
/**
 * This file is generated by o-spreadsheet build tools. Do not edit it.
 * @see https://github.com/odoo/o-spreadsheet
 * @version 17.0.84
 * @date 2026-01-14T10:04:26.188Z
 * @hash ae6422403
 */

(function (exports, owl) {
    'use strict';

    const defaultTranslate = (s) => s;
    const defaultLoaded = () => false;
    let _translate = defaultTranslate;
    let _loaded = defaultLoaded;
    function sprintf(s, ...values) {
        if (values.length === 1 && typeof values[0] === "object" && !(values[0] instanceof String)) {
            const valuesDict = values[0];
            s = s.replace(/\%\(([^\)]+)\)s/g, (match, value) => valuesDict[value]);
        }
        else if (values.length > 0) {
            s = s.replace(/\%s/g, () => values.shift());
        }
        return s;
    }
    /***
     * Allow to inject a translation function from outside o-spreadsheet. This should be called before instantiating
     * a model.
     * @param tfn the function that will do the translation
     * @param loaded a function that returns true when the translation is loaded
     */
    function setTranslationMethod(tfn, loaded = () => true) {
        _translate = tfn;
        _loaded = loaded;
    }
    /**
     * If no translation function has been set, this will mark the translation are loaded.
     *
     * By default, the translations should not be set as loaded, otherwise top-level translated constants will never be
     * translated. But if by the time the model is instantiated no custom translation function has been set, we can set
     * the default translation function as loaded so o-spreadsheet can be run in standalone with no translations.
     */
    function setDefaultTranslationMethod() {
        if (_translate === defaultTranslate && _loaded === defaultLoaded) {
            _loaded = () => true;
        }
    }
    const _t = function (s, ...values) {
        if (!_loaded()) {
            return new LazyTranslatedString(s, values);
        }
        return sprintf(_translate(s), ...values);
    };
    class LazyTranslatedString extends String {
        values;
        constructor(str, values) {
            super(str);
            this.values = values;
        }
        valueOf() {
            const str = super.valueOf();
            return _loaded() ? sprintf(_translate(str), ...this.values) : sprintf(str, ...this.values);
        }
        toString() {
            return this.valueOf();
        }
    }

    var CellErrorType;
    (function (CellErrorType) {
        CellErrorType["NotAvailable"] = "#N/A";
        CellErrorType["InvalidReference"] = "#REF";
        CellErrorType["BadExpression"] = "#BAD_EXPR";
        CellErrorType["CircularDependency"] = "#CYCLE";
        CellErrorType["UnknownFunction"] = "#NAME?";
        CellErrorType["GenericError"] = "#ERROR";
    })(CellErrorType || (CellErrorType = {}));
    var CellErrorLevel;
    (function (CellErrorLevel) {
        CellErrorLevel[CellErrorLevel["silent"] = 0] = "silent";
        CellErrorLevel[CellErrorLevel["error"] = 1] = "error";
    })(CellErrorLevel || (CellErrorLevel = {}));
    class EvaluationError extends Error {
        errorType;
        logLevel;
        constructor(errorType, message, logLevel = CellErrorLevel.error) {
            super(message);
            this.errorType = errorType;
            this.logLevel = logLevel;
        }
        get isVerbose() {
            return this.logLevel > CellErrorLevel.silent;
        }
    }
    class BadExpressionError extends EvaluationError {
        constructor(errorMessage) {
            super(CellErrorType.BadExpression, errorMessage);
        }
    }
    class CircularDependencyError extends EvaluationError {
        constructor() {
            super(CellErrorType.CircularDependency, _t("Circular reference"));
        }
    }
    class InvalidReferenceError extends EvaluationError {
        constructor() {
            super(CellErrorType.InvalidReference, _t("Invalid reference"));
        }
    }
    class NotAvailableError extends EvaluationError {
        constructor(errorMessage = undefined) {
            super(CellErrorType.NotAvailable, errorMessage || _t("Data not available"), errorMessage ? CellErrorLevel.error : CellErrorLevel.silent);
        }
    }
    class UnknownFunctionError extends EvaluationError {
        constructor(fctName) {
            super(CellErrorType.UnknownFunction, _t('Unknown function: "%s"', fctName));
        }
    }

    const CANVAS_SHIFT = 0.5;
    // Colors
    const BACKGROUND_GRAY_COLOR = "#f5f5f5";
    const BACKGROUND_HEADER_COLOR = "#F8F9FA";
    const BACKGROUND_HEADER_SELECTED_COLOR = "#E8EAED";
    const BACKGROUND_HEADER_ACTIVE_COLOR = "#595959";
    const TEXT_HEADER_COLOR = "#666666";
    const FIGURE_BORDER_COLOR = "#c9ccd2";
    const SELECTION_BORDER_COLOR = "#3266ca";
    const HEADER_BORDER_COLOR = "#C0C0C0";
    const CELL_BORDER_COLOR = "#E2E3E3";
    const BACKGROUND_CHART_COLOR = "#FFFFFF";
    const BG_HOVER_COLOR = "#EBEBEB";
    const DISABLED_TEXT_COLOR = "#CACACA";
    const DEFAULT_COLOR_SCALE_MIDPOINT_COLOR = 0xb6d7a8;
    const LINK_COLOR = "#01666b";
    const FILTERS_COLOR = "#188038";
    const BACKGROUND_HEADER_FILTER_COLOR = "#E6F4EA";
    const BACKGROUND_HEADER_SELECTED_FILTER_COLOR = "#CEEAD6";
    const SEPARATOR_COLOR = "#E0E2E4";
    const ICONS_COLOR = "#4A4F59";
    const HEADER_GROUPING_BACKGROUND_COLOR = "#F5F5F5";
    const HEADER_GROUPING_BORDER_COLOR = "#999";
    const GRID_BORDER_COLOR = "#E2E3E3";
    const FROZEN_PANE_HEADER_BORDER_COLOR = "#BCBCBC";
    const FROZEN_PANE_BORDER_COLOR = "#DADFE8";
    const COMPOSER_ASSISTANT_COLOR = "#9B359B";
    // Color picker defaults as upper case HEX to match `toHex`helper
    const COLOR_PICKER_DEFAULTS = [
        "#000000",
        "#434343",
        "#666666",
        "#999999",
        "#B7B7B7",
        "#CCCCCC",
        "#D9D9D9",
        "#EFEFEF",
        "#F3F3F3",
        "#FFFFFF",
        "#980000",
        "#FF0000",
        "#FF9900",
        "#FFFF00",
        "#00FF00",
        "#00FFFF",
        "#4A86E8",
        "#0000FF",
        "#9900FF",
        "#FF00FF",
        "#E6B8AF",
        "#F4CCCC",
        "#FCE5CD",
        "#FFF2CC",
        "#D9EAD3",
        "#D0E0E3",
        "#C9DAF8",
        "#CFE2F3",
        "#D9D2E9",
        "#EAD1DC",
        "#DD7E6B",
        "#EA9999",
        "#F9CB9C",
        "#FFE599",
        "#B6D7A8",
        "#A2C4C9",
        "#A4C2F4",
        "#9FC5E8",
        "#B4A7D6",
        "#D5A6BD",
        "#CC4125",
        "#E06666",
        "#F6B26B",
        "#FFD966",
        "#93C47D",
        "#76A5AF",
        "#6D9EEB",
        "#6FA8DC",
        "#8E7CC3",
        "#C27BA0",
        "#A61C00",
        "#CC0000",
        "#E69138",
        "#F1C232",
        "#6AA84F",
        "#45818E",
        "#3C78D8",
        "#3D85C6",
        "#674EA7",
        "#A64D79",
        "#85200C",
        "#990000",
        "#B45F06",
        "#BF9000",
        "#38761D",
        "#134F5C",
        "#1155CC",
        "#0B5394",
        "#351C75",
        "#741B47",
        "#5B0F00",
        "#660000",
        "#783F04",
        "#7F6000",
        "#274E13",
        "#0C343D",
        "#1C4587",
        "#073763",
        "#20124D",
        "#4C1130",
    ];
    // Dimensions
    const MIN_ROW_HEIGHT = 10;
    const MIN_COL_WIDTH = 5;
    const HEADER_HEIGHT = 26;
    const HEADER_WIDTH = 48;
    const TOPBAR_HEIGHT = 63;
    const TOPBAR_TOOLBAR_HEIGHT = 34;
    const BOTTOMBAR_HEIGHT = 36;
    const DEFAULT_CELL_WIDTH = 96;
    const DEFAULT_CELL_HEIGHT = 23;
    const SCROLLBAR_WIDTH = 15;
    const AUTOFILL_EDGE_LENGTH = 8;
    const ICON_EDGE_LENGTH = 18;
    const UNHIDE_ICON_EDGE_LENGTH = 14;
    const MIN_CF_ICON_MARGIN = 4;
    const MIN_CELL_TEXT_MARGIN = 4;
    const CF_ICON_EDGE_LENGTH = 15;
    const PADDING_AUTORESIZE_VERTICAL = 3;
    const PADDING_AUTORESIZE_HORIZONTAL = MIN_CELL_TEXT_MARGIN;
    const GROUP_LAYER_WIDTH = 21;
    const GRID_ICON_MARGIN = 2;
    const GRID_ICON_EDGE_LENGTH = 17;
    const FOOTER_HEIGHT = 2 * DEFAULT_CELL_HEIGHT;
    // Menus
    const MENU_WIDTH = 250;
    const MENU_VERTICAL_PADDING = 6;
    const MENU_ITEM_HEIGHT = 26;
    const MENU_ITEM_PADDING_HORIZONTAL = 11;
    const MENU_ITEM_PADDING_VERTICAL = 4;
    const MENU_SEPARATOR_BORDER_WIDTH = 1;
    const MENU_SEPARATOR_PADDING = 5;
    // Style
    const DEFAULT_STYLE = {
        align: "left",
        verticalAlign: "bottom",
        wrapping: "overflow",
        bold: false,
        italic: false,
        strikethrough: false,
        underline: false,
        fontSize: 10,
        fillColor: "",
        textColor: "",
    };
    const DEFAULT_NUMBER_STYLE = { ...DEFAULT_STYLE, align: "right" };
    const DEFAULT_VERTICAL_ALIGN = DEFAULT_STYLE.verticalAlign;
    const DEFAULT_WRAPPING_MODE = DEFAULT_STYLE.wrapping;
    // Fonts
    const DEFAULT_FONT_WEIGHT = "400";
    const DEFAULT_FONT_SIZE = DEFAULT_STYLE.fontSize;
    const HEADER_FONT_SIZE = 11;
    const DEFAULT_FONT = "'Roboto', arial";
    // Borders
    const DEFAULT_BORDER_DESC = { style: "thin", color: "#000000" };
    const DEFAULT_FILTER_BORDER_DESC = { style: "thin", color: FILTERS_COLOR };
    // Ranges
    const INCORRECT_RANGE_STRING = CellErrorType.InvalidReference;
    // Max Number of history steps kept in memory
    const MAX_HISTORY_STEPS = 99;
    // Id of the first revision
    const DEFAULT_REVISION_ID = "START_REVISION";
    // Figure
    const DEFAULT_FIGURE_HEIGHT = 335;
    const DEFAULT_FIGURE_WIDTH = 536;
    const FIGURE_BORDER_WIDTH = 1;
    const MIN_FIG_SIZE = 80;
    // Chart
    const MAX_CHAR_LABEL = 20;
    const FIGURE_ID_SPLITTER = "??";
    const DEFAULT_GAUGE_LOWER_COLOR = "#cc0000";
    const DEFAULT_GAUGE_MIDDLE_COLOR = "#f1c232";
    const DEFAULT_GAUGE_UPPER_COLOR = "#6aa84f";
    const DEFAULT_SCORECARD_BASELINE_MODE = "difference";
    const DEFAULT_SCORECARD_BASELINE_COLOR_UP = "#00A04A";
    const DEFAULT_SCORECARD_BASELINE_COLOR_DOWN = "#DC6965";
    const LINE_FILL_TRANSPARENCY = 0.4;
    // session
    const DEBOUNCE_TIME = 200;
    const MESSAGE_VERSION = 1;
    // Sheets
    const FORBIDDEN_SHEET_CHARS = ["'", "*", "?", "/", "\\", "[", "]"];
    const FORBIDDEN_IN_EXCEL_REGEX = /'|\*|\?|\/|\\|\[|\]/;
    // Cells
    const FORMULA_REF_IDENTIFIER = "|";
    const DEFAULT_ERROR_MESSAGE = _t("Invalid expression");
    // Components
    var ComponentsImportance;
    (function (ComponentsImportance) {
        ComponentsImportance[ComponentsImportance["Grid"] = 0] = "Grid";
        ComponentsImportance[ComponentsImportance["Highlight"] = 5] = "Highlight";
        ComponentsImportance[ComponentsImportance["HeaderGroupingButton"] = 6] = "HeaderGroupingButton";
        ComponentsImportance[ComponentsImportance["Figure"] = 10] = "Figure";
        ComponentsImportance[ComponentsImportance["ScrollBar"] = 15] = "ScrollBar";
        ComponentsImportance[ComponentsImportance["GridPopover"] = 19] = "GridPopover";
        ComponentsImportance[ComponentsImportance["GridComposer"] = 20] = "GridComposer";
        ComponentsImportance[ComponentsImportance["Dropdown"] = 21] = "Dropdown";
        ComponentsImportance[ComponentsImportance["IconPicker"] = 25] = "IconPicker";
        ComponentsImportance[ComponentsImportance["TopBarComposer"] = 30] = "TopBarComposer";
        ComponentsImportance[ComponentsImportance["Popover"] = 35] = "Popover";
        ComponentsImportance[ComponentsImportance["FigureAnchor"] = 1000] = "FigureAnchor";
        ComponentsImportance[ComponentsImportance["FigureSnapLine"] = 1001] = "FigureSnapLine";
    })(ComponentsImportance || (ComponentsImportance = {}));
    let DEFAULT_SHEETVIEW_SIZE = 0;
    function getDefaultSheetViewSize() {
        return DEFAULT_SHEETVIEW_SIZE;
    }
    function setDefaultSheetViewSize(size) {
        DEFAULT_SHEETVIEW_SIZE = size;
    }
    const MAXIMAL_FREEZABLE_RATIO = 0.85;
    const NEWLINE = "\n";
    const FONT_SIZES = [6, 7, 8, 9, 10, 11, 12, 14, 18, 24, 36];

    //------------------------------------------------------------------------------
    // Miscellaneous
    //------------------------------------------------------------------------------
    /**
     * Remove quotes from a quoted string
     * ```js
     * removeStringQuotes('"Hello"')
     * > 'Hello'
     * ```
     */
    function removeStringQuotes(str) {
        if (str[0] === '"') {
            str = str.slice(1);
        }
        if (str[str.length - 1] === '"' && str[str.length - 2] !== "\\") {
            return str.slice(0, str.length - 1);
        }
        return str;
    }
    function isCloneable(obj) {
        return "clone" in obj && obj.clone instanceof Function;
    }
    /**
     * Escapes a string to use as a literal string in a RegExp.
     * @url https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions#Escaping
     */
    function escapeRegExp(str) {
        return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    }
    /**
     * Deep copy arrays, plain objects and primitive values.
     * Throws an error for other types such as class instances.
     * Sparse arrays remain sparse.
     */
    function deepCopy(obj) {
        const result = Array.isArray(obj) ? [] : {};
        switch (typeof obj) {
            case "object": {
                if (obj === null) {
                    return obj;
                }
                else if (isCloneable(obj)) {
                    return obj.clone();
                }
                else if (!(isPlainObject(obj) || obj instanceof Array)) {
                    throw new Error("Unsupported type: only objects and arrays are supported");
                }
                for (const key in obj) {
                    result[key] = deepCopy(obj[key]);
                }
                return result;
            }
            case "number":
            case "string":
            case "boolean":
            case "function":
            case "undefined":
                return obj;
            default:
                throw new Error(`Unsupported type: ${typeof obj}`);
        }
    }
    /**
     * Check if the object is a plain old javascript object.
     */
    function isPlainObject(obj) {
        return (typeof obj === "object" &&
            obj !== null &&
            // obj.constructor can be undefined when there's no prototype (`Object.create(null, {})`)
            (obj?.constructor === Object || obj?.constructor === undefined));
    }
    /**
     * Sanitize the name of a sheet, by eventually removing quotes
     * @param sheetName name of the sheet, potentially quoted with single quotes
     */
    function getUnquotedSheetName(sheetName) {
        if (sheetName.startsWith("'")) {
            sheetName = sheetName.slice(1, -1).replace(/''/g, "'");
        }
        return sheetName;
    }
    /**
     * Add quotes around the sheet name if it contains at least one non alphanumeric character
     * '\w' captures [0-9][a-z][A-Z] and _.
     * @param sheetName Name of the sheet
     */
    function getCanonicalSheetName(sheetName) {
        if (sheetName.match(/\w/g)?.length !== sheetName.length) {
            sheetName = `'${sheetName}'`;
        }
        return sheetName;
    }
    function clip(val, min, max) {
        return val < min ? min : val > max ? max : val;
    }
    /**
     * Create a range from start (included) to end (excluded).
     * range(10, 13) => [10, 11, 12]
     * range(2, 8, 2) => [2, 4, 6]
     */
    function range(start, end, step = 1) {
        if (end <= start && step > 0) {
            return [];
        }
        if (step === 0) {
            throw new Error("range() step must not be zero");
        }
        const length = Math.ceil(Math.abs((end - start) / step));
        const array = Array(length);
        for (let i = 0; i < length; i++) {
            array[i] = start + i * step;
        }
        return array;
    }
    /**
     * Groups consecutive numbers.
     * The input array is assumed to be sorted
     * @param numbers
     */
    function groupConsecutive(numbers) {
        return numbers.reduce((groups, currentRow, index, rows) => {
            if (Math.abs(currentRow - rows[index - 1]) === 1) {
                const lastGroup = groups[groups.length - 1];
                lastGroup.push(currentRow);
            }
            else {
                groups.push([currentRow]);
            }
            return groups;
        }, []);
    }
    /**
     * Create one generator from two generators by linking
     * each item of the first generator to the next item of
     * the second generator.
     *
     * Let's say generator G1 yields A, B, C and generator G2 yields X, Y, Z.
     * The resulting generator of `linkNext(G1, G2)` will yield A', B', C'
     * where `A' = A & {next: Y}`, `B' = B & {next: Z}` and `C' = C & {next: undefined}`
     * @param generator
     * @param nextGenerator
     */
    function* linkNext(generator, nextGenerator) {
        nextGenerator.next();
        for (const item of generator) {
            const nextItem = nextGenerator.next();
            yield {
                ...item,
                next: nextItem.done ? undefined : nextItem.value,
            };
        }
    }
    function isBoolean(str) {
        const upperCased = str.toUpperCase();
        return upperCased === "TRUE" || upperCased === "FALSE";
    }
    const MARKDOWN_LINK_REGEX = /^\[(.+)\]\((.+)\)$/;
    //link must start with http or https
    //https://stackoverflow.com/a/3809435/4760614
    const WEB_LINK_REGEX = /^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,4}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)$/;
    function isMarkdownLink(str) {
        return MARKDOWN_LINK_REGEX.test(str);
    }
    /**
     * Check if the string is a web link.
     * e.g. http://odoo.com
     */
    function isWebLink(str) {
        return WEB_LINK_REGEX.test(str);
    }
    /**
     * Build a markdown link from a label and an url
     */
    function markdownLink(label, url) {
        return `[${label}](${url})`;
    }
    function parseMarkdownLink(str) {
        const matches = str.match(MARKDOWN_LINK_REGEX) || [];
        const label = matches[1];
        const url = matches[2];
        if (!label || !url) {
            throw new Error(`Could not parse markdown link ${str}.`);
        }
        return {
            label,
            url,
        };
    }
    const O_SPREADSHEET_LINK_PREFIX = "o-spreadsheet://";
    function isSheetUrl(url) {
        return url.startsWith(O_SPREADSHEET_LINK_PREFIX);
    }
    function buildSheetLink(sheetId) {
        return `${O_SPREADSHEET_LINK_PREFIX}${sheetId}`;
    }
    /**
     * Parse a sheet link and return the sheet id
     */
    function parseSheetUrl(sheetLink) {
        if (sheetLink.startsWith(O_SPREADSHEET_LINK_PREFIX)) {
            return sheetLink.substr(O_SPREADSHEET_LINK_PREFIX.length);
        }
        throw new Error(`${sheetLink} is not a valid sheet link`);
    }
    /**
     * This helper function can be used as a type guard when filtering arrays.
     * const foo: number[] = [1, 2, undefined, 4].filter(isDefined)
     */
    function isDefined$1(argument) {
        return argument !== undefined;
    }
    function isNotNull(argument) {
        return argument !== null;
    }
    /**
     * Check if all the values of an object, and all the values of the objects inside of it, are undefined.
     */
    function isObjectEmptyRecursive(argument) {
        if (argument === undefined)
            return true;
        return Object.values(argument).every((value) => typeof value === "object" ? isObjectEmptyRecursive(value) : !value);
    }
    /**
     * Get the id of the given item (its key in the given dictionnary).
     * If the given item does not exist in the dictionary, it creates one with a new id.
     */
    function getItemId(item, itemsDic) {
        for (const key in itemsDic) {
            if (deepEquals(itemsDic[key], item)) {
                return parseInt(key, 10);
            }
        }
        // Generate new Id if the item didn't exist in the dictionary
        const ids = Object.keys(itemsDic);
        const maxId = ids.length === 0 ? 0 : largeMax(ids.map((id) => parseInt(id, 10)));
        itemsDic[maxId + 1] = item;
        return maxId + 1;
    }
    /**
     * This method comes from owl 1 as it was removed in owl 2
     *
     * Returns a function, that, as long as it continues to be invoked, will not
     * be triggered. The function will be called after it stops being called for
     * N milliseconds. If `immediate` is passed, trigger the function on the
     * leading edge, instead of the trailing.
     *
     * Inspired by https://davidwalsh.name/javascript-debounce-function
     */
    function debounce(func, wait, immediate) {
        let timeout;
        return function () {
            const context = this;
            const args = Array.from(arguments);
            function later() {
                timeout = null;
                if (!immediate) {
                    func.apply(context, args);
                }
            }
            const callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) {
                func.apply(context, args);
            }
        };
    }
    /*
     * Concatenate an array of strings.
     */
    function concat(chars) {
        // ~40% faster than chars.join("")
        let output = "";
        for (let i = 0, len = chars.length; i < len; i++) {
            output += chars[i];
        }
        return output;
    }
    /**
     * Lazy value computed by the provided function.
     */
    function lazy(fn) {
        let isMemoized = false;
        let memo;
        const lazyValue = () => {
            if (!isMemoized) {
                memo = fn instanceof Function ? fn() : fn;
                isMemoized = true;
            }
            return memo;
        };
        lazyValue.map = (callback) => lazy(() => callback(lazyValue()));
        return lazyValue;
    }
    /**
     * Find the next defined value after the given index in an array of strings. If there is no defined value
     * after the index, return the closest defined value before the index. Return an empty string if no
     * defined value was found.
     *
     */
    function findNextDefinedValue(arr, index) {
        let value = arr.slice(index).find((val) => val);
        if (!value) {
            value = arr
                .slice(0, index)
                .reverse()
                .find((val) => val);
        }
        return value || "";
    }
    /** Get index of first header added by an ADD_COLUMNS_ROWS command */
    function getAddHeaderStartIndex(position, base) {
        return position === "after" ? base + 1 : base;
    }
    /**
     * Compares two objects.
     */
    function deepEquals(o1, o2) {
        if (o1 === o2)
            return true;
        if ((o1 && !o2) || (o2 && !o1))
            return false;
        if (typeof o1 !== typeof o2)
            return false;
        if (typeof o1 !== "object")
            return false;
        // Objects can have different keys if the values are undefined
        for (const key in o2) {
            if (!(key in o1) && o2[key] !== undefined) {
                return false;
            }
        }
        for (const key in o1) {
            if (typeof o1[key] !== typeof o2[key])
                return false;
            if (typeof o1[key] === "object") {
                if (!deepEquals(o1[key], o2[key]))
                    return false;
            }
            else {
                if (o1[key] !== o2[key])
                    return false;
            }
        }
        return true;
    }
    /**
     * Check if the given array contains all the values of the other array.
     * It makes the assumption that both array do not contain duplicates.
     */
    function includesAll(arr, values) {
        if (arr.length < values.length) {
            return false;
        }
        const set = new Set(arr);
        return values.every((value) => set.has(value));
    }
    /**
     * Return an object with all the keys in the object that have a falsy value removed.
     */
    function removeFalsyAttributes(obj) {
        const cleanObject = { ...obj };
        Object.keys(cleanObject).forEach((key) => !cleanObject[key] && delete cleanObject[key]);
        return cleanObject;
    }
    /**
     * Equivalent to "\s" in regexp, minus the new lines characters
     *
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions/Character_Classes
     */
    const specialWhiteSpaceSpecialCharacters = [
        "\t",
        "\f",
        "\v",
        String.fromCharCode(parseInt("00a0", 16)),
        String.fromCharCode(parseInt("1680", 16)),
        String.fromCharCode(parseInt("2000", 16)),
        String.fromCharCode(parseInt("200a", 16)),
        String.fromCharCode(parseInt("2028", 16)),
        String.fromCharCode(parseInt("2029", 16)),
        String.fromCharCode(parseInt("202f", 16)),
        String.fromCharCode(parseInt("205f", 16)),
        String.fromCharCode(parseInt("3000", 16)),
        String.fromCharCode(parseInt("feff", 16)),
    ];
    const specialWhiteSpaceRegexp = new RegExp(specialWhiteSpaceSpecialCharacters.join("|"), "g");
    const newLineRegexp = /(\r\n|\r)/g;
    /**
     * Replace all different newlines characters by \n
     */
    function replaceNewLines(text) {
        if (!text)
            return "";
        return text.replace(newLineRegexp, NEWLINE);
    }
    /**
     * Determine if the numbers are consecutive.
     */
    function isConsecutive(iterable) {
        const array = Array.from(iterable).sort((a, b) => a - b); // sort numerically rather than lexicographically
        for (let i = 1; i < array.length; i++) {
            if (array[i] - array[i - 1] !== 1) {
                return false;
            }
        }
        return true;
    }
    class JetSet extends Set {
        addMany(iterable) {
            for (const element of iterable) {
                super.add(element);
            }
            return this;
        }
        deleteMany(iterable) {
            for (const element of iterable) {
                super.delete(element);
            }
        }
    }
    /**
     * Creates a version of the function that's memoized on the value of its first
     * argument, if any.
     */
    function memoize(func) {
        const cache = new Map();
        const funcName = func.name ? func.name + " (memoized)" : "memoized";
        return {
            [funcName](...args) {
                if (!cache.has(args[0])) {
                    cache.set(args[0], func(...args));
                }
                return cache.get(args[0]);
            },
        }[funcName];
    }
    /**
     * Removes the specified indexes from the array.
     * Sparse (empty) elements are transformed to undefined (unless their index is explicitly removed).
     */
    function removeIndexesFromArray(array, indexes) {
        const toRemove = new Set(indexes);
        const newArray = [];
        for (let i = 0; i < array.length; i++) {
            if (!toRemove.has(i)) {
                newArray.push(array[i]);
            }
        }
        return newArray;
    }
    function insertItemsAtIndex(array, items, index) {
        return array.slice(0, index).concat(items).concat(array.slice(index));
    }
    function trimContent(content) {
        const contentLines = content.split("\n");
        return contentLines.map((line) => line.replace(/\s+/g, " ").trim()).join("\n");
    }
    function isNumberBetween(value, min, max) {
        if (min > max) {
            return isNumberBetween(value, max, min);
        }
        return value >= min && value <= max;
    }
    /**
     * Alternative to Math.max that works with large arrays.
     * Typically useful for arrays bigger than 100k elements.
     */
    function largeMax(array) {
        let len = array.length;
        if (len < 100_000)
            return Math.max(...array);
        let max = -Infinity;
        while (len--) {
            max = array[len] > max ? array[len] : max;
        }
        return max;
    }
    /**
     * Alternative to Math.min that works with large arrays.
     * Typically useful for arrays bigger than 100k elements.
     */
    function largeMin(array) {
        let len = array.length;
        if (len < 100_000)
            return Math.min(...array);
        let min = +Infinity;
        while (len--) {
            min = array[len] < min ? array[len] : min;
        }
        return min;
    }

    const RBA_REGEX = /rgba?\(|\s+|\)/gi;
    const HEX_MATCH = /^#([A-F\d]{2}){3,4}$/;
    const colors$1 = [
        "#eb6d00",
        "#0074d9",
        "#ad8e00",
        "#169ed4",
        "#b10dc9",
        "#00a82d",
        "#00a3a3",
        "#f012be",
        "#3d9970",
        "#111111",
        "#62A300",
        "#ff4136",
        "#949494",
        "#85144b",
        "#001f3f",
    ];
    /*
     * transform a color number (R * 256^2 + G * 256 + B) into classic hex6 value
     * */
    function colorNumberString(color) {
        return toHex(color.toString(16).padStart(6, "0"));
    }
    /**
     * Converts any CSS color value to a standardized hex6 value.
     * Accepts: hex3, hex6, hex8, rgb[1] and rgba[1].
     *
     * [1] under the form rgb(r, g, b, a?) or rgba(r, g, b, a?)
     * with r,g,b ∈ [0, 255] and a ∈ [0, 1]
     *
     * toHex("#ABC")
     * >> "#AABBCC"
     *
     * toHex("#AAAFFF")
     * >> "#AAAFFF"
     *
     * toHex("rgb(30, 80, 16)")
     * >> "#1E5010"
     *
     *  * toHex("rgb(30, 80, 16, 0.5)")
     * >> "#1E501080"
     *
     */
    function toHex(color) {
        let hexColor = color;
        if (color.startsWith("rgb")) {
            hexColor = rgbaStringToHex(color);
        }
        else {
            hexColor = color.replace("#", "").toUpperCase();
            if (hexColor.length === 3 || hexColor.length === 4) {
                hexColor = hexColor.split("").reduce((acc, h) => acc + h + h, "");
            }
            hexColor = `#${hexColor}`;
        }
        if (!HEX_MATCH.test(hexColor)) {
            throw new Error(`invalid color input: ${color}`);
        }
        return hexColor;
    }
    function isColorValid(color) {
        try {
            toHex(color);
            return true;
        }
        catch (error) {
            return false;
        }
    }
    function isHSLAValid(color) {
        try {
            hslaToHex(color);
            return true;
        }
        catch (error) {
            return false;
        }
    }
    const isColorValueValid = (v) => v >= 0 && v <= 255;
    function rgba(r, g, b, a = 1) {
        const isInvalid = !isColorValueValid(r) || !isColorValueValid(g) || !isColorValueValid(b) || a < 0 || a > 1;
        if (isInvalid) {
            throw new Error(`Invalid RGBA values ${[r, g, b, a]}`);
        }
        return { a, b, g, r };
    }
    /**
     * The relative brightness of a point in the colorspace, normalized to 0 for
     * darkest black and 1 for lightest white.
     * https://www.w3.org/TR/WCAG20/#relativeluminancedef
     */
    function relativeLuminance(color) {
        let { r, g, b } = colorToRGBA(color);
        r /= 255;
        g /= 255;
        b /= 255;
        const toLinearValue = (c) => (c <= 0.03928 ? c / 12.92 : ((c + 0.055) / 1.055) ** 2.4);
        const R = toLinearValue(r);
        const G = toLinearValue(g);
        const B = toLinearValue(b);
        return 0.2126 * R + 0.7152 * G + 0.0722 * B;
    }
    /**
     * Convert a CSS rgb color string to a standardized hex6 color value.
     *
     * rgbaStringToHex("rgb(30, 80, 16)")
     * >> "#1E5010"
     *
     * rgbaStringToHex("rgba(30, 80, 16, 0.5)")
     * >> "#1E501080"
     *
     * DOES NOT SUPPORT NON INTEGER RGB VALUES
     */
    function rgbaStringToHex(color) {
        const stringVals = color.replace(RBA_REGEX, "").split(",");
        let alphaHex = 255;
        if (stringVals.length !== 3 && stringVals.length !== 4) {
            throw new Error("invalid color");
        }
        else if (stringVals.length === 4) {
            const alpha = parseFloat(stringVals.pop() || "1");
            if (isNaN(alpha)) {
                throw new Error("invalid alpha value");
            }
            alphaHex = Math.round(alpha * 255);
        }
        const vals = stringVals.map((val) => parseInt(val, 10));
        if (alphaHex !== 255) {
            vals.push(alphaHex);
        }
        return "#" + concat(vals.map((value) => value.toString(16).padStart(2, "0"))).toUpperCase();
    }
    /**
     * RGBA to HEX representation (#RRGGBBAA).
     *
     * https://css-tricks.com/converting-color-spaces-in-javascript/
     */
    function rgbaToHex(rgba) {
        let r = rgba.r.toString(16);
        let g = rgba.g.toString(16);
        let b = rgba.b.toString(16);
        let a = Math.round(rgba.a * 255).toString(16);
        if (r.length === 1)
            r = "0" + r;
        if (g.length === 1)
            g = "0" + g;
        if (b.length === 1)
            b = "0" + b;
        if (a.length === 1)
            a = "0" + a;
        if (a === "ff")
            a = "";
        return ("#" + r + g + b + a).toUpperCase();
    }
    /**
     * Color string to RGBA representation
     */
    function colorToRGBA(color) {
        color = toHex(color);
        let r;
        let g;
        let b;
        let a;
        if (color.length === 7) {
            r = parseInt(color[1] + color[2], 16);
            g = parseInt(color[3] + color[4], 16);
            b = parseInt(color[5] + color[6], 16);
            a = 255;
        }
        else if (color.length === 9) {
            r = parseInt(color[1] + color[2], 16);
            g = parseInt(color[3] + color[4], 16);
            b = parseInt(color[5] + color[6], 16);
            a = parseInt(color[7] + color[8], 16);
        }
        else {
            throw new Error("Invalid color");
        }
        a = +(a / 255).toFixed(3);
        return { a, r, g, b };
    }
    /**
     * HSLA to RGBA.
     *
     * https://css-tricks.com/converting-color-spaces-in-javascript/
     */
    function hslaToRGBA(hsla) {
        hsla = { ...hsla };
        // Must be fractions of 1
        hsla.s /= 100;
        hsla.l /= 100;
        let c = (1 - Math.abs(2 * hsla.l - 1)) * hsla.s;
        let x = c * (1 - Math.abs(((hsla.h / 60) % 2) - 1));
        let m = hsla.l - c / 2;
        let r = 0;
        let g = 0;
        let b = 0;
        if (0 <= hsla.h && hsla.h < 60) {
            r = c;
            g = x;
            b = 0;
        }
        else if (60 <= hsla.h && hsla.h < 120) {
            r = x;
            g = c;
            b = 0;
        }
        else if (120 <= hsla.h && hsla.h < 180) {
            r = 0;
            g = c;
            b = x;
        }
        else if (180 <= hsla.h && hsla.h < 240) {
            r = 0;
            g = x;
            b = c;
        }
        else if (240 <= hsla.h && hsla.h < 300) {
            r = x;
            g = 0;
            b = c;
        }
        else if (300 <= hsla.h && hsla.h < 360) {
            r = c;
            g = 0;
            b = x;
        }
        r = Math.round((r + m) * 255);
        g = Math.round((g + m) * 255);
        b = Math.round((b + m) * 255);
        return { a: hsla.a, r, g, b };
    }
    /**
     * HSLA to RGBA.
     *
     * https://css-tricks.com/converting-color-spaces-in-javascript/
     */
    function rgbaToHSLA(rgba) {
        // Make r, g, and b fractions of 1
        const r = rgba.r / 255;
        const g = rgba.g / 255;
        const b = rgba.b / 255;
        // Find greatest and smallest channel values
        let cMin = Math.min(r, g, b);
        let cMax = Math.max(r, g, b);
        let delta = cMax - cMin;
        let h = 0;
        let s = 0;
        let l = 0;
        // Calculate hue
        // No difference
        if (delta === 0)
            h = 0;
        // Red is max
        else if (cMax === r)
            h = ((g - b) / delta) % 6;
        // Green is max
        else if (cMax === g)
            h = (b - r) / delta + 2;
        // Blue is max
        else
            h = (r - g) / delta + 4;
        h = Math.round(h * 60);
        // Make negative hues positive behind 360°
        if (h < 0)
            h += 360;
        l = (cMax + cMin) / 2;
        // Calculate saturation
        s = delta === 0 ? 0 : delta / (1 - Math.abs(2 * l - 1));
        // Multiply l and s by 100
        s = +(s * 100).toFixed(1);
        l = +(l * 100).toFixed(1);
        return { a: rgba.a, h, s, l };
    }
    function hslaToHex(hsla) {
        return rgbaToHex(hslaToRGBA(hsla));
    }
    function hexToHSLA(hex) {
        return rgbaToHSLA(colorToRGBA(hex));
    }
    /**
     * Will compare two color strings
     * A tolerance can be provided to account for small differences that could
     * be introduced by non-bijective transformations between color spaces.
     *
     * E.g. HSV <-> RGB is not a bijection
     *
     * Note that the tolerance is applied on the euclidean distance between
     * the two **normalized** color values.
     */
    function isSameColor(color1, color2, tolerance = 0) {
        if (!(isColorValid(color1) && isColorValid(color2))) {
            return false;
        }
        const rgb1 = colorToRGBA(color1);
        const rgb2 = colorToRGBA(color2);
        // alpha cannot differ as it is not impacted by transformations
        if (rgb1.a !== rgb2.a) {
            return false;
        }
        const diff = Math.sqrt(((rgb1.r - rgb2.r) / 255) ** 2 + ((rgb1.g - rgb2.g) / 255) ** 2 + ((rgb1.b - rgb2.b) / 255) ** 2);
        return diff <= tolerance;
    }

    //------------------------------------------------------------------------------
    // Coordinate
    //------------------------------------------------------------------------------
    /**
     * Convert a (col) number to the corresponding letter.
     *
     * Examples:
     *     0 => 'A'
     *     25 => 'Z'
     *     26 => 'AA'
     *     27 => 'AB'
     */
    function numberToLetters(n) {
        if (n < 0) {
            throw new Error(`number must be positive. Got ${n}`);
        }
        if (n < 26) {
            return String.fromCharCode(65 + n);
        }
        else {
            return numberToLetters(Math.floor(n / 26) - 1) + numberToLetters(n % 26);
        }
    }
    const LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const LETTERS_NUMBER_MAPPING = {};
    for (const letter of LETTERS) {
        const colIndex = letter.charCodeAt(0) - 64;
        LETTERS_NUMBER_MAPPING[letter] = colIndex;
        LETTERS_NUMBER_MAPPING[letter.toLowerCase()] = colIndex;
    }
    /**
     * Convert a string (describing a column) to its number value.
     *
     * Examples:
     *     'A' => 0
     *     'Z' => 25
     *     'AA' => 26
     */
    function lettersToNumber(letters) {
        let result = -1;
        const l = letters.length;
        let pow = 1;
        for (let i = l - 1; i >= 0; i--) {
            const charCode = LETTERS_NUMBER_MAPPING[letters[i]];
            result += charCode * pow;
            pow *= 26;
        }
        return result;
    }
    function isCharALetter(char) {
        return (char >= "A" && char <= "Z") || (char >= "a" && char <= "z");
    }
    function isCharADigit(char) {
        return char >= "0" && char <= "9";
    }
    /**
     * Convert a "XC" coordinate to cartesian coordinates.
     *
     * Examples:
     *   A1 => [0,0]
     *   B3 => [1,2]
     *
     * Note: it also accepts lowercase coordinates, but not fixed references
     */
    function toCartesian(xc) {
        xc = xc.trim();
        let numberPartStart = undefined;
        // Note: looping by hand is uglier but ~2x faster than using a regex to match number/letter parts
        for (let i = 0; i < xc.length; i++) {
            const char = xc[i];
            // as long as we haven't found the number part, keep advancing
            if (!numberPartStart) {
                if ((char === "$" && i === 0) || isCharALetter(char)) {
                    continue;
                }
                numberPartStart = i;
            }
            // Number part
            if (!isCharADigit(char)) {
                if (char === "$" && i === numberPartStart) {
                    continue;
                }
                throw new Error(`Invalid cell description: ${xc}`);
            }
        }
        if (!numberPartStart || numberPartStart === xc.length) {
            throw new Error(`Invalid cell description: ${xc}`);
        }
        const letterPart = xc[0] === "$" ? xc.slice(1, numberPartStart) : xc.slice(0, numberPartStart);
        const numberPart = xc[numberPartStart] === "$" ? xc.slice(numberPartStart + 1) : xc.slice(numberPartStart);
        // limit to max 3 letters and 7 numbers to avoid
        // gigantic numbers that would be a performance killer
        // down the road
        if (letterPart.length < 1 ||
            letterPart.length > 3 ||
            numberPart.length < 1 ||
            numberPart.length > 7) {
            throw new Error(`Invalid cell description: ${xc}`);
        }
        const col = lettersToNumber(letterPart);
        const row = Number(numberPart) - 1;
        if (isNaN(row)) {
            throw new Error(`Invalid cell description: ${xc}`);
        }
        return { col, row };
    }
    /**
     * Convert from cartesian coordinate to the "XC" coordinate system.
     *
     * Examples:
     *   - 0,0 => A1
     *   - 1,2 => B3
     *   - 0,0, {colFixed: false, rowFixed: true} => A$1
     *   - 1,2, {colFixed: true, rowFixed: false} => $B3
     */
    function toXC(col, row, rangePart = { colFixed: false, rowFixed: false }) {
        return ((rangePart.colFixed ? "$" : "") +
            numberToLetters(col) +
            (rangePart.rowFixed ? "$" : "") +
            String(row + 1));
    }

    // -----------------------------------------------------------------------------
    // Date Type
    // -----------------------------------------------------------------------------
    /**
     * A DateTime object that can be used to manipulate spreadsheet dates.
     * Conceptually, a spreadsheet date is simply a number with a date format,
     * and it is timezone-agnostic.
     * This DateTime object consistently uses UTC time to represent a naive date and time.
     */
    class DateTime {
        jsDate;
        constructor(year, month, day, hours = 0, minutes = 0, seconds = 0) {
            this.jsDate = new Date(Date.UTC(year, month, day, hours, minutes, seconds, 0));
        }
        static fromTimestamp(timestamp) {
            const date = new Date(timestamp);
            return new DateTime(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds());
        }
        static now() {
            const now = new Date();
            return new DateTime(now.getFullYear(), now.getMonth(), now.getDate(), now.getHours(), now.getMinutes(), now.getSeconds());
        }
        toString() {
            return this.jsDate.toString();
        }
        toLocaleDateString() {
            return this.jsDate.toLocaleDateString();
        }
        getTime() {
            return this.jsDate.getTime();
        }
        getFullYear() {
            return this.jsDate.getUTCFullYear();
        }
        getMonth() {
            return this.jsDate.getUTCMonth();
        }
        getDate() {
            return this.jsDate.getUTCDate();
        }
        getDay() {
            return this.jsDate.getUTCDay();
        }
        getHours() {
            return this.jsDate.getUTCHours();
        }
        getMinutes() {
            return this.jsDate.getUTCMinutes();
        }
        getSeconds() {
            return this.jsDate.getUTCSeconds();
        }
        setFullYear(year) {
            return this.jsDate.setUTCFullYear(year);
        }
        setMonth(month) {
            return this.jsDate.setUTCMonth(month);
        }
        setDate(date) {
            return this.jsDate.setUTCDate(date);
        }
        setHours(hours) {
            return this.jsDate.setUTCHours(hours);
        }
        setMinutes(minutes) {
            return this.jsDate.setUTCMinutes(minutes);
        }
        setSeconds(seconds) {
            return this.jsDate.setUTCSeconds(seconds);
        }
    }
    // -----------------------------------------------------------------------------
    // Parsing
    // -----------------------------------------------------------------------------
    const INITIAL_1900_DAY = new DateTime(1899, 11, 30);
    const MS_PER_DAY = 24 * 60 * 60 * 1000;
    const CURRENT_MILLENIAL = 2000; // note: don't forget to update this in 2999
    const CURRENT_YEAR = DateTime.now().getFullYear();
    const CURRENT_MONTH = DateTime.now().getMonth();
    const INITIAL_JS_DAY = DateTime.fromTimestamp(0);
    const DATE_JS_1900_OFFSET = INITIAL_JS_DAY.getTime() - INITIAL_1900_DAY.getTime();
    const mdyDateRegexp = /^\d{1,2}(\/|-|\s)\d{1,2}((\/|-|\s)\d{1,4})?$/;
    const ymdDateRegexp = /^\d{3,4}(\/|-|\s)\d{1,2}(\/|-|\s)\d{1,2}$/;
    const dateSeparatorsRegex = /\/|-|\s/;
    const dateRegexp = /^(\d{1,4})[\/-\s](\d{1,4})([\/-\s](\d{1,4}))?$/;
    const timeRegexp = /((\d+(:\d+)?(:\d+)?\s*(AM|PM))|(\d+:\d+(:\d+)?))$/;
    /** Convert a value number representing a date, or return undefined if it isn't possible */
    function valueToDateNumber(value, locale) {
        switch (typeof value) {
            case "number":
                return value;
            case "string":
                if (isDateTime(value, locale)) {
                    return parseDateTime(value, locale)?.value;
                }
                return !value || isNaN(Number(value)) ? undefined : Number(value);
            default:
                return undefined;
        }
    }
    function isDateTime(str, locale) {
        return parseDateTime(str, locale) !== null;
    }
    const CACHE = new Map();
    function parseDateTime(str, locale) {
        if (!CACHE.has(locale)) {
            CACHE.set(locale, new Map());
        }
        if (!CACHE.get(locale).has(str)) {
            CACHE.get(locale).set(str, _parseDateTime(str, locale));
        }
        return CACHE.get(locale).get(str);
    }
    function _parseDateTime(str, locale) {
        str = str.trim();
        let time = null;
        const timeMatch = str.match(timeRegexp);
        if (timeMatch) {
            time = parseTime(timeMatch[0]);
            if (time === null) {
                return null;
            }
            str = str.replace(timeMatch[0], "").trim();
        }
        let date = null;
        const dateParts = getDateParts(str, locale);
        if (dateParts) {
            const separator = dateParts.dateString.match(dateSeparatorsRegex)[0];
            date = parseDate(dateParts, separator);
            if (date === null) {
                return null;
            }
            str = str.replace(dateParts.dateString, "").trim();
        }
        if (str !== "" || !(date || time)) {
            return null;
        }
        if (date && date.jsDate && time && time.jsDate) {
            return {
                value: date.value + time.value,
                format: date.format + " " + (time.format === "hhhh:mm:ss" ? "hh:mm:ss" : time.format),
                jsDate: new DateTime(date.jsDate.getFullYear() + time.jsDate.getFullYear() - 1899, date.jsDate.getMonth() + time.jsDate.getMonth() - 11, date.jsDate.getDate() + time.jsDate.getDate() - 30, date.jsDate.getHours() + time.jsDate.getHours(), date.jsDate.getMinutes() + time.jsDate.getMinutes(), date.jsDate.getSeconds() + time.jsDate.getSeconds()),
            };
        }
        return date || time;
    }
    /**
     * Returns the parts (day/month/year) of a date string corresponding to the given locale.
     *
     * - A string "xxxx-xx-xx" will be parsed as "y-m-d" no matter the locale.
     * - A string "xx-xx-xxxx" will be parsed as "m-d-y" for mdy locale, and "d-m-y" for ymd and dmy locales.
     * - A string "xx-xx-xx" will be "y-m-d" for ymd locale, "d-m-y" for dmy locale, "m-d-y" for mdy locale.
     * - A string "xxxx-xx" will be parsed as "y-m" no matter the locale.
     * - A string "xx-xx" will be parsed as "m-d" for mdy and ymd locales, and "d-m" for dmy locale.
     */
    function getDateParts(dateString, locale) {
        const match = dateString.match(dateRegexp);
        if (!match) {
            return null;
        }
        const [, part1, part2, , part3] = match;
        if (part1.length > 2 && part3 && part3.length > 2) {
            return null;
        }
        if (part1.length > 2) {
            return { year: part1, month: part2, day: part3, dateString, type: "ymd" };
        }
        const localeDateType = getLocaleDateFormatType(locale);
        if (!part3) {
            if (part2.length > 2) {
                // e.g. 11/2023
                return { month: part1, year: part2, day: undefined, dateString, type: localeDateType };
            }
            if (localeDateType === "dmy") {
                return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
            }
            return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
        }
        if (part3.length > 2) {
            if (localeDateType === "mdy") {
                return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
            }
            return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
        }
        if (localeDateType === "mdy") {
            return { month: part1, day: part2, year: part3, dateString, type: "mdy" };
        }
        if (localeDateType === "ymd") {
            return { year: part1, month: part2, day: part3, dateString, type: "ymd" };
        }
        if (localeDateType === "dmy") {
            return { day: part1, month: part2, year: part3, dateString, type: "dmy" };
        }
        return null;
    }
    function getLocaleDateFormatType(locale) {
        switch (locale.dateFormat[0]) {
            case "d":
                return "dmy";
            case "m":
                return "mdy";
            case "y":
                return "ymd";
        }
        throw new Error("Invalid date format in locale");
    }
    function parseDate(parts, separator) {
        let { year: yearStr, month: monthStr, day: dayStr } = parts;
        const month = inferMonth(monthStr);
        const day = inferDay(dayStr);
        const year = inferYear(yearStr);
        if (year === null || month === null || day === null) {
            return null;
        }
        // month + 1: months are 0-indexed in JS
        const leadingZero = (monthStr?.length === 2 && month + 1 < 10) || (dayStr?.length === 2 && day < 10);
        const fullYear = yearStr?.length !== 2;
        const jsDate = new DateTime(year, month, day);
        if (jsDate.getMonth() !== month || jsDate.getDate() !== day) {
            // invalid date
            return null;
        }
        const delta = jsDate.getTime() - INITIAL_1900_DAY.getTime();
        const format = getFormatFromDateParts(parts, separator, leadingZero, fullYear);
        return {
            value: Math.round(delta / MS_PER_DAY),
            format: format,
            jsDate,
        };
    }
    function getFormatFromDateParts(parts, sep, leadingZero, fullYear) {
        const yearFmt = parts.year ? (fullYear ? "yyyy" : "yy") : undefined;
        const monthFmt = parts.month ? (leadingZero ? "mm" : "m") : undefined;
        const dayFmt = parts.day ? (leadingZero ? "dd" : "d") : undefined;
        switch (parts.type) {
            case "mdy":
                return [monthFmt, dayFmt, yearFmt].filter(isDefined$1).join(sep);
            case "ymd":
                return [yearFmt, monthFmt, dayFmt].filter(isDefined$1).join(sep);
            case "dmy":
                return [dayFmt, monthFmt, yearFmt].filter(isDefined$1).join(sep);
        }
    }
    function inferYear(yearStr) {
        if (!yearStr) {
            return CURRENT_YEAR;
        }
        const nbr = Number(yearStr);
        switch (yearStr.length) {
            case 1:
                return CURRENT_MILLENIAL + nbr;
            case 2:
                const offset = CURRENT_MILLENIAL + nbr > CURRENT_YEAR + 10 ? -100 : 0;
                const base = CURRENT_MILLENIAL + offset;
                return base + nbr;
            case 3:
            case 4:
                return nbr;
        }
        return null;
    }
    function inferMonth(monthStr) {
        if (!monthStr) {
            return CURRENT_MONTH;
        }
        const nbr = Number(monthStr);
        if (nbr >= 1 && nbr <= 12) {
            return nbr - 1;
        }
        return null;
    }
    function inferDay(dayStr) {
        if (!dayStr) {
            return 1;
        }
        const nbr = Number(dayStr);
        if (nbr >= 0 && nbr <= 31) {
            return nbr;
        }
        return null;
    }
    function parseTime(str) {
        str = str.trim();
        if (timeRegexp.test(str)) {
            const isAM = /AM/i.test(str);
            const isPM = /PM/i.test(str);
            const strTime = isAM || isPM ? str.substring(0, str.length - 2).trim() : str;
            const parts = strTime.split(/:/);
            const isMinutes = parts.length >= 2;
            const isSeconds = parts.length === 3;
            let hours = Number(parts[0]);
            let minutes = isMinutes ? Number(parts[1]) : 0;
            let seconds = isSeconds ? Number(parts[2]) : 0;
            let format = isSeconds ? "hh:mm:ss" : "hh:mm";
            if (isAM || isPM) {
                format += " a";
            }
            else if (!isMinutes) {
                return null;
            }
            if (hours >= 12 && isAM) {
                hours -= 12;
            }
            else if (hours < 12 && isPM) {
                hours += 12;
            }
            minutes += Math.floor(seconds / 60);
            seconds %= 60;
            hours += Math.floor(minutes / 60);
            minutes %= 60;
            if (hours >= 24) {
                format = "hhhh:mm:ss";
            }
            const jsDate = new DateTime(1899, 11, 30, hours, minutes, seconds);
            return {
                value: hours / 24 + minutes / 1440 + seconds / 86400,
                format: format,
                jsDate: jsDate,
            };
        }
        return null;
    }
    // -----------------------------------------------------------------------------
    // Conversion
    // -----------------------------------------------------------------------------
    function numberToJsDate(value) {
        const truncValue = Math.trunc(value);
        let date = DateTime.fromTimestamp(truncValue * MS_PER_DAY - DATE_JS_1900_OFFSET);
        let time = value - truncValue;
        time = time < 0 ? 1 + time : time;
        const hours = Math.round(time * 24);
        const minutes = Math.round((time - hours / 24) * 24 * 60);
        const seconds = Math.round((time - hours / 24 - minutes / 24 / 60) * 24 * 60 * 60);
        date.setHours(hours);
        date.setMinutes(minutes);
        date.setSeconds(seconds);
        return date;
    }
    function jsDateToRoundNumber(date) {
        return Math.round(jsDateToNumber(date));
    }
    function jsDateToNumber(date) {
        const delta = date.getTime() - INITIAL_1900_DAY.getTime();
        return delta / MS_PER_DAY;
    }
    /** Return the number of days in the current month of the given date */
    function getDaysInMonth(date) {
        return new DateTime(date.getFullYear(), date.getMonth() + 1, 0).getDate();
    }
    function isLastDayOfMonth(date) {
        return getDaysInMonth(date) === date.getDate();
    }
    /**
     * Add a certain number of months to a date. This will adapt the month number, and possibly adapt
     * the day of the month to keep it in the month.
     *
     * For example "31/12/2020" minus one month will be "30/11/2020", and not "31/11/2020"
     *
     * @param keepEndOfMonth if true, if the given date was the last day of a month, the returned date will
     *          also always be the last day of a month.
     */
    function addMonthsToDate(date, months, keepEndOfMonth) {
        const yStart = date.getFullYear();
        const mStart = date.getMonth();
        const dStart = date.getDate();
        const jsDate = new DateTime(yStart, mStart + months, 1);
        if (keepEndOfMonth && dStart === getDaysInMonth(date)) {
            jsDate.setDate(getDaysInMonth(jsDate));
        }
        else if (dStart > getDaysInMonth(jsDate)) {
            // 31/03 minus one month should be 28/02, not 31/02
            jsDate.setDate(getDaysInMonth(jsDate));
        }
        else {
            jsDate.setDate(dStart);
        }
        return jsDate;
    }
    function isLeapYear(year) {
        const _year = Math.trunc(year);
        return (_year % 4 === 0 && _year % 100 != 0) || _year % 400 === 0;
    }
    function getYearFrac(startDate, endDate, _dayCountConvention) {
        if (startDate === endDate) {
            return 0;
        }
        if (startDate > endDate) {
            const stack = endDate;
            endDate = startDate;
            startDate = stack;
        }
        const jsStartDate = numberToJsDate(startDate);
        const jsEndDate = numberToJsDate(endDate);
        let dayStart = jsStartDate.getDate();
        let dayEnd = jsEndDate.getDate();
        const monthStart = jsStartDate.getMonth(); // january is 0
        const monthEnd = jsEndDate.getMonth(); // january is 0
        const yearStart = jsStartDate.getFullYear();
        const yearEnd = jsEndDate.getFullYear();
        let yearsStart = 0;
        let yearsEnd = 0;
        switch (_dayCountConvention) {
            // 30/360 US convention --------------------------------------------------
            case 0:
                if (dayStart === 31)
                    dayStart = 30;
                if (dayStart === 30 && dayEnd === 31)
                    dayEnd = 30;
                // If jsStartDate is the last day of February
                if (monthStart === 1 && dayStart === (isLeapYear(yearStart) ? 29 : 28)) {
                    dayStart = 30;
                    // If jsEndDate is the last day of February
                    if (monthEnd === 1 && dayEnd === (isLeapYear(yearEnd) ? 29 : 28)) {
                        dayEnd = 30;
                    }
                }
                yearsStart = yearStart + (monthStart * 30 + dayStart) / 360;
                yearsEnd = yearEnd + (monthEnd * 30 + dayEnd) / 360;
                break;
            // actual/actual convention ----------------------------------------------
            case 1:
                let daysInYear = 365;
                const isSameYear = yearStart === yearEnd;
                const isOneDeltaYear = yearStart + 1 === yearEnd;
                const isMonthEndBigger = monthStart < monthEnd;
                const isSameMonth = monthStart === monthEnd;
                const isDayEndBigger = dayStart < dayEnd;
                // |-----|  <-- one Year
                // 'A' is start date
                // 'B' is end date
                if ((!isSameYear && !isOneDeltaYear) ||
                    (!isSameYear && isMonthEndBigger) ||
                    (!isSameYear && isSameMonth && isDayEndBigger)) {
                    // |---A-|-----|-B---|  <-- !isSameYear && !isOneDeltaYear
                    // |---A-|----B|-----|  <-- !isSameYear && isMonthEndBigger
                    // |---A-|---B-|-----|  <-- !isSameYear && isSameMonth && isDayEndBigger
                    let countYears = 0;
                    let countDaysInYears = 0;
                    for (let y = yearStart; y <= yearEnd; y++) {
                        countYears++;
                        countDaysInYears += isLeapYear(y) ? 366 : 365;
                    }
                    daysInYear = countDaysInYears / countYears;
                }
                else if (!isSameYear) {
                    // |-AF--|B----|-----|
                    if (isLeapYear(yearStart) && monthStart < 2) {
                        daysInYear = 366;
                    }
                    // |--A--|FB---|-----|
                    if (isLeapYear(yearEnd) && (monthEnd > 1 || (monthEnd === 1 && dayEnd === 29))) {
                        daysInYear = 366;
                    }
                }
                else {
                    // remaining cases:
                    //
                    // |-F-AB|-----|-----|
                    // |AB-F-|-----|-----|
                    // |A-F-B|-----|-----|
                    // if February 29 occurs between date1 (exclusive) and date2 (inclusive)
                    // daysInYear --> 366
                    if (isLeapYear(yearStart)) {
                        daysInYear = 366;
                    }
                }
                yearsStart = startDate / daysInYear;
                yearsEnd = endDate / daysInYear;
                break;
            // actual/360 convention -------------------------------------------------
            case 2:
                yearsStart = startDate / 360;
                yearsEnd = endDate / 360;
                break;
            // actual/365 convention -------------------------------------------------
            case 3:
                yearsStart = startDate / 365;
                yearsEnd = endDate / 365;
                break;
            // 30/360 European convention --------------------------------------------
            case 4:
                if (dayStart === 31)
                    dayStart = 30;
                if (dayEnd === 31)
                    dayEnd = 30;
                yearsStart = yearStart + (monthStart * 30 + dayStart) / 360;
                yearsEnd = yearEnd + (monthEnd * 30 + dayEnd) / 360;
                break;
        }
        return yearsEnd - yearsStart;
    }
    /**
     * Get the number of whole months between two dates.
     * e.g.
     *  2002/01/01 -> 2002/02/01 = 1 month,
     *  2002/01/01 -> 2003/02/01 = 13 months
     * @param startDate
     * @param endDate
     * @returns
     */
    function getTimeDifferenceInWholeMonths(startDate, endDate) {
        const months = (endDate.getFullYear() - startDate.getFullYear()) * 12 +
            endDate.getMonth() -
            startDate.getMonth();
        return startDate.getDate() > endDate.getDate() ? months - 1 : months;
    }
    function getTimeDifferenceInWholeDays(startDate, endDate) {
        const startUtc = startDate.getTime();
        const endUtc = endDate.getTime();
        return Math.floor((endUtc - startUtc) / MS_PER_DAY);
    }
    function getTimeDifferenceInWholeYears(startDate, endDate) {
        const years = endDate.getFullYear() - startDate.getFullYear();
        const monthStart = startDate.getMonth();
        const monthEnd = endDate.getMonth();
        const dateStart = startDate.getDate();
        const dateEnd = endDate.getDate();
        const isEndMonthDateBigger = monthEnd > monthStart || (monthEnd === monthStart && dateEnd >= dateStart);
        return isEndMonthDateBigger ? years : years - 1;
    }
    function areTwoDatesWithinOneYear(startDate, endDate) {
        return getYearFrac(startDate, endDate, 1) < 1;
    }
    function areDatesSameDay(startDate, endDate) {
        return Math.trunc(startDate) === Math.trunc(endDate);
    }
    function isDateBetween(date, startDate, endDate) {
        if (startDate > endDate) {
            return isDateBetween(date, endDate, startDate);
        }
        date = Math.trunc(date);
        startDate = Math.trunc(startDate);
        endDate = Math.trunc(endDate);
        return date >= startDate && date <= endDate;
    }
    /** Check if the first date is strictly before the second date */
    function isDateStrictlyBefore(date, dateBefore) {
        return Math.trunc(date) < Math.trunc(dateBefore);
    }
    /** Check if the first date is before or equal to the second date */
    function isDateBefore(date, dateBefore) {
        return Math.trunc(date) <= Math.trunc(dateBefore);
    }
    /** Check if the first date is strictly after the second date */
    function isDateStrictlyAfter(date, dateAfter) {
        return Math.trunc(date) > Math.trunc(dateAfter);
    }
    /** Check if the first date is after or equal to the second date */
    function isDateAfter(date, dateAfter) {
        return Math.trunc(date) >= Math.trunc(dateAfter);
    }

    /**
     * This function returns a regexp that is supposed to be as close as possible as the numberRegexp,
     * but its purpose is to be used by the tokenizer.
     *
     * - it tolerates extra characters at the end. This is useful because the tokenizer
     *   only needs to find the number at the start of a string
     * - it does not support % symbol, in formulas % is an operator
     */
    const getFormulaNumberRegex = memoize(function getFormulaNumberRegex(decimalSeparator) {
        decimalSeparator = escapeRegExp(decimalSeparator);
        return new RegExp(`(^-?\\d+(${decimalSeparator}?\\d*(e(\\+|-)?\\d+)?)?|^-?${decimalSeparator}\\d+)(?!\\w|!)`);
    });
    const getNumberRegex = memoize(function getNumberRegex(locale) {
        const decimalSeparator = escapeRegExp(locale.decimalSeparator);
        const thousandsSeparator = escapeRegExp(locale.thousandsSeparator || "");
        const pIntegerAndDecimals = `(\\d+(${thousandsSeparator}\\d{3,})*(${decimalSeparator}\\d*)?)`; // pattern that match integer number with or without decimal digits
        const pOnlyDecimals = `(${decimalSeparator}\\d+)`; // pattern that match only expression with decimal digits
        const pScientificFormat = "(e(\\+|-)?\\d+)?"; // pattern that match scientific format between zero and one time (should be placed before pPercentFormat)
        const pPercentFormat = "(\\s*%)?"; // pattern that match percent symbol between zero and one time
        const pNumber = "(\\s*" + pIntegerAndDecimals + "|" + pOnlyDecimals + ")" + pScientificFormat + pPercentFormat;
        const pMinus = "(\\s*-)?"; // pattern that match negative symbol between zero and one time
        const pCurrencyFormat = "(\\s*[\\$€])?";
        const p1 = pMinus + pCurrencyFormat + pNumber;
        const p2 = pMinus + pNumber + pCurrencyFormat;
        const p3 = pCurrencyFormat + pMinus + pNumber;
        const pNumberExp = "^((" + [p1, p2, p3].join(")|(") + "))$";
        const numberRegexp = new RegExp(pNumberExp, "i");
        return numberRegexp;
    });
    /**
     * Return true if the argument is a "number string".
     *
     * Note that "" (empty string) does not count as a number string
     */
    function isNumber(value, locale) {
        if (!value)
            return false;
        // TO DO: add regexp for DATE string format (ex match: "28 02 2020")
        return getNumberRegex(locale).test(value.trim());
    }
    const getInvaluableSymbolsRegexp = memoize(function getInvaluableSymbolsRegexp(locale) {
        return new RegExp(`[\$€${escapeRegExp(locale.thousandsSeparator || "")}]`, "g");
    });
    /**
     * Convert a string into a number. It assumes that the string actually represents
     * a number (as determined by the isNumber function)
     *
     * Note that it accepts "" (empty string), even though it does not count as a
     * number from the point of view of the isNumber function.
     */
    function parseNumber(str, locale) {
        // remove invaluable characters
        str = str.replace(getInvaluableSymbolsRegexp(locale), "");
        if (locale.decimalSeparator !== ".") {
            str = str.replace(locale.decimalSeparator, ".");
        }
        let n = Number(str);
        if (isNaN(n) && str.includes("%")) {
            n = Number(str.split("%")[0]);
            if (!isNaN(n)) {
                return n / 100;
            }
        }
        return n;
    }
    function percentile(values, percent, isInclusive) {
        const sortedValues = [...values].sort((a, b) => a - b);
        let percentIndex = (sortedValues.length + (isInclusive ? -1 : 1)) * percent;
        if (!isInclusive) {
            percentIndex--;
        }
        if (Number.isInteger(percentIndex)) {
            return sortedValues[percentIndex];
        }
        const indexSup = Math.ceil(percentIndex);
        const indexLow = Math.floor(percentIndex);
        return (sortedValues[indexSup] * (percentIndex - indexLow) +
            sortedValues[indexLow] * (indexSup - percentIndex));
    }

    var CellValueType;
    (function (CellValueType) {
        CellValueType["boolean"] = "boolean";
        CellValueType["number"] = "number";
        CellValueType["text"] = "text";
        CellValueType["empty"] = "empty";
        CellValueType["error"] = "error";
    })(CellValueType || (CellValueType = {}));

    var ClipboardMIMEType;
    (function (ClipboardMIMEType) {
        ClipboardMIMEType["PlainText"] = "text/plain";
        ClipboardMIMEType["Html"] = "text/html";
    })(ClipboardMIMEType || (ClipboardMIMEType = {}));

    function isSheetDependent(cmd) {
        return "sheetId" in cmd;
    }
    function isHeadersDependant(cmd) {
        return "dimension" in cmd && "sheetId" in cmd && "elements" in cmd;
    }
    function isTargetDependent(cmd) {
        return "target" in cmd && "sheetId" in cmd;
    }
    function isRangeDependant(cmd) {
        return "ranges" in cmd;
    }
    function isPositionDependent(cmd) {
        return "col" in cmd && "row" in cmd && "sheetId" in cmd;
    }
    function isZoneDependent(cmd) {
        return "sheetId" in cmd && "zone" in cmd;
    }
    const invalidateEvaluationCommands = new Set([
        "RENAME_SHEET",
        "DELETE_SHEET",
        "CREATE_SHEET",
        "ADD_COLUMNS_ROWS",
        "REMOVE_COLUMNS_ROWS",
        "UNDO",
        "REDO",
        "ADD_MERGE",
        "DUPLICATE_SHEET",
        "UPDATE_LOCALE",
    ]);
    const invalidateDependenciesCommands = new Set([
        ...invalidateEvaluationCommands,
        "MOVE_RANGES",
    ]);
    const invalidateCFEvaluationCommands = new Set([
        ...invalidateEvaluationCommands,
        "EVALUATE_CELLS",
        "ADD_CONDITIONAL_FORMAT",
        "REMOVE_CONDITIONAL_FORMAT",
        "CHANGE_CONDITIONAL_FORMAT_PRIORITY",
    ]);
    const readonlyAllowedCommands = new Set([
        "START",
        "ACTIVATE_SHEET",
        "COPY",
        "RESIZE_SHEETVIEW",
        "SET_VIEWPORT_OFFSET",
        "SELECT_SEARCH_NEXT_MATCH",
        "SELECT_SEARCH_PREVIOUS_MATCH",
        "UPDATE_SEARCH",
        "CLEAR_SEARCH",
        "EVALUATE_CELLS",
        "SET_CURRENT_CONTENT",
        "SET_FORMULA_VISIBILITY",
        "OPEN_CELL_POPOVER",
        "CLOSE_CELL_POPOVER",
        "UPDATE_FILTER",
    ]);
    const coreTypes = new Set([
        /** CELLS */
        "UPDATE_CELL",
        "UPDATE_CELL_POSITION",
        "CLEAR_CELL",
        "CLEAR_CELLS",
        "DELETE_CONTENT",
        /** GRID SHAPE */
        "ADD_COLUMNS_ROWS",
        "REMOVE_COLUMNS_ROWS",
        "RESIZE_COLUMNS_ROWS",
        "HIDE_COLUMNS_ROWS",
        "UNHIDE_COLUMNS_ROWS",
        "SET_GRID_LINES_VISIBILITY",
        "UNFREEZE_COLUMNS",
        "UNFREEZE_ROWS",
        "FREEZE_COLUMNS",
        "FREEZE_ROWS",
        "UNFREEZE_COLUMNS_ROWS",
        /** MERGE */
        "ADD_MERGE",
        "REMOVE_MERGE",
        /** SHEETS MANIPULATION */
        "CREATE_SHEET",
        "DELETE_SHEET",
        "DUPLICATE_SHEET",
        "MOVE_SHEET",
        "RENAME_SHEET",
        "HIDE_SHEET",
        "SHOW_SHEET",
        /** RANGES MANIPULATION */
        "MOVE_RANGES",
        /** CONDITIONAL FORMAT */
        "ADD_CONDITIONAL_FORMAT",
        "REMOVE_CONDITIONAL_FORMAT",
        "CHANGE_CONDITIONAL_FORMAT_PRIORITY",
        /** FIGURES */
        "CREATE_FIGURE",
        "DELETE_FIGURE",
        "UPDATE_FIGURE",
        /** FORMATTING */
        "SET_FORMATTING",
        "CLEAR_FORMATTING",
        "SET_BORDER",
        "SET_ZONE_BORDERS",
        "SET_BORDERS_ON_TARGET",
        /** CHART */
        "CREATE_CHART",
        "UPDATE_CHART",
        /** FILTERS */
        "CREATE_FILTER_TABLE",
        "REMOVE_FILTER_TABLE",
        /** IMAGE */
        "CREATE_IMAGE",
        /** HEADER GROUP */
        "GROUP_HEADERS",
        "UNGROUP_HEADERS",
        "UNFOLD_HEADER_GROUP",
        "FOLD_HEADER_GROUP",
        "FOLD_ALL_HEADER_GROUPS",
        "UNFOLD_ALL_HEADER_GROUPS",
        "UNFOLD_HEADER_GROUPS_IN_ZONE",
        "FOLD_HEADER_GROUPS_IN_ZONE",
        /** DATA VALIDATION */
        "ADD_DATA_VALIDATION_RULE",
        "REMOVE_DATA_VALIDATION_RULE",
        /** MISC */
        "UPDATE_LOCALE",
    ]);
    function isCoreCommand(cmd) {
        return coreTypes.has(cmd.type);
    }
    function canExecuteInReadonly(cmd) {
        return readonlyAllowedCommands.has(cmd.type);
    }
    /**
     * Holds the result of a command dispatch.
     * The command may have been successfully dispatched or cancelled
     * for one or more reasons.
     */
    class DispatchResult {
        reasons;
        constructor(results = []) {
            if (!Array.isArray(results)) {
                results = [results];
            }
            results = [...new Set(results)];
            this.reasons = results.filter((result) => result !== "Success" /* CommandResult.Success */);
        }
        /**
         * Static helper which returns a successful DispatchResult
         */
        static get Success() {
            return SUCCESS;
        }
        get isSuccessful() {
            return this.reasons.length === 0;
        }
        /**
         * Check if the dispatch has been cancelled because of
         * the given reason.
         */
        isCancelledBecause(reason) {
            return this.reasons.includes(reason);
        }
    }
    const SUCCESS = new DispatchResult();
    exports.CommandResult = void 0;
    (function (CommandResult) {
        CommandResult["Success"] = "Success";
        CommandResult["CancelledForUnknownReason"] = "CancelledForUnknownReason";
        CommandResult["WillRemoveExistingMerge"] = "WillRemoveExistingMerge";
        CommandResult["MergeIsDestructive"] = "MergeIsDestructive";
        CommandResult["CellIsMerged"] = "CellIsMerged";
        CommandResult["InvalidTarget"] = "InvalidTarget";
        CommandResult["EmptyUndoStack"] = "EmptyUndoStack";
        CommandResult["EmptyRedoStack"] = "EmptyRedoStack";
        CommandResult["NotEnoughElements"] = "NotEnoughElements";
        CommandResult["NotEnoughSheets"] = "NotEnoughSheets";
        CommandResult["MissingSheetName"] = "MissingSheetName";
        CommandResult["UnchangedSheetName"] = "UnchangedSheetName";
        CommandResult["DuplicatedSheetName"] = "DuplicatedSheetName";
        CommandResult["DuplicatedSheetId"] = "DuplicatedSheetId";
        CommandResult["ForbiddenCharactersInSheetName"] = "ForbiddenCharactersInSheetName";
        CommandResult["WrongSheetMove"] = "WrongSheetMove";
        CommandResult["WrongSheetPosition"] = "WrongSheetPosition";
        CommandResult["InvalidAnchorZone"] = "InvalidAnchorZone";
        CommandResult["SelectionOutOfBound"] = "SelectionOutOfBound";
        CommandResult["TargetOutOfSheet"] = "TargetOutOfSheet";
        CommandResult["WrongCutSelection"] = "WrongCutSelection";
        CommandResult["WrongPasteSelection"] = "WrongPasteSelection";
        CommandResult["WrongPasteOption"] = "WrongPasteOption";
        CommandResult["WrongFigurePasteOption"] = "WrongFigurePasteOption";
        CommandResult["EmptyClipboard"] = "EmptyClipboard";
        CommandResult["EmptyRange"] = "EmptyRange";
        CommandResult["InvalidRange"] = "InvalidRange";
        CommandResult["InvalidZones"] = "InvalidZones";
        CommandResult["InvalidSheetId"] = "InvalidSheetId";
        CommandResult["InvalidCellId"] = "InvalidCellId";
        CommandResult["InvalidFigureId"] = "InvalidFigureId";
        CommandResult["InputAlreadyFocused"] = "InputAlreadyFocused";
        CommandResult["MaximumRangesReached"] = "MaximumRangesReached";
        CommandResult["MinimumRangesReached"] = "MinimumRangesReached";
        CommandResult["InvalidChartDefinition"] = "InvalidChartDefinition";
        CommandResult["InvalidDataSet"] = "InvalidDataSet";
        CommandResult["InvalidLabelRange"] = "InvalidLabelRange";
        CommandResult["InvalidScorecardKeyValue"] = "InvalidScorecardKeyValue";
        CommandResult["InvalidScorecardBaseline"] = "InvalidScorecardBaseline";
        CommandResult["InvalidGaugeDataRange"] = "InvalidGaugeDataRange";
        CommandResult["EmptyGaugeRangeMin"] = "EmptyGaugeRangeMin";
        CommandResult["GaugeRangeMinNaN"] = "GaugeRangeMinNaN";
        CommandResult["EmptyGaugeRangeMax"] = "EmptyGaugeRangeMax";
        CommandResult["GaugeRangeMaxNaN"] = "GaugeRangeMaxNaN";
        CommandResult["GaugeRangeMinBiggerThanRangeMax"] = "GaugeRangeMinBiggerThanRangeMax";
        CommandResult["GaugeLowerInflectionPointNaN"] = "GaugeLowerInflectionPointNaN";
        CommandResult["GaugeUpperInflectionPointNaN"] = "GaugeUpperInflectionPointNaN";
        CommandResult["GaugeLowerBiggerThanUpper"] = "GaugeLowerBiggerThanUpper";
        CommandResult["InvalidAutofillSelection"] = "InvalidAutofillSelection";
        CommandResult["WrongComposerSelection"] = "WrongComposerSelection";
        CommandResult["MinBiggerThanMax"] = "MinBiggerThanMax";
        CommandResult["LowerBiggerThanUpper"] = "LowerBiggerThanUpper";
        CommandResult["MidBiggerThanMax"] = "MidBiggerThanMax";
        CommandResult["MinBiggerThanMid"] = "MinBiggerThanMid";
        CommandResult["FirstArgMissing"] = "FirstArgMissing";
        CommandResult["SecondArgMissing"] = "SecondArgMissing";
        CommandResult["MinNaN"] = "MinNaN";
        CommandResult["MidNaN"] = "MidNaN";
        CommandResult["MaxNaN"] = "MaxNaN";
        CommandResult["ValueUpperInflectionNaN"] = "ValueUpperInflectionNaN";
        CommandResult["ValueLowerInflectionNaN"] = "ValueLowerInflectionNaN";
        CommandResult["MinInvalidFormula"] = "MinInvalidFormula";
        CommandResult["MidInvalidFormula"] = "MidInvalidFormula";
        CommandResult["MaxInvalidFormula"] = "MaxInvalidFormula";
        CommandResult["ValueUpperInvalidFormula"] = "ValueUpperInvalidFormula";
        CommandResult["ValueLowerInvalidFormula"] = "ValueLowerInvalidFormula";
        CommandResult["InvalidSortZone"] = "InvalidSortZone";
        CommandResult["WaitingSessionConfirmation"] = "WaitingSessionConfirmation";
        CommandResult["MergeOverlap"] = "MergeOverlap";
        CommandResult["TooManyHiddenElements"] = "TooManyHiddenElements";
        CommandResult["Readonly"] = "Readonly";
        CommandResult["InvalidViewportSize"] = "InvalidViewportSize";
        CommandResult["InvalidScrollingDirection"] = "InvalidScrollingDirection";
        CommandResult["FigureDoesNotExist"] = "FigureDoesNotExist";
        CommandResult["InvalidConditionalFormatId"] = "InvalidConditionalFormatId";
        CommandResult["InvalidCellPopover"] = "InvalidCellPopover";
        CommandResult["EmptyTarget"] = "EmptyTarget";
        CommandResult["InvalidFreezeQuantity"] = "InvalidFreezeQuantity";
        CommandResult["FrozenPaneOverlap"] = "FrozenPaneOverlap";
        CommandResult["ValuesNotChanged"] = "ValuesNotChanged";
        CommandResult["InvalidFilterZone"] = "InvalidFilterZone";
        CommandResult["FilterOverlap"] = "FilterOverlap";
        CommandResult["FilterNotFound"] = "FilterNotFound";
        CommandResult["MergeInFilter"] = "MergeInFilter";
        CommandResult["NonContinuousTargets"] = "NonContinuousTargets";
        CommandResult["DuplicatedFigureId"] = "DuplicatedFigureId";
        CommandResult["InvalidSelectionStep"] = "InvalidSelectionStep";
        CommandResult["DuplicatedChartId"] = "DuplicatedChartId";
        CommandResult["ChartDoesNotExist"] = "ChartDoesNotExist";
        CommandResult["InvalidHeaderIndex"] = "InvalidHeaderIndex";
        CommandResult["InvalidQuantity"] = "InvalidQuantity";
        CommandResult["MoreThanOneColumnSelected"] = "MoreThanOneColumnSelected";
        CommandResult["EmptySplitSeparator"] = "EmptySplitSeparator";
        CommandResult["SplitWillOverwriteContent"] = "SplitWillOverwriteContent";
        CommandResult["NoSplitSeparatorInSelection"] = "NoSplitSeparatorInSelection";
        CommandResult["NoActiveSheet"] = "NoActiveSheet";
        CommandResult["InvalidLocale"] = "InvalidLocale";
        CommandResult["AlreadyInPaintingFormatMode"] = "AlreadyInPaintingFormatMode";
        CommandResult["MoreThanOneRangeSelected"] = "MoreThanOneRangeSelected";
        CommandResult["NoColumnsProvided"] = "NoColumnsProvided";
        CommandResult["ColumnsNotIncludedInZone"] = "ColumnsNotIncludedInZone";
        CommandResult["DuplicatesColumnsSelected"] = "DuplicatesColumnsSelected";
        CommandResult["InvalidHeaderGroupStartEnd"] = "InvalidHeaderGroupStartEnd";
        CommandResult["HeaderGroupAlreadyExists"] = "HeaderGroupAlreadyExists";
        CommandResult["UnknownHeaderGroup"] = "UnknownHeaderGroup";
        CommandResult["UnknownDataValidationRule"] = "UnknownDataValidationRule";
        CommandResult["UnknownDataValidationCriterionType"] = "UnknownDataValidationCriterionType";
        CommandResult["InvalidDataValidationCriterionValue"] = "InvalidDataValidationCriterionValue";
        CommandResult["InvalidNumberOfCriterionValues"] = "InvalidNumberOfCriterionValues";
        CommandResult["BlockingValidationRule"] = "BlockingValidationRule";
        CommandResult["InvalidCopyPasteSelection"] = "InvalidCopyPasteSelection";
        CommandResult["NoChanges"] = "NoChanges";
        CommandResult["InvalidInputId"] = "InvalidInputId";
    })(exports.CommandResult || (exports.CommandResult = {}));

    const DEFAULT_LOCALES = [
        {
            name: "English (US)",
            code: "en_US",
            thousandsSeparator: ",",
            decimalSeparator: ".",
            dateFormat: "m/d/yyyy",
            timeFormat: "hh:mm:ss a",
            formulaArgSeparator: ",",
        },
        {
            name: "French",
            code: "fr_FR",
            thousandsSeparator: " ",
            decimalSeparator: ",",
            dateFormat: "dd/mm/yyyy",
            timeFormat: "hh:mm:ss",
            formulaArgSeparator: ";",
        },
    ];
    const DEFAULT_LOCALE = DEFAULT_LOCALES[0];

    const borderStyles = ["thin", "medium", "thick", "dashed", "dotted"];
    function isMatrix(x) {
        return Array.isArray(x) && Array.isArray(x[0]);
    }
    var DIRECTION;
    (function (DIRECTION) {
        DIRECTION["UP"] = "up";
        DIRECTION["DOWN"] = "down";
        DIRECTION["LEFT"] = "left";
        DIRECTION["RIGHT"] = "right";
    })(DIRECTION || (DIRECTION = {}));

    var LAYERS;
    (function (LAYERS) {
        LAYERS[LAYERS["Background"] = 0] = "Background";
        LAYERS[LAYERS["Highlights"] = 1] = "Highlights";
        LAYERS[LAYERS["Clipboard"] = 2] = "Clipboard";
        LAYERS[LAYERS["Search"] = 3] = "Search";
        LAYERS[LAYERS["Chart"] = 4] = "Chart";
        LAYERS[LAYERS["Autofill"] = 5] = "Autofill";
        LAYERS[LAYERS["Selection"] = 6] = "Selection";
        LAYERS[LAYERS["Headers"] = 7] = "Headers";
    })(LAYERS || (LAYERS = {}));

    // HELPERS
    const SORT_TYPES_ORDER = ["number", "string", "boolean", "undefined"];
    function assert(condition, message) {
        if (!condition()) {
            throw new EvaluationError(CellErrorType.GenericError, message);
        }
    }
    // -----------------------------------------------------------------------------
    // FORMAT FUNCTIONS
    // -----------------------------------------------------------------------------
    const expectNumberValueError = (value) => _t("The function [[FUNCTION_NAME]] expects a number value, but '%s' is a string, and cannot be coerced to a number.", value);
    const expectNumberRangeError = (lowerBound, upperBound, value) => _t("The function [[FUNCTION_NAME]] expects a number value between %s and %s inclusive, but receives %s.", lowerBound.toString(), upperBound.toString(), value.toString());
    const expectStringSetError = (stringSet, value) => {
        const stringSetString = stringSet.map((str) => `'${str}'`).join(", ");
        return _t("The function [[FUNCTION_NAME]] has an argument with value '%s'. It should be one of: %s.", value, stringSetString);
    };
    function toNumber(value, locale) {
        switch (typeof value) {
            case "number":
                return value;
            case "boolean":
                return value ? 1 : 0;
            case "string":
                if (isNumber(value, locale) || value === "") {
                    return parseNumber(value, locale);
                }
                const internalDate = parseDateTime(value, locale);
                if (internalDate) {
                    return internalDate.value;
                }
                throw new Error(expectNumberValueError(value));
            default:
                return 0;
        }
    }
    function tryToNumber(value, locale) {
        try {
            return toNumber(value, locale);
        }
        catch (e) {
            return undefined;
        }
    }
    function tryCastAsNumberMatrix(data, argName) {
        data.forEach((row) => {
            row.forEach((cell) => {
                if (typeof cell !== "number") {
                    let message = "";
                    if (typeof cell === "object") {
                        message = _t("Function [[FUNCTION_NAME]] expects number values for %s, but got an empty value.", argName);
                    }
                    else if (typeof cell === "string") {
                        message = _t("Function [[FUNCTION_NAME]] expects number values for %s, but got a string.", argName);
                    }
                    else if (typeof cell === "boolean") {
                        message = _t("Function [[FUNCTION_NAME]] expects number values for %s, but got a boolean.", argName);
                    }
                    throw new Error(message);
                }
            });
        });
        return data;
    }
    function strictToNumber(value, locale) {
        if (value === "") {
            throw new Error(expectNumberValueError(value));
        }
        return toNumber(value, locale);
    }
    function toInteger(value, locale) {
        return Math.trunc(toNumber(value, locale));
    }
    function strictToInteger(value, locale) {
        return Math.trunc(strictToNumber(value, locale));
    }
    function assertNumberGreaterThanOrEqualToOne(value) {
        assert(() => value >= 1, _t("The function [[FUNCTION_NAME]] expects a number value to be greater than or equal to 1, but receives %s.", value.toString()));
    }
    function toString(value) {
        switch (typeof value) {
            case "string":
                return value;
            case "number":
                return value.toString();
            case "boolean":
                return value ? "TRUE" : "FALSE";
            default:
                return "";
        }
    }
    /** Normalize string by setting it to lowercase and replacing accent letters with plain letters */
    const normalizeString = memoize(function normalizeString(str) {
        return str
            .toLowerCase()
            .normalize("NFD")
            .replace(/[\u0300-\u036f]/g, "");
    });
    const expectBooleanValueError = (value) => _t("The function [[FUNCTION_NAME]] expects a boolean value, but '%s' is a text, and cannot be coerced to a number.", value);
    function toBoolean(value) {
        switch (typeof value) {
            case "boolean":
                return value;
            case "string":
                if (value) {
                    let uppercaseVal = value.toUpperCase();
                    if (uppercaseVal === "TRUE") {
                        return true;
                    }
                    if (uppercaseVal === "FALSE") {
                        return false;
                    }
                    throw new Error(expectBooleanValueError(value));
                }
                else {
                    return false;
                }
            case "number":
                return value ? true : false;
            default:
                return false;
        }
    }
    function strictToBoolean(value) {
        if (value === "") {
            throw new Error(expectBooleanValueError(value));
        }
        return toBoolean(value);
    }
    function toJsDate(value, locale) {
        return numberToJsDate(toNumber(value, locale));
    }
    // -----------------------------------------------------------------------------
    // VISIT FUNCTIONS
    // -----------------------------------------------------------------------------
    function visitArgs(args, cellCb, dataCb) {
        for (let arg of args) {
            if (isMatrix(arg)) {
                // arg is ref to a Cell/Range
                const lenRow = arg.length;
                const lenCol = arg[0].length;
                for (let y = 0; y < lenCol; y++) {
                    for (let x = 0; x < lenRow; x++) {
                        cellCb(arg[x][y]);
                    }
                }
            }
            else {
                // arg is set directly in the formula function
                dataCb(arg);
            }
        }
    }
    function visitAny(args, cb) {
        visitArgs(args, cb, cb);
    }
    function visitNumbers(args, cb, locale) {
        visitArgs(args, (cellValue) => {
            if (typeof cellValue === "number") {
                cb(cellValue);
            }
        }, (argValue) => {
            cb(strictToNumber(argValue, locale));
        });
    }
    // -----------------------------------------------------------------------------
    // REDUCE FUNCTIONS
    // -----------------------------------------------------------------------------
    function reduceArgs(args, cellCb, dataCb, initialValue, dir = "rowFirst") {
        let val = initialValue;
        for (let arg of args) {
            if (isMatrix(arg)) {
                // arg is ref to a Cell/Range
                const numberOfCols = arg.length;
                const numberOfRows = arg[0].length;
                if (dir === "rowFirst") {
                    for (let row = 0; row < numberOfRows; row++) {
                        for (let col = 0; col < numberOfCols; col++) {
                            val = cellCb(val, arg[col][row]);
                        }
                    }
                }
                else {
                    for (let col = 0; col < numberOfCols; col++) {
                        for (let row = 0; row < numberOfRows; row++) {
                            val = cellCb(val, arg[col][row]);
                        }
                    }
                }
            }
            else {
                // arg is set directly in the formula function
                val = dataCb(val, arg);
            }
        }
        return val;
    }
    function reduceAny(args, cb, initialValue, dir = "rowFirst") {
        return reduceArgs(args, cb, cb, initialValue, dir);
    }
    function reduceNumbers(args, cb, initialValue, locale) {
        return reduceArgs(args, (acc, ArgValue) => {
            if (typeof ArgValue === "number") {
                return cb(acc, ArgValue);
            }
            return acc;
        }, (acc, argValue) => {
            return cb(acc, strictToNumber(argValue, locale));
        }, initialValue);
    }
    function reduceNumbersTextAs0(args, cb, initialValue, locale) {
        return reduceArgs(args, (acc, ArgValue) => {
            if (ArgValue !== undefined && ArgValue !== null) {
                if (typeof ArgValue === "number") {
                    return cb(acc, ArgValue);
                }
                else if (typeof ArgValue === "boolean") {
                    return cb(acc, toNumber(ArgValue, locale));
                }
                else {
                    return cb(acc, 0);
                }
            }
            return acc;
        }, (acc, argValue) => {
            return cb(acc, toNumber(argValue, locale));
        }, initialValue);
    }
    // -----------------------------------------------------------------------------
    // MATRIX FUNCTIONS
    // -----------------------------------------------------------------------------
    /**
     * Generate a matrix of size nColumns x nRows and apply a callback on each position
     */
    function generateMatrix(nColumns, nRows, callback) {
        const returned = Array(nColumns);
        for (let col = 0; col < nColumns; col++) {
            returned[col] = Array(nRows);
            for (let row = 0; row < nRows; row++) {
                returned[col][row] = callback(col, row);
            }
        }
        return returned;
    }
    function matrixMap(matrix, fn) {
        if (matrix.length === 0) {
            return [];
        }
        return generateMatrix(matrix.length, matrix[0].length, (col, row) => fn(matrix[col][row]));
    }
    function transposeMatrix(matrix) {
        if (!matrix.length) {
            return [];
        }
        return generateMatrix(matrix[0].length, matrix.length, (i, j) => matrix[j][i]);
    }
    // -----------------------------------------------------------------------------
    // CONDITIONAL EXPLORE FUNCTIONS
    // -----------------------------------------------------------------------------
    /**
     * This function allows to visit arguments and stop the visit if necessary.
     * It is mainly used to bypass argument evaluation for functions like OR or AND.
     */
    function conditionalVisitArgs(args, cellCb, dataCb) {
        for (let arg of args) {
            if (isMatrix(arg)) {
                // arg is ref to a Cell/Range
                const lenRow = arg.length;
                const lenCol = arg[0].length;
                for (let y = 0; y < lenCol; y++) {
                    for (let x = 0; x < lenRow; x++) {
                        if (!cellCb(arg[x][y] ?? undefined))
                            return;
                    }
                }
            }
            else {
                // arg is set directly in the formula function
                if (!dataCb(arg))
                    return;
            }
        }
    }
    function conditionalVisitBoolean(args, cb) {
        return conditionalVisitArgs(args, (ArgValue) => {
            if (typeof ArgValue === "boolean") {
                return cb(ArgValue);
            }
            if (typeof ArgValue === "number") {
                return cb(ArgValue ? true : false);
            }
            return true;
        }, (argValue) => {
            if (argValue !== undefined && argValue !== null) {
                return cb(strictToBoolean(argValue));
            }
            return true;
        });
    }
    function getPredicate(descr, isQuery, locale) {
        let operator;
        let operand;
        let subString = descr.substring(0, 2);
        if (subString === "<=" || subString === ">=" || subString === "<>") {
            operator = subString;
            operand = descr.substring(2);
        }
        else {
            subString = descr.substring(0, 1);
            if (subString === "<" || subString === ">" || subString === "=") {
                operator = subString;
                operand = descr.substring(1);
            }
            else {
                operator = "=";
                operand = descr;
            }
        }
        if (isNumber(operand, locale) || isDateTime(operand, locale)) {
            operand = toNumber(operand, locale);
        }
        else if (operand === "TRUE" || operand === "FALSE") {
            operand = toBoolean(operand);
        }
        const result = { operator, operand };
        if (typeof operand === "string") {
            if (isQuery) {
                operand += "*";
            }
            result.regexp = operandToRegExp(operand);
        }
        return result;
    }
    function operandToRegExp(operand) {
        if (operand === "*") {
            return /.+/;
        }
        let exp = "";
        let predecessor = "";
        for (let char of operand) {
            if (char === "?" && predecessor !== "~") {
                exp += ".";
            }
            else if (char === "*" && predecessor !== "~") {
                exp += ".*";
            }
            else {
                if (char === "*" || char === "?") {
                    //remove "~"
                    exp = exp.slice(0, -1);
                }
                if (["^", ".", "[", "]", "$", "(", ")", "*", "+", "?", "|", "{", "}", "\\"].includes(char)) {
                    exp += "\\";
                }
                exp += char;
            }
            predecessor = char;
        }
        return new RegExp("^" + exp + "$", "i");
    }
    function evaluatePredicate(value = "", criterion, locale) {
        const { operator, operand } = criterion;
        if (operand === undefined || value === null || operand === null) {
            return false;
        }
        if (typeof operand === "number" && operator === "=") {
            if (typeof value === "string" && (isNumber(value, locale) || isDateTime(value, locale))) {
                return toNumber(value, locale) === operand;
            }
            return value === operand;
        }
        if (operator === "<>" || operator === "=") {
            let result;
            if (typeof value === typeof operand) {
                if (typeof value === "string" && criterion.regexp) {
                    result = criterion.regexp.test(value);
                }
                else {
                    result = value === operand;
                }
            }
            else {
                result = false;
            }
            return operator === "=" ? result : !result;
        }
        if (typeof value === typeof operand) {
            switch (operator) {
                case "<":
                    return value < operand;
                case ">":
                    return value > operand;
                case "<=":
                    return value <= operand;
                case ">=":
                    return value >= operand;
            }
        }
        return false;
    }
    /**
     * Functions used especially for predicate evaluation on ranges.
     *
     * Take ranges with same dimensions and take predicates, one for each range.
     * For (i, j) coordinates, if all elements with coordinates (i, j) of each
     * range correspond to the associated predicate, then the function uses a callback
     * function with the parameters "i" and "j".
     *
     * Syntax:
     * visitMatchingRanges([range1, predicate1, range2, predicate2, ...], cb(i,j), likeSelection)
     *
     * - range1 (range): The range to check against predicate1.
     * - predicate1 (string): The pattern or test to apply to range1.
     * - range2: (range, repeatable) ranges to check.
     * - predicate2 (string, repeatable): Additional pattern or test to apply to range2.
     *
     * - cb(i: number, j: number) => void: the callback function.
     *
     * - isQuery (boolean) indicates if the comparison with a string should be done as a SQL-like query.
     * (Ex1 isQuery = true, predicate = "abc", element = "abcde": predicate match the element),
     * (Ex2 isQuery = false, predicate = "abc", element = "abcde": predicate not match the element).
     * (Ex3 isQuery = true, predicate = "abc", element = "abc": predicate match the element),
     * (Ex4 isQuery = false, predicate = "abc", element = "abc": predicate match the element).
     */
    function visitMatchingRanges(args, cb, locale, isQuery = false) {
        const countArg = args.length;
        if (countArg % 2 === 1) {
            throw new Error(_t("Function [[FUNCTION_NAME]] expects criteria_range and criterion to be in pairs."));
        }
        const dimRow = args[0].length;
        const dimCol = args[0][0].length;
        let predicates = [];
        for (let i = 0; i < countArg - 1; i += 2) {
            const criteriaRange = args[i];
            if (!isMatrix(criteriaRange) ||
                criteriaRange.length !== dimRow ||
                criteriaRange[0].length !== dimCol) {
                throw new Error(_t("Function [[FUNCTION_NAME]] expects criteria_range to have the same dimension"));
            }
            const description = toString(args[i + 1]);
            predicates.push(getPredicate(description, isQuery, locale));
        }
        for (let i = 0; i < dimRow; i++) {
            for (let j = 0; j < dimCol; j++) {
                let validatedPredicates = true;
                for (let k = 0; k < countArg - 1; k += 2) {
                    const criteriaValue = args[k][i][j];
                    const criterion = predicates[k / 2];
                    validatedPredicates = evaluatePredicate(criteriaValue ?? undefined, criterion, locale);
                    if (!validatedPredicates) {
                        break;
                    }
                }
                if (validatedPredicates) {
                    cb(i, j);
                }
            }
        }
    }
    // -----------------------------------------------------------------------------
    // COMMON FUNCTIONS
    // -----------------------------------------------------------------------------
    /**
     * Perform a dichotomic search on an array and return the index of the nearest match.
     *
     * The array should be sorted, if not an incorrect value might be returned. In the case where multiple
     * element of the array match the target, the method will return the first match if the array is sorted
     * in descending order, and the last match if the array is in ascending order.
     *
     *
     * @param data the array in which to search.
     * @param target the value to search.
     * @param mode "nextGreater/nextSmaller" : return next greater/smaller value if no exact match is found.
     * @param sortOrder whether the array is sorted in ascending or descending order.
     * @param rangeLength the number of elements to consider in the search array.
     * @param getValueInData function returning the element at index i in the search array.
     */
    function dichotomicSearch(data, target, mode, sortOrder, rangeLength, getValueInData) {
        if (target === null || target === undefined) {
            return -1;
        }
        const _target = normalizeValue(target);
        const targetType = typeof _target;
        let matchVal = undefined;
        let matchValIndex = undefined;
        let indexLeft = 0;
        let indexRight = rangeLength - 1;
        let indexMedian;
        let currentIndex;
        let currentVal;
        let currentType;
        const getValue = sortOrder === "desc"
            ? (i) => normalizeValue(getValueInData(data, rangeLength - i - 1))
            : (i) => normalizeValue(getValueInData(data, i));
        while (indexRight - indexLeft >= 0) {
            indexMedian = Math.floor((indexLeft + indexRight) / 2);
            currentIndex = indexMedian;
            currentVal = getValue(currentIndex);
            currentType = typeof currentVal;
            // 1 - linear search to find value with the same type
            while (indexLeft < currentIndex && targetType !== currentType) {
                currentIndex--;
                currentVal = getValue(currentIndex);
                currentType = typeof currentVal;
            }
            if (currentType !== targetType || currentVal === undefined || currentVal === null) {
                indexLeft = indexMedian + 1;
                continue;
            }
            // 2 - check if value match
            if (mode === "strict" && currentVal === _target) {
                matchVal = currentVal;
                matchValIndex = currentIndex;
            }
            else if (mode === "nextSmaller" && currentVal <= _target) {
                if (matchVal === undefined ||
                    matchVal === null ||
                    matchVal < currentVal ||
                    (matchVal === currentVal && matchValIndex < currentIndex)) {
                    matchVal = currentVal;
                    matchValIndex = currentIndex;
                }
            }
            else if (mode === "nextGreater" && currentVal >= _target) {
                if (matchVal === undefined ||
                    matchVal > currentVal ||
                    (matchVal === currentVal && matchValIndex < currentIndex)) {
                    matchVal = currentVal;
                    matchValIndex = currentIndex;
                }
            }
            // 3 - give new indexes for the Binary search
            if (currentVal > _target || (mode === "strict" && currentVal === _target)) {
                indexRight = currentIndex - 1;
            }
            else {
                indexLeft = indexMedian + 1;
            }
        }
        // note that valMinIndex could be 0
        if (matchValIndex === undefined) {
            return -1;
        }
        return sortOrder === "desc" ? rangeLength - matchValIndex - 1 : matchValIndex;
    }
    /**
     * Perform a linear search and return the index of the match.
     * -1 is returned if no value is found.
     *
     * Example:
     * - [3, 6, 10], 3 => 0
     * - [3, 6, 10], 6 => 1
     * - [3, 6, 10], 9 => -1
     * - [3, 6, 10], 2 => -1
     *
     * @param data the array to search in.
     * @param target the value to search in the array.
     * @param mode if "strict" return exact match index. "nextGreater" returns the next greater
     * element from the target and "nextSmaller" the next smaller
     * @param numberOfValues the number of elements to consider in the search array.
     * @param getValueInData function returning the element at index i in the search array.
     * @param reverseSearch if true, search in the array starting from the end.

     */
    function linearSearch(data, target, mode, numberOfValues, getValueInData, reverseSearch = false) {
        if (target === null || target === undefined)
            return -1;
        const _target = normalizeValue(target);
        const getValue = reverseSearch
            ? (data, i) => getValueInData(data, numberOfValues - i - 1)
            : getValueInData;
        let closestMatch = undefined;
        let closestMatchIndex = -1;
        for (let i = 0; i < numberOfValues; i++) {
            const value = normalizeValue(getValue(data, i));
            if (value === _target) {
                return reverseSearch ? numberOfValues - i - 1 : i;
            }
            if (mode === "nextSmaller") {
                if ((!closestMatch && compareCellValues(_target, value) >= 0) ||
                    (compareCellValues(_target, value) >= 0 && compareCellValues(value, closestMatch) > 0)) {
                    closestMatch = value;
                    closestMatchIndex = i;
                }
            }
            else if (mode === "nextGreater") {
                if ((!closestMatch && compareCellValues(_target, value) <= 0) ||
                    (compareCellValues(_target, value) <= 0 && compareCellValues(value, closestMatch) < 0)) {
                    closestMatch = value;
                    closestMatchIndex = i;
                }
            }
        }
        return reverseSearch && closestMatchIndex !== -1
            ? numberOfValues - closestMatchIndex - 1
            : closestMatchIndex;
    }
    /**
     * Normalize a value.
     * If the cell value is a string, this will set it to lowercase and replacing accent letters with plain letters
     */
    function normalizeValue(value) {
        return typeof value === "string" ? normalizeString(value) : value;
    }
    function compareCellValues(left, right) {
        let typeOrder = SORT_TYPES_ORDER.indexOf(typeof left) - SORT_TYPES_ORDER.indexOf(typeof right);
        if (typeOrder === 0) {
            if (typeof left === "string" && typeof right === "string") {
                typeOrder = left.localeCompare(right);
            }
            else if (typeof left === "number" && typeof right === "number") {
                typeOrder = left - right;
            }
            else if (typeof left === "boolean" && typeof right === "boolean") {
                typeOrder = Number(left) - Number(right);
            }
        }
        return typeOrder;
    }
    function toMatrix(data) {
        if (data === undefined) {
            return [[]];
        }
        return isMatrix(data) ? data : [[data]];
    }
    /**
     * Flatten an array of items, where each item can be a single value or a 2D array, and apply the
     * callback to each element.
     *
     * The 2D array are flattened row first.
     */
    function flattenRowFirst(items, callback) {
        /**/
        return reduceAny(items, (array, val) => {
            array.push(callback(val));
            return array;
        }, [], "rowFirst");
    }

    function toCriterionDateNumber(dateValue) {
        const today = DateTime.now();
        switch (dateValue) {
            case "today":
                return Math.floor(jsDateToNumber(today));
            case "yesterday": {
                today.setDate(today.getDate() - 1);
                return Math.floor(jsDateToNumber(today));
            }
            case "tomorrow": {
                today.setDate(today.getDate() + 1);
                return Math.floor(jsDateToNumber(today));
            }
            case "lastWeek":
                today.setDate(today.getDate() - 6);
                return Math.floor(jsDateToNumber(today));
            case "lastMonth": {
                const lastMonth = today.getMonth() === 0 ? 11 : today.getMonth() - 1;
                const dateInLastMonth = new DateTime(today.getFullYear(), lastMonth, 1);
                if (today.getDate() > getDaysInMonth(dateInLastMonth)) {
                    today.setDate(1);
                }
                else {
                    today.setDate(today.getDate() + 1);
                    today.setMonth(today.getMonth() - 1);
                }
                return Math.floor(jsDateToNumber(today));
            }
            case "lastYear":
                // Handle leap year case
                if (today.getMonth() === 1 && today.getDate() === 29) {
                    today.setDate(28);
                    today.setFullYear(today.getFullYear() - 1);
                }
                else {
                    today.setDate(today.getDate() + 1);
                    today.setFullYear(today.getFullYear() - 1);
                }
                return Math.floor(jsDateToNumber(today));
        }
    }
    /** Get all the dates values of a criterion converted to numbers, converting date values such as "today" to actual dates  */
    function getDateNumberCriterionValues(criterion, locale) {
        if ("dateValue" in criterion && criterion.dateValue !== "exactDate") {
            return [toCriterionDateNumber(criterion.dateValue)];
        }
        return criterion.values.map((value) => valueToDateNumber(value, locale));
    }
    /** Convert the criterion values to numbers. Return undefined values if they cannot be converted to numbers. */
    function getCriterionValuesAsNumber(criterion, locale) {
        return criterion.values.map((value) => tryToNumber(value, locale));
    }

    const MAX_DELAY = 140;
    const MIN_DELAY = 20;
    const ACCELERATION = 0.035;
    /**
     * Decreasing exponential function used to determine the "speed" of edge-scrolling
     * as the timeout delay.
     *
     * Returns a timeout delay in milliseconds.
     */
    function scrollDelay(value) {
        // decreasing exponential from MAX_DELAY to MIN_DELAY
        return MIN_DELAY + (MAX_DELAY - MIN_DELAY) * Math.exp(-ACCELERATION * (value - 1));
    }

    /**
     *  Constant used to indicate the maximum of digits that is possible to display
     *  in a cell with standard size.
     */
    const MAX_DECIMAL_PLACES = 20;
    /**
     * Number of digits for the default number format. This number of digit make a number fit well in a cell
     * with default size and default font size.
     */
    const DEFAULT_FORMAT_NUMBER_OF_DIGITS = 11;
    //from https://stackoverflow.com/questions/721304/insert-commas-into-number-string @Thomas/Alan Moore
    const thousandsGroupsRegexp = /(\d+?)(?=(\d{3})+(?!\d)|$)/g;
    const zeroRegexp = /0/g;
    // TODO in the future : remove these constants MONTHS/DAYS, and use a library such as luxon to handle it
    // + possibly handle automatic translation of day/month
    const MONTHS = {
        0: _t("January"),
        1: _t("February"),
        2: _t("March"),
        3: _t("April"),
        4: _t("May"),
        5: _t("June"),
        6: _t("July"),
        7: _t("August"),
        8: _t("September"),
        9: _t("October"),
        10: _t("November"),
        11: _t("December"),
    };
    const DAYS$1 = {
        0: _t("Sunday"),
        1: _t("Monday"),
        2: _t("Tuesday"),
        3: _t("Wednesday"),
        4: _t("Thursday"),
        5: _t("Friday"),
        6: _t("Saturday"),
    };
    // -----------------------------------------------------------------------------
    // FORMAT REPRESENTATION CACHE
    // -----------------------------------------------------------------------------
    const internalFormatByFormatString = {};
    function parseFormat(formatString) {
        let internalFormat = internalFormatByFormatString[formatString];
        if (internalFormat === undefined) {
            internalFormat = convertFormatToInternalFormat(formatString);
            internalFormatByFormatString[formatString] = internalFormat;
        }
        return internalFormat;
    }
    // -----------------------------------------------------------------------------
    // APPLY FORMAT
    // -----------------------------------------------------------------------------
    /**
     * Formats a cell value with its format.
     */
    function formatValue(value, { format, locale }) {
        switch (typeof value) {
            case "string":
                if (value.includes('\\"')) {
                    return value.replace(/\\"/g, '"');
                }
                return value;
            case "boolean":
                return value ? "TRUE" : "FALSE";
            case "number":
                // transform to internalNumberFormat
                if (!format) {
                    format = createDefaultFormat(value);
                }
                const internalFormat = parseFormat(format);
                return applyInternalFormat(value, internalFormat, locale);
            case "object":
                return "0";
        }
    }
    function applyInternalFormat(value, internalFormat, locale) {
        if (internalFormat[0].type === "DATE") {
            return applyDateTimeFormat(value, internalFormat[0].format);
        }
        let formattedValue = value < 0 ? "-" : "";
        for (let part of internalFormat) {
            switch (part.type) {
                case "NUMBER":
                    formattedValue += applyInternalNumberFormat(Math.abs(value), part.format, locale);
                    break;
                case "STRING":
                    formattedValue += part.format;
                    break;
            }
        }
        return formattedValue;
    }
    function applyInternalNumberFormat(value, format, locale) {
        if (format.isPercent) {
            value = value * 100;
        }
        value = value / format.magnitude;
        let maxDecimals = 0;
        if (format.decimalPart !== undefined) {
            maxDecimals = format.decimalPart.length;
        }
        const { integerDigits, decimalDigits } = splitNumber(value, maxDecimals);
        let formattedValue = applyIntegerFormat(integerDigits, format.integerPart, format.thousandsSeparator ? locale.thousandsSeparator : undefined);
        if (format.decimalPart !== undefined) {
            formattedValue +=
                locale.decimalSeparator + applyDecimalFormat(decimalDigits || "", format.decimalPart);
        }
        if (format.isPercent) {
            formattedValue += "%";
        }
        return formattedValue;
    }
    function applyIntegerFormat(integerDigits, integerFormat, thousandsSeparator) {
        const _integerDigits = integerDigits === "0" ? "" : integerDigits;
        let formattedInteger = _integerDigits;
        const delta = integerFormat.length - _integerDigits.length;
        if (delta > 0) {
            // ex: format = "0#000000" and integerDigit: "123"
            const restIntegerFormat = integerFormat.substring(0, delta); // restIntegerFormat = "0#00"
            const countZero = (restIntegerFormat.match(zeroRegexp) || []).length; // countZero = 3
            formattedInteger = "0".repeat(countZero) + formattedInteger; // return "000123"
        }
        if (thousandsSeparator) {
            formattedInteger =
                formattedInteger.match(thousandsGroupsRegexp)?.join(thousandsSeparator) || formattedInteger;
        }
        return formattedInteger;
    }
    function applyDecimalFormat(decimalDigits, decimalFormat) {
        // assume the format is valid (no commas)
        let formattedDecimals = decimalDigits;
        if (decimalFormat.length - decimalDigits.length > 0) {
            const restDecimalFormat = decimalFormat.substring(decimalDigits.length, decimalFormat.length + 1);
            const countZero = (restDecimalFormat.match(zeroRegexp) || []).length;
            formattedDecimals = formattedDecimals + "0".repeat(countZero);
        }
        return formattedDecimals;
    }
    /**
     * this is a cache that can contains number representation formats
     * from 0 (minimum) to 20 (maximum) digits after the decimal point
     */
    const numberRepresentation = [];
    /** split a number into two strings that contain respectively:
     * - all digit stored in the integer part of the number
     * - all digit stored in the decimal part of the number
     *
     * The 'maxDecimal' parameter allows to indicate the number of digits to not
     * exceed in the decimal part, in which case digits are rounded.
     *
     **/
    function splitNumber(value, maxDecimals = MAX_DECIMAL_PLACES) {
        const asString = value.toString();
        if (asString.includes("e"))
            return splitNumberIntl(value, maxDecimals);
        if (Number.isInteger(value)) {
            return { integerDigits: asString, decimalDigits: undefined };
        }
        const indexOfDot = asString.indexOf(".");
        let integerDigits = asString.substring(0, indexOfDot);
        let decimalDigits = asString.substring(indexOfDot + 1);
        if (maxDecimals === 0) {
            if (Number(decimalDigits[0]) >= 5) {
                integerDigits = (Number(integerDigits) + 1).toString();
            }
            return { integerDigits, decimalDigits: undefined };
        }
        if (decimalDigits.length > maxDecimals) {
            const { integerDigits: roundedIntegerDigits, decimalDigits: roundedDecimalDigits } = limitDecimalDigits(decimalDigits, maxDecimals);
            decimalDigits = roundedDecimalDigits;
            if (roundedIntegerDigits !== "0") {
                integerDigits = (Number(integerDigits) + Number(roundedIntegerDigits)).toString();
            }
        }
        return { integerDigits, decimalDigits: removeTrailingZeroes(decimalDigits || "") };
    }
    /**
     *  Return the given string minus the trailing "0" characters.
     *
     * @param numberString : a string of integers
     * @returns the numberString, minus the eventual zeroes at the end
     */
    function removeTrailingZeroes(numberString) {
        let i = numberString.length - 1;
        while (i >= 0 && numberString[i] === "0") {
            i--;
        }
        return numberString.slice(0, i + 1) || undefined;
    }
    const leadingZeroesRegexp = /^0+/;
    /**
     * Limit the size of the decimal part of a number to the given number of digits.
     */
    function limitDecimalDigits(decimalDigits, maxDecimals) {
        let integerDigits = "0";
        let resultDecimalDigits = decimalDigits;
        // Note : we'd want to simply use number.toFixed() to handle the max digits & rounding,
        // but it has very strange behaviour. Ex: 12.345.toFixed(2) => "12.35", but 1.345.toFixed(2) => "1.34"
        let slicedDecimalDigits = decimalDigits.slice(0, maxDecimals);
        const i = maxDecimals;
        if (Number(decimalDigits[i]) < 5) {
            return { integerDigits, decimalDigits: slicedDecimalDigits };
        }
        // round up
        const leadingZeroes = slicedDecimalDigits.match(leadingZeroesRegexp)?.[0] || "";
        const slicedRoundedUp = (Number(slicedDecimalDigits) + 1).toString();
        const withoutLeadingZeroes = slicedDecimalDigits.slice(leadingZeroes.length);
        // e.g. carry over from 99 to 100
        const carryOver = slicedRoundedUp.length > withoutLeadingZeroes.length;
        if (carryOver && !leadingZeroes) {
            integerDigits = "1";
            resultDecimalDigits = undefined;
        }
        else if (carryOver) {
            resultDecimalDigits = leadingZeroes.slice(0, -1) + slicedRoundedUp;
        }
        else {
            resultDecimalDigits = leadingZeroes + slicedRoundedUp;
        }
        return { integerDigits, decimalDigits: resultDecimalDigits };
    }
    /**
     * Split numbers into decimal/integer digits using Intl.NumberFormat.
     * Supports numbers with a lot of digits that are transformed to scientific notation by
     * number.toString(), but is slow.
     */
    function splitNumberIntl(value, maxDecimals = MAX_DECIMAL_PLACES) {
        let formatter = numberRepresentation[maxDecimals];
        if (!formatter) {
            formatter = new Intl.NumberFormat("en-US", {
                maximumFractionDigits: maxDecimals,
                useGrouping: false,
            });
            numberRepresentation[maxDecimals] = formatter;
        }
        const [integerDigits, decimalDigits] = formatter.format(value).split(".");
        return { integerDigits, decimalDigits };
    }
    /** Convert a number into a string, without scientific notation */
    function numberToString(number, decimalSeparator) {
        const { integerDigits, decimalDigits } = splitNumber(number, 20);
        return decimalDigits ? integerDigits + decimalSeparator + decimalDigits : integerDigits;
    }
    /**
     * Check if the given format is a time, date or date time format.
     */
    function isDateTimeFormat(format) {
        if (!allowedDateTimeFormatFirstChar.has(format[0])) {
            // first check for performance reason
            return false;
        }
        try {
            applyDateTimeFormat(1, format);
            return true;
        }
        catch (error) {
            return false;
        }
    }
    const allowedDateTimeFormatFirstChar = new Set(["h", "m", "y", "d"]);
    function applyDateTimeFormat(value, format) {
        // TODO: unify the format functions for date and datetime
        // This requires some code to 'parse' or 'tokenize' the format, keep it in a
        // cache, and use it in a single mapping, that recognizes the special list
        // of tokens dd,d,m,y,h, ... and preserves the rest
        const jsDate = numberToJsDate(value);
        const indexH = format.indexOf("h");
        let strDate = "";
        let strTime = "";
        if (indexH > 0) {
            strDate = formatJSDate(jsDate, format.substring(0, indexH - 1));
            strTime = formatJSTime(jsDate, format.substring(indexH));
        }
        else if (indexH === 0) {
            strTime = formatJSTime(jsDate, format);
        }
        else if (indexH < 0) {
            strDate = formatJSDate(jsDate, format);
        }
        return strDate + (strDate && strTime ? " " : "") + strTime;
    }
    function formatJSDate(jsDate, format) {
        const sep = format.match(/\/|-|\s/)?.[0];
        const parts = sep ? format.split(sep) : [format];
        return parts
            .map((p) => {
            switch (p) {
                case "d":
                    return jsDate.getDate();
                case "dd":
                    return jsDate.getDate().toString().padStart(2, "0");
                case "ddd":
                    return DAYS$1[jsDate.getDay()].slice(0, 3);
                case "dddd":
                    return DAYS$1[jsDate.getDay()];
                case "m":
                    return jsDate.getMonth() + 1;
                case "mm":
                    return String(jsDate.getMonth() + 1).padStart(2, "0");
                case "mmm":
                    return MONTHS[jsDate.getMonth()].slice(0, 3);
                case "mmmm":
                    return MONTHS[jsDate.getMonth()];
                case "mmmmm":
                    return MONTHS[jsDate.getMonth()].slice(0, 1);
                case "yy":
                    const fullYear = String(jsDate.getFullYear()).replace("-", "").padStart(2, "0");
                    return fullYear.slice(fullYear.length - 2);
                case "yyyy":
                    return jsDate.getFullYear();
                default:
                    throw new Error(`invalid format: ${format}`);
            }
        })
            .join(sep);
    }
    function formatJSTime(jsDate, format) {
        let parts = format.split(/:|\s/);
        const dateHours = jsDate.getHours();
        const isMeridian = parts[parts.length - 1] === "a";
        let hours = dateHours;
        let meridian = "";
        if (isMeridian) {
            hours = hours === 0 ? 12 : hours > 12 ? hours - 12 : hours;
            meridian = dateHours >= 12 ? " PM" : " AM";
            parts.pop();
        }
        return (parts
            .map((p) => {
            switch (p) {
                case "hhhh":
                    const helapsedHours = Math.floor((jsDate.getTime() - INITIAL_1900_DAY.getTime()) / (60 * 60 * 1000));
                    return helapsedHours.toString();
                case "hh":
                    return hours.toString().padStart(2, "0");
                case "mm":
                    return jsDate.getMinutes().toString().padStart(2, "0");
                case "ss":
                    return jsDate.getSeconds().toString().padStart(2, "0");
                default:
                    throw new Error(`invalid format: ${format}`);
            }
        })
            .join(":") + meridian);
    }
    /**
     * Get a regex matching decimal number based on the locale's thousand separator
     *
     * eg. if the locale's thousand separator is a comma, this will return a regex /[0-9]+,[0-9]/
     */
    const getDecimalNumberRegex = memoize(function getDecimalNumberRegex(locale) {
        return new RegExp(`[0-9]+${escapeRegExp(locale.decimalSeparator)}[0-9]`);
    });
    // -----------------------------------------------------------------------------
    // CREATE / MODIFY FORMAT
    // -----------------------------------------------------------------------------
    /**
     * Create a default format for a number.
     *
     * If possible this will try round the number to have less than DEFAULT_FORMAT_NUMBER_OF_DIGITS characters
     * in the number. This is obviously only possible for number with a big decimal part. For number with a lot
     * of digits in the integer part, keep the number as it is.
     */
    function createDefaultFormat(value) {
        let { integerDigits, decimalDigits } = splitNumber(value);
        if (!decimalDigits)
            return "0";
        const digitsInIntegerPart = integerDigits.replace("-", "").length;
        // If there's no space for at least the decimal separator + a decimal digit, don't display decimals
        if (digitsInIntegerPart + 2 > DEFAULT_FORMAT_NUMBER_OF_DIGITS) {
            return "0";
        }
        // -1 for the decimal separator character
        const spaceForDecimalsDigits = DEFAULT_FORMAT_NUMBER_OF_DIGITS - digitsInIntegerPart - 1;
        ({ decimalDigits } = splitNumber(value, Math.min(spaceForDecimalsDigits, decimalDigits.length)));
        return decimalDigits ? "0." + "0".repeat(decimalDigits.length) : "0";
    }
    function detectDateFormat(content, locale) {
        if (!isDateTime(content, locale)) {
            return undefined;
        }
        const internalDate = parseDateTime(content, locale);
        return internalDate.format;
    }
    function detectNumberFormat(content) {
        if (!isNumber(content, DEFAULT_LOCALE)) {
            return undefined;
        }
        const digitBase = content.includes(".") ? "0.00" : "0";
        const matchedCurrencies = content.match(/[\$€]/);
        if (matchedCurrencies) {
            const matchedFirstDigit = content.match(/[\d]/);
            const currency = "[$" + matchedCurrencies.values().next().value + "]";
            if (matchedFirstDigit.index < matchedCurrencies.index) {
                return "#,##" + digitBase + currency;
            }
            return currency + "#,##" + digitBase;
        }
        if (content.includes("%")) {
            return digitBase + "%";
        }
        return undefined;
    }
    function createCurrencyFormat(currency) {
        const decimalPlaces = currency.decimalPlaces ?? 2;
        const position = currency.position ?? "before";
        const code = currency.code ?? "";
        const symbol = currency.symbol ?? "";
        const decimalRepresentation = decimalPlaces ? "." + "0".repeat(decimalPlaces) : "";
        const numberFormat = "#,##0" + decimalRepresentation;
        let textExpression = `${code} ${symbol}`.trim();
        if (position === "after" && code) {
            textExpression = " " + textExpression;
        }
        return insertTextInFormat(textExpression, position, numberFormat);
    }
    function insertTextInFormat(text, position, format) {
        const textExpression = `[$${text}]`;
        return position === "before" ? textExpression + format : format + textExpression;
    }
    function roundFormat(format) {
        const internalFormat = parseFormat(format);
        const roundedFormat = internalFormat.map((formatPart) => {
            if (formatPart.type === "NUMBER") {
                return {
                    type: formatPart.type,
                    format: {
                        ...formatPart.format,
                        decimalPart: undefined,
                    },
                };
            }
            return formatPart;
        });
        return convertInternalFormatToFormat(roundedFormat);
    }
    function createLargeNumberFormat(format, magnitude, postFix, locale) {
        const internalFormat = parseFormat(format || "#,##0");
        const largeNumberFormat = [];
        for (let i = 0; i < internalFormat.length; i++) {
            const formatPart = internalFormat[i];
            if (formatPart.type !== "NUMBER") {
                largeNumberFormat.push(formatPart);
                continue;
            }
            largeNumberFormat.push({
                ...formatPart,
                format: {
                    ...formatPart.format,
                    magnitude,
                    decimalPart: undefined,
                },
            });
            largeNumberFormat.push({
                type: "STRING",
                format: postFix,
            });
            const nextFormatPart = internalFormat[i + 1];
            if (nextFormatPart?.type === "STRING" && ["k", "m", "b"].includes(nextFormatPart.format)) {
                i++;
            }
        }
        return convertInternalFormatToFormat(largeNumberFormat);
    }
    function changeDecimalPlaces(format, step, locale) {
        const internalFormat = parseFormat(format);
        const newInternalFormat = internalFormat.map((intFmt) => {
            if (intFmt.type === "NUMBER") {
                return { ...intFmt, format: changeInternalNumberFormatDecimalPlaces(intFmt.format, step) };
            }
            else {
                return intFmt;
            }
        });
        const newFormat = convertInternalFormatToFormat(newInternalFormat);
        internalFormatByFormatString[newFormat] = newInternalFormat;
        return newFormat;
    }
    function changeInternalNumberFormatDecimalPlaces(format, step) {
        const _format = { ...format };
        const sign = Math.sign(step);
        const decimalLength = _format.decimalPart?.length || 0;
        const countZero = Math.min(Math.max(0, decimalLength + sign), MAX_DECIMAL_PLACES);
        _format.decimalPart = "0".repeat(countZero);
        if (_format.decimalPart === "") {
            delete _format.decimalPart;
        }
        return _format;
    }
    // -----------------------------------------------------------------------------
    // MANAGING FORMAT
    // -----------------------------------------------------------------------------
    /**
     * Validates the provided format string and returns an InternalFormat Object.
     */
    function convertFormatToInternalFormat(format) {
        if (format === "") {
            throw new Error("A format cannot be empty");
        }
        let currentIndex = 0;
        let result = [];
        while (currentIndex < format.length) {
            let closingIndex;
            if (format.charAt(currentIndex) === "[") {
                if (format.charAt(currentIndex + 1) !== "$") {
                    throw new Error(`Currency formats have to be prefixed by a $: ${format}`);
                }
                // manage brackets/customStrings
                closingIndex = format.substring(currentIndex + 1).indexOf("]") + currentIndex + 2;
                if (closingIndex === 0) {
                    throw new Error(`Invalid currency brackets format: ${format}`);
                }
                const str = format.substring(currentIndex + 2, closingIndex - 1);
                if (str.includes("[")) {
                    throw new Error(`Invalid currency format: ${format}`);
                }
                result.push({
                    type: "STRING",
                    format: str,
                }); // remove leading "[$"" and ending "]".
            }
            else {
                // rest of the time
                const nextPartIndex = format.substring(currentIndex).indexOf("[");
                closingIndex = nextPartIndex > -1 ? nextPartIndex + currentIndex : format.length;
                const subFormat = format.substring(currentIndex, closingIndex);
                if (isDateTimeFormat(subFormat)) {
                    result.push({ type: "DATE", format: subFormat });
                }
                else {
                    result.push({
                        type: "NUMBER",
                        format: convertToInternalNumberFormat(subFormat),
                    });
                }
            }
            currentIndex = closingIndex;
        }
        return result;
    }
    const magnitudeRegex = /,*?$/;
    /**
     * @param format a formatString that is only applicable to numbers. I.e. composed of characters 0 # , . %
     */
    function convertToInternalNumberFormat(format) {
        format = format.trim();
        if (containsInvalidNumberChars(format)) {
            throw new Error(`Invalid number format: ${format}`);
        }
        const isPercent = format.includes("%");
        const magnitudeCommas = format.match(magnitudeRegex)?.[0] || "";
        const magnitude = !magnitudeCommas ? 1 : 1000 ** magnitudeCommas.length;
        let _format = format.slice(0, format.length - (magnitudeCommas.length || 0));
        const thousandsSeparator = _format.includes(",");
        if (/\..*,/.test(_format)) {
            throw new Error("A format can't contain ',' symbol in the decimal part");
        }
        _format = _format.replace("%", "").replace(",", "");
        const extraSigns = _format.match(/[\%|,]/);
        if (extraSigns) {
            throw new Error(`A format can only contain a single '${extraSigns[0]}' symbol`);
        }
        const [integerPart, decimalPart] = _format.split(".");
        if (decimalPart && decimalPart.length > 20) {
            throw new Error("A format can't contain more than 20 decimal places");
        }
        if (decimalPart !== undefined) {
            return {
                integerPart,
                isPercent,
                thousandsSeparator,
                decimalPart,
                magnitude,
            };
        }
        else {
            return {
                integerPart,
                isPercent,
                thousandsSeparator,
                magnitude,
            };
        }
    }
    const validNumberChars = /[,#0.%]/g;
    function containsInvalidNumberChars(format) {
        return Boolean(format.replace(validNumberChars, ""));
    }
    function convertInternalFormatToFormat(internalFormat) {
        let format = "";
        for (let part of internalFormat) {
            let currentFormat;
            switch (part.type) {
                case "NUMBER":
                    const fmt = part.format;
                    currentFormat = fmt.integerPart;
                    if (fmt.thousandsSeparator) {
                        currentFormat = currentFormat.slice(0, -3) + "," + currentFormat.slice(-3);
                    }
                    if (fmt.decimalPart !== undefined) {
                        currentFormat += "." + fmt.decimalPart;
                    }
                    if (fmt.isPercent) {
                        currentFormat += "%";
                    }
                    if (fmt.magnitude) {
                        currentFormat += ",".repeat(Math.log10(fmt.magnitude) / 3);
                    }
                    break;
                case "STRING":
                    currentFormat = `[$${part.format}]`;
                    break;
                case "DATE":
                    currentFormat = part.format;
                    break;
            }
            format += currentFormat;
        }
        return format;
    }

    /** Reference of a cell (eg. A1, $B$5) */
    const cellReference = new RegExp(/\$?([A-Z]{1,3})\$?([0-9]{1,7})/, "i");
    // Same as above, but matches the exact string (nothing before or after)
    const singleCellReference = new RegExp(/^\$?([A-Z]{1,3})\$?([0-9]{1,7})$/, "i");
    /** Reference of a column header (eg. A, AB, $A) */
    const colHeader = new RegExp(/^\$?([A-Z]{1,3})+$/, "i");
    /** Reference of a row header (eg. 1, $1) */
    const rowHeader = new RegExp(/^\$?([0-9]{1,7})+$/, "i");
    /** Reference of a column (eg. A, $CA, Sheet1!B) */
    const colReference = new RegExp(/^\s*('.+'!|[^']+!)?\$?([A-Z]{1,3})$/, "i");
    /** Reference of a row (eg. 1, 59, Sheet1!9) */
    const rowReference = new RegExp(/^\s*('.+'!|[^']+!)?\$?([0-9]{1,7})$/, "i");
    /** Reference of a normal range or a full row range (eg. A1:B1, 1:$5, $A2:5) */
    const fullRowXc = /(\$?[A-Z]{1,3})?\$?[0-9]{1,7}\s*:\s*(\$?[A-Z]{1,3})?\$?[0-9]{1,7}\s*/i;
    /** Reference of a normal range or a column row range (eg. A1:B1, A:$B, $A1:C) */
    const fullColXc = /\$?[A-Z]{1,3}(\$?[0-9]{1,7})?\s*:\s*\$?[A-Z]{1,3}(\$?[0-9]{1,7})?\s*/i;
    /** Reference of a cell or a range, it can be a bounded range, a full row or a full column */
    const rangeReference = new RegExp(/^\s*('.+'!|[^']+!)?/.source +
        "(" +
        [cellReference.source, fullRowXc.source, fullColXc.source].join("|") +
        ")" +
        /$/.source, "i");
    /**
     * Return true if the given xc is the reference of a column (e.g. A or AC or Sheet1!A)
     */
    function isColReference(xc) {
        return colReference.test(xc);
    }
    /**
     * Return true if the given xc is the reference of a column (e.g. 1 or Sheet1!1)
     */
    function isRowReference(xc) {
        return rowReference.test(xc);
    }
    function isColHeader(str) {
        return colHeader.test(str);
    }
    function isRowHeader(str) {
        return rowHeader.test(str);
    }
    /**
     * Return true if the given xc is the reference of a single cell,
     * without any specified sheet (e.g. A1)
     */
    function isSingleCellReference(xc) {
        return singleCellReference.test(xc);
    }
    function splitReference(ref) {
        const parts = ref.split("!");
        const xc = parts.pop();
        const sheetName = getUnquotedSheetName(parts.join("!")) || undefined;
        return { sheetName, xc };
    }

    /**
     * Convert from a cartesian reference to a Zone
     * The range boundaries will be kept in the same order as the
     * ones in the text.
     * Examples:
     *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
     *    "B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
     *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
     *    "Sheet1!B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
     *    "C3:A1" ==> Top 2, Bottom 0, Left 2, Right 0
     *    "A:A" ==> Top 0, Bottom undefined, Left 0, Right 0
     *    "A:B3" or "B3:A" ==> Top 2, Bottom undefined, Left 0, Right 1
     *
     * @param xc the string reference to convert
     *
     */
    function toZoneWithoutBoundaryChanges(xc) {
        if (xc.includes("!")) {
            xc = xc.split("!").at(-1);
        }
        if (xc.includes("$")) {
            xc = xc.replaceAll("$", "");
        }
        let firstRangePart = "";
        let secondRangePart;
        if (xc.includes(":")) {
            [firstRangePart, secondRangePart] = xc.split(":");
            firstRangePart = firstRangePart.trim();
            secondRangePart = secondRangePart.trim();
        }
        else {
            firstRangePart = xc.trim();
        }
        let top, bottom, left, right;
        let fullCol = false;
        let fullRow = false;
        let hasHeader = false;
        if (isColReference(firstRangePart)) {
            left = right = lettersToNumber(firstRangePart);
            top = bottom = 0;
            fullCol = true;
        }
        else if (isRowReference(firstRangePart)) {
            top = bottom = parseInt(firstRangePart, 10) - 1;
            left = right = 0;
            fullRow = true;
        }
        else {
            const c = toCartesian(firstRangePart);
            left = right = c.col;
            top = bottom = c.row;
            hasHeader = true;
        }
        if (secondRangePart) {
            if (isColReference(secondRangePart)) {
                right = lettersToNumber(secondRangePart);
                fullCol = true;
            }
            else if (isRowReference(secondRangePart)) {
                bottom = parseInt(secondRangePart, 10) - 1;
                fullRow = true;
            }
            else {
                const c = toCartesian(secondRangePart);
                right = c.col;
                bottom = c.row;
                top = fullCol ? bottom : top;
                left = fullRow ? right : left;
                hasHeader = true;
            }
        }
        if (fullCol && fullRow) {
            throw new Error("Wrong zone xc. The zone cannot be at the same time a full column and a full row");
        }
        const zone = {
            top,
            left,
            bottom: fullCol ? undefined : bottom,
            right: fullRow ? undefined : right,
        };
        hasHeader = hasHeader && (fullRow || fullCol);
        if (hasHeader) {
            zone.hasHeader = hasHeader;
        }
        return zone;
    }
    /**
     * Convert from a cartesian reference to a (possibly unbounded) Zone
     *
     * Examples:
     *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
     *    "B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
     *    "B:B" ==> Top 0, Bottom undefined, Left: 1, Right: 1
     *    "B2:B" ==> Top 1, Bottom undefined, Left: 1, Right: 1, hasHeader: 1
     *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
     *    "Sheet1!B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
     *
     * @param xc the string reference to convert
     *
     */
    function toUnboundedZone(xc) {
        const zone = toZoneWithoutBoundaryChanges(xc);
        reorderZone(zone);
        return zone;
    }
    function reorderZone(zone) {
        if (zone.right !== undefined && zone.right < zone.left) {
            const right = zone.left;
            zone.left = zone.right;
            zone.right = right;
        }
        if (zone.bottom !== undefined && zone.bottom < zone.top) {
            const bottom = zone.top;
            zone.top = zone.bottom;
            zone.bottom = bottom;
        }
    }
    /**
     * Convert from a cartesian reference to a Zone.
     * Will return throw an error if given a unbounded zone (eg : A:A).
     *
     * Examples:
     *    "A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
     *    "B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
     *    "Sheet1!A1" ==> Top 0, Bottom 0, Left: 0, Right: 0
     *    "Sheet1!B1:B3" ==> Top 0, Bottom 3, Left: 1, Right: 1
     *
     * @param xc the string reference to convert
     *
     */
    function toZone(xc) {
        const zone = toUnboundedZone(xc);
        if (zone.bottom === undefined || zone.right === undefined) {
            throw new Error("This does not support unbounded ranges");
        }
        return zone;
    }
    /**
     * Check that the zone has valid coordinates and in
     * the correct order.
     */
    function isZoneValid(zone) {
        // Typescript *should* prevent this kind of errors but
        // it's better to be on the safe side at runtime as well.
        const { bottom, top, left, right } = zone;
        if ((bottom !== undefined && isNaN(bottom)) ||
            isNaN(top) ||
            isNaN(left) ||
            (right !== undefined && isNaN(right))) {
            return false;
        }
        return isZoneOrdered(zone) && zone.top >= 0 && zone.left >= 0;
    }
    /**
     * Check that the zone properties are in the correct order.
     */
    function isZoneOrdered(zone) {
        return ((zone.bottom === undefined || (zone.bottom >= zone.top && zone.bottom >= 0)) &&
            (zone.right === undefined || (zone.right >= zone.left && zone.right >= 0)));
    }
    /**
     * Convert from zone to a cartesian reference
     *
     */
    function zoneToXc(zone) {
        const { top, bottom, left, right } = zone;
        const hasHeader = "hasHeader" in zone ? zone.hasHeader : false;
        const isOneCell = top === bottom && left === right;
        if (bottom === undefined && right !== undefined) {
            return top === 0 && !hasHeader
                ? `${numberToLetters(left)}:${numberToLetters(right)}`
                : `${toXC(left, top)}:${numberToLetters(right)}`;
        }
        else if (right === undefined && bottom !== undefined) {
            return left === 0 && !hasHeader
                ? `${top + 1}:${bottom + 1}`
                : `${toXC(left, top)}:${bottom + 1}`;
        }
        else if (bottom !== undefined && right !== undefined) {
            return isOneCell ? toXC(left, top) : `${toXC(left, top)}:${toXC(right, bottom)}`;
        }
        throw new Error(_t("Bad zone format"));
    }
    /**
     * Expand a zone after inserting columns or rows.
     *
     * Don't resize the zone if a col/row was added right before/after the row but only move the zone.
     */
    function expandZoneOnInsertion(zone, start, base, position, quantity) {
        const dimension = start === "left" ? "columns" : "rows";
        const baseElement = position === "before" ? base - 1 : base;
        const end = start === "left" ? "right" : "bottom";
        const zoneEnd = zone[end];
        if (zone[start] <= baseElement && zoneEnd && zoneEnd > baseElement) {
            return createAdaptedZone(zone, dimension, "RESIZE", quantity);
        }
        if (baseElement < zone[start]) {
            return createAdaptedZone(zone, dimension, "MOVE", quantity);
        }
        return { ...zone };
    }
    /**
     * Update the selection after column/row addition
     */
    function updateSelectionOnInsertion(selection, start, base, position, quantity) {
        const dimension = start === "left" ? "columns" : "rows";
        const baseElement = position === "before" ? base - 1 : base;
        const end = start === "left" ? "right" : "bottom";
        if (selection[start] <= baseElement && selection[end] > baseElement) {
            return createAdaptedZone(selection, dimension, "RESIZE", quantity);
        }
        if (baseElement < selection[start]) {
            return createAdaptedZone(selection, dimension, "MOVE", quantity);
        }
        return { ...selection };
    }
    /**
     * Update the selection after column/row deletion
     */
    function updateSelectionOnDeletion(zone, start, elements) {
        const end = start === "left" ? "right" : "bottom";
        let newStart = zone[start];
        let newEnd = zone[end];
        for (let removedElement of elements.sort((a, b) => b - a)) {
            if (zone[start] > removedElement) {
                newStart--;
                newEnd--;
            }
            if (zone[start] < removedElement && zone[end] >= removedElement) {
                newEnd--;
            }
        }
        return { ...zone, [start]: newStart, [end]: newEnd };
    }
    /**
     * Reduce a zone after deletion of elements
     */
    function reduceZoneOnDeletion(zone, start, elements) {
        const end = start === "left" ? "right" : "bottom";
        let newStart = zone[start];
        let newEnd = zone[end];
        const zoneEnd = zone[end];
        for (let removedElement of elements.sort((a, b) => b - a)) {
            if (zone[start] > removedElement) {
                newStart--;
                if (newEnd !== undefined)
                    newEnd--;
            }
            if (zoneEnd !== undefined &&
                newEnd !== undefined &&
                zone[start] <= removedElement &&
                zoneEnd >= removedElement) {
                newEnd--;
            }
        }
        if (newEnd !== undefined && newStart > newEnd) {
            return undefined;
        }
        return { ...zone, [start]: newStart, [end]: newEnd };
    }
    /**
     * Compute the union of multiple zones.
     */
    function union(...zones) {
        return {
            top: Math.min(...zones.map((zone) => zone.top)),
            left: Math.min(...zones.map((zone) => zone.left)),
            bottom: Math.max(...zones.map((zone) => zone.bottom)),
            right: Math.max(...zones.map((zone) => zone.right)),
        };
    }
    /**
     * Compute the intersection of two zones. Returns nothing if the two zones don't overlap
     */
    function intersection(z1, z2) {
        if (!overlap(z1, z2)) {
            return undefined;
        }
        return {
            top: Math.max(z1.top, z2.top),
            left: Math.max(z1.left, z2.left),
            bottom: Math.min(z1.bottom, z2.bottom),
            right: Math.min(z1.right, z2.right),
        };
    }
    /**
     * Two zones are equal if they represent the same area, so we clearly cannot use
     * reference equality.
     */
    function isEqual(z1, z2) {
        return (z1.left === z2.left && z1.right === z2.right && z1.top === z2.top && z1.bottom === z2.bottom);
    }
    /**
     * Return true if two zones overlap, false otherwise.
     */
    function overlap(z1, z2) {
        if (z1.bottom < z2.top || z2.bottom < z1.top) {
            return false;
        }
        if (z1.right < z2.left || z2.right < z1.left) {
            return false;
        }
        return true;
    }
    function isInside(col, row, zone) {
        const { left, right, top, bottom } = zone;
        return col >= left && col <= right && row >= top && row <= bottom;
    }
    /**
     * Check if a zone is inside another
     */
    function isZoneInside(smallZone, biggerZone) {
        return isEqual(union(biggerZone, smallZone), biggerZone);
    }
    /**
     * Recompute the ranges of the zone to contain all the cells in zones, without the cells in toRemoveZones
     * Also regroup zones together to shorten the string
     */
    function recomputeZones(zonesXc, toRemoveZonesXc) {
        const zones = zonesXc.map(toUnboundedZone);
        const zonesToRemove = toRemoveZonesXc.map(toUnboundedZone);
        // Compute the max to replace the bottom of full columns and right of full rows by something
        // bigger than any other col/row to be able to apply the algorithm while keeping tracks of what
        // zones are full cols/rows
        const maxBottom = Math.max(...zones.concat(zonesToRemove).map((zone) => zone.bottom || 0));
        const maxRight = Math.max(...zones.concat(zonesToRemove).map((zone) => zone.right || 0));
        const expandedZones = zones.map((zone) => ({
            ...zone,
            bottom: zone.bottom === undefined ? maxBottom + 1 : zone.bottom,
            right: zone.right === undefined ? maxRight + 1 : zone.right,
        }));
        const expandedZonesToRemove = zonesToRemove.map((zone) => ({
            ...zone,
            bottom: zone.bottom === undefined ? maxBottom + 1 : zone.bottom,
            right: zone.right === undefined ? maxRight + 1 : zone.right,
        }));
        const zonePositions = expandedZones.map(positions).flat();
        const positionsToRemove = expandedZonesToRemove.map(positions).flat();
        const positionToKeep = positionsDifference(zonePositions, positionsToRemove);
        const columns = mergePositionsIntoColumns(positionToKeep);
        return mergeAlignedColumns(columns)
            .map((zone) => ({
            ...zone,
            bottom: zone.bottom === maxBottom + 1 ? undefined : zone.bottom,
            right: zone.right === maxRight + 1 ? undefined : zone.right,
        }))
            .map(zoneToXc);
    }
    /**
     * Merge aligned adjacent columns into single zones
     * e.g. A1:A5 and B1:B5 are merged into A1:B5
     */
    function mergeAlignedColumns(columns) {
        if (columns.length === 0) {
            return [];
        }
        if (columns.some((zone) => zone.left !== zone.right)) {
            throw new Error("only columns can be merged");
        }
        const done = [];
        const cols = removeRedundantZones(columns);
        const isAdjacentAndAligned = (zone, nextZone) => zone.top === nextZone.top &&
            zone.bottom === nextZone.bottom &&
            zone.right + 1 === nextZone.left;
        while (cols.length) {
            const merged = cols.reduce((zone, nextZone) => (isAdjacentAndAligned(zone, nextZone) ? union(zone, nextZone) : zone), cols.shift());
            done.push(merged);
        }
        return removeRedundantZones(done);
    }
    /**
     * Remove redundant zones in the list.
     * i.e. zones included in another zone.
     */
    function removeRedundantZones(zones) {
        const sortedZones = [...zones]
            .sort((a, b) => b.right - a.right)
            .sort((a, b) => b.bottom - a.bottom)
            .sort((a, b) => a.top - b.top)
            .sort((a, b) => a.left - b.left)
            .reverse();
        const checked = [];
        while (sortedZones.length !== 0) {
            const zone = sortedZones.shift();
            const isIncludedInOther = sortedZones.some((otherZone) => isZoneInside(zone, otherZone));
            if (!isIncludedInOther) {
                checked.push(zone);
            }
        }
        return checked.reverse();
    }
    /**
     * Merge adjacent positions into vertical zones (columns)
     */
    function mergePositionsIntoColumns(positions) {
        if (positions.length === 0) {
            return [];
        }
        const [startingPosition, ...sortedPositions] = [...positions]
            .sort((a, b) => a.row - b.row)
            .sort((a, b) => a.col - b.col);
        const done = [];
        let active = positionToZone(startingPosition);
        for (const { col, row } of sortedPositions) {
            if (isInside(col, row, active)) {
                continue;
            }
            else if (col === active.left && row === active.bottom + 1) {
                const bottom = active.bottom + 1;
                active = { ...active, bottom };
            }
            else {
                done.push(active);
                active = positionToZone({ col, row });
            }
        }
        return [...done, active];
    }
    /**
     * Returns positions in the first array which are not in the second array.
     */
    function positionsDifference(positions, toRemove) {
        const forbidden = new Set(toRemove.map(({ col, row }) => `${col}-${row}`));
        return positions.filter(({ col, row }) => !forbidden.has(`${col}-${row}`));
    }
    function zoneToDimension(zone) {
        return {
            numberOfRows: zone.bottom - zone.top + 1,
            numberOfCols: zone.right - zone.left + 1,
        };
    }
    function isOneDimensional(zone) {
        const { numberOfCols, numberOfRows } = zoneToDimension(zone);
        return numberOfCols === 1 || numberOfRows === 1;
    }
    /**
     * Array of all positions in the zone.
     */
    function positions(zone) {
        const positions = [];
        const [left, right] = [zone.right, zone.left].sort((a, b) => a - b);
        const [top, bottom] = [zone.top, zone.bottom].sort((a, b) => a - b);
        for (const col of range(left, right + 1)) {
            for (const row of range(top, bottom + 1)) {
                positions.push({ col, row });
            }
        }
        return positions;
    }
    function forEachPositionsInZone(zone, callback) {
        const { left, right, top, bottom } = zone;
        for (let col = left; col <= right; col++) {
            for (let row = top; row <= bottom; row++) {
                callback(col, row);
            }
        }
    }
    /**
     * This function returns a zone with coordinates modified according to the change
     * applied to the zone. It may be possible to change the zone by resizing or moving
     * it according to different dimensions.
     *
     * @param zone the zone to modify
     * @param dimension the direction to change the zone among "columns", "rows" and
     * "both"
     * @param operation how to change the zone, modify its size "RESIZE" or modify
     * its location "MOVE"
     * @param by a number of how many units the change should be made. This parameter
     * takes the form of a two-number array when the dimension is "both"
     */
    function createAdaptedZone(zone, dimension, operation, by) {
        const offsetX = dimension === "both" ? by[0] : dimension === "columns" ? by : 0;
        const offsetY = dimension === "both" ? by[1] : dimension === "rows" ? by : 0;
        // For full columns/rows, we have to make the distinction between the one that have a header and
        // whose start should be moved (eg. A2:A), and those who don't (eg. A:A)
        // The only time we don't want to move the start of the zone is if the zone is a full column (or a full row)
        // without header and that we are adding/removing a row (or a column)
        const hasHeader = "hasHeader" in zone ? zone.hasHeader : false;
        let shouldStartBeMoved;
        if (isFullCol(zone) && !hasHeader) {
            shouldStartBeMoved = dimension !== "rows";
        }
        else if (isFullRow(zone) && !hasHeader) {
            shouldStartBeMoved = dimension !== "columns";
        }
        else {
            shouldStartBeMoved = true;
        }
        const newZone = { ...zone };
        if (shouldStartBeMoved && operation === "MOVE") {
            newZone["left"] += offsetX;
            newZone["top"] += offsetY;
        }
        if (newZone["right"] !== undefined) {
            newZone["right"] += offsetX;
        }
        if (newZone["bottom"] !== undefined) {
            newZone["bottom"] += offsetY;
        }
        return newZone;
    }
    /**
     * Returns a Zone array with unique occurrence of each zone.
     * For each multiple occurrence, the occurrence with the largest index is kept.
     * This allows to always have the last selection made in the last position.
     * */
    function uniqueZones(zones) {
        return zones
            .reverse()
            .filter((zone, index, self) => index ===
            self.findIndex((z) => z.top === zone.top &&
                z.bottom === zone.bottom &&
                z.left === zone.left &&
                z.right === zone.right))
            .reverse();
    }
    /**
     * This function will find all overlapping zones in an array and transform them
     * into an union of each one.
     * */
    function mergeOverlappingZones(zones) {
        return zones.reduce((dissociatedZones, zone) => {
            const nextIndex = dissociatedZones.length;
            for (let i = 0; i < nextIndex; i++) {
                if (overlap(dissociatedZones[i], zone)) {
                    dissociatedZones[i] = union(dissociatedZones[i], zone);
                    return dissociatedZones;
                }
            }
            dissociatedZones[nextIndex] = zone;
            return dissociatedZones;
        }, []);
    }
    /**
     * This function will compare the modifications of selection to determine
     * a cell that is part of the new zone and not the previous one.
     */
    function findCellInNewZone(oldZone, currentZone) {
        let col, row;
        const { left: oldLeft, right: oldRight, top: oldTop, bottom: oldBottom } = oldZone;
        const { left, right, top, bottom } = currentZone;
        if (left != oldLeft) {
            col = left;
        }
        else if (right != oldRight) {
            col = right;
        }
        else {
            // left and right don't change
            col = left;
        }
        if (top != oldTop) {
            row = top;
        }
        else if (bottom != oldBottom) {
            row = bottom;
        }
        else {
            // top and bottom don't change
            row = top;
        }
        return { col, row };
    }
    function organizeZone(zone) {
        return {
            top: Math.min(zone.top, zone.bottom),
            bottom: Math.max(zone.top, zone.bottom),
            left: Math.min(zone.left, zone.right),
            right: Math.max(zone.left, zone.right),
        };
    }
    function positionToZone(position) {
        return { left: position.col, right: position.col, top: position.row, bottom: position.row };
    }
    function isFullRow(zone) {
        return zone.right === undefined;
    }
    function isFullCol(zone) {
        return zone.bottom === undefined;
    }
    /** Returns the area of a zone */
    function getZoneArea(zone) {
        return (zone.bottom - zone.top + 1) * (zone.right - zone.left + 1);
    }
    /**
     * Check if the zones are continuous, ie. if they can be merged into a single zone without
     * including cells outside the zones
     * */
    function areZonesContinuous(...zones) {
        if (zones.length < 2)
            return true;
        return recomputeZones(zones.map(zoneToXc), []).length === 1;
    }
    /** Return all the columns in the given list of zones */
    function getZonesCols(zones) {
        const set = new Set();
        for (let zone of zones) {
            for (let col of range(zone.left, zone.right + 1)) {
                set.add(col);
            }
        }
        return set;
    }
    /** Return all the rows in the given list of zones */
    function getZonesRows(zones) {
        const set = new Set();
        for (let zone of zones) {
            for (let row of range(zone.top, zone.bottom + 1)) {
                set.add(row);
            }
        }
        return set;
    }

    class RangeImpl {
        getSheetSize;
        _zone;
        parts;
        invalidXc;
        prefixSheet = false;
        sheetId; // the sheet on which the range is defined
        invalidSheetName; // the name of any sheet that is invalid
        constructor(args, getSheetSize) {
            this.getSheetSize = getSheetSize;
            this._zone = args.zone;
            this.prefixSheet = args.prefixSheet;
            this.invalidXc = args.invalidXc;
            this.sheetId = args.sheetId;
            this.invalidSheetName = args.invalidSheetName;
            let _fixedParts = [...args.parts];
            if (args.parts.length === 1 && getZoneArea(this.zone) > 1) {
                _fixedParts.push({ ...args.parts[0] });
            }
            else if (args.parts.length === 2 && getZoneArea(this.zone) === 1) {
                _fixedParts.pop();
            }
            this.parts = _fixedParts;
        }
        static fromRange(range, getters) {
            if (range instanceof RangeImpl) {
                return range;
            }
            return new RangeImpl(range, getters.getSheetSize);
        }
        get unboundedZone() {
            return this._zone;
        }
        get zone() {
            const { left, top, bottom, right } = this._zone;
            if (right !== undefined && bottom !== undefined) {
                return this._zone;
            }
            else if (bottom === undefined && right !== undefined) {
                return { right, top, left, bottom: this.getSheetSize(this.sheetId).numberOfRows - 1 };
            }
            else if (right === undefined && bottom !== undefined) {
                return { bottom, left, top, right: this.getSheetSize(this.sheetId).numberOfCols - 1 };
            }
            throw new Error(_t("Bad zone format"));
        }
        static getRangeParts(xc, zone) {
            const parts = xc.split(":").map((p) => {
                const isFullRow = isRowReference(p);
                return {
                    colFixed: isFullRow ? false : p.startsWith("$"),
                    rowFixed: isFullRow ? p.startsWith("$") : p.includes("$", 1),
                };
            });
            const isFullCol = zone.bottom === undefined;
            const isFullRow = zone.right === undefined;
            if (isFullCol) {
                parts[0].rowFixed = parts[0].rowFixed || parts[1].rowFixed;
                parts[1].rowFixed = parts[0].rowFixed || parts[1].rowFixed;
            }
            if (isFullRow) {
                parts[0].colFixed = parts[0].colFixed || parts[1].colFixed;
                parts[1].colFixed = parts[0].colFixed || parts[1].colFixed;
            }
            return parts;
        }
        get isFullCol() {
            return this._zone.bottom === undefined;
        }
        get isFullRow() {
            return this._zone.right === undefined;
        }
        get rangeData() {
            return {
                _zone: this._zone,
                _sheetId: this.sheetId,
            };
        }
        /**
         * Check that a zone is valid regarding the order of top-bottom and left-right.
         * Left should be smaller than right, top should be smaller than bottom.
         * If it's not the case, simply invert them, and invert the linked parts
         */
        orderZone() {
            if (isZoneOrdered(this._zone)) {
                return this;
            }
            const zone = { ...this._zone };
            let parts = this.parts;
            if (zone.right !== undefined && zone.right < zone.left) {
                let right = zone.right;
                zone.right = zone.left;
                zone.left = right;
                parts = [
                    {
                        colFixed: parts[1]?.colFixed || false,
                        rowFixed: parts[0]?.rowFixed || false,
                    },
                    {
                        colFixed: parts[0]?.colFixed || false,
                        rowFixed: parts[1]?.rowFixed || false,
                    },
                ];
            }
            if (zone.bottom !== undefined && zone.bottom < zone.top) {
                let bottom = zone.bottom;
                zone.bottom = zone.top;
                zone.top = bottom;
                parts = [
                    {
                        colFixed: parts[0]?.colFixed || false,
                        rowFixed: parts[1]?.rowFixed || false,
                    },
                    {
                        colFixed: parts[1]?.colFixed || false,
                        rowFixed: parts[0]?.rowFixed || false,
                    },
                ];
            }
            return this.clone({ zone, parts });
        }
        /**
         *
         * @param rangeParams optional, values to put in the cloned range instead of the current values of the range
         */
        clone(rangeParams) {
            return new RangeImpl({
                zone: rangeParams?.zone ? rangeParams.zone : { ...this._zone },
                sheetId: rangeParams?.sheetId ? rangeParams.sheetId : this.sheetId,
                invalidSheetName: rangeParams && "invalidSheetName" in rangeParams // 'attr in obj' instead of just 'obj.attr' because we accept undefined values
                    ? rangeParams.invalidSheetName
                    : this.invalidSheetName,
                invalidXc: rangeParams && "invalidXc" in rangeParams ? rangeParams.invalidXc : this.invalidXc,
                parts: rangeParams?.parts
                    ? rangeParams.parts
                    : this.parts.map((part) => {
                        return { rowFixed: part.rowFixed, colFixed: part.colFixed };
                    }),
                prefixSheet: rangeParams?.prefixSheet ? rangeParams.prefixSheet : this.prefixSheet,
            }, this.getSheetSize);
        }
    }
    /**
     * Copy a range. If the range is on the sheetIdFrom, the range will target
     * sheetIdTo.
     */
    function copyRangeWithNewSheetId(sheetIdFrom, sheetIdTo, range) {
        const sheetId = range.sheetId === sheetIdFrom ? sheetIdTo : range.sheetId;
        return range.clone({ sheetId });
    }
    /**
     * Create a range from a xc. If the xc is empty, this function returns undefined.
     */
    function createValidRange(getters, sheetId, xc) {
        if (!xc)
            return;
        const range = getters.getRangeFromSheetXC(sheetId, xc);
        return !(range.invalidSheetName || range.invalidXc) ? range : undefined;
    }
    /**
     * Spread multiple colrows zone to one row/col zone and add a many new input range as needed.
     * For example, A1:B4 will become [A1:A4, B1:B4]
     */
    function spreadRange(getters, ranges) {
        const postProcessedRanges = [];
        for (const range of ranges) {
            if (!getters.isRangeValid(range)) {
                postProcessedRanges.push(range); // ignore invalid range
                continue;
            }
            const { sheetName } = splitReference(range);
            const sheetPrefix = sheetName ? `${sheetName}!` : "";
            const zone = toUnboundedZone(range);
            if (zone.bottom !== zone.top && zone.left != zone.right) {
                if (zone.right) {
                    for (let j = zone.left; j <= zone.right; ++j) {
                        postProcessedRanges.push(`${sheetPrefix}${zoneToXc({
                        left: j,
                        right: j,
                        top: zone.top,
                        bottom: zone.bottom,
                    })}`);
                    }
                }
                else {
                    for (let j = zone.top; j <= zone.bottom; ++j) {
                        postProcessedRanges.push(`${sheetPrefix}${zoneToXc({
                        left: zone.left,
                        right: zone.right,
                        top: j,
                        bottom: j,
                    })}`);
                    }
                }
            }
            else {
                postProcessedRanges.push(range);
            }
        }
        return postProcessedRanges;
    }
    /**
     * Get all the cell positions in the given ranges. If a cell is in multiple ranges, it will be returned multiple times.
     */
    function getCellPositionsInRanges(ranges) {
        const cellPositions = [];
        for (const range of ranges) {
            for (const position of positions(range.zone)) {
                cellPositions.push({ ...position, sheetId: range.sheetId });
            }
        }
        return cellPositions;
    }

    /** Methods from Odoo Web Utils  */
    /**
     * This function computes a score that represent the fact that the
     * string contains the pattern, or not
     *
     * - If the score is 0, the string does not contain the letters of the pattern in
     *   the correct order.
     * - if the score is > 0, it actually contains the letters.
     *
     * Better matches will get a higher score: consecutive letters are better,
     * and a match closer to the beginning of the string is also scored higher.
     */
    function fuzzyMatch(pattern, str) {
        pattern = pattern.toLocaleLowerCase();
        str = str.toLocaleLowerCase();
        let totalScore = 0;
        let currentScore = 0;
        let len = str.length;
        let patternIndex = 0;
        for (let i = 0; i < len; i++) {
            if (str[i] === pattern[patternIndex]) {
                patternIndex++;
                currentScore += 100 + currentScore - i / 200;
            }
            else {
                currentScore = 0;
            }
            totalScore = totalScore + currentScore;
        }
        return patternIndex === pattern.length ? totalScore : 0;
    }
    /**
     * Return a list of things that matches a pattern, ordered by their 'score' (
     * higher score first). An higher score means that the match is better. For
     * example, consecutive letters are considered a better match.
     */
    function fuzzyLookup(pattern, list, fn) {
        const results = [];
        list.forEach((data) => {
            const score = fuzzyMatch(pattern, fn(data));
            if (score > 0) {
                results.push({ score, elem: data });
            }
        });
        // we want better matches first
        results.sort((a, b) => b.score - a.score);
        return results.map((r) => r.elem);
    }

    function createDefaultRows(rowNumber) {
        const rows = [];
        for (let i = 0; i < rowNumber; i++) {
            const row = {
                cells: {},
            };
            rows.push(row);
        }
        return rows;
    }
    function moveHeaderIndexesOnHeaderAddition(indexHeaderAdded, numberAdded, headers) {
        return headers.map((header) => {
            if (header >= indexHeaderAdded) {
                return header + numberAdded;
            }
            return header;
        });
    }
    function moveHeaderIndexesOnHeaderDeletion(deletedHeaders, headers) {
        deletedHeaders = [...deletedHeaders].sort((a, b) => b - a);
        return headers
            .map((header) => {
            for (const deletedHeader of deletedHeaders) {
                if (header > deletedHeader) {
                    header--;
                }
                else if (header === deletedHeader) {
                    return undefined;
                }
            }
            return header;
        })
            .filter(isDefined$1);
    }
    function getNextSheetName(existingNames, baseName = "Sheet") {
        let i = 1;
        let name = `${baseName}${i}`;
        while (existingNames.includes(name)) {
            name = `${baseName}${i}`;
            i++;
        }
        return name;
    }
    function getDuplicateSheetName(nameToDuplicate, existingNames) {
        let i = 1;
        const baseName = _t("Copy of %s", nameToDuplicate);
        let name = baseName.toString();
        while (existingNames.includes(name)) {
            name = `${baseName} (${i})`;
            i++;
        }
        return name;
    }
    function isSheetNameEqual(name1, name2) {
        if (name1 === undefined || name2 === undefined) {
            return false;
        }
        return (getUnquotedSheetName(name1.trim().toUpperCase()) ===
            getUnquotedSheetName(name2.trim().toUpperCase()));
    }

    function computeTextLinesHeight(textLineHeight, numberOfLines = 1) {
        return numberOfLines * (textLineHeight + MIN_CELL_TEXT_MARGIN) - MIN_CELL_TEXT_MARGIN;
    }
    /**
     * Get the default height of the cell given its style.
     */
    function getDefaultCellHeight(ctx, cell, colSize) {
        if (!cell || (!cell.isFormula && !cell.content)) {
            return DEFAULT_CELL_HEIGHT;
        }
        const content = cell.isFormula ? "" : cell.content;
        return getCellContentHeight(ctx, content, cell.style, colSize);
    }
    function getCellContentHeight(ctx, content, style, colSize) {
        const maxWidth = style?.wrapping === "wrap" ? colSize - 2 * MIN_CELL_TEXT_MARGIN : undefined;
        const numberOfLines = splitTextToWidth(ctx, content, style, maxWidth).length;
        const fontSize = computeTextFontSizeInPixels(style);
        return computeTextLinesHeight(fontSize, numberOfLines) + 2 * PADDING_AUTORESIZE_VERTICAL;
    }
    const textWidthCache = {};
    function computeTextWidth(context, text, style) {
        const font = computeTextFont(style);
        if (!textWidthCache[font]) {
            textWidthCache[font] = {};
        }
        if (textWidthCache[font][text] === undefined) {
            context.save();
            context.font = font;
            const textWidth = context.measureText(text).width;
            context.restore();
            textWidthCache[font][text] = textWidth;
        }
        return textWidthCache[font][text];
    }
    function fontSizeInPixels(fontSize) {
        return Math.round((fontSize * 96) / 72);
    }
    function computeTextFont(style) {
        const italic = style.italic ? "italic " : "";
        const weight = style.bold ? "bold" : DEFAULT_FONT_WEIGHT;
        const size = computeTextFontSizeInPixels(style);
        return `${italic}${weight} ${size}px ${DEFAULT_FONT}`;
    }
    function computeTextFontSizeInPixels(style) {
        const sizeInPt = style?.fontSize || DEFAULT_FONT_SIZE;
        return fontSizeInPixels(sizeInPt);
    }
    function splitWordToSpecificWidth(ctx, word, width, style) {
        const wordWidth = computeTextWidth(ctx, word, style);
        if (wordWidth <= width) {
            return [word];
        }
        const splitWord = [];
        let wordPart = "";
        for (let l of word) {
            const wordPartWidth = computeTextWidth(ctx, wordPart + l, style);
            if (wordPartWidth > width) {
                splitWord.push(wordPart);
                wordPart = l;
            }
            else {
                wordPart += l;
            }
        }
        splitWord.push(wordPart);
        return splitWord;
    }
    /**
     * Return the given text, split in multiple lines if needed. The text will be split in multiple
     * line if it contains NEWLINE characters, or if it's longer than the given width.
     */
    function splitTextToWidth(ctx, text, style, width) {
        if (!style)
            style = {};
        if (isMarkdownLink(text))
            text = parseMarkdownLink(text).label;
        const brokenText = [];
        // Checking if text contains NEWLINE before split makes it very slightly slower if text contains it,
        // but 5-10x faster if it doesn't
        const lines = text.includes(NEWLINE) ? text.split(NEWLINE) : [text];
        for (const line of lines) {
            const words = line.includes(" ") ? line.split(" ") : [line];
            if (!width) {
                brokenText.push(line);
                continue;
            }
            let textLine = "";
            let availableWidth = width;
            for (let word of words) {
                const splitWord = splitWordToSpecificWidth(ctx, word, width, style);
                const lastPart = splitWord.pop();
                const lastPartWidth = computeTextWidth(ctx, lastPart, style);
                // At this step: "splitWord" is an array composed of parts of word whose
                // length is at most equal to "width".
                // Last part contains the end of the word.
                // Note that: When word length is less than width, then lastPart is equal
                // to word and splitWord is empty
                if (splitWord.length) {
                    if (textLine !== "") {
                        brokenText.push(textLine);
                        textLine = "";
                        availableWidth = width;
                    }
                    splitWord.forEach((wordPart) => {
                        brokenText.push(wordPart);
                    });
                    textLine = lastPart;
                    availableWidth = width - lastPartWidth;
                }
                else {
                    // here "lastPart" is equal to "word" and the "word" size is smaller than "width"
                    const _word = textLine === "" ? lastPart : " " + lastPart;
                    const wordWidth = computeTextWidth(ctx, _word, style);
                    if (wordWidth <= availableWidth) {
                        textLine += _word;
                        availableWidth -= wordWidth;
                    }
                    else {
                        brokenText.push(textLine);
                        textLine = lastPart;
                        availableWidth = width - lastPartWidth;
                    }
                }
            }
            if (textLine !== "") {
                brokenText.push(textLine);
            }
        }
        return brokenText;
    }
    /**
     * Return the font size that makes the width of a text match the given line width.
     * Minimum font size is 1.
     *
     * @param getTextWidth function that takes a fontSize as argument, and return the width of the text with this font size.
     */
    function getFontSizeMatchingWidth(lineWidth, maxFontSize, getTextWidth, precision = 0.25) {
        let minFontSize = 1;
        if (getTextWidth(minFontSize) > lineWidth)
            return minFontSize;
        if (getTextWidth(maxFontSize) < lineWidth)
            return maxFontSize;
        // Dichotomic search
        let fontSize = (minFontSize + maxFontSize) / 2;
        let currentTextWidth = getTextWidth(fontSize);
        // Use a maximum number of iterations to be safe, because measuring text isn't 100% precise
        let iterations = 0;
        while (Math.abs(currentTextWidth - lineWidth) > precision && iterations < 20) {
            if (currentTextWidth >= lineWidth) {
                maxFontSize = (minFontSize + maxFontSize) / 2;
            }
            else {
                minFontSize = (minFontSize + maxFontSize) / 2;
            }
            fontSize = (minFontSize + maxFontSize) / 2;
            currentTextWidth = getTextWidth(fontSize);
            iterations++;
        }
        return fontSize;
    }
    function computeIconWidth(style) {
        return computeTextFontSizeInPixels(style) + 2 * MIN_CF_ICON_MARGIN;
    }
    /** Transform a string to lower case. If the string is undefined, return an empty string */
    function toLowerCase(str) {
        return str ? str.toLowerCase() : "";
    }
    /**
     * Extract the fontSize from a context font string
     * @param font The (context) font string to parse
     * @returns The fontSize in pixels
     */
    const pxRegex = /([0-9\.]*)px/;
    function getContextFontSize(font) {
        return Number(font.match(pxRegex)?.[1]);
    }
    function drawDecoratedText(context, text, position, underline = false, strikethrough = false, strokeWidth = getContextFontSize(context.font) / 10 //This value is defined to get a good looking stroke
    ) {
        context.fillText(text, position.x, position.y);
        if (!underline && !strikethrough) {
            return;
        }
        const measure = context.measureText(text);
        const textWidth = measure.width;
        const textHeight = measure.actualBoundingBoxAscent + measure.actualBoundingBoxDescent;
        const boxHeight = measure.fontBoundingBoxAscent + measure.fontBoundingBoxDescent;
        let { x, y } = position;
        let strikeY = y, underlineY = y;
        switch (context.textAlign) {
            case "center":
                x -= textWidth / 2;
                break;
            case "right":
                x -= textWidth;
                break;
        }
        switch (context.textBaseline) {
            case "top":
                underlineY += boxHeight - 2 * strokeWidth;
                strikeY += boxHeight / 2 - strokeWidth;
                break;
            case "middle":
                underlineY += boxHeight / 2 - strokeWidth;
                break;
            case "alphabetic":
                underlineY += 2 * strokeWidth;
                strikeY -= 3 * strokeWidth;
                break;
            case "bottom":
                underlineY = y;
                strikeY -= textHeight / 2 - strokeWidth / 2;
                break;
        }
        if (underline) {
            context.lineWidth = strokeWidth;
            context.strokeStyle = context.fillStyle;
            context.beginPath();
            context.moveTo(x, underlineY);
            context.lineTo(x + textWidth, underlineY);
            context.stroke();
        }
        if (strikethrough) {
            context.lineWidth = strokeWidth;
            context.strokeStyle = context.fillStyle;
            context.beginPath();
            context.moveTo(x, strikeY);
            context.lineTo(x + textWidth, strikeY);
            context.stroke();
        }
    }

    /*
     * https://stackoverflow.com/questions/105034/create-guid-uuid-in-javascript
     * */
    class UuidGenerator {
        isFastIdStrategy = false;
        fastIdStart = 0;
        setIsFastStrategy(isFast) {
            this.isFastIdStrategy = isFast;
        }
        /**
         * Generates a custom UUID using a simple 26^8 method (8-character alphanumeric string with lowercase letters)
         * This has a higher chance of collision than a UUIDv4, but not only faster to generate than an UUIDV4,
         * it also has a smaller size, which is preferable to alleviate the overall data size.
         *
         * This method is preferable when generating uuids for the core data (sheetId, figureId, etc)
         * as they will appear several times in the revisions and local history.
         *
         */
        smallUuid() {
            if (this.isFastIdStrategy) {
                this.fastIdStart++;
                return String(this.fastIdStart);
            }
            else if (window.crypto) {
                return "10000000-1000".replace(/[01]/g, (c) => {
                    const n = Number(c);
                    return (n ^ (crypto.getRandomValues(new Uint8Array(1))[0] & (15 >> (n / 4)))).toString(16);
                });
            }
            else {
                // mainly for jest and other browsers that do not have the crypto functionality
                return "xxxxxxxx-xxxx".replace(/[xy]/g, function (c) {
                    var r = (Math.random() * 16) | 0, v = c == "x" ? r : (r & 0x3) | 0x8;
                    return v.toString(16);
                });
            }
        }
        /**
         * Generates an UUIDV4, has astronomically low chance of collision, but is larger in size than the smallUuid.
         * This method should be used when you need to avoid collisions at all costs, like the id of a revision.
         */
        uuidv4() {
            if (this.isFastIdStrategy) {
                this.fastIdStart++;
                return String(this.fastIdStart);
            }
            else if (window.crypto) {
                return "10000000-1000-4000-8000-100000000000".replace(/[018]/g, (c) => {
                    const n = Number(c);
                    return (n ^ (crypto.getRandomValues(new Uint8Array(1))[0] & (15 >> (n / 4)))).toString(16);
                });
            }
            else {
                // mainly for jest and other browsers that do not have the crypto functionality
                return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
                    var r = (Math.random() * 16) | 0, v = c == "x" ? r : (r & 0x3) | 0x8;
                    return v.toString(16);
                });
            }
        }
    }

    function createActions(menuItems) {
        return menuItems.map(createAction).sort((a, b) => a.sequence - b.sequence);
    }
    const uuidGenerator$2 = new UuidGenerator();
    function createAction(item) {
        const name = item.name;
        const children = item.children;
        const description = item.description;
        const icon = item.icon;
        return {
            id: item.id || uuidGenerator$2.uuidv4(),
            name: typeof name === "function" ? name : () => name,
            isVisible: item.isVisible ? item.isVisible : () => true,
            isEnabled: item.isEnabled ? item.isEnabled : () => true,
            isActive: item.isActive,
            execute: item.execute,
            children: children
                ? (env) => {
                    return children
                        .map((child) => (typeof child === "function" ? child(env) : child))
                        .flat()
                        .map(createAction);
                }
                : () => [],
            isReadonlyAllowed: item.isReadonlyAllowed || false,
            separator: item.separator || false,
            icon: typeof icon === "function" ? icon : () => icon || "",
            description: typeof description === "function" ? description : () => description || "",
            textColor: item.textColor,
            sequence: item.sequence || 0,
        };
    }

    function transformZone(zone, executed) {
        if (executed.type === "REMOVE_COLUMNS_ROWS") {
            return reduceZoneOnDeletion(zone, executed.dimension === "COL" ? "left" : "top", executed.elements);
        }
        if (executed.type === "ADD_COLUMNS_ROWS") {
            return expandZoneOnInsertion(zone, executed.dimension === "COL" ? "left" : "top", executed.base, executed.position, executed.quantity);
        }
        return zone;
    }
    function transformRangeData(range, executed) {
        const deletedSheet = executed.type === "DELETE_SHEET" && executed.sheetId;
        if ("sheetId" in executed && range._sheetId !== executed.sheetId) {
            return range;
        }
        else {
            const newZone = transformZone(range._zone, executed);
            if (newZone && deletedSheet !== range._sheetId) {
                return { ...range, _zone: newZone };
            }
        }
        return undefined;
    }

    class ChartJsComponent extends owl.Component {
        static template = "o-spreadsheet-ChartJsComponent";
        canvas = owl.useRef("graphContainer");
        chart;
        get background() {
            return this.chartRuntime.background;
        }
        get canvasStyle() {
            return `background-color: ${this.background}`;
        }
        get chartRuntime() {
            const runtime = this.env.model.getters.getChartRuntime(this.props.figure.id);
            if (!("chartJsConfig" in runtime)) {
                throw new Error("Unsupported chart runtime");
            }
            return runtime;
        }
        setup() {
            owl.onMounted(() => {
                const runtime = this.chartRuntime;
                // Note: chartJS modify the runtime in place, so it's important to give it a copy
                this.createChart(deepCopy(runtime.chartJsConfig));
            });
            owl.useEffect(() => this.updateChartJs(deepCopy(this.chartRuntime)), () => [this.chartRuntime, window.devicePixelRatio]);
        }
        createChart(chartData) {
            const canvas = this.canvas.el;
            const ctx = canvas.getContext("2d");
            // @ts-ignore
            this.chart = new window.Chart(ctx, chartData);
        }
        updateChartJs(chartRuntime) {
            const chartData = chartRuntime.chartJsConfig;
            if (chartData.data && chartData.data.datasets) {
                this.chart.data = chartData.data;
                if (chartData.options?.plugins?.title) {
                    this.chart.config.options.plugins.title = chartData.options.plugins.title;
                }
                if (chartData.options && "valueLabel" in chartData.options) {
                    if (chartData.options?.valueLabel) {
                        this.chart.config.options.valueLabel =
                            chartData.options.valueLabel;
                    }
                }
            }
            else {
                this.chart.data.datasets = [];
            }
            this.chart.config.options.plugins.tooltip = chartData.options.plugins.tooltip;
            this.chart.config.options.plugins.legend = chartData.options.plugins.legend;
            this.chart.config.options.scales = chartData.options?.scales;
            this.chart.update();
        }
    }
    ChartJsComponent.props = {
        figure: Object,
    };

    /**
     * AbstractChart is the class from which every Chart should inherit.
     * The role of this class is to maintain the state of each chart.
     */
    class AbstractChart {
        sheetId;
        title;
        getters;
        constructor(definition, sheetId, getters) {
            this.title = definition.title;
            this.sheetId = sheetId;
            this.getters = getters;
        }
        /**
         * Validate the chart definition given as arguments. This function will be
         * called from allowDispatch function
         */
        static validateChartDefinition(validator, definition) {
            throw new Error("This method should be implemented by sub class");
        }
        /**
         * Get a new chart definition transformed with the executed command. This
         * functions will be called during operational transform process
         */
        static transformDefinition(definition, executed) {
            throw new Error("This method should be implemented by sub class");
        }
        /**
         * Get an empty definition based on the given context
         */
        static getDefinitionFromContextCreation(context) {
            throw new Error("This method should be implemented by sub class");
        }
    }

    /**
     * This file contains helpers that are common to different charts (mainly
     * line, bar and pie charts)
     */
    /**
     * Adapt ranges of a chart which support DataSet (dataSets and LabelRange).
     */
    function updateChartRangesWithDataSets(getters, applyChange, chartDataSets, chartLabelRange) {
        let isStale = false;
        const dataSetsWithUndefined = [];
        for (let index in chartDataSets) {
            let ds = chartDataSets[index];
            if (ds.labelCell) {
                const labelCell = adaptChartRange(ds.labelCell, applyChange);
                if (ds.labelCell !== labelCell) {
                    isStale = true;
                    ds = {
                        ...ds,
                        labelCell: labelCell,
                    };
                }
            }
            const dataRange = adaptChartRange(ds.dataRange, applyChange);
            if (dataRange === undefined ||
                getters.getRangeString(dataRange, dataRange.sheetId) === INCORRECT_RANGE_STRING) {
                isStale = true;
                ds = undefined;
            }
            else if (dataRange !== ds.dataRange) {
                isStale = true;
                ds = {
                    ...ds,
                    dataRange,
                };
            }
            dataSetsWithUndefined[index] = ds;
        }
        let labelRange = chartLabelRange;
        const range = adaptChartRange(labelRange, applyChange);
        if (range !== labelRange) {
            isStale = true;
            labelRange = range;
        }
        const dataSets = dataSetsWithUndefined.filter(isDefined$1);
        return {
            isStale,
            dataSets,
            labelRange,
        };
    }
    /**
     * Copy the dataSets given. All the ranges which are on sheetIdFrom will target
     * sheetIdTo.
     */
    function copyDataSetsWithNewSheetId(sheetIdFrom, sheetIdTo, dataSets) {
        return dataSets.map((ds) => {
            return {
                dataRange: copyRangeWithNewSheetId(sheetIdFrom, sheetIdTo, ds.dataRange),
                labelCell: ds.labelCell
                    ? copyRangeWithNewSheetId(sheetIdFrom, sheetIdTo, ds.labelCell)
                    : undefined,
            };
        });
    }
    /**
     * Copy a range. If the range is on the sheetIdFrom, the range will target
     * sheetIdTo.
     */
    function copyLabelRangeWithNewSheetId(sheetIdFrom, sheetIdTo, range) {
        return range ? copyRangeWithNewSheetId(sheetIdFrom, sheetIdTo, range) : undefined;
    }
    /**
     * Adapt a single range of a chart
     */
    function adaptChartRange(range, applyChange) {
        if (!range) {
            return undefined;
        }
        const change = applyChange(range);
        switch (change.changeType) {
            case "NONE":
                return range;
            case "REMOVE":
                return undefined;
            default:
                return change.range;
        }
    }
    /**
     * Create the dataSet objects from xcs
     */
    function createDataSets(getters, dataSetsString, sheetId, dataSetsHaveTitle) {
        const dataSets = [];
        for (const sheetXC of dataSetsString) {
            const dataRange = getters.getRangeFromSheetXC(sheetId, sheetXC);
            const { unboundedZone: zone, sheetId: dataSetSheetId, invalidSheetName, invalidXc } = dataRange;
            if (invalidSheetName || invalidXc) {
                continue;
            }
            // It's a rectangle. We treat all columns (arbitrary) as different data series.
            if (zone.left !== zone.right && zone.top !== zone.bottom) {
                if (zone.right === undefined) {
                    // Should never happens because of the allowDispatch of charts, but just making sure
                    continue;
                }
                for (let column = zone.left; column <= zone.right; column++) {
                    const columnZone = {
                        ...zone,
                        left: column,
                        right: column,
                    };
                    dataSets.push(createDataSet(getters, dataSetSheetId, columnZone, dataSetsHaveTitle
                        ? {
                            top: columnZone.top,
                            bottom: columnZone.top,
                            left: columnZone.left,
                            right: columnZone.left,
                        }
                        : undefined));
                }
            }
            else {
                /* 1 cell, 1 row or 1 column */
                dataSets.push(createDataSet(getters, dataSetSheetId, zone, dataSetsHaveTitle
                    ? {
                        top: zone.top,
                        bottom: zone.top,
                        left: zone.left,
                        right: zone.left,
                    }
                    : undefined));
            }
        }
        return dataSets;
    }
    function createDataSet(getters, sheetId, fullZone, titleZone) {
        if (fullZone.left !== fullZone.right && fullZone.top !== fullZone.bottom) {
            throw new Error(`Zone should be a single column or row: ${zoneToXc(fullZone)}`);
        }
        if (titleZone) {
            const dataXC = zoneToXc(fullZone);
            const labelCellXC = zoneToXc(titleZone);
            return {
                labelCell: getters.getRangeFromSheetXC(sheetId, labelCellXC),
                dataRange: getters.getRangeFromSheetXC(sheetId, dataXC),
            };
        }
        else {
            return {
                labelCell: undefined,
                dataRange: getters.getRangeFromSheetXC(sheetId, zoneToXc(fullZone)),
            };
        }
    }
    /**
     * Transform a dataSet to a ExcelDataSet
     */
    function toExcelDataset(getters, ds) {
        const labelZone = ds.labelCell?.zone;
        let dataZone = ds.dataRange.zone;
        if (labelZone) {
            const { numberOfRows, numberOfCols } = zoneToDimension(dataZone);
            if (numberOfRows === 1) {
                dataZone = { ...dataZone, left: dataZone.left + 1 };
            }
            else if (numberOfCols === 1) {
                dataZone = { ...dataZone, top: dataZone.top + 1 };
            }
        }
        const dataRange = ds.dataRange.clone({ zone: dataZone });
        return {
            label: ds.labelCell
                ? getters.getRangeString(ds.labelCell, "forceSheetReference", { useFixedReference: true })
                : undefined,
            range: getters.getRangeString(dataRange, "forceSheetReference", { useFixedReference: true }),
        };
    }
    function toExcelLabelRange(getters, labelRange, shouldRemoveFirstLabel) {
        if (!labelRange)
            return undefined;
        let zone = {
            ...labelRange.zone,
        };
        if (shouldRemoveFirstLabel && labelRange.zone.bottom > labelRange.zone.top) {
            zone.top = zone.top + 1;
        }
        const range = labelRange.clone({ zone });
        return getters.getRangeString(range, "forceSheetReference", { useFixedReference: true });
    }
    /**
     * Transform a chart definition which supports dataSets (dataSets and LabelRange)
     * with an executed command
     */
    function transformChartDefinitionWithDataSetsWithZone(definition, executed) {
        let labelRange;
        if (definition.labelRange) {
            const labelZone = transformZone(toUnboundedZone(definition.labelRange), executed);
            labelRange = labelZone ? zoneToXc(labelZone) : undefined;
        }
        const dataSets = definition.dataSets
            .map(toUnboundedZone)
            .map((zone) => transformZone(zone, executed))
            .filter(isDefined$1)
            .map(zoneToXc);
        return {
            ...definition,
            labelRange,
            dataSets,
        };
    }
    const GraphColors = [
        // the same colors as those used in odoo reporting
        "rgb(31,119,180)",
        "rgb(255,127,14)",
        "rgb(174,199,232)",
        "rgb(255,187,120)",
        "rgb(44,160,44)",
        "rgb(152,223,138)",
        "rgb(214,39,40)",
        "rgb(255,152,150)",
        "rgb(148,103,189)",
        "rgb(197,176,213)",
        "rgb(140,86,75)",
        "rgb(196,156,148)",
        "rgb(227,119,194)",
        "rgb(247,182,210)",
        "rgb(127,127,127)",
        "rgb(199,199,199)",
        "rgb(188,189,34)",
        "rgb(219,219,141)",
        "rgb(23,190,207)",
        "rgb(158,218,229)",
    ];
    class ChartColors {
        graphColorIndex = 0;
        next() {
            return GraphColors[this.graphColorIndex++ % GraphColors.length];
        }
    }
    /**
     * Choose a font color based on a background color.
     * The font is white with a dark background.
     */
    function chartFontColor(backgroundColor) {
        if (!backgroundColor) {
            return "#000000";
        }
        return relativeLuminance(backgroundColor) < 0.3 ? "#FFFFFF" : "#000000";
    }
    function checkDataset(definition) {
        if (definition.dataSets) {
            const invalidRanges = definition.dataSets.find((range) => !rangeReference.test(range)) !== undefined;
            if (invalidRanges) {
                return "InvalidDataSet" /* CommandResult.InvalidDataSet */;
            }
            const zones = definition.dataSets.map(toUnboundedZone);
            if (zones.some((zone) => zone.top !== zone.bottom && isFullRow(zone))) {
                return "InvalidDataSet" /* CommandResult.InvalidDataSet */;
            }
        }
        return "Success" /* CommandResult.Success */;
    }
    function checkLabelRange(definition) {
        if (definition.labelRange) {
            const invalidLabels = !rangeReference.test(definition.labelRange || "");
            if (invalidLabels) {
                return "InvalidLabelRange" /* CommandResult.InvalidLabelRange */;
            }
        }
        return "Success" /* CommandResult.Success */;
    }
    function shouldRemoveFirstLabel(labelRange, dataset, dataSetsHaveTitle) {
        if (!dataSetsHaveTitle)
            return false;
        if (!labelRange)
            return false;
        if (!dataset)
            return true;
        const datasetLength = getZoneArea(dataset.dataRange.zone);
        const labelLength = getZoneArea(labelRange.zone);
        if (labelLength < datasetLength) {
            return false;
        }
        return true;
    }
    // ---------------------------------------------------------------------------
    // Scorecard
    // ---------------------------------------------------------------------------
    function getBaselineText(baseline, keyValue, baselineMode, locale) {
        if (!baseline) {
            return "";
        }
        else if (baselineMode === "text" ||
            keyValue?.type !== CellValueType.number ||
            baseline.type !== CellValueType.number) {
            return baseline.formattedValue;
        }
        else {
            let diff = keyValue.value - baseline.value;
            if (baselineMode === "percentage" && diff !== 0) {
                diff = (diff / baseline.value) * 100;
            }
            if (baselineMode !== "percentage" && baseline.format) {
                return formatValue(diff, { format: baseline.format, locale });
            }
            const baselineStr = Math.abs(parseFloat(diff.toFixed(2))).toLocaleString();
            return baselineMode === "percentage" ? baselineStr + "%" : baselineStr;
        }
    }
    function getBaselineColor(baseline, baselineMode, keyValue, colorUp, colorDown) {
        if (baselineMode === "text" ||
            baseline?.type !== CellValueType.number ||
            keyValue?.type !== CellValueType.number) {
            return undefined;
        }
        const diff = keyValue.value - baseline.value;
        if (diff > 0) {
            return colorUp;
        }
        else if (diff < 0) {
            return colorDown;
        }
        return undefined;
    }
    function getBaselineArrowDirection(baseline, keyValue, baselineMode) {
        if (baselineMode === "text" ||
            baseline?.type !== CellValueType.number ||
            keyValue?.type !== CellValueType.number) {
            return "neutral";
        }
        const diff = keyValue.value - baseline.value;
        if (diff > 0) {
            return "up";
        }
        else if (diff < 0) {
            return "down";
        }
        return "neutral";
    }
    function getChartPositionAtCenterOfViewport(getters, chartSize) {
        const { x, y } = getters.getMainViewportCoordinates();
        const { scrollX, scrollY } = getters.getActiveSheetScrollInfo();
        const { width, height } = getters.getVisibleRect(getters.getActiveMainViewport());
        const position = {
            x: x + scrollX + Math.max(0, (width - chartSize.width) / 2),
            y: y + scrollY + Math.max(0, (height - chartSize.height) / 2),
        }; // Position at the center of the scrollable viewport
        return position;
    }

    function checkKeyValue(definition) {
        return definition.keyValue && !rangeReference.test(definition.keyValue)
            ? "InvalidScorecardKeyValue" /* CommandResult.InvalidScorecardKeyValue */
            : "Success" /* CommandResult.Success */;
    }
    function checkBaseline(definition) {
        return definition.baseline && !rangeReference.test(definition.baseline)
            ? "InvalidScorecardBaseline" /* CommandResult.InvalidScorecardBaseline */
            : "Success" /* CommandResult.Success */;
    }
    const arrowDownPath = new window.Path2D("M8.6 4.8a.5.5 0 0 1 0 .75l-3.9 3.9a.5 .5 0 0 1 -.75 0l-3.8 -3.9a.5 .5 0 0 1 0 -.75l.4-.4a.5.5 0 0 1 .75 0l2.3 2.4v-5.7c0-.25.25-.5.5-.5h.6c.25 0 .5.25.5.5v5.8l2.3 -2.4a.5.5 0 0 1 .75 0z");
    const arrowUpPath = new window.Path2D("M8.7 5.5a.5.5 0 0 0 0-.75l-3.8-4a.5.5 0 0 0-.75 0l-3.8 4a.5.5 0 0 0 0 .75l.4.4a.5.5 0 0 0 .75 0l2.3-2.4v5.8c0 .25.25.5.5.5h.6c.25 0 .5-.25.5-.5v-5.8l2.2 2.4a.5.5 0 0 0 .75 0z");
    let ScorecardChart$1 = class ScorecardChart extends AbstractChart {
        keyValue;
        baseline;
        baselineMode;
        baselineDescr;
        background;
        baselineColorUp;
        baselineColorDown;
        fontColor;
        type = "scorecard";
        constructor(definition, sheetId, getters) {
            super(definition, sheetId, getters);
            this.keyValue = createValidRange(getters, sheetId, definition.keyValue);
            this.baseline = createValidRange(getters, sheetId, definition.baseline);
            this.baselineMode = definition.baselineMode;
            this.baselineDescr = definition.baselineDescr;
            this.background = definition.background;
            this.baselineColorUp = definition.baselineColorUp;
            this.baselineColorDown = definition.baselineColorDown;
        }
        static validateChartDefinition(validator, definition) {
            return validator.checkValidations(definition, checkKeyValue, checkBaseline);
        }
        static getDefinitionFromContextCreation(context) {
            return {
                background: context.background,
                type: "scorecard",
                keyValue: context.range ? context.range[0] : undefined,
                title: context.title || "",
                baselineMode: DEFAULT_SCORECARD_BASELINE_MODE,
                baselineColorUp: DEFAULT_SCORECARD_BASELINE_COLOR_UP,
                baselineColorDown: DEFAULT_SCORECARD_BASELINE_COLOR_DOWN,
                baseline: context.auxiliaryRange || "",
            };
        }
        static transformDefinition(definition, executed) {
            let baselineZone;
            let keyValueZone;
            if (definition.baseline) {
                baselineZone = transformZone(toUnboundedZone(definition.baseline), executed);
            }
            if (definition.keyValue) {
                keyValueZone = transformZone(toUnboundedZone(definition.keyValue), executed);
            }
            return {
                ...definition,
                baseline: baselineZone ? zoneToXc(baselineZone) : undefined,
                keyValue: keyValueZone ? zoneToXc(keyValueZone) : undefined,
            };
        }
        copyForSheetId(sheetId) {
            const baseline = copyLabelRangeWithNewSheetId(this.sheetId, sheetId, this.baseline);
            const keyValue = copyLabelRangeWithNewSheetId(this.sheetId, sheetId, this.keyValue);
            const definition = this.getDefinitionWithSpecificRanges(baseline, keyValue, sheetId);
            return new ScorecardChart(definition, sheetId, this.getters);
        }
        copyInSheetId(sheetId) {
            const definition = this.getDefinitionWithSpecificRanges(this.baseline, this.keyValue, sheetId);
            return new ScorecardChart(definition, sheetId, this.getters);
        }
        getDefinition() {
            return this.getDefinitionWithSpecificRanges(this.baseline, this.keyValue);
        }
        getContextCreation() {
            return {
                background: this.background,
                title: this.title,
                range: this.keyValue ? [this.getters.getRangeString(this.keyValue, this.sheetId)] : undefined,
                auxiliaryRange: this.baseline
                    ? this.getters.getRangeString(this.baseline, this.sheetId)
                    : undefined,
            };
        }
        getDefinitionWithSpecificRanges(baseline, keyValue, targetSheetId) {
            return {
                baselineColorDown: this.baselineColorDown,
                baselineColorUp: this.baselineColorUp,
                baselineMode: this.baselineMode,
                title: this.title,
                type: "scorecard",
                background: this.background,
                baseline: baseline
                    ? this.getters.getRangeString(baseline, targetSheetId || this.sheetId)
                    : undefined,
                baselineDescr: this.baselineDescr,
                keyValue: keyValue
                    ? this.getters.getRangeString(keyValue, targetSheetId || this.sheetId)
                    : undefined,
            };
        }
        getDefinitionForExcel() {
            // This kind of graph is not exportable in Excel
            return undefined;
        }
        updateRanges(applyChange) {
            const baseline = adaptChartRange(this.baseline, applyChange);
            const keyValue = adaptChartRange(this.keyValue, applyChange);
            if (this.baseline === baseline && this.keyValue === keyValue) {
                return this;
            }
            const definition = this.getDefinitionWithSpecificRanges(baseline, keyValue);
            return new ScorecardChart(definition, this.sheetId, this.getters);
        }
    };
    function drawScoreChart(structure, canvas) {
        const ctx = canvas.getContext("2d");
        const dpr = window.devicePixelRatio || 1;
        canvas.width = structure.canvas.width * dpr;
        canvas.height = structure.canvas.height * dpr;
        ctx.scale(dpr, dpr);
        ctx.fillStyle = structure.canvas.backgroundColor;
        ctx.fillRect(0, 0, structure.canvas.width, structure.canvas.height);
        if (structure.title) {
            ctx.font = structure.title.style.font;
            ctx.fillStyle = structure.title.style.color;
            ctx.fillText(structure.title.text, structure.title.position.x, structure.title.position.y);
        }
        if (structure.baseline) {
            ctx.font = structure.baseline.style.font;
            ctx.fillStyle = structure.baseline.style.color;
            drawDecoratedText(ctx, structure.baseline.text, structure.baseline.position, structure.baseline.style.underline, structure.baseline.style.strikethrough);
        }
        if (structure.baselineArrow && structure.baselineArrow.style.size > 0) {
            ctx.save();
            ctx.fillStyle = structure.baselineArrow.style.color;
            ctx.translate(structure.baselineArrow.position.x, structure.baselineArrow.position.y);
            // This ratio is computed according to the original svg size and the final size we want
            const ratio = structure.baselineArrow.style.size / 10;
            ctx.scale(ratio, ratio);
            switch (structure.baselineArrow.direction) {
                case "down": {
                    ctx.fill(arrowDownPath);
                    break;
                }
                case "up": {
                    ctx.fill(arrowUpPath);
                    break;
                }
            }
            ctx.restore();
        }
        if (structure.baselineDescr) {
            ctx.font = structure.baselineDescr.style.font;
            ctx.fillStyle = structure.baselineDescr.style.color;
            ctx.fillText(structure.baselineDescr.text, structure.baselineDescr.position.x, structure.baselineDescr.position.y);
        }
        if (structure.key) {
            ctx.font = structure.key.style.font;
            ctx.fillStyle = structure.key.style.color;
            drawDecoratedText(ctx, structure.key.text, structure.key.position, structure.key.style.underline, structure.key.style.strikethrough);
        }
    }
    function createScorecardChartRuntime(chart, getters) {
        let keyValue = "";
        let formattedKeyValue = "";
        let keyValueCell;
        if (chart.keyValue) {
            const keyValuePosition = {
                sheetId: chart.keyValue.sheetId,
                col: chart.keyValue.zone.left,
                row: chart.keyValue.zone.top,
            };
            keyValueCell = getters.getEvaluatedCell(keyValuePosition);
            keyValue = String(keyValueCell.value);
            formattedKeyValue = keyValueCell.formattedValue;
        }
        let baselineCell;
        const baseline = chart.baseline;
        if (baseline) {
            const baselinePosition = {
                sheetId: chart.baseline.sheetId,
                col: chart.baseline.zone.left,
                row: chart.baseline.zone.top,
            };
            baselineCell = getters.getEvaluatedCell(baselinePosition);
        }
        const { background, fontColor } = getters.getStyleOfSingleCellChart(chart.background, chart.keyValue);
        const locale = getters.getLocale();
        return {
            title: _t(chart.title),
            keyValue: formattedKeyValue || keyValue,
            baselineDisplay: getBaselineText(baselineCell, keyValueCell, chart.baselineMode, locale),
            baselineArrow: getBaselineArrowDirection(baselineCell, keyValueCell, chart.baselineMode),
            baselineColor: getBaselineColor(baselineCell, chart.baselineMode, keyValueCell, chart.baselineColorUp, chart.baselineColorDown),
            baselineDescr: chart.baselineDescr ? _t(chart.baselineDescr) : "",
            fontColor,
            background,
            baselineStyle: chart.baselineMode !== "percentage" && baseline
                ? getters.getCellStyle({
                    sheetId: baseline.sheetId,
                    col: baseline.zone.left,
                    row: baseline.zone.top,
                })
                : undefined,
            keyValueStyle: chart.keyValue
                ? getters.getCellStyle({
                    sheetId: chart.keyValue.sheetId,
                    col: chart.keyValue.zone.left,
                    row: chart.keyValue.zone.top,
                })
                : undefined,
        };
    }

    /* Sizes of boxes containing the texts, in percentage of the Chart size */
    const TITLE_FONT_SIZE = 18;
    const BASELINE_BOX_HEIGHT_RATIO = 0.35;
    const KEY_BOX_HEIGHT_RATIO = 0.65;
    /** Baseline description should have a smaller font than the baseline */
    const BASELINE_DESCR_FONT_RATIO = 0.9;
    /* Padding at the border of the chart, in percentage of the chart width */
    const CHART_PADDING_RATIO = 0.02;
    /**
     * Line height (in em)
     * Having a line heigh =1em (=font size) don't work, the font will overflow.
     */
    const LINE_HEIGHT = 1.2;
    function formatBaselineDescr(baselineDescr, baseline) {
        const _baselineDescr = baselineDescr || "";
        return baseline && _baselineDescr ? " " + _baselineDescr : _baselineDescr;
    }
    function getDefaultContextFont(fontSize, bold = false, italic = false) {
        const italicStr = italic ? "italic" : "";
        const weight = bold ? "bold" : "";
        return `${italicStr} ${weight} ${fontSize}px ${DEFAULT_FONT}`;
    }
    function getScorecardConfiguration({ width, height }, runtime) {
        const designer = new ScorecardChartConfigBuilder({ width, height }, runtime);
        return designer.computeDesign();
    }
    class ScorecardChartConfigBuilder {
        runtime;
        context;
        width;
        height;
        constructor({ width, height }, runtime) {
            this.runtime = runtime;
            const canvas = document.createElement("canvas");
            this.width = canvas.width = width;
            this.height = canvas.height = height;
            this.context = canvas.getContext("2d");
        }
        computeDesign() {
            const structure = {
                canvas: {
                    width: this.width,
                    height: this.height,
                    backgroundColor: this.backgroundColor,
                },
            };
            const style = this.getTextStyles();
            const { height: titleHeight } = this.getTextDimensions(this.title, style.title.font);
            if (this.title) {
                structure.title = {
                    text: this.title,
                    style: style.title,
                    position: {
                        x: this.chartPadding,
                        y: this.chartPadding + titleHeight,
                    },
                };
            }
            const baselineArrowSize = style.baselineArrow?.size ?? 0;
            const { height: baselineHeight, width: baselineWidth } = this.getTextDimensions(this.baseline, style.baselineValue.font);
            const { width: baselineDescrWidth } = this.getTextDimensions(this.baselineDescr, style.baselineDescr.font);
            structure.baseline = {
                text: this.baseline,
                style: style.baselineValue,
                position: {
                    x: (this.width - baselineWidth - baselineDescrWidth + baselineArrowSize) / 2,
                    y: this.keyValue
                        ? this.height - 2 * this.chartPadding
                        : this.height - (this.height - titleHeight - baselineHeight) / 2 - this.chartPadding,
                },
            };
            if (style.baselineArrow) {
                structure.baselineArrow = {
                    direction: this.baselineArrow,
                    style: style.baselineArrow,
                    position: {
                        x: structure.baseline.position.x - baselineArrowSize,
                        y: structure.baseline.position.y - (baselineHeight + baselineArrowSize) / 2,
                    },
                };
            }
            if (this.baselineDescr) {
                structure.baselineDescr = {
                    text: this.baselineDescr,
                    style: style.baselineDescr,
                    position: {
                        x: structure.baseline.position.x + baselineWidth,
                        y: structure.baseline.position.y,
                    },
                };
            }
            const { height: keyHeight, width: keyWidth } = this.getTextDimensions(this.keyValue, style.keyValue.font);
            if (this.keyValue) {
                structure.key = {
                    text: this.keyValue,
                    style: style.keyValue,
                    position: {
                        x: (this.width - keyWidth) / 2,
                        y: (this.height - baselineHeight + titleHeight + keyHeight) / 2 - this.chartPadding,
                    },
                };
            }
            return structure;
        }
        get title() {
            return this.runtime.title;
        }
        get keyValue() {
            return this.runtime.keyValue;
        }
        get baseline() {
            return this.runtime.baselineDisplay;
        }
        get baselineDescr() {
            return formatBaselineDescr(this.runtime.baselineDescr, this.baseline);
        }
        get baselineArrow() {
            return this.runtime.baselineArrow;
        }
        get backgroundColor() {
            return this.runtime.background;
        }
        get secondaryFontColor() {
            return relativeLuminance(this.backgroundColor) > 0.3 ? "#525252" : "#C8C8C8";
        }
        get chartPadding() {
            return this.width * CHART_PADDING_RATIO;
        }
        getTextDimensions(text, font) {
            this.context.font = font;
            const measure = this.context.measureText(text);
            return {
                width: measure.width,
                height: measure.actualBoundingBoxAscent + measure.actualBoundingBoxDescent,
            };
        }
        getTextStyles() {
            // If the widest text overflows horizontally, scale it down, and apply the same scaling factors to all the other fonts.
            const maxLineWidth = this.width * (1 - 2 * CHART_PADDING_RATIO);
            const widestElement = this.getWidestElement();
            const baseFontSize = widestElement.getElementMaxFontSize(this.getDrawableHeight(), this);
            const fontSizeMatchingWidth = getFontSizeMatchingWidth(maxLineWidth, baseFontSize, (fontSize) => widestElement.getElementWidth(fontSize, this.context, this));
            let scalingFactor = fontSizeMatchingWidth / baseFontSize;
            // Fonts sizes in px
            const keyFontSize = new KeyValueElement(this.runtime.keyValueStyle).getElementMaxFontSize(this.getDrawableHeight(), this) * scalingFactor;
            const baselineFontSize = new BaselineElement(this.runtime.baselineStyle).getElementMaxFontSize(this.getDrawableHeight(), this) * scalingFactor;
            return {
                title: {
                    font: getDefaultContextFont(TITLE_FONT_SIZE),
                    color: this.secondaryFontColor,
                },
                keyValue: {
                    color: this.runtime.keyValueStyle?.textColor || this.runtime.fontColor,
                    font: getDefaultContextFont(keyFontSize, this.runtime.keyValueStyle?.bold, this.runtime.keyValueStyle?.italic),
                    strikethrough: this.runtime.keyValueStyle?.strikethrough,
                    underline: this.runtime.keyValueStyle?.underline,
                },
                baselineValue: {
                    font: getDefaultContextFont(baselineFontSize, this.runtime.baselineStyle?.bold, this.runtime.baselineStyle?.italic),
                    strikethrough: this.runtime.baselineStyle?.strikethrough,
                    underline: this.runtime.baselineStyle?.underline,
                    color: this.runtime.baselineStyle?.textColor ||
                        this.runtime.baselineColor ||
                        this.secondaryFontColor,
                },
                baselineDescr: {
                    font: getDefaultContextFont(baselineFontSize * BASELINE_DESCR_FONT_RATIO),
                    color: this.secondaryFontColor,
                },
                baselineArrow: this.baselineArrow === "neutral"
                    ? undefined
                    : {
                        size: this.keyValue ? 0.8 * baselineFontSize : 0,
                        color: this.runtime.baselineColor || this.secondaryFontColor,
                    },
            };
        }
        /** Get the height of the chart minus all the vertical paddings */
        getDrawableHeight() {
            const verticalPadding = 2 * this.chartPadding;
            let availableHeight = this.height - verticalPadding;
            availableHeight -= this.title ? TITLE_FONT_SIZE * LINE_HEIGHT : 0;
            return availableHeight;
        }
        /** Return the element with he widest text in the chart */
        getWidestElement() {
            const baseline = new BaselineElement(this.runtime.baselineStyle);
            const keyValue = new KeyValueElement(this.runtime.keyValueStyle);
            return baseline.getElementWidth(BASELINE_BOX_HEIGHT_RATIO, this.context, this) >
                keyValue.getElementWidth(KEY_BOX_HEIGHT_RATIO, this.context, this)
                ? baseline
                : keyValue;
        }
    }
    class ScorecardScalableElement {
        style;
        constructor(style = {}) {
            this.style = style;
        }
        measureTextWidth(ctx, text, fontSize) {
            ctx.font = getDefaultContextFont(fontSize, this.style.bold, this.style.italic);
            return ctx.measureText(text).width;
        }
    }
    class BaselineElement extends ScorecardScalableElement {
        getElementWidth(fontSize, ctx, chart) {
            if (!chart.runtime) {
                return 0;
            }
            const baselineStr = chart.baseline;
            // Put mock text to simulate the width of the up/down arrow
            const largeText = chart.baselineArrow !== "neutral" ? "A " + baselineStr : baselineStr;
            let textWidth = this.measureTextWidth(ctx, largeText, fontSize);
            // Baseline descr font size should be smaller than baseline font size
            textWidth += this.measureTextWidth(ctx, chart.baselineDescr, fontSize * BASELINE_DESCR_FONT_RATIO);
            return textWidth;
        }
        getElementMaxFontSize(availableHeight, chart) {
            if (!chart.runtime) {
                return 0;
            }
            const haveBaseline = chart.baseline !== "" || chart.baselineDescr;
            const maxHeight = haveBaseline ? BASELINE_BOX_HEIGHT_RATIO * availableHeight : 0;
            return maxHeight / LINE_HEIGHT;
        }
    }
    class KeyValueElement extends ScorecardScalableElement {
        getElementWidth(fontSize, ctx, chart) {
            if (!chart.runtime) {
                return 0;
            }
            const str = chart.keyValue || "";
            return this.measureTextWidth(ctx, str, fontSize);
        }
        getElementMaxFontSize(availableHeight, chart) {
            if (!chart.runtime) {
                return 0;
            }
            const haveBaseline = chart.baseline !== "" || chart.baselineDescr;
            const maxHeight = haveBaseline ? KEY_BOX_HEIGHT_RATIO * availableHeight : availableHeight;
            return maxHeight / LINE_HEIGHT;
        }
    }

    class ScorecardChart extends owl.Component {
        static template = "o-spreadsheet-ScorecardChart";
        canvas = owl.useRef("chartContainer");
        get runtime() {
            return this.env.model.getters.getChartRuntime(this.props.figure.id);
        }
        setup() {
            owl.useEffect(this.createChart.bind(this), () => {
                const canvas = this.canvas.el;
                const rect = canvas.getBoundingClientRect();
                return [rect.width, rect.height, this.runtime, this.canvas.el, window.devicePixelRatio];
            });
        }
        createChart() {
            const canvas = this.canvas.el;
            const config = getScorecardConfiguration(canvas.getBoundingClientRect(), this.runtime);
            drawScoreChart(config, canvas);
        }
    }
    ScorecardChart.props = {
        figure: Object,
    };

    /**
     * Registry
     *
     * The Registry class is basically just a mapping from a string key to an object.
     * It is really not much more than an object. It is however useful for the
     * following reasons:
     *
     * 1. it let us react and execute code when someone add something to the registry
     *   (for example, the FunctionRegistry subclass this for this purpose)
     * 2. it throws an error when the get operation fails
     * 3. it provides a chained API to add items to the registry.
     */
    class Registry {
        content = {};
        /**
         * Add an item to the registry
         *
         * Note that this also returns the registry, so another add method call can
         * be chained
         */
        add(key, value) {
            this.content[key] = value;
            return this;
        }
        /**
         * Get an item from the registry
         */
        get(key) {
            /**
             * Note: key in {} is ~12 times slower than {}[key].
             * So, we check the absence of key only when the direct access returns
             * a falsy value. It's done to ensure that the registry can contains falsy values
             */
            const content = this.content[key];
            if (!content) {
                if (!(key in this.content)) {
                    throw new Error(`Cannot find ${key} in this registry!`);
                }
            }
            return content;
        }
        /**
         * Check if the key is already in the registry
         */
        contains(key) {
            return key in this.content;
        }
        /**
         * Get a list of all elements in the registry
         */
        getAll() {
            return Object.values(this.content);
        }
        /**
         * Get a list of all keys in the registry
         */
        getKeys() {
            return Object.keys(this.content);
        }
        /**
         * Remove an item from the registry
         */
        remove(key) {
            delete this.content[key];
        }
    }

    /**
     * Add the `https` prefix to the url if it's missing
     */
    function withHttps(url) {
        return !/^https?:\/\//i.test(url) ? `https://${url}` : url;
    }
    const urlRegistry = new Registry();
    function createWebLink(url, label) {
        url = withHttps(url);
        return {
            url,
            label: label || url,
            isExternal: true,
            isUrlEditable: true,
        };
    }
    urlRegistry.add("sheet_URL", {
        match: (url) => isSheetUrl(url),
        createLink: (url, label) => {
            return {
                label,
                url,
                isExternal: false,
                isUrlEditable: false,
            };
        },
        urlRepresentation(url, getters) {
            const sheetId = parseSheetUrl(url);
            return getters.tryGetSheetName(sheetId) || _t("Invalid sheet");
        },
        open(url, env) {
            const sheetId = parseSheetUrl(url);
            env.model.dispatch("ACTIVATE_SHEET", {
                sheetIdFrom: env.model.getters.getActiveSheetId(),
                sheetIdTo: sheetId,
            });
        },
        sequence: 0,
    });
    const WebUrlSpec = {
        createLink: createWebLink,
        match: (url) => isWebLink(url),
        open: (url) => window.open(url, "_blank"),
        urlRepresentation: (url) => url,
        sequence: 0,
    };
    function findMatchingSpec(url) {
        return (urlRegistry
            .getAll()
            .sort((a, b) => a.sequence - b.sequence)
            .find((urlType) => urlType.match(url)) || WebUrlSpec);
    }
    function urlRepresentation(link, getters) {
        return findMatchingSpec(link.url).urlRepresentation(link.url, getters);
    }
    function openLink(link, env) {
        findMatchingSpec(link.url).open(link.url, env);
    }
    function detectLink(value) {
        if (typeof value !== "string") {
            return undefined;
        }
        if (isMarkdownLink(value)) {
            const { label, url } = parseMarkdownLink(value);
            return findMatchingSpec(url).createLink(url, label);
        }
        else if (isWebLink(value)) {
            return createWebLink(value);
        }
        return undefined;
    }

    function evaluateLiteral(content, localeFormat) {
        return createEvaluatedCell(parseLiteral(content || "", localeFormat.locale), localeFormat);
    }
    function parseLiteral(content, locale) {
        if (content.startsWith("=")) {
            throw new Error(`Cannot parse "${content}" because it's not a literal value. It's a formula`);
        }
        if (isNumber(content, DEFAULT_LOCALE)) {
            return toNumber(content, DEFAULT_LOCALE);
        }
        else if (isDateTime(content, locale)) {
            return toNumber(content, locale);
        }
        else if (isBoolean(content)) {
            return content.toUpperCase() === "TRUE" ? true : false;
        }
        return content;
    }
    function createEvaluatedCell(value, localeFormat) {
        const link = detectLink(value);
        if (link) {
            return {
                ..._createEvaluatedCell(parseLiteral(link.label, localeFormat.locale), {
                    format: localeFormat.format ||
                        detectDateFormat(link.label, localeFormat.locale) ||
                        detectNumberFormat(link.label),
                    locale: localeFormat.locale,
                }),
                link,
            };
        }
        return _createEvaluatedCell(value, localeFormat);
    }
    function _createEvaluatedCell(value, localeFormat) {
        try {
            for (const builder of builders) {
                const evaluateCell = builder(value, localeFormat);
                if (evaluateCell) {
                    return evaluateCell;
                }
            }
            return textCell((value || "").toString(), localeFormat);
        }
        catch (error) {
            return errorCell(new EvaluationError(CellErrorType.GenericError, error.message || DEFAULT_ERROR_MESSAGE));
        }
    }
    function textCell(value, localeFormat) {
        return {
            type: CellValueType.text,
            value,
            format: localeFormat.format,
            isAutoSummable: true,
            defaultAlign: "left",
            formattedValue: formatValue(value, localeFormat),
        };
    }
    function numberCell(value, localeFormat) {
        return {
            type: CellValueType.number,
            value: value || 0, // necessary to avoid "-0" and NaN values,
            format: localeFormat.format,
            isAutoSummable: true,
            defaultAlign: "right",
            formattedValue: formatValue(value, localeFormat),
        };
    }
    const EMPTY_EVALUATED_CELL = {
        type: CellValueType.empty,
        value: "",
        format: undefined,
        isAutoSummable: true,
        defaultAlign: "left",
        formattedValue: "",
    };
    function emptyCell(localeFormat) {
        if (localeFormat.format === undefined) {
            // share the same object to save memory
            return EMPTY_EVALUATED_CELL;
        }
        return {
            type: CellValueType.empty,
            value: "",
            format: localeFormat.format,
            isAutoSummable: true,
            defaultAlign: "left",
            formattedValue: "",
        };
    }
    function dateTimeCell(value, localeFormat) {
        const formattedValue = formatValue(value, localeFormat);
        return {
            type: CellValueType.number,
            value,
            format: localeFormat.format,
            isAutoSummable: false,
            defaultAlign: "right",
            formattedValue,
        };
    }
    function booleanCell(value, localeFormat) {
        const formattedValue = value ? "TRUE" : "FALSE";
        return {
            type: CellValueType.boolean,
            value,
            format: localeFormat.format,
            isAutoSummable: false,
            defaultAlign: "center",
            formattedValue,
        };
    }
    function errorCell(error) {
        return {
            type: CellValueType.error,
            value: error.errorType,
            error,
            isAutoSummable: false,
            defaultAlign: "center",
            formattedValue: error.errorType,
        };
    }
    const builders = [
        function createEmpty(value, localeFormat) {
            if (value === "") {
                return emptyCell(localeFormat);
            }
            return undefined;
        },
        function createDateTime(value, localeFormat) {
            if (!!localeFormat.format &&
                typeof value === "number" &&
                isDateTimeFormat(localeFormat.format)) {
                return dateTimeCell(value, localeFormat);
            }
            return undefined;
        },
        function createNumber(value, localeFormat) {
            if (typeof value === "number") {
                return numberCell(value, localeFormat);
            }
            else if (value === null) {
                return numberCell(0, localeFormat);
            }
            return undefined;
        },
        function createBoolean(value, localeFormat) {
            if (typeof value === "boolean") {
                return booleanCell(value, localeFormat);
            }
            return undefined;
        },
    ];

    /**
     * An AutofillModifierImplementation is used to describe how to handle a
     * AutofillModifier.
     */
    const autofillModifiersRegistry = new Registry();
    autofillModifiersRegistry
        .add("ALPHANUMERIC_INCREMENT_MODIFIER", {
        apply: (rule, data) => {
            rule.current += rule.increment;
            const content = `${rule.prefix}${rule.current
            .toString()
            .padStart(rule.numberPostfixLength || 0, "0")}`;
            return {
                cellData: {
                    border: data.border,
                    style: data.cell && data.cell.style,
                    format: data.cell && data.cell.format,
                    content,
                },
                tooltip: { props: { content } },
            };
        },
    })
        .add("INCREMENT_MODIFIER", {
        apply: (rule, data, getters) => {
            rule.current += rule.increment;
            const content = rule.current.toString();
            const locale = getters.getLocale();
            const tooltipValue = formatValue(rule.current, { format: data.cell?.format, locale });
            return {
                cellData: {
                    border: data.border,
                    style: data.cell && data.cell.style,
                    format: data.cell && data.cell.format,
                    content,
                },
                tooltip: content ? { props: { content: tooltipValue } } : undefined,
            };
        },
    })
        .add("COPY_MODIFIER", {
        apply: (rule, data, getters) => {
            const content = data.cell?.content || "";
            const localeFormat = { locale: getters.getLocale(), format: data.cell?.format };
            return {
                cellData: {
                    border: data.border,
                    style: data.cell && data.cell.style,
                    format: data.cell && data.cell.format,
                    content,
                },
                tooltip: content
                    ? {
                        props: {
                            content: evaluateLiteral(data.cell?.content, localeFormat).formattedValue,
                        },
                    }
                    : undefined,
            };
        },
    })
        .add("FORMULA_MODIFIER", {
        apply: (rule, data, getters, direction) => {
            rule.current += rule.increment;
            let x = 0;
            let y = 0;
            switch (direction) {
                case "up" /* DIRECTION.UP */:
                    x = 0;
                    y = -rule.current;
                    break;
                case "down" /* DIRECTION.DOWN */:
                    x = 0;
                    y = rule.current;
                    break;
                case "left" /* DIRECTION.LEFT */:
                    x = -rule.current;
                    y = 0;
                    break;
                case "right" /* DIRECTION.RIGHT */:
                    x = rule.current;
                    y = 0;
                    break;
            }
            const cell = data.cell;
            if (!cell || !cell.isFormula) {
                return { cellData: {} };
            }
            const sheetId = data.sheetId;
            const content = getters.getTranslatedCellFormula(sheetId, x, y, cell.compiledFormula);
            return {
                cellData: {
                    border: data.border,
                    style: cell.style,
                    format: cell.format,
                    content,
                },
                tooltip: content ? { props: { content } } : undefined,
            };
        },
    });

    const autofillRulesRegistry = new Registry();
    const numberPostfixRegExp = /(\d+)$/;
    const stringPrefixRegExp = /^(.*\D+)/;
    const alphaNumericValueRegExp = /^(.*\D+)(\d+)$/;
    /**
     * Get the consecutive evaluated cells that can pass the filter function (e.g. certain type filter).
     * Return the one which contains the given cell
     */
    function getGroup(cell, cells, filter) {
        let group = [];
        let found = false;
        for (let x of cells) {
            if (x === cell) {
                found = true;
            }
            const cellValue = x?.isFormula
                ? undefined
                : evaluateLiteral(x?.content, { locale: DEFAULT_LOCALE });
            if (cellValue && filter(cellValue)) {
                group.push(cellValue);
            }
            else {
                if (found) {
                    return group;
                }
                group = [];
            }
        }
        return group;
    }
    /**
     * Get the average steps between numbers
     */
    function getAverageIncrement(group) {
        const averages = [];
        let last = group[0];
        for (let i = 1; i < group.length; i++) {
            const current = group[i];
            averages.push(current - last);
            last = current;
        }
        return averages.reduce((a, b) => a + b, 0) / averages.length;
    }
    /**
     * Get the step for a group
     */
    function calculateIncrementBasedOnGroup(group) {
        let increment = 1;
        if (group.length >= 2) {
            increment = getAverageIncrement(group) * group.length;
        }
        return increment;
    }
    autofillRulesRegistry
        .add("simple_value_copy", {
        condition: (cell, cells) => {
            return (cells.length === 1 && !cell.isFormula && !(cell.format && isDateTimeFormat(cell.format)));
        },
        generateRule: () => {
            return { type: "COPY_MODIFIER" };
        },
        sequence: 10,
    })
        .add("increment_alphanumeric_value", {
        condition: (cell) => !cell.isFormula &&
            evaluateLiteral(cell.content, { locale: DEFAULT_LOCALE }).type === CellValueType.text &&
            alphaNumericValueRegExp.test(cell.content),
        generateRule: (cell, cells, direction) => {
            const numberPostfix = parseInt(cell.content.match(numberPostfixRegExp)[0]);
            const prefix = cell.content.match(stringPrefixRegExp)[0];
            const numberPostfixLength = cell.content.length - prefix.length;
            const group = getGroup(cell, cells, (evaluatedCell) => evaluatedCell.type === CellValueType.text &&
                alphaNumericValueRegExp.test(evaluatedCell.value)) // get consecutive alphanumeric cells, no matter what the prefix is
                .filter((cell) => prefix === cell.value.toString().match(stringPrefixRegExp)[0])
                .map((cell) => parseInt(cell.value.toString().match(numberPostfixRegExp)[0]));
            let increment = calculateIncrementBasedOnGroup(group);
            if (["up", "left"].includes(direction) && group.length === 1) {
                increment = -increment;
            }
            return {
                type: "ALPHANUMERIC_INCREMENT_MODIFIER",
                prefix,
                current: numberPostfix,
                increment,
                numberPostfixLength,
            };
        },
        sequence: 15,
    })
        .add("copy_text", {
        condition: (cell) => !cell.isFormula &&
            evaluateLiteral(cell.content, { locale: DEFAULT_LOCALE }).type === CellValueType.text,
        generateRule: () => {
            return { type: "COPY_MODIFIER" };
        },
        sequence: 20,
    })
        .add("update_formula", {
        condition: (cell) => cell.isFormula,
        generateRule: (_, cells) => {
            return { type: "FORMULA_MODIFIER", increment: cells.length, current: 0 };
        },
        sequence: 30,
    })
        .add("increment_number", {
        condition: (cell) => !cell.isFormula &&
            evaluateLiteral(cell.content, { locale: DEFAULT_LOCALE }).type === CellValueType.number,
        generateRule: (cell, cells, direction) => {
            const group = getGroup(cell, cells, (evaluatedCell) => evaluatedCell.type === CellValueType.number).map((cell) => Number(cell.value));
            let increment = calculateIncrementBasedOnGroup(group);
            if (["up", "left"].includes(direction) && group.length === 1) {
                increment = -increment;
            }
            const evaluation = evaluateLiteral(cell.content, { locale: DEFAULT_LOCALE });
            return {
                type: "INCREMENT_MODIFIER",
                increment,
                current: evaluation.type === CellValueType.number ? evaluation.value : 0,
            };
        },
        sequence: 40,
    });

    /**
     * This file is largely inspired by owl 1.
     * `css` tag has been removed from owl 2 without workaround to manage css.
     * So, the solution was to import the behavior of owl 1 directly in our
     * codebase, with one difference: the css is added to the sheet as soon as the
     * css tag is executed. In owl 1, the css was added as soon as a Component was
     * created for the first time.
     */
    const STYLESHEETS = {};
    let nextId = 0;
    /**
     * CSS tag helper for defining inline stylesheets.  With this, one can simply define
     * an inline stylesheet with just the following code:
     * ```js
     *     css`.component-a { color: red; }`;
     * ```
     */
    function css(strings, ...args) {
        const name = `__sheet__${nextId++}`;
        const value = String.raw(strings, ...args);
        registerSheet(name, value);
        activateSheet(name);
        return name;
    }
    function processSheet(str) {
        const tokens = str.split(/(\{|\}|;)/).map((s) => s.trim());
        const selectorStack = [];
        const parts = [];
        let rules = [];
        function generateSelector(stackIndex, parentSelector) {
            const parts = [];
            for (const selector of selectorStack[stackIndex]) {
                let part = (parentSelector && parentSelector + " " + selector) || selector;
                if (part.includes("&")) {
                    part = selector.replace(/&/g, parentSelector || "");
                }
                if (stackIndex < selectorStack.length - 1) {
                    part = generateSelector(stackIndex + 1, part);
                }
                parts.push(part);
            }
            return parts.join(", ");
        }
        function generateRules() {
            if (rules.length) {
                parts.push(generateSelector(0) + " {");
                parts.push(...rules);
                parts.push("}");
                rules = [];
            }
        }
        while (tokens.length) {
            let token = tokens.shift();
            if (token === "}") {
                generateRules();
                selectorStack.pop();
            }
            else {
                if (tokens[0] === "{") {
                    generateRules();
                    selectorStack.push(token.split(/\s*,\s*/));
                    tokens.shift();
                }
                if (tokens[0] === ";") {
                    rules.push("  " + token + ";");
                }
            }
        }
        return parts.join("\n");
    }
    function registerSheet(id, css) {
        const sheet = document.createElement("style");
        sheet.textContent = processSheet(css);
        STYLESHEETS[id] = sheet;
    }
    function activateSheet(id) {
        const sheet = STYLESHEETS[id];
        sheet.setAttribute("component", id);
        document.head.appendChild(sheet);
    }
    function getTextDecoration({ strikethrough, underline, }) {
        if (!strikethrough && !underline) {
            return "none";
        }
        return `${strikethrough ? "line-through" : ""} ${underline ? "underline" : ""}`;
    }
    /**
     * Convert the cell style to CSS properties.
     */
    function cellStyleToCss(style) {
        const attributes = cellTextStyleToCss(style);
        if (!style)
            return attributes;
        if (style.fillColor) {
            attributes["background"] = style.fillColor;
        }
        return attributes;
    }
    /**
     * Convert the cell text style to CSS properties.
     */
    function cellTextStyleToCss(style) {
        const attributes = {};
        if (!style)
            return attributes;
        if (style.bold) {
            attributes["font-weight"] = "bold";
        }
        if (style.italic) {
            attributes["font-style"] = "italic";
        }
        if (style.strikethrough || style.underline) {
            let decoration = style.strikethrough ? "line-through" : "";
            decoration = style.underline ? decoration + " underline" : decoration;
            attributes["text-decoration"] = decoration;
        }
        if (style.textColor) {
            attributes["color"] = style.textColor;
        }
        return attributes;
    }
    /**
     * Transform CSS properties into a CSS string.
     */
    function cssPropertiesToCss(attributes) {
        let styleStr = "";
        for (const attName in attributes) {
            if (!attributes[attName]) {
                continue;
            }
            styleStr += `${attName}:${attributes[attName]}; `;
        }
        return styleStr;
    }
    function getElementMargins(el) {
        const style = window.getComputedStyle(el);
        const margins = {
            top: parseInt(style.marginTop, 10) || 0,
            bottom: parseInt(style.marginBottom, 10) || 0,
            left: parseInt(style.marginLeft, 10) || 0,
            right: parseInt(style.marginRight, 10) || 0,
        };
        return margins;
    }

    const ERROR_TOOLTIP_MAX_HEIGHT = 80;
    const ERROR_TOOLTIP_WIDTH = 180;
    css /* scss */ `
  .o-error-tooltip {
    font-size: 13px;
    background-color: white;
    border-left: 3px solid red;
    padding: 10px;
    width: ${ERROR_TOOLTIP_WIDTH}px;
    box-sizing: border-box !important;
    overflow-wrap: break-word;

    .o-error-tooltip-message {
      overflow: hidden;
    }
  }
`;
    class ErrorToolTip extends owl.Component {
        static maxSize = { maxHeight: ERROR_TOOLTIP_MAX_HEIGHT };
        static template = "o-spreadsheet-ErrorToolTip";
    }
    ErrorToolTip.props = {
        errors: Array,
        onClosed: { type: Function, optional: true },
    };
    const ErrorToolTipPopoverBuilder = {
        onHover: (position, getters) => {
            const cell = getters.getEvaluatedCell(position);
            const errors = [];
            if (cell.type === CellValueType.error && cell.error.isVerbose) {
                errors.push({
                    title: _t("Error"),
                    message: cell.error.message,
                });
            }
            const validationErrorMessage = getters.getInvalidDataValidationMessage(position);
            if (validationErrorMessage) {
                errors.push({
                    title: _t("Invalid"),
                    message: validationErrorMessage,
                });
            }
            if (!errors.length) {
                return { isOpen: false };
            }
            return {
                isOpen: true,
                props: { errors: errors },
                Component: ErrorToolTip,
                cellCorner: "TopRight",
            };
        },
    };

    css /*SCSS*/ `
  .o-filter-menu-value {
    padding: 4px;
    line-height: 20px;
    height: 28px;
    .o-filter-menu-value-checked {
      width: 20px;
    }
  }
`;
    class FilterMenuValueItem extends owl.Component {
        static template = "o-spreadsheet-FilterMenuValueItem";
        itemRef = owl.useRef("menuValueItem");
        setup() {
            owl.onWillPatch(() => {
                if (this.props.scrolledTo) {
                    this.scrollListToSelectedValue();
                }
            });
        }
        scrollListToSelectedValue() {
            if (!this.itemRef.el) {
                return;
            }
            this.itemRef.el.scrollIntoView?.({
                block: this.props.scrolledTo === "bottom" ? "end" : "start",
            });
        }
    }
    FilterMenuValueItem.props = {
        value: String,
        isChecked: Boolean,
        isSelected: Boolean,
        onMouseMove: Function,
        onClick: Function,
        scrolledTo: { type: String, optional: true },
    };

    const FILTER_MENU_HEIGHT = 295;
    const CSS$2 = css /* scss */ `
  .o-filter-menu {
    box-sizing: border-box;
    padding: 8px 16px;
    height: ${FILTER_MENU_HEIGHT}px;
    line-height: 1;

    .o-filter-menu-item {
      display: flex;
      box-sizing: border-box;
      height: ${MENU_ITEM_HEIGHT}px;
      padding: 4px 4px 4px 0px;
      cursor: pointer;
      user-select: none;

      &.selected {
        background-color: rgba(0, 0, 0, 0.08);
      }
    }

    input {
      box-sizing: border-box;
      margin-bottom: 5px;
      border: 1px solid #949494;
      height: 24px;
      padding-right: 28px;
    }

    .o-search-icon {
      right: 5px;
      top: 4px;
      opacity: 0.4;

      svg {
        height: 16px;
        width: 16px;
        vertical-align: middle;
      }
    }

    .o-filter-menu-actions {
      display: flex;
      flex-direction: row;
      margin-bottom: 4px;

      .o-filter-menu-action-text {
        cursor: pointer;
        margin-right: 10px;
        color: blue;
        text-decoration: underline;
      }
    }

    .o-filter-menu-list {
      flex: auto;
      overflow-y: auto;
      border: 1px solid #949494;

      .o-filter-menu-no-values {
        color: #949494;
        font-style: italic;
      }
    }

    .o-filter-menu-buttons {
      margin-top: 9px;

      .o-filter-menu-button {
        border: 1px solid lightgrey;
        padding: 6px 10px;
        cursor: pointer;
        border-radius: 4px;
        font-weight: 500;
        line-height: 16px;
      }

      .o-filter-menu-button-cancel {
        background: white;
        &:hover {
          background-color: rgba(0, 0, 0, 0.08);
        }
      }

      .o-filter-menu-button-primary {
        background-color: #188038;
        &:hover {
          background-color: #1d9641;
        }
        color: white;
        font-weight: bold;
        margin-left: 10px;
      }
    }
  }
`;
    class FilterMenu extends owl.Component {
        static size = { width: MENU_WIDTH, height: FILTER_MENU_HEIGHT };
        static template = "o-spreadsheet-FilterMenu";
        static style = CSS$2;
        static components = { FilterMenuValueItem };
        state = owl.useState({
            values: [],
            textFilter: "",
            selectedValue: undefined,
        });
        searchBar = owl.useRef("filterMenuSearchBar");
        setup() {
            owl.onWillUpdateProps((nextProps) => {
                if (!deepEquals(nextProps.filterPosition, this.props.filterPosition)) {
                    this.state.values = this.getFilterValues(nextProps.filterPosition);
                }
            });
            this.state.values = this.getFilterValues(this.props.filterPosition);
        }
        get isReadonly() {
            return this.env.model.getters.isReadonly();
        }
        getFilterValues(position) {
            const sheetId = this.env.model.getters.getActiveSheetId();
            const filter = this.env.model.getters.getFilter({ sheetId, ...position });
            if (!filter) {
                return [];
            }
            const cellValues = (filter.filteredZone ? positions(filter.filteredZone) : [])
                .filter(({ row }) => !this.env.model.getters.isRowHidden(sheetId, row))
                .map(({ col, row }) => this.env.model.getters.getEvaluatedCell({ sheetId, col, row }).formattedValue);
            const filterValues = this.env.model.getters.getFilterValues({ sheetId, ...position });
            const normalizedFilteredValues = new Set(filterValues.map(toLowerCase));
            const set = new Set();
            const values = [];
            const addValue = (value) => {
                const normalizedValue = toLowerCase(value);
                if (!set.has(normalizedValue)) {
                    values.push({
                        string: value || "",
                        checked: !normalizedFilteredValues.has(normalizedValue),
                        normalizedValue,
                    });
                    set.add(normalizedValue);
                }
            };
            cellValues.forEach(addValue);
            filterValues.forEach(addValue);
            return values.sort((val1, val2) => val1.normalizedValue.localeCompare(val2.normalizedValue, undefined, {
                numeric: true,
                sensitivity: "base",
            }));
        }
        checkValue(value) {
            this.state.selectedValue = value.string;
            value.checked = !value.checked;
            this.searchBar.el?.focus();
        }
        onMouseMove(value) {
            this.state.selectedValue = value.string;
        }
        selectAll() {
            this.displayedValues.forEach((value) => (value.checked = true));
        }
        clearAll() {
            this.displayedValues.forEach((value) => (value.checked = false));
        }
        get filterTable() {
            const sheetId = this.env.model.getters.getActiveSheetId();
            const position = this.props.filterPosition;
            return this.env.model.getters.getFilterTable({ sheetId, ...position });
        }
        get displayedValues() {
            if (!this.state.textFilter) {
                return this.state.values;
            }
            return fuzzyLookup(this.state.textFilter, this.state.values, (val) => val.string);
        }
        confirm() {
            const position = this.props.filterPosition;
            this.env.model.dispatch("UPDATE_FILTER", {
                ...position,
                sheetId: this.env.model.getters.getActiveSheetId(),
                hiddenValues: this.state.values.filter((val) => !val.checked).map((val) => val.string),
            });
            this.props.onClosed?.();
        }
        cancel() {
            this.props.onClosed?.();
        }
        onKeyDown(ev) {
            const displayedValues = this.displayedValues;
            if (displayedValues.length === 0)
                return;
            let selectedIndex = undefined;
            if (this.state.selectedValue !== undefined) {
                const index = displayedValues.findIndex((val) => val.string === this.state.selectedValue);
                selectedIndex = index === -1 ? undefined : index;
            }
            switch (ev.key) {
                case "ArrowDown":
                    if (selectedIndex === undefined) {
                        selectedIndex = 0;
                    }
                    else {
                        selectedIndex = Math.min(selectedIndex + 1, displayedValues.length - 1);
                    }
                    ev.preventDefault();
                    ev.stopPropagation();
                    break;
                case "ArrowUp":
                    if (selectedIndex === undefined) {
                        selectedIndex = displayedValues.length - 1;
                    }
                    else {
                        selectedIndex = Math.max(selectedIndex - 1, 0);
                    }
                    ev.preventDefault();
                    ev.stopPropagation();
                    break;
                case "Enter":
                    if (selectedIndex !== undefined) {
                        this.checkValue(displayedValues[selectedIndex]);
                    }
                    ev.stopPropagation();
                    ev.preventDefault();
                    break;
            }
            this.state.selectedValue =
                selectedIndex !== undefined ? displayedValues[selectedIndex].string : undefined;
            if (ev.key === "ArrowUp" || ev.key === "ArrowDown") {
                this.scrollListToSelectedValue(ev.key);
            }
        }
        clearScrolledToValue() {
            this.state.values.forEach((val) => (val.scrolledTo = undefined));
        }
        scrollListToSelectedValue(arrow) {
            this.clearScrolledToValue();
            const selectedValue = this.state.values.find((val) => val.string === this.state.selectedValue);
            if (selectedValue) {
                selectedValue.scrolledTo = arrow === "ArrowUp" ? "top" : "bottom";
            }
        }
        sortFilterZone(sortDirection) {
            const filterPosition = this.props.filterPosition;
            const filterTable = this.filterTable;
            if (!filterPosition || !filterTable || !filterTable.contentZone) {
                return;
            }
            const sheetId = this.env.model.getters.getActiveSheetId();
            this.env.model.dispatch("SORT_CELLS", {
                sheetId,
                col: filterPosition.col,
                row: filterTable.contentZone.top,
                zone: filterTable.contentZone,
                sortDirection,
                sortOptions: { emptyCellAsZero: true, sortHeaders: true },
            });
            this.props.onClosed?.();
        }
    }
    FilterMenu.props = {
        filterPosition: Object,
        onClosed: { type: Function, optional: true },
    };
    const FilterMenuPopoverBuilder = {
        onOpen: (position, getters) => {
            return {
                isOpen: true,
                props: { filterPosition: position },
                Component: FilterMenu,
                cellCorner: "BottomLeft",
            };
        },
    };

    const macRegex = /Mac/i;
    const MODIFIER_KEYS$1 = ["Shift", "Control", "Alt", "Meta"];
    /**
     * Return true if the event was triggered from
     * a child element.
     */
    function isChildEvent(parent, ev) {
        return !!ev.target && parent.contains(ev.target);
    }
    function gridOverlayPosition() {
        const spreadsheetElement = document.querySelector(".o-grid-overlay");
        if (spreadsheetElement) {
            const { top, left } = spreadsheetElement?.getBoundingClientRect();
            return { top, left };
        }
        throw new Error("Can't find spreadsheet position");
    }
    function getBoundingRectAsPOJO(el) {
        const rect = el.getBoundingClientRect();
        return {
            x: rect.x,
            y: rect.y,
            width: rect.width,
            height: rect.height,
        };
    }
    /**
     * Iterate over all the children of `el` in the dom tree starting at `el`, depth first.
     */
    function* iterateChildren(el) {
        yield el;
        if (el.hasChildNodes()) {
            for (let child of el.childNodes) {
                yield* iterateChildren(child);
            }
        }
    }
    function getOpenedMenus() {
        return Array.from(document.querySelectorAll(".o-spreadsheet .o-menu"));
    }
    const letterRegex = /^[a-zA-Z]$/;
    /**
     * Transform a keyboard event into a shortcut string that represent this event. The letters keys will be uppercased.
     *
     * @argument ev - The keyboard event to transform
     * @argument mode - Use either ev.key of ev.code to get the string shortcut
     *
     * @example
     * event : { ctrlKey: true, key: "a" } => "Ctrl+A"
     * event : { shift: true, alt: true, key: "Home" } => "Alt+Shift+Home"
     */
    function keyboardEventToShortcutString(ev, mode = "key") {
        let keyDownString = "";
        if (!MODIFIER_KEYS$1.includes(ev.key)) {
            if (isCtrlKey(ev))
                keyDownString += "Ctrl+";
            if (ev.altKey)
                keyDownString += "Alt+";
            if (ev.shiftKey)
                keyDownString += "Shift+";
        }
        const key = mode === "key" ? ev.key : ev.code;
        keyDownString += letterRegex.test(key) ? key.toUpperCase() : key;
        return keyDownString;
    }
    function isMacOS() {
        return Boolean(macRegex.test(navigator.userAgent));
    }
    /**
     * @param {KeyboardEvent | MouseEvent} ev
     * @returns Returns true if the event was triggered with the "ctrl" modifier pressed.
     * On Mac, this is the "meta" or "command" key.
     */
    function isCtrlKey(ev) {
        return isMacOS() ? ev.metaKey : ev.ctrlKey;
    }

    /**
     * Return the o-spreadsheet element position relative
     * to the browser viewport.
     */
    function useSpreadsheetRect() {
        const position = owl.useState({ x: 0, y: 0, width: 0, height: 0 });
        let spreadsheetElement = null;
        function updatePosition() {
            if (!spreadsheetElement) {
                spreadsheetElement = document.querySelector(".o-spreadsheet");
            }
            if (spreadsheetElement) {
                const { top, left, width, height } = spreadsheetElement.getBoundingClientRect();
                position.x = left;
                position.y = top;
                position.width = width;
                position.height = height;
            }
        }
        owl.onMounted(updatePosition);
        owl.onPatched(updatePosition);
        return position;
    }
    /**
     * Return the component (or ref's component) BoundingRect, relative
     * to the upper left corner of the screen (<body> element).
     *
     * Note: when used with a <Portal/> component, it will
     * return the portal position, not the teleported position.
     */
    function useAbsoluteBoundingRect(ref) {
        const rect = owl.useState({ x: 0, y: 0, width: 0, height: 0 });
        function updateElRect() {
            const el = ref.el;
            if (el === null) {
                return;
            }
            const { top, left, width, height } = el.getBoundingClientRect();
            rect.x = left;
            rect.y = top;
            rect.width = width;
            rect.height = height;
        }
        owl.onMounted(updateElRect);
        owl.onPatched(updateElRect);
        return rect;
    }
    /**
     * Get the rectangle inside which a popover should stay when being displayed.
     * It's the value defined in `env.getPopoverContainerRect`, or the Rect of the "o-spreadsheet"
     * element by default.
     *
     * Coordinates are expressed expressed as absolute DOM position.
     */
    function usePopoverContainer() {
        const container = owl.useState({ x: 0, y: 0, width: 0, height: 0 });
        const component = owl.useComponent();
        const spreadsheetRect = useSpreadsheetRect();
        function updateRect() {
            const env = component.env;
            const newRect = "getPopoverContainerRect" in env ? env.getPopoverContainerRect() : spreadsheetRect;
            container.x = newRect.x;
            container.y = newRect.y;
            container.width = newRect.width;
            container.height = newRect.height;
        }
        updateRect();
        owl.onMounted(updateRect);
        owl.onPatched(updateRect);
        return container;
    }

    /**
     * Compute the intersection of two rectangles. Returns nothing if the two rectangles don't overlap
     */
    function rectIntersection(rect1, rect2) {
        return zoneToRect(intersection(rectToZone(rect1), rectToZone(rect2)));
    }
    /** Compute the union of the rectangles, ie. the smallest rectangle that contain them all */
    function rectUnion(...rects) {
        return zoneToRect(union(...rects.map(rectToZone)));
    }
    function rectToZone(rect) {
        return {
            left: rect.x,
            top: rect.y,
            right: rect.x + rect.width,
            bottom: rect.y + rect.height,
        };
    }
    function zoneToRect(zone) {
        if (!zone)
            return undefined;
        return {
            x: zone.left,
            y: zone.top,
            width: zone.right - zone.left,
            height: zone.bottom - zone.top,
        };
    }

    css /* scss */ `
  .o-popover {
    position: absolute;
    z-index: ${ComponentsImportance.Popover};
    overflow: auto;
    box-shadow: 1px 2px 5px 2px rgb(51 51 51 / 15%);
    width: fit-content;
    height: fit-content;
  }
`;
    class Popover extends owl.Component {
        static template = "o-spreadsheet-Popover";
        static defaultProps = {
            positioning: "BottomLeft",
            verticalOffset: 0,
            onMouseWheel: () => { },
            onPopoverMoved: () => { },
            onPopoverHidden: () => { },
            zIndex: ComponentsImportance.Popover,
        };
        popoverRef = owl.useRef("popover");
        currentPosition = undefined;
        currentDisplayValue = undefined;
        spreadsheetRect = useSpreadsheetRect();
        containerRect;
        setup() {
            this.containerRect = usePopoverContainer();
            // useEffect occurs after the DOM is created and the element width/height are computed, but before
            // the element in rendered, so we can still set its position
            owl.useEffect(() => {
                if (!this.containerRect)
                    throw new Error("Popover container is not defined");
                const el = this.popoverRef.el;
                const anchor = rectIntersection(this.props.anchorRect, this.containerRect);
                const newDisplay = anchor ? "block" : "none";
                if (this.currentDisplayValue !== "none" && newDisplay === "none") {
                    this.props.onPopoverHidden?.();
                }
                el.style.display = newDisplay;
                this.currentDisplayValue = newDisplay;
                if (!anchor)
                    return;
                const propsMaxSize = { width: this.props.maxWidth, height: this.props.maxHeight };
                let elDims = {
                    width: el.getBoundingClientRect().width,
                    height: el.getBoundingClientRect().height,
                };
                const spreadsheetRect = this.spreadsheetRect;
                const popoverPositionHelper = this.props.positioning === "BottomLeft"
                    ? new BottomLeftPopoverContext(anchor, this.containerRect, propsMaxSize, spreadsheetRect)
                    : new TopRightPopoverContext(anchor, this.containerRect, propsMaxSize, spreadsheetRect);
                el.style["max-height"] = popoverPositionHelper.getMaxHeight(elDims.height) + "px";
                el.style["max-width"] = popoverPositionHelper.getMaxWidth(elDims.width) + "px";
                // Re-compute the dimensions after setting the max-width and max-height
                elDims = {
                    width: el.getBoundingClientRect().width,
                    height: el.getBoundingClientRect().height,
                };
                let style = popoverPositionHelper.getCss(elDims, this.props.verticalOffset);
                for (const property of Object.keys(style)) {
                    el.style[property] = style[property];
                }
                const newPosition = popoverPositionHelper.getCurrentPosition(elDims);
                if (this.currentPosition && newPosition !== this.currentPosition) {
                    this.props.onPopoverMoved?.();
                }
                this.currentPosition = newPosition;
            });
        }
        get popoverStyle() {
            return cssPropertiesToCss({
                "z-index": `${this.props.zIndex}`,
            });
        }
    }
    Popover.props = {
        anchorRect: Object,
        containerRect: { type: Object, optional: true },
        positioning: { type: String, optional: true },
        maxWidth: { type: Number, optional: true },
        maxHeight: { type: Number, optional: true },
        verticalOffset: { type: Number, optional: true },
        onMouseWheel: { type: Function, optional: true },
        onPopoverHidden: { type: Function, optional: true },
        onPopoverMoved: { type: Function, optional: true },
        zIndex: { type: Number, optional: true },
        slots: Object,
    };
    class PopoverPositionContext {
        anchorRect;
        containerRect;
        propsMaxSize;
        spreadsheetOffset;
        constructor(anchorRect, containerRect, propsMaxSize, spreadsheetOffset) {
            this.anchorRect = anchorRect;
            this.containerRect = containerRect;
            this.propsMaxSize = propsMaxSize;
            this.spreadsheetOffset = spreadsheetOffset;
        }
        /** Check if there is enough space for the popover to be rendered at the bottom of the anchorRect */
        shouldRenderAtBottom(elementHeight) {
            return (elementHeight <= this.availableHeightDown ||
                this.availableHeightDown >= this.availableHeightUp);
        }
        /** Check if there is enough space for the popover to be rendered at the right of the anchorRect */
        shouldRenderAtRight(elementWidth) {
            return (elementWidth <= this.availableWidthRight ||
                this.availableWidthRight >= this.availableWidthLeft);
        }
        getMaxHeight(elementHeight) {
            const shouldRenderAtBottom = this.shouldRenderAtBottom(elementHeight);
            const availableHeight = shouldRenderAtBottom
                ? this.availableHeightDown
                : this.availableHeightUp;
            return this.propsMaxSize.height
                ? Math.min(availableHeight, this.propsMaxSize.height)
                : availableHeight;
        }
        getMaxWidth(elementWidth) {
            const shouldRenderAtRight = this.shouldRenderAtRight(elementWidth);
            const availableWidth = shouldRenderAtRight ? this.availableWidthRight : this.availableWidthLeft;
            return this.propsMaxSize.width
                ? Math.min(availableWidth, this.propsMaxSize.width)
                : availableWidth;
        }
        getCss(elDims, verticalOffset) {
            const maxHeight = this.getMaxHeight(elDims.height);
            const maxWidth = this.getMaxWidth(elDims.width);
            const actualHeight = Math.min(maxHeight, elDims.height);
            const actualWidth = Math.min(maxWidth, elDims.width);
            const shouldRenderAtBottom = this.shouldRenderAtBottom(elDims.height);
            const shouldRenderAtRight = this.shouldRenderAtRight(elDims.width);
            verticalOffset = shouldRenderAtBottom ? verticalOffset : -verticalOffset;
            const cssProperties = {
                top: this.getTopCoordinate(actualHeight, shouldRenderAtBottom) -
                    this.spreadsheetOffset.y -
                    verticalOffset +
                    "px",
                left: this.getLeftCoordinate(actualWidth, shouldRenderAtRight) - this.spreadsheetOffset.x + "px",
            };
            return cssProperties;
        }
        getCurrentPosition(elDims) {
            const shouldRenderAtBottom = this.shouldRenderAtBottom(elDims.height);
            const shouldRenderAtRight = this.shouldRenderAtRight(elDims.width);
            if (shouldRenderAtBottom && shouldRenderAtRight)
                return "BottomRight";
            if (shouldRenderAtBottom && !shouldRenderAtRight)
                return "BottomLeft";
            if (!shouldRenderAtBottom && shouldRenderAtRight)
                return "TopRight";
            return "TopLeft";
        }
    }
    class BottomLeftPopoverContext extends PopoverPositionContext {
        get availableHeightUp() {
            return this.anchorRect.y - this.containerRect.y;
        }
        get availableHeightDown() {
            return this.containerRect.height - this.availableHeightUp - this.anchorRect.height;
        }
        get availableWidthRight() {
            return this.containerRect.x + this.containerRect.width - this.anchorRect.x;
        }
        get availableWidthLeft() {
            return this.anchorRect.x + this.anchorRect.width - this.containerRect.x;
        }
        getTopCoordinate(elementHeight, shouldRenderAtBottom) {
            if (shouldRenderAtBottom) {
                return this.anchorRect.y + this.anchorRect.height;
            }
            else {
                return this.anchorRect.y - elementHeight;
            }
        }
        getLeftCoordinate(elementWidth, shouldRenderAtRight) {
            if (shouldRenderAtRight) {
                return this.anchorRect.x;
            }
            else {
                return this.anchorRect.x + this.anchorRect.width - elementWidth;
            }
        }
    }
    class TopRightPopoverContext extends PopoverPositionContext {
        get availableHeightUp() {
            return this.anchorRect.y + this.anchorRect.height - this.containerRect.y;
        }
        get availableHeightDown() {
            return this.containerRect.y + this.containerRect.height - this.anchorRect.y;
        }
        get availableWidthRight() {
            return this.containerRect.width - this.anchorRect.width - this.availableWidthLeft;
        }
        get availableWidthLeft() {
            return this.anchorRect.x - this.containerRect.x;
        }
        getTopCoordinate(elementHeight, shouldRenderAtBottom) {
            if (shouldRenderAtBottom) {
                return this.anchorRect.y;
            }
            else {
                return this.anchorRect.y + this.anchorRect.height - elementHeight;
            }
        }
        getLeftCoordinate(elementWidth, shouldRenderAtRight) {
            if (shouldRenderAtRight) {
                return this.anchorRect.x + this.anchorRect.width;
            }
            else {
                return this.anchorRect.x - elementWidth;
            }
        }
    }

    //------------------------------------------------------------------------------
    // Context Menu Component
    //------------------------------------------------------------------------------
    css /* scss */ `
  .o-menu {
    background-color: white;
    padding: ${MENU_VERTICAL_PADDING}px 0px;
    width: ${MENU_WIDTH}px;
    box-sizing: border-box !important;

    .o-menu-item {
      display: flex;
      justify-content: space-between;
      align-items: center;
      box-sizing: border-box;
      height: ${MENU_ITEM_HEIGHT}px;
      padding: ${MENU_ITEM_PADDING_VERTICAL}px ${MENU_ITEM_PADDING_HORIZONTAL}px;
      cursor: pointer;
      user-select: none;

      .o-menu-item-name {
        min-width: 40%;
      }

      &.o-menu-root {
        display: flex;
        justify-content: space-between;
      }

      .o-menu-item-icon {
        display: inline-block;
        margin: 0px 8px 0px 0px;
        width: ${MENU_ITEM_HEIGHT - 2 * MENU_ITEM_PADDING_VERTICAL}px;
        line-height: ${MENU_ITEM_HEIGHT - 2 * MENU_ITEM_PADDING_VERTICAL}px;
      }
      .o-menu-item-root {
        width: 10px;
      }

      &:not(.disabled) {
        &:hover,
        &.o-menu-item-active {
          background-color: ${BG_HOVER_COLOR};
        }
        .o-menu-item-description {
          color: grey;
        }
        .o-menu-item-icon {
          .o-icon {
            color: ${ICONS_COLOR};
          }
        }
      }
      &.disabled {
        color: ${DISABLED_TEXT_COLOR};
        cursor: not-allowed;
      }
    }
  }
`;
    class Menu extends owl.Component {
        static template = "o-spreadsheet-Menu";
        static components = { Menu, Popover };
        static defaultProps = {
            depth: 1,
        };
        subMenu = owl.useState({
            isOpen: false,
            position: null,
            scrollOffset: 0,
            menuItems: [],
        });
        menuRef = owl.useRef("menu");
        position = useAbsoluteBoundingRect(this.menuRef);
        setup() {
            owl.useExternalListener(window, "click", this.onExternalClick, { capture: true });
            owl.useExternalListener(window, "contextmenu", this.onExternalClick, { capture: true });
            owl.onWillUpdateProps((nextProps) => {
                if (nextProps.menuItems !== this.props.menuItems) {
                    this.closeSubMenu();
                }
            });
        }
        get menuItemsAndSeparators() {
            const menuItemsAndSeparators = [];
            for (let i = 0; i < this.props.menuItems.length; i++) {
                const menuItem = this.props.menuItems[i];
                if (menuItem.isVisible(this.env)) {
                    menuItemsAndSeparators.push(menuItem);
                }
                if (menuItem.separator &&
                    i !== this.props.menuItems.length - 1 && // no separator at the end
                    menuItemsAndSeparators[menuItemsAndSeparators.length - 1] !== "separator" // no double separator
                ) {
                    menuItemsAndSeparators.push("separator");
                }
            }
            if (menuItemsAndSeparators[menuItemsAndSeparators.length - 1] === "separator") {
                menuItemsAndSeparators.pop();
            }
            if (menuItemsAndSeparators.length === 1 && menuItemsAndSeparators[0] === "separator") {
                return [];
            }
            return menuItemsAndSeparators;
        }
        get subMenuPosition() {
            const position = Object.assign({}, this.subMenu.position);
            position.y -= this.subMenu.scrollOffset || 0;
            return position;
        }
        get popoverProps() {
            const isRoot = this.props.depth === 1;
            return {
                anchorRect: {
                    x: this.props.position.x - MENU_WIDTH * (this.props.depth - 1),
                    y: this.props.position.y,
                    width: isRoot ? 0 : MENU_WIDTH,
                    height: isRoot ? 0 : MENU_ITEM_HEIGHT,
                },
                positioning: "TopRight",
                verticalOffset: isRoot ? 0 : MENU_VERTICAL_PADDING,
                onPopoverHidden: () => this.closeSubMenu(),
                onPopoverMoved: () => this.closeSubMenu(),
            };
        }
        get childrenHaveIcon() {
            return this.props.menuItems.some((menuItem) => !!this.getIconName(menuItem));
        }
        getIconName(menu) {
            if (menu.icon(this.env)) {
                return menu.icon(this.env);
            }
            if (menu.isActive?.(this.env)) {
                return "o-spreadsheet-Icon.CHECK";
            }
            return "";
        }
        getColor(menu) {
            return menu.textColor ? `color: ${menu.textColor}` : undefined;
        }
        async activateMenu(menu) {
            const result = await menu.execute?.(this.env);
            this.close();
            this.props.onMenuClicked?.({ detail: result });
        }
        close() {
            this.closeSubMenu();
            this.props.onClose();
        }
        onExternalClick(ev) {
            // Don't close a root menu when clicked to open the submenus.
            const el = this.menuRef.el;
            if (el && getOpenedMenus().some((el) => isChildEvent(el, ev))) {
                return;
            }
            ev.closedMenuId = this.props.menuId;
            this.close();
        }
        getName(menu) {
            return menu.name(this.env);
        }
        isRoot(menu) {
            return !menu.execute;
        }
        isEnabled(menu) {
            if (menu.isEnabled(this.env)) {
                return this.env.model.getters.isReadonly() ? menu.isReadonlyAllowed : true;
            }
            return false;
        }
        onScroll(ev) {
            this.subMenu.scrollOffset = ev.target.scrollTop;
        }
        /**
         * If the given menu is not disabled, open it's submenu at the
         * correct position according to available surrounding space.
         */
        openSubMenu(menu, menuIndex, ev) {
            const parentMenuEl = ev.currentTarget;
            if (!parentMenuEl)
                return;
            const y = parentMenuEl.getBoundingClientRect().top;
            this.subMenu.position = {
                x: this.position.x + this.props.depth * MENU_WIDTH,
                y: y - (this.subMenu.scrollOffset || 0),
            };
            this.subMenu.menuItems = menu.children(this.env);
            this.subMenu.isOpen = true;
            this.subMenu.parentMenu = menu;
        }
        isParentMenu(subMenu, menuItem) {
            return subMenu.parentMenu?.id === menuItem.id;
        }
        closeSubMenu() {
            this.subMenu.isOpen = false;
            this.subMenu.parentMenu = undefined;
        }
        onClickMenu(menu, menuIndex, ev) {
            if (this.isEnabled(menu)) {
                if (this.isRoot(menu)) {
                    this.openSubMenu(menu, menuIndex, ev);
                }
                else {
                    this.activateMenu(menu);
                }
            }
        }
        onMouseOver(menu, position, ev) {
            if (this.isEnabled(menu)) {
                if (this.isRoot(menu)) {
                    this.openSubMenu(menu, position, ev);
                }
                else {
                    this.closeSubMenu();
                }
            }
        }
    }
    Menu.props = {
        position: Object,
        menuItems: Array,
        depth: { type: Number, optional: true },
        maxHeight: { type: Number, optional: true },
        onClose: Function,
        onMenuClicked: { type: Function, optional: true },
        menuId: { type: String, optional: true },
    };

    const LINK_TOOLTIP_HEIGHT = 32;
    const LINK_TOOLTIP_WIDTH = 220;
    css /* scss */ `
  .o-link-tool {
    font-size: 13px;
    background-color: white;
    box-shadow: 0 1px 4px 3px rgba(60, 64, 67, 0.15);
    padding: 6px 12px;
    border-radius: 4px;
    display: flex;
    justify-content: space-between;
    height: ${LINK_TOOLTIP_HEIGHT}px;
    width: ${LINK_TOOLTIP_WIDTH}px;
    box-sizing: border-box !important;

    img {
      margin-right: 3px;
      width: 16px;
      height: 16px;
    }

    a.o-link {
      color: #01666b;
      text-decoration: none;
      flex-grow: 2;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }
    a.o-link:hover {
      text-decoration: none;
      color: #001d1f;
      cursor: pointer;
    }
  }
  .o-link-icon {
    float: right;
    padding-left: 5px;
    .o-icon {
      height: 16px;
    }
  }
  .o-link-icon .o-icon {
    height: 13px;
  }
  .o-link-icon:hover {
    cursor: pointer;
    color: #000;
  }
`;
    class LinkDisplay extends owl.Component {
        static components = { Menu };
        static template = "o-spreadsheet-LinkDisplay";
        get cell() {
            const { col, row } = this.props.cellPosition;
            const sheetId = this.env.model.getters.getActiveSheetId();
            return this.env.model.getters.getEvaluatedCell({ sheetId, col, row });
        }
        get link() {
            if (this.cell.link) {
                return this.cell.link;
            }
            const { col, row } = this.props.cellPosition;
            throw new Error(`LinkDisplay Component can only be used with link cells. ${toXC(col, row)} is not a link.`);
        }
        getUrlRepresentation(link) {
            return urlRepresentation(link, this.env.model.getters);
        }
        openLink() {
            openLink(this.link, this.env);
        }
        edit() {
            const { col, row } = this.props.cellPosition;
            this.env.model.dispatch("OPEN_CELL_POPOVER", {
                col,
                row,
                popoverType: "LinkEditor",
            });
        }
        unlink() {
            const sheetId = this.env.model.getters.getActiveSheetId();
            const { col, row } = this.props.cellPosition;
            const style = this.env.model.getters.getCellComputedStyle({ sheetId, col, row });
            const textColor = style?.textColor === LINK_COLOR ? undefined : style?.textColor;
            this.env.model.dispatch("UPDATE_CELL", {
                col,
                row,
                sheetId,
                content: this.link.label,
                style: { ...style, textColor, underline: undefined },
            });
        }
    }
    const LinkCellPopoverBuilder = {
        onHover: (position, getters) => {
            const cell = getters.getEvaluatedCell(position);
            const shouldDisplayLink = !getters.isDashboard() && cell.link && getters.isVisibleInViewport(position);
            if (!shouldDisplayLink)
                return { isOpen: false };
            return {
                isOpen: true,
                Component: LinkDisplay,
                props: { cellPosition: position },
                cellCorner: "BottomLeft",
            };
        },
    };
    LinkDisplay.props = {
        cellPosition: Object,
        onClosed: { type: Function, optional: true },
    };

    /**
     * Tokenizer
     *
     * A tokenizer is a piece of code whose job is to transform a string into a list
     * of "tokens". For example, "(12+" is converted into:
     *   [{type: "LEFT_PAREN", value: "("},
     *    {type: "NUMBER", value: "12"},
     *    {type: "OPERATOR", value: "+"}]
     *
     * As the example shows, a tokenizer does not care about the meaning behind those
     * tokens. It only cares about the structure.
     *
     * The tokenizer is usually the first step in a compilation pipeline.  Also, it
     * is useful for the composer, which needs to be able to work with incomplete
     * formulas.
     */
    const POSTFIX_UNARY_OPERATORS = ["%"];
    const OPERATORS = "+,-,*,/,:,=,<>,>=,>,<=,<,^,&".split(",").concat(POSTFIX_UNARY_OPERATORS);
    function tokenize(str, locale = DEFAULT_LOCALE) {
        str = replaceNewLines(str);
        const chars = new TokenizingChars(str);
        const result = [];
        const tokenizeSpace = specialWhiteSpaceRegexp.test(str)
            ? tokenizeSpecialCharacterSpace
            : tokenizeSimpleSpace;
        while (!chars.isOver()) {
            let token = tokenizeNewLine(chars) ||
                tokenizeSpace(chars) ||
                tokenizeArgsSeparator(chars, locale) ||
                tokenizeParenthesis(chars) ||
                tokenizeOperator(chars) ||
                tokenizeString(chars) ||
                tokenizeDebugger(chars) ||
                tokenizeInvalidRange(chars) ||
                tokenizeNumber(chars, locale) ||
                tokenizeSymbol(chars);
            if (!token) {
                token = { type: "UNKNOWN", value: chars.shift() };
            }
            result.push(token);
        }
        return result;
    }
    function tokenizeDebugger(chars) {
        if (chars.current === "?") {
            chars.shift();
            return { type: "DEBUGGER", value: "?" };
        }
        return null;
    }
    const parenthesis = {
        "(": { type: "LEFT_PAREN", value: "(" },
        ")": { type: "RIGHT_PAREN", value: ")" },
    };
    function tokenizeParenthesis(chars) {
        if (chars.current === "(" || chars.current === ")") {
            const value = chars.shift();
            return parenthesis[value];
        }
        return null;
    }
    function tokenizeArgsSeparator(chars, locale) {
        if (chars.current === locale.formulaArgSeparator) {
            const value = chars.shift();
            const type = "ARG_SEPARATOR";
            return { type, value };
        }
        return null;
    }
    function tokenizeOperator(chars) {
        for (let op of OPERATORS) {
            if (chars.currentStartsWith(op)) {
                chars.advanceBy(op.length);
                return { type: "OPERATOR", value: op };
            }
        }
        return null;
    }
    const FIRST_POSSIBLE_NUMBER_CHARS = new Set("0123456789");
    function tokenizeNumber(chars, locale) {
        if (!FIRST_POSSIBLE_NUMBER_CHARS.has(chars.current) &&
            chars.current !== locale.decimalSeparator) {
            return null;
        }
        const match = chars.remaining().match(getFormulaNumberRegex(locale.decimalSeparator));
        if (match) {
            chars.advanceBy(match[0].length);
            return { type: "NUMBER", value: match[0] };
        }
        return null;
    }
    function tokenizeString(chars) {
        if (chars.current === '"') {
            const startChar = chars.shift();
            let letters = startChar;
            while (chars.current && (chars.current !== startChar || letters[letters.length - 1] === "\\")) {
                letters += chars.shift();
            }
            if (chars.current === '"') {
                letters += chars.shift();
            }
            return {
                type: "STRING",
                value: letters,
            };
        }
        return null;
    }
    /**
      - \p{L} is for any letter (from any language)
      - \p{N} is for any number
      - the u flag at the end is for unicode, which enables the `\p{...}` syntax
     */
    const unicodeSymbolCharRegexp = /\p{L}|\p{N}|_|\.|!|\$/u;
    const SYMBOL_CHARS = new Set("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_.!$");
    /**
     * A "Symbol" is just basically any word-like element that can appear in a
     * formula, which is not a string. So:
     *   A1
     *   SUM
     *   CEILING.MATH
     *   A$1
     *   Sheet2!A2
     *   'Sheet 2'!A2
     *
     * are examples of symbols
     */
    function tokenizeSymbol(chars) {
        let result = "";
        // there are two main cases to manage: either something which starts with
        // a ', like 'Sheet 2'A2, or a word-like element.
        if (chars.current === "'") {
            let lastChar = chars.shift();
            result += lastChar;
            while (chars.current) {
                lastChar = chars.shift();
                result += lastChar;
                if (lastChar === "'") {
                    if (chars.current && chars.current === "'") {
                        lastChar = chars.shift();
                        result += lastChar;
                    }
                    else {
                        break;
                    }
                }
            }
            if (lastChar !== "'") {
                return {
                    type: "UNKNOWN",
                    value: result,
                };
            }
        }
        while (chars.current &&
            (SYMBOL_CHARS.has(chars.current) || chars.current.match(unicodeSymbolCharRegexp))) {
            result += chars.shift();
        }
        if (result.length) {
            const value = result;
            const isReference = rangeReference.test(value);
            if (isReference) {
                return { type: "REFERENCE", value };
            }
            return { type: "SYMBOL", value };
        }
        return null;
    }
    function tokenizeSpecialCharacterSpace(chars) {
        let spaces = "";
        while (chars.current === " " || (chars.current && chars.current.match(specialWhiteSpaceRegexp))) {
            spaces += chars.shift();
        }
        if (spaces) {
            return { type: "SPACE", value: spaces };
        }
        return null;
    }
    function tokenizeSimpleSpace(chars) {
        let spaces = "";
        while (chars.current === " ") {
            spaces += chars.shift();
        }
        if (spaces) {
            return { type: "SPACE", value: spaces };
        }
        return null;
    }
    function tokenizeNewLine(chars) {
        let length = 0;
        while (chars.current === NEWLINE) {
            length++;
            chars.shift();
        }
        if (length) {
            return { type: "SPACE", value: NEWLINE.repeat(length) };
        }
        return null;
    }
    function tokenizeInvalidRange(chars) {
        if (chars.currentStartsWith(INCORRECT_RANGE_STRING)) {
            chars.advanceBy(INCORRECT_RANGE_STRING.length);
            return { type: "INVALID_REFERENCE", value: INCORRECT_RANGE_STRING };
        }
        return null;
    }
    class TokenizingChars {
        text;
        currentIndex = 0;
        current;
        constructor(text) {
            this.text = text;
            this.current = text[0];
        }
        shift() {
            const current = this.current;
            const next = this.text[++this.currentIndex];
            this.current = next;
            return current;
        }
        advanceBy(length) {
            this.currentIndex += length;
            this.current = this.text[this.currentIndex];
        }
        isOver() {
            return this.currentIndex >= this.text.length;
        }
        remaining() {
            return this.text.substring(this.currentIndex);
        }
        currentStartsWith(str) {
            if (this.current !== str[0]) {
                return false;
            }
            for (let j = 1; j < str.length; j++) {
                if (this.text[this.currentIndex + j] !== str[j]) {
                    return false;
                }
            }
            return true;
        }
    }

    function isValidLocale(locale) {
        if (!locale ||
            typeof locale !== "object" ||
            !(!locale.thousandsSeparator || typeof locale.thousandsSeparator === "string")) {
            return false;
        }
        for (const property of [
            "code",
            "name",
            "decimalSeparator",
            "dateFormat",
            "timeFormat",
            "formulaArgSeparator",
        ]) {
            if (!locale[property] || typeof locale[property] !== "string") {
                return false;
            }
        }
        if (locale.formulaArgSeparator === locale.decimalSeparator) {
            return false;
        }
        if (locale.thousandsSeparator === locale.decimalSeparator) {
            return false;
        }
        try {
            formatValue(1, { locale, format: "#,##0.00" });
            formatValue(1, { locale, format: locale.dateFormat });
            formatValue(1, { locale, format: locale.timeFormat });
        }
        catch {
            return false;
        }
        return true;
    }
    /**
     * Change a content string from the given locale to its canonical form (en_US locale). Don't convert date string.
     *
     * @example
     * canonicalizeNumberContent("=SUM(1,5; 02/12/2012)", FR_LOCALE) // "=SUM(1.5, 02/12/2012)"
     * canonicalizeNumberContent("125,9", FR_LOCALE) // "125.9"
     * canonicalizeNumberContent("02/12/2012", FR_LOCALE) // "02/12/2012"
     */
    function canonicalizeNumberContent(content, locale) {
        return content.startsWith("=")
            ? canonicalizeFormula(content, locale)
            : canonicalizeNumberLiteral(content, locale);
    }
    /**
     * Change a content string from the given locale to its canonical form (en_US locale). Also convert date string.
     * This is destructive and won't preserve the original format.
     *
     * @example
     * canonicalizeContent("=SUM(1,5; 5)", FR_LOCALE) // "=SUM(1.5, 5)"
     * canonicalizeContent("125,9", FR_LOCALE) // "125.9"
     * canonicalizeContent("02/12/2012", FR_LOCALE) // "12/02/2012"
     * canonicalizeContent("02-12-2012", FR_LOCALE) // "12/02/2012"
     */
    function canonicalizeContent(content, locale) {
        return content.startsWith("=")
            ? canonicalizeFormula(content, locale)
            : canonicalizeLiteral(content, locale);
    }
    /**
     * Change a content string from its canonical form (en_US locale) to the given locale. Also convert date string.
     *
     * @example
     * localizeContent("=SUM(1.5, 5)", FR_LOCALE) // "=SUM(1,5; 5)"
     * localizeContent("125.9", FR_LOCALE) // "125,9"
     * localizeContent("12/02/2012", FR_LOCALE) // "02/12/2012"
     */
    function localizeContent(content, locale) {
        return content.startsWith("=")
            ? localizeFormula(content, locale)
            : localizeLiteral(content, locale);
    }
    /** Change a number string to its canonical form (en_US locale) */
    function canonicalizeNumberValue(content, locale) {
        return content.startsWith("=")
            ? canonicalizeFormula(content, locale)
            : canonicalizeNumberLiteral(content, locale);
    }
    /** Change a formula to its canonical form (en_US locale) */
    function canonicalizeFormula(formula, locale) {
        return _localizeFormula(formula, locale, DEFAULT_LOCALE);
    }
    /** Change a formula from the canonical form to the given locale */
    function localizeFormula(formula, locale) {
        return _localizeFormula(formula, DEFAULT_LOCALE, locale);
    }
    function _localizeFormula(formula, fromLocale, toLocale) {
        if (fromLocale.formulaArgSeparator === toLocale.formulaArgSeparator &&
            fromLocale.decimalSeparator === toLocale.decimalSeparator) {
            return formula;
        }
        const tokens = tokenize(formula, fromLocale);
        let localizedFormula = "";
        for (const token of tokens) {
            if (token.type === "NUMBER") {
                localizedFormula += token.value.replace(fromLocale.decimalSeparator, toLocale.decimalSeparator);
            }
            else if (token.type === "ARG_SEPARATOR") {
                localizedFormula += toLocale.formulaArgSeparator;
            }
            else {
                localizedFormula += token.value;
            }
        }
        return localizedFormula;
    }
    /**
     * Change a literal string from the given locale to its canonical form (en_US locale). Don't convert date string.
     *
     * @example
     * canonicalizeNumberLiteral("125,9", FR_LOCALE) // "125.9"
     * canonicalizeNumberLiteral("02/12/2012", FR_LOCALE) // "02/12/2012"
     */
    function canonicalizeNumberLiteral(content, locale) {
        if (locale.decimalSeparator === "." || !isNumber(content, locale)) {
            return content;
        }
        if (locale.thousandsSeparator) {
            content = content.replaceAll(locale.thousandsSeparator, "");
        }
        return content.replace(locale.decimalSeparator, ".");
    }
    /**
     * Change a content string from the given locale to its canonical form (en_US locale). Also convert date string.
     * This is destructive and won't preserve the original format.
     *
     * @example
     * canonicalizeLiteral("125,9", FR_LOCALE) // "125.9"
     * canonicalizeLiteral("02/12/2012", FR_LOCALE) // "12/02/2012"
     * canonicalizeLiteral("02-12-2012", FR_LOCALE) // "12/02/2012"
     */
    function canonicalizeLiteral(content, locale) {
        if (isDateTime(content, locale)) {
            const dateNumber = toNumber(content, locale);
            let format = DEFAULT_LOCALE.dateFormat;
            if (!Number.isInteger(dateNumber)) {
                format += " " + DEFAULT_LOCALE.timeFormat;
            }
            return formatValue(dateNumber, { locale: DEFAULT_LOCALE, format });
        }
        return canonicalizeNumberLiteral(content, locale);
    }
    /**
     * Change a literal string from its canonical form (en_US locale) to the given locale. Don't convert date string.
     * This is destructive and won't preserve the original format.
     *
     * @example
     * localizeNumberLiteral("125.9", FR_LOCALE) // "125,9"
     * localizeNumberLiteral("12/02/2012", FR_LOCALE) // "12/02/2012"
     * localizeNumberLiteral("12-02-2012", FR_LOCALE) // "12/02/2012"
     */
    function localizeNumberLiteral(literal, locale) {
        if (locale.decimalSeparator === "." || !isNumber(literal, DEFAULT_LOCALE)) {
            return literal;
        }
        const decimalNumberRegex = getDecimalNumberRegex(DEFAULT_LOCALE);
        const localized = literal.replace(decimalNumberRegex, (match) => {
            return match.replace(".", locale.decimalSeparator);
        });
        return localized;
    }
    /**
     * Change a literal string from its canonical form (en_US locale) to the given locale. Also convert date string.
     *
     * @example
     * localizeLiteral("125.9", FR_LOCALE) // "125,9"
     * localizeLiteral("12/02/2012", FR_LOCALE) // "02/12/2012"
     */
    function localizeLiteral(literal, locale) {
        if (isDateTime(literal, DEFAULT_LOCALE)) {
            const dateNumber = toNumber(literal, DEFAULT_LOCALE);
            let format = locale.dateFormat;
            if (!Number.isInteger(dateNumber)) {
                format += " " + locale.timeFormat;
            }
            return formatValue(dateNumber, { locale, format });
        }
        return localizeNumberLiteral(literal, locale);
    }
    function canonicalizeCFRule(cf, locale) {
        return changeCFRuleLocale(cf, (content) => canonicalizeContent(content, locale));
    }
    function localizeCFRule(cf, locale) {
        return changeCFRuleLocale(cf, (content) => localizeContent(content, locale));
    }
    function localizeDataValidationRule(rule, locale) {
        const localizedDVRule = deepCopy(rule);
        localizedDVRule.criterion.values = localizedDVRule.criterion.values.map((content) => localizeContent(content, locale));
        return localizedDVRule;
    }
    function changeCFRuleLocale(rule, changeContentLocale) {
        rule = deepCopy(rule);
        switch (rule.type) {
            case "CellIsRule":
                // Only change value for number operators
                switch (rule.operator) {
                    case "Between":
                    case "NotBetween":
                    case "Equal":
                    case "NotEqual":
                    case "GreaterThan":
                    case "GreaterThanOrEqual":
                    case "LessThan":
                    case "LessThanOrEqual":
                        rule.values = rule.values.map((v) => changeContentLocale(v));
                        return rule;
                    case "BeginsWith":
                    case "ContainsText":
                    case "EndsWith":
                    case "NotContains":
                    case "IsEmpty":
                    case "IsNotEmpty":
                        return rule;
                }
                break;
            case "ColorScaleRule":
                rule.minimum = changeCFRuleThresholdLocale(rule.minimum, changeContentLocale);
                rule.maximum = changeCFRuleThresholdLocale(rule.maximum, changeContentLocale);
                if (rule.midpoint) {
                    rule.midpoint = changeCFRuleThresholdLocale(rule.midpoint, changeContentLocale);
                }
                return rule;
            case "IconSetRule":
                rule.lowerInflectionPoint.value = changeContentLocale(rule.lowerInflectionPoint.value);
                rule.upperInflectionPoint.value = changeContentLocale(rule.upperInflectionPoint.value);
                return rule;
        }
    }
    function changeCFRuleThresholdLocale(threshold, changeContentLocale) {
        if (!threshold?.value) {
            return threshold;
        }
        const value = threshold.type === "formula" ? "=" + threshold.value : threshold.value;
        const modified = changeContentLocale(value);
        const newValue = threshold.type === "formula" ? modified.slice(1) : modified;
        return { ...threshold, value: newValue };
    }
    function getDateTimeFormat(locale) {
        return locale.dateFormat + " " + locale.timeFormat;
    }

    const linkSheet = {
        name: _t("Link sheet"),
        children: [
            (env) => {
                const sheets = env.model.getters
                    .getSheetIds()
                    .map((sheetId) => env.model.getters.getSheet(sheetId));
                return sheets.map((sheet) => ({
                    id: sheet.id,
                    name: sheet.name,
                    execute: () => markdownLink(sheet.name, buildSheetLink(sheet.id)),
                }));
            },
        ],
    };
    const deleteSheet = {
        name: _t("Delete"),
        isVisible: (env) => {
            return env.model.getters.getVisibleSheetIds().length > 1;
        },
        execute: (env) => env.askConfirmation(_t("Are you sure you want to delete this sheet?"), () => {
            env.model.dispatch("DELETE_SHEET", { sheetId: env.model.getters.getActiveSheetId() });
        }),
    };
    const duplicateSheet = {
        name: _t("Duplicate"),
        execute: (env) => {
            const sheetIdFrom = env.model.getters.getActiveSheetId();
            const sheetNameFrom = env.model.getters.getSheetName(sheetIdFrom);
            const sheetIdTo = env.model.uuidGenerator.smallUuid();
            const sheetNameTo = env.model.getters.getDuplicateSheetName(sheetNameFrom);
            env.model.dispatch("DUPLICATE_SHEET", {
                sheetId: sheetIdFrom,
                sheetIdTo,
                sheetNameTo,
            });
            env.model.dispatch("ACTIVATE_SHEET", { sheetIdFrom, sheetIdTo });
        },
    };
    const renameSheet = (args) => {
        return {
            name: _t("Rename"),
            execute: args.renameSheetCallback,
        };
    };
    const sheetMoveRight = {
        name: _t("Move right"),
        isVisible: (env) => {
            const sheetId = env.model.getters.getActiveSheetId();
            const sheetIds = env.model.getters.getVisibleSheetIds();
            return sheetIds.indexOf(sheetId) !== sheetIds.length - 1;
        },
        execute: (env) => env.model.dispatch("MOVE_SHEET", {
            sheetId: env.model.getters.getActiveSheetId(),
            delta: 1,
        }),
    };
    const sheetMoveLeft = {
        name: _t("Move left"),
        isVisible: (env) => {
            const sheetId = env.model.getters.getActiveSheetId();
            return env.model.getters.getVisibleSheetIds()[0] !== sheetId;
        },
        execute: (env) => env.model.dispatch("MOVE_SHEET", {
            sheetId: env.model.getters.getActiveSheetId(),
            delta: -1,
        }),
    };
    const hideSheet = {
        name: _t("Hide sheet"),
        isVisible: (env) => env.model.getters.getVisibleSheetIds().length !== 1,
        execute: (env) => env.model.dispatch("HIDE_SHEET", { sheetId: env.model.getters.getActiveSheetId() }),
    };

    /**
     * The class Registry is extended in order to add the function addChild
     *
     */
    class MenuItemRegistry extends Registry {
        /**
         * @override
         */
        add(key, value) {
            if (value.id === undefined) {
                value.id = key;
            }
            this.content[key] = value;
            return this;
        }
        /**
         * Add a subitem to an existing item
         * @param path Path of items to add this subitem
         * @param value Subitem to add
         */
        addChild(key, path, value) {
            if (typeof value !== "function" && value.id === undefined) {
                value.id = key;
            }
            const root = path.splice(0, 1)[0];
            let node = this.content[root];
            if (!node) {
                throw new Error(`Path ${root + ":" + path.join(":")} not found`);
            }
            for (let p of path) {
                const children = node.children;
                if (!children || typeof children === "function") {
                    throw new Error(`${p} is either not a node or it's dynamically computed`);
                }
                node = children.find((elt) => elt.id === p);
                if (!node) {
                    throw new Error(`Path ${root + ":" + path.join(":")} not found`);
                }
            }
            if (!node.children) {
                node.children = [];
            }
            node.children.push(value);
            return this;
        }
        getMenuItems() {
            return createActions(this.getAll());
        }
    }

    //------------------------------------------------------------------------------
    // Link Menu Registry
    //------------------------------------------------------------------------------
    const linkMenuRegistry = new MenuItemRegistry();
    linkMenuRegistry.add("sheet", {
        ...linkSheet,
        sequence: 10,
    });

    const MENU_OFFSET_X = 320;
    const MENU_OFFSET_Y = 100;
    const PADDING = 12;
    const LINK_EDITOR_WIDTH = 340;
    const LINK_EDITOR_HEIGHT = 165;
    css /* scss */ `
  .o-link-editor {
    font-size: 13px;
    background-color: white;
    box-shadow: 0 1px 4px 3px rgba(60, 64, 67, 0.15);
    padding: ${PADDING}px;
    display: flex;
    flex-direction: column;
    border-radius: 4px;
    height: ${LINK_EDITOR_HEIGHT}px;
    width: ${LINK_EDITOR_WIDTH}px;

    .o-section {
      .o-section-title {
        font-weight: bold;
        color: dimgrey;
        margin-bottom: 5px;
      }
    }
    .o-buttons {
      padding-left: 16px;
      padding-top: 16px;
      padding-bottom: 16px;
      text-align: right;
    }
    input {
      box-sizing: border-box;
      width: 100%;
      border-radius: 4px;
      padding: 4px 23px 4px 10px;
      border: none;
      height: 24px;
      border: 1px solid lightgrey;
    }
    .o-link-url {
      position: relative;
      flex-grow: 1;
      button {
        position: absolute;
        right: 0px;
        top: 0px;
        border: none;
        height: 20px;
        width: 20px;
        background-color: #fff;
        margin: 2px 3px 1px 0px;
        padding: 0px 1px 0px 0px;
      }
      button:hover {
        cursor: pointer;
      }
    }
  }
`;
    class LinkEditor extends owl.Component {
        static template = "o-spreadsheet-LinkEditor";
        static components = { Menu };
        menuItems = linkMenuRegistry.getMenuItems();
        link = owl.useState(this.defaultState);
        menu = owl.useState({
            isOpen: false,
        });
        linkEditorRef = owl.useRef("linkEditor");
        position = useAbsoluteBoundingRect(this.linkEditorRef);
        urlInput = owl.useRef("urlInput");
        setup() {
            owl.onMounted(() => this.urlInput.el?.focus());
        }
        get defaultState() {
            const { col, row } = this.props.cellPosition;
            const sheetId = this.env.model.getters.getActiveSheetId();
            const cell = this.env.model.getters.getEvaluatedCell({ sheetId, col, row });
            if (cell.link) {
                return {
                    url: cell.link.url,
                    label: cell.formattedValue,
                    isUrlEditable: cell.link.isUrlEditable,
                };
            }
            return {
                label: cell.formattedValue,
                url: "",
                isUrlEditable: true,
            };
        }
        get menuPosition() {
            return {
                x: this.position.x + MENU_OFFSET_X - PADDING - 2,
                y: this.position.y + MENU_OFFSET_Y,
            };
        }
        onSpecialLink(ev) {
            const { detail: markdownLink } = ev;
            const link = detectLink(markdownLink);
            if (!link) {
                return;
            }
            this.link.url = link.url;
            this.link.label = link.label;
            this.link.isUrlEditable = link.isUrlEditable;
        }
        getUrlRepresentation(link) {
            return urlRepresentation(link, this.env.model.getters);
        }
        openMenu() {
            this.menu.isOpen = true;
        }
        removeLink() {
            this.link.url = "";
            this.link.isUrlEditable = true;
        }
        save() {
            const { col, row } = this.props.cellPosition;
            const locale = this.env.model.getters.getLocale();
            const label = this.link.label
                ? canonicalizeNumberContent(this.link.label, locale)
                : this.link.url;
            this.env.model.dispatch("UPDATE_CELL", {
                col: col,
                row: row,
                sheetId: this.env.model.getters.getActiveSheetId(),
                content: markdownLink(label, this.link.url),
            });
            this.props.onClosed?.();
        }
        cancel() {
            this.props.onClosed?.();
        }
        onKeyDown(ev) {
            switch (ev.key) {
                case "Enter":
                    if (this.link.url) {
                        this.save();
                    }
                    ev.stopPropagation();
                    ev.preventDefault();
                    break;
                case "Escape":
                    this.cancel();
                    ev.stopPropagation();
                    break;
            }
        }
    }
    const LinkEditorPopoverBuilder = {
        onOpen: (position, getters) => {
            return {
                isOpen: true,
                props: { cellPosition: position },
                Component: LinkEditor,
                cellCorner: "BottomLeft",
            };
        },
    };
    LinkEditor.props = {
        cellPosition: Object,
        onClosed: { type: Function, optional: true },
    };

    const cellPopoverRegistry = new Registry();
    cellPopoverRegistry
        .add("ErrorToolTip", ErrorToolTipPopoverBuilder)
        .add("LinkCell", LinkCellPopoverBuilder)
        .add("LinkEditor", LinkEditorPopoverBuilder)
        .add("FilterMenu", FilterMenuPopoverBuilder);

    /**
     * Convert a JS color hexadecimal to an excel compatible color.
     *
     * In Excel the color don't start with a '#' and the format is AARRGGBB instead of RRGGBBAA
     */
    function toXlsxHexColor(color) {
        color = toHex(color).replace("#", "");
        // alpha channel goes first
        if (color.length === 8) {
            return color.slice(6) + color.slice(0, 6);
        }
        return color;
    }

    const PasteInteractiveContent = {
        wrongPasteSelection: _t("This operation is not allowed with multiple selections."),
        willRemoveExistingMerge: _t("This operation is not possible due to a merge. Please remove the merges first than try again."),
        wrongFigurePasteOption: _t("Cannot do a special paste of a figure."),
        frozenPaneOverlap: _t("This operation is not allowed due to an overlapping frozen pane."),
    };
    function handlePasteResult(env, result) {
        if (!result.isSuccessful) {
            if (result.reasons.includes("WrongPasteSelection" /* CommandResult.WrongPasteSelection */)) {
                env.raiseError(PasteInteractiveContent.wrongPasteSelection);
            }
            else if (result.reasons.includes("WillRemoveExistingMerge" /* CommandResult.WillRemoveExistingMerge */)) {
                env.raiseError(PasteInteractiveContent.willRemoveExistingMerge);
            }
            else if (result.reasons.includes("WrongFigurePasteOption" /* CommandResult.WrongFigurePasteOption */)) {
                env.raiseError(PasteInteractiveContent.wrongFigurePasteOption);
            }
            else if (result.reasons.includes("FrozenPaneOverlap" /* CommandResult.FrozenPaneOverlap */)) {
                env.raiseError(PasteInteractiveContent.frozenPaneOverlap);
            }
        }
    }
    function interactivePaste(env, target, pasteOption) {
        const result = env.model.dispatch("PASTE", { target, pasteOption });
        handlePasteResult(env, result);
    }
    function interactivePasteFromOS(env, target, text, pasteOption) {
        const result = env.model.dispatch("PASTE_FROM_OS_CLIPBOARD", { target, text, pasteOption });
        handlePasteResult(env, result);
    }

    const CfTerms = {
        Errors: {
            ["InvalidRange" /* CommandResult.InvalidRange */]: _t("The range is invalid"),
            ["FirstArgMissing" /* CommandResult.FirstArgMissing */]: _t("The argument is missing. Please provide a value"),
            ["SecondArgMissing" /* CommandResult.SecondArgMissing */]: _t("The second argument is missing. Please provide a value"),
            ["MinNaN" /* CommandResult.MinNaN */]: _t("The minpoint must be a number"),
            ["MidNaN" /* CommandResult.MidNaN */]: _t("The midpoint must be a number"),
            ["MaxNaN" /* CommandResult.MaxNaN */]: _t("The maxpoint must be a number"),
            ["ValueUpperInflectionNaN" /* CommandResult.ValueUpperInflectionNaN */]: _t("The first value must be a number"),
            ["ValueLowerInflectionNaN" /* CommandResult.ValueLowerInflectionNaN */]: _t("The second value must be a number"),
            ["MinBiggerThanMax" /* CommandResult.MinBiggerThanMax */]: _t("Minimum must be smaller then Maximum"),
            ["MinBiggerThanMid" /* CommandResult.MinBiggerThanMid */]: _t("Minimum must be smaller then Midpoint"),
            ["MidBiggerThanMax" /* CommandResult.MidBiggerThanMax */]: _t("Midpoint must be smaller then Maximum"),
            ["LowerBiggerThanUpper" /* CommandResult.LowerBiggerThanUpper */]: _t("Lower inflection point must be smaller than upper inflection point"),
            ["MinInvalidFormula" /* CommandResult.MinInvalidFormula */]: _t("Invalid Minpoint formula"),
            ["MaxInvalidFormula" /* CommandResult.MaxInvalidFormula */]: _t("Invalid Maxpoint formula"),
            ["MidInvalidFormula" /* CommandResult.MidInvalidFormula */]: _t("Invalid Midpoint formula"),
            ["ValueUpperInvalidFormula" /* CommandResult.ValueUpperInvalidFormula */]: _t("Invalid upper inflection point formula"),
            ["ValueLowerInvalidFormula" /* CommandResult.ValueLowerInvalidFormula */]: _t("Invalid lower inflection point formula"),
            ["EmptyRange" /* CommandResult.EmptyRange */]: _t("A range needs to be defined"),
            Unexpected: _t("The rule is invalid for an unknown reason"),
        },
        ColorScale: _t("Color scale"),
        IconSet: _t("Icon set"),
    };
    const CellIsOperators = {
        IsEmpty: _t("Is empty"),
        IsNotEmpty: _t("Is not empty"),
        ContainsText: _t("Contains"),
        NotContains: _t("Does not contain"),
        BeginsWith: _t("Starts with"),
        EndsWith: _t("Ends with"),
        Equal: _t("Is equal to"),
        NotEqual: _t("Is not equal to"),
        GreaterThan: _t("Is greater than"),
        GreaterThanOrEqual: _t("Is greater than or equal to"),
        LessThan: _t("Is less than"),
        LessThanOrEqual: _t("Is less than or equal to"),
        Between: _t("Is between"),
        NotBetween: _t("Is not between"),
    };
    const ChartTerms = {
        Series: _t("Series"),
        Errors: {
            Unexpected: _t("The chart definition is invalid for an unknown reason"),
            // BASIC CHART ERRORS (LINE | BAR | PIE)
            ["InvalidDataSet" /* CommandResult.InvalidDataSet */]: _t("The dataset is invalid"),
            ["InvalidLabelRange" /* CommandResult.InvalidLabelRange */]: _t("Labels are invalid"),
            // SCORECARD CHART ERRORS
            ["InvalidScorecardKeyValue" /* CommandResult.InvalidScorecardKeyValue */]: _t("The key value is invalid"),
            ["InvalidScorecardBaseline" /* CommandResult.InvalidScorecardBaseline */]: _t("The baseline value is invalid"),
            // GAUGE CHART ERRORS
            ["InvalidGaugeDataRange" /* CommandResult.InvalidGaugeDataRange */]: _t("The data range is invalid"),
            ["EmptyGaugeRangeMin" /* CommandResult.EmptyGaugeRangeMin */]: _t("A minimum range limit value is needed"),
            ["GaugeRangeMinNaN" /* CommandResult.GaugeRangeMinNaN */]: _t("The minimum range limit value must be a number"),
            ["EmptyGaugeRangeMax" /* CommandResult.EmptyGaugeRangeMax */]: _t("A maximum range limit value is needed"),
            ["GaugeRangeMaxNaN" /* CommandResult.GaugeRangeMaxNaN */]: _t("The maximum range limit value must be a number"),
            ["GaugeRangeMinBiggerThanRangeMax" /* CommandResult.GaugeRangeMinBiggerThanRangeMax */]: _t("Minimum range limit must be smaller than maximum range limit"),
            ["GaugeLowerInflectionPointNaN" /* CommandResult.GaugeLowerInflectionPointNaN */]: _t("The lower inflection point value must be a number"),
            ["GaugeUpperInflectionPointNaN" /* CommandResult.GaugeUpperInflectionPointNaN */]: _t("The upper inflection point value must be a number"),
        },
    };
    const CustomCurrencyTerms = {
        Custom: _t("Custom"),
    };
    const MergeErrorMessage = _t("Merged cells are preventing this operation. Unmerge those cells and try again.");
    const SplitToColumnsTerms = {
        Errors: {
            Unexpected: _t("Cannot split the selection for an unknown reason"),
            ["NoSplitSeparatorInSelection" /* CommandResult.NoSplitSeparatorInSelection */]: _t("There is no match for the selected separator in the selection"),
            ["MoreThanOneColumnSelected" /* CommandResult.MoreThanOneColumnSelected */]: _t("Only a selection from a single column can be split"),
            ["SplitWillOverwriteContent" /* CommandResult.SplitWillOverwriteContent */]: _t("Splitting will overwrite existing content"),
        },
    };
    const RemoveDuplicateTerms = {
        Errors: {
            Unexpected: _t("Cannot remove duplicates for an unknown reason"),
            ["MoreThanOneRangeSelected" /* CommandResult.MoreThanOneRangeSelected */]: _t("Please select only one range of cells"),
            ["EmptyTarget" /* CommandResult.EmptyTarget */]: _t("Please select a range of cells containing values."),
            ["NoColumnsProvided" /* CommandResult.NoColumnsProvided */]: _t("Please select at latest one column to analyze."),
            //TODO: Remove it when accept to copy and paste merge cells
            ["WillRemoveExistingMerge" /* CommandResult.WillRemoveExistingMerge */]: PasteInteractiveContent.willRemoveExistingMerge,
        },
    };
    const DVTerms = {
        DateIs: {
            today: _t("today"),
            yesterday: _t("yesterday"),
            tomorrow: _t("tomorrow"),
            lastWeek: _t("in the past week"),
            lastMonth: _t("in the past month"),
            lastYear: _t("in the past year"),
        },
        DateIsBefore: {
            today: _t("today"),
            yesterday: _t("yesterday"),
            tomorrow: _t("tomorrow"),
            lastWeek: _t("one week ago"),
            lastMonth: _t("one month ago"),
            lastYear: _t("one year ago"),
        },
        CriterionError: {
            notEmptyValue: _t("The value must not be empty"),
            numberValue: _t("The value must be a number"),
            dateValue: _t("The value must be a date"),
            validRange: _t("The value must be a valid range"),
        },
    };

    /**
     * This file contains helpers that are common to different runtime charts (mainly
     * line, bar and pie charts)
     */
    /**
     * Get the data from a dataSet
     */
    function getData(getters, ds) {
        if (ds.dataRange) {
            const labelCellZone = ds.labelCell ? [zoneToXc(ds.labelCell.zone)] : [];
            const dataXC = recomputeZones([zoneToXc(ds.dataRange.zone)], labelCellZone)[0];
            if (dataXC === undefined) {
                return [];
            }
            const dataRange = getters.getRangeFromSheetXC(ds.dataRange.sheetId, dataXC);
            return getters.getRangeValues(dataRange).map((value) => (value === "" ? undefined : value));
        }
        return [];
    }
    function filterEmptyDataPoints(labels, datasets) {
        const numberOfDataPoints = Math.max(labels.length, ...datasets.map((dataset) => dataset.data?.length || 0));
        const dataPointsIndexes = range(0, numberOfDataPoints).filter((dataPointIndex) => {
            const label = labels[dataPointIndex];
            const values = datasets.map((dataset) => dataset.data?.[dataPointIndex]);
            return label || values.some((value) => value === 0 || Boolean(value));
        });
        return {
            labels: dataPointsIndexes.map((i) => labels[i] || ""),
            dataSetsValues: datasets.map((dataset) => ({
                ...dataset,
                data: dataPointsIndexes.map((i) => dataset.data[i]),
            })),
        };
    }
    /**
     * Aggregates data based on labels
     */
    function aggregateDataForLabels(labels, datasets) {
        const parseNumber = (value) => (typeof value === "number" ? value : 0);
        const labelSet = new Set(labels);
        const labelMap = {};
        labelSet.forEach((label) => {
            labelMap[label] = new Array(datasets.length).fill(0);
        });
        for (const indexOfLabel of range(0, labels.length)) {
            const label = labels[indexOfLabel];
            for (const indexOfDataset of range(0, datasets.length)) {
                labelMap[label][indexOfDataset] += parseNumber(datasets[indexOfDataset].data[indexOfLabel]);
            }
        }
        return {
            labels: Array.from(labelSet),
            dataSetsValues: datasets.map((dataset, indexOfDataset) => ({
                ...dataset,
                data: Array.from(labelSet).map((label) => labelMap[label][indexOfDataset]),
            })),
        };
    }
    function truncateLabel(label) {
        if (!label) {
            return "";
        }
        if (label.length > MAX_CHAR_LABEL) {
            return label.substring(0, MAX_CHAR_LABEL) + "…";
        }
        return label;
    }
    /**
     * Get a default chart js configuration
     */
    function getDefaultChartJsRuntime(chart, labels, fontColor, { format, locale, truncateLabels = true }) {
        const options = {
            // https://www.chartjs.org/docs/latest/general/responsive.html
            responsive: true, // will resize when its container is resized
            maintainAspectRatio: false, // doesn't maintain the aspect ration (width/height =2 by default) so the user has the choice of the exact layout
            layout: {
                padding: { left: 20, right: 20, top: chart.title ? 10 : 25, bottom: 10 },
            },
            elements: {
                line: {
                    fill: false, // do not fill the area under line charts
                },
                point: {
                    hitRadius: 15, // increased hit radius to display point tooltip when hovering nearby
                },
            },
            animation: false,
            plugins: {
                title: {
                    display: !!chart.title,
                    text: _t(chart.title),
                    color: fontColor,
                    font: { size: 22, weight: "normal" },
                },
                legend: {
                    // Disable default legend onClick (show/hide dataset), to allow us to set a global onClick on the chart container.
                    // If we want to re-enable this in the future, we need to override the default onClick to stop the event propagation
                    onClick: () => { },
                },
                tooltip: {
                    callbacks: {
                        label: function (tooltipItem) {
                            const xLabel = tooltipItem.dataset?.label || tooltipItem.label;
                            // tooltipItem.parsed.y can be an object or a number for pie charts
                            const yLabel = tooltipItem.parsed.y ?? tooltipItem.parsed;
                            const toolTipFormat = !format && Math.abs(yLabel) >= 1000 ? "#,##" : format;
                            const yLabelStr = formatValue(yLabel, { format: toolTipFormat, locale });
                            return xLabel ? `${xLabel}: ${yLabelStr}` : yLabelStr;
                        },
                    },
                },
            },
        };
        return {
            type: chart.type,
            options,
            data: {
                labels: truncateLabels ? labels.map(truncateLabel) : labels,
                datasets: [],
            },
            plugins: [],
        };
    }
    function getChartLabelFormat(getters, range, shouldRemoveFirstLabel) {
        if (!range)
            return undefined;
        const { sheetId, zone } = range;
        const formats = positions(zone).map((position) => getters.getEvaluatedCell({ sheetId, ...position }).format);
        if (shouldRemoveFirstLabel) {
            formats.shift();
        }
        return formats.find((format) => format !== undefined);
    }
    function getChartLabelValues(getters, dataSets, labelRange) {
        let labels = { values: [], formattedValues: [] };
        if (labelRange) {
            if (!labelRange.invalidXc && !labelRange.invalidSheetName) {
                labels = {
                    formattedValues: getters.getRangeFormattedValues(labelRange),
                    values: getters.getRangeValues(labelRange).map((val) => String(val)),
                };
            }
        }
        else if (dataSets.length === 1) {
            const dataLength = getData(getters, dataSets[0]).length;
            for (let i = 0; i < dataLength; i++) {
                labels.formattedValues.push("");
                labels.values.push("");
            }
        }
        else {
            if (dataSets[0]) {
                const ranges = getData(getters, dataSets[0]);
                labels = {
                    formattedValues: range(0, ranges.length).map((r) => r.toString()),
                    values: labels.formattedValues,
                };
            }
        }
        return labels;
    }
    /**
     * Get the format to apply to the the dataset values. This format is defined as the first format
     * found in the dataset ranges that isn't a date format.
     */
    function getChartDatasetFormat(getters, dataSets) {
        for (const ds of dataSets) {
            const formatsInDataset = getters.getRangeFormats(ds.dataRange);
            const format = formatsInDataset.find((f) => f !== undefined && !isDateTimeFormat(f));
            if (format)
                return format;
        }
        return undefined;
    }
    function getChartDatasetValues(getters, dataSets) {
        const datasetValues = [];
        for (const [dsIndex, ds] of Object.entries(dataSets)) {
            let label;
            if (ds.labelCell) {
                const labelRange = ds.labelCell;
                const cell = labelRange
                    ? getters.getEvaluatedCell({
                        sheetId: labelRange.sheetId,
                        col: labelRange.zone.left,
                        row: labelRange.zone.top,
                    })
                    : undefined;
                label =
                    cell && labelRange
                        ? truncateLabel(cell.formattedValue)
                        : (label = `${ChartTerms.Series} ${parseInt(dsIndex) + 1}`);
            }
            else {
                label = label = `${ChartTerms.Series} ${parseInt(dsIndex) + 1}`;
            }
            let data = ds.dataRange ? getData(getters, ds) : [];
            datasetValues.push({ data, label });
        }
        return datasetValues;
    }
    /** See https://www.chartjs.org/docs/latest/charts/area.html#filling-modes */
    function getFillingMode(index) {
        if (index === 0) {
            return "origin";
        }
        else {
            return index - 1;
        }
    }
    function chartToImage(runtime, figure, type) {
        // wrap the canvas in a div with a fixed size because chart.js would
        // fill the whole page otherwise
        const div = document.createElement("div");
        div.style.width = `${figure.width}px`;
        div.style.height = `${figure.height}px`;
        const canvas = document.createElement("canvas");
        div.append(canvas);
        canvas.setAttribute("width", figure.width.toString());
        canvas.setAttribute("height", figure.height.toString());
        // we have to add the canvas to the DOM otherwise it won't be rendered
        document.body.append(div);
        if ("chartJsConfig" in runtime) {
            runtime.chartJsConfig.plugins = [backgroundColorChartJSPlugin];
            // @ts-ignore
            const chart = new window.Chart(canvas, deepCopy(runtime.chartJsConfig));
            const imgContent = chart.toBase64Image();
            chart.destroy();
            div.remove();
            return imgContent;
        }
        else if (type === "scorecard") {
            const design = getScorecardConfiguration(figure, runtime);
            drawScoreChart(design, canvas);
            const imgContent = canvas.toDataURL();
            div.remove();
            return imgContent;
        }
        return "";
    }
    /**
     * Custom chart.js plugin to set the background color of the canvas
     * https://github.com/chartjs/Chart.js/blob/8fdf76f8f02d31684d34704341a5d9217e977491/docs/configuration/canvas-background.md
     */
    const backgroundColorChartJSPlugin = {
        id: "customCanvasBackgroundColor",
        beforeDraw: (chart) => {
            const { ctx } = chart;
            ctx.save();
            ctx.globalCompositeOperation = "destination-over";
            ctx.fillStyle = "#ffffff";
            ctx.fillRect(0, 0, chart.width, chart.height);
            ctx.restore();
        },
    };

    class BarChart extends AbstractChart {
        dataSets;
        labelRange;
        background;
        verticalAxisPosition;
        legendPosition;
        stacked;
        aggregated;
        type = "bar";
        dataSetsHaveTitle;
        constructor(definition, sheetId, getters) {
            super(definition, sheetId, getters);
            this.dataSets = createDataSets(getters, definition.dataSets, sheetId, definition.dataSetsHaveTitle);
            this.labelRange = createValidRange(getters, sheetId, definition.labelRange);
            this.background = definition.background;
            this.verticalAxisPosition = definition.verticalAxisPosition;
            this.legendPosition = definition.legendPosition;
            this.stacked = definition.stacked;
            this.aggregated = definition.aggregated;
            this.dataSetsHaveTitle = definition.dataSetsHaveTitle;
        }
        static transformDefinition(definition, executed) {
            return transformChartDefinitionWithDataSetsWithZone(definition, executed);
        }
        static validateChartDefinition(validator, definition) {
            return validator.checkValidations(definition, checkDataset, checkLabelRange);
        }
        static getDefinitionFromContextCreation(context) {
            return {
                background: context.background,
                dataSets: context.range ? context.range : [],
                dataSetsHaveTitle: false,
                stacked: false,
                aggregated: false,
                legendPosition: "top",
                title: context.title || "",
                type: "bar",
                verticalAxisPosition: "left",
                labelRange: context.auxiliaryRange || undefined,
            };
        }
        getContextCreation() {
            return {
                background: this.background,
                title: this.title,
                range: this.dataSets.map((ds) => this.getters.getRangeString(ds.dataRange, this.sheetId)),
                auxiliaryRange: this.labelRange
                    ? this.getters.getRangeString(this.labelRange, this.sheetId)
                    : undefined,
            };
        }
        copyForSheetId(sheetId) {
            const dataSets = copyDataSetsWithNewSheetId(this.sheetId, sheetId, this.dataSets);
            const labelRange = copyLabelRangeWithNewSheetId(this.sheetId, sheetId, this.labelRange);
            const definition = this.getDefinitionWithSpecificDataSets(dataSets, labelRange, sheetId);
            return new BarChart(definition, sheetId, this.getters);
        }
        copyInSheetId(sheetId) {
            const definition = this.getDefinitionWithSpecificDataSets(this.dataSets, this.labelRange, sheetId);
            return new BarChart(definition, sheetId, this.getters);
        }
        getDefinition() {
            return this.getDefinitionWithSpecificDataSets(this.dataSets, this.labelRange);
        }
        getDefinitionWithSpecificDataSets(dataSets, labelRange, targetSheetId) {
            return {
                type: "bar",
                dataSetsHaveTitle: dataSets.length ? Boolean(dataSets[0].labelCell) : false,
                background: this.background,
                dataSets: dataSets.map((ds) => this.getters.getRangeString(ds.dataRange, targetSheetId || this.sheetId)),
                legendPosition: this.legendPosition,
                verticalAxisPosition: this.verticalAxisPosition,
                labelRange: labelRange
                    ? this.getters.getRangeString(labelRange, targetSheetId || this.sheetId)
                    : undefined,
                title: this.title,
                stacked: this.stacked,
                aggregated: this.aggregated,
            };
        }
        getDefinitionForExcel() {
            const dataSets = this.dataSets
                .map((ds) => toExcelDataset(this.getters, ds))
                .filter((ds) => ds.range !== "" && ds.range !== INCORRECT_RANGE_STRING);
            const labelRange = toExcelLabelRange(this.getters, this.labelRange, shouldRemoveFirstLabel(this.labelRange, this.dataSets[0], this.dataSetsHaveTitle));
            return {
                ...this.getDefinition(),
                backgroundColor: toXlsxHexColor(this.background || BACKGROUND_CHART_COLOR),
                fontColor: toXlsxHexColor(chartFontColor(this.background)),
                dataSets,
                labelRange,
            };
        }
        updateRanges(applyChange) {
            const { dataSets, labelRange, isStale } = updateChartRangesWithDataSets(this.getters, applyChange, this.dataSets, this.labelRange);
            if (!isStale) {
                return this;
            }
            const definition = this.getDefinitionWithSpecificDataSets(dataSets, labelRange);
            return new BarChart(definition, this.sheetId, this.getters);
        }
    }
    function getBarConfiguration(chart, labels, localeFormat) {
        const fontColor = chartFontColor(chart.background);
        const config = getDefaultChartJsRuntime(chart, labels, fontColor, localeFormat);
        const legend = {
            labels: { color: fontColor },
        };
        if ((!chart.labelRange && chart.dataSets.length === 1) || chart.legendPosition === "none") {
            legend.display = false;
        }
        else {
            legend.position = chart.legendPosition;
        }
        config.options.plugins.legend = { ...config.options.plugins?.legend, ...legend };
        config.options.layout = {
            padding: { left: 20, right: 20, top: chart.title ? 10 : 25, bottom: 10 },
        };
        config.options.scales = {
            x: {
                ticks: {
                    padding: 5,
                    color: fontColor,
                },
            },
            y: {
                position: chart.verticalAxisPosition,
                beginAtZero: true, // the origin of the y axis is always zero
                ticks: {
                    color: fontColor,
                    callback: (value) => {
                        value = Number(value);
                        if (isNaN(value))
                            return value;
                        const { locale, format } = localeFormat;
                        return formatValue(value, {
                            locale,
                            format: !format && Math.abs(value) >= 1000 ? "#,##" : format,
                        });
                    },
                },
            },
        };
        if (chart.stacked) {
            // @ts-ignore chart.js type is broken
            config.options.scales.x.stacked = true;
            // @ts-ignore chart.js type is broken
            config.options.scales.y.stacked = true;
        }
        return config;
    }
    function createBarChartRuntime(chart, getters) {
        const labelValues = getChartLabelValues(getters, chart.dataSets, chart.labelRange);
        let labels = labelValues.formattedValues;
        let dataSetsValues = getChartDatasetValues(getters, chart.dataSets);
        if (shouldRemoveFirstLabel(chart.labelRange, chart.dataSets[0], chart.dataSetsHaveTitle)) {
            labels.shift();
        }
        ({ labels, dataSetsValues } = filterEmptyDataPoints(labels, dataSetsValues));
        if (chart.aggregated) {
            ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
        }
        const dataSetFormat = getChartDatasetFormat(getters, chart.dataSets);
        const locale = getters.getLocale();
        const config = getBarConfiguration(chart, labels, { format: dataSetFormat, locale });
        const colors = new ChartColors();
        for (let { label, data } of dataSetsValues) {
            const color = colors.next();
            const dataset = {
                label,
                data,
                borderColor: color,
                backgroundColor: color,
            };
            config.data.datasets.push(dataset);
        }
        return { chartJsConfig: config, background: chart.background || BACKGROUND_CHART_COLOR };
    }

    function isDataRangeValid(definition) {
        return definition.dataRange && !rangeReference.test(definition.dataRange)
            ? "InvalidGaugeDataRange" /* CommandResult.InvalidGaugeDataRange */
            : "Success" /* CommandResult.Success */;
    }
    function checkRangeLimits(check, batchValidations) {
        return batchValidations((definition) => {
            if (definition.sectionRule) {
                return check(definition.sectionRule.rangeMin, "rangeMin");
            }
            return "Success" /* CommandResult.Success */;
        }, (definition) => {
            if (definition.sectionRule) {
                return check(definition.sectionRule.rangeMax, "rangeMax");
            }
            return "Success" /* CommandResult.Success */;
        });
    }
    function checkInflectionPointsValue(check, batchValidations) {
        return batchValidations((definition) => {
            if (definition.sectionRule) {
                return check(definition.sectionRule.lowerInflectionPoint.value, "lowerInflectionPointValue");
            }
            return "Success" /* CommandResult.Success */;
        }, (definition) => {
            if (definition.sectionRule) {
                return check(definition.sectionRule.upperInflectionPoint.value, "upperInflectionPointValue");
            }
            return "Success" /* CommandResult.Success */;
        });
    }
    function checkRangeMinBiggerThanRangeMax(definition) {
        if (definition.sectionRule) {
            if (Number(definition.sectionRule.rangeMin) >= Number(definition.sectionRule.rangeMax)) {
                return "GaugeRangeMinBiggerThanRangeMax" /* CommandResult.GaugeRangeMinBiggerThanRangeMax */;
            }
        }
        return "Success" /* CommandResult.Success */;
    }
    function checkEmpty(value, valueName) {
        if (value === "") {
            switch (valueName) {
                case "rangeMin":
                    return "EmptyGaugeRangeMin" /* CommandResult.EmptyGaugeRangeMin */;
                case "rangeMax":
                    return "EmptyGaugeRangeMax" /* CommandResult.EmptyGaugeRangeMax */;
            }
        }
        return "Success" /* CommandResult.Success */;
    }
    function checkNaN(value, valueName) {
        if (isNaN(value)) {
            switch (valueName) {
                case "rangeMin":
                    return "GaugeRangeMinNaN" /* CommandResult.GaugeRangeMinNaN */;
                case "rangeMax":
                    return "GaugeRangeMaxNaN" /* CommandResult.GaugeRangeMaxNaN */;
                case "lowerInflectionPointValue":
                    return "GaugeLowerInflectionPointNaN" /* CommandResult.GaugeLowerInflectionPointNaN */;
                case "upperInflectionPointValue":
                    return "GaugeUpperInflectionPointNaN" /* CommandResult.GaugeUpperInflectionPointNaN */;
            }
        }
        return "Success" /* CommandResult.Success */;
    }
    class GaugeChart extends AbstractChart {
        dataRange;
        sectionRule;
        background;
        type = "gauge";
        constructor(definition, sheetId, getters) {
            super(definition, sheetId, getters);
            this.dataRange = createValidRange(this.getters, this.sheetId, definition.dataRange);
            this.sectionRule = definition.sectionRule;
            this.background = definition.background;
        }
        static validateChartDefinition(validator, definition) {
            return validator.checkValidations(definition, isDataRangeValid, validator.chainValidations(checkRangeLimits(checkEmpty, validator.batchValidations), checkRangeLimits(checkNaN, validator.batchValidations), checkRangeMinBiggerThanRangeMax), validator.chainValidations(checkInflectionPointsValue(checkNaN, validator.batchValidations)));
        }
        static transformDefinition(definition, executed) {
            let dataRangeZone;
            if (definition.dataRange) {
                dataRangeZone = transformZone(toUnboundedZone(definition.dataRange), executed);
            }
            return {
                ...definition,
                dataRange: dataRangeZone ? zoneToXc(dataRangeZone) : undefined,
            };
        }
        static getDefinitionFromContextCreation(context) {
            return {
                background: context.background,
                title: context.title || "",
                type: "gauge",
                dataRange: context.range ? context.range[0] : undefined,
                sectionRule: {
                    colors: {
                        lowerColor: DEFAULT_GAUGE_LOWER_COLOR,
                        middleColor: DEFAULT_GAUGE_MIDDLE_COLOR,
                        upperColor: DEFAULT_GAUGE_UPPER_COLOR,
                    },
                    rangeMin: "0",
                    rangeMax: "100",
                    lowerInflectionPoint: {
                        type: "percentage",
                        value: "15",
                    },
                    upperInflectionPoint: {
                        type: "percentage",
                        value: "40",
                    },
                },
            };
        }
        copyForSheetId(sheetId) {
            const dataRange = copyLabelRangeWithNewSheetId(this.sheetId, sheetId, this.dataRange);
            const definition = this.getDefinitionWithSpecificRanges(dataRange, sheetId);
            return new GaugeChart(definition, sheetId, this.getters);
        }
        copyInSheetId(sheetId) {
            const definition = this.getDefinitionWithSpecificRanges(this.dataRange, sheetId);
            return new GaugeChart(definition, sheetId, this.getters);
        }
        getDefinition() {
            return this.getDefinitionWithSpecificRanges(this.dataRange);
        }
        getDefinitionWithSpecificRanges(dataRange, targetSheetId) {
            return {
                background: this.background,
                sectionRule: this.sectionRule,
                title: this.title,
                type: "gauge",
                dataRange: dataRange
                    ? this.getters.getRangeString(dataRange, targetSheetId || this.sheetId)
                    : undefined,
            };
        }
        getDefinitionForExcel() {
            // This kind of graph is not exportable in Excel
            return undefined;
        }
        getContextCreation() {
            return {
                background: this.background,
                title: this.title,
                range: this.dataRange
                    ? [this.getters.getRangeString(this.dataRange, this.sheetId)]
                    : undefined,
            };
        }
        updateRanges(applyChange) {
            const range = adaptChartRange(this.dataRange, applyChange);
            if (this.dataRange === range) {
                return this;
            }
            const definition = this.getDefinitionWithSpecificRanges(range);
            return new GaugeChart(definition, this.sheetId, this.getters);
        }
    }
    function getGaugeConfiguration(chart, locale) {
        const fontColor = chartFontColor(chart.background);
        const config = getDefaultChartJsRuntime(chart, [], fontColor, {
            locale,
        });
        config.options.hover = undefined;
        config.options.events = [];
        config.options.layout = {
            padding: { left: 30, right: 30, top: chart.title ? 10 : 25, bottom: 25 },
        };
        config.options.needle = {
            width: 10,
            borderColor: "#000000",
            backgroundColor: "#000000",
        };
        config.options.valueLabel = {
            display: false,
            font: {
                size: 30,
                color: "#FFFFFF",
            },
            backgroundColor: "#000000",
            borderColor: "#000000",
            borderRadius: 5,
            padding: {
                top: 5,
                right: 5,
                bottom: 5,
                left: 5,
            },
        };
        return config;
    }
    function createGaugeChartRuntime(chart, getters) {
        const locale = getters.getLocale();
        const config = getGaugeConfiguration(chart, locale);
        const colors = chart.sectionRule.colors;
        const lowerPoint = chart.sectionRule.lowerInflectionPoint;
        const upperPoint = chart.sectionRule.upperInflectionPoint;
        const lowerPointValue = Number(lowerPoint.value);
        const upperPointValue = Number(upperPoint.value);
        const minNeedleValue = Number(chart.sectionRule.rangeMin);
        const maxNeedleValue = Number(chart.sectionRule.rangeMax);
        const needleCoverage = maxNeedleValue - minNeedleValue;
        const needleInflectionPoint = [];
        if (lowerPoint.value !== "") {
            const lowerPointNeedleValue = lowerPoint.type === "number"
                ? lowerPointValue
                : minNeedleValue + (needleCoverage * lowerPointValue) / 100;
            needleInflectionPoint.push({
                value: clip(lowerPointNeedleValue, minNeedleValue, maxNeedleValue),
                color: colors.lowerColor,
            });
        }
        if (upperPoint.value !== "") {
            const upperPointNeedleValue = upperPoint.type === "number"
                ? upperPointValue
                : minNeedleValue + (needleCoverage * upperPointValue) / 100;
            needleInflectionPoint.push({
                value: clip(upperPointNeedleValue, minNeedleValue, maxNeedleValue),
                color: colors.middleColor,
            });
        }
        const data = [];
        const backgroundColor = [];
        needleInflectionPoint
            .sort((a, b) => a.value - b.value)
            .map((point) => {
            data.push(point.value);
            backgroundColor.push(point.color);
        });
        data.push(maxNeedleValue);
        backgroundColor.push(colors.upperColor);
        const dataRange = chart.dataRange;
        const deltaBeyondRangeLimit = needleCoverage / 30;
        let needleValue = minNeedleValue - deltaBeyondRangeLimit; // make needle value always at the minimum by default
        let cellFormatter = undefined;
        let displayValue = false;
        if (dataRange !== undefined) {
            const cell = getters.getEvaluatedCell({
                sheetId: dataRange.sheetId,
                col: dataRange.zone.left,
                row: dataRange.zone.top,
            });
            if (cell.type === CellValueType.number) {
                // in gauge graph "datasets.value" is used to calculate the angle of the
                // needle in the graph. To prevent the needle from making 360° turns, we
                // clip the value between a min and a max. This min and this max are slightly
                // smaller and slightly larger than minRange and maxRange to mark the fact
                // that the needle is out of the range limits
                needleValue = clip(cell.value, minNeedleValue - deltaBeyondRangeLimit, maxNeedleValue + deltaBeyondRangeLimit);
                // show the original value, not the clipped one
                cellFormatter = () => getters.getRangeFormattedValues(dataRange)[0];
                displayValue = true;
            }
        }
        config.options.valueLabel.display = displayValue;
        config.options.valueLabel.formatter = cellFormatter;
        config.data.datasets.push({
            data,
            minValue: Number(chart.sectionRule.rangeMin),
            value: needleValue,
            backgroundColor,
        });
        return {
            chartJsConfig: config,
            background: getters.getStyleOfSingleCellChart(chart.background, dataRange).background,
        };
    }

    const UNIT_LENGTH = {
        second: 1000,
        minute: 1000 * 60,
        hour: 1000 * 3600,
        day: 1000 * 3600 * 24,
        month: 1000 * 3600 * 24 * 30,
        year: 1000 * 3600 * 24 * 365,
    };
    const Milliseconds = {
        inSeconds: function (milliseconds) {
            return Math.floor(milliseconds / UNIT_LENGTH.second);
        },
        inMinutes: function (milliseconds) {
            return Math.floor(milliseconds / UNIT_LENGTH.minute);
        },
        inHours: function (milliseconds) {
            return Math.floor(milliseconds / UNIT_LENGTH.hour);
        },
        inDays: function (milliseconds) {
            return Math.floor(milliseconds / UNIT_LENGTH.day);
        },
        inMonths: function (milliseconds) {
            return Math.floor(milliseconds / UNIT_LENGTH.month);
        },
        inYears: function (milliseconds) {
            return Math.floor(milliseconds / UNIT_LENGTH.year);
        },
    };
    /**
     * Regex to test if a format string is a date format that can be translated into a luxon time format
     */
    const timeFormatLuxonCompatible = /^((d|dd|m|mm|yyyy|yy|hh|h|ss|a)(-|:|\s|\/))*(d|dd|m|mm|yyyy|yy|hh|h|ss|a)$/i;
    /** Get the time options for the XAxis of ChartJS */
    function getChartTimeOptions(labels, labelFormat, locale) {
        const luxonFormat = convertDateFormatForLuxon(labelFormat);
        const timeUnit = getBestTimeUnitForScale(labels, luxonFormat, locale);
        const displayFormats = {};
        if (timeUnit) {
            displayFormats[timeUnit] = luxonFormat;
        }
        return {
            parser: luxonFormat,
            displayFormats,
            unit: timeUnit ?? false,
            tooltipFormat: luxonFormat,
        };
    }
    /**
     * Convert the given date format into a format that moment.js understands.
     *
     * https://github.com/moment/luxon/blob/master/docs/formatting.md#table-of-tokens
     */
    function convertDateFormatForLuxon(format) {
        // "m" before "h" === month, "m" after "h" === minute
        const indexH = format.indexOf("h");
        if (indexH >= 0) {
            format = format.slice(0, indexH).replace(/m/g, "M") + format.slice(indexH);
        }
        else {
            format = format.replace(/m/g, "M");
        }
        // If we have an "a", we should display hours as AM/PM (h), otherwise display 24 hours format (H)
        if (!format.includes("a")) {
            format = format.replace(/h/g, "H");
        }
        return format;
    }
    /** Get the minimum time unit that the format is able to display */
    function getFormatMinDisplayUnit(format) {
        if (format.includes("s")) {
            return "second";
        }
        else if (format.includes("m")) {
            return "minute";
        }
        else if (format.includes("h") || format.includes("H")) {
            return "hour";
        }
        else if (format.includes("d")) {
            return "day";
        }
        else if (format.includes("M")) {
            return "month";
        }
        return "year";
    }
    /**
     * Returns the best time unit that should be used for the X axis of a chart in order to display all
     * the labels correctly.
     *
     * There is two conditions :
     *  - the format of the labels should be able to display the unit. For example if the format is "DD/MM/YYYY"
     *    it makes no sense to try to use minutes in the X axis
     *  - we want the "best fit" unit. For example if the labels span a period of several days, we want to use days
     *    as a unit, but if they span 200 days, we'd like to use months instead
     *
     */
    function getBestTimeUnitForScale(labels, format, locale) {
        const labelDates = labels.map((label) => parseDateTime(label, locale)?.jsDate);
        if (labelDates.some((date) => date === undefined) || labels.length < 2) {
            return undefined;
        }
        const labelsTimestamps = labelDates.map((date) => date.getTime());
        const period = largeMax(labelsTimestamps) - largeMin(labelsTimestamps);
        const minUnit = getFormatMinDisplayUnit(format);
        if (UNIT_LENGTH.second >= UNIT_LENGTH[minUnit] && Milliseconds.inSeconds(period) < 180) {
            return "second";
        }
        else if (UNIT_LENGTH.minute >= UNIT_LENGTH[minUnit] && Milliseconds.inMinutes(period) < 180) {
            return "minute";
        }
        else if (UNIT_LENGTH.hour >= UNIT_LENGTH[minUnit] && Milliseconds.inHours(period) < 96) {
            return "hour";
        }
        else if (UNIT_LENGTH.day >= UNIT_LENGTH[minUnit] && Milliseconds.inDays(period) < 90) {
            return "day";
        }
        else if (UNIT_LENGTH.month >= UNIT_LENGTH[minUnit] && Milliseconds.inMonths(period) < 36) {
            return "month";
        }
        return "year";
    }

    class LineChart extends AbstractChart {
        dataSets;
        labelRange;
        background;
        verticalAxisPosition;
        legendPosition;
        labelsAsText;
        stacked;
        aggregated;
        type = "line";
        dataSetsHaveTitle;
        cumulative;
        constructor(definition, sheetId, getters) {
            super(definition, sheetId, getters);
            this.dataSets = createDataSets(this.getters, definition.dataSets, sheetId, definition.dataSetsHaveTitle);
            this.labelRange = createValidRange(this.getters, sheetId, definition.labelRange);
            this.background = definition.background;
            this.verticalAxisPosition = definition.verticalAxisPosition;
            this.legendPosition = definition.legendPosition;
            this.labelsAsText = definition.labelsAsText;
            this.stacked = definition.stacked;
            this.aggregated = definition.aggregated;
            this.dataSetsHaveTitle = definition.dataSetsHaveTitle;
            this.cumulative = definition.cumulative;
        }
        static validateChartDefinition(validator, definition) {
            return validator.checkValidations(definition, checkDataset, checkLabelRange);
        }
        static transformDefinition(definition, executed) {
            return transformChartDefinitionWithDataSetsWithZone(definition, executed);
        }
        static getDefinitionFromContextCreation(context) {
            return {
                background: context.background,
                dataSets: context.range ? context.range : [],
                dataSetsHaveTitle: false,
                labelsAsText: false,
                legendPosition: "top",
                title: context.title || "",
                type: "line",
                verticalAxisPosition: "left",
                labelRange: context.auxiliaryRange || undefined,
                stacked: false,
                aggregated: false,
                cumulative: false,
            };
        }
        getDefinition() {
            return this.getDefinitionWithSpecificDataSets(this.dataSets, this.labelRange);
        }
        getDefinitionWithSpecificDataSets(dataSets, labelRange, targetSheetId) {
            return {
                type: "line",
                dataSetsHaveTitle: dataSets.length ? Boolean(dataSets[0].labelCell) : false,
                background: this.background,
                dataSets: dataSets.map((ds) => this.getters.getRangeString(ds.dataRange, targetSheetId || this.sheetId)),
                legendPosition: this.legendPosition,
                verticalAxisPosition: this.verticalAxisPosition,
                labelRange: labelRange
                    ? this.getters.getRangeString(labelRange, targetSheetId || this.sheetId)
                    : undefined,
                title: this.title,
                labelsAsText: this.labelsAsText,
                stacked: this.stacked,
                aggregated: this.aggregated,
                cumulative: this.cumulative,
            };
        }
        getContextCreation() {
            return {
                background: this.background,
                title: this.title,
                range: this.dataSets.map((ds) => this.getters.getRangeString(ds.dataRange, this.sheetId)),
                auxiliaryRange: this.labelRange
                    ? this.getters.getRangeString(this.labelRange, this.sheetId)
                    : undefined,
            };
        }
        updateRanges(applyChange) {
            const { dataSets, labelRange, isStale } = updateChartRangesWithDataSets(this.getters, applyChange, this.dataSets, this.labelRange);
            if (!isStale) {
                return this;
            }
            const definition = this.getDefinitionWithSpecificDataSets(dataSets, labelRange);
            return new LineChart(definition, this.sheetId, this.getters);
        }
        getDefinitionForExcel() {
            const dataSets = this.dataSets
                .map((ds) => toExcelDataset(this.getters, ds))
                .filter((ds) => ds.range !== "" && ds.range !== INCORRECT_RANGE_STRING);
            const labelRange = toExcelLabelRange(this.getters, this.labelRange, shouldRemoveFirstLabel(this.labelRange, this.dataSets[0], this.dataSetsHaveTitle));
            return {
                ...this.getDefinition(),
                backgroundColor: toXlsxHexColor(this.background || BACKGROUND_CHART_COLOR),
                fontColor: toXlsxHexColor(chartFontColor(this.background)),
                dataSets,
                labelRange,
            };
        }
        copyForSheetId(sheetId) {
            const dataSets = copyDataSetsWithNewSheetId(this.sheetId, sheetId, this.dataSets);
            const labelRange = copyLabelRangeWithNewSheetId(this.sheetId, sheetId, this.labelRange);
            const definition = this.getDefinitionWithSpecificDataSets(dataSets, labelRange, sheetId);
            return new LineChart(definition, sheetId, this.getters);
        }
        copyInSheetId(sheetId) {
            const definition = this.getDefinitionWithSpecificDataSets(this.dataSets, this.labelRange, sheetId);
            return new LineChart(definition, sheetId, this.getters);
        }
    }
    function fixEmptyLabelsForDateCharts(labels, dataSetsValues) {
        if (labels.length === 0 || labels.every((label) => !label)) {
            return { labels, dataSetsValues };
        }
        const newLabels = [...labels];
        const newDatasets = deepCopy(dataSetsValues);
        for (let i = 0; i < newLabels.length; i++) {
            if (!newLabels[i]) {
                newLabels[i] = findNextDefinedValue(newLabels, i);
                for (let ds of newDatasets) {
                    ds.data[i] = undefined;
                }
            }
        }
        return { labels: newLabels, dataSetsValues: newDatasets };
    }
    function canChartParseLabels(chart, getters) {
        return canBeDateChart(chart, getters) || canBeLinearChart(chart, getters);
    }
    function getChartAxisType(chart, getters) {
        if (isDateChart(chart, getters) && isLuxonTimeAdapterInstalled()) {
            return "time";
        }
        if (isLinearChart(chart, getters)) {
            return "linear";
        }
        return "category";
    }
    function isDateChart(chart, getters) {
        return !chart.labelsAsText && canBeDateChart(chart, getters);
    }
    function isLinearChart(chart, getters) {
        return !chart.labelsAsText && canBeLinearChart(chart, getters);
    }
    function canBeDateChart(chart, getters) {
        if (!chart.labelRange || !canBeLinearChart(chart, getters)) {
            return false;
        }
        const labelFormat = getChartLabelFormat(getters, chart.labelRange, shouldRemoveFirstLabel(chart.labelRange, chart.dataSets[0], chart.dataSetsHaveTitle));
        return Boolean(labelFormat && timeFormatLuxonCompatible.test(labelFormat));
    }
    function canBeLinearChart(chart, getters) {
        if (!chart.labelRange) {
            return false;
        }
        const labels = getters.getRangeValues(chart.labelRange);
        if (shouldRemoveFirstLabel(chart.labelRange, chart.dataSets[0], chart.dataSetsHaveTitle)) {
            labels.shift();
        }
        if (labels.some((label) => isNaN(Number(label)) && label)) {
            return false;
        }
        if (labels.every((label) => !label)) {
            return false;
        }
        return true;
    }
    function getLineConfiguration(chart, labels, options) {
        const fontColor = chartFontColor(chart.background);
        const config = getDefaultChartJsRuntime(chart, labels, fontColor, options);
        const legend = {
            labels: {
                color: fontColor,
                generateLabels(chart) {
                    // color the legend labels with the dataset color, without any transparency
                    const { data } = chart;
                    /** @ts-ignore */
                    const labels = window.Chart.defaults.plugins.legend.labels
                        .generateLabels(chart);
                    for (const [index, label] of labels.entries()) {
                        label.fillStyle = data.datasets[index].borderColor;
                    }
                    return labels;
                },
            },
        };
        if ((!chart.labelRange && chart.dataSets.length === 1) || chart.legendPosition === "none") {
            legend.display = false;
        }
        else {
            legend.position = chart.legendPosition;
        }
        Object.assign(config.options.plugins.legend || {}, legend);
        config.options.layout = {
            padding: { left: 20, right: 20, top: chart.title ? 10 : 25, bottom: 10 },
        };
        config.options.scales = {
            x: {
                ticks: {
                    padding: 5,
                    color: fontColor,
                },
            },
            y: {
                position: chart.verticalAxisPosition,
                beginAtZero: true, // the origin of the y axis is always zero
                ticks: {
                    color: fontColor,
                    callback: (value) => {
                        value = Number(value);
                        if (isNaN(value))
                            return value;
                        const { locale, format } = options;
                        return formatValue(value, {
                            locale,
                            format: !format && Math.abs(value) >= 1000 ? "#,##" : format,
                        });
                    },
                },
            },
        };
        if (chart.stacked && config.options?.scales?.y) {
            // @ts-ignore chart.js type is wrong
            config.options.scales.y.stacked = true;
        }
        return config;
    }
    function createLineChartRuntime(chart, getters) {
        const axisType = getChartAxisType(chart, getters);
        const labelValues = getChartLabelValues(getters, chart.dataSets, chart.labelRange);
        let labels = axisType === "linear" ? labelValues.values : labelValues.formattedValues;
        let dataSetsValues = getChartDatasetValues(getters, chart.dataSets);
        const removeFirstLabel = shouldRemoveFirstLabel(chart.labelRange, chart.dataSets[0], chart.dataSetsHaveTitle);
        if (removeFirstLabel) {
            labels.shift();
        }
        ({ labels, dataSetsValues } = filterEmptyDataPoints(labels, dataSetsValues));
        if (axisType === "time") {
            ({ labels, dataSetsValues } = fixEmptyLabelsForDateCharts(labels, dataSetsValues));
        }
        if (chart.aggregated) {
            ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
        }
        const locale = getters.getLocale();
        const truncateLabels = axisType === "category";
        const dataSetFormat = getChartDatasetFormat(getters, chart.dataSets);
        const options = { format: dataSetFormat, locale, truncateLabels };
        const config = getLineConfiguration(chart, labels, options);
        const labelFormat = getChartLabelFormat(getters, chart.labelRange, removeFirstLabel);
        if (axisType === "time") {
            const axis = {
                type: "time",
                time: getChartTimeOptions(labels, labelFormat, locale),
            };
            Object.assign(config.options.scales.x, axis);
            config.options.scales.x.ticks.maxTicksLimit = 15;
        }
        else if (axisType === "linear") {
            config.options.scales.x.type = "linear";
            config.options.scales.x.ticks.callback = (value) => formatValue(value, { format: labelFormat, locale });
            config.options.plugins.tooltip.callbacks.title = (tooltipItem) => {
                return formatValue(tooltipItem[0].parsed.x || tooltipItem[0].label, {
                    locale,
                    format: labelFormat,
                });
            };
        }
        const colors = new ChartColors();
        for (let [index, { label, data }] of dataSetsValues.entries()) {
            if (chart.cumulative) {
                let accumulator = 0;
                data = data.map((value) => {
                    if (!isNaN(value)) {
                        accumulator += parseFloat(value);
                        return accumulator;
                    }
                    return value;
                });
            }
            if (["linear", "time"].includes(axisType)) {
                // Replace empty string labels by undefined to make sure chartJS doesn't decide that "" is the same as 0
                data = data.map((y, index) => ({ x: labels[index] || undefined, y }));
            }
            const color = colors.next();
            let backgroundRGBA = colorToRGBA(color);
            if (chart.stacked) {
                backgroundRGBA.a = LINE_FILL_TRANSPARENCY;
            }
            const backgroundColor = rgbaToHex(backgroundRGBA);
            const dataset = {
                label,
                data,
                tension: 0, // 0 -> render straight lines, which is much faster
                borderColor: color,
                backgroundColor,
                pointBackgroundColor: color,
                fill: chart.stacked ? getFillingMode(index) : false,
            };
            config.data.datasets.push(dataset);
        }
        return { chartJsConfig: config, background: chart.background || BACKGROUND_CHART_COLOR };
    }
    let missingTimeAdapterAlreadyWarned = false;
    function isLuxonTimeAdapterInstalled() {
        // @ts-ignore
        if (!window.Chart) {
            return false;
        }
        // @ts-ignore
        const adapter = new window.Chart._adapters._date({});
        // @ts-ignore
        const isInstalled = adapter._id === "luxon";
        if (!isInstalled && !missingTimeAdapterAlreadyWarned) {
            missingTimeAdapterAlreadyWarned = true;
            console.warn("'chartjs-adapter-luxon' time adapter is not installed. Time scale axes are disabled.");
        }
        return isInstalled;
    }

    class PieChart extends AbstractChart {
        dataSets;
        labelRange;
        background;
        legendPosition;
        type = "pie";
        aggregated;
        dataSetsHaveTitle;
        constructor(definition, sheetId, getters) {
            super(definition, sheetId, getters);
            this.dataSets = createDataSets(getters, definition.dataSets, sheetId, definition.dataSetsHaveTitle);
            this.labelRange = createValidRange(getters, sheetId, definition.labelRange);
            this.background = definition.background;
            this.legendPosition = definition.legendPosition;
            this.aggregated = definition.aggregated;
            this.dataSetsHaveTitle = definition.dataSetsHaveTitle;
        }
        static transformDefinition(definition, executed) {
            return transformChartDefinitionWithDataSetsWithZone(definition, executed);
        }
        static validateChartDefinition(validator, definition) {
            return validator.checkValidations(definition, checkDataset, checkLabelRange);
        }
        static getDefinitionFromContextCreation(context) {
            return {
                background: context.background,
                dataSets: context.range ? context.range : [],
                dataSetsHaveTitle: false,
                legendPosition: "top",
                title: context.title || "",
                type: "pie",
                labelRange: context.auxiliaryRange || undefined,
                aggregated: false,
            };
        }
        getDefinition() {
            return this.getDefinitionWithSpecificDataSets(this.dataSets, this.labelRange);
        }
        getContextCreation() {
            return {
                background: this.background,
                title: this.title,
                range: this.dataSets.map((ds) => this.getters.getRangeString(ds.dataRange, this.sheetId)),
                auxiliaryRange: this.labelRange
                    ? this.getters.getRangeString(this.labelRange, this.sheetId)
                    : undefined,
            };
        }
        getDefinitionWithSpecificDataSets(dataSets, labelRange, targetSheetId) {
            return {
                type: "pie",
                dataSetsHaveTitle: dataSets.length ? Boolean(dataSets[0].labelCell) : false,
                background: this.background,
                dataSets: dataSets.map((ds) => this.getters.getRangeString(ds.dataRange, targetSheetId || this.sheetId)),
                legendPosition: this.legendPosition,
                labelRange: labelRange
                    ? this.getters.getRangeString(labelRange, targetSheetId || this.sheetId)
                    : undefined,
                title: this.title,
                aggregated: this.aggregated,
            };
        }
        copyForSheetId(sheetId) {
            const dataSets = copyDataSetsWithNewSheetId(this.sheetId, sheetId, this.dataSets);
            const labelRange = copyLabelRangeWithNewSheetId(this.sheetId, sheetId, this.labelRange);
            const definition = this.getDefinitionWithSpecificDataSets(dataSets, labelRange, sheetId);
            return new PieChart(definition, sheetId, this.getters);
        }
        copyInSheetId(sheetId) {
            const definition = this.getDefinitionWithSpecificDataSets(this.dataSets, this.labelRange, sheetId);
            return new PieChart(definition, sheetId, this.getters);
        }
        getDefinitionForExcel() {
            const dataSets = this.dataSets
                .map((ds) => toExcelDataset(this.getters, ds))
                .filter((ds) => ds.range !== "" && ds.range !== INCORRECT_RANGE_STRING);
            const labelRange = toExcelLabelRange(this.getters, this.labelRange, shouldRemoveFirstLabel(this.labelRange, this.dataSets[0], this.dataSetsHaveTitle));
            return {
                ...this.getDefinition(),
                backgroundColor: toXlsxHexColor(this.background || BACKGROUND_CHART_COLOR),
                fontColor: toXlsxHexColor(chartFontColor(this.background)),
                verticalAxisPosition: "left", //TODO ExcelChartDefinition should be adapted, but can be done later
                dataSets,
                labelRange,
            };
        }
        updateRanges(applyChange) {
            const { dataSets, labelRange, isStale } = updateChartRangesWithDataSets(this.getters, applyChange, this.dataSets, this.labelRange);
            if (!isStale) {
                return this;
            }
            const definition = this.getDefinitionWithSpecificDataSets(dataSets, labelRange);
            return new PieChart(definition, this.sheetId, this.getters);
        }
    }
    function getPieConfiguration(chart, labels, localeFormat) {
        const fontColor = chartFontColor(chart.background);
        const config = getDefaultChartJsRuntime(chart, labels, fontColor, localeFormat);
        const legend = {
            labels: { color: fontColor },
        };
        if ((!chart.labelRange && chart.dataSets.length === 1) || chart.legendPosition === "none") {
            legend.display = false;
        }
        else {
            legend.position = chart.legendPosition;
        }
        Object.assign(config.options.plugins.legend || {}, legend);
        config.options.layout = {
            padding: { left: 20, right: 20, top: chart.title ? 10 : 25, bottom: 10 },
        };
        config.options.plugins.tooltip.callbacks.title = function (tooltipItems) {
            return tooltipItems[0].dataset.label;
        };
        config.options.plugins.tooltip.callbacks.label = function (tooltipItem) {
            const { format, locale } = localeFormat;
            const data = tooltipItem.dataset.data;
            const dataIndex = tooltipItem.dataIndex;
            const percentage = calculatePercentage(data, dataIndex);
            const xLabel = tooltipItem.label || tooltipItem.dataset.label;
            const yLabel = tooltipItem.parsed.y ?? tooltipItem.parsed;
            const toolTipFormat = !format && Math.abs(yLabel) >= 1000 ? "#,##" : format;
            const yLabelStr = formatValue(yLabel, { format: toolTipFormat, locale });
            return xLabel ? `${xLabel}: ${yLabelStr} (${percentage}%)` : `${yLabelStr} (${percentage}%)`;
        };
        return config;
    }
    function getPieColors(colors, dataSetsValues) {
        const pieColors = [];
        const maxLength = largeMax(dataSetsValues.map((ds) => ds.data.length));
        for (let i = 0; i <= maxLength; i++) {
            pieColors.push(colors.next());
        }
        return pieColors;
    }
    function calculatePercentage(dataset, dataIndex) {
        const numericData = dataset.filter((value) => typeof value === "number");
        const total = numericData.reduce((sum, value) => sum + value, 0);
        if (!total) {
            return "";
        }
        const percentage = (dataset[dataIndex] / total) * 100;
        return percentage.toFixed(2);
    }
    function createPieChartRuntime(chart, getters) {
        const labelValues = getChartLabelValues(getters, chart.dataSets, chart.labelRange);
        let labels = labelValues.formattedValues;
        let dataSetsValues = getChartDatasetValues(getters, chart.dataSets);
        if (shouldRemoveFirstLabel(chart.labelRange, chart.dataSets[0], chart.dataSetsHaveTitle)) {
            labels.shift();
        }
        ({ labels, dataSetsValues } = filterEmptyDataPoints(labels, dataSetsValues));
        if (chart.aggregated) {
            ({ labels, dataSetsValues } = aggregateDataForLabels(labels, dataSetsValues));
        }
        const dataSetFormat = getChartDatasetFormat(getters, chart.dataSets);
        const locale = getters.getLocale();
        const config = getPieConfiguration(chart, labels, { format: dataSetFormat, locale });
        const colors = new ChartColors();
        for (let { label, data } of dataSetsValues) {
            const backgroundColor = getPieColors(colors, dataSetsValues);
            const dataset = {
                label,
                data,
                borderColor: chart.background || "#FFFFFF",
                backgroundColor,
            };
            config.data.datasets.push(dataset);
        }
        return { chartJsConfig: config, background: chart.background || BACKGROUND_CHART_COLOR };
    }

    /**
     * This registry is intended to map a cell content (raw string) to
     * an instance of a cell.
     */
    const chartRegistry = new Registry();
    chartRegistry.add("bar", {
        match: (type) => type === "bar",
        createChart: (definition, sheetId, getters) => new BarChart(definition, sheetId, getters),
        getChartRuntime: createBarChartRuntime,
        validateChartDefinition: (validator, definition) => BarChart.validateChartDefinition(validator, definition),
        transformDefinition: (definition, executed) => BarChart.transformDefinition(definition, executed),
        getChartDefinitionFromContextCreation: (context) => BarChart.getDefinitionFromContextCreation(context),
        name: _t("Bar"),
        sequence: 10,
    });
    chartRegistry.add("line", {
        match: (type) => type === "line",
        createChart: (definition, sheetId, getters) => new LineChart(definition, sheetId, getters),
        getChartRuntime: createLineChartRuntime,
        validateChartDefinition: (validator, definition) => LineChart.validateChartDefinition(validator, definition),
        transformDefinition: (definition, executed) => LineChart.transformDefinition(definition, executed),
        getChartDefinitionFromContextCreation: (context) => LineChart.getDefinitionFromContextCreation(context),
        name: _t("Line"),
        sequence: 20,
    });
    chartRegistry.add("pie", {
        match: (type) => type === "pie",
        createChart: (definition, sheetId, getters) => new PieChart(definition, sheetId, getters),
        getChartRuntime: createPieChartRuntime,
        validateChartDefinition: (validator, definition) => PieChart.validateChartDefinition(validator, definition),
        transformDefinition: (definition, executed) => PieChart.transformDefinition(definition, executed),
        getChartDefinitionFromContextCreation: (context) => PieChart.getDefinitionFromContextCreation(context),
        name: _t("Pie"),
        sequence: 30,
    });
    chartRegistry.add("scorecard", {
        match: (type) => type === "scorecard",
        createChart: (definition, sheetId, getters) => new ScorecardChart$1(definition, sheetId, getters),
        getChartRuntime: createScorecardChartRuntime,
        validateChartDefinition: (validator, definition) => ScorecardChart$1.validateChartDefinition(validator, definition),
        transformDefinition: (definition, executed) => ScorecardChart$1.transformDefinition(definition, executed),
        getChartDefinitionFromContextCreation: (context) => ScorecardChart$1.getDefinitionFromContextCreation(context),
        name: _t("Scorecard"),
        sequence: 40,
    });
    chartRegistry.add("gauge", {
        match: (type) => type === "gauge",
        createChart: (definition, sheetId, getters) => new GaugeChart(definition, sheetId, getters),
        getChartRuntime: createGaugeChartRuntime,
        validateChartDefinition: (validator, definition) => GaugeChart.validateChartDefinition(validator, definition),
        transformDefinition: (definition, executed) => GaugeChart.transformDefinition(definition, executed),
        getChartDefinitionFromContextCreation: (context) => GaugeChart.getDefinitionFromContextCreation(context),
        name: _t("Gauge"),
        sequence: 50,
    });
    const chartComponentRegistry = new Registry();
    chartComponentRegistry.add("line", ChartJsComponent);
    chartComponentRegistry.add("bar", ChartJsComponent);
    chartComponentRegistry.add("pie", ChartJsComponent);
    chartComponentRegistry.add("gauge", ChartJsComponent);
    chartComponentRegistry.add("scorecard", ScorecardChart);

    /**
     * Registry intended to support usual currencies. It is mainly used to create
     * currency formats that can be selected or modified when customizing formats.
     */
    const currenciesRegistry = new Registry();

    // -----------------------------------------------------------------------------
    // STYLE
    // -----------------------------------------------------------------------------
    css /* scss */ `
  .o-chart-container {
    width: 100%;
    height: 100%;
    position: relative;
  }
`;
    class ChartFigure extends owl.Component {
        static template = "o-spreadsheet-ChartFigure";
        static components = {};
        onDoubleClick() {
            this.env.model.dispatch("SELECT_FIGURE", { id: this.props.figure.id });
            this.env.openSidePanel("ChartPanel");
        }
        get chartType() {
            return this.env.model.getters.getChartType(this.props.figure.id);
        }
        get chartComponent() {
            const type = this.chartType;
            const component = chartComponentRegistry.get(type);
            if (!component) {
                throw new Error(`Component is not defined for type ${type}`);
            }
            return component;
        }
    }
    ChartFigure.props = {
        figure: Object,
        onFigureDeleted: Function,
    };

    class ImageFigure extends owl.Component {
        static template = "o-spreadsheet-ImageFigure";
        static components = {};
        // ---------------------------------------------------------------------------
        // Getters
        // ---------------------------------------------------------------------------
        get figureId() {
            return this.props.figure.id;
        }
        get getImagePath() {
            return this.env.model.getters.getImagePath(this.figureId);
        }
    }
    ImageFigure.props = {
        figure: Object,
        onFigureDeleted: Function,
    };

    function centerFigurePosition(getters, size) {
        const { x: offsetCorrectionX, y: offsetCorrectionY } = getters.getMainViewportCoordinates();
        const { scrollX, scrollY } = getters.getActiveSheetScrollInfo();
        const dim = getters.getSheetViewDimension();
        const rect = getters.getVisibleRect(getters.getActiveMainViewport());
        const scrollableViewportWidth = Math.min(rect.width, dim.width - offsetCorrectionX);
        const scrollableViewportHeight = Math.min(rect.height, dim.height - offsetCorrectionY);
        const position = {
            x: offsetCorrectionX + scrollX + Math.max(0, (scrollableViewportWidth - size.width) / 2),
            y: offsetCorrectionY + scrollY + Math.max(0, (scrollableViewportHeight - size.height) / 2),
        }; // Position at the center of the scrollable viewport
        return position;
    }
    function getMaxFigureSize(getters, figureSize) {
        const size = deepCopy(figureSize);
        const dim = getters.getSheetViewDimension();
        const maxWidth = dim.width;
        const maxHeight = dim.height;
        if (size.width > maxWidth) {
            const ratio = maxWidth / size.width;
            size.width = maxWidth;
            size.height = size.height * ratio;
        }
        if (size.height > maxHeight) {
            const ratio = maxHeight / size.height;
            size.height = maxHeight;
            size.width = size.width * ratio;
        }
        return size;
    }

    const figureRegistry = new Registry();
    figureRegistry.add("chart", {
        Component: ChartFigure,
        SidePanelComponent: "ChartPanel",
        menuBuilder: getChartMenu,
    });
    figureRegistry.add("image", {
        Component: ImageFigure,
        keepRatio: true,
        minFigSize: 20,
        borderWidth: 0,
        menuBuilder: getImageMenuRegistry,
    });
    function getChartMenu(figureId, onFigureDeleted, env) {
        const menuItemSpecs = [
            {
                id: "edit",
                name: _t("Edit"),
                sequence: 1,
                execute: () => {
                    env.model.dispatch("SELECT_FIGURE", { id: figureId });
                    env.openSidePanel("ChartPanel");
                },
                icon: "o-spreadsheet-Icon.EDIT",
            },
            getCopyMenuItem(figureId, env),
            getCutMenuItem(figureId, env),
            getDeleteMenuItem(figureId, onFigureDeleted, env),
        ];
        return createActions(menuItemSpecs);
    }
    function getImageMenuRegistry(figureId, onFigureDeleted, env) {
        const menuItemSpecs = [
            getCopyMenuItem(figureId, env),
            getCutMenuItem(figureId, env),
            {
                id: "reset_size",
                name: _t("Reset size"),
                sequence: 4,
                execute: async () => {
                    const imagePath = env.model.getters.getImagePath(figureId);
                    const size = env.model.getters.getImageSize(figureId) ??
                        (await env.imageProvider?.getImageOriginalSize(imagePath));
                    if (!env.model.getters.getImageSize(figureId)) {
                        const image = env.model.getters.getImage(figureId);
                        image.size = size;
                    }
                    const { height, width } = getMaxFigureSize(env.model.getters, size);
                    env.model.dispatch("UPDATE_FIGURE", {
                        sheetId: env.model.getters.getActiveSheetId(),
                        id: figureId,
                        height,
                        width,
                    });
                },
                icon: "o-spreadsheet-Icon.REFRESH",
            },
            getDeleteMenuItem(figureId, onFigureDeleted, env),
        ];
        return createActions(menuItemSpecs);
    }
    function getCopyMenuItem(figureId, env) {
        return {
            id: "copy",
            name: _t("Copy"),
            sequence: 2,
            description: "Ctrl+C",
            execute: async () => {
                env.model.dispatch("SELECT_FIGURE", { id: figureId });
                env.model.dispatch("COPY");
                await env.clipboard.write(env.model.getters.getClipboardContent());
            },
            icon: "o-spreadsheet-Icon.COPY",
        };
    }
    function getCutMenuItem(figureId, env) {
        return {
            id: "cut",
            name: _t("Cut"),
            sequence: 3,
            description: "Ctrl+X",
            execute: async () => {
                env.model.dispatch("SELECT_FIGURE", { id: figureId });
                env.model.dispatch("CUT");
                await env.clipboard.write(env.model.getters.getClipboardContent());
            },
            icon: "o-spreadsheet-Icon.CUT",
        };
    }
    function getDeleteMenuItem(figureId, onFigureDeleted, env) {
        return {
            id: "delete",
            name: _t("Delete"),
            sequence: 10,
            execute: () => {
                env.model.dispatch("DELETE_FIGURE", {
                    sheetId: env.model.getters.getActiveSheetId(),
                    id: figureId,
                });
                onFigureDeleted();
            },
            icon: "o-spreadsheet-Icon.DELETE",
        };
    }

    const inverseCommandRegistry = new Registry()
        .add("ADD_COLUMNS_ROWS", inverseAddColumnsRows)
        .add("REMOVE_COLUMNS_ROWS", inverseRemoveColumnsRows)
        .add("ADD_MERGE", inverseAddMerge)
        .add("REMOVE_MERGE", inverseRemoveMerge)
        .add("CREATE_SHEET", inverseCreateSheet)
        .add("DELETE_SHEET", inverseDeleteSheet)
        .add("DUPLICATE_SHEET", inverseDuplicateSheet)
        .add("CREATE_FIGURE", inverseCreateFigure)
        .add("CREATE_CHART", inverseCreateChart)
        .add("HIDE_COLUMNS_ROWS", inverseHideColumnsRows)
        .add("UNHIDE_COLUMNS_ROWS", inverseUnhideColumnsRows);
    for (const cmd of coreTypes.values()) {
        if (!inverseCommandRegistry.contains(cmd)) {
            inverseCommandRegistry.add(cmd, identity);
        }
    }
    function identity(cmd) {
        return [cmd];
    }
    function inverseAddColumnsRows(cmd) {
        const elements = [];
        let start = cmd.base;
        if (cmd.position === "after") {
            start++;
        }
        for (let i = 0; i < cmd.quantity; i++) {
            elements.push(i + start);
        }
        return [
            {
                type: "REMOVE_COLUMNS_ROWS",
                dimension: cmd.dimension,
                elements,
                sheetId: cmd.sheetId,
            },
        ];
    }
    function inverseAddMerge(cmd) {
        return [{ type: "REMOVE_MERGE", sheetId: cmd.sheetId, target: cmd.target }];
    }
    function inverseRemoveMerge(cmd) {
        return [{ type: "ADD_MERGE", sheetId: cmd.sheetId, target: cmd.target }];
    }
    function inverseCreateSheet(cmd) {
        return [{ type: "DELETE_SHEET", sheetId: cmd.sheetId }];
    }
    function inverseDuplicateSheet(cmd) {
        return [{ type: "DELETE_SHEET", sheetId: cmd.sheetIdTo }];
    }
    function inverseRemoveColumnsRows(cmd) {
        const commands = [];
        const elements = [...cmd.elements].sort((a, b) => a - b);
        for (let group of groupConsecutive(elements)) {
            const column = group[0] === 0 ? 0 : group[0] - 1;
            const position = group[0] === 0 ? "before" : "after";
            commands.push({
                type: "ADD_COLUMNS_ROWS",
                dimension: cmd.dimension,
                quantity: group.length,
                base: column,
                sheetId: cmd.sheetId,
                position,
            });
        }
        return commands;
    }
    function inverseDeleteSheet(cmd) {
        return [{ type: "CREATE_SHEET", sheetId: cmd.sheetId, position: 1 }];
    }
    function inverseCreateFigure(cmd) {
        return [{ type: "DELETE_FIGURE", id: cmd.figure.id, sheetId: cmd.sheetId }];
    }
    function inverseCreateChart(cmd) {
        return [{ type: "DELETE_FIGURE", id: cmd.id, sheetId: cmd.sheetId }];
    }
    function inverseHideColumnsRows(cmd) {
        return [
            {
                type: "UNHIDE_COLUMNS_ROWS",
                sheetId: cmd.sheetId,
                dimension: cmd.dimension,
                elements: cmd.elements,
            },
        ];
    }
    function inverseUnhideColumnsRows(cmd) {
        return [
            {
                type: "HIDE_COLUMNS_ROWS",
                sheetId: cmd.sheetId,
                dimension: cmd.dimension,
                elements: cmd.elements,
            },
        ];
    }

    function interactiveCut(env) {
        const result = env.model.dispatch("CUT");
        if (!result.isSuccessful) {
            if (result.isCancelledBecause("WrongCutSelection" /* CommandResult.WrongCutSelection */)) {
                env.raiseError(_t("This operation is not allowed with multiple selections."));
            }
        }
    }

    const AddMergeInteractiveContent = {
        MergeIsDestructive: _t("Merging these cells will only preserve the top-leftmost value. Merge anyway?"),
        MergeInFilter: _t("You can't merge cells inside of an existing filter."),
    };
    function interactiveAddMerge(env, sheetId, target) {
        const result = env.model.dispatch("ADD_MERGE", { sheetId, target });
        if (result.isCancelledBecause("MergeInFilter" /* CommandResult.MergeInFilter */)) {
            env.raiseError(AddMergeInteractiveContent.MergeInFilter);
        }
        else if (result.isCancelledBecause("MergeIsDestructive" /* CommandResult.MergeIsDestructive */)) {
            env.askConfirmation(AddMergeInteractiveContent.MergeIsDestructive, () => {
                env.model.dispatch("ADD_MERGE", { sheetId, target, force: true });
            });
        }
    }

    /**
     * Create a function used to create a Chart based on the definition
     */
    function chartFactory(getters) {
        const builders = chartRegistry.getAll().sort((a, b) => a.sequence - b.sequence);
        function createChart(id, definition, sheetId) {
            const builder = builders.find((builder) => builder.match(definition.type));
            if (!builder) {
                throw new Error(`No builder for this chart: ${definition.type}`);
            }
            return builder.createChart(definition, sheetId, getters);
        }
        return createChart;
    }
    /**
     * Create a function used to create a Chart Runtime based on the chart class
     * instance
     */
    function chartRuntimeFactory(getters) {
        const builders = chartRegistry.getAll().sort((a, b) => a.sequence - b.sequence);
        function createRuntimeChart(chart) {
            const builder = builders.find((builder) => builder.match(chart.type));
            if (!builder) {
                throw new Error("No runtime builder for this chart.");
            }
            return builder.getChartRuntime(chart, getters);
        }
        return createRuntimeChart;
    }
    /**
     * Validate the chart definition given in arguments
     */
    function validateChartDefinition(validator, definition) {
        const validators = chartRegistry.getAll().find((validator) => validator.match(definition.type));
        if (!validators) {
            throw new Error("Unknown chart type.");
        }
        return validators.validateChartDefinition(validator, definition);
    }
    /**
     * Get a new chart definition transformed with the executed command. This
     * functions will be called during operational transform process
     */
    function transformDefinition(definition, executed) {
        const transformation = chartRegistry.getAll().find((factory) => factory.match(definition.type));
        if (!transformation) {
            throw new Error("Unknown chart type.");
        }
        return transformation.transformDefinition(definition, executed);
    }
    /**
     * Get an empty definition based on the given context and the given type
     */
    function getChartDefinitionFromContextCreation(context, type) {
        const chartClass = chartRegistry.get(type);
        return chartClass.getChartDefinitionFromContextCreation(context);
    }
    function getChartTypes() {
        const result = {};
        for (const key of chartRegistry.getKeys()) {
            result[key] = chartRegistry.get(key).name;
        }
        return result;
    }
    /**
     * Return a "smart" chart definition in the given zone. The definition is "smart" because it will
     * use the best type of chart to display the data of the zone.
     *
     * It will also try to find labels and datasets in the range, and try to find title for the datasets.
     *
     * The type of chart will be :
     * - If the zone is a single non-empty cell, returns a scorecard
     * - If the all the labels are numbers/date, returns a line chart
     * - Else returns a bar chart
     */
    function getSmartChartDefinition(zone, getters) {
        let dataSetZone = zone;
        if (zone.left !== zone.right) {
            dataSetZone = { ...zone, left: zone.left + 1 };
        }
        const dataSets = [zoneToXc(dataSetZone)];
        const sheetId = getters.getActiveSheetId();
        const topLeftCell = getters.getCell({ sheetId, col: zone.left, row: zone.top });
        if (getZoneArea(zone) === 1 && topLeftCell?.content) {
            return {
                type: "scorecard",
                title: "",
                background: topLeftCell.style?.fillColor || undefined,
                keyValue: zoneToXc(zone),
                baselineMode: DEFAULT_SCORECARD_BASELINE_MODE,
                baselineColorUp: DEFAULT_SCORECARD_BASELINE_COLOR_UP,
                baselineColorDown: DEFAULT_SCORECARD_BASELINE_COLOR_DOWN,
            };
        }
        let title = "";
        const cellsInFirstRow = getters.getEvaluatedCellsInZone(sheetId, {
            ...dataSetZone,
            bottom: dataSetZone.top,
        });
        const dataSetsHaveTitle = !!cellsInFirstRow.find((cell) => cell.type !== CellValueType.empty && cell.type !== CellValueType.number);
        if (dataSetsHaveTitle) {
            const texts = cellsInFirstRow
                .filter((cell) => cell.type !== CellValueType.error && cell.type !== CellValueType.empty)
                .map((cell) => cell.formattedValue);
            const lastElement = texts.splice(-1)[0];
            title = texts.join(", ");
            if (lastElement) {
                title += (title ? " " + _t("and") + " " : "") + lastElement;
            }
        }
        let labelRangeXc;
        if (zone.left !== zone.right) {
            labelRangeXc = zoneToXc({
                ...zone,
                right: zone.left,
            });
        }
        // Only display legend for several datasets.
        const newLegendPos = dataSetZone.right === dataSetZone.left ? "none" : "top";
        const lineChartDefinition = {
            title,
            dataSets,
            labelsAsText: false,
            stacked: false,
            aggregated: false,
            cumulative: false,
            labelRange: labelRangeXc,
            type: "line",
            dataSetsHaveTitle,
            verticalAxisPosition: "left",
            legendPosition: newLegendPos,
        };
        const chart = new LineChart(lineChartDefinition, sheetId, getters);
        if (canChartParseLabels(chart, getters)) {
            return lineChartDefinition;
        }
        return {
            title,
            dataSets,
            labelRange: labelRangeXc,
            type: "bar",
            stacked: false,
            aggregated: false,
            dataSetsHaveTitle,
            verticalAxisPosition: "left",
            legendPosition: newLegendPos,
        };
    }

    // @ts-ignore
    if (window.Chart) {
        // @ts-ignore
        const DoughnutController = window.Chart?.DoughnutController;
        /**
         * Example :
         * const chart = new Chart(ctx, {
         *   type: "gauge",
         *   data: {
         *     datasets: [
         *       {
         *         borderWidth: 5,
         *         data: [10, 20, 10],
         *         value: 23,
         *         backgroundColor: [
         *           "#dc3545", //red
         *           "#ffc107", //orange
         *           "#28a745", //green
         *         ],
         *       },
         *     ],
         *   },
         *   options: {
         *     plugins: {
         *       title: {
         *         display: true,
         *         text: "Custom Chart Title",
         *         padding: {
         *           top: 10,
         *           bottom: 30,
         *         },
         *         font : {
         *           size : 30
         *         }
         *       },
         *     },
         *     valueLabel: {
         *       display: true,
         *       format: (value) => {
         *         return value.toFixed(2) + "%";
         *       },
         *       font : {
         *         size : 35,
         *         family : "Arial",
         *         color : "#FC0",
         *       },
         *       backgroundColor : "#ccc",
         *       borderColor : "#090",
         *       borderRadius : 50
         *     },
         *     needle: {
         *       display: true,
         *       width: 50,
         *       color: "#DC5",
         *       backgroundColor : "#ccc",
         *     },
         *   },
         * });
         */
        class GaugeController extends DoughnutController {
            static id = "gauge";
            static defaults = {
                ...DoughnutController.defaults,
                circumference: 180,
                rotation: 270,
            };
            static overrides = {
                aspectRatio: 2,
                plugins: {
                    legend: {
                        display: false,
                    },
                    tooltip: {
                        enabled: false,
                    },
                },
            };
            get chartHeight() {
                return Math.abs(this.chart.chartArea.top - this.chart.chartArea.bottom);
            }
            get chartWidth() {
                return Math.abs(this.chart.chartArea.left - this.chart.chartArea.right);
            }
            get needleOptions() {
                const { config } = this.chart;
                const options = config.options;
                // @ts-ignore
                return options?.needle || {};
            }
            get valueLabelOptions() {
                const { config } = this.chart;
                const options = config.options;
                // @ts-ignore
                return options?.valueLabel || {};
            }
            get minValue() {
                const dataset = this.getDataset();
                // @ts-ignore
                return dataset.minValue || 0;
            }
            getValueAngleInPercent(value) {
                const dataset = this.getDataset();
                const data = dataset.data || [];
                const max = Math.max(...data);
                const min = this.minValue;
                return (value - min) / (max - min);
            }
            drawValueLabel(params) {
                const { ctx } = this.chart;
                if (this.valueLabelOptions.display === false) {
                    return;
                }
                // draw background rectangle
                ctx.save();
                ctx.beginPath();
                ctx.fillStyle = params.valueLabel.backgroundColor;
                ctx.strokeStyle = params.valueLabel.borderColor;
                ctx.roundRect(params.valueLabel.rect.x, params.valueLabel.rect.y, params.valueLabel.rect.width, params.valueLabel.rect.height, params.valueLabel.borderRadius);
                ctx.stroke();
                ctx.fill();
                // draw value text
                ctx.textAlign = "center";
                ctx.textBaseline = "middle";
                ctx.font = params.valueLabel.font;
                ctx.fillStyle = params.valueLabel.textColor;
                ctx.fillText(params.valueLabel.valueText, params.valueLabel.textPosition.x, params.valueLabel.textPosition.y);
                ctx.restore();
            }
            drawNeedle(params) {
                const { ctx } = this.chart;
                if (this.needleOptions.display === false) {
                    return;
                }
                // translate & rotate next paths
                ctx.save();
                ctx.translate(params.needle.position.x, params.needle.position.y);
                ctx.rotate(-Math.PI / 2 + Math.PI * params.needle.percent);
                // draw circle
                ctx.beginPath();
                ctx.fillStyle = params.needle.backgroundColor;
                ctx.strokeStyle = params.needle.borderColor;
                ctx.ellipse(0, 0, params.needle.width / 2, params.needle.width / 2, 0, 0, 2 * Math.PI);
                ctx.fill();
                ctx.stroke();
                ctx.closePath();
                // draw needle
                ctx.fillStyle = params.needle.backgroundColor;
                ctx.strokeStyle = params.needle.borderColor;
                ctx.beginPath();
                ctx.moveTo(-params.needle.width / 2, 0);
                ctx.lineTo(0, -params.needle.height + 10);
                ctx.lineTo(+params.needle.width / 2, 0);
                ctx.closePath();
                ctx.fill();
                ctx.stroke();
                ctx.restore();
            }
            computeRenderingParams() {
                const { ctx, config } = this.chart;
                const options = config.options;
                options.layout = options.layout || {};
                options.layout.padding = options.layout.padding || {};
                const formatter = this.valueLabelOptions.formatter;
                const fmt = typeof formatter === "function" ? formatter : (value) => value;
                const dataset = this.getDataset();
                // @ts-ignore value is a custom property for gauge charts
                const value = dataset.value || 0;
                const valueText = fmt(value).toString();
                const percent = this.getValueAngleInPercent(value);
                const fontFamily = this.valueLabelOptions.font?.family || "Arial";
                const optionsFontSize = this.valueLabelOptions.font?.size || 0;
                const fontSize = optionsFontSize >= 1 ? optionsFontSize : 30;
                const font = `${fontSize}px ${fontFamily}`;
                const padding = {
                    right: 0,
                    left: 0,
                    top: 0,
                    bottom: 0,
                    ...this.valueLabelOptions.padding,
                };
                padding.left = padding.left >= 0 ? padding.left : 10;
                padding.right = padding.right >= 0 ? padding.right : 10;
                padding.top = padding.top >= 0 ? padding.top : 10;
                padding.bottom = padding.bottom >= 0 ? padding.bottom : 10;
                const chartArea = this.chart.chartArea;
                const offsetX = this.offsetX || 0;
                const offsetY = this.offsetY || 0;
                const centerX = (chartArea.left + chartArea.right) / 2;
                const centerY = (chartArea.top + chartArea.bottom) / 2;
                const center = {
                    x: centerX + offsetX,
                    y: centerY + offsetY,
                };
                const textPosition = {
                    x: center.x,
                    y: center.y,
                };
                ctx.save();
                ctx.font = font;
                const metrics = ctx.measureText(valueText);
                ctx.restore();
                const textHeight = metrics.fontBoundingBoxAscent - metrics.fontBoundingBoxDescent;
                return {
                    needle: {
                        borderColor: this.needleOptions.borderColor || "#000",
                        backgroundColor: this.needleOptions.backgroundColor || "#000",
                        width: this.needleOptions.width || 10,
                        height: Math.min(this.chartHeight, this.chartWidth / 2),
                        position: {
                            x: textPosition.x,
                            y: textPosition.y,
                        },
                        percent,
                    },
                    valueLabel: {
                        textColor: this.valueLabelOptions.font?.color || "#FFF",
                        backgroundColor: this.valueLabelOptions.backgroundColor || "#000",
                        borderColor: this.valueLabelOptions.borderColor || "#000",
                        borderRadius: this.valueLabelOptions.borderRadius || 10,
                        rect: {
                            x: center.x - metrics.width / 2 - padding.left,
                            y: center.y + textHeight / 2 + padding.top,
                            width: metrics.width + padding.left + padding.right,
                            height: -(textHeight + 6 + padding.top + padding.bottom),
                        },
                        valueText,
                        textPosition,
                        textHeight,
                        font,
                    },
                };
            }
            draw() {
                super.draw();
                const params = this.computeRenderingParams();
                this.drawNeedle(params);
                this.drawValueLabel(params);
            }
            updateElements(elements, start, count, mode) {
                super.updateElements(elements, start, count, mode);
                const dataset = this.getDataset();
                const data = this.getDataset().data;
                // @ts-ignore
                const minValue = dataset.minValue;
                // @ts-ignore
                const rotation = this.chart.options.rotation || 0;
                // @ts-ignore
                const circumference = this.chart.options.circumference || 0;
                for (let arcIndex = 0; arcIndex < data.length; arcIndex++) {
                    const previousValue = arcIndex === 0 ? minValue : data[arcIndex - 1];
                    const startAngleInPercent = this.getValueAngleInPercent(previousValue);
                    const endAngleInPercent = this.getValueAngleInPercent(data[arcIndex]);
                    const startAngle = degreesToRadians(rotation + circumference * startAngleInPercent) - Math.PI / 2;
                    const endAngle = degreesToRadians(rotation + circumference * endAngleInPercent) - Math.PI / 2;
                    const arcCircumference = endAngle - startAngle;
                    const arc = elements[arcIndex];
                    const propertiesUpdates = {
                        startAngle,
                        endAngle,
                        circumference: arcCircumference,
                    };
                    this.updateElement(arc, arcIndex, propertiesUpdates, mode);
                }
            }
        }
        function degreesToRadians(degrees) {
            return (degrees * Math.PI) / 180;
        }
        // @ts-ignore
        window.Chart.register(GaugeController);
    }

    //------------------------------------------------------------------------------
    // Helpers
    //------------------------------------------------------------------------------
    function setFormatter(env, format) {
        env.model.dispatch("CANCEL_EDITION");
        env.model.dispatch("SET_FORMATTING", {
            sheetId: env.model.getters.getActiveSheetId(),
            target: env.model.getters.getSelectedZones(),
            format,
        });
    }
    function setStyle(env, style) {
        env.model.dispatch("SET_FORMATTING", {
            sheetId: env.model.getters.getActiveSheetId(),
            target: env.model.getters.getSelectedZones(),
            style,
        });
    }
    //------------------------------------------------------------------------------
    // Simple actions
    //------------------------------------------------------------------------------
    const PASTE_ACTION = async (env) => paste$1(env);
    const PASTE_VALUE_ACTION = async (env) => paste$1(env, "onlyValue");
    async function paste$1(env, pasteOption) {
        const spreadsheetClipboard = env.model.getters.getClipboardTextContent();
        const osClipboard = await env.clipboard.readText();
        switch (osClipboard.status) {
            case "ok":
                const target = env.model.getters.getSelectedZones();
                if (osClipboard && osClipboard.content !== spreadsheetClipboard) {
                    interactivePasteFromOS(env, target, osClipboard.content, pasteOption);
                }
                else {
                    interactivePaste(env, target, pasteOption);
                }
                if (env.model.getters.isCutOperation() && pasteOption !== "onlyValue") {
                    await env.clipboard.write({ [ClipboardMIMEType.PlainText]: "" });
                }
                break;
            case "notImplemented":
                env.raiseError(_t("Pasting from the context menu is not supported in this browser. Use keyboard shortcuts ctrl+c / ctrl+v instead."));
                break;
            case "permissionDenied":
                env.raiseError(_t("Access to the clipboard denied by the browser. Please enable clipboard permission for this page in your browser settings."));
                break;
        }
    }
    const PASTE_FORMAT_ACTION = (env) => paste$1(env, "onlyFormat");
    //------------------------------------------------------------------------------
    // Grid manipulations
    //------------------------------------------------------------------------------
    const DELETE_CONTENT_ROWS_NAME = (env) => {
        if (env.model.getters.getSelectedZones().length > 1) {
            return _t("Clear rows");
        }
        let first;
        let last;
        const activesRows = env.model.getters.getActiveRows();
        if (activesRows.size !== 0) {
            first = largeMin([...activesRows]);
            last = largeMax([...activesRows]);
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            first = zone.top;
            last = zone.bottom;
        }
        if (first === last) {
            return _t("Clear row %s", (first + 1).toString());
        }
        return _t("Clear rows %s - %s", (first + 1).toString(), (last + 1).toString());
    };
    const DELETE_CONTENT_ROWS_ACTION = (env) => {
        const sheetId = env.model.getters.getActiveSheetId();
        const target = [...env.model.getters.getActiveRows()].map((index) => env.model.getters.getRowsZone(sheetId, index, index));
        env.model.dispatch("DELETE_CONTENT", {
            target,
            sheetId: env.model.getters.getActiveSheetId(),
        });
    };
    const DELETE_CONTENT_COLUMNS_NAME = (env) => {
        if (env.model.getters.getSelectedZones().length > 1) {
            return _t("Clear columns");
        }
        let first;
        let last;
        const activeCols = env.model.getters.getActiveCols();
        if (activeCols.size !== 0) {
            first = largeMin([...activeCols]);
            last = largeMax([...activeCols]);
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            first = zone.left;
            last = zone.right;
        }
        if (first === last) {
            return _t("Clear column %s", numberToLetters(first));
        }
        return _t("Clear columns %s - %s", numberToLetters(first), numberToLetters(last));
    };
    const DELETE_CONTENT_COLUMNS_ACTION = (env) => {
        const sheetId = env.model.getters.getActiveSheetId();
        const target = [...env.model.getters.getActiveCols()].map((index) => env.model.getters.getColsZone(sheetId, index, index));
        env.model.dispatch("DELETE_CONTENT", {
            target,
            sheetId: env.model.getters.getActiveSheetId(),
        });
    };
    const REMOVE_ROWS_NAME = (env) => {
        if (env.model.getters.getSelectedZones().length > 1) {
            return _t("Delete rows");
        }
        let first;
        let last;
        const activesRows = env.model.getters.getActiveRows();
        if (activesRows.size !== 0) {
            first = largeMin([...activesRows]);
            last = largeMax([...activesRows]);
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            first = zone.top;
            last = zone.bottom;
        }
        if (first === last) {
            return _t("Delete row %s", (first + 1).toString());
        }
        return _t("Delete rows %s - %s", (first + 1).toString(), (last + 1).toString());
    };
    const REMOVE_ROWS_ACTION = (env) => {
        let rows = [...env.model.getters.getActiveRows()];
        if (!rows.length) {
            const zone = env.model.getters.getSelectedZones()[0];
            for (let i = zone.top; i <= zone.bottom; i++) {
                rows.push(i);
            }
        }
        env.model.dispatch("REMOVE_COLUMNS_ROWS", {
            sheetId: env.model.getters.getActiveSheetId(),
            dimension: "ROW",
            elements: rows,
        });
    };
    const CAN_REMOVE_COLUMNS_ROWS = (dimension, env) => {
        if ((dimension === "COL" && env.model.getters.getActiveRows().size > 0) ||
            (dimension === "ROW" && env.model.getters.getActiveCols().size > 0)) {
            return false;
        }
        const sheetId = env.model.getters.getActiveSheetId();
        const selectedElements = env.model.getters.getElementsFromSelection(dimension);
        const includesAllVisibleHeaders = env.model.getters.checkElementsIncludeAllVisibleHeaders(sheetId, dimension, selectedElements);
        const includesAllNonFrozenHeaders = env.model.getters.checkElementsIncludeAllNonFrozenHeaders(sheetId, dimension, selectedElements);
        return !includesAllVisibleHeaders && !includesAllNonFrozenHeaders;
    };
    const REMOVE_COLUMNS_NAME = (env) => {
        if (env.model.getters.getSelectedZones().length > 1) {
            return _t("Delete columns");
        }
        let first;
        let last;
        const activeCols = env.model.getters.getActiveCols();
        if (activeCols.size !== 0) {
            first = largeMin([...activeCols]);
            last = largeMax([...activeCols]);
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            first = zone.left;
            last = zone.right;
        }
        if (first === last) {
            return _t("Delete column %s", numberToLetters(first));
        }
        return _t("Delete columns %s - %s", numberToLetters(first), numberToLetters(last));
    };
    const NOT_ALL_VISIBLE_ROWS_SELECTED = (env) => {
        const sheetId = env.model.getters.getActiveSheetId();
        const selectedRows = env.model.getters.getElementsFromSelection("ROW");
        return !env.model.getters.checkElementsIncludeAllVisibleHeaders(sheetId, "ROW", selectedRows);
    };
    const REMOVE_COLUMNS_ACTION = (env) => {
        let columns = [...env.model.getters.getActiveCols()];
        if (!columns.length) {
            const zone = env.model.getters.getSelectedZones()[0];
            for (let i = zone.left; i <= zone.right; i++) {
                columns.push(i);
            }
        }
        env.model.dispatch("REMOVE_COLUMNS_ROWS", {
            sheetId: env.model.getters.getActiveSheetId(),
            dimension: "COL",
            elements: columns,
        });
    };
    const NOT_ALL_VISIBLE_COLS_SELECTED = (env) => {
        const sheetId = env.model.getters.getActiveSheetId();
        const selectedCols = env.model.getters.getElementsFromSelection("COL");
        return !env.model.getters.checkElementsIncludeAllVisibleHeaders(sheetId, "COL", selectedCols);
    };
    const INSERT_ROWS_BEFORE_ACTION = (env) => {
        const activeRows = env.model.getters.getActiveRows();
        let row;
        let quantity;
        if (activeRows.size) {
            row = largeMin([...activeRows]);
            quantity = activeRows.size;
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            row = zone.top;
            quantity = zone.bottom - zone.top + 1;
        }
        env.model.dispatch("ADD_COLUMNS_ROWS", {
            sheetId: env.model.getters.getActiveSheetId(),
            position: "before",
            base: row,
            quantity,
            dimension: "ROW",
        });
    };
    const INSERT_ROWS_AFTER_ACTION = (env) => {
        const activeRows = env.model.getters.getActiveRows();
        let row;
        let quantity;
        if (activeRows.size) {
            row = largeMax([...activeRows]);
            quantity = activeRows.size;
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            row = zone.bottom;
            quantity = zone.bottom - zone.top + 1;
        }
        env.model.dispatch("ADD_COLUMNS_ROWS", {
            sheetId: env.model.getters.getActiveSheetId(),
            position: "after",
            base: row,
            quantity,
            dimension: "ROW",
        });
    };
    const INSERT_COLUMNS_BEFORE_ACTION = (env) => {
        const activeCols = env.model.getters.getActiveCols();
        let column;
        let quantity;
        if (activeCols.size) {
            column = largeMin([...activeCols]);
            quantity = activeCols.size;
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            column = zone.left;
            quantity = zone.right - zone.left + 1;
        }
        env.model.dispatch("ADD_COLUMNS_ROWS", {
            sheetId: env.model.getters.getActiveSheetId(),
            position: "before",
            dimension: "COL",
            base: column,
            quantity,
        });
    };
    const INSERT_COLUMNS_AFTER_ACTION = (env) => {
        const activeCols = env.model.getters.getActiveCols();
        let column;
        let quantity;
        if (activeCols.size) {
            column = largeMax([...activeCols]);
            quantity = activeCols.size;
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            column = zone.right;
            quantity = zone.right - zone.left + 1;
        }
        env.model.dispatch("ADD_COLUMNS_ROWS", {
            sheetId: env.model.getters.getActiveSheetId(),
            position: "after",
            dimension: "COL",
            base: column,
            quantity,
        });
    };
    const HIDE_COLUMNS_NAME = (env) => {
        const cols = env.model.getters.getElementsFromSelection("COL");
        let first = cols[0];
        let last = cols[cols.length - 1];
        if (cols.length === 1) {
            return _t("Hide column %s", numberToLetters(first).toString());
        }
        else if (last - first + 1 === cols.length) {
            return _t("Hide columns %s - %s", numberToLetters(first).toString(), numberToLetters(last).toString());
        }
        else {
            return _t("Hide columns");
        }
    };
    const HIDE_ROWS_NAME = (env) => {
        const rows = env.model.getters.getElementsFromSelection("ROW");
        let first = rows[0];
        let last = rows[rows.length - 1];
        if (rows.length === 1) {
            return _t("Hide row %s", (first + 1).toString());
        }
        else if (last - first + 1 === rows.length) {
            return _t("Hide rows %s - %s", (first + 1).toString(), (last + 1).toString());
        }
        else {
            return _t("Hide rows");
        }
    };
    //------------------------------------------------------------------------------
    // Charts
    //------------------------------------------------------------------------------
    const CREATE_CHART = (env) => {
        const getters = env.model.getters;
        const id = env.model.uuidGenerator.smallUuid();
        const sheetId = getters.getActiveSheetId();
        if (getZoneArea(env.model.getters.getSelectedZone()) === 1) {
            env.model.selection.selectTableAroundSelection();
        }
        const size = { width: DEFAULT_FIGURE_WIDTH, height: DEFAULT_FIGURE_HEIGHT };
        const position = getChartPositionAtCenterOfViewport(getters, size);
        const result = env.model.dispatch("CREATE_CHART", {
            sheetId,
            id,
            position,
            size,
            definition: getSmartChartDefinition(env.model.getters.getSelectedZone(), env.model.getters),
        });
        if (result.isSuccessful) {
            env.model.dispatch("SELECT_FIGURE", { id });
            env.openSidePanel("ChartPanel");
        }
    };
    //------------------------------------------------------------------------------
    // Image
    //------------------------------------------------------------------------------
    async function requestImage(env) {
        try {
            return await env.imageProvider.requestImage();
        }
        catch {
            env.raiseError(_t("An unexpected error occurred during the image transfer"));
            return undefined;
        }
    }
    const CREATE_IMAGE = async (env) => {
        if (env.imageProvider) {
            const sheetId = env.model.getters.getActiveSheetId();
            const figureId = env.model.uuidGenerator.smallUuid();
            const image = await requestImage(env);
            if (!image) {
                throw new Error("No image provider was given to the environment");
            }
            const size = getMaxFigureSize(env.model.getters, image.size);
            const position = centerFigurePosition(env.model.getters, size);
            env.model.dispatch("CREATE_IMAGE", {
                sheetId,
                figureId,
                position,
                size,
                definition: image,
            });
        }
    };
    //------------------------------------------------------------------------------
    // Style/Format
    //------------------------------------------------------------------------------
    const FORMAT_PERCENT_ACTION = (env) => setFormatter(env, "0.00%");
    //------------------------------------------------------------------------------
    // Side panel
    //------------------------------------------------------------------------------
    const OPEN_CF_SIDEPANEL_ACTION = (env) => {
        env.openSidePanel("ConditionalFormatting", { selection: env.model.getters.getSelectedZones() });
    };
    const INSERT_LINK = (env) => {
        let { col, row } = env.model.getters.getActivePosition();
        env.model.dispatch("OPEN_CELL_POPOVER", { col, row, popoverType: "LinkEditor" });
    };
    const INSERT_LINK_NAME = (env) => {
        const sheetId = env.model.getters.getActiveSheetId();
        const { col, row } = env.model.getters.getActivePosition();
        const cell = env.model.getters.getEvaluatedCell({ sheetId, col, row });
        return cell && cell.link ? _t("Edit link") : _t("Insert link");
    };
    //------------------------------------------------------------------------------
    // Filters action
    //------------------------------------------------------------------------------
    const SELECTION_CONTAINS_FILTER = (env) => {
        const sheetId = env.model.getters.getActiveSheetId();
        const selectedZones = env.model.getters.getSelectedZones();
        return env.model.getters.doesZonesContainFilter(sheetId, selectedZones);
    };
    //------------------------------------------------------------------------------
    // Sorting action
    //------------------------------------------------------------------------------
    const IS_ONLY_ONE_RANGE = (env) => {
        return env.model.getters.getSelectedZones().length === 1;
    };
    const CAN_INSERT_HEADER = (env, dimension) => {
        if (!IS_ONLY_ONE_RANGE(env)) {
            return false;
        }
        const activeHeaders = dimension === "COL" ? env.model.getters.getActiveCols() : env.model.getters.getActiveRows();
        const ortogonalActiveHeaders = dimension === "COL" ? env.model.getters.getActiveRows() : env.model.getters.getActiveCols();
        const sheetId = env.model.getters.getActiveSheetId();
        const zone = env.model.getters.getSelectedZone();
        const allSheetSelected = isEqual(zone, env.model.getters.getSheetZone(sheetId));
        return isConsecutive(activeHeaders) && (ortogonalActiveHeaders.size === 0 || allSheetSelected);
    };

    const undo = {
        name: _t("Undo"),
        description: "Ctrl+Z",
        execute: (env) => env.model.dispatch("REQUEST_UNDO"),
        isEnabled: (env) => env.model.getters.canUndo(),
        icon: "o-spreadsheet-Icon.UNDO",
    };
    const redo = {
        name: _t("Redo"),
        description: "Ctrl+Y",
        execute: (env) => env.model.dispatch("REQUEST_REDO"),
        isEnabled: (env) => env.model.getters.canRedo(),
        icon: "o-spreadsheet-Icon.REDO",
    };
    const copy = {
        name: _t("Copy"),
        description: "Ctrl+C",
        isReadonlyAllowed: true,
        execute: async (env) => {
            env.model.dispatch("COPY");
            await env.clipboard.write(env.model.getters.getClipboardContent());
        },
        icon: "o-spreadsheet-Icon.COPY",
    };
    const cut = {
        name: _t("Cut"),
        description: "Ctrl+X",
        execute: async (env) => {
            interactiveCut(env);
            await env.clipboard.write(env.model.getters.getClipboardContent());
        },
        icon: "o-spreadsheet-Icon.CUT",
    };
    const paste = {
        name: _t("Paste"),
        description: "Ctrl+V",
        execute: PASTE_ACTION,
        icon: "o-spreadsheet-Icon.PASTE",
    };
    const pasteSpecial = {
        name: _t("Paste special"),
        isVisible: (env) => {
            return !env.model.getters.isCutOperation();
        },
        icon: "o-spreadsheet-Icon.PASTE",
    };
    const pasteSpecialValue = {
        name: _t("Paste value only"),
        description: "Ctrl+Shift+V",
        execute: PASTE_VALUE_ACTION,
    };
    const pasteSpecialFormat = {
        name: _t("Paste format only"),
        execute: PASTE_FORMAT_ACTION,
    };
    const findAndReplace = {
        name: _t("Find and replace"),
        description: "Ctrl+H",
        isReadonlyAllowed: true,
        execute: (env) => {
            env.openSidePanel("FindAndReplace", {});
        },
        icon: "o-spreadsheet-Icon.FIND_AND_REPLACE",
    };
    const deleteValues = {
        name: _t("Delete values"),
        execute: (env) => env.model.dispatch("DELETE_CONTENT", {
            sheetId: env.model.getters.getActiveSheetId(),
            target: env.model.getters.getSelectedZones(),
        }),
    };
    const deleteRows = {
        name: REMOVE_ROWS_NAME,
        execute: REMOVE_ROWS_ACTION,
        isVisible: (env) => CAN_REMOVE_COLUMNS_ROWS("ROW", env),
    };
    const deleteRow = {
        ...deleteRows,
        isVisible: IS_ONLY_ONE_RANGE,
    };
    const clearRows = {
        name: DELETE_CONTENT_ROWS_NAME,
        execute: DELETE_CONTENT_ROWS_ACTION,
    };
    const deleteCols = {
        name: REMOVE_COLUMNS_NAME,
        execute: REMOVE_COLUMNS_ACTION,
        isVisible: (env) => CAN_REMOVE_COLUMNS_ROWS("COL", env),
    };
    const deleteCol = {
        ...deleteCols,
        isVisible: IS_ONLY_ONE_RANGE,
    };
    const clearCols = {
        name: DELETE_CONTENT_COLUMNS_NAME,
        execute: DELETE_CONTENT_COLUMNS_ACTION,
    };
    const deleteCells = {
        name: _t("Delete cells"),
        isVisible: IS_ONLY_ONE_RANGE,
    };
    const deleteCellShiftUp = {
        name: _t("Delete cell and shift up"),
        execute: (env) => {
            const zone = env.model.getters.getSelectedZone();
            const result = env.model.dispatch("DELETE_CELL", { zone, shiftDimension: "ROW" });
            handlePasteResult(env, result);
        },
    };
    const deleteCellShiftLeft = {
        name: _t("Delete cell and shift left"),
        execute: (env) => {
            const zone = env.model.getters.getSelectedZone();
            const result = env.model.dispatch("DELETE_CELL", { zone, shiftDimension: "COL" });
            handlePasteResult(env, result);
        },
    };
    const mergeCells = {
        name: _t("Merge cells"),
        isEnabled: (env) => !cannotMerge(env),
        isActive: (env) => isInMerge(env),
        execute: (env) => toggleMerge(env),
        icon: "o-spreadsheet-Icon.MERGE_CELL",
    };
    function cannotMerge(env) {
        const zones = env.model.getters.getSelectedZones();
        const { top, left, right, bottom } = env.model.getters.getSelectedZone();
        const { sheetId } = env.model.getters.getActivePosition();
        const { xSplit, ySplit } = env.model.getters.getPaneDivisions(sheetId);
        return (zones.length > 1 ||
            (top === bottom && left === right) ||
            (left < xSplit && xSplit <= right) ||
            (top < ySplit && ySplit <= bottom));
    }
    function isInMerge(env) {
        if (!cannotMerge(env)) {
            const zones = env.model.getters.getSelectedZones();
            const { col, row, sheetId } = env.model.getters.getActivePosition();
            const zone = env.model.getters.expandZone(sheetId, positionToZone({ col, row }));
            return isEqual(zones[0], zone);
        }
        return false;
    }
    function toggleMerge(env) {
        if (cannotMerge(env)) {
            return;
        }
        const zones = env.model.getters.getSelectedZones();
        const target = [zones[zones.length - 1]];
        const sheetId = env.model.getters.getActiveSheetId();
        if (isInMerge(env)) {
            env.model.dispatch("REMOVE_MERGE", { sheetId, target });
        }
        else {
            interactiveAddMerge(env, sheetId, target);
        }
    }

    var ACTION_EDIT = /*#__PURE__*/Object.freeze({
        __proto__: null,
        clearCols: clearCols,
        clearRows: clearRows,
        copy: copy,
        cut: cut,
        deleteCellShiftLeft: deleteCellShiftLeft,
        deleteCellShiftUp: deleteCellShiftUp,
        deleteCells: deleteCells,
        deleteCol: deleteCol,
        deleteCols: deleteCols,
        deleteRow: deleteRow,
        deleteRows: deleteRows,
        deleteValues: deleteValues,
        findAndReplace: findAndReplace,
        mergeCells: mergeCells,
        paste: paste,
        pasteSpecial: pasteSpecial,
        pasteSpecialFormat: pasteSpecialFormat,
        pasteSpecialValue: pasteSpecialValue,
        redo: redo,
        undo: undo
    });

    //------------------------------------------------------------------------------
    // Arg description DSL
    //------------------------------------------------------------------------------
    const ARG_REGEXP = /(.*?)\((.*?)\)(.*)/;
    const ARG_TYPES = [
        "ANY",
        "BOOLEAN",
        "DATE",
        "NUMBER",
        "STRING",
        "RANGE",
        "RANGE<BOOLEAN>",
        "RANGE<DATE>",
        "RANGE<NUMBER>",
        "RANGE<STRING>",
        "META",
    ];
    function arg(definition, description = "") {
        return makeArg(definition, description);
    }
    function makeArg(str, description) {
        let parts = str.match(ARG_REGEXP);
        let name = parts[1].trim();
        if (!name) {
            throw new Error(`Function argument definition is missing a name: '${str}'.`);
        }
        let types = [];
        let isOptional = false;
        let isRepeating = false;
        let isLazy = false;
        let defaultValue;
        for (let param of parts[2].split(",")) {
            const key = param.trim().toUpperCase();
            let type = ARG_TYPES.find((t) => key === t);
            if (type) {
                types.push(type);
            }
            else if (key === "RANGE<ANY>") {
                types.push("RANGE");
            }
            else if (key === "OPTIONAL") {
                isOptional = true;
            }
            else if (key === "REPEATING") {
                isRepeating = true;
            }
            else if (key === "LAZY") {
                isLazy = true;
            }
            else if (key.startsWith("DEFAULT=")) {
                defaultValue = param.trim().slice(8);
            }
        }
        const result = {
            name,
            description,
            type: types,
        };
        if (isOptional) {
            result.optional = true;
        }
        if (isRepeating) {
            result.repeating = true;
        }
        if (isLazy) {
            result.lazy = true;
        }
        if (defaultValue !== undefined) {
            result.default = true;
            result.defaultValue = defaultValue;
        }
        if (types.some((t) => t.startsWith("RANGE"))) {
            result.acceptMatrix = true;
        }
        return result;
    }
    /**
     * This function adds on description more general information derived from the
     * arguments.
     *
     * This information is useful during compilation.
     */
    function addMetaInfoFromArg(addDescr) {
        let countArg = 0;
        let minArg = 0;
        let repeatingArg = 0;
        for (let arg of addDescr.args) {
            countArg++;
            if (!arg.optional && !arg.repeating && !arg.default) {
                minArg++;
            }
            if (arg.repeating) {
                repeatingArg++;
            }
        }
        const descr = addDescr;
        descr.minArgRequired = minArg;
        descr.maxArgPossible = repeatingArg ? Infinity : countArg;
        descr.nbrArgRepeating = repeatingArg;
        descr.getArgToFocus = argTargeting(countArg, repeatingArg);
        descr.hidden = addDescr.hidden || false;
        return descr;
    }
    /**
     * Returns a function allowing finding which argument corresponds a position
     * in a function. This is particularly useful for functions with repeatable
     * arguments.
     *
     * Indeed the function makes it possible to etablish corespondance between
     * arguments when the number of arguments supplied is greater than the number of
     * arguments defined by the function.
     *
     * Ex:
     *
     * in the formula "=SUM(11, 55, 66)" which is defined like this "SUM(value1, [value2, ...])"
     * - 11 corresponds to the value1 argument => position will be 1
     * - 55 corresponds to the [value2, ...] argument => position will be 2
     * - 66 corresponds to the [value2, ...] argument => position will be 2
     *
     * in the formula "=AVERAGE.WEIGHTED(1, 2, 3, 4, 5, 6)" which is defined like this
     * "AVERAGE.WEIGHTED(values, weights, [additional_values, ...], [additional_weights, ...])"
     * - 1 corresponds to the values argument => position will be 1
     * - 2 corresponds to the weights argument => position will be 2
     * - 3 corresponds to the [additional_values, ...] argument => position will be 3
     * - 4 corresponds to the [additional_weights, ...] argument => position will be 4
     * - 5 corresponds to the [additional_values, ...] argument => position will be 3
     * - 6 corresponds to the [additional_weights, ...] argument => position will be 4
     */
    function argTargeting(countArg, repeatingArg) {
        if (!repeatingArg) {
            return (argPosition) => argPosition;
        }
        if (repeatingArg === 1) {
            return (argPosition) => Math.min(argPosition, countArg);
        }
        const argBeforeRepeat = countArg - repeatingArg;
        return (argPosition) => {
            if (argPosition <= argBeforeRepeat) {
                return argPosition;
            }
            const argAfterRepeat = (argPosition - argBeforeRepeat) % repeatingArg || repeatingArg;
            return argBeforeRepeat + argAfterRepeat;
        };
    }
    //------------------------------------------------------------------------------
    // Argument validation
    //------------------------------------------------------------------------------
    function validateArguments(args) {
        let previousArgRepeating = false;
        let previousArgOptional = false;
        let previousArgDefault = false;
        for (let current of args) {
            if (current.type.includes("META") && current.type.length > 1) {
                throw new Error(_t("Function ${name} has an argument that has been declared with more than one type whose type 'META'. The 'META' type can only be declared alone."));
            }
            if (previousArgRepeating && !current.repeating) {
                throw new Error(_t("Function ${name} has no-repeatable arguments declared after repeatable ones. All repeatable arguments must be declared last."));
            }
            const previousIsOptional = previousArgOptional || previousArgRepeating || previousArgDefault;
            const currentIsntOptional = !(current.optional || current.repeating || current.default);
            if (previousIsOptional && currentIsntOptional) {
                throw new Error(_t("Function ${name} has at mandatory arguments declared after optional ones. All optional arguments must be after all mandatory arguments."));
            }
            previousArgRepeating = current.repeating;
            previousArgOptional = current.optional;
            previousArgDefault = current.default;
        }
    }

    function assertSingleColOrRow(errorStr, arg) {
        assert(() => arg.length === 1 || arg[0].length === 1, errorStr);
    }
    function assertSameDimensions(errorStr, ...args) {
        if (args.every(isMatrix)) {
            const cols = args[0].length;
            const rows = args[0][0].length;
            for (const arg of args) {
                assert(() => arg.length === cols && arg[0].length === rows, errorStr);
            }
            return;
        }
        if (args.some((arg) => Array.isArray(arg) && (arg.length !== 1 || arg[0].length !== 1))) {
            throw new Error(errorStr);
        }
    }
    function assertPositive(errorStr, arg) {
        assert(() => arg > 0, errorStr);
    }
    function assertSquareMatrix(errorStr, arg) {
        assert(() => arg.length === arg[0].length, errorStr);
    }
    function isNumberMatrix(arg) {
        return arg.every((row) => row.every((val) => typeof val === "number"));
    }

    function getUnitMatrix(n) {
        const matrix = Array(n);
        for (let i = 0; i < n; i++) {
            matrix[i] = Array(n).fill(0);
            matrix[i][i] = 1;
        }
        return matrix;
    }
    /**
     * Invert a matrix and compute its determinant using Gaussian Elimination.
     *
     * The Matrix should be a square matrix, and should be indexed [col][row] instead of the
     * standard mathematical indexing [row][col].
     */
    function invertMatrix(M) {
        // Use Gaussian Elimination to calculate the inverse:
        // (1) 'augment' the matrix (left) by the identity (on the right)
        // (2) Turn the matrix on the left into the identity using elementary row operations
        // (3) The matrix on the right becomes the inverse (was the identity matrix)
        //
        // There are 3 elementary row operations:
        // (a) Swap 2 rows. This multiply the determinant by -1.
        // (b) Multiply a row by a scalar. This multiply the determinant by that scalar.
        // (c) Add to a row a multiple of another row. This does not change the determinant.
        if (M.length < 1 || M[0].length < 1) {
            throw new Error("invertMatrix: an empty matrix cannot be inverted.");
        }
        if (M.length !== M[0].length) {
            throw new Error("invertMatrix: only square matrices are invertible");
        }
        let determinant = 1;
        const dim = M.length;
        const I = getUnitMatrix(dim);
        const C = M.map((row) => row.slice());
        // Perform elementary row operations
        for (let pivot = 0; pivot < dim; pivot++) {
            let diagonalElement = C[pivot][pivot];
            // if we have a 0 on the diagonal we'll need to swap with a lower row
            if (diagonalElement === 0) {
                //look through every row below the i'th row
                for (let row = pivot + 1; row < dim; row++) {
                    //if the ii'th row has a non-0 in the i'th col, swap it with that row
                    if (C[pivot][row] != 0) {
                        swapMatrixRows(C, pivot, row);
                        swapMatrixRows(I, pivot, row);
                        determinant *= -1;
                        break;
                    }
                }
                diagonalElement = C[pivot][pivot];
                //if it's still 0, matrix isn't invertible
                if (diagonalElement === 0) {
                    return { determinant: 0 };
                }
            }
            // Scale this row down by e (so we have a 1 on the diagonal)
            for (let col = 0; col < dim; col++) {
                C[col][pivot] = C[col][pivot] / diagonalElement;
                I[col][pivot] = I[col][pivot] / diagonalElement;
            }
            determinant *= diagonalElement;
            // Subtract a multiple of the current row from ALL of
            // the other rows so that there will be 0's in this column in the
            // rows above and below this one
            for (let row = 0; row < dim; row++) {
                if (row === pivot) {
                    continue;
                }
                // We want to change this element to 0
                const e = C[pivot][row];
                // Subtract (the row above(or below) scaled by e) from (the
                // current row) but start at the i'th column and assume all the
                // stuff left of diagonal is 0 (which it should be if we made this
                // algorithm correctly)
                for (let col = 0; col < dim; col++) {
                    C[col][row] -= e * C[col][pivot];
                    I[col][row] -= e * I[col][pivot];
                }
            }
        }
        // We've done all operations, C should be the identity matrix I should be the inverse
        return { inverted: I, determinant };
    }
    function swapMatrixRows(matrix, row1, row2) {
        for (let i = 0; i < matrix.length; i++) {
            const tmp = matrix[i][row1];
            matrix[i][row1] = matrix[i][row2];
            matrix[i][row2] = tmp;
        }
    }
    /**
     * Matrix multiplication of 2 matrices.
     * ex: matrix1 : n x l, matrix2 : m x n => result : m x l
     *
     * Note: we use indexing [col][row] instead of the standard mathematical notation [row][col]
     */
    function multiplyMatrices(matrix1, matrix2) {
        if (matrix1.length < 1 || matrix2.length < 1) {
            throw new Error("multiplyMatrices: empty matrices cannot be multiplied.");
        }
        if (matrix1.length !== matrix2[0].length) {
            throw new Error("multiplyMatrices: incompatible matrices size.");
        }
        const rowsM1 = matrix1[0].length;
        const colsM2 = matrix2.length;
        const n = matrix1.length;
        const result = Array(colsM2);
        for (let col = 0; col < colsM2; col++) {
            result[col] = Array(rowsM1);
            for (let row = 0; row < rowsM1; row++) {
                let sum = 0;
                for (let k = 0; k < n; k++) {
                    sum += matrix1[k][row] * matrix2[col][k];
                }
                result[col][row] = sum;
            }
        }
        return result;
    }
    /**
     * Return the input if it's a scalar or the first element of the input if it's a matrix.
     */
    function toScalar(matrix) {
        if (!isMatrix(matrix)) {
            return matrix;
        }
        if (matrix.length !== 1 || matrix[0].length !== 1) {
            throw new Error("toScalar: matrix should be a scalar or a 1x1 matrix");
        }
        return matrix[0][0];
    }

    // -----------------------------------------------------------------------------
    // ARRAY_CONSTRAIN
    // -----------------------------------------------------------------------------
    const ARRAY_CONSTRAIN = {
        description: _t("Returns a result array constrained to a specific width and height."),
        args: [
            arg("input_range (any, range<any>)", _t("The range to constrain.")),
            arg("rows (number)", _t("The number of rows in the constrained array.")),
            arg("columns (number)", _t("The number of columns in the constrained array.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (array, rows, columns) {
            const _array = toMatrix(array);
            const _rowsArg = toInteger(rows?.value, this.locale);
            const _columnsArg = toInteger(columns?.value, this.locale);
            assertPositive(_t("The rows argument (%s) must be strictly positive.", _rowsArg.toString()), _rowsArg);
            assertPositive(_t("The columns argument (%s) must be strictly positive.", _rowsArg.toString()), _columnsArg);
            const _nbRows = Math.min(_rowsArg, _array[0].length);
            const _nbColumns = Math.min(_columnsArg, _array.length);
            return generateMatrix(_nbColumns, _nbRows, (col, row) => _array[col][row]);
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // CHOOSECOLS
    // -----------------------------------------------------------------------------
    const CHOOSECOLS = {
        description: _t("Creates a new array from the selected columns in the existing range."),
        args: [
            arg("array (any, range<any>)", _t("The array that contains the columns to be returned.")),
            arg("col_num (number, range<number>)", _t("The first column index of the columns to be returned.")),
            arg("col_num2 (number, range<number>, repeating)", _t("The columns indexes of the columns to be returned.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (array, ...columns) {
            const _array = toMatrix(array);
            const _columns = flattenRowFirst(columns, (item) => toInteger(item?.value, this.locale));
            assert(() => _columns.every((col) => col > 0 && col <= _array.length), _t("The columns arguments must be between 1 and %s (got %s).", _array.length.toString(), (_columns.find((col) => col <= 0 || col > _array.length) || 0).toString()));
            const result = Array(_columns.length);
            for (let col = 0; col < _columns.length; col++) {
                const colIndex = _columns[col] - 1; // -1 because columns arguments are 1-indexed
                result[col] = _array[colIndex];
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CHOOSEROWS
    // -----------------------------------------------------------------------------
    const CHOOSEROWS = {
        description: _t("Creates a new array from the selected rows in the existing range."),
        args: [
            arg("array (any, range<any>)", _t("The array that contains the rows to be returned.")),
            arg("row_num (number, range<number>)", _t("The first row index of the rows to be returned.")),
            arg("row_num2 (number, range<number>, repeating)", _t("The rows indexes of the rows to be returned.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (array, ...rows) {
            const _array = toMatrix(array);
            const _rows = flattenRowFirst(rows, (item) => toInteger(item?.value, this.locale));
            const _nbColumns = _array.length;
            assert(() => _rows.every((row) => row > 0 && row <= _array[0].length), _t("The rows arguments must be between 1 and %s (got %s).", _array[0].length.toString(), (_rows.find((row) => row <= 0 || row > _array[0].length) || 0).toString()));
            return generateMatrix(_nbColumns, _rows.length, (col, row) => _array[col][_rows[row] - 1]); // -1 because rows arguments are 1-indexed
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // EXPAND
    // -----------------------------------------------------------------------------
    const EXPAND = {
        description: _t("Expands or pads an array to specified row and column dimensions."),
        args: [
            arg("array (any, range<any>)", _t("The array to expand.")),
            arg("rows (number)", _t("The number of rows in the expanded array. If missing, rows will not be expanded.")),
            arg("columns (number, optional)", _t("The number of columns in the expanded array. If missing, columns will not be expanded.")),
            arg("pad_with (any, default=0)", _t("The value with which to pad.")), // @compatibility: on Excel, pad with #N/A
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (arg, rows, columns, padWith = { value: 0 } // TODO : Replace with #N/A errors once it's supported
        ) {
            const _array = toMatrix(arg);
            const _nbRows = toInteger(rows?.value, this.locale);
            const _nbColumns = columns !== undefined ? toInteger(columns.value, this.local) : _array.length;
            assert(() => _nbRows >= _array[0].length, _t("The rows arguments (%s) must be greater or equal than the number of rows of the array.", _nbRows.toString()));
            assert(() => _nbColumns >= _array.length, _t("The columns arguments (%s) must be greater or equal than the number of columns of the array.", _nbColumns.toString()));
            return generateMatrix(_nbColumns, _nbRows, (col, row) => col >= _array.length || row >= _array[col].length ? padWith : _array[col][row]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FLATTEN
    // -----------------------------------------------------------------------------
    const FLATTEN = {
        description: _t("Flattens all the values from one or more ranges into a single column."),
        args: [
            arg("range (any, range<any>)", _t("The first range to flatten.")),
            arg("range2 (any, range<any>, repeating)", _t("Additional ranges to flatten.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (...ranges) {
            return [flattenRowFirst(ranges, (val) => (val === undefined ? { value: "" } : val))];
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // FREQUENCY
    // -----------------------------------------------------------------------------
    const FREQUENCY = {
        description: _t("Calculates the frequency distribution of a range."),
        args: [
            arg("data (range<number>)", _t("The array of ranges containing the values to be counted.")),
            arg("classes (number, range<number>)", _t("The range containing the set of classes.")),
        ],
        returns: ["RANGE<NUMBER>"],
        compute: function (data, classes) {
            const _data = flattenRowFirst([data], (val) => val).filter((val) => typeof val === "number");
            const _classes = flattenRowFirst([classes], (val) => val).filter((val) => typeof val === "number");
            /**
             * Returns the frequency distribution of the data in the classes, ie. the number of elements in the range
             * between each classes.
             *
             * For example:
             * - data = [1, 3, 2, 5, 4]
             * - classes = [3, 5, 1]
             *
             * The result will be:
             * - 2 ==> number of elements 1 > el >= 3
             * - 2 ==> number of elements 3 > el >= 5
             * - 1 ==> number of elements <= 1
             * - 0 ==> number of elements > 5
             *
             * @compatibility: GSheet sort the input classes. We do the implemntation of Excel, where we kee the classes unsorted.
             */
            const sortedClasses = _classes
                .map((value, index) => ({ initialIndex: index, value, count: 0 }))
                .sort((a, b) => a.value - b.value);
            sortedClasses.push({ initialIndex: sortedClasses.length, value: Infinity, count: 0 });
            const sortedData = _data.sort((a, b) => a - b);
            let index = 0;
            for (const val of sortedData) {
                while (val > sortedClasses[index].value && index < sortedClasses.length - 1) {
                    index++;
                }
                sortedClasses[index].count++;
            }
            const result = sortedClasses
                .sort((a, b) => a.initialIndex - b.initialIndex)
                .map((val) => val.count);
            return [result];
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // HSTACK
    // -----------------------------------------------------------------------------
    const HSTACK = {
        description: _t("Appends ranges horizontally and in sequence to return a larger array."),
        args: [
            arg("range1 (any, range<any>)", _t("The first range to be appended.")),
            arg("range2 (any, range<any>, repeating)", _t("Additional ranges to add to range1.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (...ranges) {
            const nbRows = Math.max(...ranges.map((r) => r?.[0]?.length ?? 0));
            const result = [];
            for (const range of ranges) {
                const _range = toMatrix(range);
                for (let col = 0; col < _range.length; col++) {
                    //TODO: fill with #N/A for unavailable values instead of zeroes
                    const array = Array(nbRows).fill({ value: null });
                    for (let row = 0; row < _range[col].length; row++) {
                        array[row] = _range[col][row];
                    }
                    result.push(array);
                }
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MDETERM
    // -----------------------------------------------------------------------------
    const MDETERM = {
        description: _t("Returns the matrix determinant of a square matrix."),
        args: [
            arg("square_matrix (number, range<number>)", _t("An range with an equal number of rows and columns representing a matrix whose determinant will be calculated.")),
        ],
        returns: ["NUMBER"],
        compute: function (matrix) {
            const _matrix = toMatrix(matrix);
            assertSquareMatrix(_t("The argument square_matrix must have the same number of columns and rows."), _matrix);
            if (!isNumberMatrix(_matrix)) {
                throw new Error(_t("The argument square_matrix must be a matrix of numbers."));
            }
            const { determinant } = invertMatrix(_matrix);
            return determinant;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MINVERSE
    // -----------------------------------------------------------------------------
    const MINVERSE = {
        description: _t("Returns the multiplicative inverse of a square matrix."),
        args: [
            arg("square_matrix (number, range<number>)", _t("An range with an equal number of rows and columns representing a matrix whose multiplicative inverse will be calculated.")),
        ],
        returns: ["RANGE<NUMBER>"],
        compute: function (matrix) {
            const _matrix = toMatrix(matrix);
            assertSquareMatrix(_t("The argument square_matrix must have the same number of columns and rows."), _matrix);
            if (!isNumberMatrix(_matrix)) {
                throw new Error(_t("The argument square_matrix must be a matrix of numbers."));
            }
            const { inverted } = invertMatrix(_matrix);
            if (!inverted) {
                throw new Error(_t("The matrix is not invertible."));
            }
            return inverted;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MMULT
    // -----------------------------------------------------------------------------
    const MMULT = {
        description: _t("Calculates the matrix product of two matrices."),
        args: [
            arg("matrix1 (number, range<number>)", _t("The first matrix in the matrix multiplication operation.")),
            arg("matrix2 (number, range<number>)", _t("The second matrix in the matrix multiplication operation.")),
        ],
        returns: ["RANGE<NUMBER>"],
        compute: function (matrix1, matrix2) {
            const _matrix1 = toMatrix(matrix1);
            const _matrix2 = toMatrix(matrix2);
            assert(() => _matrix1.length > 0 && _matrix2.length > 0, _t("The first and second arguments of [[FUNCTION_NAME]] must be non-empty matrices."));
            assert(() => _matrix1.length === _matrix2[0].length, _t("In [[FUNCTION_NAME]], the number of columns of the first matrix (%s) must be equal to the \
        number of rows of the second matrix (%s).", _matrix1.length.toString(), _matrix2[0].length.toString()));
            if (!isNumberMatrix(_matrix1) || !isNumberMatrix(_matrix2)) {
                throw new Error(_t("The arguments matrix1 and matrix2 must be matrices of numbers."));
            }
            return multiplyMatrices(_matrix1, _matrix2);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SUMPRODUCT
    // -----------------------------------------------------------------------------
    const SUMPRODUCT = {
        description: _t("Calculates the sum of the products of corresponding entries in equal-sized ranges."),
        args: [
            arg("range1 (number, range<number>)", _t("The first range whose entries will be multiplied with corresponding entries in the other ranges.")),
            arg("range2 (number, range<number>, repeating)", _t("The other range whose entries will be multiplied with corresponding entries in the other ranges.")),
        ],
        returns: ["NUMBER"],
        compute: function (...args) {
            assertSameDimensions(_t("All the ranges must have the same dimensions."), ...args);
            const _args = args.map(toMatrix);
            let result = 0;
            for (let col = 0; col < _args[0].length; col++) {
                for (let row = 0; row < _args[0][col].length; row++) {
                    if (!_args.every((range) => typeof range[col][row] === "number")) {
                        continue;
                    }
                    let product = 1;
                    for (const range of _args) {
                        product *= toNumber(range[col][row], this.locale);
                    }
                    result += product;
                }
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SUMX2MY2
    // -----------------------------------------------------------------------------
    /**
     * Return the sum of the callback applied to each pair of values in the two arrays.
     *
     * Ignore the pairs X,Y where one of the value isn't a number. Throw an error if no pair of numbers is found.
     */
    function getSumXAndY(arrayX, arrayY, cb) {
        assertSameDimensions("The arguments array_x and array_y must have the same dimensions.", arrayX, arrayY);
        const _arrayX = toMatrix(arrayX);
        const _arrayY = toMatrix(arrayY);
        let validPairFound = false;
        let result = 0;
        for (const col in _arrayX) {
            for (const row in _arrayX[col]) {
                const arrayXValue = _arrayX[col][row];
                const arrayYValue = _arrayY[col][row];
                if (typeof arrayXValue !== "number" || typeof arrayYValue !== "number") {
                    continue;
                }
                validPairFound = true;
                result += cb(arrayXValue, arrayYValue);
            }
        }
        if (!validPairFound) {
            throw new Error("The arguments array_x and array_y must contain at least one pair of numbers.");
        }
        return result;
    }
    const SUMX2MY2 = {
        description: _t("Calculates the sum of the difference of the squares of the values in two array."),
        args: [
            arg("array_x (number, range<number>)", _t("The array or range of values whose squares will be reduced by the squares of corresponding entries in array_y and added together.")),
            arg("array_y (number, range<number>)", _t("The array or range of values whose squares will be subtracted from the squares of corresponding entries in array_x and added together.")),
        ],
        returns: ["NUMBER"],
        compute: function (arrayX, arrayY) {
            return getSumXAndY(arrayX, arrayY, (x, y) => x ** 2 - y ** 2);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SUMX2PY2
    // -----------------------------------------------------------------------------
    const SUMX2PY2 = {
        description: _t("Calculates the sum of the sum of the squares of the values in two array."),
        args: [
            arg("array_x (number, range<number>)", _t("The array or range of values whose squares will be added to the squares of corresponding entries in array_y and added together.")),
            arg("array_y (number, range<number>)", _t("The array or range of values whose squares will be added to the squares of corresponding entries in array_x and added together.")),
        ],
        returns: ["NUMBER"],
        compute: function (arrayX, arrayY) {
            return getSumXAndY(arrayX, arrayY, (x, y) => x ** 2 + y ** 2);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SUMXMY2
    // -----------------------------------------------------------------------------
    const SUMXMY2 = {
        description: _t("Calculates the sum of squares of the differences of values in two array."),
        args: [
            arg("array_x (number, range<number>)", _t("The array or range of values that will be reduced by corresponding entries in array_y, squared, and added together.")),
            arg("array_y (number, range<number>)", _t("The array or range of values that will be subtracted from corresponding entries in array_x, the result squared, and all such results added together.")),
        ],
        returns: ["NUMBER"],
        compute: function (arrayX, arrayY) {
            return getSumXAndY(arrayX, arrayY, (x, y) => (x - y) ** 2);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TOCOL
    // -----------------------------------------------------------------------------
    const TO_COL_ROW_DEFAULT_IGNORE = 0;
    const TO_COL_ROW_DEFAULT_SCAN = false;
    const TO_COL_ROW_ARGS = [
        arg("array (any, range<any>)", _t("The array which will be transformed.")),
        arg(`ignore (number, default=${TO_COL_ROW_DEFAULT_IGNORE})`, _t("The control to ignore blanks and errors. 0 (default) is to keep all values, 1 is to ignore blanks, 2 is to ignore errors, and 3 is to ignore blanks and errors.")),
        arg(`scan_by_column (number, default=${TO_COL_ROW_DEFAULT_SCAN})`, _t("Whether the array should be scanned by column. True scans the array by column and false (default) \
      scans the array by row.")),
    ];
    const TOCOL = {
        description: _t("Transforms a range of cells into a single column."),
        args: TO_COL_ROW_ARGS,
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (array, ignore = { value: TO_COL_ROW_DEFAULT_IGNORE }, scanByColumn = { value: TO_COL_ROW_DEFAULT_SCAN }) {
            const _array = toMatrix(array);
            const _ignore = toInteger(ignore.value, this.locale);
            const _scanByColumn = toBoolean(scanByColumn.value);
            assert(() => _ignore >= 0 && _ignore <= 3, _t("Argument ignore must be between 0 and 3"));
            // TODO : implement ignore value 2 (ignore error) & 3 (ignore blanks and errors) once we can have errors in
            // the array w/o crashing
            const result = (_scanByColumn ? _array : transposeMatrix(_array))
                .flat()
                .filter((item) => (_ignore !== 1 && _ignore !== 3) || (item.value !== undefined && item.value !== null));
            if (result.length === 0) {
                throw new NotAvailableError(_t("No results for the given arguments of TOCOL."));
            }
            return [result];
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TOROW
    // -----------------------------------------------------------------------------
    const TOROW = {
        description: _t("Transforms a range of cells into a single row."),
        args: TO_COL_ROW_ARGS,
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (array, ignore = { value: TO_COL_ROW_DEFAULT_IGNORE }, scanByColumn = { value: TO_COL_ROW_DEFAULT_SCAN }) {
            const _array = toMatrix(array);
            const _ignore = toInteger(ignore.value, this.locale);
            const _scanByColumn = toBoolean(scanByColumn.value);
            assert(() => _ignore >= 0 && _ignore <= 3, _t("Argument ignore must be between 0 and 3"));
            // TODO : implement ignore value 2 (ignore error) & 3 (ignore blanks and errors) once we can have errors in
            // the array w/o crashing
            const result = (_scanByColumn ? _array : transposeMatrix(_array))
                .flat()
                .filter((item) => (_ignore !== 1 && _ignore !== 3) || (item.value !== undefined && item.value !== null))
                .map((item) => [item]);
            if (result.length === 0 || result[0].length === 0) {
                throw new NotAvailableError(_t("No results for the given arguments of TOROW."));
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TRANSPOSE
    // -----------------------------------------------------------------------------
    const TRANSPOSE = {
        description: _t("Transposes the rows and columns of a range."),
        args: [arg("range (any, range<any>)", _t("The range to be transposed."))],
        returns: ["RANGE"],
        computeValueAndFormat: function (arg) {
            const _array = toMatrix(arg);
            const nbColumns = _array[0].length;
            const nbRows = _array.length;
            return generateMatrix(nbColumns, nbRows, (col, row) => _array[row][col]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VSTACK
    // -----------------------------------------------------------------------------
    const VSTACK = {
        description: _t("Appends ranges vertically and in sequence to return a larger array."),
        args: [
            arg("range1 (any, range<any>)", _t("The first range to be appended.")),
            arg("range2 (any, range<any>, repeating)", _t("Additional ranges to add to range1.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (...ranges) {
            const nbColumns = Math.max(...ranges.map((range) => toMatrix(range).length));
            const nbRows = ranges.reduce((acc, range) => acc + toMatrix(range)[0].length, 0);
            const result = Array(nbColumns)
                .fill([])
                .map(() => Array(nbRows).fill({ value: 0 })); // TODO fill with #N/A
            let currentRow = 0;
            for (const range of ranges) {
                const _array = toMatrix(range);
                for (let col = 0; col < _array.length; col++) {
                    for (let row = 0; row < _array[col].length; row++) {
                        result[col][currentRow + row] = _array[col][row];
                    }
                }
                currentRow += _array[0].length;
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // WRAPCOLS
    // -----------------------------------------------------------------------------
    const WRAPCOLS = {
        description: _t("Wraps the provided row or column of cells by columns after a specified number of elements to form a new array."),
        args: [
            arg("range (any, range<any>)", _t("The range to wrap.")),
            arg("wrap_count (number)", _t("The maximum number of cells for each column, rounded down to the nearest whole number.")),
            arg("pad_with  (any, default=0)", // TODO : replace with #N/A
            _t("The value with which to fill the extra cells in the range.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (range, wrapCount, padWith = { value: 0 }) {
            const _array = toMatrix(range);
            const nbRows = toInteger(wrapCount?.value, this.locale);
            assertSingleColOrRow(_t("Argument range must be a single row or column."), _array);
            const array = _array.flat();
            const nbColumns = Math.ceil(array.length / nbRows);
            return generateMatrix(nbColumns, nbRows, (col, row) => {
                const index = col * nbRows + row;
                return index < array.length ? array[index] : padWith;
            });
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // WRAPROWS
    // -----------------------------------------------------------------------------
    const WRAPROWS = {
        description: _t("Wraps the provided row or column of cells by rows after a specified number of elements to form a new array."),
        args: [
            arg("range (any, range<any>)", _t("The range to wrap.")),
            arg("wrap_count (number)", _t("The maximum number of cells for each row, rounded down to the nearest whole number.")),
            arg("pad_with  (any, default=0)", // TODO : replace with #N/A
            _t("The value with which to fill the extra cells in the range.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (range, wrapCount, padWith = { value: 0 }) {
            const _array = toMatrix(range);
            const nbColumns = toInteger(wrapCount?.value, this.locale);
            assertSingleColOrRow(_t("Argument range must be a single row or column."), _array);
            const array = _array.flat();
            const nbRows = Math.ceil(array.length / nbColumns);
            return generateMatrix(nbColumns, nbRows, (col, row) => {
                const index = row * nbColumns + col;
                return index < array.length ? array[index] : padWith;
            });
        },
        isExported: true,
    };

    var array = /*#__PURE__*/Object.freeze({
        __proto__: null,
        ARRAY_CONSTRAIN: ARRAY_CONSTRAIN,
        CHOOSECOLS: CHOOSECOLS,
        CHOOSEROWS: CHOOSEROWS,
        EXPAND: EXPAND,
        FLATTEN: FLATTEN,
        FREQUENCY: FREQUENCY,
        HSTACK: HSTACK,
        MDETERM: MDETERM,
        MINVERSE: MINVERSE,
        MMULT: MMULT,
        SUMPRODUCT: SUMPRODUCT,
        SUMX2MY2: SUMX2MY2,
        SUMX2PY2: SUMX2PY2,
        SUMXMY2: SUMXMY2,
        TOCOL: TOCOL,
        TOROW: TOROW,
        TRANSPOSE: TRANSPOSE,
        VSTACK: VSTACK,
        WRAPCOLS: WRAPCOLS,
        WRAPROWS: WRAPROWS
    });

    // -----------------------------------------------------------------------------
    // FORMAT.LARGE.NUMBER
    // -----------------------------------------------------------------------------
    const FORMAT_LARGE_NUMBER = {
        description: _t("Apply a large number format"),
        args: [
            arg("value (number)", _t("The number.")),
            arg("unit (string, optional)", _t("The formatting unit. Use 'k', 'm', or 'b' to force the unit")),
        ],
        returns: ["NUMBER"],
        computeFormat: function (arg, unit) {
            const value = Math.abs(toNumber(arg?.value, this.locale));
            const format = arg?.format;
            if (unit !== undefined) {
                const postFix = unit?.value;
                switch (postFix) {
                    case "k":
                        return createLargeNumberFormat(format, 1e3, "k", this.locale);
                    case "m":
                        return createLargeNumberFormat(format, 1e6, "m", this.locale);
                    case "b":
                        return createLargeNumberFormat(format, 1e9, "b", this.locale);
                    default:
                        throw new Error(_t("The formatting unit should be 'k', 'm' or 'b'."));
                }
            }
            if (value < 1e5) {
                return createLargeNumberFormat(format, 0, "", this.locale);
            }
            else if (value < 1e8) {
                return createLargeNumberFormat(format, 1e3, "k", this.locale);
            }
            else if (value < 1e11) {
                return createLargeNumberFormat(format, 1e6, "m", this.locale);
            }
            return createLargeNumberFormat(format, 1e9, "b", this.locale);
        },
        compute: function (value) {
            return toNumber(value, this.locale);
        },
    };

    var misc = /*#__PURE__*/Object.freeze({
        __proto__: null,
        FORMAT_LARGE_NUMBER: FORMAT_LARGE_NUMBER
    });

    const DEFAULT_FACTOR = 1;
    const DEFAULT_MODE = 0;
    const DEFAULT_PLACES = 0;
    const DEFAULT_SIGNIFICANCE = 1;
    const DECIMAL_REPRESENTATION = /^-?[a-z0-9]+$/i;
    // -----------------------------------------------------------------------------
    // ABS
    // -----------------------------------------------------------------------------
    const ABS = {
        description: _t("Absolute value of a number."),
        args: [arg("value (number)", _t("The number of which to return the absolute value."))],
        returns: ["NUMBER"],
        compute: function (value) {
            return Math.abs(toNumber(value, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ACOS
    // -----------------------------------------------------------------------------
    const ACOS = {
        description: _t("Inverse cosine of a value, in radians."),
        args: [
            arg("value (number)", _t("The value for which to calculate the inverse cosine. Must be between -1 and 1, inclusive.")),
        ],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => Math.abs(_value) <= 1, _t("The value (%s) must be between -1 and 1 inclusive.", _value.toString()));
            return Math.acos(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ACOSH
    // -----------------------------------------------------------------------------
    const ACOSH = {
        description: _t("Inverse hyperbolic cosine of a number."),
        args: [
            arg("value (number)", _t("The value for which to calculate the inverse hyperbolic cosine. Must be greater than or equal to 1.")),
        ],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => _value >= 1, _t("The value (%s) must be greater than or equal to 1.", _value.toString()));
            return Math.acosh(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ACOT
    // -----------------------------------------------------------------------------
    const ACOT = {
        description: _t("Inverse cotangent of a value."),
        args: [arg("value (number)", _t("The value for which to calculate the inverse cotangent."))],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            const sign = Math.sign(_value) || 1;
            // ACOT has two possible configurations:
            // @compatibility Excel: return Math.PI / 2 - Math.atan(toNumber(_value, this.locale));
            // @compatibility Google: return sign * Math.PI / 2 - Math.atan(toNumber(_value, this.locale));
            return (sign * Math.PI) / 2 - Math.atan(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ACOTH
    // -----------------------------------------------------------------------------
    const ACOTH = {
        description: _t("Inverse hyperbolic cotangent of a value."),
        args: [
            arg("value (number)", _t("The value for which to calculate the inverse hyperbolic cotangent. Must not be between -1 and 1, inclusive.")),
        ],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => Math.abs(_value) > 1, _t("The value (%s) cannot be between -1 and 1 inclusive.", _value.toString()));
            return Math.log((_value + 1) / (_value - 1)) / 2;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ASIN
    // -----------------------------------------------------------------------------
    const ASIN = {
        description: _t("Inverse sine of a value, in radians."),
        args: [
            arg("value (number)", _t("The value for which to calculate the inverse sine. Must be between -1 and 1, inclusive.")),
        ],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => Math.abs(_value) <= 1, _t("The value (%s) must be between -1 and 1 inclusive.", _value.toString()));
            return Math.asin(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ASINH
    // -----------------------------------------------------------------------------
    const ASINH = {
        description: _t("Inverse hyperbolic sine of a number."),
        args: [
            arg("value (number)", _t("The value for which to calculate the inverse hyperbolic sine.")),
        ],
        returns: ["NUMBER"],
        compute: function (value) {
            return Math.asinh(toNumber(value, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ATAN
    // -----------------------------------------------------------------------------
    const ATAN = {
        description: _t("Inverse tangent of a value, in radians."),
        args: [arg("value (number)", _t("The value for which to calculate the inverse tangent."))],
        returns: ["NUMBER"],
        compute: function (value) {
            return Math.atan(toNumber(value, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ATAN2
    // -----------------------------------------------------------------------------
    const ATAN2 = {
        description: _t("Angle from the X axis to a point (x,y), in radians."),
        args: [
            arg("x (number)", _t("The x coordinate of the endpoint of the line segment for which to calculate the angle from the x-axis.")),
            arg("y (number)", _t("The y coordinate of the endpoint of the line segment for which to calculate the angle from the x-axis.")),
        ],
        returns: ["NUMBER"],
        compute: function (x, y) {
            const _x = toNumber(x, this.locale);
            const _y = toNumber(y, this.locale);
            assert(() => _x !== 0 || _y !== 0, _t("Function [[FUNCTION_NAME]] caused a divide by zero error."));
            return Math.atan2(_y, _x);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ATANH
    // -----------------------------------------------------------------------------
    const ATANH = {
        description: _t("Inverse hyperbolic tangent of a number."),
        args: [
            arg("value (number)", _t("The value for which to calculate the inverse hyperbolic tangent. Must be between -1 and 1, exclusive.")),
        ],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => Math.abs(_value) < 1, _t("The value (%s) must be between -1 and 1 exclusive.", _value.toString()));
            return Math.atanh(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CEILING
    // -----------------------------------------------------------------------------
    const CEILING = {
        description: _t("Rounds number up to nearest multiple of factor."),
        args: [
            arg("value (number)", _t("The value to round up to the nearest integer multiple of factor.")),
            arg(`factor (number, default=${DEFAULT_FACTOR})`, _t("The number to whose multiples value will be rounded.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value) => value?.format,
        compute: function (value, factor = DEFAULT_FACTOR) {
            const _value = toNumber(value, this.locale);
            const _factor = toNumber(factor, this.locale);
            assert(() => _factor >= 0 || _value <= 0, _t("The factor (%s) must be positive when the value (%s) is positive.", _factor.toString(), _value.toString()));
            return _factor ? Math.ceil(_value / _factor) * _factor : 0;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CEILING.MATH
    // -----------------------------------------------------------------------------
    const CEILING_MATH = {
        description: _t("Rounds number up to nearest multiple of factor."),
        args: [
            arg("number (number)", _t("The value to round up to the nearest integer multiple of significance.")),
            arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded. The sign of significance will be ignored.")),
            arg(`mode (number, default=${DEFAULT_MODE})`, _t("If number is negative, specifies the rounding direction. If 0 or blank, it is rounded towards zero. Otherwise, it is rounded away from zero.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (number) => number?.format,
        compute: function (number, significance = DEFAULT_SIGNIFICANCE, mode = DEFAULT_MODE) {
            let _significance = toNumber(significance, this.locale);
            if (_significance === 0) {
                return 0;
            }
            const _number = toNumber(number, this.locale);
            _significance = Math.abs(_significance);
            if (_number >= 0) {
                return Math.ceil(_number / _significance) * _significance;
            }
            const _mode = toNumber(mode, this.locale);
            if (_mode === 0) {
                return -Math.floor(Math.abs(_number) / _significance) * _significance;
            }
            return -Math.ceil(Math.abs(_number) / _significance) * _significance;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CEILING.PRECISE
    // -----------------------------------------------------------------------------
    const CEILING_PRECISE = {
        description: _t("Rounds number up to nearest multiple of factor."),
        args: [
            arg("number (number)", _t("The value to round up to the nearest integer multiple of significance.")),
            arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (number) => number?.format,
        compute: function (number, significance) {
            return CEILING_MATH.compute.bind(this)(number, significance, 0);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COS
    // -----------------------------------------------------------------------------
    const COS = {
        description: _t("Cosine of an angle provided in radians."),
        args: [arg("angle (number)", _t("The angle to find the cosine of, in radians."))],
        returns: ["NUMBER"],
        compute: function (angle) {
            return Math.cos(toNumber(angle, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COSH
    // -----------------------------------------------------------------------------
    const COSH = {
        description: _t("Hyperbolic cosine of any real number."),
        args: [arg("value (number)", _t("Any real value to calculate the hyperbolic cosine of."))],
        returns: ["NUMBER"],
        compute: function (value) {
            return Math.cosh(toNumber(value, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COT
    // -----------------------------------------------------------------------------
    const COT = {
        description: _t("Cotangent of an angle provided in radians."),
        args: [arg("angle (number)", _t("The angle to find the cotangent of, in radians."))],
        returns: ["NUMBER"],
        compute: function (angle) {
            const _angle = toNumber(angle, this.locale);
            assert(() => _angle !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return 1 / Math.tan(_angle);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COTH
    // -----------------------------------------------------------------------------
    const COTH = {
        description: _t("Hyperbolic cotangent of any real number."),
        args: [arg("value (number)", _t("Any real value to calculate the hyperbolic cotangent of."))],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => _value !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return 1 / Math.tanh(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUNTBLANK
    // -----------------------------------------------------------------------------
    const COUNTBLANK = {
        description: _t("Number of empty values."),
        args: [
            arg("value1 (any, range)", _t("The first value or range in which to count the number of blanks.")),
            arg("value2 (any, range, repeating)", _t("Additional values or ranges in which to count the number of blanks.")),
        ],
        returns: ["NUMBER"],
        compute: function (...argsValues) {
            return reduceAny(argsValues, (acc, a) => (a === null || a === undefined || a === "" ? acc + 1 : acc), 0);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUNTIF
    // -----------------------------------------------------------------------------
    const COUNTIF = {
        description: _t("A conditional count across a range."),
        args: [
            arg("range (range)", _t("The range that is tested against criterion.")),
            arg("criterion (string)", _t("The pattern or test to apply to range.")),
        ],
        returns: ["NUMBER"],
        compute: function (...argsValues) {
            let count = 0;
            visitMatchingRanges(argsValues, (i, j) => {
                count += 1;
            }, this.locale);
            return count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUNTIFS
    // -----------------------------------------------------------------------------
    const COUNTIFS = {
        description: _t("Count values depending on multiple criteria."),
        args: [
            arg("criteria_range1 (range)", _t("The range to check against criterion1.")),
            arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1.")),
            arg("criteria_range2 (any, range, repeating)", _t("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
            arg("criterion2 (string, repeating)", _t("Additional criteria to check.")),
        ],
        returns: ["NUMBER"],
        compute: function (...argsValues) {
            let count = 0;
            visitMatchingRanges(argsValues, (i, j) => {
                count += 1;
            }, this.locale);
            return count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUNTUNIQUE
    // -----------------------------------------------------------------------------
    function isDefined(value) {
        switch (value) {
            case undefined:
                return false;
            case "":
                return false;
            case null:
                return false;
            default:
                return true;
        }
    }
    const COUNTUNIQUE = {
        description: _t("Counts number of unique values in a range."),
        args: [
            arg("value1 (any, range)", _t("The first value or range to consider for uniqueness.")),
            arg("value2 (any, range, repeating)", _t("Additional values or ranges to consider for uniqueness.")),
        ],
        returns: ["NUMBER"],
        compute: function (...argsValues) {
            return reduceAny(argsValues, (acc, a) => (isDefined(a) ? acc.add(a) : acc), new Set()).size;
        },
    };
    // -----------------------------------------------------------------------------
    // COUNTUNIQUEIFS
    // -----------------------------------------------------------------------------
    const COUNTUNIQUEIFS = {
        description: _t("Counts number of unique values in a range, filtered by a set of criteria."),
        args: [
            arg("range (range)", _t("The range of cells from which the number of unique values will be counted.")),
            arg("criteria_range1 (range)", _t("The range of cells over which to evaluate criterion1.")),
            arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
            arg("criteria_range2 (any, range, repeating)", _t("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
            arg("criterion2 (string, repeating)", _t("The pattern or test to apply to criteria_range2.")),
        ],
        returns: ["NUMBER"],
        compute: function (range, ...argsValues) {
            let uniqueValues = new Set();
            visitMatchingRanges(argsValues, (i, j) => {
                const value = range[i][j];
                if (isDefined(value)) {
                    uniqueValues.add(value);
                }
            }, this.locale);
            return uniqueValues.size;
        },
    };
    // -----------------------------------------------------------------------------
    // CSC
    // -----------------------------------------------------------------------------
    const CSC = {
        description: _t("Cosecant of an angle provided in radians."),
        args: [arg("angle (number)", _t("The angle to find the cosecant of, in radians."))],
        returns: ["NUMBER"],
        compute: function (angle) {
            const _angle = toNumber(angle, this.locale);
            assert(() => _angle !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return 1 / Math.sin(_angle);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CSCH
    // -----------------------------------------------------------------------------
    const CSCH = {
        description: _t("Hyperbolic cosecant of any real number."),
        args: [arg("value (number)", _t("Any real value to calculate the hyperbolic cosecant of."))],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => _value !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return 1 / Math.sinh(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DECIMAL
    // -----------------------------------------------------------------------------
    const DECIMAL = {
        description: _t("Converts from another base to decimal."),
        args: [
            arg("value (string)", _t("The number to convert.")),
            arg(",base (number)", _t("The base to convert the value from.")),
        ],
        returns: ["NUMBER"],
        compute: function (value, base) {
            let _base = toNumber(base, this.locale);
            _base = Math.floor(_base);
            assert(() => 2 <= _base && _base <= 36, _t("The base (%s) must be between 2 and 36 inclusive.", _base.toString()));
            const _value = toString(value);
            if (_value === "") {
                return 0;
            }
            /**
             * @compatibility: on Google sheets, expects the parameter 'value' to be positive.
             * Return error if 'value' is positive.
             * Remove '-?' in the next regex to catch this error.
             */
            assert(() => !!DECIMAL_REPRESENTATION.test(_value), _t("The value (%s) must be a valid base %s representation.", _value, _base.toString()));
            const deci = parseInt(_value, _base);
            assert(() => !isNaN(deci), _t("The value (%s) must be a valid base %s representation.", _value, _base.toString()));
            return deci;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DEGREES
    // -----------------------------------------------------------------------------
    const DEGREES = {
        description: _t("Converts an angle value in radians to degrees."),
        args: [arg("angle (number)", _t("The angle to convert from radians to degrees."))],
        returns: ["NUMBER"],
        compute: function (angle) {
            return (toNumber(angle, this.locale) * 180) / Math.PI;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // EXP
    // -----------------------------------------------------------------------------
    const EXP = {
        description: _t("Euler's number, e (~2.718) raised to a power."),
        args: [arg("value (number)", _t("The exponent to raise e."))],
        returns: ["NUMBER"],
        compute: function (value) {
            return Math.exp(toNumber(value, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FLOOR
    // -----------------------------------------------------------------------------
    const FLOOR = {
        description: _t("Rounds number down to nearest multiple of factor."),
        args: [
            arg("value (number)", _t("The value to round down to the nearest integer multiple of factor.")),
            arg(`factor (number, default=${DEFAULT_FACTOR})`, _t("The number to whose multiples value will be rounded.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value) => value?.format,
        compute: function (value, factor = DEFAULT_FACTOR) {
            const _value = toNumber(value, this.locale);
            const _factor = toNumber(factor, this.locale);
            assert(() => _factor >= 0 || _value <= 0, _t("The factor (%s) must be positive when the value (%s) is positive.", _factor.toString(), _value.toString()));
            return _factor ? Math.floor(_value / _factor) * _factor : 0;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FLOOR.MATH
    // -----------------------------------------------------------------------------
    const FLOOR_MATH = {
        description: _t("Rounds number down to nearest multiple of factor."),
        args: [
            arg("number (number)", _t("The value to round down to the nearest integer multiple of significance.")),
            arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded. The sign of significance will be ignored.")),
            arg(`mode (number, default=${DEFAULT_MODE})`, _t("If number is negative, specifies the rounding direction. If 0 or blank, it is rounded away from zero. Otherwise, it is rounded towards zero.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (number) => number?.format,
        compute: function (number, significance = DEFAULT_SIGNIFICANCE, mode = DEFAULT_MODE) {
            let _significance = toNumber(significance, this.locale);
            if (_significance === 0) {
                return 0;
            }
            const _number = toNumber(number, this.locale);
            _significance = Math.abs(_significance);
            if (_number >= 0) {
                return Math.floor(_number / _significance) * _significance;
            }
            const _mode = toNumber(mode, this.locale);
            if (_mode === 0) {
                return -Math.ceil(Math.abs(_number) / _significance) * _significance;
            }
            return -Math.floor(Math.abs(_number) / _significance) * _significance;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FLOOR.PRECISE
    // -----------------------------------------------------------------------------
    const FLOOR_PRECISE = {
        description: _t("Rounds number down to nearest multiple of factor."),
        args: [
            arg("number (number)", _t("The value to round down to the nearest integer multiple of significance.")),
            arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (number) => number?.format,
        compute: function (number, significance = DEFAULT_SIGNIFICANCE) {
            return FLOOR_MATH.compute.bind(this)(number, significance, 0);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISEVEN
    // -----------------------------------------------------------------------------
    const ISEVEN = {
        description: _t("Whether the provided value is even."),
        args: [arg("value (number)", _t("The value to be verified as even."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            const _value = strictToNumber(value, this.locale);
            return Math.floor(Math.abs(_value)) & 1 ? false : true;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISO.CEILING
    // -----------------------------------------------------------------------------
    const ISO_CEILING = {
        description: _t("Rounds number up to nearest multiple of factor."),
        args: [
            arg("number (number)", _t("The value to round up to the nearest integer multiple of significance.")),
            arg(`significance (number, default=${DEFAULT_SIGNIFICANCE})`, _t("The number to whose multiples number will be rounded.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (number) => number?.format,
        compute: function (number, significance = DEFAULT_SIGNIFICANCE) {
            return CEILING_MATH.compute.bind(this)(number, significance, 0);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISODD
    // -----------------------------------------------------------------------------
    const ISODD = {
        description: _t("Whether the provided value is even."),
        args: [arg("value (number)", _t("The value to be verified as even."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            const _value = strictToNumber(value, this.locale);
            return Math.floor(Math.abs(_value)) & 1 ? true : false;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // LN
    // -----------------------------------------------------------------------------
    const LN = {
        description: _t("The logarithm of a number, base e (euler's number)."),
        args: [arg("value (number)", _t("The value for which to calculate the logarithm, base e."))],
        returns: ["NUMBER"],
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => _value > 0, _t("The value (%s) must be strictly positive.", _value.toString()));
            return Math.log(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // LOG
    // -----------------------------------------------------------------------------
    const LOG = {
        description: _t("The logarithm of a number, for a given base."),
        args: [
            arg("value (number)", _t("The value for which to calculate the logarithm.")),
            arg("base (number, default=10)", _t("The base of the logarithm.")),
        ],
        returns: ["NUMBER"],
        compute: function (value, base = 10) {
            const _value = toNumber(value, this.locale);
            const _base = toNumber(base, this.locale);
            assert(() => _value > 0, _t("The value (%s) must be strictly positive.", _value.toString()));
            assert(() => _base > 0, _t("The base (%s) must be strictly positive.", _base.toString()));
            assert(() => _base !== 1, _t("The base must be different from 1."));
            return Math.log10(_value) / Math.log10(_base);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MOD
    // -----------------------------------------------------------------------------
    const MOD = {
        description: _t("Modulo (remainder) operator."),
        args: [
            arg("dividend (number)", _t("The number to be divided to find the remainder.")),
            arg("divisor (number)", _t("The number to divide by.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (dividend) => dividend?.format,
        compute: function (dividend, divisor) {
            const _divisor = toNumber(divisor, this.locale);
            assert(() => _divisor !== 0, _t("The divisor must be different from 0."));
            const _dividend = toNumber(dividend, this.locale);
            const modulus = _dividend % _divisor;
            // -42 % 10 = -2 but we want 8, so need the code below
            if ((modulus > 0 && _divisor < 0) || (modulus < 0 && _divisor > 0)) {
                return modulus + _divisor;
            }
            return modulus;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MUNIT
    // -----------------------------------------------------------------------------
    const MUNIT = {
        description: _t("Returns a n x n unit matrix, where n is the input dimension."),
        args: [
            arg("dimension (number)", _t("An integer specifying the dimension size of the unit matrix. It must be positive.")),
        ],
        returns: ["RANGE<NUMBER>"],
        compute: function (n) {
            const _n = toInteger(n, this.locale);
            assertPositive(_t("The argument dimension must be positive"), _n);
            return getUnitMatrix(_n);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ODD
    // -----------------------------------------------------------------------------
    const ODD = {
        description: _t("Rounds a number up to the nearest odd integer."),
        args: [arg("value (number)", _t("The value to round to the next greatest odd number."))],
        returns: ["NUMBER"],
        computeFormat: (number) => number?.format,
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            let temp = Math.ceil(Math.abs(_value));
            temp = temp & 1 ? temp : temp + 1;
            return _value < 0 ? -temp : temp;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PI
    // -----------------------------------------------------------------------------
    const PI = {
        description: _t("The number pi."),
        args: [],
        returns: ["NUMBER"],
        compute: function () {
            return Math.PI;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // POWER
    // -----------------------------------------------------------------------------
    const POWER = {
        description: _t("A number raised to a power."),
        args: [
            arg("base (number)", _t("The number to raise to the exponent power.")),
            arg("exponent (number)", _t("The exponent to raise base to.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (base) => base?.format,
        compute: function (base, exponent) {
            const _base = toNumber(base, this.locale);
            const _exponent = toNumber(exponent, this.locale);
            assert(() => _base >= 0 || Number.isInteger(_exponent), _t("The exponent (%s) must be an integer when the base is negative.", _exponent.toString()));
            return Math.pow(_base, _exponent);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PRODUCT
    // -----------------------------------------------------------------------------
    const PRODUCT = {
        description: _t("Result of multiplying a series of numbers together."),
        args: [
            arg("factor1 (number, range<number>)", _t("The first number or range to calculate for the product.")),
            arg("factor2 (number, range<number>, repeating)", _t("More numbers or ranges to calculate for the product.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (factor1) => {
            return isMatrix(factor1) ? factor1[0][0]?.format : factor1?.format;
        },
        compute: function (...factors) {
            let count = 0;
            let acc = 1;
            for (let n of factors) {
                if (isMatrix(n)) {
                    for (let i of n) {
                        for (let j of i) {
                            if (typeof j === "number") {
                                acc *= j;
                                count += 1;
                            }
                        }
                    }
                }
                else if (n !== null && n !== undefined) {
                    acc *= strictToNumber(n, this.locale);
                    count += 1;
                }
            }
            if (count === 0) {
                return 0;
            }
            return acc;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // RAND
    // -----------------------------------------------------------------------------
    const RAND = {
        description: _t("A random number between 0 inclusive and 1 exclusive."),
        args: [],
        returns: ["NUMBER"],
        compute: function () {
            return Math.random();
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // RANDARRAY
    // -----------------------------------------------------------------------------
    const RANDARRAY = {
        description: _t("Returns a grid of random numbers between 0 inclusive and 1 exclusive."),
        args: [
            arg("rows (number, default=1)", _t("The number of rows to be returned.")),
            arg("columns (number, default=1)", _t("The number of columns to be returned.")),
            arg("min (number, default=0)", _t("The minimum number you would like returned.")),
            arg("max (number, default=1)", _t("The maximum number you would like returned.")),
            arg("whole_number (number, default=FALSE)", _t("Return a whole number or a decimal value.")),
        ],
        returns: ["RANGE<NUMBER>"],
        compute: function (rows = 1, columns = 1, min = 0, max = 1, whole_number = false) {
            const _cols = toInteger(columns, this.locale);
            const _rows = toInteger(rows, this.locale);
            const _min = toNumber(min, this.locale);
            const _max = toNumber(max, this.locale);
            const _whole_number = toBoolean(whole_number);
            assertPositive(_t("The number columns (%s) must be positive.", _cols.toString()), _cols);
            assertPositive(_t("The number rows (%s) must be positive.", _rows.toString()), _rows);
            assert(() => _min <= _max, _t("The maximum (%s) must be greater than or equal to the minimum (%s).", _max.toString(), _min.toString()));
            if (_whole_number) {
                assert(() => Number.isInteger(_min) && Number.isInteger(_max), _t("The maximum (%s) and minimum (%s) must be integers when whole_number is TRUE.", _max.toString(), _min.toString()));
            }
            const result = Array(_cols);
            for (let col = 0; col < _cols; col++) {
                result[col] = Array(_rows);
                for (let row = 0; row < _rows; row++) {
                    if (!_whole_number) {
                        result[col][row] = _min + Math.random() * (_max - _min);
                    }
                    else {
                        result[col][row] = Math.floor(Math.random() * (_max - _min + 1) + _min);
                    }
                }
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // RANDBETWEEN
    // -----------------------------------------------------------------------------
    const RANDBETWEEN = {
        description: _t("Random integer between two values, inclusive."),
        args: [
            arg("low (number)", _t("The low end of the random range.")),
            arg("high (number)", _t("The high end of the random range.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (low) => low?.format,
        compute: function (low, high) {
            let _low = toNumber(low, this.locale);
            if (!Number.isInteger(_low)) {
                _low = Math.ceil(_low);
            }
            let _high = toNumber(high, this.locale);
            if (!Number.isInteger(_high)) {
                _high = Math.floor(_high);
            }
            assert(() => _low <= _high, _t("The high (%s) must be greater than or equal to the low (%s).", _high.toString(), _low.toString()));
            return _low + Math.ceil((_high - _low + 1) * Math.random()) - 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ROUND
    // -----------------------------------------------------------------------------
    const ROUND = {
        description: _t("Rounds a number according to standard rules."),
        args: [
            arg("value (number)", _t("The value to round to places number of places.")),
            arg(`places (number, default=${DEFAULT_PLACES})`, _t("The number of decimal places to which to round.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value) => value?.format,
        compute: function (value, places = DEFAULT_PLACES) {
            const _value = toNumber(value, this.locale);
            let _places = toNumber(places, this.locale);
            const absValue = Math.abs(_value);
            let tempResult;
            if (_places === 0) {
                tempResult = Math.round(absValue);
            }
            else {
                if (!Number.isInteger(_places)) {
                    _places = Math.trunc(_places);
                }
                tempResult = Math.round(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
            }
            return _value >= 0 ? tempResult : -tempResult;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ROUNDDOWN
    // -----------------------------------------------------------------------------
    const ROUNDDOWN = {
        description: _t("Rounds down a number."),
        args: [
            arg("value (number)", _t("The value to round to places number of places, always rounding down.")),
            arg(`places (number, default=${DEFAULT_PLACES})`, _t("The number of decimal places to which to round.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value) => value?.format,
        compute: function (value, places = DEFAULT_PLACES) {
            const _value = toNumber(value, this.locale);
            let _places = toNumber(places, this.locale);
            const absValue = Math.abs(_value);
            let tempResult;
            if (_places === 0) {
                tempResult = Math.floor(absValue);
            }
            else {
                if (!Number.isInteger(_places)) {
                    _places = Math.trunc(_places);
                }
                tempResult = Math.floor(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
            }
            return _value >= 0 ? tempResult : -tempResult;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ROUNDUP
    // -----------------------------------------------------------------------------
    const ROUNDUP = {
        description: _t("Rounds up a number."),
        args: [
            arg("value (number)", _t("The value to round to places number of places, always rounding up.")),
            arg(`places (number, default=${DEFAULT_PLACES})`, _t("The number of decimal places to which to round.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value) => value?.format,
        compute: function (value, places = DEFAULT_PLACES) {
            const _value = toNumber(value, this.locale);
            let _places = toNumber(places, this.locale);
            const absValue = Math.abs(_value);
            let tempResult;
            if (_places === 0) {
                tempResult = Math.ceil(absValue);
            }
            else {
                if (!Number.isInteger(_places)) {
                    _places = Math.trunc(_places);
                }
                tempResult = Math.ceil(absValue * Math.pow(10, _places)) / Math.pow(10, _places);
            }
            return _value >= 0 ? tempResult : -tempResult;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SEC
    // -----------------------------------------------------------------------------
    const SEC = {
        description: _t("Secant of an angle provided in radians."),
        args: [arg("angle (number)", _t("The angle to find the secant of, in radians."))],
        returns: ["NUMBER"],
        compute: function (angle) {
            return 1 / Math.cos(toNumber(angle, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SECH
    // -----------------------------------------------------------------------------
    const SECH = {
        description: _t("Hyperbolic secant of any real number."),
        args: [arg("value (number)", _t("Any real value to calculate the hyperbolic secant of."))],
        returns: ["NUMBER"],
        compute: function (value) {
            return 1 / Math.cosh(toNumber(value, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SIN
    // -----------------------------------------------------------------------------
    const SIN = {
        description: _t("Sine of an angle provided in radians."),
        args: [arg("angle (number)", _t("The angle to find the sine of, in radians."))],
        returns: ["NUMBER"],
        compute: function (angle) {
            return Math.sin(toNumber(angle, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SINH
    // -----------------------------------------------------------------------------
    const SINH = {
        description: _t("Hyperbolic sine of any real number."),
        args: [arg("value (number)", _t("Any real value to calculate the hyperbolic sine of."))],
        returns: ["NUMBER"],
        compute: function (value) {
            return Math.sinh(toNumber(value, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SQRT
    // -----------------------------------------------------------------------------
    const SQRT = {
        description: _t("Positive square root of a positive number."),
        args: [arg("value (number)", _t("The number for which to calculate the positive square root."))],
        returns: ["NUMBER"],
        computeFormat: (value) => value?.format,
        compute: function (value) {
            const _value = toNumber(value, this.locale);
            assert(() => _value >= 0, _t("The value (%s) must be positive or null.", _value.toString()));
            return Math.sqrt(_value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SUM
    // -----------------------------------------------------------------------------
    const SUM = {
        description: _t("Sum of a series of numbers and/or cells."),
        args: [
            arg("value1 (number, range<number>)", _t("The first number or range to add together.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional numbers or ranges to add to value1.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1) => {
            return isMatrix(value1) ? value1[0][0]?.format : value1?.format;
        },
        compute: function (...values) {
            return reduceNumbers(values, (acc, a) => acc + a, 0, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SUMIF
    // -----------------------------------------------------------------------------
    const SUMIF = {
        description: _t("A conditional sum across a range."),
        args: [
            arg("criteria_range (range)", _t("The range which is tested against criterion.")),
            arg("criterion (string)", _t("The pattern or test to apply to range.")),
            arg("sum_range (range, default=criteria_range)", _t("The range to be summed, if different from range.")),
        ],
        returns: ["NUMBER"],
        compute: function (criteriaRange, criterion, sumRange) {
            if (sumRange === undefined) {
                sumRange = criteriaRange;
            }
            let sum = 0;
            visitMatchingRanges([criteriaRange, criterion], (i, j) => {
                const value = sumRange[i][j];
                if (typeof value === "number") {
                    sum += value;
                }
            }, this.locale);
            return sum;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SUMIFS
    // -----------------------------------------------------------------------------
    const SUMIFS = {
        description: _t("Sums a range depending on multiple criteria."),
        args: [
            arg("sum_range (range)", _t("The range to sum.")),
            arg("criteria_range1 (range)", _t("The range to check against criterion1.")),
            arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1.")),
            arg("criteria_range2 (any, range, repeating)", _t("Additional ranges to check.")),
            arg("criterion2 (string, repeating)", _t("Additional criteria to check.")),
        ],
        returns: ["NUMBER"],
        compute: function (sumRange, ...criters) {
            let sum = 0;
            visitMatchingRanges(criters, (i, j) => {
                const value = sumRange[i][j];
                if (typeof value === "number") {
                    sum += value;
                }
            }, this.locale);
            return sum;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TAN
    // -----------------------------------------------------------------------------
    const TAN = {
        description: _t("Tangent of an angle provided in radians."),
        args: [arg("angle (number)", _t("The angle to find the tangent of, in radians."))],
        returns: ["NUMBER"],
        compute: function (angle) {
            return Math.tan(toNumber(angle, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TANH
    // -----------------------------------------------------------------------------
    const TANH = {
        description: _t("Hyperbolic tangent of any real number."),
        args: [arg("value (number)", _t("Any real value to calculate the hyperbolic tangent of."))],
        returns: ["NUMBER"],
        compute: function (value) {
            return Math.tanh(toNumber(value, this.locale));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TRUNC
    // -----------------------------------------------------------------------------
    const TRUNC = {
        description: _t("Truncates a number."),
        args: [
            arg("value (number)", _t("The value to be truncated.")),
            arg(`places (number, default=${DEFAULT_PLACES})`, _t("The number of significant digits to the right of the decimal point to retain.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value) => value?.format,
        compute: function (value, places = DEFAULT_PLACES) {
            const _value = toNumber(value, this.locale);
            let _places = toNumber(places, this.locale);
            if (_places === 0) {
                return Math.trunc(_value);
            }
            if (!Number.isInteger(_places)) {
                _places = Math.trunc(_places);
            }
            return Math.trunc(_value * Math.pow(10, _places)) / Math.pow(10, _places);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // INT
    // -----------------------------------------------------------------------------
    const INT = {
        description: _t("Rounds a number down to the nearest integer that is less than or equal to it."),
        args: [arg("value (number)", _t("The number to round down to the nearest integer."))],
        returns: ["NUMBER"],
        compute: function (value) {
            return Math.floor(toNumber(value, this.locale));
        },
        isExported: true,
    };

    var math = /*#__PURE__*/Object.freeze({
        __proto__: null,
        ABS: ABS,
        ACOS: ACOS,
        ACOSH: ACOSH,
        ACOT: ACOT,
        ACOTH: ACOTH,
        ASIN: ASIN,
        ASINH: ASINH,
        ATAN: ATAN,
        ATAN2: ATAN2,
        ATANH: ATANH,
        CEILING: CEILING,
        CEILING_MATH: CEILING_MATH,
        CEILING_PRECISE: CEILING_PRECISE,
        COS: COS,
        COSH: COSH,
        COT: COT,
        COTH: COTH,
        COUNTBLANK: COUNTBLANK,
        COUNTIF: COUNTIF,
        COUNTIFS: COUNTIFS,
        COUNTUNIQUE: COUNTUNIQUE,
        COUNTUNIQUEIFS: COUNTUNIQUEIFS,
        CSC: CSC,
        CSCH: CSCH,
        DECIMAL: DECIMAL,
        DEGREES: DEGREES,
        EXP: EXP,
        FLOOR: FLOOR,
        FLOOR_MATH: FLOOR_MATH,
        FLOOR_PRECISE: FLOOR_PRECISE,
        INT: INT,
        ISEVEN: ISEVEN,
        ISODD: ISODD,
        ISO_CEILING: ISO_CEILING,
        LN: LN,
        LOG: LOG,
        MOD: MOD,
        MUNIT: MUNIT,
        ODD: ODD,
        PI: PI,
        POWER: POWER,
        PRODUCT: PRODUCT,
        RAND: RAND,
        RANDARRAY: RANDARRAY,
        RANDBETWEEN: RANDBETWEEN,
        ROUND: ROUND,
        ROUNDDOWN: ROUNDDOWN,
        ROUNDUP: ROUNDUP,
        SEC: SEC,
        SECH: SECH,
        SIN: SIN,
        SINH: SINH,
        SQRT: SQRT,
        SUM: SUM,
        SUMIF: SUMIF,
        SUMIFS: SUMIFS,
        TAN: TAN,
        TANH: TANH,
        TRUNC: TRUNC
    });

    function assertSameNumberOfElements(...args) {
        const dims = args[0].length;
        args.forEach((arg, i) => assert(() => arg.length === dims, _t("[[FUNCTION_NAME]] has mismatched dimensions for argument %s (%s vs %s).", i.toString(), dims.toString(), arg.length.toString())));
    }
    function assertNonEmptyMatrix(matrix, argName) {
        assert(() => matrix.length > 0 && matrix[0].length > 0, _t("[[FUNCTION_NAME]] expects the provided values of %(argName)s to be a non-empty matrix.", {
            argName,
        }));
    }
    function assertNonEmpty(...data) {
        if (data.length === 0 || data.some((arg) => arg.length === 0)) {
            throw new NotAvailableError(_t("[[FUNCTION_NAME]] has no valid input data."));
        }
    }

    function filterAndFlatData(dataY, dataX) {
        const _flatDataY = [];
        const _flatDataX = [];
        let lenY = 0;
        let lenX = 0;
        visitAny([dataY], (y) => {
            _flatDataY.push(y);
            lenY += 1;
        });
        visitAny([dataX], (x) => {
            _flatDataX.push(x);
            lenX += 1;
        });
        assert(() => lenY === lenX, _t("[[FUNCTION_NAME]] has mismatched argument count %s vs %s.", lenY, lenX));
        const flatDataX = [];
        const flatDataY = [];
        for (let i = 0; i < lenY; i++) {
            const valueY = _flatDataY[i];
            const valueX = _flatDataX[i];
            if (typeof valueY === "number" && typeof valueX === "number") {
                flatDataY.push(valueY);
                flatDataX.push(valueX);
            }
        }
        return { flatDataX, flatDataY };
    }
    // Note: dataY and dataX may not have the same dimension
    function covariance(dataY, dataX, isSample) {
        const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
        const count = flatDataY.length;
        assert(() => count !== 0 && (!isSample || count !== 1), _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
        let sumY = 0;
        let sumX = 0;
        for (let i = 0; i < count; i++) {
            sumY += flatDataY[i];
            sumX += flatDataX[i];
        }
        const averageY = sumY / count;
        const averageX = sumX / count;
        let acc = 0;
        for (let i = 0; i < count; i++) {
            acc += (flatDataY[i] - averageY) * (flatDataX[i] - averageX);
        }
        return acc / (count - (isSample ? 1 : 0));
    }
    function variance(args, isSample, textAs0, locale) {
        let count = 0;
        let sum = 0;
        const reduceFunction = textAs0 ? reduceNumbersTextAs0 : reduceNumbers;
        sum = reduceFunction(args, (acc, a) => {
            count += 1;
            return acc + a;
        }, 0, locale);
        assert(() => count !== 0 && (!isSample || count !== 1), _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
        const average = sum / count;
        return (reduceFunction(args, (acc, a) => acc + Math.pow(a - average, 2), 0, locale) /
            (count - (isSample ? 1 : 0)));
    }
    function centile(data, percent, isInclusive, locale) {
        const _percent = toNumber(percent, locale);
        assert(() => (isInclusive ? 0 <= _percent && _percent <= 1 : 0 < _percent && _percent < 1), _t("Function [[FUNCTION_NAME]] parameter 2 value is out of range."));
        let sortedArray = [];
        let index;
        let count = 0;
        visitAny(data, (d) => {
            if (typeof d === "number") {
                index = dichotomicSearch(sortedArray, d, "nextSmaller", "asc", sortedArray.length, (array, i) => array[i]);
                sortedArray.splice(index + 1, 0, d);
                count++;
            }
        });
        assert(() => count !== 0, _t("[[FUNCTION_NAME]] has no valid input data."));
        if (!isInclusive) {
            // 2nd argument must be between 1/(n+1) and n/(n+1) with n the number of data
            assert(() => 1 / (count + 1) <= _percent && _percent <= count / (count + 1), _t("Function [[FUNCTION_NAME]] parameter 2 value is out of range."));
        }
        return percentile(sortedArray, _percent, isInclusive);
    }
    function prepareDataForRegression(X, Y, newX) {
        const _X = X.length ? X : [range(1, Y.flat().length + 1)];
        const nVar = _X.length;
        let _newX = newX.length ? newX : _X;
        _newX = _newX.length === nVar ? transposeMatrix(_newX) : _newX;
        return { _X, _newX };
    }
    /*
     * This function performs a linear regression on the data set. It returns an array with two elements.
     * The first element is the slope, and the second element is the intercept.
     * The linear regression line is: y = slope*x + intercept
     * The function use the least squares method to find the best fit for the data set :
     * see https://www.mathsisfun.com/data/least-squares-regression.html
     *     https://www.statology.org/standard-error-of-estimate/
     *     https://agronomy4future.org/?p=16670
     *     https://vitalflux.com/interpreting-f-statistics-in-linear-regression-formula-examples/
     *     https://web.ist.utl.pt/~ist11038/compute/errtheory/,regression/regrthroughorigin.pdf
     */
    function fullLinearRegression(X, Y, computeIntercept = true, verbose = false) {
        const y = Y.flat();
        const n = y.length;
        let { _X } = prepareDataForRegression(X, Y, []);
        _X = _X.length === n ? transposeMatrix(_X) : _X.slice();
        assertSameNumberOfElements(_X[0], y);
        const nVar = _X.length;
        const nDeg = n - nVar - (computeIntercept ? 1 : 0);
        const yMatrix = [y];
        const xMatrix = transposeMatrix(_X.reverse());
        let avgX = [];
        for (let i = 0; i < nVar; i++) {
            avgX.push(0);
            if (computeIntercept) {
                for (const xij of _X[i]) {
                    avgX[i] += xij;
                }
                avgX[i] /= n;
            }
        }
        let avgY = 0;
        if (computeIntercept) {
            for (const yi of y) {
                avgY += yi;
            }
            avgY /= n;
        }
        const redX = xMatrix.map((row) => row.map((value, i) => value - avgX[i]));
        if (computeIntercept) {
            xMatrix.forEach((row) => row.push(1));
        }
        const coeffs = getLMSCoefficients(xMatrix, yMatrix);
        if (!computeIntercept) {
            coeffs.push([0]);
        }
        if (!verbose) {
            return coeffs;
        }
        const dot1 = multiplyMatrices(redX, transposeMatrix(redX));
        const { inverted: dotInv } = invertMatrix(dot1);
        if (dotInv === undefined) {
            throw new Error(_t("Matrix is not invertible"));
        }
        let SSE = 0, SSR = 0;
        for (let i = 0; i < n; i++) {
            const yi = y[i] - avgY;
            let temp = 0;
            for (let j = 0; j < nVar; j++) {
                const xi = redX[i][j];
                temp += xi * coeffs[j][0];
            }
            const ei = yi - temp;
            SSE += ei * ei;
            SSR += temp * temp;
        }
        const RMSE = Math.sqrt(SSE / nDeg);
        const r2 = SSR / (SSR + SSE);
        const f_stat = SSR / nVar / (SSE / nDeg);
        const deltaCoeffs = [];
        for (let i = 0; i < nVar; i++) {
            deltaCoeffs.push(RMSE * Math.sqrt(dotInv[i][i]));
        }
        if (computeIntercept) {
            const dot2 = multiplyMatrices(dotInv, [avgX]);
            const dot3 = multiplyMatrices(transposeMatrix([avgX]), dot2);
            deltaCoeffs.push(RMSE * Math.sqrt(dot3[0][0] + 1 / y.length));
        }
        const returned = [
            [coeffs[0][0], deltaCoeffs[0], r2, f_stat, SSR],
            [coeffs[1][0], deltaCoeffs[1], RMSE, nDeg, SSE],
        ];
        for (let i = 2; i < nVar; i++) {
            returned.push([coeffs[i][0], deltaCoeffs[i], "", "", ""]);
        }
        if (computeIntercept) {
            returned.push([coeffs[nVar][0], deltaCoeffs[nVar], "", "", ""]);
        }
        else {
            returned.push([0, "", "", "", ""]);
        }
        return returned;
    }
    /*
      This function performs a polynomial regression on the data set. It returns the coefficients of
      the polynomial function that best fits the data set.
      The polynomial function is: y = c0 + c1*x + c2*x^2 + ... + cn*x^n, where n is the order (degree)
      of the polynomial. The returned coefficients are then in the form: [c0, c1, c2, ..., cn]
      The function is based on the method of least squares :
      see: https://mathworld.wolfram.com/LeastSquaresFittingPolynomial.html
    */
    function polynomialRegression(flatY, flatX, order, intercept) {
        assertSameNumberOfElements(flatX, flatY);
        assert(() => order >= 1, _t("Function [[FUNCTION_NAME]] A regression of order less than 1 cannot be possible."));
        const yMatrix = [flatY];
        const xMatrix = flatX.map((x) => range(0, order).map((i) => Math.pow(x, order - i)));
        if (intercept) {
            xMatrix.forEach((row) => row.push(1));
        }
        const coeffs = getLMSCoefficients(xMatrix, yMatrix);
        if (!intercept) {
            coeffs.push([0]);
        }
        return coeffs;
    }
    function getLMSCoefficients(xMatrix, yMatrix) {
        const xMatrixT = transposeMatrix(xMatrix);
        const dot1 = multiplyMatrices(xMatrix, xMatrixT);
        const { inverted: dotInv } = invertMatrix(dot1);
        if (dotInv === undefined) {
            throw new Error(_t("Matrix is not invertible"));
        }
        const dot2 = multiplyMatrices(xMatrix, yMatrix);
        return transposeMatrix(multiplyMatrices(dotInv, dot2));
    }
    function evaluatePolynomial(coeffs, x, order) {
        return coeffs.reduce((acc, coeff, i) => acc + coeff * Math.pow(x, order - i), 0);
    }
    function expM(M) {
        return M.map((col) => col.map((cell) => Math.exp(cell)));
    }
    function logM(M) {
        return M.map((col) => col.map((cell) => Math.log(cell)));
    }
    function predictLinearValues(Y, X, newX, computeIntercept) {
        const { _X, _newX } = prepareDataForRegression(X, Y, newX);
        const coeffs = fullLinearRegression(_X, Y, computeIntercept, false);
        const nVar = coeffs.length - 1;
        const newY = _newX.map((col) => {
            let value = 0;
            for (let i = 0; i < nVar; i++) {
                value += coeffs[i][0] * col[nVar - i - 1];
            }
            value += coeffs[nVar][0];
            return [value];
        });
        return newY.length === newX.length ? newY : transposeMatrix(newY);
    }
    // -----------------------------------------------------------------------------
    // AVEDEV
    // -----------------------------------------------------------------------------
    const AVEDEV = {
        description: _t("Average magnitude of deviations from mean."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            let count = 0;
            const sum = reduceNumbers(values, (acc, a) => {
                count += 1;
                return acc + a;
            }, 0, this.locale);
            assert(() => count !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            const average = sum / count;
            return reduceNumbers(values, (acc, a) => acc + Math.abs(average - a), 0, this.locale) / count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // AVERAGE
    // -----------------------------------------------------------------------------
    const AVERAGE = {
        description: _t("Numerical average value in a dataset, ignoring text."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the average value.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the average value.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1) => {
            return isMatrix(value1) ? value1[0][0]?.format : value1?.format;
        },
        compute: function (...values) {
            let count = 0;
            const sum = reduceNumbers(values, (acc, a) => {
                count += 1;
                return acc + a;
            }, 0, this.locale);
            assert(() => count !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return sum / count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // AVERAGE.WEIGHTED
    // -----------------------------------------------------------------------------
    const rangeError = _t("[[FUNCTION_NAME]] has mismatched range sizes.");
    const negativeWeightError = _t("[[FUNCTION_NAME]] expects the weight to be positive or equal to 0.");
    const AVERAGE_WEIGHTED = {
        description: _t("Weighted average."),
        args: [
            arg("values (number, range<number>)", _t("Values to average.")),
            arg("weights (number, range<number>)", _t("Weights for each corresponding value.")),
            arg("additional_values (number, range<number>, repeating)", _t("Additional values to average.")),
            arg("additional_weights (number, range<number>, repeating)", _t("Additional weights.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (values) => {
            return isMatrix(values) ? values[0][0]?.format : values?.format;
        },
        compute: function (...values) {
            let sum = 0;
            let count = 0;
            let value;
            let weight;
            assert(() => values.length % 2 === 0, _t("Wrong number of Argument[]. Expected an even number of Argument[]."));
            for (let n = 0; n < values.length - 1; n += 2) {
                value = values[n];
                weight = values[n + 1];
                // if (typeof value != typeof weight) {
                //   throw new Error(rangeError);
                // }
                if (isMatrix(value)) {
                    assert(() => isMatrix(weight), rangeError);
                    let dimColValue = value.length;
                    let dimLinValue = value[0].length;
                    assert(() => dimColValue === weight.length && dimLinValue === weight[0].length, rangeError);
                    for (let i = 0; i < dimColValue; i++) {
                        for (let j = 0; j < dimLinValue; j++) {
                            let subValue = value[i][j];
                            let subWeight = weight[i][j];
                            let subValueIsNumber = typeof subValue === "number";
                            let subWeightIsNumber = typeof subWeight === "number";
                            // typeof subValue or subWeight can be 'number' or 'undefined'
                            assert(() => subValueIsNumber === subWeightIsNumber, _t("[[FUNCTION_NAME]] expects number values."));
                            if (subWeightIsNumber) {
                                assert(() => subWeight >= 0, negativeWeightError);
                                sum += subValue * subWeight;
                                count += subWeight;
                            }
                        }
                    }
                }
                else {
                    weight = toNumber(weight, this.locale);
                    value = toNumber(value, this.locale);
                    assert(() => weight >= 0, negativeWeightError);
                    sum += value * weight;
                    count += weight;
                }
            }
            assert(() => count !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return sum / count;
        },
    };
    // -----------------------------------------------------------------------------
    // AVERAGEA
    // -----------------------------------------------------------------------------
    const AVERAGEA = {
        description: _t("Numerical average value in a dataset."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the average value.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the average value.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1) => {
            return isMatrix(value1) ? value1[0][0]?.format : value1?.format;
        },
        compute: function (...values) {
            let count = 0;
            const sum = reduceNumbersTextAs0(values, (acc, a) => {
                count += 1;
                return acc + a;
            }, 0, this.locale);
            assert(() => count !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return sum / count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // AVERAGEIF
    // -----------------------------------------------------------------------------
    const AVERAGEIF = {
        description: _t("Average of values depending on criteria."),
        args: [
            arg("criteria_range (number, range<number>)", _t("The range to check against criterion.")),
            arg("criterion (string)", _t("The pattern or test to apply to criteria_range.")),
            arg("average_range (number, range<number>, default=criteria_range)", _t("The range to average. If not included, criteria_range is used for the average instead.")),
        ],
        returns: ["NUMBER"],
        compute: function (criteriaRange, criterion, averageRange) {
            const _criteriaRange = toMatrix(criteriaRange);
            const _averageRange = averageRange === undefined ? _criteriaRange : toMatrix(averageRange);
            let count = 0;
            let sum = 0;
            visitMatchingRanges([criteriaRange, criterion], (i, j) => {
                const value = _averageRange[i][j];
                if (typeof value === "number") {
                    count += 1;
                    sum += value;
                }
            }, this.locale);
            assert(() => count !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return sum / count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // AVERAGEIFS
    // -----------------------------------------------------------------------------
    const AVERAGEIFS = {
        description: _t("Average of values depending on multiple criteria."),
        args: [
            arg("average_range (range)", _t("The range to average.")),
            arg("criteria_range1 (range)", _t("The range to check against criterion1.")),
            arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1.")),
            arg("criteria_range2 (any, range, repeating)", _t("Additional criteria_range and criterion to check.")),
            arg("criterion2 (string, repeating)", _t("The pattern or test to apply to criteria_range2.")),
        ],
        returns: ["NUMBER"],
        compute: function (averageRange, ...values) {
            const _averageRange = toMatrix(averageRange);
            let count = 0;
            let sum = 0;
            visitMatchingRanges(values, (i, j) => {
                const value = _averageRange[i][j];
                if (typeof value === "number") {
                    count += 1;
                    sum += value;
                }
            }, this.locale);
            assert(() => count !== 0, _t("Evaluation of function [[FUNCTION_NAME]] caused a divide by zero error."));
            return sum / count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUNT
    // -----------------------------------------------------------------------------
    const COUNT = {
        description: _t("The number of numeric values in dataset."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range to consider when counting.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when counting.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            let count = 0;
            for (let n of values) {
                if (isMatrix(n)) {
                    for (let i of n) {
                        for (let j of i) {
                            if (typeof j === "number") {
                                count += 1;
                            }
                        }
                    }
                }
                else if (typeof n !== "string" ||
                    isNumber(n, this.locale) ||
                    parseDateTime(n, this.locale)) {
                    count += 1;
                }
            }
            return count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUNTA
    // -----------------------------------------------------------------------------
    const COUNTA = {
        description: _t("The number of values in a dataset."),
        args: [
            arg("value1 (any, range)", _t("The first value or range to consider when counting.")),
            arg("value2 (any, range, repeating)", _t("Additional values or ranges to consider when counting.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return reduceAny(values, (acc, a) => (a !== undefined && a !== null ? acc + 1 : acc), 0);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COVAR
    // -----------------------------------------------------------------------------
    // Note: Unlike the VAR function which corresponds to the variance over a sample (VAR.S),
    // the COVAR function corresponds to the covariance over an entire population (COVAR.P)
    const COVAR = {
        description: _t("The covariance of a dataset."),
        args: [
            arg("data_y (any, range)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (any, range)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX) {
            return covariance(dataY, dataX, false);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COVARIANCE.P
    // -----------------------------------------------------------------------------
    const COVARIANCE_P = {
        description: _t("The covariance of a dataset."),
        args: [
            arg("data_y (any, range)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (any, range)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX) {
            return covariance(dataY, dataX, false);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COVARIANCE.S
    // -----------------------------------------------------------------------------
    const COVARIANCE_S = {
        description: _t("The sample covariance of a dataset."),
        args: [
            arg("data_y (any, range)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (any, range)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX) {
            return covariance(dataY, dataX, true);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FORECAST
    // -----------------------------------------------------------------------------
    const FORECAST = {
        description: _t("Calculates the expected y-value for a specified x based on a linear regression of a dataset."),
        args: [
            arg("x (number, range<number>)", _t("The value(s) on the x-axis to forecast.")),
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (x, dataY, dataX) {
            const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
            assertNonEmpty(flatDataX, flatDataY);
            return predictLinearValues([flatDataY], [flatDataX], matrixMap(toMatrix(x), (value) => toNumber(value, this.locale)), true);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // GROWTH
    // -----------------------------------------------------------------------------
    const GROWTH = {
        description: _t("Fits points to exponential growth trend."),
        args: [
            arg("known_data_y (range<number>)", _t("The array or range containing dependent (y) values that are already known, used to curve fit an ideal exponential growth curve.")),
            arg("known_data_x (range<number>, default={1;2;3;...})", _t("The values of the independent variable(s) corresponding with known_data_y.")),
            arg("new_data_x (any, range, default=known_data_x)", _t("The data points to return the y values for on the ideal curve fit.")),
            arg("b (boolean, default=TRUE)", _t("Given a general exponential form of y = b*m^x for a curve fit, calculates b if TRUE or forces b to be 1 and only calculates the m values if FALSE.")),
        ],
        returns: ["NUMBER"],
        compute: function (knownDataY, knownDataX = [], newDataX = [], b = true) {
            assertNonEmptyMatrix(knownDataY, "known_data_y");
            return expM(predictLinearValues(logM(tryCastAsNumberMatrix(knownDataY, "known_data_y")), tryCastAsNumberMatrix(knownDataX, "known_data_x"), tryCastAsNumberMatrix(newDataX, "new_data_y"), toBoolean(b)));
        },
    };
    // -----------------------------------------------------------------------------
    // INTERCEPT
    // -----------------------------------------------------------------------------
    const INTERCEPT = {
        description: _t("Compute the intercept of the linear regression."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX) {
            const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
            assertNonEmpty(flatDataX, flatDataY);
            const [[], [intercept]] = fullLinearRegression([flatDataX], [flatDataY]);
            return intercept;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // LARGE
    // -----------------------------------------------------------------------------
    const LARGE = {
        description: _t("Nth largest element from a data set."),
        args: [
            arg("data (any, range)", _t("Array or range containing the dataset to consider.")),
            arg("n (number)", _t("The rank from largest to smallest of the element to return.")),
        ],
        returns: ["NUMBER"],
        computeValueAndFormat: function (data, n) {
            const _n = Math.trunc(toNumber(n?.value, this.locale));
            let largests = [];
            let index;
            let count = 0;
            visitAny([data], (d) => {
                if (typeof d.value === "number") {
                    index = dichotomicSearch(largests, d.value, "nextSmaller", "asc", largests.length, (array, i) => array[i].value);
                    largests.splice(index + 1, 0, d);
                    count++;
                    if (count > _n) {
                        largests.shift();
                        count--;
                    }
                }
            });
            const result = largests.shift();
            assert(() => result !== undefined, _t("[[FUNCTION_NAME]] has no valid input data."));
            assert(() => count >= _n, _t("Function [[FUNCTION_NAME]] parameter 2 value (%s) is out of range.", _n));
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // LINEST
    // -----------------------------------------------------------------------------
    const LINEST = {
        description: _t("Compute the intercept of the linear regression."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>, default={1;2;3;...})", _t("The range representing the array or matrix of independent data.")),
            arg("calculate_b (boolean, default=TRUE)", _t("A flag specifying wheter to compute the slope or not")),
            arg("verbose (boolean, default=FALSE)", _t("A flag specifying whether to return additional regression statistics or only the linear coefficients and the y-intercept")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX = [], calculateB = true, verbose = false) {
            assertNonEmptyMatrix(dataY, "data_y");
            return fullLinearRegression(tryCastAsNumberMatrix(dataX, "data_x"), tryCastAsNumberMatrix(dataY, "data_y"), toBoolean(calculateB), toBoolean(verbose));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // LOGEST
    // -----------------------------------------------------------------------------
    const LOGEST = {
        description: _t("Compute the intercept of the linear regression."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>, optional, default={1;2;3;...})", _t("The range representing the array or matrix of independent data.")),
            arg("calculate_b (boolean, default=TRUE)", _t("A flag specifying wheter to compute the slope or not")),
            arg("verbose (boolean, default=FALSE)", _t("A flag specifying whether to return additional regression statistics or only the linear coefficients and the y-intercept")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX = [], calculateB = true, verbose = false) {
            assertNonEmptyMatrix(dataY, "data_y");
            const coeffs = fullLinearRegression(tryCastAsNumberMatrix(dataX, "data_x"), logM(tryCastAsNumberMatrix(dataY, "data_y")), toBoolean(calculateB), toBoolean(verbose));
            for (let i = 0; i < coeffs.length; i++) {
                coeffs[i][0] = Math.exp(coeffs[i][0]);
            }
            return coeffs;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MATTHEWS
    // -----------------------------------------------------------------------------
    const MATTHEWS = {
        description: _t("Compute the Matthews correlation coefficient of a dataset."),
        args: [
            arg("data_x (range)", _t("The range representing the array or matrix of observed data.")),
            arg("data_y (range)", _t("The range representing the array or matrix of predicted data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataX, dataY) {
            const flatX = dataX.flat();
            const flatY = dataY.flat();
            assertSameNumberOfElements(flatX, flatY);
            assertNonEmpty(flatX, flatY);
            const n = flatX.length;
            let trueN = 0, trueP = 0, falseP = 0, falseN = 0;
            for (let i = 0; i < n; ++i) {
                const isTrue1 = toBoolean(flatX[i]);
                const isTrue2 = toBoolean(flatY[i]);
                if (isTrue1 === isTrue2) {
                    if (isTrue1) {
                        trueP++;
                    }
                    else {
                        trueN++;
                    }
                }
                else {
                    if (isTrue1) {
                        falseN++;
                    }
                    else {
                        falseP++;
                    }
                }
            }
            return ((trueP * trueN - falseP * falseN) /
                Math.sqrt((trueP + falseP) * (trueP + falseN) * (trueN + falseP) * (trueN + falseN)));
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // MAX
    // -----------------------------------------------------------------------------
    const MAX = {
        description: _t("Maximum value in a numeric dataset."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the maximum value.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the maximum value.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1) => {
            return isMatrix(value1) ? value1[0][0]?.format : value1?.format;
        },
        compute: function (...values) {
            const result = reduceNumbers(values, (acc, a) => (acc < a ? a : acc), -Infinity, this.locale);
            return result === -Infinity ? 0 : result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MAXA
    // -----------------------------------------------------------------------------
    const MAXA = {
        description: _t("Maximum numeric value in a dataset."),
        args: [
            arg("value1 (any, range)", _t("The first value or range to consider when calculating the maximum value.")),
            arg("value2 (any, range, repeating)", _t("Additional values or ranges to consider when calculating the maximum value.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1) => {
            return isMatrix(value1) ? value1[0][0]?.format : value1?.format;
        },
        compute: function (...values) {
            const maxa = reduceNumbersTextAs0(values, (acc, a) => {
                return Math.max(a, acc);
            }, -Infinity, this.locale);
            return maxa === -Infinity ? 0 : maxa;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MAXIFS
    // -----------------------------------------------------------------------------
    const MAXIFS = {
        description: _t("Returns the maximum value in a range of cells, filtered by a set of criteria."),
        args: [
            arg("range (range)", _t("The range of cells from which the maximum will be determined.")),
            arg("criteria_range1 (range)", _t("The range of cells over which to evaluate criterion1.")),
            arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
            arg("criteria_range2 (any, range, repeating)", _t("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
            arg("criterion2 (string, repeating)", _t("The pattern or test to apply to criteria_range2.")),
        ],
        returns: ["NUMBER"],
        compute: function (range, ...args) {
            let result = -Infinity;
            const _range = toMatrix(range);
            visitMatchingRanges(args, (i, j) => {
                const value = _range[i][j];
                if (typeof value === "number") {
                    result = result < value ? value : result;
                }
            }, this.locale);
            return result === -Infinity ? 0 : result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MEDIAN
    // -----------------------------------------------------------------------------
    const MEDIAN = {
        description: _t("Median value in a numeric dataset."),
        args: [
            arg("value1 (any, range)", _t("The first value or range to consider when calculating the median value.")),
            arg("value2 (any, range, repeating)", _t("Additional values or ranges to consider when calculating the median value.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1) => {
            return isMatrix(value1) ? value1[0][0]?.format : value1?.format;
        },
        compute: function (...values) {
            let data = [];
            visitNumbers(values, (arg) => {
                data.push(arg);
            }, this.locale);
            return centile(data, 0.5, true, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MIN
    // -----------------------------------------------------------------------------
    const MIN = {
        description: _t("Minimum value in a numeric dataset."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the minimum value.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the minimum value.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1) => {
            return isMatrix(value1) ? value1[0][0]?.format : value1?.format;
        },
        compute: function (...values) {
            const result = reduceNumbers(values, (acc, a) => (a < acc ? a : acc), Infinity, this.locale);
            return result === Infinity ? 0 : result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MINA
    // -----------------------------------------------------------------------------
    const MINA = {
        description: _t("Minimum numeric value in a dataset."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range to consider when calculating the minimum value.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to consider when calculating the minimum value.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1) => {
            return isMatrix(value1) ? value1[0][0]?.format : value1?.format;
        },
        compute: function (...values) {
            const mina = reduceNumbersTextAs0(values, (acc, a) => {
                return Math.min(a, acc);
            }, Infinity, this.locale);
            return mina === Infinity ? 0 : mina;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MINIFS
    // -----------------------------------------------------------------------------
    const MINIFS = {
        description: _t("Returns the minimum value in a range of cells, filtered by a set of criteria."),
        args: [
            arg("range (range)", _t("The range of cells from which the minimum will be determined.")),
            arg("criteria_range1 (range)", _t("The range of cells over which to evaluate criterion1.")),
            arg("criterion1 (string)", _t("The pattern or test to apply to criteria_range1, such that each cell that evaluates to TRUE will be included in the filtered set.")),
            arg("criteria_range2 (any, range, repeating)", _t("Additional ranges over which to evaluate the additional criteria. The filtered set will be the intersection of the sets produced by each criterion-range pair.")),
            arg("criterion2 (string, repeating)", _t("The pattern or test to apply to criteria_range2.")),
        ],
        returns: ["NUMBER"],
        compute: function (range, ...args) {
            let result = Infinity;
            const _range = toMatrix(range);
            visitMatchingRanges(args, (i, j) => {
                const value = _range[i][j];
                if (typeof value === "number") {
                    result = result > value ? value : result;
                }
            }, this.locale);
            return result === Infinity ? 0 : result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PEARSON
    // -----------------------------------------------------------------------------
    const PEARSON = {
        description: _t("Compute the Pearson product-moment correlation coefficient of a dataset."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX) {
            const { flatDataX, flatDataY } = filterAndFlatData(dataX, dataY);
            assertNonEmpty(flatDataX, flatDataY);
            const n = flatDataX.length;
            let sumX = 0, sumY = 0, sumXY = 0, sumXX = 0, sumYY = 0;
            for (let i = 0; i < n; i++) {
                const xij = flatDataX[i];
                const yij = flatDataY[i];
                sumX += xij;
                sumY += yij;
                sumXY += xij * yij;
                sumXX += xij * xij;
                sumYY += yij * yij;
            }
            return ((n * sumXY - sumX * sumY) / Math.sqrt((n * sumXX - sumX * sumX) * (n * sumYY - sumY * sumY)));
        },
        isExported: true,
    };
    // In GSheet, CORREL is just an alias to PEARSON
    const CORREL = PEARSON;
    // -----------------------------------------------------------------------------
    // PERCENTILE
    // -----------------------------------------------------------------------------
    const PERCENTILE = {
        description: _t("Value at a given percentile of a dataset."),
        args: [
            arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
            arg("percentile (number)", _t("The percentile whose value within data will be calculated and returned.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (data) => {
            return isMatrix(data) ? data[0][0]?.format : data?.format;
        },
        compute: function (data, percentile) {
            return PERCENTILE_INC.compute.bind(this)(data, percentile);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PERCENTILE.EXC
    // -----------------------------------------------------------------------------
    const PERCENTILE_EXC = {
        description: _t("Value at a given percentile of a dataset exclusive of 0 and 1."),
        args: [
            arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
            arg("percentile (number)", _t("The percentile, exclusive of 0 and 1, whose value within 'data' will be calculated and returned.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (data) => {
            return isMatrix(data) ? data[0][0]?.format : data?.format;
        },
        compute: function (data, percentile) {
            return centile([data], percentile, false, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PERCENTILE.INC
    // -----------------------------------------------------------------------------
    const PERCENTILE_INC = {
        description: _t("Value at a given percentile of a dataset."),
        args: [
            arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
            arg("percentile (number)", _t("The percentile whose value within data will be calculated and returned.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (data) => {
            return isMatrix(data) ? data[0][0]?.format : data?.format;
        },
        compute: function (data, percentile) {
            return centile([data], percentile, true, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // POLYFIT
    // -----------------------------------------------------------------------------
    const POLYFIT_COEFFS = {
        description: _t("Compute the coefficients of polynomial regression of the dataset."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
            arg("order (number)", _t("The order of the polynomial to fit the data, between 1 and 6.")),
            arg("intercept (boolean, default=TRUE)", _t("A flag specifying whether to compute the intercept or not.")),
        ],
        returns: ["RANGE<NUMBER>"],
        compute: function (dataY, dataX, order, intercept = true) {
            const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
            assertNonEmpty(flatDataX, flatDataY);
            return polynomialRegression(flatDataY, flatDataX, toNumber(order, this.locale), toBoolean(intercept));
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // POLYFIT.FORECAST
    // -----------------------------------------------------------------------------
    const POLYFIT_FORECAST = {
        description: _t("Predict value by computing a polynomial regression of the dataset."),
        args: [
            arg("x (number, range<number>)", _t("The value(s) on the x-axis to forecast.")),
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
            arg("order (number)", _t("The order of the polynomial to fit the data, between 1 and 6.")),
            arg("intercept (boolean, default=TRUE)", _t("A flag specifying whether to compute the intercept or not.")),
        ],
        returns: ["NUMBER"],
        compute: function (x, dataY, dataX, order, intercept = true) {
            const _order = toNumber(order, this.locale);
            const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
            assertNonEmpty(flatDataX, flatDataY);
            const coeffs = polynomialRegression(flatDataY, flatDataX, _order, toBoolean(intercept)).flat();
            return matrixMap(toMatrix(x), (xij) => evaluatePolynomial(coeffs, toNumber(xij, this.locale), _order));
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // QUARTILE
    // -----------------------------------------------------------------------------
    const QUARTILE = {
        description: _t("Value nearest to a specific quartile of a dataset."),
        args: [
            arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
            arg("quartile_number (number)", _t("Which quartile value to return.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (data) => {
            return isMatrix(data) ? data[0][0]?.format : data?.format;
        },
        compute: function (data, quartileNumber) {
            return QUARTILE_INC.compute.bind(this)(data, quartileNumber);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // QUARTILE.EXC
    // -----------------------------------------------------------------------------
    const QUARTILE_EXC = {
        description: _t("Value nearest to a specific quartile of a dataset exclusive of 0 and 4."),
        args: [
            arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
            arg("quartile_number (number)", _t("Which quartile value, exclusive of 0 and 4, to return.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (data) => {
            return isMatrix(data) ? data[0][0]?.format : data?.format;
        },
        compute: function (data, quartileNumber) {
            const _quartileNumber = Math.trunc(toNumber(quartileNumber, this.locale));
            return centile([data], 0.25 * _quartileNumber, false, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // QUARTILE.INC
    // -----------------------------------------------------------------------------
    const QUARTILE_INC = {
        description: _t("Value nearest to a specific quartile of a dataset."),
        args: [
            arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
            arg("quartile_number (number)", _t("Which quartile value to return.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (data) => {
            return isMatrix(data) ? data[0][0]?.format : data?.format;
        },
        compute: function (data, quartileNumber) {
            const _quartileNumber = Math.trunc(toNumber(quartileNumber, this.locale));
            return centile([data], 0.25 * _quartileNumber, true, this.locale);
        },
        isExported: true,
    };
    // RANK
    // -----------------------------------------------------------------------------
    const RANK = {
        description: _t("Returns the rank of a specified value in a dataset."),
        args: [
            arg("value (number)", _t("The value whose rank will be determined.")),
            arg("data (range)", _t("The range containing the dataset to consider.")),
            arg("is_ascending (boolean, default=FALSE)", _t("Whether to consider the values in data in descending or ascending order.")),
        ],
        returns: ["ANY"],
        compute: function (value, data, isAscending = false) {
            const _isAscending = toBoolean(isAscending);
            const _value = toNumber(value, this.locale);
            let rank = 1;
            let found = false;
            for (const row of data) {
                for (const cell of row) {
                    if (typeof cell !== "number") {
                        continue;
                    }
                    const _cell = toNumber(cell, this.locale);
                    if (_cell === _value) {
                        found = true;
                    }
                    else if (_cell > _value !== _isAscending) {
                        rank++;
                    }
                }
            }
            if (!found) {
                throw new NotAvailableError(_t("Value not found in the given data."));
            }
            return rank;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // RSQ
    // -----------------------------------------------------------------------------
    const RSQ = {
        description: _t("Compute the square of r, the Pearson product-moment correlation coefficient of a dataset."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX) {
            const pearson = PEARSON.compute.bind(this);
            return Math.pow(pearson(dataX, dataY), 2.0);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SLOPE
    // -----------------------------------------------------------------------------
    const SLOPE = {
        description: _t("Compute the slope of the linear regression."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX) {
            const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
            assertNonEmpty(flatDataX, flatDataY);
            const [[slope]] = fullLinearRegression([flatDataX], [flatDataY]);
            return slope;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SMALL
    // -----------------------------------------------------------------------------
    const SMALL = {
        description: _t("Nth smallest element in a data set."),
        args: [
            arg("data (any, range)", _t("The array or range containing the dataset to consider.")),
            arg("n (number)", _t("The rank from smallest to largest of the element to return.")),
        ],
        returns: ["NUMBER"],
        computeValueAndFormat: function (data, n) {
            const _n = Math.trunc(toNumber(n?.value, this.locale));
            let largests = [];
            let index;
            let count = 0;
            visitAny([data], (d) => {
                if (typeof d.value === "number") {
                    index = dichotomicSearch(largests, d.value, "nextSmaller", "asc", largests.length, (array, i) => array[i].value);
                    largests.splice(index + 1, 0, d);
                    count++;
                    if (count > _n) {
                        largests.pop();
                        count--;
                    }
                }
            });
            const result = largests.pop();
            assert(() => result !== undefined, _t("[[FUNCTION_NAME]] has no valid input data."));
            assert(() => count >= _n, _t("Function [[FUNCTION_NAME]] parameter 2 value (%s) is out of range.", _n));
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SPEARMAN
    // -----------------------------------------------------------------------------
    const SPEARMAN = {
        description: _t("Compute the Spearman rank correlation coefficient of a dataset."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataX, dataY) {
            const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
            assertNonEmpty(flatDataX, flatDataY);
            const n = flatDataX.length;
            const order = flatDataX.map((e, i) => [e, flatDataY[i]]);
            order.sort((a, b) => a[0] - b[0]);
            for (let i = 0; i < n; ++i) {
                order[i][0] = i;
            }
            order.sort((a, b) => a[1] - b[1]);
            let sum = 0.0;
            for (let i = 0; i < n; ++i) {
                sum += (order[i][0] - i) ** 2;
            }
            return 1 - (6 * sum) / (n ** 3 - n);
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // STDEV
    // -----------------------------------------------------------------------------
    const STDEV = {
        description: _t("Standard deviation."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return Math.sqrt(VAR.compute.bind(this)(...values));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // STDEV.P
    // -----------------------------------------------------------------------------
    const STDEV_P = {
        description: _t("Standard deviation of entire population."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return Math.sqrt(VAR_P.compute.bind(this)(...values));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // STDEV.S
    // -----------------------------------------------------------------------------
    const STDEV_S = {
        description: _t("Standard deviation."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return Math.sqrt(VAR_S.compute.bind(this)(...values));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // STDEVA
    // -----------------------------------------------------------------------------
    const STDEVA = {
        description: _t("Standard deviation of sample (text as 0)."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return Math.sqrt(VARA.compute.bind(this)(...values));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // STDEVP
    // -----------------------------------------------------------------------------
    const STDEVP = {
        description: _t("Standard deviation of entire population."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return Math.sqrt(VARP.compute.bind(this)(...values));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // STDEVPA
    // -----------------------------------------------------------------------------
    const STDEVPA = {
        description: _t("Standard deviation of entire population (text as 0)."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return Math.sqrt(VARPA.compute.bind(this)(...values));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // STEYX
    // -----------------------------------------------------------------------------
    const STEYX = {
        description: _t("Calculates the standard error of the predicted y-value for each x in the regression of a dataset."),
        args: [
            arg("data_y (range<number>)", _t("The range representing the array or matrix of dependent data.")),
            arg("data_x (range<number>)", _t("The range representing the array or matrix of independent data.")),
        ],
        returns: ["NUMBER"],
        compute: function (dataY, dataX) {
            const { flatDataX, flatDataY } = filterAndFlatData(dataY, dataX);
            assertNonEmpty(flatDataX, flatDataY);
            const data = fullLinearRegression([flatDataX], [flatDataY], true, true);
            return data[1][2];
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TREND
    // -----------------------------------------------------------------------------
    const TREND = {
        description: _t("Fits points to linear trend derived via least-squares."),
        args: [
            arg("known_data_y (number, range<number>)", _t("The array or range containing dependent (y) values that are already known, used to curve fit an ideal linear trend.")),
            arg("known_data_x (number, range<number>, optional, default={1;2;3;...})", _t("The values of the independent variable(s) corresponding with known_data_y.")),
            arg("new_data_x (number, range<number>, optional, default=known_data_x)", _t("The data points to return the y values for on the ideal curve fit.")),
            arg("b (boolean, optional, default=TRUE)", _t("Given a general linear form of y = m*x+b for a curve fit, calculates b if TRUE or forces b to be 0 and only calculates the m values if FALSE, i.e. forces the curve fit to pass through the origin.")),
        ],
        returns: ["NUMBER"],
        compute: function (knownDataY, knownDataX = [], newDataX = [], b = true) {
            assertNonEmptyMatrix(knownDataY, "known_data_y");
            return predictLinearValues(tryCastAsNumberMatrix(knownDataY, "known_data_y"), tryCastAsNumberMatrix(knownDataX, "known_data_x"), tryCastAsNumberMatrix(newDataX, "new_data_y"), toBoolean(b));
        },
    };
    // -----------------------------------------------------------------------------
    // VAR
    // -----------------------------------------------------------------------------
    const VAR = {
        description: _t("Variance."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return variance(values, true, false, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VAR.P
    // -----------------------------------------------------------------------------
    const VAR_P = {
        description: _t("Variance of entire population."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return variance(values, false, false, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VAR.S
    // -----------------------------------------------------------------------------
    const VAR_S = {
        description: _t("Variance."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return variance(values, true, false, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VARA
    // -----------------------------------------------------------------------------
    const VARA = {
        description: _t("Variance of sample (text as 0)."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the sample.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the sample.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return variance(values, true, true, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VARP
    // -----------------------------------------------------------------------------
    const VARP = {
        description: _t("Variance of entire population."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return variance(values, false, false, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VARPA
    // -----------------------------------------------------------------------------
    const VARPA = {
        description: _t("Variance of entire population (text as 0)."),
        args: [
            arg("value1 (number, range<number>)", _t("The first value or range of the population.")),
            arg("value2 (number, range<number>, repeating)", _t("Additional values or ranges to include in the population.")),
        ],
        returns: ["NUMBER"],
        compute: function (...values) {
            return variance(values, false, true, this.locale);
        },
        isExported: true,
    };

    var statistical = /*#__PURE__*/Object.freeze({
        __proto__: null,
        AVEDEV: AVEDEV,
        AVERAGE: AVERAGE,
        AVERAGEA: AVERAGEA,
        AVERAGEIF: AVERAGEIF,
        AVERAGEIFS: AVERAGEIFS,
        AVERAGE_WEIGHTED: AVERAGE_WEIGHTED,
        CORREL: CORREL,
        COUNT: COUNT,
        COUNTA: COUNTA,
        COVAR: COVAR,
        COVARIANCE_P: COVARIANCE_P,
        COVARIANCE_S: COVARIANCE_S,
        FORECAST: FORECAST,
        GROWTH: GROWTH,
        INTERCEPT: INTERCEPT,
        LARGE: LARGE,
        LINEST: LINEST,
        LOGEST: LOGEST,
        MATTHEWS: MATTHEWS,
        MAX: MAX,
        MAXA: MAXA,
        MAXIFS: MAXIFS,
        MEDIAN: MEDIAN,
        MIN: MIN,
        MINA: MINA,
        MINIFS: MINIFS,
        PEARSON: PEARSON,
        PERCENTILE: PERCENTILE,
        PERCENTILE_EXC: PERCENTILE_EXC,
        PERCENTILE_INC: PERCENTILE_INC,
        POLYFIT_COEFFS: POLYFIT_COEFFS,
        POLYFIT_FORECAST: POLYFIT_FORECAST,
        QUARTILE: QUARTILE,
        QUARTILE_EXC: QUARTILE_EXC,
        QUARTILE_INC: QUARTILE_INC,
        RANK: RANK,
        RSQ: RSQ,
        SLOPE: SLOPE,
        SMALL: SMALL,
        SPEARMAN: SPEARMAN,
        STDEV: STDEV,
        STDEVA: STDEVA,
        STDEVP: STDEVP,
        STDEVPA: STDEVPA,
        STDEV_P: STDEV_P,
        STDEV_S: STDEV_S,
        STEYX: STEYX,
        TREND: TREND,
        VAR: VAR,
        VARA: VARA,
        VARP: VARP,
        VARPA: VARPA,
        VAR_P: VAR_P,
        VAR_S: VAR_S
    });

    function getMatchingCells(database, field, criteria, locale) {
        // Example
        // # DATABASE             # CRITERIA          # field = "C"
        //
        // | A | B | C |          | A | C |
        // |===========|          |=======|
        // | 1 | x | j |          |<2 | j |
        // | 1 | Z | k |          |   | 7 |
        // | 5 | y | 7 |
        // 1 - Select coordinates of database columns ----------------------------------------------------
        const indexColNameDB = new Map();
        const dimRowDB = database.length;
        for (let indexCol = dimRowDB - 1; indexCol >= 0; indexCol--) {
            indexColNameDB.set(toString(database[indexCol][0]).toUpperCase(), indexCol);
        }
        // Example continuation: indexColNameDB = {"A" => 0, "B" => 1, "C" => 2}
        // 2 - Check if the field parameter exists in the column names of the database -------------------
        // field may either be a text label corresponding to a column header in the
        // first row of database or a numeric index indicating which column to consider,
        // where the first column has the value 1.
        if (typeof field !== "number" && typeof field !== "string") {
            throw new Error(_t("The field must be a number or a string"));
        }
        let index;
        if (typeof field === "number") {
            index = Math.trunc(field) - 1;
            if (index < 0 || dimRowDB - 1 < index) {
                throw new Error(_t("The field (%s) must be one of %s or must be a number between 1 and %s inclusive.", field.toString(), dimRowDB.toString()));
            }
        }
        else {
            const colName = toString(field).toUpperCase();
            index = indexColNameDB.get(colName) ?? -1;
            if (index === -1) {
                throw new Error(_t("The field (%s) must be one of %s.", toString(field), [...indexColNameDB.keys()].toString()));
            }
        }
        // Example continuation: index = 2
        // 3 - For each criteria row, find database row that correspond ----------------------------------
        const dimColCriteria = criteria[0].length;
        if (dimColCriteria < 2) {
            throw new Error(_t("The criteria range contains %s row, it must be at least 2 rows.", dimColCriteria.toString()));
        }
        let matchingRows = new Set();
        const dimColDB = database[0].length;
        for (let indexRow = 1; indexRow < dimColCriteria; indexRow++) {
            let args = [];
            let existColNameDB = true;
            for (let indexCol = 0; indexCol < criteria.length; indexCol++) {
                const currentName = toString(criteria[indexCol][0]).toUpperCase();
                const indexColDB = indexColNameDB.get(currentName);
                const criter = criteria[indexCol][indexRow];
                if (criter !== null) {
                    if (indexColDB !== undefined) {
                        args.push([database[indexColDB].slice(1, dimColDB)]);
                        args.push(criter);
                    }
                    else {
                        existColNameDB = false;
                        break;
                    }
                }
            }
            // Example continuation: args1 = [[1,1,5], "<2", ["j","k",7], "j"]
            // Example continuation: args2 = [["j","k",7], "7"]
            if (existColNameDB) {
                if (args.length > 0) {
                    visitMatchingRanges(args, (i, j) => {
                        matchingRows.add(j);
                    }, locale, true);
                }
                else {
                    // return indices of each database row when a criteria table row is void
                    matchingRows = new Set(Array(dimColDB - 1).keys());
                    break;
                }
            }
        }
        // Example continuation: matchingRows = {0, 2}
        // 4 - return for each database row corresponding, the cells corresponding to the field parameter
        const fieldCol = database[index];
        // Example continuation:: fieldCol = ["C", "j", "k", 7]
        const matchingCells = [...matchingRows].map((x) => fieldCol[x + 1]);
        // Example continuation:: matchingCells = ["j", 7]
        return matchingCells;
    }
    const databaseArgs = [
        arg("database (range)", _t("The array or range containing the data to consider, structured in such a way that the first row contains the labels for each column's values.")),
        arg("field (any)", _t("Indicates which column in database contains the values to be extracted and operated on.")),
        arg("criteria (range)", _t("An array or range containing zero or more criteria to filter the database values by before operating.")),
    ];
    // -----------------------------------------------------------------------------
    // DAVERAGE
    // -----------------------------------------------------------------------------
    const DAVERAGE = {
        description: _t("Average of a set of values from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return AVERAGE.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DCOUNT
    // -----------------------------------------------------------------------------
    const DCOUNT = {
        description: _t("Counts values from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return COUNT.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DCOUNTA
    // -----------------------------------------------------------------------------
    const DCOUNTA = {
        description: _t("Counts values and text from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return COUNTA.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DGET
    // -----------------------------------------------------------------------------
    const DGET = {
        description: _t("Single value from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            assert(() => cells.length === 1, _t("More than one match found in DGET evaluation."));
            return cells[0];
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DMAX
    // -----------------------------------------------------------------------------
    const DMAX = {
        description: _t("Maximum of values from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return MAX.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DMIN
    // -----------------------------------------------------------------------------
    const DMIN = {
        description: _t("Minimum of values from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return MIN.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DPRODUCT
    // -----------------------------------------------------------------------------
    const DPRODUCT = {
        description: _t("Product of values from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return PRODUCT.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DSTDEV
    // -----------------------------------------------------------------------------
    const DSTDEV = {
        description: _t("Standard deviation of population sample from table."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return STDEV.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DSTDEVP
    // -----------------------------------------------------------------------------
    const DSTDEVP = {
        description: _t("Standard deviation of entire population from table."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return STDEVP.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DSUM
    // -----------------------------------------------------------------------------
    const DSUM = {
        description: _t("Sum of values from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return SUM.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DVAR
    // -----------------------------------------------------------------------------
    const DVAR = {
        description: _t("Variance of population sample from table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return VAR.compute.bind(this)([cells]);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DVARP
    // -----------------------------------------------------------------------------
    const DVARP = {
        description: _t("Variance of a population from a table-like range."),
        args: databaseArgs,
        returns: ["NUMBER"],
        compute: function (database, field, criteria) {
            const cells = getMatchingCells(database, field, criteria, this.locale);
            return VARP.compute.bind(this)([cells]);
        },
        isExported: true,
    };

    var database = /*#__PURE__*/Object.freeze({
        __proto__: null,
        DAVERAGE: DAVERAGE,
        DCOUNT: DCOUNT,
        DCOUNTA: DCOUNTA,
        DGET: DGET,
        DMAX: DMAX,
        DMIN: DMIN,
        DPRODUCT: DPRODUCT,
        DSTDEV: DSTDEV,
        DSTDEVP: DSTDEVP,
        DSUM: DSUM,
        DVAR: DVAR,
        DVARP: DVARP
    });

    const DEFAULT_TYPE = 1;
    const DEFAULT_WEEKEND = 1;
    var TIME_UNIT;
    (function (TIME_UNIT) {
        TIME_UNIT["WHOLE_YEARS"] = "Y";
        TIME_UNIT["WHOLE_MONTHS"] = "M";
        TIME_UNIT["WHOLE_DAYS"] = "D";
        TIME_UNIT["DAYS_WITHOUT_WHOLE_MONTHS"] = "MD";
        TIME_UNIT["MONTH_WITHOUT_WHOLE_YEARS"] = "YM";
        TIME_UNIT["DAYS_BETWEEN_NO_MORE_THAN_ONE_YEAR"] = "YD";
    })(TIME_UNIT || (TIME_UNIT = {}));
    // -----------------------------------------------------------------------------
    // DATE
    // -----------------------------------------------------------------------------
    const DATE = {
        description: _t("Converts year/month/day into a date."),
        args: [
            arg("year (number)", _t("The year component of the date.")),
            arg("month (number)", _t("The month component of the date.")),
            arg("day (number)", _t("The day component of the date.")),
        ],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (year, month, day) {
            let _year = Math.trunc(toNumber(year, this.locale));
            const _month = Math.trunc(toNumber(month, this.locale));
            const _day = Math.trunc(toNumber(day, this.locale));
            // For years less than 0 or greater than 10000, return #ERROR.
            assert(() => 0 <= _year && _year <= 9999, _t("The year (%s) must be between 0 and 9999 inclusive.", _year.toString()));
            // Between 0 and 1899, we add that value to 1900 to calculate the year
            if (_year < 1900) {
                _year += 1900;
            }
            const jsDate = new DateTime(_year, _month - 1, _day);
            const result = jsDateToRoundNumber(jsDate);
            assert(() => result >= 0, _t("The function [[FUNCTION_NAME]] result must be greater than or equal 01/01/1900."));
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DATEDIF
    // -----------------------------------------------------------------------------
    const DATEDIF = {
        description: _t("Calculates the number of days, months, or years between two dates."),
        args: [
            arg("start_date (date)", _t("The start date to consider in the calculation. Must be a reference to a cell containing a DATE, a function returning a DATE type, or a number.")),
            arg("end_date (date)", _t("The end date to consider in the calculation. Must be a reference to a cell containing a DATE, a function returning a DATE type, or a number.")),
            arg("unit (string)", _t('A text abbreviation for unit of time. Accepted values are "Y" (the number of whole years between start_date and end_date), "M" (the number of whole months between start_date and end_date), "D" (the number of days between start_date and end_date), "MD" (the number of days between start_date and end_date after subtracting whole months), "YM" (the number of whole months between start_date and end_date after subtracting whole years), "YD" (the number of days between start_date and end_date, assuming start_date and end_date were no more than one year apart).')),
        ],
        returns: ["NUMBER"],
        compute: function (startDate, endDate, unit) {
            const _unit = toString(unit).toUpperCase();
            assert(() => Object.values(TIME_UNIT).includes(_unit), expectStringSetError(Object.values(TIME_UNIT), toString(unit)));
            const _startDate = Math.trunc(toNumber(startDate, this.locale));
            const _endDate = Math.trunc(toNumber(endDate, this.locale));
            const jsStartDate = numberToJsDate(_startDate);
            const jsEndDate = numberToJsDate(_endDate);
            assert(() => _endDate >= _startDate, _t("start_date (%s) should be on or before end_date (%s).", jsStartDate.toLocaleDateString(), jsEndDate.toLocaleDateString()));
            switch (_unit) {
                case TIME_UNIT.WHOLE_YEARS:
                    return getTimeDifferenceInWholeYears(jsStartDate, jsEndDate);
                case TIME_UNIT.WHOLE_MONTHS:
                    return getTimeDifferenceInWholeMonths(jsStartDate, jsEndDate);
                case TIME_UNIT.WHOLE_DAYS: {
                    return getTimeDifferenceInWholeDays(jsStartDate, jsEndDate);
                }
                case TIME_UNIT.MONTH_WITHOUT_WHOLE_YEARS: {
                    return (getTimeDifferenceInWholeMonths(jsStartDate, jsEndDate) -
                        getTimeDifferenceInWholeYears(jsStartDate, jsEndDate) * 12);
                }
                case TIME_UNIT.DAYS_WITHOUT_WHOLE_MONTHS:
                    // Using "MD" may get incorrect result in Excel
                    // See: https://support.microsoft.com/en-us/office/datedif-function-25dba1a4-2812-480b-84dd-8b32a451b35c
                    let days = jsEndDate.getDate() - jsStartDate.getDate();
                    if (days < 0) {
                        const monthBeforeEndMonth = new DateTime(jsEndDate.getFullYear(), jsEndDate.getMonth() - 1, 1);
                        const daysInMonthBeforeEndMonth = getDaysInMonth(monthBeforeEndMonth);
                        days = daysInMonthBeforeEndMonth - Math.abs(days);
                    }
                    return days;
                case TIME_UNIT.DAYS_BETWEEN_NO_MORE_THAN_ONE_YEAR: {
                    if (areTwoDatesWithinOneYear(_startDate, _endDate)) {
                        return getTimeDifferenceInWholeDays(jsStartDate, jsEndDate);
                    }
                    const endDateWithinOneYear = new DateTime(jsStartDate.getFullYear(), jsEndDate.getMonth(), jsEndDate.getDate());
                    let days = getTimeDifferenceInWholeDays(jsStartDate, endDateWithinOneYear);
                    if (days < 0) {
                        endDateWithinOneYear.setFullYear(jsStartDate.getFullYear() + 1);
                        days = getTimeDifferenceInWholeDays(jsStartDate, endDateWithinOneYear);
                    }
                    return days;
                }
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DATEVALUE
    // -----------------------------------------------------------------------------
    const DATEVALUE = {
        description: _t("Converts a date string to a date value."),
        args: [arg("date_string (string)", _t("The string representing the date."))],
        returns: ["NUMBER"],
        compute: function (dateString) {
            const _dateString = toString(dateString);
            const internalDate = parseDateTime(_dateString, this.locale);
            assert(() => internalDate !== null, _t("The date_string (%s) cannot be parsed to date/time.", _dateString.toString()));
            return Math.trunc(internalDate.value);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DAY
    // -----------------------------------------------------------------------------
    const DAY = {
        description: _t("Day of the month that a specific date falls on."),
        args: [arg("date (string)", _t("The date from which to extract the day."))],
        returns: ["NUMBER"],
        compute: function (date) {
            return toJsDate(date, this.locale).getDate();
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DAYS
    // -----------------------------------------------------------------------------
    const DAYS = {
        description: _t("Number of days between two dates."),
        args: [
            arg("end_date (date)", _t("The end of the date range.")),
            arg("start_date (date)", _t("The start of the date range.")),
        ],
        returns: ["NUMBER"],
        compute: function (endDate, startDate) {
            const _endDate = toJsDate(endDate, this.locale);
            const _startDate = toJsDate(startDate, this.locale);
            const dateDif = _endDate.getTime() - _startDate.getTime();
            return Math.round(dateDif / MS_PER_DAY);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DAYS360
    // -----------------------------------------------------------------------------
    const DEFAULT_DAY_COUNT_METHOD = 0;
    const DAYS360 = {
        description: _t("Number of days between two dates on a 360-day year (months of 30 days)."),
        args: [
            arg("start_date (date)", _t("The start date to consider in the calculation.")),
            arg("end_date (date)", _t("The end date to consider in the calculation.")),
            arg(`method (number, default=${DEFAULT_DAY_COUNT_METHOD})`, _t("An indicator of what day count method to use. (0) US NASD method (1) European method")),
        ],
        returns: ["NUMBER"],
        compute: function (startDate, endDate, method = DEFAULT_DAY_COUNT_METHOD) {
            const _startDate = toNumber(startDate, this.locale);
            const _endDate = toNumber(endDate, this.locale);
            const dayCountConvention = toBoolean(method) ? 4 : 0;
            const yearFrac = YEARFRAC.compute.bind(this)(startDate, endDate, dayCountConvention);
            return Math.sign(_endDate - _startDate) * Math.round(yearFrac * 360);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // EDATE
    // -----------------------------------------------------------------------------
    const EDATE = {
        description: _t("Date a number of months before/after another date."),
        args: [
            arg("start_date (date)", _t("The date from which to calculate the result.")),
            arg("months (number)", _t("The number of months before (negative) or after (positive) 'start_date' to calculate.")),
        ],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (startDate, months) {
            const _startDate = toJsDate(startDate, this.locale);
            const _months = Math.trunc(toNumber(months, this.locale));
            const jsDate = addMonthsToDate(_startDate, _months, false);
            return jsDateToRoundNumber(jsDate);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // EOMONTH
    // -----------------------------------------------------------------------------
    const EOMONTH = {
        description: _t("Last day of a month before or after a date."),
        args: [
            arg("start_date (date)", _t("The date from which to calculate the result.")),
            arg("months (number)", _t("The number of months before (negative) or after (positive) 'start_date' to consider.")),
        ],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (startDate, months) {
            const _startDate = toJsDate(startDate, this.locale);
            const _months = Math.trunc(toNumber(months, this.locale));
            const yStart = _startDate.getFullYear();
            const mStart = _startDate.getMonth();
            const jsDate = new DateTime(yStart, mStart + _months + 1, 0);
            return jsDateToRoundNumber(jsDate);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // HOUR
    // -----------------------------------------------------------------------------
    const HOUR = {
        description: _t("Hour component of a specific time."),
        args: [arg("time (date)", _t("The time from which to calculate the hour component."))],
        returns: ["NUMBER"],
        compute: function (date) {
            return toJsDate(date, this.locale).getHours();
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISOWEEKNUM
    // -----------------------------------------------------------------------------
    const ISOWEEKNUM = {
        description: _t("ISO week number of the year."),
        args: [
            arg("date (date)", _t("The date for which to determine the ISO week number. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
        ],
        returns: ["NUMBER"],
        compute: function (date) {
            const _date = toJsDate(date, this.locale);
            const y = _date.getFullYear();
            // 1 - As the 1st week of a year can start the previous year or after the 1st
            // january we first look if the date is in the weeks of the current year, previous
            // year or year after.
            // A - We look for the current year, the first days of the first week
            // and the last days of the last week
            // The first week of the year is the week that contains the first
            // Thursday of the year.
            let firstThursday = 1;
            while (new DateTime(y, 0, firstThursday).getDay() !== 4) {
                firstThursday += 1;
            }
            const firstDayOfFirstWeek = new DateTime(y, 0, firstThursday - 3);
            // The last week of the year is the week that contains the last Thursday of
            // the year.
            let lastThursday = 31;
            while (new DateTime(y, 11, lastThursday).getDay() !== 4) {
                lastThursday -= 1;
            }
            const lastDayOfLastWeek = new DateTime(y, 11, lastThursday + 3);
            // B - If our date > lastDayOfLastWeek then it's in the weeks of the year after
            // If our date < firstDayOfFirstWeek then it's in the weeks of the year before
            let offsetYear;
            if (firstDayOfFirstWeek.getTime() <= _date.getTime()) {
                if (_date.getTime() <= lastDayOfLastWeek.getTime()) {
                    offsetYear = 0;
                }
                else {
                    offsetYear = 1;
                }
            }
            else {
                offsetYear = -1;
            }
            // 2 - now that the year is known, we are looking at the difference between
            // the first day of this year and the date. The difference in days divided by
            // 7 gives us the week number
            let firstDay;
            switch (offsetYear) {
                case 0:
                    firstDay = firstDayOfFirstWeek;
                    break;
                case 1:
                    // firstDay is the 1st day of the 1st week of the year after
                    // firstDay = lastDayOfLastWeek + 1 Day
                    firstDay = new DateTime(y, 11, lastThursday + 3 + 1);
                    break;
                case -1:
                    // firstDay is the 1st day of the 1st week of the previous year.
                    // The first week of the previous year is the week that contains the
                    // first Thursday of the previous year.
                    let firstThursdayPreviousYear = 1;
                    while (new DateTime(y - 1, 0, firstThursdayPreviousYear).getDay() !== 4) {
                        firstThursdayPreviousYear += 1;
                    }
                    firstDay = new DateTime(y - 1, 0, firstThursdayPreviousYear - 3);
                    break;
            }
            const diff = (_date.getTime() - firstDay.getTime()) / MS_PER_DAY;
            return Math.floor(diff / 7) + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MINUTE
    // -----------------------------------------------------------------------------
    const MINUTE = {
        description: _t("Minute component of a specific time."),
        args: [arg("time (date)", _t("The time from which to calculate the minute component."))],
        returns: ["NUMBER"],
        compute: function (date) {
            return toJsDate(date, this.locale).getMinutes();
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MONTH
    // -----------------------------------------------------------------------------
    const MONTH = {
        description: _t("Month of the year a specific date falls in"),
        args: [arg("date (date)", _t("The date from which to extract the month."))],
        returns: ["NUMBER"],
        compute: function (date) {
            return toJsDate(date, this.locale).getMonth() + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // NETWORKDAYS
    // -----------------------------------------------------------------------------
    const NETWORKDAYS = {
        description: _t("Net working days between two provided days."),
        args: [
            arg("start_date (date)", _t("The start date of the period from which to calculate the number of net working days.")),
            arg("end_date (date)", _t("The end date of the period from which to calculate the number of net working days.")),
            arg("holidays (date, range<date>, optional)", _t("A range or array constant containing the date serial numbers to consider holidays.")),
        ],
        returns: ["NUMBER"],
        compute: function (startDate, endDate, holidays) {
            return NETWORKDAYS_INTL.compute.bind(this)(startDate, endDate, 1, holidays);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // NETWORKDAYS.INTL
    // -----------------------------------------------------------------------------
    /**
     * Transform weekend Spreadsheet information into Date Day JavaScript information.
     * Take string (String method) or number (Number method), return array of numbers.
     *
     * String method: weekends can be specified using seven 0’s and 1’s, where the
     * first number in the set represents Monday and the last number is for Sunday.
     * A zero means that the day is a work day, a 1 means that the day is a weekend.
     * For example, “0000011” would mean Saturday and Sunday are weekends.
     *
     * Number method: instead of using the string method above, a single number can
     * be used. 1 = Saturday/Sunday are weekends, 2 = Sunday/Monday, and this pattern
     * repeats until 7 = Friday/Saturday. 11 = Sunday is the only weekend, 12 = Monday
     * is the only weekend, and this pattern repeats until 17 = Saturday is the only
     * weekend.
     *
     * Example:
     * - 11 return [0] (correspond to Sunday)
     * - 12 return [1] (correspond to Monday)
     * - 3 return [1,2] (correspond to Monday and Tuesday)
     * - "0101010" return [2,4,6] (correspond to Tuesday, Thursday and Saturday)
     */
    function weekendToDayNumber(weekend) {
        // case "string"
        if (typeof weekend === "string") {
            assert(() => {
                if (weekend.length !== 7) {
                    return false;
                }
                for (let day of weekend) {
                    if (day !== "0" && day !== "1") {
                        return false;
                    }
                }
                return true;
            }, _t('When weekend is a string (%s) it must be composed of "0" or "1".', weekend));
            let result = [];
            for (let i = 0; i < 7; i++) {
                if (weekend[i] === "1") {
                    result.push((i + 1) % 7);
                }
            }
            return result;
        }
        //case "number"
        if (typeof weekend === "number") {
            assert(() => (1 <= weekend && weekend <= 7) || (11 <= weekend && weekend <= 17), _t("The weekend (%s) must be a string or a number in the range 1-7 or 11-17.", weekend.toString()));
            // case 1 <= weekend <= 7
            if (weekend <= 7) {
                // 1 = Saturday/Sunday are weekends
                // 2 = Sunday/Monday
                // ...
                // 7 = Friday/Saturday.
                return [weekend - 2 === -1 ? 6 : weekend - 2, weekend - 1];
            }
            // case 11 <= weekend <= 17
            // 11 = Sunday is the only weekend
            // 12 = Monday is the only weekend
            // ...
            // 17 = Saturday is the only weekend.
            return [weekend - 11];
        }
        throw Error(_t("The weekend must be a number or a string."));
    }
    const NETWORKDAYS_INTL = {
        description: _t("Net working days between two dates (specifying weekends)."),
        args: [
            arg("start_date (date)", _t("The start date of the period from which to calculate the number of net working days.")),
            arg("end_date (date)", _t("The end date of the period from which to calculate the number of net working days.")),
            arg(`weekend (any, default=${DEFAULT_WEEKEND})`, _t("A number or string representing which days of the week are considered weekends.")),
            arg("holidays (date, range<date>, optional)", _t("A range or array constant containing the dates to consider as holidays.")),
        ],
        returns: ["NUMBER"],
        compute: function (startDate, endDate, weekend = DEFAULT_WEEKEND, holidays) {
            const _startDate = toJsDate(startDate, this.locale);
            const _endDate = toJsDate(endDate, this.locale);
            const daysWeekend = weekendToDayNumber(weekend);
            let timesHoliday = new Set();
            if (holidays !== undefined) {
                visitAny([holidays], (h) => {
                    const holiday = toJsDate(h, this.locale);
                    timesHoliday.add(holiday.getTime());
                });
            }
            const invertDate = _startDate.getTime() > _endDate.getTime();
            const stopDate = DateTime.fromTimestamp((invertDate ? _startDate : _endDate).getTime());
            let stepDate = DateTime.fromTimestamp((invertDate ? _endDate : _startDate).getTime());
            const timeStopDate = stopDate.getTime();
            let timeStepDate = stepDate.getTime();
            let netWorkingDay = 0;
            while (timeStepDate <= timeStopDate) {
                if (!daysWeekend.includes(stepDate.getDay()) && !timesHoliday.has(timeStepDate)) {
                    netWorkingDay += 1;
                }
                stepDate.setDate(stepDate.getDate() + 1);
                timeStepDate = stepDate.getTime();
            }
            return invertDate ? -netWorkingDay : netWorkingDay;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // NOW
    // -----------------------------------------------------------------------------
    const NOW = {
        description: _t("Current date and time as a date value."),
        args: [],
        returns: ["DATE"],
        computeFormat: function () {
            return getDateTimeFormat(this.locale);
        },
        compute: function () {
            let today = DateTime.now();
            const delta = today.getTime() - INITIAL_1900_DAY.getTime();
            const time = today.getHours() / 24 + today.getMinutes() / 1440 + today.getSeconds() / 86400;
            return Math.floor(delta / MS_PER_DAY) + time;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SECOND
    // -----------------------------------------------------------------------------
    const SECOND = {
        description: _t("Minute component of a specific time."),
        args: [arg("time (date)", _t("The time from which to calculate the second component."))],
        returns: ["NUMBER"],
        compute: function (date) {
            return toJsDate(date, this.locale).getSeconds();
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TIME
    // -----------------------------------------------------------------------------
    const TIME = {
        description: _t("Converts hour/minute/second into a time."),
        args: [
            arg("hour (number)", _t("The hour component of the time.")),
            arg("minute (number)", _t("The minute component of the time.")),
            arg("second (number)", _t("The second component of the time.")),
        ],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.timeFormat;
        },
        compute: function (hour, minute, second) {
            let _hour = Math.trunc(toNumber(hour, this.locale));
            let _minute = Math.trunc(toNumber(minute, this.locale));
            let _second = Math.trunc(toNumber(second, this.locale));
            _minute += Math.floor(_second / 60);
            _second = (_second % 60) + (_second < 0 ? 60 : 0);
            _hour += Math.floor(_minute / 60);
            _minute = (_minute % 60) + (_minute < 0 ? 60 : 0);
            _hour %= 24;
            assert(() => _hour >= 0, _t("The function [[FUNCTION_NAME]] result cannot be negative"));
            return _hour / 24 + _minute / (24 * 60) + _second / (24 * 60 * 60);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TIMEVALUE
    // -----------------------------------------------------------------------------
    const TIMEVALUE = {
        description: _t("Converts a time string into its serial number representation."),
        args: [arg("time_string (string)", _t("The string that holds the time representation."))],
        returns: ["NUMBER"],
        compute: function (timeString) {
            const _timeString = toString(timeString);
            const internalDate = parseDateTime(_timeString, this.locale);
            assert(() => internalDate !== null, _t("The time_string (%s) cannot be parsed to date/time.", _timeString));
            const result = internalDate.value - Math.trunc(internalDate.value);
            return result < 0 ? 1 + result : result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TODAY
    // -----------------------------------------------------------------------------
    const TODAY = {
        description: _t("Current date as a date value."),
        args: [],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function () {
            const today = DateTime.now();
            const jsDate = new DateTime(today.getFullYear(), today.getMonth(), today.getDate());
            return jsDateToRoundNumber(jsDate);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // WEEKDAY
    // -----------------------------------------------------------------------------
    const WEEKDAY = {
        description: _t("Day of the week of the date provided (as number)."),
        args: [
            arg("date (date)", _t("The date for which to determine the day of the week. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
            arg(`type (number, default=${DEFAULT_TYPE})`, _t("A number indicating which numbering system to use to represent weekdays. By default, counts starting with Sunday = 1.")),
        ],
        returns: ["NUMBER"],
        compute: function (date, type = DEFAULT_TYPE) {
            const _date = toJsDate(date, this.locale);
            const _type = Math.round(toNumber(type, this.locale));
            const m = _date.getDay();
            assert(() => [1, 2, 3].includes(_type), _t("The type (%s) must be 1, 2 or 3.", _type.toString()));
            if (_type === 1)
                return m + 1;
            if (_type === 2)
                return m === 0 ? 7 : m;
            return m === 0 ? 6 : m - 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // WEEKNUM
    // -----------------------------------------------------------------------------
    const WEEKNUM = {
        description: _t("Week number of the year."),
        args: [
            arg("date (date)", _t("The date for which to determine the week number. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
            arg(`type (number, default=${DEFAULT_TYPE})`, _t("A number representing the day that a week starts on. Sunday = 1.")),
        ],
        returns: ["NUMBER"],
        compute: function (date, type = DEFAULT_TYPE) {
            const _date = toJsDate(date, this.locale);
            const _type = Math.round(toNumber(type, this.locale));
            assert(() => _type === 1 || _type === 2 || (11 <= _type && _type <= 17) || _type === 21, _t("The type (%s) is out of range.", _type.toString()));
            if (_type === 21) {
                return ISOWEEKNUM.compute.bind(this)(date);
            }
            let startDayOfWeek;
            if (_type === 1 || _type === 2) {
                startDayOfWeek = _type - 1;
            }
            else {
                // case 11 <= _type <= 17
                startDayOfWeek = _type - 10 === 7 ? 0 : _type - 10;
            }
            const y = _date.getFullYear();
            let dayStart = 1;
            let startDayOfFirstWeek = new DateTime(y, 0, dayStart);
            while (startDayOfFirstWeek.getDay() !== startDayOfWeek) {
                dayStart += 1;
                startDayOfFirstWeek = new DateTime(y, 0, dayStart);
            }
            const dif = (_date.getTime() - startDayOfFirstWeek.getTime()) / MS_PER_DAY;
            if (dif < 0) {
                return 1;
            }
            return Math.floor(dif / 7) + (dayStart === 1 ? 1 : 2);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // WORKDAY
    // -----------------------------------------------------------------------------
    const WORKDAY = {
        description: _t("Date after a number of workdays."),
        args: [
            arg("start_date (date)", _t("The date from which to begin counting.")),
            arg("num_days (number)", _t("The number of working days to advance from start_date. If negative, counts backwards.")),
            arg("holidays (date, range<date>, optional)", _t("A range or array constant containing the dates to consider holidays.")),
        ],
        returns: ["NUMBER"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (startDate, numDays, holidays = undefined) {
            return WORKDAY_INTL.compute.bind(this)(startDate, numDays, 1, holidays ?? null);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // WORKDAY.INTL
    // -----------------------------------------------------------------------------
    const WORKDAY_INTL = {
        description: _t("Date after a number of workdays (specifying weekends)."),
        args: [
            arg("start_date (date)", _t("The date from which to begin counting.")),
            arg("num_days (number)", _t("The number of working days to advance from start_date. If negative, counts backwards.")),
            arg(`weekend (any, default=${DEFAULT_WEEKEND})`, _t("A number or string representing which days of the week are considered weekends.")),
            arg("holidays (date, range<date>, optional)", _t("A range or array constant containing the dates to consider holidays.")),
        ],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (startDate, numDays, weekend = DEFAULT_WEEKEND, holidays) {
            let _startDate = toJsDate(startDate, this.locale);
            let _numDays = Math.trunc(toNumber(numDays, this.locale));
            if (typeof weekend === "string") {
                assert(() => weekend !== "1111111", _t("The weekend (%s) must be different from '1111111'.", weekend));
            }
            const daysWeekend = weekendToDayNumber(weekend);
            let timesHoliday = new Set();
            if (holidays !== undefined) {
                visitAny([holidays], (h) => {
                    const holiday = toJsDate(h, this.locale);
                    timesHoliday.add(holiday.getTime());
                });
            }
            let stepDate = DateTime.fromTimestamp(_startDate.getTime());
            let timeStepDate = stepDate.getTime();
            const unitDay = Math.sign(_numDays);
            let stepDay = Math.abs(_numDays);
            while (stepDay > 0) {
                stepDate.setDate(stepDate.getDate() + unitDay);
                timeStepDate = stepDate.getTime();
                if (!daysWeekend.includes(stepDate.getDay()) && !timesHoliday.has(timeStepDate)) {
                    stepDay -= 1;
                }
            }
            const delta = timeStepDate - INITIAL_1900_DAY.getTime();
            return Math.round(delta / MS_PER_DAY);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // YEAR
    // -----------------------------------------------------------------------------
    const YEAR = {
        description: _t("Year specified by a given date."),
        args: [arg("date (date)", _t("The date from which to extract the year."))],
        returns: ["NUMBER"],
        compute: function (date) {
            return toJsDate(date, this.locale).getFullYear();
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // YEARFRAC
    // -----------------------------------------------------------------------------
    const DEFAULT_DAY_COUNT_CONVENTION$1 = 0;
    const YEARFRAC = {
        description: _t("Exact number of years between two dates."),
        args: [
            arg("start_date (date)", _t("The start date to consider in the calculation. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
            arg("end_date (date)", _t("The end date to consider in the calculation. Must be a reference to a cell containing a date, a function returning a date type, or a number.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION$1})`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (startDate, endDate, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION$1) {
            let _startDate = Math.trunc(toNumber(startDate, this.locale));
            let _endDate = Math.trunc(toNumber(endDate, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assert(() => _startDate >= 0, _t("The start_date (%s) must be positive or null.", _startDate.toString()));
            assert(() => _endDate >= 0, _t("The end_date (%s) must be positive or null.", _endDate.toString()));
            assert(() => 0 <= _dayCountConvention && _dayCountConvention <= 4, _t("The day_count_convention (%s) must be between 0 and 4 inclusive.", _dayCountConvention.toString()));
            return getYearFrac(_startDate, _endDate, _dayCountConvention);
        },
    };
    // -----------------------------------------------------------------------------
    // MONTH.START
    // -----------------------------------------------------------------------------
    const MONTH_START = {
        description: _t("First day of the month preceding a date."),
        args: [arg("date (date)", _t("The date from which to calculate the result."))],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (date) {
            const _startDate = toJsDate(date, this.locale);
            const yStart = _startDate.getFullYear();
            const mStart = _startDate.getMonth();
            const jsDate = new DateTime(yStart, mStart, 1);
            return jsDateToRoundNumber(jsDate);
        },
    };
    // -----------------------------------------------------------------------------
    // MONTH.END
    // -----------------------------------------------------------------------------
    const MONTH_END = {
        description: _t("Last day of the month following a date."),
        args: [arg("date (date)", _t("The date from which to calculate the result."))],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (date) {
            return EOMONTH.compute.bind(this)(date, 0);
        },
    };
    // -----------------------------------------------------------------------------
    // QUARTER
    // -----------------------------------------------------------------------------
    const QUARTER = {
        description: _t("Quarter of the year a specific date falls in"),
        args: [arg("date (date)", _t("The date from which to extract the quarter."))],
        returns: ["NUMBER"],
        compute: function (date) {
            return Math.ceil((toJsDate(date, this.locale).getMonth() + 1) / 3);
        },
    };
    // -----------------------------------------------------------------------------
    // QUARTER.START
    // -----------------------------------------------------------------------------
    const QUARTER_START = {
        description: _t("First day of the quarter of the year a specific date falls in."),
        args: [arg("date (date)", _t("The date from which to calculate the start of quarter."))],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (date) {
            const quarter = QUARTER.compute.bind(this)(date);
            const year = YEAR.compute.bind(this)(date);
            const jsDate = new DateTime(year, (quarter - 1) * 3, 1);
            return jsDateToRoundNumber(jsDate);
        },
    };
    // -----------------------------------------------------------------------------
    // QUARTER.END
    // -----------------------------------------------------------------------------
    const QUARTER_END = {
        description: _t("Last day of the quarter of the year a specific date falls in."),
        args: [arg("date (date)", _t("The date from which to calculate the end of quarter."))],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (date) {
            const quarter = QUARTER.compute.bind(this)(date);
            const year = YEAR.compute.bind(this)(date);
            const jsDate = new DateTime(year, quarter * 3, 0);
            return jsDateToRoundNumber(jsDate);
        },
    };
    // -----------------------------------------------------------------------------
    // YEAR.START
    // -----------------------------------------------------------------------------
    const YEAR_START = {
        description: _t("First day of the year a specific date falls in."),
        args: [arg("date (date)", _t("The date from which to calculate the start of the year."))],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (date) {
            const year = YEAR.compute.bind(this)(date);
            const jsDate = new DateTime(year, 0, 1);
            return jsDateToRoundNumber(jsDate);
        },
    };
    // -----------------------------------------------------------------------------
    // YEAR.END
    // -----------------------------------------------------------------------------
    const YEAR_END = {
        description: _t("Last day of the year a specific date falls in."),
        args: [arg("date (date)", _t("The date from which to calculate the end of the year."))],
        returns: ["DATE"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (date) {
            const year = YEAR.compute.bind(this)(date);
            const jsDate = new DateTime(year + 1, 0, 0);
            return jsDateToRoundNumber(jsDate);
        },
    };

    var date = /*#__PURE__*/Object.freeze({
        __proto__: null,
        DATE: DATE,
        DATEDIF: DATEDIF,
        DATEVALUE: DATEVALUE,
        DAY: DAY,
        DAYS: DAYS,
        DAYS360: DAYS360,
        EDATE: EDATE,
        EOMONTH: EOMONTH,
        HOUR: HOUR,
        ISOWEEKNUM: ISOWEEKNUM,
        MINUTE: MINUTE,
        MONTH: MONTH,
        MONTH_END: MONTH_END,
        MONTH_START: MONTH_START,
        NETWORKDAYS: NETWORKDAYS,
        NETWORKDAYS_INTL: NETWORKDAYS_INTL,
        NOW: NOW,
        QUARTER: QUARTER,
        QUARTER_END: QUARTER_END,
        QUARTER_START: QUARTER_START,
        SECOND: SECOND,
        TIME: TIME,
        TIMEVALUE: TIMEVALUE,
        TODAY: TODAY,
        WEEKDAY: WEEKDAY,
        WEEKNUM: WEEKNUM,
        WORKDAY: WORKDAY,
        WORKDAY_INTL: WORKDAY_INTL,
        YEAR: YEAR,
        YEARFRAC: YEARFRAC,
        YEAR_END: YEAR_END,
        YEAR_START: YEAR_START
    });

    const DEFAULT_DELTA_ARG = 0;
    // -----------------------------------------------------------------------------
    // DELTA
    // -----------------------------------------------------------------------------
    const DELTA = {
        description: _t("Compare two numeric values, returning 1 if they're equal."),
        args: [
            arg("number1 (number)", _t("The first number to compare.")),
            arg(`number2 (number, default=${DEFAULT_DELTA_ARG})`, _t("The second number to compare.")),
        ],
        returns: ["NUMBER"],
        compute: function (number1, number2 = DEFAULT_DELTA_ARG) {
            const _number1 = toNumber(number1, this.locale);
            const _number2 = toNumber(number2, this.locale);
            return _number1 === _number2 ? 1 : 0;
        },
        isExported: true,
    };

    var engineering = /*#__PURE__*/Object.freeze({
        __proto__: null,
        DELTA: DELTA
    });

    const SORT_TYPES = [
        CellValueType.number,
        CellValueType.error,
        CellValueType.text,
        CellValueType.boolean,
    ];
    function cellsSortingCriterion(sortingOrder) {
        const inverse = sortingOrder === "ascending" ? 1 : -1;
        return (left, right) => {
            if (left.type === CellValueType.empty) {
                return right.type === CellValueType.empty ? 0 : 1;
            }
            else if (right.type === CellValueType.empty) {
                return -1;
            }
            let typeOrder = SORT_TYPES.indexOf(left.type) - SORT_TYPES.indexOf(right.type);
            if (typeOrder === 0) {
                if (left.type === CellValueType.text || left.type === CellValueType.error) {
                    typeOrder = left.value.localeCompare(right.value);
                }
                else {
                    typeOrder = left.value - right.value;
                }
            }
            return inverse * typeOrder;
        };
    }
    function sortCells(cells, sortDirection, emptyCellAsZero) {
        const cellsWithIndex = cells.map((cell, index) => ({
            index,
            type: cell.type,
            value: cell.value,
        }));
        const cellsToSort = emptyCellAsZero
            ? cellsWithIndex.map((cell) => cell.type === CellValueType.empty ? { ...cell, type: CellValueType.number, value: 0 } : cell)
            : cellsWithIndex;
        return cellsToSort.sort(cellsSortingCriterion(sortDirection));
    }
    function interactiveSortSelection(env, sheetId, anchor, zone, sortDirection) {
        let result = DispatchResult.Success;
        //several columns => bypass the contiguity check
        let multiColumns = zone.right > zone.left;
        if (env.model.getters.doesIntersectMerge(sheetId, zone)) {
            multiColumns = false;
            let table;
            for (let row = zone.top; row <= zone.bottom; row++) {
                table = [];
                for (let col = zone.left; col <= zone.right; col++) {
                    let merge = env.model.getters.getMerge({ sheetId, col, row });
                    if (merge && !table.includes(merge.id.toString())) {
                        table.push(merge.id.toString());
                    }
                }
                if (table.length >= 2) {
                    multiColumns = true;
                    break;
                }
            }
        }
        const { col, row } = anchor;
        if (multiColumns) {
            result = env.model.dispatch("SORT_CELLS", { sheetId, col, row, zone, sortDirection });
        }
        else {
            // check contiguity
            const contiguousZone = env.model.getters.getContiguousZone(sheetId, zone);
            if (isEqual(contiguousZone, zone)) {
                // merge as it is
                result = env.model.dispatch("SORT_CELLS", {
                    sheetId,
                    col,
                    row,
                    zone,
                    sortDirection,
                });
            }
            else {
                env.askConfirmation(_t("We found data next to your selection. Since this data was not selected, it will not be sorted. Do you want to extend your selection?"), () => {
                    zone = contiguousZone;
                    result = env.model.dispatch("SORT_CELLS", {
                        sheetId,
                        col,
                        row,
                        zone,
                        sortDirection,
                    });
                }, () => {
                    result = env.model.dispatch("SORT_CELLS", {
                        sheetId,
                        col,
                        row,
                        zone,
                        sortDirection,
                    });
                });
            }
        }
        if (result.isCancelledBecause("InvalidSortZone" /* CommandResult.InvalidSortZone */)) {
            const { col, row } = anchor;
            env.model.selection.selectZone({ cell: { col, row }, zone });
            env.raiseError(_t("Cannot sort. To sort, select only cells or only merges that have the same size."));
        }
    }

    function sortMatrix(matrix, locale, ...criteria) {
        for (let i = 0; i < criteria.length; i++) {
            const param = i % 2 === 0 ? "sort_column" : "is_ascending";
            assert(() => criteria[i] !== undefined, _t("Value for parameter %s is missing in [[FUNCTION_NAME]].", param));
        }
        const sortingOrders = [];
        const sortColumns = [];
        const nRows = matrix.length;
        for (let i = 0; i < criteria.length; i += 2) {
            sortingOrders.push(toBoolean(toScalar(criteria[i + 1])?.value) ? "ascending" : "descending");
            const sortColumn = criteria[i];
            if (isMatrix(sortColumn) && (sortColumn.length > 1 || sortColumn[0].length > 1)) {
                assert(() => sortColumn.length === 1 && sortColumn[0].length === nRows, _t("Wrong size for %s. Expected a range of size 1x%s. Got %sx%s.", `sort_column${i + 1}`, nRows, sortColumn.length, sortColumn[0].length));
                sortColumns.push(sortColumn.flat().map((c) => c.value));
            }
            else {
                const colIndex = toNumber(toScalar(sortColumn)?.value, locale);
                if (colIndex < 1 || colIndex > matrix[0].length) {
                    return matrix;
                }
                sortColumns.push(matrix.map((row) => row[colIndex - 1].value));
            }
        }
        if (sortColumns.length === 0) {
            for (let i = 0; i < matrix[0].length; i++) {
                sortColumns.push(matrix.map((row) => row[i].value));
                sortingOrders.push("ascending");
            }
        }
        const sortingCriteria = {
            descending: cellsSortingCriterion("descending"),
            ascending: cellsSortingCriterion("ascending"),
        };
        const indexes = range(0, matrix.length);
        indexes.sort((a, b) => {
            for (const [i, sortColumn] of sortColumns.entries()) {
                const left = sortColumn[a];
                const right = sortColumn[b];
                const leftCell = {
                    value: left,
                    type: left === null
                        ? CellValueType.empty
                        : typeof left === "string"
                            ? CellValueType.text
                            : typeof left,
                };
                const rightCell = {
                    value: right,
                    type: right === null
                        ? CellValueType.empty
                        : typeof right === "string"
                            ? CellValueType.text
                            : typeof right,
                };
                const result = sortingCriteria[sortingOrders[i]](leftCell, rightCell);
                if (result !== 0) {
                    return result;
                }
            }
            return 0;
        });
        return indexes.map((i) => matrix[i]);
    }
    // -----------------------------------------------------------------------------
    // FILTER
    // -----------------------------------------------------------------------------
    const FILTER = {
        description: _t("Returns a filtered version of the source range, returning only rows or columns that meet the specified conditions."),
        // TODO modify args description when vectorization on formulas is available
        args: [
            arg("range (any, range<any>)", _t("The data to be filtered.")),
            arg("condition1 (boolean, range<boolean>)", _t("A column or row containing true or false values corresponding to the first column or row of range.")),
            arg("condition2 (boolean, range<boolean>, repeating)", _t("Additional column or row containing true or false values.")),
        ],
        returns: ["RANGE<ANY>"],
        computeValueAndFormat: function (range, ...conditions) {
            let _array = toMatrix(range);
            const _conditionsMatrices = conditions.map((cond) => matrixMap(toMatrix(cond), (data) => data.value));
            _conditionsMatrices.map((c) => assertSingleColOrRow(_t("The arguments condition must be a single column or row."), c));
            assertSameDimensions(_t("The arguments conditions must have the same dimensions."), ..._conditionsMatrices);
            const _conditions = _conditionsMatrices.map((c) => c.flat());
            const mode = _conditionsMatrices[0].length === 1 ? "row" : "col";
            _array = mode === "row" ? transposeMatrix(_array) : _array;
            assert(() => _conditions.every((cond) => cond.length === _array.length), _t("FILTER has mismatched sizes on the range and conditions."));
            const result = [];
            for (let i = 0; i < _array.length; i++) {
                const row = _array[i];
                if (_conditions.every((c) => c[i])) {
                    result.push(row);
                }
            }
            if (!result.length) {
                throw new NotAvailableError(_t("No match found in FILTER evaluation"));
            }
            return mode === "row" ? transposeMatrix(result) : result;
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // SORT
    // -----------------------------------------------------------------------------
    const SORT = {
        description: _t("Sorts the rows of a given array or range by the values in one or more columns."),
        args: [
            arg("range (range)", _t("The data to be sorted.")),
            arg("sort_column (any, range<number>, repeating)", _t("The index of the column in range or a range outside of range containing the values by which to sort.")),
            arg("is_ascending (boolean, repeating)", _t("TRUE or FALSE indicating whether to sort sort_column in ascending order. FALSE sorts in descending order.")),
        ],
        returns: ["RANGE"],
        computeValueAndFormat: function (range, ...sortingCriteria) {
            const _range = transposeMatrix(range);
            return transposeMatrix(sortMatrix(_range, this.locale, ...sortingCriteria));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SORTN
    // -----------------------------------------------------------------------------
    const SORTN = {
        description: _t("Returns the first n items in a data set after performing a sort."),
        args: [
            arg("range (range)", _t("The data to be sorted.")),
            arg("n (number, default=1)", _t("The number of items to return.")),
            arg("display_ties_mode (number, default=0)", _t("A number representing the way to display ties.")),
            arg("sort_column (number, range<number>, repeating)", _t("The index of the column in range or a range outside of range containing the values by which to sort.")),
            arg("is_ascending (boolean, repeating)", _t("TRUE or FALSE indicating whether to sort sort_column in ascending order. FALSE sorts in descending order.")),
        ],
        returns: ["RANGE"],
        computeValueAndFormat: function (range, n, displayTiesMode, ...sortingCriteria) {
            const _n = toNumber(n?.value ?? 1, this.locale);
            assert(() => _n >= 0, _t("Wrong value of 'n'. Expected a positive number. Got %s.", _n));
            const _displayTiesMode = toNumber(displayTiesMode?.value ?? 0, this.locale);
            assert(() => _displayTiesMode >= 0 && _displayTiesMode <= 3, _t("Wrong value of 'display_ties_mode'. Expected a positive number between 0 and 3. Got %s.", _displayTiesMode));
            const sortedData = sortMatrix(transposeMatrix(range), this.locale, ...sortingCriteria);
            const sameRows = (i, j) => JSON.stringify(sortedData[i].map((c) => c.value)) ===
                JSON.stringify(sortedData[j].map((c) => c.value));
            /*
             * displayTiesMode determine how ties (equal values) are dealt with:
             * 0 - ignore ties and show first n rows only
             * 1 - show first n rows plus any additional ties with nth row
             * 2 - show n rows but remove duplicates
             * 3 - show first n unique rows and all duplicates of these rows
             */
            switch (_displayTiesMode) {
                case 0:
                    return transposeMatrix(sortedData.slice(0, _n));
                case 1:
                    for (let i = _n; i < sortedData.length; i++) {
                        if (!sameRows(i, _n - 1)) {
                            return transposeMatrix(sortedData.slice(0, i));
                        }
                    }
                    return transposeMatrix(sortedData);
                case 2: {
                    const uniques = [sortedData[0]];
                    for (let i = 1; i < sortedData.length; i++) {
                        for (let j = 0; j < i; j++) {
                            if (sameRows(i, j)) {
                                break;
                            }
                            if (j === i - 1) {
                                uniques.push(sortedData[i]);
                            }
                        }
                    }
                    return transposeMatrix(uniques.slice(0, _n));
                }
                case 3: {
                    const uniques = [sortedData[0]];
                    let counter = 1;
                    for (let i = 1; i < sortedData.length; i++) {
                        if (!sameRows(i, i - 1)) {
                            counter++;
                        }
                        if (counter > _n) {
                            break;
                        }
                        uniques.push(sortedData[i]);
                    }
                    return transposeMatrix(uniques);
                }
            }
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // UNIQUE
    // -----------------------------------------------------------------------------
    const UNIQUE = {
        description: _t("Unique rows in the provided source range."),
        args: [
            arg("range (any, range<any>)", _t("The data to filter by unique entries.")),
            arg("by_column (boolean, default=FALSE)", _t("Whether to filter the data by columns or by rows.")),
            arg("exactly_once (boolean, default=FALSE)", _t("Whether to return only entries with no duplicates.")),
        ],
        returns: ["RANGE<NUMBER>"],
        computeValueAndFormat: function (range = { value: "" }, byColumn, exactlyOnce) {
            if (!isMatrix(range)) {
                return [[range]];
            }
            const _byColumn = toBoolean(byColumn?.value) || false;
            const _exactlyOnce = toBoolean(exactlyOnce?.value) || false;
            if (!_byColumn) {
                range = transposeMatrix(range);
            }
            const map = new Map();
            for (const data of range) {
                const key = JSON.stringify(data.map((item) => item.value));
                const occurrence = map.get(key);
                if (!occurrence) {
                    map.set(key, { data, count: 1 });
                }
                else {
                    occurrence.count++;
                }
            }
            const result = [];
            for (const row of map.values()) {
                if (_exactlyOnce && row.count > 1) {
                    continue;
                }
                result.push(row.data);
            }
            if (!result.length)
                throw new Error(_t("No unique values found"));
            return _byColumn ? result : transposeMatrix(result);
        },
        isExported: true,
    };

    var filter = /*#__PURE__*/Object.freeze({
        __proto__: null,
        FILTER: FILTER,
        SORT: SORT,
        SORTN: SORTN,
        UNIQUE: UNIQUE
    });

    /** Assert maturity date > settlement date */
    function assertMaturityAndSettlementDatesAreValid(settlement, maturity) {
        assert(() => settlement < maturity, _t("The maturity (%s) must be strictly greater than the settlement (%s).", maturity.toString(), settlement.toString()));
    }
    /** Assert settlement date > issue date */
    function assertSettlementAndIssueDatesAreValid(settlement, issue) {
        assert(() => issue < settlement, _t("The settlement date (%s) must be strictly greater than the issue date (%s).", settlement.toString(), issue.toString()));
    }
    /** Assert coupon frequency is in [1, 2, 4] */
    function assertCouponFrequencyIsValid(frequency) {
        assert(() => [1, 2, 4].includes(frequency), _t("The frequency (%s) must be one of %s", frequency.toString(), [1, 2, 4].toString()));
    }
    /** Assert dayCountConvention is between 0 and 4 */
    function assertDayCountConventionIsValid(dayCountConvention) {
        assert(() => 0 <= dayCountConvention && dayCountConvention <= 4, _t("The day_count_convention (%s) must be between 0 and 4 inclusive.", dayCountConvention.toString()));
    }
    function assertRedemptionStrictlyPositive(redemption) {
        assert(() => redemption > 0, _t("The redemption (%s) must be strictly positive.", redemption.toString()));
    }
    function assertPriceStrictlyPositive(price) {
        assert(() => price > 0, _t("The price (%s) must be strictly positive.", price.toString()));
    }
    function assertNumberOfPeriodsStrictlyPositive(nPeriods) {
        assert(() => nPeriods > 0, _t("The number_of_periods (%s) must be greater than 0.", nPeriods.toString()));
    }
    function assertRateStrictlyPositive(rate) {
        assert(() => rate > 0, _t("The rate (%s) must be strictly positive.", rate.toString()));
    }
    function assertLifeStrictlyPositive(life) {
        assert(() => life > 0, _t("The life (%s) must be strictly positive.", life.toString()));
    }
    function assertCostStrictlyPositive(cost) {
        assert(() => cost > 0, _t("The cost (%s) must be strictly positive.", cost.toString()));
    }
    function assertCostPositiveOrZero(cost) {
        assert(() => cost >= 0, _t("The cost (%s) must be positive or null.", cost.toString()));
    }
    function assertPeriodStrictlyPositive(period) {
        assert(() => period > 0, _t("The period (%s) must be strictly positive.", period.toString()));
    }
    function assertPeriodPositiveOrZero(period) {
        assert(() => period >= 0, _t("The period (%s) must be positive or null.", period.toString()));
    }
    function assertSalvagePositiveOrZero(salvage) {
        assert(() => salvage >= 0, _t("The salvage (%s) must be positive or null.", salvage.toString()));
    }
    function assertSalvageSmallerOrEqualThanCost(salvage, cost) {
        assert(() => salvage <= cost, _t("The salvage (%s) must be smaller or equal than the cost (%s).", salvage.toString(), cost.toString()));
    }
    function assertPresentValueStrictlyPositive(pv) {
        assert(() => pv > 0, _t("The present value (%s) must be strictly positive.", pv.toString()));
    }
    function assertPeriodSmallerOrEqualToLife(period, life) {
        assert(() => period <= life, _t("The period (%s) must be less than or equal life (%s).", period.toString(), life.toString()));
    }
    function assertInvestmentStrictlyPositive(investment) {
        assert(() => investment > 0, _t("The investment (%s) must be strictly positive.", investment.toString()));
    }
    function assertDiscountStrictlyPositive(discount) {
        assert(() => discount > 0, _t("The discount (%s) must be strictly positive.", discount.toString()));
    }
    function assertDiscountStrictlySmallerThanOne(discount) {
        assert(() => discount < 1, _t("The discount (%s) must be smaller than 1.", discount.toString()));
    }
    function assertDeprecationFactorStrictlyPositive(factor) {
        assert(() => factor > 0, _t("The depreciation factor (%s) must be strictly positive.", factor.toString()));
    }
    function assertSettlementLessThanOneYearBeforeMaturity(settlement, maturity, locale) {
        const startDate = toJsDate(settlement, locale);
        const endDate = toJsDate(maturity, locale);
        const startDatePlusOneYear = toJsDate(settlement, locale);
        startDatePlusOneYear.setFullYear(startDate.getFullYear() + 1);
        assert(() => endDate.getTime() <= startDatePlusOneYear.getTime(), _t("The settlement date (%s) must at most one year after the maturity date (%s).", settlement.toString(), maturity.toString()));
    }
    /**
     * Check if the given periods are valid. This will assert :
     *
     * - 0 < numberOfPeriods
     * - 0 < firstPeriod <= lastPeriod
     * - 0 < lastPeriod <= numberOfPeriods
     *
     */
    function assertFirstAndLastPeriodsAreValid(firstPeriod, lastPeriod, numberOfPeriods) {
        assertNumberOfPeriodsStrictlyPositive(numberOfPeriods);
        assert(() => firstPeriod > 0, _t("The first_period (%s) must be strictly positive.", firstPeriod.toString()));
        assert(() => lastPeriod > 0, _t("The last_period (%s) must be strictly positive.", lastPeriod.toString()));
        assert(() => firstPeriod <= lastPeriod, _t("The first_period (%s) must be smaller or equal to the last_period (%s).", firstPeriod.toString(), lastPeriod.toString()));
        assert(() => lastPeriod <= numberOfPeriods, _t("The last_period (%s) must be smaller or equal to the number_of_periods (%s).", firstPeriod.toString(), numberOfPeriods.toString()));
    }
    /**
     * Check if the given periods are valid. This will assert :
     *
     * - 0 < life
     * - 0 <= startPeriod <= endPeriod
     * - 0 <= endPeriod <= life
     *
     */
    function assertStartAndEndPeriodAreValid(startPeriod, endPeriod, life) {
        assertLifeStrictlyPositive(life);
        assert(() => startPeriod >= 0, _t("The start_period (%s) must be greater or equal than 0.", startPeriod.toString()));
        assert(() => endPeriod >= 0, _t("The end_period (%s) must be greater or equal than 0.", endPeriod.toString()));
        assert(() => startPeriod <= endPeriod, _t("The start_period (%s) must be smaller or equal to the end_period (%s).", startPeriod.toString(), endPeriod.toString()));
        assert(() => endPeriod <= life, _t("The end_period (%s) must be smaller or equal to the life (%s).", startPeriod.toString(), life.toString()));
    }
    function assertRateGuessStrictlyGreaterThanMinusOne(guess) {
        assert(() => guess > -1, _t("The rate_guess (%s) must be strictly greater than -1.", guess.toString()));
    }
    function assertCashFlowsAndDatesHaveSameDimension(cashFlows, dates) {
        assert(() => cashFlows.length === dates.length && cashFlows[0].length === dates[0].length, _t("The cashflow_amounts and cashflow_dates ranges must have the same dimensions."));
    }
    function assertCashFlowsHavePositiveAndNegativesValues(cashFlow) {
        assert(() => cashFlow.some((val) => val > 0) && cashFlow.some((val) => val < 0), _t("There must be both positive and negative values in cashflow_amounts."));
    }
    function assertEveryDateGreaterThanFirstDateOfCashFlowDates(dates) {
        assert(() => dates.every((date) => date >= dates[0]), _t("All the dates should be greater or equal to the first date in cashflow_dates (%s).", dates[0].toString()));
    }

    const DEFAULT_DAY_COUNT_CONVENTION = 0;
    const DEFAULT_END_OR_BEGINNING = 0;
    const DEFAULT_FUTURE_VALUE = 0;
    const COUPON_FUNCTION_ARGS = [
        arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
        arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
        arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
        arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
    ];
    /**
     * Use the Newton–Raphson method to find a root of the given function in an iterative manner.
     *
     * @param func the function to find a root of
     * @param derivFunc the derivative of the function
     * @param startValue the initial value for the first iteration of the algorithm
     * @param maxIterations the maximum number of iterations
     * @param epsMax the epsilon for the root
     * @param nanFallback a function giving a fallback value to use if func(x) returns NaN. Useful if the
     *                       function is not defined for some range, but we know approximately where the root is when the Newton
     *                       algorithm ends up in this range.
     */
    function newtonMethod(func, derivFunc, startValue, maxIterations, epsMax = 1e-10, nanFallback) {
        let x = startValue;
        let newX;
        let xDelta;
        let y;
        let yEqual0 = false;
        let count = 0;
        let previousFallback = undefined;
        do {
            y = func(x);
            if (isNaN(y)) {
                assert(() => count < maxIterations && nanFallback !== undefined, _t("Function [[FUNCTION_NAME]] didn't find any result."));
                count++;
                x = nanFallback(previousFallback);
                previousFallback = x;
                continue;
            }
            newX = x - y / derivFunc(x);
            xDelta = Math.abs(newX - x);
            x = newX;
            yEqual0 = xDelta < epsMax || Math.abs(y) < epsMax;
            assert(() => count < maxIterations, _t("Function [[FUNCTION_NAME]] didn't find any result."));
            count++;
        } while (!yEqual0);
        return x;
    }
    // -----------------------------------------------------------------------------
    // ACCRINTM
    // -----------------------------------------------------------------------------
    const ACCRINTM = {
        description: _t("Accrued interest of security paying at maturity."),
        args: [
            arg("issue (date)", _t("The date the security was initially issued.")),
            arg("maturity (date)", _t("The maturity date of the security.")),
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (issue, maturity, rate, redemption, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const start = Math.trunc(toNumber(issue, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const _redemption = toNumber(redemption, this.locale);
            const _rate = toNumber(rate, this.locale);
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertSettlementAndIssueDatesAreValid(end, start);
            assertDayCountConventionIsValid(_dayCountConvention);
            assertRedemptionStrictlyPositive(_redemption);
            assertRateStrictlyPositive(_rate);
            const yearFrac = YEARFRAC.compute.bind(this)(start, end, dayCountConvention);
            return _redemption * _rate * yearFrac;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // AMORLINC
    // -----------------------------------------------------------------------------
    const AMORLINC = {
        description: _t("Depreciation for an accounting period."),
        args: [
            arg("cost (number)", _t("The initial cost of the asset.")),
            arg("purchase_date (date)", _t("The date the asset was purchased.")),
            arg("first_period_end (date)", _t("The date the first period ended.")),
            arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
            arg("period (number)", _t("The single period within life for which to calculate depreciation.")),
            arg("rate (number)", _t("The deprecation rate.")),
            arg("day_count_convention (number, optional)", _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (cost, purchaseDate, firstPeriodEnd, salvage, period, rate, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _cost = toNumber(cost, this.locale);
            const _purchaseDate = Math.trunc(toNumber(purchaseDate, this.locale));
            const _firstPeriodEnd = Math.trunc(toNumber(firstPeriodEnd, this.locale));
            const _salvage = toNumber(salvage, this.locale);
            const _period = toNumber(period, this.locale);
            const _rate = toNumber(rate, this.locale);
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertCostStrictlyPositive(_cost);
            assertSalvagePositiveOrZero(_salvage);
            assertSalvageSmallerOrEqualThanCost(_salvage, _cost);
            assertPeriodPositiveOrZero(_period);
            assertRateStrictlyPositive(_rate);
            assertDayCountConventionIsValid(_dayCountConvention);
            assert(() => _purchaseDate <= _firstPeriodEnd, _t("The purchase_date (%s) must be before the first_period_end (%s).", _purchaseDate.toString(), _firstPeriodEnd.toString()));
            /**
             * https://wiki.documentfoundation.org/Documentation/Calc_Functions/AMORLINC
             *
             * AMORLINC period 0 = cost * rate * YEARFRAC(purchase date, first period end)
             * AMORLINC period n = cost * rate
             * AMORLINC at the last period is such that the remaining deprecated cost is equal to the salvage value.
             *
             * The period is and rounded to 1 if < 1 truncated if > 1,
             *
             * Compatibility note :
             * If (purchase date) === (first period end), on GSheet the deprecation at the first period is 0, and on Excel
             * it is a full period deprecation. We choose to use the Excel behaviour.
             */
            const roundedPeriod = _period < 1 && _period > 0 ? 1 : Math.trunc(_period);
            const deprec = _cost * _rate;
            const yearFrac = YEARFRAC.compute.bind(this)(_purchaseDate, _firstPeriodEnd, _dayCountConvention);
            const firstDeprec = _purchaseDate === _firstPeriodEnd ? deprec : deprec * yearFrac;
            const valueAtPeriod = _cost - firstDeprec - deprec * roundedPeriod;
            if (valueAtPeriod >= _salvage) {
                return roundedPeriod === 0 ? firstDeprec : deprec;
            }
            return _salvage - valueAtPeriod < deprec ? deprec - (_salvage - valueAtPeriod) : 0;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUPDAYS
    // -----------------------------------------------------------------------------
    const COUPDAYS = {
        description: _t("Days in coupon period containing settlement date."),
        args: COUPON_FUNCTION_ARGS,
        returns: ["NUMBER"],
        compute: function (settlement, maturity, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            // https://wiki.documentfoundation.org/Documentation/Calc_Functions/COUPDAYS
            if (_dayCountConvention === 1) {
                const before = COUPPCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
                const after = COUPNCD.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
                return after - before;
            }
            const daysInYear = _dayCountConvention === 3 ? 365 : 360;
            return daysInYear / _frequency;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUPDAYBS
    // -----------------------------------------------------------------------------
    const COUPDAYBS = {
        description: _t("Days from settlement until next coupon."),
        args: COUPON_FUNCTION_ARGS,
        returns: ["NUMBER"],
        compute: function (settlement, maturity, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            const couponBeforeStart = COUPPCD.compute.bind(this)(start, end, frequency, dayCountConvention);
            if ([1, 2, 3].includes(_dayCountConvention)) {
                return start - couponBeforeStart;
            }
            if (_dayCountConvention === 4) {
                const yearFrac = getYearFrac(couponBeforeStart, start, _dayCountConvention);
                return Math.round(yearFrac * 360);
            }
            const startDate = toJsDate(start, this.locale);
            const dateCouponBeforeStart = toJsDate(couponBeforeStart, this.locale);
            const y1 = dateCouponBeforeStart.getFullYear();
            const y2 = startDate.getFullYear();
            const m1 = dateCouponBeforeStart.getMonth() + 1; // +1 because months in js start at 0 and it's confusing
            const m2 = startDate.getMonth() + 1;
            let d1 = dateCouponBeforeStart.getDate();
            let d2 = startDate.getDate();
            /**
             * Rules based on https://en.wikipedia.org/wiki/Day_count_convention#30/360_US
             *
             * These are slightly modified (no mention of if investment is EOM and rules order is modified),
             * but from my testing this seems the rules used by Excel/GSheet.
             */
            if (m1 === 2 &&
                m2 === 2 &&
                isLastDayOfMonth(dateCouponBeforeStart) &&
                isLastDayOfMonth(startDate)) {
                d2 = 30;
            }
            if (d2 === 31 && (d1 === 30 || d1 === 31)) {
                d2 = 30;
            }
            if (m1 === 2 && isLastDayOfMonth(dateCouponBeforeStart)) {
                d1 = 30;
            }
            if (d1 === 31) {
                d1 = 30;
            }
            return (y2 - y1) * 360 + (m2 - m1) * 30 + (d2 - d1);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUPDAYSNC
    // -----------------------------------------------------------------------------
    const COUPDAYSNC = {
        description: _t("Days from settlement until next coupon."),
        args: COUPON_FUNCTION_ARGS,
        returns: ["NUMBER"],
        compute: function (settlement, maturity, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            const couponAfterStart = COUPNCD.compute.bind(this)(start, end, frequency, dayCountConvention);
            if ([1, 2, 3].includes(_dayCountConvention)) {
                return couponAfterStart - start;
            }
            if (_dayCountConvention === 4) {
                const yearFrac = getYearFrac(start, couponAfterStart, _dayCountConvention);
                return Math.round(yearFrac * 360);
            }
            const coupDayBs = COUPDAYBS.compute.bind(this)(settlement, maturity, frequency, _dayCountConvention);
            const coupDays = COUPDAYS.compute.bind(this)(settlement, maturity, frequency, _dayCountConvention);
            return coupDays - coupDayBs;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUPNCD
    // -----------------------------------------------------------------------------
    const COUPNCD = {
        description: _t("Next coupon date after the settlement date."),
        args: COUPON_FUNCTION_ARGS,
        returns: ["NUMBER"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (settlement, maturity, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            const monthsPerPeriod = 12 / _frequency;
            const coupNum = COUPNUM.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
            const date = addMonthsToDate(toJsDate(end, this.locale), -(coupNum - 1) * monthsPerPeriod, true);
            return jsDateToRoundNumber(date);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUPNUM
    // -----------------------------------------------------------------------------
    const COUPNUM = {
        description: _t("Number of coupons between settlement and maturity."),
        args: COUPON_FUNCTION_ARGS,
        returns: ["NUMBER"],
        compute: function (settlement, maturity, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            let num = 1;
            let currentDate = end;
            const monthsPerPeriod = 12 / _frequency;
            while (currentDate > start) {
                currentDate = jsDateToRoundNumber(addMonthsToDate(toJsDate(currentDate, this.locale), -monthsPerPeriod, false));
                num++;
            }
            return num - 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COUPPCD
    // -----------------------------------------------------------------------------
    const COUPPCD = {
        description: _t("Last coupon date prior to or on the settlement date."),
        args: COUPON_FUNCTION_ARGS,
        returns: ["NUMBER"],
        computeFormat: function () {
            return this.locale.dateFormat;
        },
        compute: function (settlement, maturity, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            const monthsPerPeriod = 12 / _frequency;
            const coupNum = COUPNUM.compute.bind(this)(settlement, maturity, frequency, dayCountConvention);
            const date = addMonthsToDate(toJsDate(end, this.locale), -coupNum * monthsPerPeriod, true);
            return jsDateToRoundNumber(date);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CUMIPMT
    // -----------------------------------------------------------------------------
    const CUMIPMT = {
        description: _t("Cumulative interest paid over a set of periods."),
        args: [
            arg("rate (number)", _t("The interest rate.")),
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("present_value (number)", _t("The current value of the annuity.")),
            arg("first_period (number)", _t("The number of the payment period to begin the cumulative calculation.")),
            arg("last_period (number)", _t("The number of the payment period to end the cumulative calculation.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        ],
        returns: ["NUMBER"],
        compute: function (rate, numberOfPeriods, presentValue, firstPeriod, lastPeriod, endOrBeginning = DEFAULT_END_OR_BEGINNING) {
            const first = toNumber(firstPeriod, this.locale);
            const last = toNumber(lastPeriod, this.locale);
            const _rate = toNumber(rate, this.locale);
            const pv = toNumber(presentValue, this.locale);
            const nOfPeriods = toNumber(numberOfPeriods, this.locale);
            assertFirstAndLastPeriodsAreValid(first, last, nOfPeriods);
            assertRateStrictlyPositive(_rate);
            assertPresentValueStrictlyPositive(pv);
            let cumSum = 0;
            for (let i = first; i <= last; i++) {
                const impt = IPMT.compute.bind(this)(rate, i, nOfPeriods, presentValue, 0, endOrBeginning);
                cumSum += impt;
            }
            return cumSum;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CUMPRINC
    // -----------------------------------------------------------------------------
    const CUMPRINC = {
        description: _t("Cumulative principal paid over a set of periods."),
        args: [
            arg("rate (number)", _t("The interest rate.")),
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("present_value (number)", _t("The current value of the annuity.")),
            arg("first_period (number)", _t("The number of the payment period to begin the cumulative calculation.")),
            arg("last_period (number)", _t("The number of the payment period to end the cumulative calculation.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        ],
        returns: ["NUMBER"],
        compute: function (rate, numberOfPeriods, presentValue, firstPeriod, lastPeriod, endOrBeginning = DEFAULT_END_OR_BEGINNING) {
            const first = toNumber(firstPeriod, this.locale);
            const last = toNumber(lastPeriod, this.locale);
            const _rate = toNumber(rate, this.locale);
            const pv = toNumber(presentValue, this.locale);
            const nOfPeriods = toNumber(numberOfPeriods, this.locale);
            assertFirstAndLastPeriodsAreValid(first, last, nOfPeriods);
            assertRateStrictlyPositive(_rate);
            assertPresentValueStrictlyPositive(pv);
            let cumSum = 0;
            for (let i = first; i <= last; i++) {
                const ppmt = PPMT.compute.bind(this)(rate, i, nOfPeriods, presentValue, 0, endOrBeginning);
                cumSum += ppmt;
            }
            return cumSum;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DB
    // -----------------------------------------------------------------------------
    const DB = {
        description: _t("Depreciation via declining balance method."),
        args: [
            arg("cost (number)", _t("The initial cost of the asset.")),
            arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
            arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
            arg("period (number)", _t("The single period within life for which to calculate depreciation.")),
            arg("month (number, optional)", _t("The number of months in the first year of depreciation.")),
        ],
        returns: ["NUMBER"],
        // to do: replace by dollar format
        computeFormat: () => "#,##0.00",
        compute: function (cost, salvage, life, period, ...args) {
            const _cost = toNumber(cost, this.locale);
            const _salvage = toNumber(salvage, this.locale);
            const _life = toNumber(life, this.locale);
            const _period = Math.trunc(toNumber(period, this.locale));
            const _month = args.length ? Math.trunc(toNumber(args[0], this.locale)) : 12;
            const lifeLimit = _life + (_month === 12 ? 0 : 1);
            assertCostPositiveOrZero(_cost);
            assertSalvagePositiveOrZero(_salvage);
            assertPeriodStrictlyPositive(_period);
            assertLifeStrictlyPositive(_life);
            assert(() => 1 <= _month && _month <= 12, _t("The month (%s) must be between 1 and 12 inclusive.", _month.toString()));
            assert(() => _period <= lifeLimit, _t("The period (%s) must be less than or equal to %s.", _period.toString(), lifeLimit.toString()));
            const monthPart = _month / 12;
            let rate = 1 - Math.pow(_salvage / _cost, 1 / _life);
            // round to 3 decimal places
            rate = Math.round(rate * 1000) / 1000;
            let before = _cost;
            let after = _cost * (1 - rate * monthPart);
            for (let i = 1; i < _period; i++) {
                before = after;
                after = before * (1 - rate);
                if (i === _life) {
                    after = before * (1 - rate * (1 - monthPart));
                }
            }
            return before - after;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DDB
    // -----------------------------------------------------------------------------
    const DEFAULT_DDB_DEPRECIATION_FACTOR = 2;
    const DDB = {
        description: _t("Depreciation via double-declining balance method."),
        args: [
            arg("cost (number)", _t("The initial cost of the asset.")),
            arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
            arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
            arg("period (number)", _t("The single period within life for which to calculate depreciation.")),
            arg(`factor (number, default=${DEFAULT_DDB_DEPRECIATION_FACTOR})`, _t("The factor by which depreciation decreases.")),
        ],
        returns: ["NUMBER"],
        computeFormat: () => "#,##0.00",
        compute: function (cost, salvage, life, period, factor = DEFAULT_DDB_DEPRECIATION_FACTOR) {
            factor = factor || 0;
            const _cost = toNumber(cost, this.locale);
            const _salvage = toNumber(salvage, this.locale);
            const _life = toNumber(life, this.locale);
            const _period = toNumber(period, this.locale);
            const _factor = toNumber(factor, this.locale);
            assertCostPositiveOrZero(_cost);
            assertSalvagePositiveOrZero(_salvage);
            assertPeriodStrictlyPositive(_period);
            assertLifeStrictlyPositive(_life);
            assertPeriodSmallerOrEqualToLife(_period, _life);
            assertDeprecationFactorStrictlyPositive(_factor);
            if (_cost === 0 || _salvage >= _cost)
                return 0;
            const deprecFactor = _factor / _life;
            if (deprecFactor > 1) {
                return period === 1 ? _cost - _salvage : 0;
            }
            if (_period <= 1) {
                return _cost * deprecFactor;
            }
            const previousCost = _cost * Math.pow(1 - deprecFactor, _period - 1);
            const nextCost = _cost * Math.pow(1 - deprecFactor, _period);
            const deprec = nextCost < _salvage ? previousCost - _salvage : previousCost - nextCost;
            return Math.max(deprec, 0);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DISC
    // -----------------------------------------------------------------------------
    const DISC = {
        description: _t("Discount rate of a security based on price."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("price (number)", _t("The price at which the security is bought per 100 face value.")),
            arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, price, redemption, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _price = toNumber(price, this.locale);
            const _redemption = toNumber(redemption, this.locale);
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertDayCountConventionIsValid(_dayCountConvention);
            assertPriceStrictlyPositive(_price);
            assertRedemptionStrictlyPositive(_redemption);
            /**
             * https://support.microsoft.com/en-us/office/disc-function-71fce9f3-3f05-4acf-a5a3-eac6ef4daa53
             *
             * B = number of days in year, depending on year basis
             * DSM = number of days from settlement to maturity
             *
             *        redemption - price          B
             * DISC = ____________________  *    ____
             *            redemption             DSM
             */
            const yearsFrac = YEARFRAC.compute.bind(this)(_settlement, _maturity, _dayCountConvention);
            return (_redemption - _price) / _redemption / yearsFrac;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DOLLARDE
    // -----------------------------------------------------------------------------
    const DOLLARDE = {
        description: _t("Convert a decimal fraction to decimal value."),
        args: [
            arg("fractional_price (number)", _t("The price quotation given using fractional decimal conventions.")),
            arg("unit (number)", _t("The units of the fraction, e.g. 8 for 1/8ths or 32 for 1/32nds.")),
        ],
        returns: ["NUMBER"],
        compute: function (fractionalPrice, unit) {
            const price = toNumber(fractionalPrice, this.locale);
            const _unit = Math.trunc(toNumber(unit, this.locale));
            assert(() => _unit > 0, _t("The unit (%s) must be strictly positive.", _unit.toString()));
            const truncatedPrice = Math.trunc(price);
            const priceFractionalPart = price - truncatedPrice;
            const frac = 10 ** Math.ceil(Math.log10(_unit)) / _unit;
            return truncatedPrice + priceFractionalPart * frac;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DOLLARFR
    // -----------------------------------------------------------------------------
    const DOLLARFR = {
        description: _t("Convert a decimal value to decimal fraction."),
        args: [
            arg("decimal_price (number)", _t("The price quotation given as a decimal value.")),
            arg("unit (number)", _t("The units of the desired fraction, e.g. 8 for 1/8ths or 32 for 1/32nds.")),
        ],
        returns: ["NUMBER"],
        compute: function (decimalPrice, unit) {
            const price = toNumber(decimalPrice, this.locale);
            const _unit = Math.trunc(toNumber(unit, this.locale));
            assert(() => _unit > 0, _t("The unit (%s) must be strictly positive.", _unit.toString()));
            const truncatedPrice = Math.trunc(price);
            const priceFractionalPart = price - truncatedPrice;
            const frac = _unit / 10 ** Math.ceil(Math.log10(_unit));
            return truncatedPrice + priceFractionalPart * frac;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DURATION
    // -----------------------------------------------------------------------------
    const DURATION = {
        description: _t("Number of periods for an investment to reach a value."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("yield (number)", _t("The expected annual yield of the security.")),
            arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, rate, securityYield, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const _rate = toNumber(rate, this.locale);
            const _yield = toNumber(securityYield, this.locale);
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
            assert(() => _yield >= 0, _t("The yield (%s) must be positive or null.", _yield.toString()));
            const years = YEARFRAC.compute.bind(this)(start, end, _dayCountConvention);
            const timeFirstYear = years - Math.trunc(years) || 1 / _frequency;
            const nbrCoupons = Math.ceil(years * _frequency);
            // The DURATION function return the Macaulay duration
            // See example: https://en.wikipedia.org/wiki/Bond_duration#Formulas
            const cashFlowFromCoupon = _rate / _frequency;
            const yieldPerPeriod = _yield / _frequency;
            let count = 0;
            let sum = 0;
            for (let i = 1; i <= nbrCoupons; i++) {
                const cashFlowPerPeriod = cashFlowFromCoupon + (i === nbrCoupons ? 1 : 0);
                const presentValuePerPeriod = cashFlowPerPeriod / (1 + yieldPerPeriod) ** i;
                sum += (timeFirstYear + (i - 1) / _frequency) * presentValuePerPeriod;
                count += presentValuePerPeriod;
            }
            return count === 0 ? 0 : sum / count;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // EFFECT
    // -----------------------------------------------------------------------------
    const EFFECT = {
        description: _t("Annual effective interest rate."),
        args: [
            arg("nominal_rate (number)", _t("The nominal interest rate per year.")),
            arg("periods_per_year (number)", _t("The number of compounding periods per year.")),
        ],
        returns: ["NUMBER"],
        compute: function (nominal_rate, periods_per_year) {
            const nominal = toNumber(nominal_rate, this.locale);
            const periods = Math.trunc(toNumber(periods_per_year, this.locale));
            assert(() => nominal > 0, _t("The nominal rate (%s) must be strictly greater than 0.", nominal.toString()));
            assert(() => periods > 0, _t("The number of periods by year (%s) must strictly greater than 0.", periods.toString()));
            // https://en.wikipedia.org/wiki/Nominal_interest_rate#Nominal_versus_effective_interest_rate
            return Math.pow(1 + nominal / periods, periods) - 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FV
    // -----------------------------------------------------------------------------
    const DEFAULT_PRESENT_VALUE = 0;
    const FV = {
        description: _t("Future value of an annuity investment."),
        args: [
            arg("rate (number)", _t("The interest rate.")),
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("payment_amount (number)", _t("The amount per period to be paid.")),
            arg(`present_value (number, default=${DEFAULT_PRESENT_VALUE})`, _t("The current value of the annuity.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        ],
        returns: ["NUMBER"],
        // to do: replace by dollar format
        computeFormat: () => "#,##0.00",
        compute: function (rate, numberOfPeriods, paymentAmount, presentValue = DEFAULT_PRESENT_VALUE, endOrBeginning = DEFAULT_END_OR_BEGINNING) {
            presentValue = presentValue || 0;
            endOrBeginning = endOrBeginning || 0;
            const r = toNumber(rate, this.locale);
            const n = toNumber(numberOfPeriods, this.locale);
            const p = toNumber(paymentAmount, this.locale);
            const pv = toNumber(presentValue, this.locale);
            const type = toBoolean(endOrBeginning) ? 1 : 0;
            return r ? -pv * (1 + r) ** n - (p * (1 + r * type) * ((1 + r) ** n - 1)) / r : -(pv + p * n);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FVSCHEDULE
    // -----------------------------------------------------------------------------
    const FVSCHEDULE = {
        description: _t("Future value of principal from series of rates."),
        args: [
            arg("principal (number)", _t("The amount of initial capital or value to compound against.")),
            arg("rate_schedule (number, range<number>)", _t("A series of interest rates to compound against the principal.")),
        ],
        returns: ["NUMBER"],
        compute: function (principalAmount, rateSchedule) {
            const principal = toNumber(principalAmount, this.locale);
            return reduceAny([rateSchedule], (acc, rate) => acc * (1 + toNumber(rate, this.locale)), principal);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // INTRATE
    // -----------------------------------------------------------------------------
    const INTRATE = {
        description: _t("Calculates effective interest rate."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("investment (number)", _t("The amount invested in the security.")),
            arg("redemption (number)", _t("The amount to be received at maturity.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, investment, redemption, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _redemption = toNumber(redemption, this.locale);
            const _investment = toNumber(investment, this.locale);
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertInvestmentStrictlyPositive(_investment);
            assertRedemptionStrictlyPositive(_redemption);
            /**
             * https://wiki.documentfoundation.org/Documentation/Calc_Functions/INTRATE
             *
             *             (Redemption  - Investment) / Investment
             * INTRATE =  _________________________________________
             *              YEARFRAC(settlement, maturity, basis)
             */
            const yearFrac = YEARFRAC.compute.bind(this)(_settlement, _maturity, dayCountConvention);
            return (_redemption - _investment) / _investment / yearFrac;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // IPMT
    // -----------------------------------------------------------------------------
    const IPMT = {
        description: _t("Payment on the principal of an investment."),
        args: [
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("period (number)", _t("The amortization period, in terms of number of periods.")),
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("present_value (number)", _t("The current value of the annuity.")),
            arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        ],
        returns: ["NUMBER"],
        computeFormat: () => "#,##0.00",
        compute: function (rate, currentPeriod, numberOfPeriods, presentValue, futureValue = DEFAULT_FUTURE_VALUE, endOrBeginning = DEFAULT_END_OR_BEGINNING) {
            const payment = PMT.compute.bind(this)(rate, numberOfPeriods, presentValue, futureValue, endOrBeginning);
            const ppmt = PPMT.compute.bind(this)(rate, currentPeriod, numberOfPeriods, presentValue, futureValue, endOrBeginning);
            return payment - ppmt;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // IRR
    // -----------------------------------------------------------------------------
    const DEFAULT_RATE_GUESS = 0.1;
    const IRR = {
        description: _t("Internal rate of return given periodic cashflows."),
        args: [
            arg("cashflow_amounts (number, range<number>)", _t("An array or range containing the income or payments associated with the investment.")),
            arg(`rate_guess (number, default=${DEFAULT_RATE_GUESS})`, _t("An estimate for what the internal rate of return will be.")),
        ],
        returns: ["NUMBER"],
        computeFormat: () => "0%",
        compute: function (cashFlowAmounts, rateGuess = DEFAULT_RATE_GUESS) {
            const _rateGuess = toNumber(rateGuess, this.locale);
            assertRateGuessStrictlyGreaterThanMinusOne(_rateGuess);
            // check that values contains at least one positive value and one negative value
            // and extract number present in the cashFlowAmount argument
            let positive = false;
            let negative = false;
            let amounts = [];
            visitNumbers([cashFlowAmounts], (amount) => {
                if (amount > 0)
                    positive = true;
                if (amount < 0)
                    negative = true;
                amounts.push(amount);
            }, this.locale);
            assert(() => positive && negative, _t("The cashflow_amounts must include negative and positive values."));
            const firstAmount = amounts.shift();
            // The result of IRR is the rate at which the NPV() function will return zero with the given values.
            // This algorithm uses the Newton's method on the NPV function to determine the result
            // Newton's method: https://en.wikipedia.org/wiki/Newton%27s_method
            // As the NPV function isn't continuous, we apply the Newton's method on the numerator of the NPV formula.
            function npvNumerator(rate, startValue, values) {
                const nbrValue = values.length;
                let i = 0;
                return values.reduce((acc, v) => {
                    i++;
                    return acc + v * rate ** (nbrValue - i);
                }, startValue * rate ** nbrValue);
            }
            function npvNumeratorDeriv(rate, startValue, values) {
                const nbrValue = values.length;
                let i = 0;
                return values.reduce((acc, v) => {
                    i++;
                    return acc + v * (nbrValue - i) * rate ** (nbrValue - i - 1);
                }, startValue * nbrValue * rate ** (nbrValue - 1));
            }
            function func(x) {
                return npvNumerator(x, firstAmount, amounts);
            }
            function derivFunc(x) {
                return npvNumeratorDeriv(x, firstAmount, amounts);
            }
            return newtonMethod(func, derivFunc, _rateGuess + 1, 20, 1e-5) - 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISPMT
    // -----------------------------------------------------------------------------
    const ISPMT = {
        description: _t("Returns the interest paid at a particular period of an investment."),
        args: [
            arg("rate (number)", _t("The interest rate.")),
            arg("period (number)", _t("The period for which you want to view the interest payment.")),
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("present_value (number)", _t("The current value of the annuity.")),
        ],
        returns: ["NUMBER"],
        compute: function (rate, currentPeriod, numberOfPeriods, presentValue) {
            const interestRate = toNumber(rate, this.locale);
            const period = toNumber(currentPeriod, this.locale);
            const nOfPeriods = toNumber(numberOfPeriods, this.locale);
            const investment = toNumber(presentValue, this.locale);
            assert(() => nOfPeriods !== 0, _t("The number of periods must be different than 0.", nOfPeriods.toString()));
            const currentInvestment = investment - investment * (period / nOfPeriods);
            return -1 * currentInvestment * interestRate;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MDURATION
    // -----------------------------------------------------------------------------
    const MDURATION = {
        description: _t("Modified Macaulay duration."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("yield (number)", _t("The expected annual yield of the security.")),
            arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, rate, securityYield, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            const duration = DURATION.compute.bind(this)(settlement, maturity, rate, securityYield, frequency, dayCountConvention);
            const y = toNumber(securityYield, this.locale);
            const k = Math.trunc(toNumber(frequency, this.locale));
            return duration / (1 + y / k);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MIRR
    // -----------------------------------------------------------------------------
    const MIRR = {
        description: _t("Modified internal rate of return."),
        args: [
            arg("cashflow_amounts (range<number>)", _t("A range containing the income or payments associated with the investment. The array should contain bot payments and incomes.")),
            arg("financing_rate (number)", _t("The interest rate paid on funds invested.")),
            arg("reinvestment_return_rate (number)", _t("The return (as a percentage) earned on reinvestment of income received from the investment.")),
        ],
        returns: ["NUMBER"],
        compute: function (cashflowAmount, financingRate, reinvestmentRate) {
            const fRate = toNumber(financingRate, this.locale);
            const rRate = toNumber(reinvestmentRate, this.locale);
            const cashFlow = transposeMatrix(cashflowAmount)
                .flat()
                .filter((t) => t !== null)
                .map((val) => toNumber(val, this.locale));
            const n = cashFlow.length;
            /**
             * https://en.wikipedia.org/wiki/Modified_internal_rate_of_return
             *
             *         /  FV(positive cash flows, reinvestment rate) \  ^ (1 / (n - 1))
             * MIRR = |  ___________________________________________  |                 - 1
             *         \   - PV(negative cash flows, finance rate)   /
             *
             * with n the number of cash flows.
             *
             * You can compute FV and PV as :
             *
             * FV =    SUM      [ (cashFlow[i]>0 ? cashFlow[i] : 0) * (1 + rRate)**(n - i-1) ]
             *       i= 0 => n
             *
             * PV =    SUM      [ (cashFlow[i]<0 ? cashFlow[i] : 0) / (1 + fRate)**i ]
             *       i= 0 => n
             */
            let fv = 0;
            let pv = 0;
            for (const i of range(0, n)) {
                const amount = cashFlow[i];
                if (amount >= 0) {
                    fv += amount * (rRate + 1) ** (n - i - 1);
                }
                else {
                    pv += amount / (fRate + 1) ** i;
                }
            }
            assert(() => pv !== 0 && fv !== 0, _t("There must be both positive and negative values in cashflow_amounts."));
            const exponent = 1 / (n - 1);
            return (-fv / pv) ** exponent - 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // NOMINAL
    // -----------------------------------------------------------------------------
    const NOMINAL = {
        description: _t("Annual nominal interest rate."),
        args: [
            arg("effective_rate (number)", _t("The effective interest rate per year.")),
            arg("periods_per_year (number)", _t("The number of compounding periods per year.")),
        ],
        returns: ["NUMBER"],
        compute: function (effective_rate, periods_per_year) {
            const effective = toNumber(effective_rate, this.locale);
            const periods = Math.trunc(toNumber(periods_per_year, this.locale));
            assert(() => effective > 0, _t("The effective rate (%s) must must strictly greater than 0.", effective.toString()));
            assert(() => periods > 0, _t("The number of periods by year (%s) must strictly greater than 0.", periods.toString()));
            // https://en.wikipedia.org/wiki/Nominal_interest_rate#Nominal_versus_effective_interest_rate
            return (Math.pow(effective + 1, 1 / periods) - 1) * periods;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // NPER
    // -----------------------------------------------------------------------------
    const NPER = {
        description: _t("Number of payment periods for an investment."),
        args: [
            arg("rate (number)", _t("The interest rate.")),
            arg("payment_amount (number)", _t("The amount of each payment made.")),
            arg("present_value (number)", _t("The current value of the annuity.")),
            arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        ],
        returns: ["NUMBER"],
        compute: function (rate, paymentAmount, presentValue, futureValue = DEFAULT_FUTURE_VALUE, endOrBeginning = DEFAULT_END_OR_BEGINNING) {
            futureValue = futureValue || 0;
            endOrBeginning = endOrBeginning || 0;
            const r = toNumber(rate, this.locale);
            const p = toNumber(paymentAmount, this.locale);
            const pv = toNumber(presentValue, this.locale);
            const fv = toNumber(futureValue, this.locale);
            const t = toBoolean(endOrBeginning) ? 1 : 0;
            /**
             * https://wiki.documentfoundation.org/Documentation/Calc_Functions/NPER
             *
             * 0 = pv * (1 + r)^N + fv + [ p * (1 + r * t) * ((1 + r)^N - 1) ] / r
             *
             * We solve the equation for N:
             *
             * with C = [ p * (1 + r * t)] / r and
             *      R = 1 + r
             *
             * => 0 = pv * R^N + C * R^N - C + fv
             * <=> (C - fv) = R^N * (pv + C)
             * <=> log[(C - fv) / (pv + C)] = N * log(R)
             */
            if (r === 0) {
                return -(fv + pv) / p;
            }
            const c = (p * (1 + r * t)) / r;
            return Math.log((c - fv) / (pv + c)) / Math.log(1 + r);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // NPV
    // -----------------------------------------------------------------------------
    function npvResult(r, startValue, values, locale) {
        let i = 0;
        return reduceNumbers(values, (acc, v) => {
            i++;
            return acc + v / (1 + r) ** i;
        }, startValue, locale);
    }
    const NPV = {
        description: _t("The net present value of an investment based on a series of periodic cash flows and a discount rate."),
        args: [
            arg("discount (number)", _t("The discount rate of the investment over one period.")),
            arg("cashflow1 (number, range<number>)", _t("The first future cash flow.")),
            arg("cashflow2 (number, range<number>, repeating)", _t("Additional future cash flows.")),
        ],
        returns: ["NUMBER"],
        // to do: replace by dollar format
        computeFormat: () => "#,##0.00",
        compute: function (discount, ...values) {
            const _discount = toNumber(discount, this.locale);
            assert(() => _discount !== -1, _t("The discount (%s) must be different from -1.", _discount.toString()));
            return npvResult(_discount, 0, values, this.locale);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PDURATION
    // -----------------------------------------------------------------------------
    const PDURATION = {
        description: _t("Computes the number of periods needed for an investment to reach a value."),
        args: [
            arg("rate (number)", _t("The rate at which the investment grows each period.")),
            arg("present_value (number)", _t("The investment's current value.")),
            arg("future_value (number)", _t("The investment's desired future value.")),
        ],
        returns: ["NUMBER"],
        compute: function (rate, presentValue, futureValue) {
            const _rate = toNumber(rate, this.locale);
            const _presentValue = toNumber(presentValue, this.locale);
            const _futureValue = toNumber(futureValue, this.locale);
            assertRateStrictlyPositive(_rate);
            assert(() => _presentValue > 0, _t("The present_value (%s) must be strictly positive.", _presentValue.toString()));
            assert(() => _futureValue > 0, _t("The future_value (%s) must be strictly positive.", _futureValue.toString()));
            return (Math.log(_futureValue) - Math.log(_presentValue)) / Math.log(1 + _rate);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PMT
    // -----------------------------------------------------------------------------
    const PMT = {
        description: _t("Periodic payment for an annuity investment."),
        args: [
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("present_value (number)", _t("The current value of the annuity.")),
            arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        ],
        returns: ["NUMBER"],
        computeFormat: () => "#,##0.00",
        compute: function (rate, numberOfPeriods, presentValue, futureValue = DEFAULT_FUTURE_VALUE, endOrBeginning = DEFAULT_END_OR_BEGINNING) {
            futureValue = futureValue || 0;
            endOrBeginning = endOrBeginning || 0;
            const n = toNumber(numberOfPeriods, this.locale);
            const r = toNumber(rate, this.locale);
            const t = toBoolean(endOrBeginning) ? 1 : 0;
            let fv = toNumber(futureValue, this.locale);
            let pv = toNumber(presentValue, this.locale);
            assertNumberOfPeriodsStrictlyPositive(n);
            /**
             * https://wiki.documentfoundation.org/Documentation/Calc_Functions/PMT
             *
             * 0 = pv * (1 + r)^N + fv + [ p * (1 + r * t) * ((1 + r)^N - 1) ] / r
             *
             * We simply the equation for p
             */
            if (r === 0) {
                return -(fv + pv) / n;
            }
            let payment = -(pv * (1 + r) ** n + fv);
            payment = (payment * r) / ((1 + r * t) * ((1 + r) ** n - 1));
            return payment;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PPMT
    // -----------------------------------------------------------------------------
    const PPMT = {
        description: _t("Payment on the principal of an investment."),
        args: [
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("period (number)", _t("The amortization period, in terms of number of periods.")),
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("present_value (number)", _t("The current value of the annuity.")),
            arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        ],
        returns: ["NUMBER"],
        computeFormat: () => "#,##0.00",
        compute: function (rate, currentPeriod, numberOfPeriods, presentValue, futureValue = DEFAULT_FUTURE_VALUE, endOrBeginning = DEFAULT_END_OR_BEGINNING) {
            futureValue = futureValue || 0;
            endOrBeginning = endOrBeginning || 0;
            const n = toNumber(numberOfPeriods, this.locale);
            const r = toNumber(rate, this.locale);
            const period = toNumber(currentPeriod, this.locale);
            const type = toBoolean(endOrBeginning) ? 1 : 0;
            const fv = toNumber(futureValue, this.locale);
            const pv = toNumber(presentValue, this.locale);
            assertNumberOfPeriodsStrictlyPositive(n);
            assert(() => period > 0 && period <= n, _t("The period must be between 1 and number_of_periods", n.toString()));
            const payment = PMT.compute.bind(this)(r, n, pv, fv, endOrBeginning);
            if (type === 1 && period === 1)
                return payment;
            const eqPeriod = type === 0 ? period - 1 : period - 2;
            const eqPv = pv + payment * type;
            const capitalAtPeriod = -FV.compute.bind(this)(r, eqPeriod, payment, eqPv, 0);
            const currentInterest = capitalAtPeriod * r;
            return payment + currentInterest;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PV
    // -----------------------------------------------------------------------------
    const PV = {
        description: _t("Present value of an annuity investment."),
        args: [
            arg("rate (number)", _t("The interest rate.")),
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("payment_amount (number)", _t("The amount per period to be paid.")),
            arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
        ],
        returns: ["NUMBER"],
        // to do: replace by dollar format
        computeFormat: () => "#,##0.00",
        compute: function (rate, numberOfPeriods, paymentAmount, futureValue = DEFAULT_FUTURE_VALUE, endOrBeginning = DEFAULT_END_OR_BEGINNING) {
            futureValue = futureValue || 0;
            endOrBeginning = endOrBeginning || 0;
            const r = toNumber(rate, this.locale);
            const n = toNumber(numberOfPeriods, this.locale);
            const p = toNumber(paymentAmount, this.locale);
            const fv = toNumber(futureValue, this.locale);
            const type = toBoolean(endOrBeginning) ? 1 : 0;
            // https://wiki.documentfoundation.org/Documentation/Calc_Functions/PV
            return r ? -((p * (1 + r * type) * ((1 + r) ** n - 1)) / r + fv) / (1 + r) ** n : -(fv + p * n);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PRICE
    // -----------------------------------------------------------------------------
    const PRICE = {
        description: _t("Price of a security paying periodic interest."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("yield (number)", _t("The expected annual yield of the security.")),
            arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
            arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, rate, securityYield, redemption, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _rate = toNumber(rate, this.locale);
            const _yield = toNumber(securityYield, this.locale);
            const _redemption = toNumber(redemption, this.locale);
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
            assert(() => _yield >= 0, _t("The yield (%s) must be positive or null.", _yield.toString()));
            assertRedemptionStrictlyPositive(_redemption);
            const years = YEARFRAC.compute.bind(this)(_settlement, _maturity, _dayCountConvention);
            const nbrRealCoupons = years * _frequency;
            const nbrFullCoupons = Math.ceil(nbrRealCoupons);
            const timeFirstCoupon = nbrRealCoupons - Math.floor(nbrRealCoupons) || 1;
            const yieldFactorPerPeriod = 1 + _yield / _frequency;
            const cashFlowFromCoupon = (100 * _rate) / _frequency;
            if (nbrFullCoupons === 1) {
                return ((cashFlowFromCoupon + _redemption) / ((timeFirstCoupon * _yield) / _frequency + 1) -
                    cashFlowFromCoupon * (1 - timeFirstCoupon));
            }
            let cashFlowsPresentValue = 0;
            for (let i = 1; i <= nbrFullCoupons; i++) {
                cashFlowsPresentValue +=
                    cashFlowFromCoupon / yieldFactorPerPeriod ** (i - 1 + timeFirstCoupon);
            }
            const redemptionPresentValue = _redemption / yieldFactorPerPeriod ** (nbrFullCoupons - 1 + timeFirstCoupon);
            return (redemptionPresentValue + cashFlowsPresentValue - cashFlowFromCoupon * (1 - timeFirstCoupon));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PRICEDISC
    // -----------------------------------------------------------------------------
    const PRICEDISC = {
        description: _t("Price of a discount security."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("discount (number)", _t("The discount rate of the security at time of purchase.")),
            arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, discount, redemption, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _discount = toNumber(discount, this.locale);
            const _redemption = toNumber(redemption, this.locale);
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertDayCountConventionIsValid(_dayCountConvention);
            assertDiscountStrictlyPositive(_discount);
            assertRedemptionStrictlyPositive(_redemption);
            /**
             * https://support.microsoft.com/en-us/office/pricedisc-function-d06ad7c1-380e-4be7-9fd9-75e3079acfd3
             *
             * B = number of days in year, depending on year basis
             * DSM = number of days from settlement to maturity
             *
             * PRICEDISC = redemption - discount * redemption * (DSM/B)
             */
            const yearsFrac = YEARFRAC.compute.bind(this)(_settlement, _maturity, _dayCountConvention);
            return _redemption - _discount * _redemption * yearsFrac;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PRICEMAT
    // -----------------------------------------------------------------------------
    const PRICEMAT = {
        description: _t("Calculates the price of a security paying interest at maturity, based on expected yield."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("issue (date)", _t("The date the security was initially issued.")),
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("yield (number)", _t("The expected annual yield of the security.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, issue, rate, securityYield, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _issue = Math.trunc(toNumber(issue, this.locale));
            const _rate = toNumber(rate, this.locale);
            const _yield = toNumber(securityYield, this.locale);
            const _dayCount = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertSettlementAndIssueDatesAreValid(_settlement, _issue);
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertDayCountConventionIsValid(_dayCount);
            assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
            assert(() => _yield >= 0, _t("The yield (%s) must be positive or null.", _yield.toString()));
            /**
             * https://support.microsoft.com/en-us/office/pricemat-function-52c3b4da-bc7e-476a-989f-a95f675cae77
             *
             * B = number of days in year, depending on year basis
             * DSM = number of days from settlement to maturity
             * DIM = number of days from issue to maturity
             * DIS = number of days from issue to settlement
             *
             *             100 + (DIM/B * rate * 100)
             *  PRICEMAT =  __________________________   - (DIS/B * rate * 100)
             *              1 + (DSM/B * yield)
             *
             * The ratios number_of_days / days_in_year are computed using the YEARFRAC function, that handle
             * differences due to day count conventions.
             *
             * Compatibility note :
             *
             * Contrary to GSheet and OpenOffice, Excel doesn't seems to always use its own YEARFRAC function
             * to compute PRICEMAT, and give different values for some combinations of dates and day count
             * conventions ( notably for leap years and dayCountConvention = 1 (Actual/Actual)).
             *
             * Our function PRICEMAT give us the same results as LibreOffice Calc.
             * Google Sheet use the formula with YEARFRAC, but its YEARFRAC function results are different
             * from the results of Excel/LibreOffice, thus we get different values with PRICEMAT.
             *
             */
            const settlementToMaturity = YEARFRAC.compute.bind(this)(_settlement, _maturity, _dayCount);
            const issueToSettlement = YEARFRAC.compute.bind(this)(_settlement, _issue, _dayCount);
            const issueToMaturity = YEARFRAC.compute.bind(this)(_issue, _maturity, _dayCount);
            const numerator = 100 + issueToMaturity * _rate * 100;
            const denominator = 1 + settlementToMaturity * _yield;
            const term2 = issueToSettlement * _rate * 100;
            return numerator / denominator - term2;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // RATE
    // -----------------------------------------------------------------------------
    const RATE_GUESS_DEFAULT = 0.1;
    const RATE = {
        description: _t("Interest rate of an annuity investment."),
        args: [
            arg("number_of_periods (number)", _t("The number of payments to be made.")),
            arg("payment_per_period (number)", _t("The amount per period to be paid.")),
            arg("present_value (number)", _t("The current value of the annuity.")),
            arg(`future_value (number, default=${DEFAULT_FUTURE_VALUE})`, _t("The future value remaining after the final payment has been made.")),
            arg(`end_or_beginning (number, default=${DEFAULT_END_OR_BEGINNING})`, _t("Whether payments are due at the end (0) or beginning (1) of each period.")),
            arg(`rate_guess (number, default=${RATE_GUESS_DEFAULT})`, _t("An estimate for what the interest rate will be.")),
        ],
        returns: ["NUMBER"],
        computeFormat: () => "0%",
        compute: function (numberOfPeriods, paymentPerPeriod, presentValue, futureValue = DEFAULT_FUTURE_VALUE, endOrBeginning = DEFAULT_END_OR_BEGINNING, rateGuess = RATE_GUESS_DEFAULT) {
            futureValue = futureValue || 0;
            endOrBeginning = endOrBeginning || 0;
            rateGuess = rateGuess || RATE_GUESS_DEFAULT;
            const n = toNumber(numberOfPeriods, this.locale);
            const payment = toNumber(paymentPerPeriod, this.locale);
            const type = toBoolean(endOrBeginning) ? 1 : 0;
            const guess = toNumber(rateGuess, this.locale);
            let fv = toNumber(futureValue, this.locale);
            let pv = toNumber(presentValue, this.locale);
            assertNumberOfPeriodsStrictlyPositive(n);
            assert(() => [payment, pv, fv].some((val) => val > 0) && [payment, pv, fv].some((val) => val < 0), _t("There must be both positive and negative values in [payment_amount, present_value, future_value].", n.toString()));
            assertRateGuessStrictlyGreaterThanMinusOne(guess);
            fv -= payment * type;
            pv += payment * type;
            // https://github.com/apache/openoffice/blob/trunk/main/sc/source/core/tool/interpr2.cxx
            const func = (rate) => {
                const powN = Math.pow(1 + rate, n);
                const intResult = (powN - 1) / rate;
                return fv + pv * powN + payment * intResult;
            };
            const derivFunc = (rate) => {
                const powNMinus1 = Math.pow(1 + rate, n - 1);
                const powN = Math.pow(1 + rate, n);
                const intResult = (powN - 1) / rate;
                const intResultDeriv = (n * powNMinus1) / rate - intResult / rate;
                const fTermDerivation = pv * n * powNMinus1 + payment * intResultDeriv;
                return fTermDerivation;
            };
            return newtonMethod(func, derivFunc, guess, 40, 1e-5);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // RECEIVED
    // -----------------------------------------------------------------------------
    const RECEIVED = {
        description: _t("Amount received at maturity for a security."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("investment (number)", _t("The amount invested (irrespective of face value of each security).")),
            arg("discount (number)", _t("The discount rate of the security invested in.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, investment, discount, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _investment = toNumber(investment, this.locale);
            const _discount = toNumber(discount, this.locale);
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertDayCountConventionIsValid(_dayCountConvention);
            assertInvestmentStrictlyPositive(_investment);
            assertDiscountStrictlyPositive(_discount);
            /**
             * https://support.microsoft.com/en-us/office/received-function-7a3f8b93-6611-4f81-8576-828312c9b5e5
             *
             *                    investment
             * RECEIVED = _________________________
             *              1 - discount * DSM / B
             *
             * with DSM = number of days from settlement to maturity and B = number of days in a year
             *
             * The ratio DSM/B can be computed with the YEARFRAC function to take the dayCountConvention into account.
             */
            const yearsFrac = YEARFRAC.compute.bind(this)(_settlement, _maturity, _dayCountConvention);
            return _investment / (1 - _discount * yearsFrac);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // RRI
    // -----------------------------------------------------------------------------
    const RRI = {
        description: _t("Computes the rate needed for an investment to reach a specific value within a specific number of periods."),
        args: [
            arg("number_of_periods (number)", _t("The number of periods.")),
            arg("present_value (number)", _t("The present value of the investment.")),
            arg("future_value (number)", _t("The future value of the investment.")),
        ],
        returns: ["NUMBER"],
        compute: function (numberOfPeriods, presentValue, futureValue) {
            const n = toNumber(numberOfPeriods, this.locale);
            const pv = toNumber(presentValue, this.locale);
            const fv = toNumber(futureValue, this.locale);
            assertNumberOfPeriodsStrictlyPositive(n);
            /**
             * https://support.microsoft.com/en-us/office/rri-function-6f5822d8-7ef1-4233-944c-79e8172930f4
             *
             * RRI = (future value / present value) ^ (1 / number of periods) - 1
             */
            return (fv / pv) ** (1 / n) - 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SLN
    // -----------------------------------------------------------------------------
    const SLN = {
        description: _t("Depreciation of an asset using the straight-line method."),
        args: [
            arg("cost (number)", _t("The initial cost of the asset.")),
            arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
            arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
        ],
        returns: ["NUMBER"],
        computeFormat: () => "#,##0.00",
        compute: function (cost, salvage, life) {
            const _cost = toNumber(cost, this.locale);
            const _salvage = toNumber(salvage, this.locale);
            const _life = toNumber(life, this.locale);
            // No assertion is done on the values of the arguments to be compatible with Excel/Gsheet that don't check the values.
            // It's up to the user to make sure the arguments make sense, which is good design because the user is smart.
            return (_cost - _salvage) / _life;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SYD
    // -----------------------------------------------------------------------------
    const SYD = {
        description: _t("Depreciation via sum of years digit method."),
        args: [
            arg("cost (number)", _t("The initial cost of the asset.")),
            arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
            arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
            arg("period (number)", _t("The single period within life for which to calculate depreciation.")),
        ],
        returns: ["NUMBER"],
        computeFormat: () => "#,##0.00",
        compute: function (cost, salvage, life, period) {
            const _cost = toNumber(cost, this.locale);
            const _salvage = toNumber(salvage, this.locale);
            const _life = toNumber(life, this.locale);
            const _period = toNumber(period, this.locale);
            assertPeriodStrictlyPositive(_period);
            assertLifeStrictlyPositive(_life);
            assertPeriodSmallerOrEqualToLife(_period, _life);
            /**
             * This deprecation method use the sum of digits of the periods of the life as the deprecation factor.
             * For example for a life = 5, we have a deprecation factor or 1 + 2 + 3 + 4 + 5 = 15 = life * (life + 1) / 2 = F.
             *
             * The deprecation for a period p is then computed based on F and the remaining lifetime at the period P.
             *
             * deprecation = (cost - salvage) * (number of remaining periods / F)
             */
            const deprecFactor = (_life * (_life + 1)) / 2;
            const remainingPeriods = _life - _period + 1;
            return (_cost - _salvage) * (remainingPeriods / deprecFactor);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TBILLPRICE
    // -----------------------------------------------------------------------------
    const TBILLPRICE = {
        description: _t("Price of a US Treasury bill."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("discount (number)", _t("The discount rate of the bill at time of purchase.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, discount) {
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const disc = toNumber(discount, this.locale);
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertSettlementLessThanOneYearBeforeMaturity(start, end, this.locale);
            assertDiscountStrictlyPositive(disc);
            assertDiscountStrictlySmallerThanOne(disc);
            /**
             * https://support.microsoft.com/en-us/office/tbillprice-function-eacca992-c29d-425a-9eb8-0513fe6035a2
             *
             * TBILLPRICE = 100 * (1 - discount * DSM / 360)
             *
             * with DSM = number of days from settlement to maturity
             *
             * The ratio DSM/360 can be computed with the YEARFRAC function with dayCountConvention = 2 (actual/360).
             */
            const yearFrac = YEARFRAC.compute.bind(this)(start, end, 2);
            return 100 * (1 - disc * yearFrac);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TBILLEQ
    // -----------------------------------------------------------------------------
    const TBILLEQ = {
        description: _t("Equivalent rate of return for a US Treasury bill."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("discount (number)", _t("The discount rate of the bill at time of purchase.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, discount) {
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const disc = toNumber(discount, this.locale);
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertSettlementLessThanOneYearBeforeMaturity(start, end, this.locale);
            assertDiscountStrictlyPositive(disc);
            assertDiscountStrictlySmallerThanOne(disc);
            /**
             * https://support.microsoft.com/en-us/office/tbilleq-function-2ab72d90-9b4d-4efe-9fc2-0f81f2c19c8c
             *
             *               365 * discount
             * TBILLEQ = ________________________
             *            360 - discount * DSM
             *
             * with DSM = number of days from settlement to maturity
             *
             * What is not indicated in the Excel documentation is that this formula only works for duration between settlement
             * and maturity that are less than 6 months (182 days). This is because US Treasury bills use semi-annual interest,
             * and thus we have to take into account the compound interest for the calculation.
             *
             * For this case, the formula becomes (Treasury Securities and Derivatives, by Frank J. Fabozzi, page 49)
             *
             *            -2X + 2* SQRT[ X² - (2X - 1) * (1 - 100/p) ]
             * TBILLEQ = ________________________________________________
             *                            2X - 1
             *
             * with X = DSM / (number of days in a year),
             *  and p is the price, computed with TBILLPRICE
             *
             * Note that from my tests in Excel, we take (number of days in a year) = 366 ONLY if DSM is 366, not if
             * the settlement year is a leap year.
             *
             */
            const nDays = DAYS.compute.bind(this)(end, start);
            if (nDays <= 182) {
                return (365 * disc) / (360 - disc * nDays);
            }
            const p = TBILLPRICE.compute.bind(this)(start, end, disc) / 100;
            const daysInYear = nDays === 366 ? 366 : 365;
            const x = nDays / daysInYear;
            const num = -2 * x + 2 * Math.sqrt(x ** 2 - (2 * x - 1) * (1 - 1 / p));
            const denom = 2 * x - 1;
            return num / denom;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TBILLYIELD
    // -----------------------------------------------------------------------------
    const TBILLYIELD = {
        description: _t("The yield of a US Treasury bill based on price."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("price (number)", _t("The price at which the security is bought per 100 face value.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, price) {
            const start = Math.trunc(toNumber(settlement, this.locale));
            const end = Math.trunc(toNumber(maturity, this.locale));
            const p = toNumber(price, this.locale);
            assertMaturityAndSettlementDatesAreValid(start, end);
            assertSettlementLessThanOneYearBeforeMaturity(start, end, this.locale);
            assertPriceStrictlyPositive(p);
            /**
             * https://support.microsoft.com/en-us/office/tbillyield-function-6d381232-f4b0-4cd5-8e97-45b9c03468ba
             *
             *              100 - price     360
             * TBILLYIELD = ____________ * _____
             *                 price        DSM
             *
             * with DSM = number of days from settlement to maturity
             *
             * The ratio DSM/360 can be computed with the YEARFRAC function with dayCountConvention = 2 (actual/360).
             *
             */
            const yearFrac = YEARFRAC.compute.bind(this)(start, end, 2);
            return ((100 - p) / p) * (1 / yearFrac);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VDB
    // -----------------------------------------------------------------------------
    const DEFAULT_VDB_NO_SWITCH = false;
    const VDB = {
        description: _t("Variable declining balance. WARNING : does not handle decimal periods."),
        args: [
            arg("cost (number)", _t("The initial cost of the asset.")),
            arg("salvage (number)", _t("The value of the asset at the end of depreciation.")),
            arg("life (number)", _t("The number of periods over which the asset is depreciated.")),
            arg("start (number)", _t("Starting period to calculate depreciation.")),
            arg("end (number)", _t("Ending period to calculate depreciation.")),
            arg(`factor (number, default=${DEFAULT_DDB_DEPRECIATION_FACTOR})`, _t("The number of months in the first year of depreciation.")),
            arg(`no_switch (number, default=${DEFAULT_VDB_NO_SWITCH})`, _t("Whether to switch to straight-line depreciation when the depreciation is greater than the declining balance calculation.")),
        ],
        returns: ["NUMBER"],
        compute: function (cost, salvage, life, startPeriod, endPeriod, factor = DEFAULT_DDB_DEPRECIATION_FACTOR, noSwitch = DEFAULT_VDB_NO_SWITCH) {
            factor = factor || 0;
            const _cost = toNumber(cost, this.locale);
            const _salvage = toNumber(salvage, this.locale);
            const _life = toNumber(life, this.locale);
            /* TODO : handle decimal periods
             * on end_period it looks like it is a simple linear function, but I cannot understand exactly how
             * decimals periods are handled with start_period.
             */
            const _startPeriod = Math.trunc(toNumber(startPeriod, this.locale));
            const _endPeriod = Math.trunc(toNumber(endPeriod, this.locale));
            const _factor = toNumber(factor, this.locale);
            const _noSwitch = toBoolean(noSwitch);
            assertCostPositiveOrZero(_cost);
            assertSalvagePositiveOrZero(_salvage);
            assertStartAndEndPeriodAreValid(_startPeriod, _endPeriod, _life);
            assertDeprecationFactorStrictlyPositive(_factor);
            if (_cost === 0)
                return 0;
            if (_salvage >= _cost) {
                return _startPeriod < 1 ? _cost - _salvage : 0;
            }
            const doubleDeprecFactor = _factor / _life;
            if (doubleDeprecFactor >= 1) {
                return _startPeriod < 1 ? _cost - _salvage : 0;
            }
            let previousCost = _cost;
            let currentDeprec = 0;
            let resultDeprec = 0;
            let isLinearDeprec = false;
            for (let i = 0; i < _endPeriod; i++) {
                // compute the current deprecation, or keep the last one if we reached a stage of linear deprecation
                if (!isLinearDeprec || _noSwitch) {
                    const doubleDeprec = previousCost * doubleDeprecFactor;
                    const remainingPeriods = _life - i;
                    const linearDeprec = (previousCost - _salvage) / remainingPeriods;
                    if (!_noSwitch && linearDeprec > doubleDeprec) {
                        isLinearDeprec = true;
                        currentDeprec = linearDeprec;
                    }
                    else {
                        currentDeprec = doubleDeprec;
                    }
                }
                const nextCost = Math.max(previousCost - currentDeprec, _salvage);
                if (i >= _startPeriod) {
                    resultDeprec += previousCost - nextCost;
                }
                previousCost = nextCost;
            }
            return resultDeprec;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // XIRR
    // -----------------------------------------------------------------------------
    const XIRR = {
        description: _t("Internal rate of return given non-periodic cash flows."),
        args: [
            arg("cashflow_amounts (range<number>)", _t("An range containing the income or payments associated with the investment.")),
            arg("cashflow_dates (range<number>)", _t("An range with dates corresponding to the cash flows in cashflow_amounts.")),
            arg(`rate_guess (number, default=${RATE_GUESS_DEFAULT})`, _t("An estimate for what the internal rate of return will be.")),
        ],
        returns: ["NUMBER"],
        compute: function (cashflowAmounts, cashflowDates, rateGuess = RATE_GUESS_DEFAULT) {
            rateGuess = rateGuess || 0;
            const guess = toNumber(rateGuess, this.locale);
            const _cashFlows = cashflowAmounts.flat().map((val) => toNumber(val, this.locale));
            const _dates = cashflowDates.flat().map((val) => toNumber(val, this.locale));
            assertCashFlowsAndDatesHaveSameDimension(cashflowAmounts, cashflowDates);
            assertCashFlowsHavePositiveAndNegativesValues(_cashFlows);
            assertEveryDateGreaterThanFirstDateOfCashFlowDates(_dates);
            assertRateGuessStrictlyGreaterThanMinusOne(guess);
            const map = new Map();
            for (const i of range(0, _dates.length)) {
                const date = _dates[i];
                if (map.has(date))
                    map.set(date, map.get(date) + _cashFlows[i]);
                else
                    map.set(date, _cashFlows[i]);
            }
            const dates = Array.from(map.keys());
            const values = dates.map((date) => map.get(date));
            /**
             * https://support.microsoft.com/en-us/office/xirr-function-de1242ec-6477-445b-b11b-a303ad9adc9d
             *
             * The rate is computed iteratively by trying to solve the equation
             *
             *
             * 0 =    SUM     [ P_i * (1 + rate) ^((d_0 - d_i) / 365) ]  + P_0
             *     i = 1 => n
             *
             * with P_i = price number i
             *      d_i = date number i
             *
             * This function is not defined for rate < -1. For the case where we get rates < -1 in the Newton method, add
             * a fallback for a number very close to -1 to continue the Newton method.
             *
             */
            const func = (rate) => {
                let value = values[0];
                for (const i of range(1, values.length)) {
                    const dateDiff = (dates[0] - dates[i]) / 365;
                    value += values[i] * (1 + rate) ** dateDiff;
                }
                return value;
            };
            const derivFunc = (rate) => {
                let deriv = 0;
                for (const i of range(1, values.length)) {
                    const dateDiff = (dates[0] - dates[i]) / 365;
                    deriv += dateDiff * values[i] * (1 + rate) ** (dateDiff - 1);
                }
                return deriv;
            };
            const nanFallback = (previousFallback) => {
                // -0.9 => -0.99 => -0.999 => ...
                if (!previousFallback)
                    return -0.9;
                return previousFallback / 10 - 0.9;
            };
            return newtonMethod(func, derivFunc, guess, 40, 1e-5, nanFallback);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // XNPV
    // -----------------------------------------------------------------------------
    const XNPV = {
        description: _t("Net present value given to non-periodic cash flows.."),
        args: [
            arg("discount (number)", _t("The discount rate of the investment over one period.")),
            arg("cashflow_amounts (number, range<number>)", _t("An range containing the income or payments associated with the investment.")),
            arg("cashflow_dates (number, range<number>)", _t("An range with dates corresponding to the cash flows in cashflow_amounts.")),
        ],
        returns: ["NUMBER"],
        compute: function (discount, cashflowAmounts, cashflowDates) {
            const rate = toNumber(discount, this.locale);
            const _cashFlows = isMatrix(cashflowAmounts)
                ? cashflowAmounts.flat().map((val) => strictToNumber(val, this.locale))
                : [strictToNumber(cashflowAmounts, this.locale)];
            const _dates = isMatrix(cashflowDates)
                ? cashflowDates.flat().map((val) => strictToNumber(val, this.locale))
                : [strictToNumber(cashflowDates, this.locale)];
            if (isMatrix(cashflowDates) && isMatrix(cashflowAmounts)) {
                assertCashFlowsAndDatesHaveSameDimension(cashflowAmounts, cashflowDates);
            }
            else {
                assert(() => _cashFlows.length === _dates.length, _t("There must be the same number of values in cashflow_amounts and cashflow_dates."));
            }
            assertEveryDateGreaterThanFirstDateOfCashFlowDates(_dates);
            assertRateStrictlyPositive(rate);
            if (_cashFlows.length === 1)
                return _cashFlows[0];
            // aggregate values of the same date
            const map = new Map();
            for (const i of range(0, _dates.length)) {
                const date = _dates[i];
                if (map.has(date))
                    map.set(date, map.get(date) + _cashFlows[i]);
                else
                    map.set(date, _cashFlows[i]);
            }
            const dates = Array.from(map.keys());
            const values = dates.map((date) => map.get(date));
            /**
             * https://support.microsoft.com/en-us/office/xirr-function-de1242ec-6477-445b-b11b-a303ad9adc9d
             *
             * The present value is computed using
             *
             *
             * NPV =    SUM     [ P_i *(1 + rate) ^((d_0 - d_i) / 365) ]  + P_0
             *       i = 1 => n
             *
             * with P_i = price number i
             *      d_i = date number i
             *
             *
             */
            let pv = values[0];
            for (const i of range(1, values.length)) {
                const dateDiff = (dates[0] - dates[i]) / 365;
                pv += values[i] * (1 + rate) ** dateDiff;
            }
            return pv;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // YIELD
    // -----------------------------------------------------------------------------
    const YIELD = {
        description: _t("Annual yield of a security paying periodic interest."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("price (number)", _t("The price at which the security is bought per 100 face value.")),
            arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
            arg("frequency (number)", _t("The number of interest or coupon payments per year (1, 2, or 4).")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, rate, price, redemption, frequency, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _rate = toNumber(rate, this.locale);
            const _price = toNumber(price, this.locale);
            const _redemption = toNumber(redemption, this.locale);
            const _frequency = Math.trunc(toNumber(frequency, this.locale));
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertCouponFrequencyIsValid(_frequency);
            assertDayCountConventionIsValid(_dayCountConvention);
            assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
            assertPriceStrictlyPositive(_price);
            assertRedemptionStrictlyPositive(_redemption);
            const years = YEARFRAC.compute.bind(this)(_settlement, _maturity, _dayCountConvention);
            const nbrRealCoupons = years * _frequency;
            const nbrFullCoupons = Math.ceil(nbrRealCoupons);
            const timeFirstCoupon = nbrRealCoupons - Math.floor(nbrRealCoupons) || 1;
            const cashFlowFromCoupon = (100 * _rate) / _frequency;
            if (nbrFullCoupons === 1) {
                const subPart = _price + cashFlowFromCoupon * (1 - timeFirstCoupon);
                return (((_redemption + cashFlowFromCoupon - subPart) * _frequency * (1 / timeFirstCoupon)) /
                    subPart);
            }
            // The result of YIELD function is the yield at which the PRICE function will return the given price.
            // This algorithm uses the Newton's method on the PRICE function to determine the result.
            // Newton's method: https://en.wikipedia.org/wiki/Newton%27s_method
            // As the PRICE function isn't continuous, we apply the Newton's method on the numerator of the PRICE formula.
            // For simplicity, it is not yield but yieldFactorPerPeriod (= 1 + yield / frequency) which will be calibrated in Newton's method.
            // yield can be deduced from yieldFactorPerPeriod in sequence.
            function priceNumerator(price, timeFirstCoupon, nbrFullCoupons, yieldFactorPerPeriod, cashFlowFromCoupon, redemption) {
                let result = redemption -
                    (price + cashFlowFromCoupon * (1 - timeFirstCoupon)) *
                        yieldFactorPerPeriod ** (nbrFullCoupons - 1 + timeFirstCoupon);
                for (let i = 1; i <= nbrFullCoupons; i++) {
                    result += cashFlowFromCoupon * yieldFactorPerPeriod ** (i - 1);
                }
                return result;
            }
            function priceNumeratorDeriv(price, timeFirstCoupon, nbrFullCoupons, yieldFactorPerPeriod, cashFlowFromCoupon) {
                let result = -(price + cashFlowFromCoupon * (1 - timeFirstCoupon)) *
                    (nbrFullCoupons - 1 + timeFirstCoupon) *
                    yieldFactorPerPeriod ** (nbrFullCoupons - 2 + timeFirstCoupon);
                for (let i = 1; i <= nbrFullCoupons; i++) {
                    result += cashFlowFromCoupon * (i - 1) * yieldFactorPerPeriod ** (i - 2);
                }
                return result;
            }
            function func(x) {
                return priceNumerator(_price, timeFirstCoupon, nbrFullCoupons, x, cashFlowFromCoupon, _redemption);
            }
            function derivFunc(x) {
                return priceNumeratorDeriv(_price, timeFirstCoupon, nbrFullCoupons, x, cashFlowFromCoupon);
            }
            const initYield = _rate + 1;
            const initYieldFactorPerPeriod = 1 + initYield / _frequency;
            const methodResult = newtonMethod(func, derivFunc, initYieldFactorPerPeriod, 100, 1e-5);
            return (methodResult - 1) * _frequency;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // YIELDDISC
    // -----------------------------------------------------------------------------
    const YIELDDISC = {
        description: _t("Annual yield of a discount security."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("price (number)", _t("The price at which the security is bought per 100 face value.")),
            arg("redemption (number)", _t("The redemption amount per 100 face value, or par.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, price, redemption, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _price = toNumber(price, this.locale);
            const _redemption = toNumber(redemption, this.locale);
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertDayCountConventionIsValid(_dayCountConvention);
            assertPriceStrictlyPositive(_price);
            assertRedemptionStrictlyPositive(_redemption);
            /**
             * https://wiki.documentfoundation.org/Documentation/Calc_Functions/YIELDDISC
             *
             *                    (redemption / price) - 1
             * YIELDDISC = _____________________________________
             *             YEARFRAC(settlement, maturity, basis)
             */
            const yearFrac = YEARFRAC.compute.bind(this)(settlement, maturity, dayCountConvention);
            return (_redemption / _price - 1) / yearFrac;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // YIELDMAT
    // -----------------------------------------------------------------------------
    const YIELDMAT = {
        description: _t("Annual yield of a security paying interest at maturity."),
        args: [
            arg("settlement (date)", _t("The settlement date of the security, the date after issuance when the security is delivered to the buyer.")),
            arg("maturity (date)", _t("The maturity or end date of the security, when it can be redeemed at face, or par value.")),
            arg("issue (date)", _t("The date the security was initially issued.")),
            arg("rate (number)", _t("The annualized rate of interest.")),
            arg("price (number)", _t("The price at which the security is bought.")),
            arg(`day_count_convention (number, default=${DEFAULT_DAY_COUNT_CONVENTION} )`, _t("An indicator of what day count method to use.")),
        ],
        returns: ["NUMBER"],
        compute: function (settlement, maturity, issue, rate, price, dayCountConvention = DEFAULT_DAY_COUNT_CONVENTION) {
            dayCountConvention = dayCountConvention || 0;
            const _settlement = Math.trunc(toNumber(settlement, this.locale));
            const _maturity = Math.trunc(toNumber(maturity, this.locale));
            const _issue = Math.trunc(toNumber(issue, this.locale));
            const _rate = toNumber(rate, this.locale);
            const _price = toNumber(price, this.locale);
            const _dayCountConvention = Math.trunc(toNumber(dayCountConvention, this.locale));
            assertMaturityAndSettlementDatesAreValid(_settlement, _maturity);
            assertDayCountConventionIsValid(_dayCountConvention);
            assert(() => _settlement >= _issue, _t("The settlement (%s) must be greater than or equal to the issue (%s).", _settlement.toString(), _issue.toString()));
            assert(() => _rate >= 0, _t("The rate (%s) must be positive or null.", _rate.toString()));
            assertPriceStrictlyPositive(_price);
            const issueToMaturity = YEARFRAC.compute.bind(this)(_issue, _maturity, _dayCountConvention);
            const issueToSettlement = YEARFRAC.compute.bind(this)(_issue, _settlement, _dayCountConvention);
            const settlementToMaturity = YEARFRAC.compute.bind(this)(_settlement, _maturity, _dayCountConvention);
            const numerator = (100 * (1 + _rate * issueToMaturity)) / (_price + 100 * _rate * issueToSettlement) - 1;
            return numerator / settlementToMaturity;
        },
        isExported: true,
    };

    var financial = /*#__PURE__*/Object.freeze({
        __proto__: null,
        ACCRINTM: ACCRINTM,
        AMORLINC: AMORLINC,
        COUPDAYBS: COUPDAYBS,
        COUPDAYS: COUPDAYS,
        COUPDAYSNC: COUPDAYSNC,
        COUPNCD: COUPNCD,
        COUPNUM: COUPNUM,
        COUPPCD: COUPPCD,
        CUMIPMT: CUMIPMT,
        CUMPRINC: CUMPRINC,
        DB: DB,
        DDB: DDB,
        DISC: DISC,
        DOLLARDE: DOLLARDE,
        DOLLARFR: DOLLARFR,
        DURATION: DURATION,
        EFFECT: EFFECT,
        FV: FV,
        FVSCHEDULE: FVSCHEDULE,
        INTRATE: INTRATE,
        IPMT: IPMT,
        IRR: IRR,
        ISPMT: ISPMT,
        MDURATION: MDURATION,
        MIRR: MIRR,
        NOMINAL: NOMINAL,
        NPER: NPER,
        NPV: NPV,
        PDURATION: PDURATION,
        PMT: PMT,
        PPMT: PPMT,
        PRICE: PRICE,
        PRICEDISC: PRICEDISC,
        PRICEMAT: PRICEMAT,
        PV: PV,
        RATE: RATE,
        RECEIVED: RECEIVED,
        RRI: RRI,
        SLN: SLN,
        SYD: SYD,
        TBILLEQ: TBILLEQ,
        TBILLPRICE: TBILLPRICE,
        TBILLYIELD: TBILLYIELD,
        VDB: VDB,
        XIRR: XIRR,
        XNPV: XNPV,
        YIELD: YIELD,
        YIELDDISC: YIELDDISC,
        YIELDMAT: YIELDMAT
    });

    // -----------------------------------------------------------------------------
    // ISERR
    // -----------------------------------------------------------------------------
    const ISERR = {
        description: _t("Whether a value is an error other than #N/A."),
        args: [arg("value (any, lazy)", _t("The value to be verified as an error type."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            try {
                value();
                return false;
            }
            catch (e) {
                return e?.errorType != CellErrorType.NotAvailable;
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISERROR
    // -----------------------------------------------------------------------------
    const ISERROR = {
        description: _t("Whether a value is an error."),
        args: [arg("value (any, lazy)", _t("The value to be verified as an error type."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            try {
                value();
                return false;
            }
            catch (e) {
                return true;
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISLOGICAL
    // -----------------------------------------------------------------------------
    const ISLOGICAL = {
        description: _t("Whether a value is `true` or `false`."),
        args: [arg("value (any, lazy)", _t("The value to be verified as a logical TRUE or FALSE."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            try {
                return typeof value() === "boolean";
            }
            catch (e) {
                return false;
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISNA
    // -----------------------------------------------------------------------------
    const ISNA = {
        description: _t("Whether a value is the error #N/A."),
        args: [arg("value (any, lazy)", _t("The value to be verified as an error type."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            try {
                value();
                return false;
            }
            catch (e) {
                return e?.errorType === CellErrorType.NotAvailable;
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISNONTEXT
    // -----------------------------------------------------------------------------
    const ISNONTEXT = {
        description: _t("Whether a value is non-textual."),
        args: [arg("value (any, lazy)", _t("The value to be checked."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            try {
                return typeof value() !== "string";
            }
            catch (e) {
                return true;
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISNUMBER
    // -----------------------------------------------------------------------------
    const ISNUMBER = {
        description: _t("Whether a value is a number."),
        args: [arg("value (any, lazy)", _t("The value to be verified as a number."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            try {
                return typeof value() === "number";
            }
            catch (e) {
                return false;
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISTEXT
    // -----------------------------------------------------------------------------
    const ISTEXT = {
        description: _t("Whether a value is text."),
        args: [arg("value (any, lazy)", _t("The value to be verified as text."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            try {
                return typeof value() === "string";
            }
            catch (e) {
                return false;
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ISBLANK
    // -----------------------------------------------------------------------------
    const ISBLANK = {
        description: _t("Whether the referenced cell is empty"),
        args: [arg("value (any, lazy)", _t("Reference to the cell that will be checked for emptiness."))],
        returns: ["BOOLEAN"],
        compute: function (value) {
            try {
                const val = value();
                return val === null;
            }
            catch (e) {
                return false;
            }
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // NA
    // -----------------------------------------------------------------------------
    const NA = {
        description: _t("Returns the error value #N/A."),
        args: [],
        returns: ["BOOLEAN"],
        compute: function (value) {
            throw new NotAvailableError();
        },
        isExported: true,
    };

    var info = /*#__PURE__*/Object.freeze({
        __proto__: null,
        ISBLANK: ISBLANK,
        ISERR: ISERR,
        ISERROR: ISERROR,
        ISLOGICAL: ISLOGICAL,
        ISNA: ISNA,
        ISNONTEXT: ISNONTEXT,
        ISNUMBER: ISNUMBER,
        ISTEXT: ISTEXT,
        NA: NA
    });

    // -----------------------------------------------------------------------------
    // AND
    // -----------------------------------------------------------------------------
    const AND = {
        description: _t("Logical `and` operator."),
        args: [
            arg("logical_expression1 (boolean, range<boolean>)", _t("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
            arg("logical_expression2 (boolean, range<boolean>, repeating)", _t("More expressions that represent logical values.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (...logicalExpressions) {
            let foundBoolean = false;
            let acc = true;
            conditionalVisitBoolean(logicalExpressions, (arg) => {
                foundBoolean = true;
                acc = acc && arg;
                return acc;
            });
            assert(() => foundBoolean, _t("[[FUNCTION_NAME]] has no valid input data."));
            return acc;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FALSE
    // -----------------------------------------------------------------------------
    const FALSE = {
        description: _t("Logical value `false`."),
        args: [],
        returns: ["BOOLEAN"],
        compute: function () {
            return false;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // IF
    // -----------------------------------------------------------------------------
    const IF = {
        description: _t("Returns value depending on logical expression."),
        args: [
            arg("logical_expression (boolean)", _t("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE.")),
            arg("value_if_true (any, lazy)", _t("The value the function returns if logical_expression is TRUE.")),
            arg("value_if_false (any, lazy, default=FALSE)", _t("The value the function returns if logical_expression is FALSE.")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (logicalExpression, valueIfTrue, valueIfFalse = () => ({ value: false })) {
            const result = toBoolean(logicalExpression?.value) ? valueIfTrue() : valueIfFalse();
            if (result === undefined) {
                return { value: "" };
            }
            if (result.value === null) {
                result.value = "";
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // IFERROR
    // -----------------------------------------------------------------------------
    const IFERROR = {
        description: _t("Value if it is not an error, otherwise 2nd argument."),
        args: [
            arg("value (any, lazy)", _t("The value to return if value itself is not an error.")),
            arg(`value_if_error (any, lazy, default="empty")`, _t("The value the function returns if value is an error.")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (value, valueIfError = () => ({ value: "" })) {
            let result;
            try {
                result = value();
            }
            catch (e) {
                result = valueIfError();
            }
            if (result === undefined) {
                return { value: "" };
            }
            if (result.value === null) {
                result.value = "";
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // IFNA
    // -----------------------------------------------------------------------------
    const IFNA = {
        description: _t("Value if it is not an #N/A error, otherwise 2nd argument."),
        args: [
            arg("value (any, lazy)", _t("The value to return if value itself is not #N/A an error.")),
            arg(`value_if_error (any, lazy, default="empty")`, _t("The value the function returns if value is an #N/A error.")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (value, valueIfError = () => ({ value: "" })) {
            let result;
            try {
                result = value();
            }
            catch (e) {
                if (e.errorType === CellErrorType.NotAvailable) {
                    result = valueIfError();
                }
                else {
                    result = value();
                }
            }
            if (result === undefined) {
                return { value: "" };
            }
            if (result.value === null) {
                result.value = "";
            }
            return result;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // IFS
    // -----------------------------------------------------------------------------
    const IFS = {
        description: _t("Returns a value depending on multiple logical expressions."),
        args: [
            arg("condition1 (boolean, lazy)", _t("The first condition to be evaluated. This can be a boolean, a number, an array, or a reference to any of those.")),
            arg("value1 (any, lazy)", _t("The returned value if condition1 is TRUE.")),
            arg("condition2 (boolean, lazy, repeating)", _t("Additional conditions to be evaluated if the previous ones are FALSE.")),
            arg("value2 (any, lazy, repeating)", _t("Additional values to be returned if their corresponding conditions are TRUE.")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (...values) {
            assert(() => values.length % 2 === 0, _t("Wrong number of arguments. Expected an even number of arguments."));
            for (let n = 0; n < values.length - 1; n += 2) {
                if (toBoolean(values[n]()?.value)) {
                    const result = values[n + 1]();
                    if (result === undefined) {
                        return { value: "" };
                    }
                    if (result.value === null) {
                        result.value = "";
                    }
                    return result;
                }
            }
            throw new Error(_t("No match."));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // NOT
    // -----------------------------------------------------------------------------
    const NOT = {
        description: _t("Returns opposite of provided logical value."),
        args: [
            arg("logical_expression (boolean)", _t("An expression or reference to a cell holding an expression that represents some logical value.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (logicalExpression) {
            return !toBoolean(logicalExpression);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // OR
    // -----------------------------------------------------------------------------
    const OR = {
        description: _t("Logical `or` operator."),
        args: [
            arg("logical_expression1 (boolean, range<boolean>)", _t("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
            arg("logical_expression2 (boolean, range<boolean>, repeating)", _t("More expressions that evaluate to logical values.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (...logicalExpressions) {
            let foundBoolean = false;
            let acc = false;
            conditionalVisitBoolean(logicalExpressions, (arg) => {
                foundBoolean = true;
                acc = acc || arg;
                return !acc;
            });
            assert(() => foundBoolean, _t("[[FUNCTION_NAME]] has no valid input data."));
            return acc;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TRUE
    // -----------------------------------------------------------------------------
    const TRUE = {
        description: _t("Logical value `true`."),
        args: [],
        returns: ["BOOLEAN"],
        compute: function () {
            return true;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // XOR
    // -----------------------------------------------------------------------------
    const XOR = {
        description: _t("Logical `xor` operator."),
        args: [
            arg("logical_expression1 (boolean, range<boolean>)", _t("An expression or reference to a cell containing an expression that represents some logical value, i.e. TRUE or FALSE, or an expression that can be coerced to a logical value.")),
            arg("logical_expression2 (boolean, range<boolean>, repeating)", _t("More expressions that evaluate to logical values.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (...logicalExpressions) {
            let foundBoolean = false;
            let acc = false;
            conditionalVisitBoolean(logicalExpressions, (arg) => {
                foundBoolean = true;
                acc = acc ? !arg : arg;
                return true; // no stop condition
            });
            assert(() => foundBoolean, _t("[[FUNCTION_NAME]] has no valid input data."));
            return acc;
        },
        isExported: true,
    };

    var logical = /*#__PURE__*/Object.freeze({
        __proto__: null,
        AND: AND,
        FALSE: FALSE,
        IF: IF,
        IFERROR: IFERROR,
        IFNA: IFNA,
        IFS: IFS,
        NOT: NOT,
        OR: OR,
        TRUE: TRUE,
        XOR: XOR
    });

    const DEFAULT_IS_SORTED = true;
    const DEFAULT_MATCH_MODE = 0;
    const DEFAULT_SEARCH_MODE = 1;
    const DEFAULT_ABSOLUTE_RELATIVE_MODE = 1;
    function assertAvailable(variable, searchKey) {
        if (variable === undefined) {
            throw new NotAvailableError(_t("Did not find value '%s' in [[FUNCTION_NAME]] evaluation.", toString(searchKey)));
        }
    }
    // -----------------------------------------------------------------------------
    // ADDRESS
    // -----------------------------------------------------------------------------
    const ADDRESS = {
        description: _t("Returns a cell reference as a string. "),
        args: [
            arg("row (number)", _t("The row number of the cell reference. ")),
            arg("column (number)", _t("The column number (not name) of the cell reference. A is column number 1. ")),
            arg(`absolute_relative_mode (number, default=${DEFAULT_ABSOLUTE_RELATIVE_MODE})`, _t("An indicator of whether the reference is row/column absolute. 1 is row and column absolute (e.g. $A$1), 2 is row absolute and column relative (e.g. A$1), 3 is row relative and column absolute (e.g. $A1), and 4 is row and column relative (e.g. A1).")),
            arg("use_a1_notation (boolean, default=TRUE)", _t("A boolean indicating whether to use A1 style notation (TRUE) or R1C1 style notation (FALSE).")),
            arg("sheet (string, optional)", _t("A string indicating the name of the sheet into which the address points.")),
        ],
        returns: ["STRING"],
        compute: function (row, column, absoluteRelativeMode = DEFAULT_ABSOLUTE_RELATIVE_MODE, useA1Notation = true, sheet) {
            const rowNumber = strictToInteger(row, this.locale);
            const colNumber = strictToInteger(column, this.locale);
            assertNumberGreaterThanOrEqualToOne(rowNumber);
            assertNumberGreaterThanOrEqualToOne(colNumber);
            const _absoluteRelativeMode = strictToInteger(absoluteRelativeMode, this.locale);
            assert(() => [1, 2, 3, 4].includes(_absoluteRelativeMode), expectNumberRangeError(1, 4, _absoluteRelativeMode));
            const _useA1Notation = toBoolean(useA1Notation);
            let cellReference;
            if (_useA1Notation) {
                const rangePart = {
                    rowFixed: [1, 2].includes(_absoluteRelativeMode) ? true : false,
                    colFixed: [1, 3].includes(_absoluteRelativeMode) ? true : false,
                };
                cellReference = toXC(colNumber - 1, rowNumber - 1, rangePart);
            }
            else {
                const rowPart = [1, 2].includes(_absoluteRelativeMode) ? `R${rowNumber}` : `R[${rowNumber}]`;
                const colPart = [1, 3].includes(_absoluteRelativeMode) ? `C${colNumber}` : `C[${colNumber}]`;
                cellReference = rowPart + colPart;
            }
            if (sheet !== undefined) {
                return `${getCanonicalSheetName(toString(sheet))}!${cellReference}`;
            }
            return cellReference;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COLUMN
    // -----------------------------------------------------------------------------
    const COLUMN = {
        description: _t("Column number of a specified cell."),
        args: [
            arg("cell_reference (meta, default='this cell')", _t("The cell whose column number will be returned. Column A corresponds to 1. By default, the function use the cell in which the formula is entered.")),
        ],
        returns: ["NUMBER"],
        compute: function (cellReference) {
            const _cellReference = cellReference || this.__originCellXC?.();
            assert(() => !!_cellReference, "In this context, the function [[FUNCTION_NAME]] needs to have a cell or range in parameter.");
            const zone = toZone(_cellReference);
            return zone.left + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // COLUMNS
    // -----------------------------------------------------------------------------
    const COLUMNS = {
        description: _t("Number of columns in a specified array or range."),
        args: [arg("range (meta)", _t("The range whose column count will be returned."))],
        returns: ["NUMBER"],
        compute: function (range) {
            const zone = toZone(range);
            return zone.right - zone.left + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // HLOOKUP
    // -----------------------------------------------------------------------------
    const HLOOKUP = {
        description: _t("Horizontal lookup"),
        args: [
            arg("search_key (any)", _t("The value to search for. For example, 42, 'Cats', or I24.")),
            arg("range (any, range)", _t("The range to consider for the search. The first row in the range is searched for the key specified in search_key.")),
            arg("index (number)", _t("The row index of the value to be returned, where the first row in range is numbered 1.")),
            arg(`is_sorted (boolean, default=${DEFAULT_IS_SORTED})`, _t("Indicates whether the row to be searched (the first row of the specified range) is sorted, in which case the closest match for search_key will be returned.")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (searchKey, range, index, isSorted = { value: DEFAULT_IS_SORTED }) {
            const _index = Math.trunc(toNumber(index?.value, this.locale));
            const _range = toMatrix(range);
            assert(() => 1 <= _index && _index <= _range[0].length, _t("[[FUNCTION_NAME]] evaluates to an out of bounds range."));
            const getValueFromRange = (range, index) => range[index][0].value;
            const _isSorted = toBoolean(isSorted.value);
            const colIndex = _isSorted
                ? dichotomicSearch(_range, searchKey?.value, "nextSmaller", "asc", _range.length, getValueFromRange)
                : linearSearch(_range, searchKey?.value, "strict", _range.length, getValueFromRange);
            const col = _range[colIndex];
            assertAvailable(col, searchKey?.value);
            return col[_index - 1];
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // INDEX
    // -----------------------------------------------------------------------------
    const INDEX = {
        description: _t("Returns the content of a cell, specified by row and column offset."),
        args: [
            arg("reference (any, range)", _t("The range of cells from which the values are returned.")),
            arg("row (number, default=0)", _t("The index of the row to be returned from within the reference range of cells.")),
            arg("column (number, default=0)", _t("The index of the column to be returned from within the reference range of cells.")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (reference, row = { value: 0 }, column = { value: 0 }) {
            const _reference = isMatrix(reference) ? reference : [[reference]];
            const _row = toNumber(row.value, this.locale);
            const _column = toNumber(column.value, this.locale);
            assert(() => _column >= 0 &&
                _column - 1 < _reference.length &&
                _row >= 0 &&
                _row - 1 < _reference[0].length, _t("Index out of range."));
            if (_row === 0 && _column === 0) {
                return _reference;
            }
            if (_row === 0) {
                return [_reference[_column - 1]];
            }
            if (_column === 0) {
                return _reference.map((col) => [col[_row - 1]]);
            }
            return _reference[_column - 1][_row - 1];
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // LOOKUP
    // -----------------------------------------------------------------------------
    const LOOKUP = {
        description: _t("Look up a value."),
        args: [
            arg("search_key (any)", _t("The value to search for. For example, 42, 'Cats', or I24.")),
            arg("search_array (any, range)", _t("One method of using this function is to provide a single sorted row or column search_array to look through for the search_key with a second argument result_range. The other way is to combine these two arguments into one search_array where the first row or column is searched and a value is returned from the last row or column in the array. If search_key is not found, a non-exact match may be returned.")),
            arg("result_range (any, range, optional)", _t("The range from which to return a result. The value returned corresponds to the location where search_key is found in search_range. This range must be only a single row or column and should not be used if using the search_result_array method.")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (searchKey, searchArray, resultRange) {
            const _searchArray = toMatrix(searchArray);
            const _resultRange = toMatrix(resultRange);
            let nbCol = _searchArray.length;
            let nbRow = _searchArray[0].length;
            const verticalSearch = nbRow >= nbCol;
            const getElement = verticalSearch
                ? (range, index) => range[0][index].value
                : (range, index) => range[index][0].value;
            const rangeLength = verticalSearch ? nbRow : nbCol;
            const index = dichotomicSearch(_searchArray, searchKey?.value, "nextSmaller", "asc", rangeLength, getElement);
            if (index === -1)
                assertAvailable(undefined, searchKey?.value);
            verticalSearch
                ? assertAvailable(_searchArray[0][index], searchKey?.value)
                : assertAvailable(_searchArray[index][nbRow - 1], searchKey?.value);
            if (_resultRange[0].length === 0) {
                return verticalSearch ? _searchArray[nbCol - 1][index] : _searchArray[index][nbRow - 1];
            }
            nbCol = _resultRange.length;
            nbRow = _resultRange[0].length;
            assert(() => nbCol === 1 || nbRow === 1, _t("The result_range must be a single row or a single column."));
            if (nbCol > 1) {
                assert(() => index <= nbCol - 1, _t("[[FUNCTION_NAME]] evaluates to an out of range row value %s.", (index + 1).toString()));
                return _resultRange[index][0];
            }
            assert(() => index <= nbRow - 1, _t("[[FUNCTION_NAME]] evaluates to an out of range column value %s.", (index + 1).toString()));
            return _resultRange[0][index];
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MATCH
    // -----------------------------------------------------------------------------
    const DEFAULT_SEARCH_TYPE = 1;
    const MATCH = {
        description: _t("Position of item in range that matches value."),
        args: [
            arg("search_key (any)", _t("The value to search for. For example, 42, 'Cats', or I24.")),
            arg("range (any, range)", _t("The one-dimensional array to be searched.")),
            arg(`search_type (number, default=${DEFAULT_SEARCH_TYPE})`, _t("The search method. 1 (default) finds the largest value less than or equal to search_key when range is sorted in ascending order. 0 finds the exact value when range is unsorted. -1 finds the smallest value greater than or equal to search_key when range is sorted in descending order.")),
        ],
        returns: ["NUMBER"],
        compute: function (searchKey, range, searchType = DEFAULT_SEARCH_TYPE) {
            let _searchType = toNumber(searchType, this.locale);
            const _range = toMatrix(range);
            const nbCol = _range.length;
            const nbRow = _range[0].length;
            assert(() => nbCol === 1 || nbRow === 1, _t("The range must be a single row or a single column."));
            let index = -1;
            const getElement = nbCol === 1
                ? (_range, index) => _range[0][index]
                : (_range, index) => _range[index][0];
            const rangeLen = nbCol === 1 ? _range[0].length : _range.length;
            _searchType = Math.sign(_searchType);
            switch (_searchType) {
                case 1:
                    index = dichotomicSearch(_range, searchKey, "nextSmaller", "asc", rangeLen, getElement);
                    break;
                case 0:
                    index = linearSearch(_range, searchKey, "strict", rangeLen, getElement);
                    break;
                case -1:
                    index = dichotomicSearch(_range, searchKey, "nextGreater", "desc", rangeLen, getElement);
                    break;
            }
            assertAvailable(nbCol === 1 ? _range[0][index] : _range[index], searchKey);
            return index + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ROW
    // -----------------------------------------------------------------------------
    const ROW = {
        description: _t("Row number of a specified cell."),
        args: [
            arg("cell_reference (meta, default='this cell')", _t("The cell whose row number will be returned. By default, this function uses the cell in which the formula is entered.")),
        ],
        returns: ["NUMBER"],
        compute: function (cellReference) {
            cellReference = cellReference || this.__originCellXC?.();
            assert(() => !!cellReference, "In this context, the function [[FUNCTION_NAME]] needs to have a cell or range in parameter.");
            const zone = toZone(cellReference);
            return zone.top + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // ROWS
    // -----------------------------------------------------------------------------
    const ROWS = {
        description: _t("Number of rows in a specified array or range."),
        args: [arg("range (meta)", _t("The range whose row count will be returned."))],
        returns: ["NUMBER"],
        compute: function (range) {
            const zone = toZone(range);
            return zone.bottom - zone.top + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VLOOKUP
    // -----------------------------------------------------------------------------
    const VLOOKUP = {
        description: _t("Vertical lookup."),
        args: [
            arg("search_key (any)", _t("The value to search for. For example, 42, 'Cats', or I24.")),
            arg("range (any, range)", _t("The range to consider for the search. The first column in the range is searched for the key specified in search_key.")),
            arg("index (number)", _t("The column index of the value to be returned, where the first column in range is numbered 1.")),
            arg(`is_sorted (boolean, default=${DEFAULT_IS_SORTED})`, _t("Indicates whether the column to be searched (the first column of the specified range) is sorted, in which case the closest match for search_key will be returned.")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (searchKey, range, index, isSorted = { value: DEFAULT_IS_SORTED }) {
            const _index = Math.trunc(toNumber(index?.value, this.locale));
            const _range = toMatrix(range);
            assert(() => 1 <= _index && _index <= _range.length, _t("[[FUNCTION_NAME]] evaluates to an out of bounds range."));
            const getValueFromRange = (range, index) => range[0][index].value;
            const _isSorted = toBoolean(isSorted.value);
            const rowIndex = _isSorted
                ? dichotomicSearch(_range, searchKey?.value, "nextSmaller", "asc", _range[0].length, getValueFromRange)
                : linearSearch(_range, searchKey?.value, "strict", _range[0].length, getValueFromRange);
            const value = _range[_index - 1][rowIndex];
            assertAvailable(value, searchKey?.value);
            return value;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // XLOOKUP
    // -----------------------------------------------------------------------------
    const XLOOKUP = {
        description: _t("Search a range for a match and return the corresponding item from a second range."),
        args: [
            arg("search_key (any)", _t("The value to search for.")),
            arg("lookup_range (any, range)", _t("The range to consider for the search. Should be a single column or a single row.")),
            arg("return_range (any, range)", _t("The range containing the return value. Should have the same dimensions as lookup_range.")),
            arg("if_not_found (any, lazy, optional)", _t("If a valid match is not found, return this value.")),
            arg(`match_mode (any, default=${DEFAULT_MATCH_MODE})`, _t("(0) Exact match. (-1) Return next smaller item if no match. (1) Return next greater item if no match.")),
            arg(`search_mode (any, default=${DEFAULT_SEARCH_MODE})`, _t("(1) Search starting at first item. \
      (-1) Search starting at last item. \
      (2) Perform a binary search that relies on lookup_array being sorted in ascending order. If not sorted, invalid results will be returned. \
      (-2) Perform a binary search that relies on lookup_array being sorted in descending order. If not sorted, invalid results will be returned.\
      ")),
        ],
        returns: ["ANY"],
        computeValueAndFormat: function (searchKey, lookupRange, returnRange, defaultValue, matchMode = { value: DEFAULT_MATCH_MODE }, searchMode = { value: DEFAULT_SEARCH_MODE }) {
            const _matchMode = Math.trunc(toNumber(matchMode.value, this.locale));
            const _searchMode = Math.trunc(toNumber(searchMode.value, this.locale));
            const _lookupRange = toMatrix(lookupRange);
            const _returnRange = toMatrix(returnRange);
            assert(() => _lookupRange.length === 1 || _lookupRange[0].length === 1, _t("lookup_range should be either a single row or single column."));
            assert(() => [-1, 1, -2, 2].includes(_searchMode), _t("searchMode should be a value in [-1, 1, -2, 2]."));
            assert(() => [-1, 0, 1].includes(_matchMode), _t("matchMode should be a value in [-1, 0, 1]."));
            const lookupDirection = _lookupRange.length === 1 ? "col" : "row";
            assert(() => lookupDirection === "col"
                ? _returnRange[0].length === _lookupRange[0].length
                : _returnRange.length === _lookupRange.length, _t("return_range should have the same dimensions as lookup_range."));
            const getElement = lookupDirection === "col"
                ? (range, index) => range[0][index].value
                : (range, index) => range[index][0].value;
            const rangeLen = lookupDirection === "col" ? _lookupRange[0].length : _lookupRange.length;
            const mode = _matchMode === 0 ? "strict" : _matchMode === 1 ? "nextGreater" : "nextSmaller";
            const reverseSearch = _searchMode === -1;
            const index = _searchMode === 2 || _searchMode === -2
                ? dichotomicSearch(_lookupRange, searchKey?.value, mode, _searchMode === 2 ? "asc" : "desc", rangeLen, getElement)
                : linearSearch(_lookupRange, searchKey?.value, mode, rangeLen, getElement, reverseSearch);
            if (index !== -1) {
                return lookupDirection === "col"
                    ? _returnRange.map((col) => [col[index]])
                    : [_returnRange[index]];
            }
            const _defaultValue = defaultValue?.();
            assertAvailable(_defaultValue, searchKey?.value);
            return [[_defaultValue]];
        },
        isExported: true,
    };

    var lookup = /*#__PURE__*/Object.freeze({
        __proto__: null,
        ADDRESS: ADDRESS,
        COLUMN: COLUMN,
        COLUMNS: COLUMNS,
        HLOOKUP: HLOOKUP,
        INDEX: INDEX,
        LOOKUP: LOOKUP,
        MATCH: MATCH,
        ROW: ROW,
        ROWS: ROWS,
        VLOOKUP: VLOOKUP,
        XLOOKUP: XLOOKUP
    });

    // -----------------------------------------------------------------------------
    // ADD
    // -----------------------------------------------------------------------------
    const ADD = {
        description: _t("Sum of two numbers."),
        args: [
            arg("value1 (number)", _t("The first addend.")),
            arg("value2 (number)", _t("The second addend.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1, value2) => value1?.format || value2?.format,
        compute: function (value1, value2) {
            return toNumber(value1, this.locale) + toNumber(value2, this.locale);
        },
    };
    // -----------------------------------------------------------------------------
    // CONCAT
    // -----------------------------------------------------------------------------
    const CONCAT = {
        description: _t("Concatenation of two values."),
        args: [
            arg("value1 (string)", _t("The value to which value2 will be appended.")),
            arg("value2 (string)", _t("The value to append to value1.")),
        ],
        returns: ["STRING"],
        compute: function (value1, value2) {
            return toString(value1) + toString(value2);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // DIVIDE
    // -----------------------------------------------------------------------------
    const DIVIDE = {
        description: _t("One number divided by another."),
        args: [
            arg("dividend (number)", _t("The number to be divided.")),
            arg("divisor (number)", _t("The number to divide by.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (dividend, divisor) => dividend?.format || divisor?.format,
        compute: function (dividend, divisor) {
            const _divisor = toNumber(divisor, this.locale);
            assert(() => _divisor !== 0, _t("The divisor must be different from zero."));
            return toNumber(dividend, this.locale) / _divisor;
        },
    };
    // -----------------------------------------------------------------------------
    // EQ
    // -----------------------------------------------------------------------------
    function isEmpty(value) {
        return value === null || value === undefined;
    }
    const getNeutral = { number: 0, string: "", boolean: false };
    function areAlmostEqual(value1, value2, epsilon = 2e-16) {
        return Math.abs(value1 - value2) < epsilon;
    }
    const EQ = {
        description: _t("Equal."),
        args: [
            arg("value1 (any)", _t("The first value.")),
            arg("value2 (any)", _t("The value to test against value1 for equality.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (value1, value2) {
            value1 = isEmpty(value1) ? getNeutral[typeof value2] : value1;
            value2 = isEmpty(value2) ? getNeutral[typeof value1] : value2;
            if (typeof value1 === "string") {
                value1 = value1.toUpperCase();
            }
            if (typeof value2 === "string") {
                value2 = value2.toUpperCase();
            }
            if (typeof value1 === "number" && typeof value2 === "number") {
                return areAlmostEqual(value1, value2);
            }
            return value1 === value2;
        },
    };
    // -----------------------------------------------------------------------------
    // GT
    // -----------------------------------------------------------------------------
    function applyRelationalOperator(value1, value2, cb) {
        value1 = isEmpty(value1) ? getNeutral[typeof value2] : value1;
        value2 = isEmpty(value2) ? getNeutral[typeof value1] : value2;
        if (typeof value1 !== "number") {
            value1 = toString(value1).toUpperCase();
        }
        if (typeof value2 !== "number") {
            value2 = toString(value2).toUpperCase();
        }
        const tV1 = typeof value1;
        const tV2 = typeof value2;
        if (tV1 === "string" && tV2 === "number") {
            return true;
        }
        if (tV2 === "string" && tV1 === "number") {
            return false;
        }
        return cb(value1, value2);
    }
    const GT = {
        description: _t("Strictly greater than."),
        args: [
            arg("value1 (any)", _t("The value to test as being greater than value2.")),
            arg("value2 (any)", _t("The second value.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (value1, value2) {
            return applyRelationalOperator(value1, value2, (v1, v2) => {
                if (typeof v1 === "number" && typeof v2 === "number") {
                    return !areAlmostEqual(v1, v2) && v1 > v2;
                }
                return v1 > v2;
            });
        },
    };
    // -----------------------------------------------------------------------------
    // GTE
    // -----------------------------------------------------------------------------
    const GTE = {
        description: _t("Greater than or equal to."),
        args: [
            arg("value1 (any)", _t("The value to test as being greater than or equal to value2.")),
            arg("value2 (any)", _t("The second value.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (value1, value2) {
            return applyRelationalOperator(value1, value2, (v1, v2) => {
                if (typeof v1 === "number" && typeof v2 === "number") {
                    return areAlmostEqual(v1, v2) || v1 > v2;
                }
                return v1 >= v2;
            });
        },
    };
    // -----------------------------------------------------------------------------
    // LT
    // -----------------------------------------------------------------------------
    const LT = {
        description: _t("Less than."),
        args: [
            arg("value1 (any)", _t("The value to test as being less than value2.")),
            arg("value2 (any)", _t("The second value.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (value1, value2) {
            return !GTE.compute.bind(this)(value1, value2);
        },
    };
    // -----------------------------------------------------------------------------
    // LTE
    // -----------------------------------------------------------------------------
    const LTE = {
        description: _t("Less than or equal to."),
        args: [
            arg("value1 (any)", _t("The value to test as being less than or equal to value2.")),
            arg("value2 (any)", _t("The second value.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (value1, value2) {
            return !GT.compute.bind(this)(value1, value2);
        },
    };
    // -----------------------------------------------------------------------------
    // MINUS
    // -----------------------------------------------------------------------------
    const MINUS = {
        description: _t("Difference of two numbers."),
        args: [
            arg("value1 (number)", _t("The minuend, or number to be subtracted from.")),
            arg("value2 (number)", _t("The subtrahend, or number to subtract from value1.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (value1, value2) => value1?.format || value2?.format,
        compute: function (value1, value2) {
            return toNumber(value1, this.locale) - toNumber(value2, this.locale);
        },
    };
    // -----------------------------------------------------------------------------
    // MULTIPLY
    // -----------------------------------------------------------------------------
    const MULTIPLY = {
        description: _t("Product of two numbers"),
        args: [
            arg("factor1 (number)", _t("The first multiplicand.")),
            arg("factor2 (number)", _t("The second multiplicand.")),
        ],
        returns: ["NUMBER"],
        computeFormat: (factor1, factor2) => factor1?.format || factor2?.format,
        compute: function (factor1, factor2) {
            return toNumber(factor1, this.locale) * toNumber(factor2, this.locale);
        },
    };
    // -----------------------------------------------------------------------------
    // NE
    // -----------------------------------------------------------------------------
    const NE = {
        description: _t("Not equal."),
        args: [
            arg("value1 (any)", _t("The first value.")),
            arg("value2 (any)", _t("The value to test against value1 for inequality.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (value1, value2) {
            return !EQ.compute.bind(this)(value1, value2);
        },
    };
    // -----------------------------------------------------------------------------
    // POW
    // -----------------------------------------------------------------------------
    const POW = {
        description: _t("A number raised to a power."),
        args: [
            arg("base (number)", _t("The number to raise to the exponent power.")),
            arg("exponent (number)", _t("The exponent to raise base to.")),
        ],
        returns: ["NUMBER"],
        compute: function (base, exponent) {
            return POWER.compute.bind(this)(base, exponent);
        },
    };
    // -----------------------------------------------------------------------------
    // UMINUS
    // -----------------------------------------------------------------------------
    const UMINUS = {
        description: _t("A number with the sign reversed."),
        args: [
            arg("value (number)", _t("The number to have its sign reversed. Equivalently, the number to multiply by -1.")),
        ],
        computeFormat: (value) => value?.format,
        returns: ["NUMBER"],
        compute: function (value) {
            return -toNumber(value, this.locale);
        },
    };
    // -----------------------------------------------------------------------------
    // UNARY_PERCENT
    // -----------------------------------------------------------------------------
    const UNARY_PERCENT = {
        description: _t("Value interpreted as a percentage."),
        args: [arg("percentage (number)", _t("The value to interpret as a percentage."))],
        returns: ["NUMBER"],
        compute: function (percentage) {
            return toNumber(percentage, this.locale) / 100;
        },
    };
    // -----------------------------------------------------------------------------
    // UPLUS
    // -----------------------------------------------------------------------------
    const UPLUS = {
        description: _t("A specified number, unchanged."),
        args: [arg("value (any)", _t("The number to return."))],
        returns: ["ANY"],
        computeFormat: (value) => value?.format,
        compute: function (value = "") {
            return value === null ? "" : value;
        },
    };

    var operators = /*#__PURE__*/Object.freeze({
        __proto__: null,
        ADD: ADD,
        CONCAT: CONCAT,
        DIVIDE: DIVIDE,
        EQ: EQ,
        GT: GT,
        GTE: GTE,
        LT: LT,
        LTE: LTE,
        MINUS: MINUS,
        MULTIPLY: MULTIPLY,
        NE: NE,
        POW: POW,
        UMINUS: UMINUS,
        UNARY_PERCENT: UNARY_PERCENT,
        UPLUS: UPLUS
    });

    const DEFAULT_STARTING_AT = 1;
    /** Regex matching all the words in a string */
    const wordRegex = /[A-Za-zÀ-ÖØ-öø-ÿ]+/g;
    // -----------------------------------------------------------------------------
    // CHAR
    // -----------------------------------------------------------------------------
    const CHAR = {
        description: _t("Gets character associated with number."),
        args: [
            arg("table_number (number)", _t("The number of the character to look up from the current Unicode table in decimal format.")),
        ],
        returns: ["STRING"],
        compute: function (tableNumber) {
            const _tableNumber = Math.trunc(toNumber(tableNumber, this.locale));
            assert(() => _tableNumber >= 1, _t("The table_number (%s) is out of range.", _tableNumber.toString()));
            return String.fromCharCode(_tableNumber);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CLEAN
    // -----------------------------------------------------------------------------
    const CLEAN = {
        description: _t("Remove non-printable characters from a piece of text."),
        args: [arg("text (string)", _t("The text whose non-printable characters are to be removed."))],
        returns: ["STRING"],
        compute: function (text) {
            const _text = toString(text);
            let cleanedStr = "";
            for (const char of _text) {
                if (char && char.charCodeAt(0) > 31) {
                    cleanedStr += char;
                }
            }
            return cleanedStr;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // CONCATENATE
    // -----------------------------------------------------------------------------
    const CONCATENATE = {
        description: _t("Appends strings to one another."),
        args: [
            arg("string1 (string, range<string>)", _t("The initial string.")),
            arg("string2 (string, range<string>, repeating)", _t("More strings to append in sequence.")),
        ],
        returns: ["STRING"],
        compute: function (...values) {
            return reduceAny(values, (acc, a) => acc + toString(a), "");
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // EXACT
    // -----------------------------------------------------------------------------
    const EXACT = {
        description: _t("Tests whether two strings are identical."),
        args: [
            arg("string1 (string)", _t("The first string to compare.")),
            arg("string2 (string)", _t("The second string to compare.")),
        ],
        returns: ["BOOLEAN"],
        compute: function (string1, string2) {
            return toString(string1) === toString(string2);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // FIND
    // -----------------------------------------------------------------------------
    const FIND = {
        description: _t("First position of string found in text, case-sensitive."),
        args: [
            arg("search_for (string)", _t("The string to look for within text_to_search.")),
            arg("text_to_search (string)", _t("The text to search for the first occurrence of search_for.")),
            arg(`starting_at (number, default=${DEFAULT_STARTING_AT})`, _t("The character within text_to_search at which to start the search.")),
        ],
        returns: ["NUMBER"],
        compute: function (searchFor, textToSearch, startingAt = DEFAULT_STARTING_AT) {
            const _searchFor = toString(searchFor);
            const _textToSearch = toString(textToSearch);
            const _startingAt = toNumber(startingAt, this.locale);
            assert(() => _textToSearch !== "", _t("The text_to_search must be non-empty."));
            assert(() => _startingAt >= 1, _t("The starting_at (%s) must be greater than or equal to 1.", _startingAt.toString()));
            const result = _textToSearch.indexOf(_searchFor, _startingAt - 1);
            assert(() => result >= 0, _t("In [[FUNCTION_NAME]] evaluation, cannot find '%s' within '%s'.", _searchFor.toString(), _textToSearch));
            return result + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // JOIN
    // -----------------------------------------------------------------------------
    const JOIN = {
        description: _t("Concatenates elements of arrays with delimiter."),
        args: [
            arg("delimiter (string)", _t("The character or string to place between each concatenated value.")),
            arg("value_or_array1 (string, range<string>)", _t("The value or values to be appended using delimiter.")),
            arg("value_or_array2 (string, range<string>, repeating)", _t("More values to be appended using delimiter.")),
        ],
        returns: ["STRING"],
        compute: function (delimiter, ...valuesOrArrays) {
            const _delimiter = toString(delimiter);
            return reduceAny(valuesOrArrays, (acc, a) => (acc ? acc + _delimiter : "") + toString(a), "");
        },
    };
    // -----------------------------------------------------------------------------
    // LEFT
    // -----------------------------------------------------------------------------
    const LEFT = {
        description: _t("Substring from beginning of specified string."),
        args: [
            arg("text (string)", _t("The string from which the left portion will be returned.")),
            arg("number_of_characters (number, optional)", _t("The number of characters to return from the left side of string.")),
        ],
        returns: ["STRING"],
        compute: function (text, ...args) {
            const _numberOfCharacters = args.length ? toNumber(args[0], this.locale) : 1;
            assert(() => _numberOfCharacters >= 0, _t("The number_of_characters (%s) must be positive or null.", _numberOfCharacters.toString()));
            return toString(text).substring(0, _numberOfCharacters);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // LEN
    // -----------------------------------------------------------------------------
    const LEN = {
        description: _t("Length of a string."),
        args: [arg("text (string)", _t("The string whose length will be returned."))],
        returns: ["NUMBER"],
        compute: function (text) {
            return toString(text).length;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // LOWER
    // -----------------------------------------------------------------------------
    const LOWER = {
        description: _t("Converts a specified string to lowercase."),
        args: [arg("text (string)", _t("The string to convert to lowercase."))],
        returns: ["STRING"],
        compute: function (text) {
            return toString(text).toLowerCase();
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // MID
    // -----------------------------------------------------------------------------
    const MID = {
        description: _t("A segment of a string."),
        args: [
            arg("text (string)", _t("The string to extract a segment from.")),
            arg("starting_at (number)", _t("The index from the left of string from which to begin extracting. The first character in string has the index 1.")),
            arg("extract_length (number)", _t("The length of the segment to extract.")),
        ],
        returns: ["STRING"],
        compute: function (text, starting_at, extract_length) {
            const _text = toString(text);
            const _starting_at = toNumber(starting_at, this.locale);
            const _extract_length = toNumber(extract_length, this.locale);
            assert(() => _starting_at >= 1, _t("The starting_at argument (%s) must be positive greater than one.", _starting_at.toString()));
            assert(() => _extract_length >= 0, _t("The extract_length argument (%s) must be positive or null.", _extract_length.toString()));
            return _text.slice(_starting_at - 1, _starting_at + _extract_length - 1);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // PROPER
    // -----------------------------------------------------------------------------
    const PROPER = {
        description: _t("Capitalizes each word in a specified string."),
        args: [
            arg("text_to_capitalize (string)", _t("The text which will be returned with the first letter of each word in uppercase and all other letters in lowercase.")),
        ],
        returns: ["STRING"],
        compute: function (text) {
            const _text = toString(text);
            return _text.replace(wordRegex, (word) => {
                return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();
            });
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // REPLACE
    // -----------------------------------------------------------------------------
    const REPLACE = {
        description: _t("Replaces part of a text string with different text."),
        args: [
            arg("text (string)", _t("The text, a part of which will be replaced.")),
            arg("position (number)", _t("The position where the replacement will begin (starting from 1).")),
            arg("length (number)", _t("The number of characters in the text to be replaced.")),
            arg("new_text (string)", _t("The text which will be inserted into the original text.")),
        ],
        returns: ["STRING"],
        compute: function (text, position, length, newText) {
            const _position = toNumber(position, this.locale);
            assert(() => _position >= 1, _t("The position (%s) must be greater than or equal to 1.", _position.toString()));
            const _text = toString(text);
            const _length = toNumber(length, this.locale);
            const _newText = toString(newText);
            return _text.substring(0, _position - 1) + _newText + _text.substring(_position - 1 + _length);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // RIGHT
    // -----------------------------------------------------------------------------
    const RIGHT = {
        description: _t("A substring from the end of a specified string."),
        args: [
            arg("text (string)", _t("The string from which the right portion will be returned.")),
            arg("number_of_characters (number, optional)", _t("The number of characters to return from the right side of string.")),
        ],
        returns: ["STRING"],
        compute: function (text, ...args) {
            const _numberOfCharacters = args.length ? toNumber(args[0], this.locale) : 1;
            assert(() => _numberOfCharacters >= 0, _t("The number_of_characters (%s) must be positive or null.", _numberOfCharacters.toString()));
            const _text = toString(text);
            const stringLength = _text.length;
            return _text.substring(stringLength - _numberOfCharacters, stringLength);
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SEARCH
    // -----------------------------------------------------------------------------
    const SEARCH = {
        description: _t("First position of string found in text, ignoring case."),
        args: [
            arg("search_for (string)", _t("The string to look for within text_to_search.")),
            arg("text_to_search (string)", _t("The text to search for the first occurrence of search_for.")),
            arg(`starting_at (number, default=${DEFAULT_STARTING_AT})`, _t("The character within text_to_search at which to start the search.")),
        ],
        returns: ["NUMBER"],
        compute: function (searchFor, textToSearch, startingAt = DEFAULT_STARTING_AT) {
            const _searchFor = toString(searchFor).toLowerCase();
            const _textToSearch = toString(textToSearch).toLowerCase();
            const _startingAt = toNumber(startingAt, this.locale);
            assert(() => _textToSearch !== "", _t("The text_to_search must be non-empty."));
            assert(() => _startingAt >= 1, _t("The starting_at (%s) must be greater than or equal to 1.", _startingAt.toString()));
            const result = _textToSearch.indexOf(_searchFor, _startingAt - 1);
            assert(() => result >= 0, _t("In [[FUNCTION_NAME]] evaluation, cannot find '%s' within '%s'.", _searchFor, _textToSearch));
            return result + 1;
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // SPLIT
    // -----------------------------------------------------------------------------
    const SPLIT_DEFAULT_SPLIT_BY_EACH = true;
    const SPLIT_DEFAULT_REMOVE_EMPTY_TEXT = true;
    const SPLIT = {
        description: _t("Split text by specific character delimiter(s)."),
        args: [
            arg("text (string)", _t("The text to divide.")),
            arg("delimiter (string)", _t("The character or characters to use to split text.")),
            arg(`split_by_each (boolean, default=${SPLIT_DEFAULT_SPLIT_BY_EACH}})`, _t("Whether or not to divide text around each character contained in delimiter.")),
            arg(`remove_empty_text (boolean, default=${SPLIT_DEFAULT_REMOVE_EMPTY_TEXT})`, _t("Whether or not to remove empty text messages from the split results. The default behavior is to treat \
        consecutive delimiters as one (if TRUE). If FALSE, empty cells values are added between consecutive delimiters.")),
        ],
        returns: ["RANGE<STRING>"],
        compute: function (text, delimiter, splitByEach = SPLIT_DEFAULT_SPLIT_BY_EACH, removeEmptyText = SPLIT_DEFAULT_REMOVE_EMPTY_TEXT) {
            const _text = toString(text);
            const _delimiter = escapeRegExp(toString(delimiter));
            const _splitByEach = toBoolean(splitByEach);
            const _removeEmptyText = toBoolean(removeEmptyText);
            assert(() => _delimiter.length > 0, _t("The _delimiter (%s) must be not be empty.", _delimiter));
            const regex = _splitByEach ? new RegExp(`[${_delimiter}]`, "g") : new RegExp(_delimiter, "g");
            let result = _text.split(regex);
            if (_removeEmptyText) {
                result = result.filter((text) => text !== "");
            }
            return transposeMatrix([result]);
        },
        isExported: false,
    };
    // -----------------------------------------------------------------------------
    // SUBSTITUTE
    // -----------------------------------------------------------------------------
    const SUBSTITUTE = {
        description: _t("Replaces existing text with new text in a string."),
        args: [
            arg("text_to_search (string)", _t("The text within which to search and replace.")),
            arg("search_for (string)", _t("The string to search for within text_to_search.")),
            arg("replace_with (string)", _t("The string that will replace search_for.")),
            arg("occurrence_number (number, optional)", _t("The instance of search_for within text_to_search to replace with replace_with. By default, all occurrences of search_for are replaced; however, if occurrence_number is specified, only the indicated instance of search_for is replaced.")),
        ],
        returns: ["NUMBER"],
        compute: function (textToSearch, searchFor, replaceWith, occurrenceNumber) {
            const _occurrenceNumber = toNumber(occurrenceNumber, this.locale);
            assert(() => _occurrenceNumber >= 0, _t("The occurrenceNumber (%s) must be positive or null.", _occurrenceNumber.toString()));
            const _textToSearch = toString(textToSearch);
            const _searchFor = toString(searchFor);
            if (_searchFor === "") {
                return _textToSearch;
            }
            const _replaceWith = toString(replaceWith);
            const reg = new RegExp(escapeRegExp(_searchFor), "g");
            if (_occurrenceNumber === 0) {
                return _textToSearch.replace(reg, _replaceWith);
            }
            let n = 0;
            return _textToSearch.replace(reg, (text) => (++n === _occurrenceNumber ? _replaceWith : text));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TEXTJOIN
    // -----------------------------------------------------------------------------
    const TEXTJOIN = {
        description: _t("Combines text from multiple strings and/or arrays."),
        args: [
            arg("delimiter (string)", _t(" A string, possible empty, or a reference to a valid string. If empty, the text will be simply concatenated.")),
            arg("ignore_empty (boolean)", _t("A boolean; if TRUE, empty cells selected in the text arguments won't be included in the result.")),
            arg("text1 (string, range<string>)", _t("Any text item. This could be a string, or an array of strings in a range.")),
            arg("text2 (string, range<string>, repeating)", _t("Additional text item(s).")),
        ],
        returns: ["STRING"],
        compute: function (delimiter, ignoreEmpty, ...textsOrArrays) {
            const _delimiter = toString(delimiter);
            const _ignoreEmpty = toBoolean(ignoreEmpty);
            let n = 0;
            return reduceAny(textsOrArrays, (acc, a) => !(_ignoreEmpty && toString(a) === "") ? (n++ ? acc + _delimiter : "") + toString(a) : acc, "");
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TRIM
    // -----------------------------------------------------------------------------
    const TRIM = {
        description: _t("Removes space characters."),
        args: [
            arg("text (string)", _t("The text or reference to a cell containing text to be trimmed.")),
        ],
        returns: ["STRING"],
        compute: function (text) {
            return trimContent(toString(text));
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // UPPER
    // -----------------------------------------------------------------------------
    const UPPER = {
        description: _t("Converts a specified string to uppercase."),
        args: [arg("text (string)", _t("The string to convert to uppercase."))],
        returns: ["STRING"],
        compute: function (text) {
            return toString(text).toUpperCase();
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // TEXT
    // -----------------------------------------------------------------------------
    const TEXT = {
        description: _t("Converts a number to text according to a specified format."),
        args: [
            arg("number (number)", _t("The number, date or time to format.")),
            arg("format (string)", _t("The pattern by which to format the number, enclosed in quotation marks.")),
        ],
        returns: ["STRING"],
        compute: function (number, format) {
            const _number = toNumber(number, this.locale);
            return formatValue(_number, { format: toString(format), locale: this.locale });
        },
        isExported: true,
    };
    // -----------------------------------------------------------------------------
    // VALUE
    // -----------------------------------------------------------------------------
    const VALUE = {
        description: _t("Converts a string to a numeric value."),
        args: [arg("value (number)", _t("the string to be converted"))],
        returns: ["NUMBER"],
        compute: function (value) {
            return toNumber(value, this.locale);
        },
        isExported: true,
    };

    var text = /*#__PURE__*/Object.freeze({
        __proto__: null,
        CHAR: CHAR,
        CLEAN: CLEAN,
        CONCATENATE: CONCATENATE,
        EXACT: EXACT,
        FIND: FIND,
        JOIN: JOIN,
        LEFT: LEFT,
        LEN: LEN,
        LOWER: LOWER,
        MID: MID,
        PROPER: PROPER,
        REPLACE: REPLACE,
        RIGHT: RIGHT,
        SEARCH: SEARCH,
        SPLIT: SPLIT,
        SUBSTITUTE: SUBSTITUTE,
        TEXT: TEXT,
        TEXTJOIN: TEXTJOIN,
        TRIM: TRIM,
        UPPER: UPPER,
        VALUE: VALUE
    });

    // -----------------------------------------------------------------------------
    // HYPERLINK
    // -----------------------------------------------------------------------------
    const HYPERLINK = {
        description: _t("Creates a hyperlink in a cell."),
        args: [
            arg("url (string)", _t("The full URL of the link enclosed in quotation marks.")),
            arg("link_label (string, optional)", _t("The text to display in the cell, enclosed in quotation marks.")),
        ],
        returns: ["STRING"],
        compute: function (url, linkLabel) {
            const processedUrl = toString(url).trim();
            const processedLabel = toString(linkLabel) || processedUrl;
            if (processedUrl === "")
                return processedLabel;
            return markdownLink(processedLabel, processedUrl);
        },
        isExported: true,
    };

    var web = /*#__PURE__*/Object.freeze({
        __proto__: null,
        HYPERLINK: HYPERLINK
    });

    const categories = [
        { name: _t("Array"), functions: array },
        { name: _t("Database"), functions: database },
        { name: _t("Date"), functions: date },
        { name: _t("Filter"), functions: filter },
        { name: _t("Financial"), functions: financial },
        { name: _t("Info"), functions: info },
        { name: _t("Lookup"), functions: lookup },
        { name: _t("Logical"), functions: logical },
        { name: _t("Math"), functions: math },
        { name: _t("Misc"), functions: misc },
        { name: _t("Operator"), functions: operators },
        { name: _t("Statistical"), functions: statistical },
        { name: _t("Text"), functions: text },
        { name: _t("Engineering"), functions: engineering },
        { name: _t("Web"), functions: web },
    ];
    const functionNameRegex = /^[A-Z0-9\_\.]+$/;
    //------------------------------------------------------------------------------
    // Function registry
    //------------------------------------------------------------------------------
    class FunctionRegistry extends Registry {
        mapping = {};
        add(name, addDescr) {
            name = name.toUpperCase();
            if (!functionNameRegex.test(name)) {
                throw new Error(_t("Invalid function name %s. Function names can exclusively contain alphanumerical values separated by dots (.) or underscore (_)", name));
            }
            const descr = addMetaInfoFromArg(addDescr);
            validateArguments(descr.args);
            this.mapping[name] = addInputHandling(descr, createComputeFunctionFromDescription(descr));
            super.add(name, descr);
            return this;
        }
    }
    function addInputHandling(descr, computeFunction) {
        function computeWithInputHandling(...args) {
            for (let i = 0; i < args.length; i++) {
                const argDefinition = descr.args[descr.getArgToFocus(i + 1) - 1];
                const arg = args[i];
                if (isMatrix(arg) && !argDefinition.acceptMatrix) {
                    if (arg.length !== 1 || arg[0].length !== 1) {
                        throw new EvaluationError(CellErrorType.GenericError, _t("Function [[FUNCTION_NAME]] expects the parameter '%s' to be a single value or a single cell reference, not a range.", argDefinition.name));
                    }
                    args[i] = arg[0][0];
                }
            }
            return computeFunction.apply(this, args);
        }
        return computeWithInputHandling;
    }
    function createComputeFunctionFromDescription(descr) {
        const computeValueAndFormat = "computeValueAndFormat" in descr;
        const computeValue = "compute" in descr;
        const computeFormat = "computeFormat" in descr;
        if (!computeValueAndFormat && !computeValue) {
            throw new Error("Invalid function description, need at least one 'compute' or 'computeValueAndFormat' function");
        }
        if (computeValueAndFormat && (computeValue || computeFormat)) {
            throw new Error("Invalid function description, cannot have both 'computeValueAndFormat' and 'compute'/'computeFormat' functions");
        }
        if (computeValueAndFormat) {
            return descr.computeValueAndFormat;
        }
        // case computeValue
        return buildComputeFunctionFromDescription(descr);
    }
    function buildComputeFunctionFromDescription(descr) {
        return function (...args) {
            const value = descr.compute.apply(this, extractArgValuesFromArgs(args));
            const format = descr.computeFormat?.apply(this, args);
            if (isMatrix(value)) {
                if (format === undefined || isMatrix(format)) {
                    return value.map((col, i) => col.map((row, j) => ({ value: row, format: format?.[i]?.[j] })));
                }
            }
            else {
                if (format === undefined || !isMatrix(format)) {
                    return { value, format };
                }
            }
            throw new Error("A format matrix should never be associated with a scalar value");
        };
    }
    function extractArgValuesFromArgs(args) {
        return args.map((arg) => {
            if (arg === undefined) {
                return undefined;
            }
            if (typeof arg === "function") {
                return () => extractArgValueFromArg(arg());
            }
            return extractArgValueFromArg(arg);
        });
    }
    function extractArgValueFromArg(arg) {
        if (isMatrix(arg)) {
            return matrixMap(arg, (data) => data.value);
        }
        return arg?.value;
    }
    const functionRegistry = new FunctionRegistry();
    for (let category of categories) {
        const fns = category.functions;
        for (let name in fns) {
            const addDescr = fns[name];
            addDescr.category = addDescr.category || category.name;
            name = name.replace(/_/g, ".");
            functionRegistry.add(name, { isExported: false, ...addDescr });
        }
    }

    const insertRow = {
        name: (env) => {
            const number = getRowsNumber(env);
            return number === 1 ? _t("Insert row") : _t("Insert %s rows", number.toString());
        },
        isVisible: (env) => CAN_INSERT_HEADER(env, "ROW"),
        icon: "o-spreadsheet-Icon.INSERT_ROW",
    };
    const rowInsertRowBefore = {
        name: (env) => {
            const number = getRowsNumber(env);
            return number === 1 ? _t("Insert row above") : _t("Insert %s rows above", number.toString());
        },
        execute: INSERT_ROWS_BEFORE_ACTION,
        isVisible: (env) => CAN_INSERT_HEADER(env, "ROW"),
        icon: "o-spreadsheet-Icon.INSERT_ROW_BEFORE",
    };
    const topBarInsertRowsBefore = {
        ...rowInsertRowBefore,
        name: (env) => {
            const number = getRowsNumber(env);
            if (number === 1) {
                return _t("Row above");
            }
            return _t("%s Rows above", number.toString());
        },
    };
    const cellInsertRowsBefore = {
        ...rowInsertRowBefore,
        name: (env) => {
            const number = getRowsNumber(env);
            if (number === 1) {
                return _t("Insert row");
            }
            return _t("Insert %s rows", number.toString());
        },
        isVisible: IS_ONLY_ONE_RANGE,
        icon: "o-spreadsheet-Icon.INSERT_ROW_BEFORE",
    };
    const rowInsertRowsAfter = {
        execute: INSERT_ROWS_AFTER_ACTION,
        name: (env) => {
            const number = getRowsNumber(env);
            return number === 1 ? _t("Insert row below") : _t("Insert %s rows below", number.toString());
        },
        isVisible: (env) => CAN_INSERT_HEADER(env, "ROW"),
        icon: "o-spreadsheet-Icon.INSERT_ROW_AFTER",
    };
    const topBarInsertRowsAfter = {
        ...rowInsertRowsAfter,
        name: (env) => {
            const number = getRowsNumber(env);
            if (number === 1) {
                return _t("Row below");
            }
            return _t("%s Rows below", number.toString());
        },
    };
    const insertCol = {
        name: (env) => {
            const number = getColumnsNumber(env);
            return number === 1 ? _t("Insert column") : _t("Insert %s columns", number.toString());
        },
        isVisible: (env) => CAN_INSERT_HEADER(env, "COL"),
        icon: "o-spreadsheet-Icon.INSERT_COL",
    };
    const colInsertColsBefore = {
        name: (env) => {
            const number = getColumnsNumber(env);
            return number === 1
                ? _t("Insert column left")
                : _t("Insert %s columns left", number.toString());
        },
        execute: INSERT_COLUMNS_BEFORE_ACTION,
        isVisible: (env) => CAN_INSERT_HEADER(env, "COL"),
        icon: "o-spreadsheet-Icon.INSERT_COL_BEFORE",
    };
    const topBarInsertColsBefore = {
        ...colInsertColsBefore,
        name: (env) => {
            const number = getColumnsNumber(env);
            if (number === 1) {
                return _t("Column left");
            }
            return _t("%s Columns left", number.toString());
        },
    };
    const cellInsertColsBefore = {
        ...colInsertColsBefore,
        name: (env) => {
            const number = getColumnsNumber(env);
            if (number === 1) {
                return _t("Insert column");
            }
            return _t("Insert %s columns", number.toString());
        },
        isVisible: IS_ONLY_ONE_RANGE,
        icon: "o-spreadsheet-Icon.INSERT_COL_BEFORE",
    };
    const colInsertColsAfter = {
        name: (env) => {
            const number = getColumnsNumber(env);
            return number === 1
                ? _t("Insert column right")
                : _t("Insert %s columns right", number.toString());
        },
        execute: INSERT_COLUMNS_AFTER_ACTION,
        isVisible: (env) => CAN_INSERT_HEADER(env, "COL"),
        icon: "o-spreadsheet-Icon.INSERT_COL_AFTER",
    };
    const topBarInsertColsAfter = {
        ...colInsertColsAfter,
        name: (env) => {
            const number = getColumnsNumber(env);
            if (number === 1) {
                return _t("Column right");
            }
            return _t("%s Columns right", number.toString());
        },
        execute: INSERT_COLUMNS_AFTER_ACTION,
    };
    const insertCell = {
        name: _t("Insert cells"),
        isVisible: (env) => IS_ONLY_ONE_RANGE(env) &&
            env.model.getters.getActiveCols().size === 0 &&
            env.model.getters.getActiveRows().size === 0,
        icon: "o-spreadsheet-Icon.INSERT_CELL",
    };
    const insertCellShiftDown = {
        name: _t("Insert cells and shift down"),
        execute: (env) => {
            const zone = env.model.getters.getSelectedZone();
            const result = env.model.dispatch("INSERT_CELL", { zone, shiftDimension: "ROW" });
            handlePasteResult(env, result);
        },
        isVisible: (env) => env.model.getters.getActiveRows().size === 0 && env.model.getters.getActiveCols().size === 0,
        icon: "o-spreadsheet-Icon.INSERT_CELL_SHIFT_DOWN",
    };
    const insertCellShiftRight = {
        name: _t("Insert cells and shift right"),
        execute: (env) => {
            const zone = env.model.getters.getSelectedZone();
            const result = env.model.dispatch("INSERT_CELL", { zone, shiftDimension: "COL" });
            handlePasteResult(env, result);
        },
        isVisible: (env) => env.model.getters.getActiveRows().size === 0 && env.model.getters.getActiveCols().size === 0,
        icon: "o-spreadsheet-Icon.INSERT_CELL_SHIFT_RIGHT",
    };
    const insertChart = {
        name: _t("Chart"),
        execute: CREATE_CHART,
        icon: "o-spreadsheet-Icon.INSERT_CHART",
    };
    const insertImage = {
        name: _t("Image"),
        description: "Ctrl+O",
        execute: CREATE_IMAGE,
        isVisible: (env) => env.imageProvider !== undefined,
        icon: "o-spreadsheet-Icon.INSERT_IMAGE",
    };
    const insertFunction = {
        name: _t("Function"),
        icon: "o-spreadsheet-Icon.SHOW_HIDE_FORMULA",
    };
    const insertFunctionSum = {
        name: _t("SUM"),
        execute: (env) => env.startCellEdition(`=SUM(`),
    };
    const insertFunctionAverage = {
        name: _t("AVERAGE"),
        execute: (env) => env.startCellEdition(`=AVERAGE(`),
    };
    const insertFunctionCount = {
        name: _t("COUNT"),
        execute: (env) => env.startCellEdition(`=COUNT(`),
    };
    const insertFunctionMax = {
        name: _t("MAX"),
        execute: (env) => env.startCellEdition(`=MAX(`),
    };
    const insertFunctionMin = {
        name: _t("MIN"),
        execute: (env) => env.startCellEdition(`=MIN(`),
    };
    const categorieFunctionAll = {
        name: _t("All"),
        children: [allFunctionListMenuBuilder],
    };
    function allFunctionListMenuBuilder() {
        const fnNames = functionRegistry.getKeys().filter((key) => !functionRegistry.get(key).hidden);
        return createFormulaFunctions(fnNames);
    }
    const categoriesFunctionListMenuBuilder = () => {
        const functions = functionRegistry.content;
        const categories = [
            ...new Set(functionRegistry
                .getAll()
                .filter((fn) => !fn.hidden)
                .map((fn) => fn.category)),
        ].filter(isDefined$1);
        return categories.sort().map((category, i) => {
            const functionsInCategory = Object.keys(functions).filter((key) => functions[key].category === category && !functions[key].hidden);
            return {
                name: category,
                children: createFormulaFunctions(functionsInCategory),
            };
        });
    };
    const insertLink = {
        name: _t("Link"),
        execute: INSERT_LINK,
        icon: "o-spreadsheet-Icon.INSERT_LINK",
    };
    const insertSheet = {
        name: _t("Insert sheet"),
        execute: (env) => {
            const activeSheetId = env.model.getters.getActiveSheetId();
            const position = env.model.getters.getSheetIds().indexOf(activeSheetId) + 1;
            const sheetId = env.model.uuidGenerator.smallUuid();
            env.model.dispatch("CREATE_SHEET", { sheetId, position });
            env.model.dispatch("ACTIVATE_SHEET", { sheetIdFrom: activeSheetId, sheetIdTo: sheetId });
        },
        icon: "o-spreadsheet-Icon.INSERT_SHEET",
    };
    function createFormulaFunctions(fnNames) {
        return fnNames.sort().map((fnName, i) => {
            return {
                name: fnName,
                sequence: i * 10,
                execute: (env) => env.startCellEdition(`=${fnName}(`),
            };
        });
    }
    function getRowsNumber(env) {
        const activeRows = env.model.getters.getActiveRows();
        if (activeRows.size) {
            return activeRows.size;
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            return zone.bottom - zone.top + 1;
        }
    }
    function getColumnsNumber(env) {
        const activeCols = env.model.getters.getActiveCols();
        if (activeCols.size) {
            return activeCols.size;
        }
        else {
            const zone = env.model.getters.getSelectedZones()[0];
            return zone.right - zone.left + 1;
        }
    }

    //------------------------------------------------------------------------------
    // Context Menu Registry
    //------------------------------------------------------------------------------
    const cellMenuRegistry = new MenuItemRegistry();
    cellMenuRegistry
        .add("cut", {
        ...cut,
        sequence: 10,
    })
        .add("copy", {
        ...copy,
        sequence: 20,
    })
        .add("paste", {
        ...paste,
        sequence: 30,
    })
        .add("paste_special", {
        ...pasteSpecial,
        sequence: 40,
        separator: true,
    })
        .addChild("paste_value_only", ["paste_special"], {
        ...pasteSpecialValue,
        sequence: 10,
    })
        .addChild("paste_format_only", ["paste_special"], {
        ...pasteSpecialFormat,
        sequence: 20,
    })
        .add("add_row_before", {
        ...cellInsertRowsBefore,
        sequence: 70,
    })
        .add("add_column_before", {
        ...cellInsertColsBefore,
        sequence: 90,
    })
        .add("insert_cell", {
        ...insertCell,
        sequence: 100,
        separator: true,
    })
        .addChild("insert_cell_down", ["insert_cell"], {
        ...insertCellShiftDown,
        name: _t("Shift down"),
        sequence: 10,
    })
        .addChild("insert_cell_right", ["insert_cell"], {
        ...insertCellShiftRight,
        name: _t("Shift right"),
        sequence: 20,
    })
        .add("delete_row", {
        ...deleteRow,
        sequence: 110,
        icon: "o-spreadsheet-Icon.DELETE",
    })
        .add("delete_column", {
        ...deleteCol,
        sequence: 120,
        icon: "o-spreadsheet-Icon.DELETE",
    })
        .add("delete_cell", {
        ...deleteCells,
        sequence: 130,
        separator: true,
        icon: "o-spreadsheet-Icon.DELETE",
    })
        .addChild("delete_cell_up", ["delete_cell"], {
        ...deleteCellShiftUp,
        name: _t("Shift up"),
        sequence: 10,
        icon: "o-spreadsheet-Icon.DELETE_CELL_SHIFT_UP",
    })
        .addChild("delete_cell_left", ["delete_cell"], {
        ...deleteCellShiftLeft,
        name: _t("Shift left"),
        sequence: 20,
        icon: "o-spreadsheet-Icon.DELETE_CELL_SHIFT_LEFT",
    })
        .add("insert_link", {
        ...insertLink,
        name: INSERT_LINK_NAME,
        sequence: 150,
        separator: true,
    });

    const AddFilterInteractiveContent = {
        filterOverlap: _t("You cannot create overlapping filters."),
        nonContinuousTargets: _t("A filter can only be created on a continuous selection."),
        mergeInFilter: _t("You can't create a filter over a range that contains a merge."),
    };
    function interactiveAddFilter(env, sheetId, target) {
        const result = env.model.dispatch("CREATE_FILTER_TABLE", { target, sheetId });
        if (result.isCancelledBecause("FilterOverlap" /* CommandResult.FilterOverlap */)) {
            env.raiseError(AddFilterInteractiveContent.filterOverlap);
        }
        else if (result.isCancelledBecause("MergeInFilter" /* CommandResult.MergeInFilter */)) {
            env.raiseError(AddFilterInteractiveContent.mergeInFilter);
        }
        else if (result.isCancelledBecause("NonContinuousTargets" /* CommandResult.NonContinuousTargets */)) {
            env.raiseError(AddFilterInteractiveContent.nonContinuousTargets);
        }
    }

    function interactiveFreezeColumnsRows(env, dimension, base) {
        const sheetId = env.model.getters.getActiveSheetId();
        const cmd = dimension === "COL" ? "FREEZE_COLUMNS" : "FREEZE_ROWS";
        const result = env.model.dispatch(cmd, { sheetId, quantity: base });
        if (result.isCancelledBecause("MergeOverlap" /* CommandResult.MergeOverlap */)) {
            env.raiseError(MergeErrorMessage);
        }
    }

    const hideCols = {
        name: HIDE_COLUMNS_NAME,
        execute: (env) => {
            const columns = env.model.getters.getElementsFromSelection("COL");
            env.model.dispatch("HIDE_COLUMNS_ROWS", {
                sheetId: env.model.getters.getActiveSheetId(),
                dimension: "COL",
                elements: columns,
            });
        },
        isVisible: NOT_ALL_VISIBLE_COLS_SELECTED,
        icon: "o-spreadsheet-Icon.HIDE_COL",
    };
    const unhideCols = {
        name: _t("Unhide columns"),
        execute: (env) => {
            const columns = env.model.getters.getElementsFromSelection("COL");
            env.model.dispatch("UNHIDE_COLUMNS_ROWS", {
                sheetId: env.model.getters.getActiveSheetId(),
                dimension: "COL",
                elements: columns,
            });
        },
        isVisible: (env) => {
            const hiddenCols = env.model.getters
                .getHiddenColsGroups(env.model.getters.getActiveSheetId())
                .flat();
            const currentCols = env.model.getters.getElementsFromSelection("COL");
            return currentCols.some((col) => hiddenCols.includes(col));
        },
    };
    const unhideAllCols = {
        name: _t("Unhide all columns"),
        execute: (env) => {
            const sheetId = env.model.getters.getActiveSheetId();
            env.model.dispatch("UNHIDE_COLUMNS_ROWS", {
                sheetId,
                dimension: "COL",
                elements: Array.from(Array(env.model.getters.getNumberCols(sheetId)).keys()),
            });
        },
        isVisible: (env) => env.model.getters.getHiddenColsGroups(env.model.getters.getActiveSheetId()).length > 0,
    };
    const hideRows = {
        name: HIDE_ROWS_NAME,
        execute: (env) => {
            const rows = env.model.getters.getElementsFromSelection("ROW");
            env.model.dispatch("HIDE_COLUMNS_ROWS", {
                sheetId: env.model.getters.getActiveSheetId(),
                dimension: "ROW",
                elements: rows,
            });
        },
        isVisible: NOT_ALL_VISIBLE_ROWS_SELECTED,
        icon: "o-spreadsheet-Icon.HIDE_ROW",
    };
    const unhideRows = {
        name: _t("Unhide rows"),
        execute: (env) => {
            const columns = env.model.getters.getElementsFromSelection("ROW");
            env.model.dispatch("UNHIDE_COLUMNS_ROWS", {
                sheetId: env.model.getters.getActiveSheetId(),
                dimension: "ROW",
                elements: columns,
            });
        },
        isVisible: (env) => {
            const hiddenRows = env.model.getters
                .getHiddenRowsGroups(env.model.getters.getActiveSheetId())
                .flat();
            const currentRows = env.model.getters.getElementsFromSelection("ROW");
            return currentRows.some((col) => hiddenRows.includes(col));
        },
    };
    const unhideAllRows = {
        name: _t("Unhide all rows"),
        execute: (env) => {
            const sheetId = env.model.getters.getActiveSheetId();
            env.model.dispatch("UNHIDE_COLUMNS_ROWS", {
                sheetId,
                dimension: "ROW",
                elements: Array.from(Array(env.model.getters.getNumberRows(sheetId)).keys()),
            });
        },
        isVisible: (env) => env.model.getters.getHiddenRowsGroups(env.model.getters.getActiveSheetId()).length > 0,
    };
    const unFreezePane = {
        name: _t("Unfreeze"),
        isVisible: (env) => {
            const { xSplit, ySplit } = env.model.getters.getPaneDivisions(env.model.getters.getActiveSheetId());
            return xSplit + ySplit > 0;
        },
        execute: (env) => env.model.dispatch("UNFREEZE_COLUMNS_ROWS", {
            sheetId: env.model.getters.getActiveSheetId(),
        }),
        icon: "o-spreadsheet-Icon.UNFREEZE",
    };
    const freezePane = {
        name: _t("Freeze"),
        icon: "o-spreadsheet-Icon.FREEZE",
    };
    const unFreezeRows = {
        name: _t("No rows"),
        execute: (env) => env.model.dispatch("UNFREEZE_ROWS", {
            sheetId: env.model.getters.getActiveSheetId(),
        }),
        isReadonlyAllowed: true,
        isVisible: (env) => !!env.model.getters.getPaneDivisions(env.model.getters.getActiveSheetId()).ySplit,
    };
    const freezeFirstRow = {
        name: _t("1 row"),
        execute: (env) => interactiveFreezeColumnsRows(env, "ROW", 1),
        isReadonlyAllowed: true,
    };
    const freezeSecondRow = {
        name: _t("2 rows"),
        execute: (env) => interactiveFreezeColumnsRows(env, "ROW", 2),
        isReadonlyAllowed: true,
    };
    const freezeCurrentRow = {
        name: _t("Up to current row"),
        execute: (env) => {
            const { bottom } = env.model.getters.getSelectedZone();
            interactiveFreezeColumnsRows(env, "ROW", bottom + 1);
        },
        isReadonlyAllowed: true,
    };
    const unFreezeCols = {
        name: _t("No columns"),
        execute: (env) => env.model.dispatch("UNFREEZE_COLUMNS", {
            sheetId: env.model.getters.getActiveSheetId(),
        }),
        isReadonlyAllowed: true,
        isVisible: (env) => !!env.model.getters.getPaneDivisions(env.model.getters.getActiveSheetId()).xSplit,
    };
    const freezeFirstCol = {
        name: _t("1 column"),
        execute: (env) => interactiveFreezeColumnsRows(env, "COL", 1),
        isReadonlyAllowed: true,
    };
    const freezeSecondCol = {
        name: _t("2 columns"),
        execute: (env) => interactiveFreezeColumnsRows(env, "COL", 2),
        isReadonlyAllowed: true,
    };
    const freezeCurrentCol = {
        name: _t("Up to current column"),
        execute: (env) => {
            const { right } = env.model.getters.getSelectedZone();
            interactiveFreezeColumnsRows(env, "COL", right + 1);
        },
        isReadonlyAllowed: true,
    };
    const viewGridlines = {
        name: (env) => env.model.getters.getGridLinesVisibility(env.model.getters.getActiveSheetId())
            ? _t("Hide gridlines")
            : _t("Show gridlines"),
        execute: (env) => {
            const sheetId = env.model.getters.getActiveSheetId();
            env.model.dispatch("SET_GRID_LINES_VISIBILITY", {
                sheetId,
                areGridLinesVisible: !env.model.getters.getGridLinesVisibility(sheetId),
            });
        },
        icon: "o-spreadsheet-Icon.SHOW_HIDE_GRID",
    };
    const viewFormulas = {
        name: (env) => env.model.getters.shouldShowFormulas() ? "Hide formulas" : _t("Show formulas"),
        execute: (env) => env.model.dispatch("SET_FORMULA_VISIBILITY", { show: !env.model.getters.shouldShowFormulas() }),
        isReadonlyAllowed: true,
        icon: "o-spreadsheet-Icon.SHOW_HIDE_FORMULA",
    };
    const createRemoveFilter = {
        name: (env) => selectionContainsFilter(env) ? _t("Remove selected filters") : _t("Create filter"),
        isActive: (env) => selectionContainsFilter(env),
        isEnabled: (env) => !cannotCreateFilter(env),
        execute: (env) => createRemoveFilterAction(env),
        icon: "o-spreadsheet-Icon.FILTER_ICON_INACTIVE",
    };
    const groupColumns = {
        name: (env) => {
            const selection = env.model.getters.getSelectedZone();
            if (selection.left === selection.right) {
                return _t("Group column %s", numberToLetters(selection.left));
            }
            return _t("Group columns %s - %s", numberToLetters(selection.left), numberToLetters(selection.right));
        },
        execute: (env) => groupHeadersAction(env, "COL"),
        isVisible: (env) => {
            const sheetId = env.model.getters.getActiveSheetId();
            const selection = env.model.getters.getSelectedZone();
            const groups = env.model.getters.getHeaderGroupsInZone(sheetId, "COL", selection);
            return (IS_ONLY_ONE_RANGE(env) &&
                !groups.some((group) => group.start === selection.left && group.end === selection.right));
        },
        icon: "o-spreadsheet-Icon.GROUP_COLUMNS",
    };
    const groupRows = {
        name: (env) => {
            const selection = env.model.getters.getSelectedZone();
            if (selection.top === selection.bottom) {
                return _t("Group row %s", String(selection.top + 1));
            }
            return _t("Group rows %s - %s", String(selection.top + 1), String(selection.bottom + 1));
        },
        execute: (env) => groupHeadersAction(env, "ROW"),
        isVisible: (env) => {
            const sheetId = env.model.getters.getActiveSheetId();
            const selection = env.model.getters.getSelectedZone();
            const groups = env.model.getters.getHeaderGroupsInZone(sheetId, "ROW", selection);
            return (IS_ONLY_ONE_RANGE(env) &&
                !groups.some((group) => group.start === selection.top && group.end === selection.bottom));
        },
        icon: "o-spreadsheet-Icon.GROUP_ROWS",
    };
    const ungroupColumns = {
        name: (env) => {
            const selection = env.model.getters.getSelectedZone();
            if (selection.left === selection.right) {
                return _t("Ungroup column %s", numberToLetters(selection.left));
            }
            return _t("Ungroup columns %s - %s", numberToLetters(selection.left), numberToLetters(selection.right));
        },
        execute: (env) => ungroupHeaders(env, "COL"),
        icon: "o-spreadsheet-Icon.UNGROUP_COLUMNS",
    };
    const ungroupRows = {
        name: (env) => {
            const selection = env.model.getters.getSelectedZone();
            if (selection.top === selection.bottom) {
                return _t("Ungroup row %s", String(selection.top + 1));
            }
            return _t("Ungroup rows %s - %s", String(selection.top + 1), String(selection.bottom + 1));
        },
        execute: (env) => ungroupHeaders(env, "ROW"),
        icon: "o-spreadsheet-Icon.UNGROUP_ROWS",
    };
    function selectionContainsFilter(env) {
        const sheetId = env.model.getters.getActiveSheetId();
        const selectedZones = env.model.getters.getSelectedZones();
        return env.model.getters.doesZonesContainFilter(sheetId, selectedZones);
    }
    function cannotCreateFilter(env) {
        return !areZonesContinuous(...env.model.getters.getSelectedZones());
    }
    function createRemoveFilterAction(env) {
        if (selectionContainsFilter(env)) {
            env.model.dispatch("REMOVE_FILTER_TABLE", {
                sheetId: env.model.getters.getActiveSheetId(),
                target: env.model.getters.getSelectedZones(),
            });
            return;
        }
        if (cannotCreateFilter(env)) {
            return;
        }
        env.model.selection.selectTableAroundSelection();
        const sheetId = env.model.getters.getActiveSheetId();
        const selection = env.model.getters.getSelectedZones();
        interactiveAddFilter(env, sheetId, selection);
    }
    function groupHeadersAction(env, dim) {
        const selection = env.model.getters.getSelectedZone();
        const sheetId = env.model.getters.getActiveSheetId();
        env.model.dispatch("GROUP_HEADERS", {
            sheetId,
            dimension: dim,
            start: dim === "COL" ? selection.left : selection.top,
            end: dim === "COL" ? selection.right : selection.bottom,
        });
    }
    function ungroupHeaders(env, dim) {
        const selection = env.model.getters.getSelectedZone();
        const sheetId = env.model.getters.getActiveSheetId();
        env.model.dispatch("UNGROUP_HEADERS", {
            sheetId,
            dimension: dim,
            start: dim === "COL" ? selection.left : selection.top,
            end: dim === "COL" ? selection.right : selection.bottom,
        });
    }
    function canUngroupHeaders(env, dimension) {
        const sheetId = env.model.getters.getActiveSheetId();
        const selection = env.model.getters.getSelectedZones();
        return (selection.length === 1 &&
            env.model.getters.getHeaderGroupsInZone(sheetId, dimension, selection[0]).length > 0);
    }

    var ACTION_VIEW = /*#__PURE__*/Object.freeze({
        __proto__: null,
        canUngroupHeaders: canUngroupHeaders,
        createRemoveFilter: createRemoveFilter,
        createRemoveFilterAction: createRemoveFilterAction,
        freezeCurrentCol: freezeCurrentCol,
        freezeCurrentRow: freezeCurrentRow,
        freezeFirstCol: freezeFirstCol,
        freezeFirstRow: freezeFirstRow,
        freezePane: freezePane,
        freezeSecondCol: freezeSecondCol,
        freezeSecondRow: freezeSecondRow,
        groupColumns: groupColumns,
        groupRows: groupRows,
        hideCols: hideCols,
        hideRows: hideRows,
        unFreezeCols: unFreezeCols,
        unFreezePane: unFreezePane,
        unFreezeRows: unFreezeRows,
        ungroupColumns: ungroupColumns,
        ungroupRows: ungroupRows,
        unhideAllCols: unhideAllCols,
        unhideAllRows: unhideAllRows,
        unhideCols: unhideCols,
        unhideRows: unhideRows,
        viewFormulas: viewFormulas,
        viewGridlines: viewGridlines
    });

    const sortRange = {
        name: _t("Sort range"),
        isVisible: IS_ONLY_ONE_RANGE,
        icon: "o-spreadsheet-Icon.SORT_RANGE",
    };
    const sortAscending = {
        name: _t("Ascending (A ⟶ Z)"),
        execute: (env) => {
            const { anchor, zones } = env.model.getters.getSelection();
            const sheetId = env.model.getters.getActiveSheetId();
            interactiveSortSelection(env, sheetId, anchor.cell, zones[0], "ascending");
        },
        icon: "o-spreadsheet-Icon.SORT_ASCENDING",
    };
    const dataCleanup = {
        name: _t("Data cleanup"),
        icon: "o-spreadsheet-Icon.DATA_CLEANUP",
    };
    const removeDuplicates = {
        name: _t("Remove duplicates"),
        execute: (env) => {
            if (getZoneArea(env.model.getters.getSelectedZone()) === 1) {
                env.model.selection.selectTableAroundSelection();
            }
            env.openSidePanel("RemoveDuplicates", {});
        },
    };
    const trimWhitespace = {
        name: _t("Trim whitespace"),
        execute: (env) => {
            env.model.dispatch("TRIM_WHITESPACE");
        },
    };
    const sortDescending = {
        name: _t("Descending (Z ⟶ A)"),
        execute: (env) => {
            const { anchor, zones } = env.model.getters.getSelection();
            const sheetId = env.model.getters.getActiveSheetId();
            interactiveSortSelection(env, sheetId, anchor.cell, zones[0], "descending");
        },
        icon: "o-spreadsheet-Icon.SORT_DESCENDING",
    };
    const addRemoveDataFilter = {
        name: (env) => SELECTION_CONTAINS_FILTER(env) ? _t("Remove filter") : _t("Create filter"),
        execute: (env) => createRemoveFilterAction(env),
        isEnabled: (env) => {
            const selectedZones = env.model.getters.getSelectedZones();
            return areZonesContinuous(...selectedZones);
        },
        icon: "o-spreadsheet-Icon.MENU_FILTER_ICON",
    };
    const splitToColumns = {
        name: _t("Split text to columns"),
        sequence: 1,
        execute: (env) => env.openSidePanel("SplitToColumns", {}),
        isEnabled: (env) => env.model.getters.isSingleColSelected(),
        icon: "o-spreadsheet-Icon.SPLIT_TEXT",
    };

    /**
     * Create a format action specification for a given format.
     * The format can be dynamically computed from the environment.
     */
    function createFormatActionSpec({ name, format, descriptionValue, }) {
        const formatCallback = typeof format === "function" ? format : () => format;
        return {
            name,
            description: (env) => formatValue(descriptionValue, {
                format: formatCallback(env),
                locale: env.model.getters.getLocale(),
            }),
            execute: (env) => setFormatter(env, formatCallback(env)),
            isActive: (env) => isFormatSelected(env, formatCallback(env)),
        };
    }
    const formatNumberAutomatic = {
        name: _t("Automatic"),
        execute: (env) => setFormatter(env, ""),
        isActive: (env) => isAutomaticFormatSelected(env),
    };
    const formatNumberNumber = createFormatActionSpec({
        name: _t("Number"),
        descriptionValue: 1000.12,
        format: "#,##0.00",
    });
    const formatPercent = {
        name: _t("Format as percent"),
        execute: FORMAT_PERCENT_ACTION,
        icon: "o-spreadsheet-Icon.PERCENT",
    };
    const formatNumberPercent = createFormatActionSpec({
        name: _t("Percent"),
        descriptionValue: 0.1012,
        format: "0.00%",
    });
    const formatNumberCurrency = createFormatActionSpec({
        name: _t("Currency"),
        descriptionValue: 1000.12,
        format: (env) => env.model.config.defaultCurrencyFormat ?? DEFAULT_CURRENCY_FORMAT,
    });
    const formatNumberCurrencyRounded = {
        ...createFormatActionSpec({
            name: _t("Currency rounded"),
            descriptionValue: 1000,
            format: (env) => roundFormat(env.model.config.defaultCurrencyFormat ?? DEFAULT_CURRENCY_FORMAT),
        }),
        isVisible: (env) => {
            const currencyFormat = env.model.config.defaultCurrencyFormat;
            return currencyFormat !== roundFormat(currencyFormat ?? DEFAULT_CURRENCY_FORMAT);
        },
    };
    const DEFAULT_CURRENCY_FORMAT = "[$$]#,##0.00";
    const EXAMPLE_DATE = parseLiteral("2023/09/26 10:43:00 PM", DEFAULT_LOCALE);
    const formatCustomCurrency = {
        name: _t("Custom currency"),
        isVisible: (env) => env.loadCurrencies !== undefined,
        execute: (env) => env.openSidePanel("CustomCurrency", {}),
    };
    const formatNumberDate = createFormatActionSpec({
        name: _t("Date"),
        descriptionValue: EXAMPLE_DATE,
        format: (env) => env.model.getters.getLocale().dateFormat,
    });
    const formatNumberTime = createFormatActionSpec({
        name: _t("Time"),
        descriptionValue: EXAMPLE_DATE,
        format: (env) => env.model.getters.getLocale().timeFormat,
    });
    const formatNumberDateTime = createFormatActionSpec({
        name: _t("Date time"),
        descriptionValue: EXAMPLE_DATE,
        format: (env) => {
            const locale = env.model.getters.getLocale();
            return getDateTimeFormat(locale);
        },
    });
    const formatNumberDuration = createFormatActionSpec({
        name: _t("Duration"),
        descriptionValue: "27:51:38",
        format: "hhhh:mm:ss",
    });
    const moreFormats = {
        name: _t("More date formats"),
        execute: (env) => env.openSidePanel("MoreFormats", {}),
    };
    const formatNumberFullDateTime = createFormatActionSpec({
        name: _t("Full date time"),
        format: "dddd d mmmm yyyy hh:mm:ss a",
        descriptionValue: EXAMPLE_DATE,
    });
    const formatNumberFullWeekDayAndMonth = createFormatActionSpec({
        name: _t("Full week day and month"),
        format: "dddd d mmmm yyyy",
        descriptionValue: EXAMPLE_DATE,
    });
    const formatNumberDayAndFullMonth = createFormatActionSpec({
        name: _t("Day and full month"),
        format: "d mmmm yyyy",
        descriptionValue: EXAMPLE_DATE,
    });
    const formatNumberShortWeekDay = createFormatActionSpec({
        name: _t("Short week day"),
        format: "ddd d mmm yyyy",
        descriptionValue: EXAMPLE_DATE,
    });
    const formatNumberDayAndShortMonth = createFormatActionSpec({
        name: _t("Day and short month"),
        format: "d mmm yyyy",
        descriptionValue: EXAMPLE_DATE,
    });
    const formatNumberFullMonth = createFormatActionSpec({
        name: _t("Full month"),
        format: "mmmm yyyy",
        descriptionValue: EXAMPLE_DATE,
    });
    const formatNumberShortMonth = createFormatActionSpec({
        name: _t("Short month"),
        format: "mmm yyyy",
        descriptionValue: EXAMPLE_DATE,
    });
    const incraseDecimalPlaces = {
        name: _t("Increase decimal places"),
        icon: "o-spreadsheet-Icon.INCREASE_DECIMAL",
        execute: (env) => env.model.dispatch("SET_DECIMAL", {
            sheetId: env.model.getters.getActiveSheetId(),
            target: env.model.getters.getSelectedZones(),
            step: 1,
        }),
    };
    const decraseDecimalPlaces = {
        name: _t("Decrease decimal places"),
        icon: "o-spreadsheet-Icon.DECRASE_DECIMAL",
        execute: (env) => env.model.dispatch("SET_DECIMAL", {
            sheetId: env.model.getters.getActiveSheetId(),
            target: env.model.getters.getSelectedZones(),
            step: -1,
        }),
    };
    const formatBold = {
        name: _t("Bold"),
        description: "Ctrl+B",
        execute: (env) => setStyle(env, { bold: !env.model.getters.getCurrentStyle().bold }),
        icon: "o-spreadsheet-Icon.BOLD",
        isActive: (env) => !!env.model.getters.getCurrentStyle().bold,
    };
    const formatItalic = {
        name: _t("Italic"),
        description: "Ctrl+I",
        execute: (env) => setStyle(env, { italic: !env.model.getters.getCurrentStyle().italic }),
        icon: "o-spreadsheet-Icon.ITALIC",
        isActive: (env) => !!env.model.getters.getCurrentStyle().italic,
    };
    const formatUnderline = {
        name: _t("Underline"),
        description: "Ctrl+U",
        execute: (env) => setStyle(env, { underline: !env.model.getters.getCurrentStyle().underline }),
        icon: "o-spreadsheet-Icon.UNDERLINE",
        isActive: (env) => !!env.model.getters.getCurrentStyle().underline,
    };
    const formatStrikethrough = {
        name: _t("Strikethrough"),
        execute: (env) => setStyle(env, { strikethrough: !env.model.getters.getCurrentStyle().strikethrough }),
        icon: "o-spreadsheet-Icon.STRIKE",
        isActive: (env) => !!env.model.getters.getCurrentStyle().strikethrough,
    };
    const formatFontSize = {
        name: _t("Font size"),
        children: fontSizeMenuBuilder(),
        icon: "o-spreadsheet-Icon.FONT_SIZE",
    };
    const formatAlignment = {
        name: _t("Alignment"),
        icon: "o-spreadsheet-Icon.ALIGN_LEFT",
    };
    const formatAlignmentHorizontal = {
        name: _t("Horizontal align"),
        icon: (env) => getHorizontalAlignmentIcon(env),
    };
    const formatAlignmentLeft = {
        name: _t("Left"),
        description: "Ctrl+Shift+L",
        execute: (env) => setStyle(env, { align: "left" }),
        isActive: (env) => getHorizontalAlign(env) === "left",
        icon: "o-spreadsheet-Icon.ALIGN_LEFT",
    };
    const formatAlignmentCenter = {
        name: _t("Center"),
        description: "Ctrl+Shift+E",
        execute: (env) => setStyle(env, { align: "center" }),
        isActive: (env) => getHorizontalAlign(env) === "center",
        icon: "o-spreadsheet-Icon.ALIGN_CENTER",
    };
    const formatAlignmentRight = {
        name: _t("Right"),
        description: "Ctrl+Shift+R",
        execute: (env) => setStyle(env, { align: "right" }),
        isActive: (env) => getHorizontalAlign(env) === "right",
        icon: "o-spreadsheet-Icon.ALIGN_RIGHT",
    };
    const formatAlignmentVertical = {
        name: _t("Vertical align"),
        icon: (env) => getVerticalAlignmentIcon(env),
    };
    const formatAlignmentTop = {
        name: _t("Top"),
        execute: (env) => setStyle(env, { verticalAlign: "top" }),
        isActive: (env) => getVerticalAlign(env) === "top",
        icon: "o-spreadsheet-Icon.ALIGN_TOP",
    };
    const formatAlignmentMiddle = {
        name: _t("Middle"),
        execute: (env) => setStyle(env, { verticalAlign: "middle" }),
        isActive: (env) => getVerticalAlign(env) === "middle",
        icon: "o-spreadsheet-Icon.ALIGN_MIDDLE",
    };
    const formatAlignmentBottom = {
        name: _t("Bottom"),
        execute: (env) => setStyle(env, { verticalAlign: "bottom" }),
        isActive: (env) => getVerticalAlign(env) === "bottom",
        icon: "o-spreadsheet-Icon.ALIGN_BOTTOM",
    };
    const formatWrappingIcon = {
        name: _t("Wrapping"),
        icon: "o-spreadsheet-Icon.WRAPPING_OVERFLOW",
    };
    const formatWrapping = {
        name: _t("Wrapping"),
        icon: (env) => getWrapModeIcon(env),
    };
    const formatWrappingOverflow = {
        name: _t("Overflow"),
        execute: (env) => setStyle(env, { wrapping: "overflow" }),
        isActive: (env) => getWrappingMode(env) === "overflow",
        icon: "o-spreadsheet-Icon.WRAPPING_OVERFLOW",
    };
    const formatWrappingWrap = {
        name: _t("Wrap"),
        execute: (env) => setStyle(env, { wrapping: "wrap" }),
        isActive: (env) => getWrappingMode(env) === "wrap",
        icon: "o-spreadsheet-Icon.WRAPPING_WRAP",
    };
    const formatWrappingClip = {
        name: _t("Clip"),
        execute: (env) => setStyle(env, { wrapping: "clip" }),
        isActive: (env) => getWrappingMode(env) === "clip",
        icon: "o-spreadsheet-Icon.WRAPPING_CLIP",
    };
    const textColor = {
        name: _t("Text Color"),
        icon: "o-spreadsheet-Icon.TEXT_COLOR",
    };
    const fillColor = {
        name: _t("Fill Color"),
        icon: "o-spreadsheet-Icon.FILL_COLOR",
    };
    const formatCF = {
        name: _t("Conditional formatting"),
        execute: OPEN_CF_SIDEPANEL_ACTION,
        icon: "o-spreadsheet-Icon.CONDITIONAL_FORMAT",
    };
    const clearFormat = {
        name: _t("Clear formatting"),
        description: "Ctrl+<",
        execute: (env) => env.model.dispatch("CLEAR_FORMATTING", {
            sheetId: env.model.getters.getActiveSheetId(),
            target: env.model.getters.getSelectedZones(),
        }),
        icon: "o-spreadsheet-Icon.CLEAR_FORMAT",
    };
    function fontSizeMenuBuilder() {
        return FONT_SIZES.map((fs) => {
            return {
                name: fs.toString(),
                sequence: fs,
                id: `font_size_${fs}`,
                execute: (env) => setStyle(env, { fontSize: fs }),
                isActive: (env) => isFontSizeSelected(env, fs),
            };
        });
    }
    function isAutomaticFormatSelected(env) {
        const activeCell = env.model.getters.getCell(env.model.getters.getActivePosition());
        return !activeCell || !activeCell.format;
    }
    function isFormatSelected(env, format) {
        const activeCell = env.model.getters.getCell(env.model.getters.getActivePosition());
        return activeCell?.format === format;
    }
    function isFontSizeSelected(env, fontSize) {
        const currentFontSize = env.model.getters.getCurrentStyle().fontSize || DEFAULT_FONT_SIZE;
        return currentFontSize === fontSize;
    }
    function getHorizontalAlign(env) {
        const style = env.model.getters.getCurrentStyle();
        if (style.align) {
            return style.align;
        }
        const cell = env.model.getters.getActiveCell();
        return cell.defaultAlign;
    }
    function getVerticalAlign(env) {
        const style = env.model.getters.getCurrentStyle();
        if (style.verticalAlign) {
            return style.verticalAlign;
        }
        return DEFAULT_VERTICAL_ALIGN;
    }
    function getWrappingMode(env) {
        const style = env.model.getters.getCurrentStyle();
        if (style.wrapping) {
            return style.wrapping;
        }
        return DEFAULT_WRAPPING_MODE;
    }
    function getHorizontalAlignmentIcon(env) {
        const horizontalAlign = getHorizontalAlign(env);
        switch (horizontalAlign) {
            case "right":
                return "o-spreadsheet-Icon.ALIGN_RIGHT";
            case "center":
                return "o-spreadsheet-Icon.ALIGN_CENTER";
            default:
                return "o-spreadsheet-Icon.ALIGN_LEFT";
        }
    }
    function getVerticalAlignmentIcon(env) {
        const verticalAlign = getVerticalAlign(env);
        switch (verticalAlign) {
            case "top":
                return "o-spreadsheet-Icon.ALIGN_TOP";
            case "middle":
                return "o-spreadsheet-Icon.ALIGN_MIDDLE";
            default:
                return "o-spreadsheet-Icon.ALIGN_BOTTOM";
        }
    }
    function getWrapModeIcon(env) {
        const wrapMode = getWrappingMode(env);
        switch (wrapMode) {
            case "wrap":
                return "o-spreadsheet-Icon.WRAPPING_WRAP";
            case "clip":
                return "o-spreadsheet-Icon.WRAPPING_CLIP";
            default:
                return "o-spreadsheet-Icon.WRAPPING_OVERFLOW";
        }
    }

    var ACTION_FORMAT = /*#__PURE__*/Object.freeze({
        __proto__: null,
        clearFormat: clearFormat,
        decraseDecimalPlaces: decraseDecimalPlaces,
        fillColor: fillColor,
        formatAlignment: formatAlignment,
        formatAlignmentBottom: formatAlignmentBottom,
        formatAlignmentCenter: formatAlignmentCenter,
        formatAlignmentHorizontal: formatAlignmentHorizontal,
        formatAlignmentLeft: formatAlignmentLeft,
        formatAlignmentMiddle: formatAlignmentMiddle,
        formatAlignmentRight: formatAlignmentRight,
        formatAlignmentTop: formatAlignmentTop,
        formatAlignmentVertical: formatAlignmentVertical,
        formatBold: formatBold,
        formatCF: formatCF,
        formatCustomCurrency: formatCustomCurrency,
        formatFontSize: formatFontSize,
        formatItalic: formatItalic,
        formatNumberAutomatic: formatNumberAutomatic,
        formatNumberCurrency: formatNumberCurrency,
        formatNumberCurrencyRounded: formatNumberCurrencyRounded,
        formatNumberDate: formatNumberDate,
        formatNumberDateTime: formatNumberDateTime,
        formatNumberDayAndFullMonth: formatNumberDayAndFullMonth,
        formatNumberDayAndShortMonth: formatNumberDayAndShortMonth,
        formatNumberDuration: formatNumberDuration,
        formatNumberFullDateTime: formatNumberFullDateTime,
        formatNumberFullMonth: formatNumberFullMonth,
        formatNumberFullWeekDayAndMonth: formatNumberFullWeekDayAndMonth,
        formatNumberNumber: formatNumberNumber,
        formatNumberPercent: formatNumberPercent,
        formatNumberShortMonth: formatNumberShortMonth,
        formatNumberShortWeekDay: formatNumberShortWeekDay,
        formatNumberTime: formatNumberTime,
        formatPercent: formatPercent,
        formatStrikethrough: formatStrikethrough,
        formatUnderline: formatUnderline,
        formatWrapping: formatWrapping,
        formatWrappingClip: formatWrappingClip,
        formatWrappingIcon: formatWrappingIcon,
        formatWrappingOverflow: formatWrappingOverflow,
        formatWrappingWrap: formatWrappingWrap,
        incraseDecimalPlaces: incraseDecimalPlaces,
        moreFormats: moreFormats,
        textColor: textColor
    });

    const colMenuRegistry = new MenuItemRegistry();
    colMenuRegistry
        .add("cut", {
        ...cut,
        sequence: 10,
    })
        .add("copy", {
        ...copy,
        sequence: 20,
    })
        .add("paste", {
        ...paste,
        sequence: 30,
    })
        .add("paste_special", {
        ...pasteSpecial,
        sequence: 40,
        separator: true,
    })
        .addChild("paste_value_only", ["paste_special"], {
        ...pasteSpecialValue,
        sequence: 10,
    })
        .addChild("paste_format_only", ["paste_special"], {
        ...pasteSpecialFormat,
        sequence: 20,
    })
        .add("sort_columns", {
        ...sortRange,
        name: (env) => env.model.getters.getActiveCols().size > 1 ? _t("Sort columns") : _t("Sort column"),
        sequence: 50,
        separator: true,
    })
        .addChild("sort_ascending", ["sort_columns"], {
        ...sortAscending,
        sequence: 10,
    })
        .addChild("sort_descending", ["sort_columns"], {
        ...sortDescending,
        sequence: 20,
    })
        .add("add_column_before", {
        ...colInsertColsBefore,
        sequence: 70,
    })
        .add("add_column_after", {
        ...colInsertColsAfter,
        sequence: 80,
    })
        .add("delete_column", {
        ...deleteCols,
        sequence: 90,
        icon: "o-spreadsheet-Icon.DELETE",
    })
        .add("clear_column", {
        ...clearCols,
        sequence: 100,
        icon: "o-spreadsheet-Icon.CLEAR",
    })
        .add("hide_columns", {
        ...hideCols,
        sequence: 105,
        separator: true,
    })
        .add("unhide_columns", {
        ...unhideCols,
        sequence: 106,
        separator: true,
    })
        .add("conditional_formatting", {
        ...formatCF,
        sequence: 110,
        separator: true,
    })
        .add("group_columns", {
        sequence: 120,
        ...groupColumns,
    })
        .add("ungroup_columns", {
        sequence: 130,
        ...ungroupColumns,
        isVisible: (env) => canUngroupHeaders(env, "COL"),
    });

    const numberFormatMenuRegistry = new MenuItemRegistry();
    numberFormatMenuRegistry
        .add("format_number_automatic", {
        ...formatNumberAutomatic,
        sequence: 10,
        separator: true,
    })
        .add("format_number_number", {
        ...formatNumberNumber,
        sequence: 20,
    })
        .add("format_number_percent", {
        ...formatNumberPercent,
        sequence: 30,
        separator: true,
    })
        .add("format_number_currency", {
        ...formatNumberCurrency,
        sequence: 40,
    })
        .add("format_number_currency_rounded", {
        ...formatNumberCurrencyRounded,
        sequence: 50,
    })
        .add("format_custom_currency", {
        ...formatCustomCurrency,
        sequence: 60,
        separator: true,
    })
        .add("format_number_date", {
        ...formatNumberDate,
        sequence: 70,
    })
        .add("format_number_time", {
        ...formatNumberTime,
        sequence: 80,
    })
        .add("format_number_date_time", {
        ...formatNumberDateTime,
        sequence: 90,
    })
        .add("format_number_duration", {
        ...formatNumberDuration,
        sequence: 100,
        separator: true,
    })
        .add("more_formats", {
        ...moreFormats,
        sequence: 110,
    });
    const formatNumberMenuItemSpec = {
        name: _t("More formats"),
        icon: "o-spreadsheet-Icon.NUMBER_FORMATS",
        children: [() => numberFormatMenuRegistry.getAll()],
    };

    const rowMenuRegistry = new MenuItemRegistry();
    rowMenuRegistry
        .add("cut", {
        ...cut,
        sequence: 10,
    })
        .add("copy", {
        ...copy,
        sequence: 20,
    })
        .add("paste", {
        ...paste,
        sequence: 30,
    })
        .add("paste_special", {
        ...pasteSpecial,
        sequence: 40,
        separator: true,
    })
        .addChild("paste_value_only", ["paste_special"], {
        ...pasteSpecialValue,
        sequence: 10,
    })
        .addChild("paste_format_only", ["paste_special"], {
        ...pasteSpecialFormat,
        sequence: 20,
    })
        .add("add_row_before", {
        ...rowInsertRowBefore,
        sequence: 50,
    })
        .add("add_row_after", {
        ...rowInsertRowsAfter,
        sequence: 60,
    })
        .add("delete_row", {
        ...deleteRows,
        sequence: 70,
        icon: "o-spreadsheet-Icon.DELETE",
    })
        .add("clear_row", {
        ...clearRows,
        sequence: 80,
        icon: "o-spreadsheet-Icon.CLEAR",
    })
        .add("hide_rows", {
        ...hideRows,
        sequence: 85,
        separator: true,
    })
        .add("unhide_rows", {
        ...unhideRows,
        sequence: 86,
        separator: true,
    })
        .add("conditional_formatting", {
        ...formatCF,
        sequence: 90,
        separator: true,
    })
        .add("group_rows", {
        sequence: 100,
        ...groupRows,
    })
        .add("ungroup_rows", {
        sequence: 110,
        ...ungroupRows,
        isVisible: (env) => canUngroupHeaders(env, "ROW"),
    });

    function getSheetMenuRegistry(args) {
        const sheetMenuRegistry = new MenuItemRegistry();
        sheetMenuRegistry
            .add("delete", {
            ...deleteSheet,
            sequence: 10,
        })
            .add("duplicate", {
            ...duplicateSheet,
            sequence: 20,
        })
            .add("rename", {
            ...renameSheet(args),
            sequence: 30,
        })
            .add("move_right", {
            ...sheetMoveRight,
            sequence: 40,
        })
            .add("move_left", {
            ...sheetMoveLeft,
            sequence: 50,
        })
            .add("hide_sheet", {
            ...hideSheet,
            sequence: 60,
        });
        return sheetMenuRegistry;
    }

    const topbarMenuRegistry = new MenuItemRegistry();
    topbarMenuRegistry
        // ---------------------------------------------------------------------
        // FILE MENU ITEMS
        // ---------------------------------------------------------------------
        .add("file", {
        name: _t("File"),
        sequence: 10,
    })
        .addChild("settings", ["file"], {
        name: _t("Settings"),
        sequence: 100,
        execute: (env) => env.openSidePanel("Settings"),
        icon: "o-spreadsheet-Icon.COG",
    })
        // ---------------------------------------------------------------------
        // EDIT MENU ITEMS
        // ---------------------------------------------------------------------
        .add("edit", {
        name: _t("Edit"),
        sequence: 20,
    })
        .addChild("undo", ["edit"], {
        ...undo,
        sequence: 10,
    })
        .addChild("redo", ["edit"], {
        ...redo,
        sequence: 20,
        separator: true,
    })
        .addChild("copy", ["edit"], {
        ...copy,
        sequence: 30,
    })
        .addChild("cut", ["edit"], {
        ...cut,
        sequence: 40,
    })
        .addChild("paste", ["edit"], {
        ...paste,
        sequence: 50,
    })
        .addChild("paste_special", ["edit"], {
        ...pasteSpecial,
        sequence: 60,
        separator: true,
    })
        .addChild("paste_special_value", ["edit", "paste_special"], {
        ...pasteSpecialValue,
        sequence: 10,
    })
        .addChild("paste_special_format", ["edit", "paste_special"], {
        ...pasteSpecialFormat,
        sequence: 20,
    })
        .addChild("find_and_replace", ["edit"], {
        ...findAndReplace,
        sequence: 65,
        separator: true,
    })
        .addChild("delete", ["edit"], {
        name: _t("Delete"),
        icon: "o-spreadsheet-Icon.DELETE",
        sequence: 70,
    })
        .addChild("edit_delete_cell_values", ["edit", "delete"], {
        ...deleteValues,
        sequence: 10,
    })
        .addChild("edit_delete_row", ["edit", "delete"], {
        ...deleteRows,
        sequence: 20,
    })
        .addChild("edit_delete_column", ["edit", "delete"], {
        ...deleteCols,
        sequence: 30,
    })
        .addChild("edit_delete_cell_shift_up", ["edit", "delete"], {
        ...deleteCellShiftUp,
        sequence: 40,
    })
        .addChild("edit_delete_cell_shift_left", ["edit", "delete"], {
        ...deleteCellShiftLeft,
        sequence: 50,
    })
        .addChild("edit_unhide_columns", ["edit"], {
        ...unhideAllCols,
        sequence: 80,
    })
        .addChild("edit_unhide_rows", ["edit"], {
        ...unhideAllRows,
        sequence: 80,
    })
        // ---------------------------------------------------------------------
        // VIEW MENU ITEMS
        // ---------------------------------------------------------------------
        .add("view", {
        name: _t("View"),
        sequence: 30,
    })
        .addChild("unfreeze_panes", ["view"], {
        ...unFreezePane,
        sequence: 4,
    })
        .addChild("freeze_panes", ["view"], {
        ...freezePane,
        sequence: 5,
    })
        .addChild("unfreeze_rows", ["view", "freeze_panes"], {
        ...unFreezeRows,
        sequence: 5,
    })
        .addChild("freeze_first_row", ["view", "freeze_panes"], {
        ...freezeFirstRow,
        sequence: 10,
    })
        .addChild("freeze_second_row", ["view", "freeze_panes"], {
        ...freezeSecondRow,
        sequence: 15,
    })
        .addChild("freeze_current_row", ["view", "freeze_panes"], {
        ...freezeCurrentRow,
        sequence: 20,
        separator: true,
    })
        .addChild("unfreeze_columns", ["view", "freeze_panes"], {
        ...unFreezeCols,
        sequence: 25,
    })
        .addChild("freeze_first_col", ["view", "freeze_panes"], {
        ...freezeFirstCol,
        sequence: 30,
    })
        .addChild("freeze_second_col", ["view", "freeze_panes"], {
        ...freezeSecondCol,
        sequence: 35,
    })
        .addChild("freeze_current_col", ["view", "freeze_panes"], {
        ...freezeCurrentCol,
        sequence: 40,
    })
        .addChild("group_headers", ["view"], {
        name: _t("Group"),
        sequence: 15,
        separator: true,
        icon: "o-spreadsheet-Icon.PLUS_IN_BOX",
        isVisible: IS_ONLY_ONE_RANGE,
    })
        .addChild("group_columns", ["view", "group_headers"], {
        ...groupColumns,
        sequence: 5,
    })
        .addChild("ungroup_columns", ["view", "group_headers"], {
        ...ungroupColumns,
        isVisible: (env) => canUngroupHeaders(env, "COL"),
        sequence: 10,
    })
        .addChild("group_rows", ["view", "group_headers"], {
        ...groupRows,
        sequence: 15,
    })
        .addChild("ungroup_rows", ["view", "group_headers"], {
        ...ungroupRows,
        isVisible: (env) => canUngroupHeaders(env, "ROW"),
        sequence: 20,
    })
        .addChild("view_gridlines", ["view"], {
        ...viewGridlines,
        sequence: 15,
    })
        .addChild("view_formulas", ["view"], {
        ...viewFormulas,
        sequence: 20,
    })
        // ---------------------------------------------------------------------
        // INSERT MENU ITEMS
        // ---------------------------------------------------------------------
        .add("insert", {
        name: _t("Insert"),
        sequence: 40,
    })
        .addChild("insert_row", ["insert"], {
        ...insertRow,
        sequence: 10,
    })
        .addChild("insert_row_before", ["insert", "insert_row"], {
        ...topBarInsertRowsBefore,
        sequence: 10,
    })
        .addChild("insert_row_after", ["insert", "insert_row"], {
        ...topBarInsertRowsAfter,
        sequence: 20,
    })
        .addChild("insert_column", ["insert"], {
        ...insertCol,
        sequence: 20,
    })
        .addChild("insert_column_before", ["insert", "insert_column"], {
        ...topBarInsertColsBefore,
        sequence: 10,
    })
        .addChild("insert_column_after", ["insert", "insert_column"], {
        ...topBarInsertColsAfter,
        sequence: 20,
    })
        .addChild("insert_cell", ["insert"], {
        ...insertCell,
        sequence: 43,
    })
        .addChild("insert_cell_down", ["insert", "insert_cell"], {
        ...insertCellShiftDown,
        name: _t("Shift down"),
        sequence: 10,
    })
        .addChild("insert_cell_right", ["insert", "insert_cell"], {
        ...insertCellShiftRight,
        name: _t("Shift right"),
        sequence: 20,
    })
        .addChild("insert_sheet", ["insert"], {
        ...insertSheet,
        sequence: 80,
        separator: true,
    })
        .addChild("insert_chart", ["insert"], {
        ...insertChart,
        sequence: 50,
    })
        .addChild("insert_image", ["insert"], {
        ...insertImage,
        sequence: 55,
    })
        .addChild("insert_function", ["insert"], {
        ...insertFunction,
        sequence: 60,
    })
        .addChild("insert_function_sum", ["insert", "insert_function"], {
        ...insertFunctionSum,
        sequence: 0,
    })
        .addChild("insert_function_average", ["insert", "insert_function"], {
        ...insertFunctionAverage,
        sequence: 10,
    })
        .addChild("insert_function_count", ["insert", "insert_function"], {
        ...insertFunctionCount,
        sequence: 20,
    })
        .addChild("insert_function_max", ["insert", "insert_function"], {
        ...insertFunctionMax,
        sequence: 30,
    })
        .addChild("insert_function_min", ["insert", "insert_function"], {
        ...insertFunctionMin,
        sequence: 40,
        separator: true,
    })
        .addChild("categorie_function_all", ["insert", "insert_function"], {
        ...categorieFunctionAll,
        sequence: 50,
    })
        .addChild("categories_function_list", ["insert", "insert_function"], categoriesFunctionListMenuBuilder)
        .addChild("insert_link", ["insert"], {
        ...insertLink,
        separator: true,
        sequence: 70,
    })
        // ---------------------------------------------------------------------
        // FORMAT MENU ITEMS
        // ---------------------------------------------------------------------
        .add("format", { name: _t("Format"), sequence: 50 })
        .addChild("format_number", ["format"], {
        ...formatNumberMenuItemSpec,
        name: _t("Number"),
        sequence: 10,
        separator: true,
    })
        .addChild("format_bold", ["format"], {
        ...formatBold,
        sequence: 20,
    })
        .addChild("format_italic", ["format"], {
        ...formatItalic,
        sequence: 30,
    })
        .addChild("format_underline", ["format"], {
        ...formatUnderline,
        sequence: 40,
    })
        .addChild("format_strikethrough", ["format"], {
        ...formatStrikethrough,
        sequence: 50,
        separator: true,
    })
        .addChild("format_font_size", ["format"], {
        ...formatFontSize,
        sequence: 60,
        separator: true,
    })
        .addChild("format_alignment", ["format"], {
        ...formatAlignment,
        sequence: 70,
    })
        .addChild("format_alignment_left", ["format", "format_alignment"], {
        ...formatAlignmentLeft,
        sequence: 10,
    })
        .addChild("format_alignment_center", ["format", "format_alignment"], {
        ...formatAlignmentCenter,
        sequence: 20,
    })
        .addChild("format_alignment_right", ["format", "format_alignment"], {
        ...formatAlignmentRight,
        sequence: 30,
        separator: true,
    })
        .addChild("format_alignment_top", ["format", "format_alignment"], {
        ...formatAlignmentTop,
        sequence: 40,
    })
        .addChild("format_alignment_middle", ["format", "format_alignment"], {
        ...formatAlignmentMiddle,
        sequence: 50,
    })
        .addChild("format_alignment_bottom", ["format", "format_alignment"], {
        ...formatAlignmentBottom,
        sequence: 60,
        separator: true,
    })
        .addChild("format_wrapping", ["format"], {
        ...formatWrappingIcon,
        sequence: 80,
        separator: true,
    })
        .addChild("format_wrapping_overflow", ["format", "format_wrapping"], {
        ...formatWrappingOverflow,
        sequence: 10,
    })
        .addChild("format_wrapping_wrap", ["format", "format_wrapping"], {
        ...formatWrappingWrap,
        sequence: 20,
    })
        .addChild("format_wrapping_clip", ["format", "format_wrapping"], {
        ...formatWrappingClip,
        sequence: 30,
    })
        .addChild("format_cf", ["format"], {
        ...formatCF,
        sequence: 90,
        separator: true,
    })
        .addChild("format_clearFormat", ["format"], {
        ...clearFormat,
        sequence: 100,
        separator: true,
    })
        // ---------------------------------------------------------------------
        // DATA MENU ITEMS
        // ---------------------------------------------------------------------
        .add("data", {
        name: _t("Data"),
        sequence: 60,
    })
        .addChild("sort_range", ["data"], {
        ...sortRange,
        sequence: 10,
        separator: true,
    })
        .addChild("sort_ascending", ["data", "sort_range"], {
        ...sortAscending,
        sequence: 10,
    })
        .addChild("sort_descending", ["data", "sort_range"], {
        ...sortDescending,
        sequence: 20,
    })
        .addChild("data_cleanup", ["data"], {
        ...dataCleanup,
        sequence: 15,
    })
        .addChild("remove_duplicates", ["data", "data_cleanup"], {
        ...removeDuplicates,
        sequence: 10,
    })
        .addChild("trim_whitespace", ["data", "data_cleanup"], {
        ...trimWhitespace,
        sequence: 20,
    })
        .addChild("split_to_columns", ["data"], {
        ...splitToColumns,
        sequence: 20,
    })
        .addChild("data_validation", ["data"], {
        name: _t("Data Validation"),
        execute: (env) => {
            env.openSidePanel("DataValidation");
        },
        icon: "o-spreadsheet-Icon.DATA_VALIDATION",
        sequence: 30,
        separator: true,
    })
        .addChild("add_remove_data_filter", ["data"], {
        ...addRemoveDataFilter,
        sequence: 40,
        separator: true,
    });

    class OTRegistry extends Registry {
        /**
         * Add a transformation function to the registry. When the executed command
         * happened, all the commands in toTransforms should be transformed using the
         * transformation function given
         */
        addTransformation(executed, toTransforms, fn) {
            if (!this.content[executed]) {
                this.content[executed] = new Map();
            }
            for (const toTransform of toTransforms) {
                this.content[executed].set(toTransform, fn);
            }
            return this;
        }
        /**
         * Get the transformation function to transform the command toTransform, after
         * that the executed command happened.
         */
        getTransformation(toTransform, executed) {
            return this.content[executed] && this.content[executed].get(toTransform);
        }
    }
    const otRegistry = new OTRegistry();

    const arrowMap = {
        ArrowDown: "down",
        ArrowLeft: "left",
        ArrowRight: "right",
        ArrowUp: "up",
    };
    function updateSelectionWithArrowKeys(ev, selection) {
        const direction = arrowMap[ev.key];
        if (ev.shiftKey) {
            selection.resizeAnchorZone(direction, isCtrlKey(ev) ? "end" : 1);
        }
        else {
            selection.moveAnchorCell(direction, isCtrlKey(ev) ? "end" : 1);
        }
    }

    const uuidGenerator$1 = new UuidGenerator();
    css /* scss */ `
  .o-selection {
    .o-selection-input {
      padding: 2px 0px;

      input {
        padding: 4px 6px;
        border-radius: 4px;
        box-sizing: border-box;
      }
      input:focus {
        outline: none;
      }
      input.o-required,
      input.o-focused {
        border: 1px solid;
      }
      input.o-focused {
        border-width: 2px;
        padding: 3px 5px;
      }
      input.o-invalid {
        /* The background-color is similar to the bootstrap alert-danger class but, because of the commit 0358a76d,
         * which avoids being parasitized by the dark-mode in spreadsheet, we cannot use this class.
         * TODO: Replace with the bootstrap alert-danger class when we support dark mode
         */
        background-color: #ffdddd;
        border-width: 2px;
      }
      button.o-btn {
        color: #333;
      }
      button.o-btn-action {
        margin: 8px 1px;
        border-radius: 4px;
        border: 1px solid #dadce0;
        color: #188038;
        font-size: 14px;
        height: 25px;
      }
      .error-icon {
        right: 7px;
        top: 7px;
      }
    }
    /** Make the character a bit bigger
    compared to its neighbor INPUT box  */
    .o-remove-selection {
      font-size: calc(100% + 4px);
    }
  }
`;
    /**
     * This component can be used when the user needs to input some
     * ranges. He can either input the ranges with the regular DOM `<input/>`
     * displayed or by selecting zones on the grid.
     *
     * onSelectionChanged is called every time the input value
     * changes.
     */
    class SelectionInput extends owl.Component {
        static template = "o-spreadsheet-SelectionInput";
        id = uuidGenerator$1.smallUuid();
        previousRanges = this.props.ranges() || [];
        originSheet = this.env.model.getters.getActiveSheetId();
        state = owl.useState({
            isMissing: false,
            mode: "select-range",
        });
        focusedInput = owl.useRef("focusedInput");
        get ranges() {
            const existingSelectionRanges = this.env.model.getters.getSelectionInput(this.id);
            const ranges = existingSelectionRanges.length
                ? existingSelectionRanges
                : this.props.ranges().map((xc, id) => ({
                    xc,
                    id: id + 1,
                    isFocused: false,
                }));
            return ranges.map((range) => ({
                ...range,
                isValidRange: range.xc === "" || this.env.model.getters.isRangeValid(range.xc),
            }));
        }
        get hasFocus() {
            return this.ranges.filter((i) => i.isFocused).length > 0;
        }
        get canAddRange() {
            return !this.props.hasSingleRange;
        }
        get isInvalid() {
            return this.props.isInvalid || this.state.isMissing;
        }
        get isConfirmable() {
            return this.hasFocus && this.ranges.every((range) => range.isValidRange);
        }
        get isResettable() {
            return this.previousRanges.join() !== this.ranges.map((r) => r.xc).join();
        }
        setup() {
            owl.useEffect(() => this.focusedInput.el?.focus(), () => [this.focusedInput.el]);
            owl.onMounted(() => this.enableNewSelectionInput());
            owl.onWillUnmount(async () => this.disableNewSelectionInput());
            owl.onPatched(() => this.checkChange());
        }
        enableNewSelectionInput() {
            this.env.model.dispatch("ENABLE_NEW_SELECTION_INPUT", {
                id: this.id,
                initialRanges: this.props.ranges(),
                hasSingleRange: this.props.hasSingleRange,
            });
        }
        disableNewSelectionInput() {
            this.env.model.dispatch("DISABLE_SELECTION_INPUT", { id: this.id });
        }
        checkChange() {
            const value = this.env.model.getters.getSelectionInputValue(this.id);
            const valid = !this.isInvalid && this.ranges.every((range) => range.isValidRange);
            if (valid && this.previousRanges.join() !== value.join()) {
                this.triggerChange();
            }
        }
        getColor(range) {
            const color = range.color || "#000";
            return "color: " + color + ";";
        }
        triggerChange() {
            const ranges = this.env.model.getters.getSelectionInputValue(this.id);
            this.props.onSelectionChanged?.(ranges);
        }
        onKeydown(ev) {
            if (ev.key === "F2") {
                ev.preventDefault();
                ev.stopPropagation();
                this.state.mode = this.state.mode === "select-range" ? "text-edit" : "select-range";
            }
            else if (ev.key.startsWith("Arrow")) {
                ev.stopPropagation();
                if (this.state.mode === "select-range") {
                    ev.preventDefault();
                    updateSelectionWithArrowKeys(ev, this.env.model.selection);
                }
            }
            else if (ev.key === "Enter") {
                const target = ev.target;
                target.blur();
                this.confirm();
            }
        }
        extractRanges(value) {
            return this.props.hasSingleRange ? value.split(",")[0] : value;
        }
        focus(rangeId) {
            this.state.isMissing = false;
            this.state.mode = "select-range";
            this.env.model.dispatch("FOCUS_RANGE", {
                id: this.id,
                rangeId,
            });
        }
        addEmptyInput() {
            this.env.model.dispatch("ADD_EMPTY_RANGE", { id: this.id });
        }
        removeInput(rangeId) {
            this.env.model.dispatch("REMOVE_RANGE", { id: this.id, rangeId });
            this.triggerChange();
            this.props.onSelectionConfirmed?.();
        }
        onInputChanged(rangeId, ev) {
            const target = ev.target;
            const value = this.extractRanges(target.value);
            this.env.model.dispatch("CHANGE_RANGE", {
                id: this.id,
                rangeId,
                value,
            });
            this.triggerChange();
        }
        reset() {
            this.env.model.dispatch("ENABLE_NEW_SELECTION_INPUT", {
                id: this.id,
                initialRanges: this.previousRanges,
                hasSingleRange: this.props.hasSingleRange,
            });
            this.confirm();
        }
        confirm() {
            let anyValidInput = false;
            const existingSelectionRanges = this.env.model.getters.getSelectionInput(this.id);
            const existingSelectionXcs = [];
            for (const range of existingSelectionRanges) {
                if (range.xc === "") {
                    const result = this.env.model.dispatch("REMOVE_RANGE", {
                        id: this.id,
                        rangeId: range.id,
                    });
                    if (result.isSuccessful) {
                        continue;
                    }
                }
                existingSelectionXcs.push(range.xc);
                if (this.env.model.getters.isRangeValid(range.xc)) {
                    anyValidInput = true;
                }
            }
            if (this.props.required && !anyValidInput) {
                this.state.isMissing = true;
            }
            const activeSheetId = this.env.model.getters.getActiveSheetId();
            if (this.originSheet !== activeSheetId) {
                this.env.model.dispatch("ACTIVATE_SHEET", {
                    sheetIdFrom: activeSheetId,
                    sheetIdTo: this.originSheet,
                });
            }
            this.props.onSelectionChanged?.(existingSelectionXcs);
            this.props.onSelectionConfirmed?.();
            this.previousRanges = this.props.ranges();
            if (existingSelectionXcs.join() !== this.previousRanges.join()) {
                this.enableNewSelectionInput();
            }
            this.env.model.dispatch("UNFOCUS_SELECTION_INPUT");
        }
    }
    SelectionInput.props = {
        ranges: Function,
        hasSingleRange: { type: Boolean, optional: true },
        required: { type: Boolean, optional: true },
        isInvalid: { type: Boolean, optional: true },
        class: { type: String, optional: true },
        onSelectionChanged: { type: Function, optional: true },
        onSelectionConfirmed: { type: Function, optional: true },
    };

    css /* scss */ `
  .o-validation-error,
  .o-validation-warning {
    margin-top: 10px;

    .o-icon {
      margin-right: 5px;
      height: 1.2em;
      width: 1.2em;
    }
  }
`;
    class ValidationMessages extends owl.Component {
        static template = "o-spreadsheet-ValidationMessages";
        get divClasses() {
            if (this.props.msgType === "warning") {
                return "o-validation-warning text-warning";
            }
            return "o-validation-error text-danger";
        }
    }
    ValidationMessages.props = {
        messages: Array,
        msgType: String,
    };

    class LineBarPieConfigPanel extends owl.Component {
        static template = "o-spreadsheet-LineBarPieConfigPanel";
        static components = { SelectionInput, ValidationMessages };
        state = owl.useState({
            datasetDispatchResult: undefined,
            labelsDispatchResult: undefined,
        });
        dataSeriesRanges = [];
        labelRange;
        setup() {
            this.dataSeriesRanges = this.props.definition.dataSets;
            this.labelRange = this.props.definition.labelRange;
        }
        get errorMessages() {
            const cancelledReasons = [
                ...(this.state.datasetDispatchResult?.reasons || []),
                ...(this.state.labelsDispatchResult?.reasons || []),
            ];
            return cancelledReasons.map((error) => ChartTerms.Errors[error] || ChartTerms.Errors.Unexpected);
        }
        get isDatasetInvalid() {
            return !!this.state.datasetDispatchResult?.isCancelledBecause("InvalidDataSet" /* CommandResult.InvalidDataSet */);
        }
        get isLabelInvalid() {
            return !!this.state.labelsDispatchResult?.isCancelledBecause("InvalidLabelRange" /* CommandResult.InvalidLabelRange */);
        }
        onUpdateDataSetsHaveTitle(ev) {
            this.props.updateChart(this.props.figureId, {
                dataSetsHaveTitle: ev.target.checked,
            });
        }
        /**
         * Change the local dataSeriesRanges. The model should be updated when the
         * button "confirm" is clicked
         */
        onDataSeriesRangesChanged(ranges) {
            this.dataSeriesRanges = ranges;
            this.state.datasetDispatchResult = this.props.canUpdateChart(this.props.figureId, {
                dataSets: this.dataSeriesRanges,
            });
        }
        onDataSeriesConfirmed() {
            this.dataSeriesRanges = spreadRange(this.env.model.getters, this.dataSeriesRanges);
            this.state.datasetDispatchResult = this.props.updateChart(this.props.figureId, {
                dataSets: this.dataSeriesRanges,
            });
        }
        getDataSeriesRanges() {
            return this.dataSeriesRanges;
        }
        /**
         * Change the local labelRange. The model should be updated when the
         * button "confirm" is clicked
         */
        onLabelRangeChanged(ranges) {
            this.labelRange = ranges[0];
            this.state.labelsDispatchResult = this.props.canUpdateChart(this.props.figureId, {
                labelRange: this.labelRange,
            });
        }
        onLabelRangeConfirmed() {
            this.state.labelsDispatchResult = this.props.updateChart(this.props.figureId, {
                labelRange: this.labelRange,
            });
        }
        getLabelRange() {
            return this.labelRange || "";
        }
        onUpdateAggregated(ev) {
            this.props.updateChart(this.props.figureId, {
                aggregated: ev.target.checked,
            });
        }
        calculateHeaderPosition() {
            if (this.isDatasetInvalid || this.isLabelInvalid) {
                return undefined;
            }
            const getters = this.env.model.getters;
            const sheetId = getters.getActiveSheetId();
            const labelRange = createValidRange(getters, sheetId, this.labelRange);
            const dataSets = createDataSets(getters, this.dataSeriesRanges, sheetId, this.props.definition.dataSetsHaveTitle);
            if (dataSets.length) {
                return dataSets[0].dataRange.zone.top + 1;
            }
            else if (labelRange) {
                return labelRange.zone.top + 1;
            }
            return undefined;
        }
    }
    LineBarPieConfigPanel.props = {
        figureId: String,
        definition: Object,
        updateChart: Function,
        canUpdateChart: Function,
    };

    class BarConfigPanel extends LineBarPieConfigPanel {
        static template = "o-spreadsheet-BarConfigPanel";
        onUpdateStacked(ev) {
            this.props.updateChart(this.props.figureId, {
                stacked: ev.target.checked,
            });
        }
        onUpdateAggregated(ev) {
            this.props.updateChart(this.props.figureId, {
                aggregated: ev.target.checked,
            });
        }
    }

    /**
     * Start listening to pointer events and apply the given callbacks.
     *
     * @returns A function to remove the listeners.
     */
    function startDnd(onMouseMove, onMouseUp, onMouseDown = () => { }) {
        const removeListeners = () => {
            window.removeEventListener("mousedown", onMouseDown);
            window.removeEventListener("mouseup", _onMouseUp);
            window.removeEventListener("dragstart", _onDragStart);
            window.removeEventListener("mousemove", onMouseMove);
            window.removeEventListener("wheel", onMouseMove);
        };
        const _onMouseUp = (ev) => {
            onMouseUp(ev);
            removeListeners();
        };
        function _onDragStart(ev) {
            ev.preventDefault();
        }
        window.addEventListener("mousedown", onMouseDown);
        window.addEventListener("mouseup", _onMouseUp);
        window.addEventListener("dragstart", _onDragStart);
        window.addEventListener("mousemove", onMouseMove);
        // mouse wheel on window is by default a passive event.
        // preventDefault() is not allowed in passive event handler.
        // https://chromestatus.com/feature/6662647093133312
        window.addEventListener("wheel", onMouseMove, { passive: false });
        return removeListeners;
    }
    /**
     * Function to be used during a mousedown event, this function allows to
     * perform actions related to the mousemove and mouseup events and adjusts the viewport
     * when the new position related to the mousemove event is outside of it.
     * Among inputs are two callback functions. First intended for actions performed during
     * the mousemove event, it receives as parameters the current position of the mousemove
     * (occurrence of the current column and the current row). Second intended for actions
     * performed during the mouseup event.
     */
    function dragAndDropBeyondTheViewport(env, cbMouseMove, cbMouseUp, only = false) {
        let timeOutId = null;
        let currentEv;
        let previousEv;
        let startingEv;
        let startingX;
        let startingY;
        const getters = env.model.getters;
        const sheetId = getters.getActiveSheetId();
        const position = gridOverlayPosition();
        let colIndex;
        let rowIndex;
        const onMouseDown = (ev) => {
            previousEv = ev;
            startingEv = ev;
            startingX = startingEv.clientX - position.left;
            startingY = startingEv.clientY - position.top;
        };
        const onMouseMove = (ev) => {
            currentEv = ev;
            if (timeOutId) {
                return;
            }
            const { x: offsetCorrectionX, y: offsetCorrectionY } = getters.getMainViewportCoordinates();
            let { top, left, bottom, right } = getters.getActiveMainViewport();
            let { scrollX, scrollY } = getters.getActiveSheetDOMScrollInfo();
            const { xSplit, ySplit } = getters.getPaneDivisions(sheetId);
            let canEdgeScroll = false;
            let timeoutDelay = MAX_DELAY;
            const x = currentEv.clientX - position.left;
            colIndex = getters.getColIndex(x);
            if (only !== "vertical") {
                const previousX = previousEv.clientX - position.left;
                const edgeScrollInfoX = getters.getEdgeScrollCol(x, previousX, startingX);
                if (edgeScrollInfoX.canEdgeScroll) {
                    canEdgeScroll = true;
                    timeoutDelay = Math.min(timeoutDelay, edgeScrollInfoX.delay);
                    let newTarget;
                    switch (edgeScrollInfoX.direction) {
                        case "reset":
                            colIndex = xSplit;
                            newTarget = xSplit;
                            break;
                        case 1:
                            colIndex = right;
                            newTarget = left + 1;
                            break;
                        case -1:
                            colIndex = left - 1;
                            while (env.model.getters.isColHidden(sheetId, colIndex)) {
                                colIndex--;
                            }
                            newTarget = colIndex;
                            break;
                    }
                    scrollX = getters.getColDimensions(sheetId, newTarget).start - offsetCorrectionX;
                }
            }
            const y = currentEv.clientY - position.top;
            rowIndex = getters.getRowIndex(y);
            if (only !== "horizontal") {
                const previousY = previousEv.clientY - position.top;
                const edgeScrollInfoY = getters.getEdgeScrollRow(y, previousY, startingY);
                if (edgeScrollInfoY.canEdgeScroll) {
                    canEdgeScroll = true;
                    timeoutDelay = Math.min(timeoutDelay, edgeScrollInfoY.delay);
                    let newTarget;
                    switch (edgeScrollInfoY.direction) {
                        case "reset":
                            rowIndex = ySplit;
                            newTarget = ySplit;
                            break;
                        case 1:
                            rowIndex = bottom;
                            newTarget = top + edgeScrollInfoY.direction;
                            break;
                        case -1:
                            rowIndex = top - 1;
                            while (env.model.getters.isRowHidden(sheetId, rowIndex)) {
                                rowIndex--;
                            }
                            newTarget = rowIndex;
                            break;
                    }
                    scrollY = env.model.getters.getRowDimensions(sheetId, newTarget).start - offsetCorrectionY;
                }
            }
            if (!canEdgeScroll) {
                if (rowIndex === -1) {
                    rowIndex = y < 0 ? 0 : getters.getNumberRows(sheetId) - 1;
                }
                if (colIndex === -1 && x < 0) {
                    colIndex = x < 0 ? 0 : getters.getNumberCols(sheetId) - 1;
                }
            }
            cbMouseMove(colIndex, rowIndex, currentEv);
            if (canEdgeScroll) {
                env.model.dispatch("SET_VIEWPORT_OFFSET", { offsetX: scrollX, offsetY: scrollY });
                timeOutId = setTimeout(() => {
                    timeOutId = null;
                    onMouseMove(currentEv);
                }, Math.round(timeoutDelay));
            }
            previousEv = currentEv;
        };
        const onMouseUp = () => {
            clearTimeout(timeOutId);
            cbMouseUp();
        };
        startDnd(onMouseMove, onMouseUp, onMouseDown);
    }

    const LINE_VERTICAL_PADDING = 1;
    const PICKER_PADDING = 8;
    const ITEM_BORDER_WIDTH = 1;
    const ITEM_EDGE_LENGTH = 18;
    const ITEMS_PER_LINE = 10;
    const MAGNIFIER_EDGE = 16;
    const ITEM_GAP = 2;
    const CONTENT_WIDTH = ITEMS_PER_LINE * (ITEM_EDGE_LENGTH + 2 * ITEM_BORDER_WIDTH) + (ITEMS_PER_LINE - 1) * ITEM_GAP;
    const INNER_GRADIENT_WIDTH = CONTENT_WIDTH - 2 * ITEM_BORDER_WIDTH;
    const INNER_GRADIENT_HEIGHT = CONTENT_WIDTH - 30 - 2 * ITEM_BORDER_WIDTH;
    const CONTAINER_WIDTH = CONTENT_WIDTH + 2 * PICKER_PADDING;
    css /* scss */ `
  .o-color-picker {
    padding: ${PICKER_PADDING}px 0;
    /** FIXME: this is useless, overiden by the popover container */
    box-shadow: 1px 2px 5px 2px rgba(51, 51, 51, 0.15);
    background-color: white;
    line-height: 1.2;
    overflow-y: auto;
    overflow-x: hidden;
    width: ${CONTAINER_WIDTH}px;

    .o-color-picker-section-name {
      margin: 0px ${ITEM_BORDER_WIDTH}px;
      padding: 4px ${PICKER_PADDING}px;
    }
    .colors-grid {
      display: grid;
      padding: ${LINE_VERTICAL_PADDING}px ${PICKER_PADDING}px;
      grid-template-columns: repeat(${ITEMS_PER_LINE}, 1fr);
      grid-gap: ${ITEM_GAP}px;
    }
    .o-color-picker-toggler-button {
      display: flex;
      .o-color-picker-toggler-sign {
        display: flex;
        margin: auto auto;
        width: 55%;
        height: 55%;
        .o-icon {
          width: 100%;
          height: 100%;
        }
      }
    }
    .o-color-picker-line-item {
      width: ${ITEM_EDGE_LENGTH}px;
      height: ${ITEM_EDGE_LENGTH}px;
      margin: 0px;
      border-radius: 50px;
      border: ${ITEM_BORDER_WIDTH}px solid #666666;
      padding: 0px;
      font-size: 16px;
      background: white;
      &:hover {
        background-color: rgba(0, 0, 0, 0.08);
        outline: 1px solid gray;
        cursor: pointer;
      }
    }
    .o-buttons {
      padding: ${PICKER_PADDING}px;
      display: flex;
      .o-cancel {
        border: ${ITEM_BORDER_WIDTH}px solid #c0c0c0;
        width: 100%;
        padding: 5px;
        font-size: 14px;
        background: white;
        border-radius: 4px;
        box-sizing: border-box;
        &:hover:enabled {
          background-color: rgba(0, 0, 0, 0.08);
        }
      }
    }
    .o-add-button {
      border: ${ITEM_BORDER_WIDTH}px solid #c0c0c0;
      padding: 4px;
      background: white;
      border-radius: 4px;
      &:hover:enabled {
        background-color: rgba(0, 0, 0, 0.08);
      }
    }
    .o-separator {
      border-bottom: ${MENU_SEPARATOR_BORDER_WIDTH}px solid ${SEPARATOR_COLOR};
      margin-top: ${MENU_SEPARATOR_PADDING}px;
      margin-bottom: ${MENU_SEPARATOR_PADDING}px;
    }

    .o-custom-selector {
      padding: ${PICKER_PADDING + 2}px ${PICKER_PADDING}px;
      position: relative;
      .o-gradient {
        margin-bottom: ${MAGNIFIER_EDGE / 2}px;
        border: ${ITEM_BORDER_WIDTH}px solid #c0c0c0;
        box-sizing: border-box;
        width: ${INNER_GRADIENT_WIDTH + 2 * ITEM_BORDER_WIDTH}px;
        height: ${INNER_GRADIENT_HEIGHT + 2 * ITEM_BORDER_WIDTH}px;
        position: relative;
      }

      .magnifier {
        height: ${MAGNIFIER_EDGE}px;
        width: ${MAGNIFIER_EDGE}px;
        box-sizing: border-box;
        border-radius: 50%;
        border: 2px solid #fff;
        box-shadow: 0px 0px 3px #c0c0c0;
        position: absolute;
        z-index: 2;
      }
      .saturation {
        background: linear-gradient(to right, #fff 0%, transparent 100%);
      }
      .lightness {
        background: linear-gradient(to top, #000 0%, transparent 100%);
      }
      .o-hue-picker {
        border: ${ITEM_BORDER_WIDTH}px solid #c0c0c0;
        box-sizing: border-box;
        width: 100%;
        height: 12px;
        border-radius: 4px;
        background: linear-gradient(
          to right,
          hsl(0 100% 50%) 0%,
          hsl(0.2turn 100% 50%) 20%,
          hsl(0.3turn 100% 50%) 30%,
          hsl(0.4turn 100% 50%) 40%,
          hsl(0.5turn 100% 50%) 50%,
          hsl(0.6turn 100% 50%) 60%,
          hsl(0.7turn 100% 50%) 70%,
          hsl(0.8turn 100% 50%) 80%,
          hsl(0.9turn 100% 50%) 90%,
          hsl(1turn 100% 50%) 100%
        );
        position: relative;
        cursor: crosshair;
      }
      .o-hue-slider {
        margin-top: -3px;
      }
      .o-custom-input-preview {
        padding: 2px 0px;
        display: flex;
        input {
          box-sizing: border-box;
          width: 50%;
          border-radius: 4px;
          padding: 4px 23px 4px 10px;
          height: 24px;
          border: 1px solid #c0c0c0;
          margin-right: 2px;
        }
        .o-wrong-color {
          /** FIXME bootstrap class instead? */
          outline-color: red;
          border-color: red;
          &:focus {
            outline-style: solid;
            outline-width: 1px;
          }
        }
      }
      .o-custom-input-buttons {
        padding: 2px 0px;
        display: flex;
        justify-content: end;
      }
      .o-color-preview {
        border: 1px solid #c0c0c0;
        border-radius: 4px;
        width: 50%;
      }
    }
  }
`;
    class ColorPicker extends owl.Component {
        static template = "o-spreadsheet-ColorPicker";
        static defaultProps = { currentColor: "" };
        static components = { Popover };
        COLORS = COLOR_PICKER_DEFAULTS;
        state = owl.useState({
            showGradient: false,
            currentHslaColor: isColorValid(this.props.currentColor)
                ? { ...hexToHSLA(this.props.currentColor), a: 1 }
                : { h: 0, s: 100, l: 100, a: 1 },
            customHexColor: isColorValid(this.props.currentColor) ? toHex(this.props.currentColor) : "",
        });
        get colorPickerStyle() {
            if (this.props.maxHeight !== undefined && this.props.maxHeight <= 0) {
                return cssPropertiesToCss({ display: "none" });
            }
            return "";
        }
        get popoverProps() {
            return {
                anchorRect: this.props.anchorRect,
                maxHeight: this.props.maxHeight,
                positioning: "BottomLeft",
                verticalOffset: 0,
            };
        }
        get gradientHueStyle() {
            const hue = this.state.currentHslaColor?.h || 0;
            return cssPropertiesToCss({
                background: `hsl(${hue} 100% 50%)`,
            });
        }
        get sliderStyle() {
            const hue = this.state.currentHslaColor?.h || 0;
            const delta = Math.round((hue / 360) * INNER_GRADIENT_WIDTH);
            const left = clip(delta, 1, INNER_GRADIENT_WIDTH) - ICON_EDGE_LENGTH / 2;
            return cssPropertiesToCss({
                "margin-left": `${left}px`,
            });
        }
        get pointerStyle() {
            const { s, l } = this.state.currentHslaColor || { s: 0, l: 0 };
            const left = Math.round(INNER_GRADIENT_WIDTH * clip(s / 100, 0, 1));
            const top = Math.round(INNER_GRADIENT_HEIGHT * clip(1 - (2 * l) / (200 - s), 0, 1));
            return cssPropertiesToCss({
                left: `${-MAGNIFIER_EDGE / 2 + left}px`,
                top: `${-MAGNIFIER_EDGE / 2 + top}px`,
                background: hslaToHex(this.state.currentHslaColor),
            });
        }
        get colorPreviewStyle() {
            return cssPropertiesToCss({
                "background-color": hslaToHex(this.state.currentHslaColor),
            });
        }
        get checkmarkColor() {
            return chartFontColor(this.props.currentColor);
        }
        get isHexColorInputValid() {
            return !this.state.customHexColor || isColorValid(this.state.customHexColor);
        }
        setCustomGradient({ x, y }) {
            const offsetX = clip(x, 0, INNER_GRADIENT_WIDTH);
            const offsetY = clip(y, 0, INNER_GRADIENT_HEIGHT);
            const deltaX = offsetX / INNER_GRADIENT_WIDTH;
            const deltaY = offsetY / INNER_GRADIENT_HEIGHT;
            const s = 100 * deltaX;
            const l = 100 * (1 - deltaY) * (1 - 0.5 * deltaX);
            this.updateColor({ s, l });
        }
        setCustomHue(x) {
            // needs to be capped such that h is in [0°, 359°]
            const h = Math.round(clip((360 * x) / INNER_GRADIENT_WIDTH, 0, 359));
            this.updateColor({ h });
        }
        updateColor(newHsl) {
            this.state.currentHslaColor = { ...this.state.currentHslaColor, ...newHsl };
            this.state.customHexColor = hslaToHex(this.state.currentHslaColor);
        }
        onColorClick(color) {
            if (color) {
                this.props.onColorPicked(toHex(color));
            }
        }
        resetColor() {
            this.props.onColorPicked("");
        }
        toggleColorPicker() {
            this.state.showGradient = !this.state.showGradient;
        }
        dragGradientPointer(ev) {
            const initialGradientCoordinates = { x: ev.offsetX, y: ev.offsetY };
            this.setCustomGradient(initialGradientCoordinates);
            const initialMousePosition = { x: ev.clientX, y: ev.clientY };
            const onMouseMove = (ev) => {
                const currentMousePosition = { x: ev.clientX, y: ev.clientY };
                const deltaX = currentMousePosition.x - initialMousePosition.x;
                const deltaY = currentMousePosition.y - initialMousePosition.y;
                const currentGradientCoordinates = {
                    x: initialGradientCoordinates.x + deltaX,
                    y: initialGradientCoordinates.y + deltaY,
                };
                this.setCustomGradient(currentGradientCoordinates);
            };
            startDnd(onMouseMove, () => { });
        }
        dragHuePointer(ev) {
            const initialX = ev.offsetX;
            const initialMouseX = ev.clientX;
            this.setCustomHue(initialX);
            const onMouseMove = (ev) => {
                const currentMouseX = ev.clientX;
                const deltaX = currentMouseX - initialMouseX;
                const x = initialX + deltaX;
                this.setCustomHue(x);
            };
            startDnd(onMouseMove, () => { });
        }
        setHexColor(ev) {
            // only support HEX code input
            const val = ev.target.value.replace("##", "#").slice(0, 7);
            this.state.customHexColor = val;
            if (!isColorValid(val)) ;
            else {
                this.state.currentHslaColor = { ...hexToHSLA(val), a: 1 };
            }
        }
        addCustomColor(ev) {
            if (!isHSLAValid(this.state.currentHslaColor) || !isColorValid(this.state.customHexColor)) {
                return;
            }
            this.props.onColorPicked(toHex(this.state.customHexColor));
        }
        isSameColor(color1, color2) {
            return isSameColor(color1, color2);
        }
    }
    ColorPicker.props = {
        onColorPicked: Function,
        currentColor: { type: String, optional: true },
        maxHeight: { type: Number, optional: true },
        anchorRect: Object,
        disableNoColor: { type: Boolean, optional: true },
    };

    css /* scss */ `
  .o-color-picker-widget {
    display: flex;
    position: relative;
    align-items: center;

    .o-color-picker-button-style {
      display: flex;
      justify-content: center;
      align-items: center;
      margin: 2px;
      padding: 3px;
      border-radius: 2px;
      cursor: pointer;
      &:not([disabled]):hover {
        background-color: rgba(0, 0, 0, 0.08);
      }
    }

    .o-color-picker-button {
      height: 30px;
      > span {
        border-bottom: 4px solid;
        height: 16px;
        margin-top: 2px;
      }

      &[disabled] {
        pointer-events: none;
        opacity: 0.3;
      }
    }
  }
`;
    class ColorPickerWidget extends owl.Component {
        static template = "o-spreadsheet-ColorPickerWidget";
        static components = { ColorPicker };
        colorPickerButtonRef = owl.useRef("colorPickerButton");
        get iconStyle() {
            return this.props.currentColor
                ? `border-color: ${this.props.currentColor}`
                : "border-bottom-style: hidden";
        }
        get colorPickerAnchorRect() {
            const button = this.colorPickerButtonRef.el;
            const buttonRect = button.getBoundingClientRect();
            return {
                x: buttonRect.x,
                y: buttonRect.y,
                width: buttonRect.width,
                height: buttonRect.height,
            };
        }
    }
    ColorPickerWidget.props = {
        currentColor: { type: String, optional: true },
        toggleColorPicker: Function,
        showColorPicker: Boolean,
        onColorPicked: Function,
        icon: String,
        title: { type: String, optional: true },
        disabled: { type: Boolean, optional: true },
        dropdownMaxHeight: { type: Number, optional: true },
        class: { type: String, optional: true },
        disableNoColor: { type: Boolean, optional: true },
    };

    class LineBarPieDesignPanel extends owl.Component {
        static template = "o-spreadsheet-LineBarPieDesignPanel";
        static components = { ColorPickerWidget };
        state = owl.useState({
            title: "",
            fillColorTool: false,
        });
        onClick(ev) {
            this.state.fillColorTool = false;
        }
        setup() {
            this.state.title = _t(this.props.definition.title);
            owl.useExternalListener(window, "click", this.onClick);
        }
        toggleColorPicker() {
            this.state.fillColorTool = !this.state.fillColorTool;
        }
        updateBackgroundColor(color) {
            this.props.updateChart(this.props.figureId, {
                background: color,
            });
        }
        updateTitle() {
            this.props.updateChart(this.props.figureId, {
                title: this.state.title,
            });
        }
        updateSelect(attr, ev) {
            this.props.updateChart(this.props.figureId, {
                [attr]: ev.target.value,
            });
        }
    }
    LineBarPieDesignPanel.props = {
        figureId: String,
        definition: Object,
        updateChart: Function,
        canUpdateChart: Function,
    };

    class BarChartDesignPanel extends LineBarPieDesignPanel {
        static template = "o-spreadsheet-BarChartDesignPanel";
    }

    class GaugeChartConfigPanel extends owl.Component {
        static template = "o-spreadsheet-GaugeChartConfigPanel";
        static components = { SelectionInput, ValidationMessages };
        state = owl.useState({
            dataRangeDispatchResult: undefined,
        });
        dataRange = this.props.definition.dataRange;
        get configurationErrorMessages() {
            const cancelledReasons = [...(this.state.dataRangeDispatchResult?.reasons || [])];
            return cancelledReasons.map((error) => ChartTerms.Errors[error] || ChartTerms.Errors.Unexpected);
        }
        get isDataRangeInvalid() {
            return !!this.state.dataRangeDispatchResult?.isCancelledBecause("InvalidGaugeDataRange" /* CommandResult.InvalidGaugeDataRange */);
        }
        onDataRangeChanged(ranges) {
            this.dataRange = ranges[0];
            this.state.dataRangeDispatchResult = this.props.canUpdateChart(this.props.figureId, {
                dataRange: this.dataRange,
            });
        }
        updateDataRange() {
            this.state.dataRangeDispatchResult = this.props.updateChart(this.props.figureId, {
                dataRange: this.dataRange,
            });
        }
        getDataRange() {
            return this.dataRange || "";
        }
    }
    GaugeChartConfigPanel.props = {
        figureId: String,
        definition: Object,
        updateChart: Function,
        canUpdateChart: Function,
    };

    css /* scss */ `
  .o-gauge-color-set {
    table {
      table-layout: fixed;
      margin-top: 2%;
      display: table;
      text-align: left;
      font-size: 12px;
      line-height: 18px;
      width: 100%;
    }
    th.o-gauge-color-set-colorPicker {
      width: 8%;
    }
    th.o-gauge-color-set-text {
      width: 40%;
    }
    th.o-gauge-color-set-value {
      width: 22%;
    }
    th.o-gauge-color-set-type {
      width: 30%;
    }
    input,
    select {
      width: 100%;
      height: 100%;
      box-sizing: border-box;
    }
  }
`;
    class GaugeChartDesignPanel extends owl.Component {
        static template = "o-spreadsheet-GaugeChartDesignPanel";
        static components = { ColorPickerWidget, ValidationMessages };
        state = owl.useState({
            title: "",
            openedMenu: undefined,
            sectionRuleDispatchResult: undefined,
            sectionRule: deepCopy(this.props.definition.sectionRule),
        });
        setup() {
            this.state.title = _t(this.props.definition.title);
            owl.useExternalListener(window, "click", this.closeMenus);
        }
        get designErrorMessages() {
            const cancelledReasons = [...(this.state.sectionRuleDispatchResult?.reasons || [])];
            return cancelledReasons.map((error) => ChartTerms.Errors[error] || ChartTerms.Errors.Unexpected);
        }
        updateBackgroundColor(color) {
            this.state.openedMenu = undefined;
            this.props.updateChart(this.props.figureId, {
                background: color,
            });
        }
        updateTitle() {
            this.props.updateChart(this.props.figureId, {
                title: this.state.title,
            });
        }
        isRangeMinInvalid() {
            return !!(this.state.sectionRuleDispatchResult?.isCancelledBecause("EmptyGaugeRangeMin" /* CommandResult.EmptyGaugeRangeMin */) ||
                this.state.sectionRuleDispatchResult?.isCancelledBecause("GaugeRangeMinNaN" /* CommandResult.GaugeRangeMinNaN */) ||
                this.state.sectionRuleDispatchResult?.isCancelledBecause("GaugeRangeMinBiggerThanRangeMax" /* CommandResult.GaugeRangeMinBiggerThanRangeMax */));
        }
        isRangeMaxInvalid() {
            return !!(this.state.sectionRuleDispatchResult?.isCancelledBecause("EmptyGaugeRangeMax" /* CommandResult.EmptyGaugeRangeMax */) ||
                this.state.sectionRuleDispatchResult?.isCancelledBecause("GaugeRangeMaxNaN" /* CommandResult.GaugeRangeMaxNaN */) ||
                this.state.sectionRuleDispatchResult?.isCancelledBecause("GaugeRangeMinBiggerThanRangeMax" /* CommandResult.GaugeRangeMinBiggerThanRangeMax */));
        }
        // ---------------------------------------------------------------------------
        // COLOR_SECTION_TEMPLATE
        // ---------------------------------------------------------------------------
        get isLowerInflectionPointInvalid() {
            return !!(this.state.sectionRuleDispatchResult?.isCancelledBecause("GaugeLowerInflectionPointNaN" /* CommandResult.GaugeLowerInflectionPointNaN */) ||
                this.state.sectionRuleDispatchResult?.isCancelledBecause("GaugeLowerBiggerThanUpper" /* CommandResult.GaugeLowerBiggerThanUpper */));
        }
        get isUpperInflectionPointInvalid() {
            return !!(this.state.sectionRuleDispatchResult?.isCancelledBecause("GaugeUpperInflectionPointNaN" /* CommandResult.GaugeUpperInflectionPointNaN */) ||
                this.state.sectionRuleDispatchResult?.isCancelledBecause("GaugeLowerBiggerThanUpper" /* CommandResult.GaugeLowerBiggerThanUpper */));
        }
        updateSectionColor(target, color) {
            const sectionRule = deepCopy(this.state.sectionRule);
            sectionRule.colors[target] = color;
            this.updateSectionRule(sectionRule);
            this.closeMenus();
        }
        toggleMenu(menu) {
            const isSelected = this.state.openedMenu === menu;
            this.closeMenus();
            if (!isSelected) {
                this.state.openedMenu = menu;
            }
        }
        updateSectionRule(sectionRule) {
            this.state.sectionRuleDispatchResult = this.props.updateChart(this.props.figureId, {
                sectionRule,
            });
        }
        canUpdateSectionRule(sectionRule) {
            this.state.sectionRuleDispatchResult = this.props.canUpdateChart(this.props.figureId, {
                sectionRule,
            });
        }
        closeMenus() {
            this.state.openedMenu = undefined;
        }
    }
    GaugeChartDesignPanel.props = {
        figureId: String,
        definition: Object,
        updateChart: Function,
        canUpdateChart: Function,
    };

    class LineConfigPanel extends LineBarPieConfigPanel {
        static template = "o-spreadsheet-LineConfigPanel";
        get canTreatLabelsAsText() {
            const chart = this.env.model.getters.getChart(this.props.figureId);
            if (chart && chart instanceof LineChart) {
                return canChartParseLabels(chart, this.env.model.getters);
            }
            return false;
        }
        onUpdateLabelsAsText(ev) {
            this.props.updateChart(this.props.figureId, {
                labelsAsText: ev.target.checked,
            });
        }
        onUpdateStacked(ev) {
            this.props.updateChart(this.props.figureId, {
                stacked: ev.target.checked,
            });
        }
        onUpdateAggregated(ev) {
            this.props.updateChart(this.props.figureId, {
                aggregated: ev.target.checked,
            });
        }
        onUpdateCumulative(ev) {
            this.props.updateChart(this.props.figureId, {
                cumulative: ev.target.checked,
            });
        }
    }

    class LineChartDesignPanel extends LineBarPieDesignPanel {
        static template = "o-spreadsheet-LineChartDesignPanel";
    }

    class ScorecardChartConfigPanel extends owl.Component {
        static template = "o-spreadsheet-ScorecardChartConfigPanel";
        static components = { SelectionInput, ValidationMessages };
        state = owl.useState({
            keyValueDispatchResult: undefined,
            baselineDispatchResult: undefined,
        });
        keyValue = this.props.definition.keyValue;
        baseline = this.props.definition.baseline;
        get errorMessages() {
            const cancelledReasons = [
                ...(this.state.keyValueDispatchResult?.reasons || []),
                ...(this.state.baselineDispatchResult?.reasons || []),
            ];
            return cancelledReasons.map((error) => ChartTerms.Errors[error] || ChartTerms.Errors.Unexpected);
        }
        get isKeyValueInvalid() {
            return !!this.state.keyValueDispatchResult?.isCancelledBecause("InvalidScorecardKeyValue" /* CommandResult.InvalidScorecardKeyValue */);
        }
        get isBaselineInvalid() {
            return !!this.state.keyValueDispatchResult?.isCancelledBecause("InvalidScorecardBaseline" /* CommandResult.InvalidScorecardBaseline */);
        }
        onKeyValueRangeChanged(ranges) {
            this.keyValue = ranges[0];
            this.state.keyValueDispatchResult = this.props.canUpdateChart(this.props.figureId, {
                keyValue: this.keyValue,
            });
        }
        updateKeyValueRange() {
            this.state.keyValueDispatchResult = this.props.updateChart(this.props.figureId, {
                keyValue: this.keyValue,
            });
        }
        getKeyValueRange() {
            return this.keyValue || "";
        }
        onBaselineRangeChanged(ranges) {
            this.baseline = ranges[0];
            this.state.baselineDispatchResult = this.props.canUpdateChart(this.props.figureId, {
                baseline: this.baseline,
            });
        }
        updateBaselineRange() {
            this.state.baselineDispatchResult = this.props.updateChart(this.props.figureId, {
                baseline: this.baseline,
            });
        }
        getBaselineRange() {
            return this.baseline || "";
        }
        updateBaselineMode(ev) {
            this.props.updateChart(this.props.figureId, { baselineMode: ev.target.value });
        }
    }
    ScorecardChartConfigPanel.props = {
        figureId: String,
        definition: Object,
        updateChart: Function,
        canUpdateChart: Function,
    };

    class ScorecardChartDesignPanel extends owl.Component {
        static template = "o-spreadsheet-ScorecardChartDesignPanel";
        static components = { ColorPickerWidget };
        state = owl.useState({
            title: "",
            openedColorPicker: undefined,
        });
        setup() {
            this.state.title = _t(this.props.definition.title);
            owl.useExternalListener(window, "click", this.closeMenus);
        }
        updateTitle() {
            this.props.updateChart(this.props.figureId, {
                title: this.state.title,
            });
        }
        translate(term) {
            return _t(term);
        }
        updateBaselineDescr(ev) {
            this.props.updateChart(this.props.figureId, { baselineDescr: ev.target.value });
        }
        toggleColorPicker(colorPickerId) {
            if (this.state.openedColorPicker === colorPickerId) {
                this.state.openedColorPicker = undefined;
            }
            else {
                this.state.openedColorPicker = colorPickerId;
            }
        }
        setColor(color, colorPickerId) {
            switch (colorPickerId) {
                case "backgroundColor":
                    this.props.updateChart(this.props.figureId, { background: color });
                    break;
                case "baselineColorDown":
                    this.props.updateChart(this.props.figureId, { baselineColorDown: color });
                    break;
                case "baselineColorUp":
                    this.props.updateChart(this.props.figureId, { baselineColorUp: color });
                    break;
            }
            this.closeMenus();
        }
        closeMenus() {
            this.state.openedColorPicker = undefined;
        }
    }
    ScorecardChartDesignPanel.props = {
        figureId: String,
        definition: Object,
        updateChart: Function,
        canUpdateChart: Function,
    };

    const chartSidePanelComponentRegistry = new Registry();
    chartSidePanelComponentRegistry
        .add("line", {
        configuration: LineConfigPanel,
        design: LineChartDesignPanel,
    })
        .add("bar", {
        configuration: BarConfigPanel,
        design: BarChartDesignPanel,
    })
        .add("pie", {
        configuration: LineBarPieConfigPanel,
        design: LineBarPieDesignPanel,
    })
        .add("gauge", {
        configuration: GaugeChartConfigPanel,
        design: GaugeChartDesignPanel,
    })
        .add("scorecard", {
        configuration: ScorecardChartConfigPanel,
        design: ScorecardChartDesignPanel,
    });

    css /* scss */ `
  .o-chart {
    .o-panel {
      display: flex;
      .o-panel-element {
        flex: 1 0 auto;
        padding: 8px 0px;
        text-align: center;
        cursor: pointer;
        border-right: 1px solid darkgray;
        &.inactive {
          background-color: ${BACKGROUND_HEADER_COLOR};
          border-bottom: 1px solid darkgray;
        }
        .fa {
          margin-right: 4px;
        }
      }
      .o-panel-element:last-child {
        border-right: none;
      }
    }
  }
`;
    class ChartPanel extends owl.Component {
        static template = "o-spreadsheet-ChartPanel";
        state;
        get figureId() {
            return this.state.figureId;
        }
        setup() {
            const selectedFigureId = this.env.model.getters.getSelectedFigureId();
            if (!selectedFigureId) {
                this.props.onCloseSidePanel();
                return;
            }
            this.state = owl.useState({
                panel: "configuration",
                figureId: selectedFigureId,
            });
            owl.onWillUpdateProps(() => {
                const selectedFigureId = this.env.model.getters.getSelectedFigureId();
                if (selectedFigureId && selectedFigureId !== this.state.figureId) {
                    this.state.figureId = selectedFigureId;
                }
                if (!this.env.model.getters.isChartDefined(this.figureId)) {
                    this.props.onCloseSidePanel();
                    return;
                }
            });
        }
        updateChart(figureId, updateDefinition) {
            if (figureId !== this.figureId) {
                return;
            }
            const definition = {
                ...this.getChartDefinition(),
                ...updateDefinition,
            };
            return this.env.model.dispatch("UPDATE_CHART", {
                definition,
                id: figureId,
                sheetId: this.env.model.getters.getFigureSheetId(figureId),
            });
        }
        canUpdateChart(figureId, updateDefinition) {
            if (figureId !== this.figureId || !this.env.model.getters.isChartDefined(figureId)) {
                return;
            }
            const definition = {
                ...this.getChartDefinition(),
                ...updateDefinition,
            };
            return this.env.model.canDispatch("UPDATE_CHART", {
                definition,
                id: figureId,
                sheetId: this.env.model.getters.getFigureSheetId(figureId),
            });
        }
        onTypeChange(type) {
            const context = this.env.model.getters.getContextCreationChart(this.figureId);
            if (!context) {
                throw new Error("Chart not defined.");
            }
            const definition = getChartDefinitionFromContextCreation(context, type);
            this.env.model.dispatch("UPDATE_CHART", {
                definition,
                id: this.figureId,
                sheetId: this.env.model.getters.getFigureSheetId(this.figureId),
            });
        }
        get chartPanel() {
            const type = this.env.model.getters.getChartType(this.figureId);
            if (!type) {
                throw new Error("Chart not defined.");
            }
            const chartPanel = chartSidePanelComponentRegistry.get(type);
            if (!chartPanel) {
                throw new Error(`Component is not defined for type ${type}`);
            }
            return chartPanel;
        }
        getChartDefinition(figureId = this.figureId) {
            return this.env.model.getters.getChartDefinition(figureId);
        }
        get chartTypes() {
            return getChartTypes();
        }
        activatePanel(panel) {
            this.state.panel = panel;
        }
    }
    ChartPanel.props = {
        onCloseSidePanel: Function,
    };

    css /* scss */ `
  .o-spreadsheet {
    .o-icon {
      .small-text {
        font: bold 9px sans-serif;
      }
      .heavy-text {
        font: bold 16px sans-serif;
      }
    }
  }
`;
    // -----------------------------------------------------------------------------
    // We need here the svg of the icons that we need to convert to images for the renderer
    // -----------------------------------------------------------------------------
    const ARROW_DOWN = '<svg class="o-cf-icon arrow-down" width="10" height="10" focusable="false" viewBox="0 0 448 512"><path fill="#DC6965" d="M413.1 222.5l22.2 22.2c9.4 9.4 9.4 24.6 0 33.9L241 473c-9.4 9.4-24.6 9.4-33.9 0L12.7 278.6c-9.4-9.4-9.4-24.6 0-33.9l22.2-22.2c9.5-9.5 25-9.3 34.3.4L184 343.4V56c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v287.4l114.8-120.5c9.3-9.8 24.8-10 34.3-.4z"></path></svg>';
    const ARROW_UP = '<svg class="o-cf-icon arrow-up" width="10" height="10" focusable="false" viewBox="0 0 448 512"><path fill="#00A04A" d="M34.9 289.5l-22.2-22.2c-9.4-9.4-9.4-24.6 0-33.9L207 39c9.4-9.4 24.6-9.4 33.9 0l194.3 194.3c9.4 9.4 9.4 24.6 0 33.9L413 289.4c-9.5 9.5-25 9.3-34.3-.4L264 168.6V456c0 13.3-10.7 24-24 24h-32c-13.3 0-24-10.7-24-24V168.6L69.2 289.1c-9.3 9.8-24.8 10-34.3.4z"></path></svg>';
    const ARROW_RIGHT = '<svg class="o-cf-icon arrow-right" width="10" height="10" focusable="false" viewBox="0 0 448 512"><path fill="#F0AD4E" d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path></svg>';
    const SMILE = '<svg class="o-cf-icon smile" width="10" height="10" focusable="false" viewBox="0 0 496 512"><path fill="#00A04A" d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-80-216c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm4 72.6c-20.8 25-51.5 39.4-84 39.4s-63.2-14.3-84-39.4c-8.5-10.2-23.7-11.5-33.8-3.1-10.2 8.5-11.5 23.6-3.1 33.8 30 36 74.1 56.6 120.9 56.6s90.9-20.6 120.9-56.6c8.5-10.2 7.1-25.3-3.1-33.8-10.1-8.4-25.3-7.1-33.8 3.1z"></path></svg>';
    const MEH = '<svg class="o-cf-icon meh" width="10" height="10" focusable="false" viewBox="0 0 496 512"><path fill="#F0AD4E" d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-80-216c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160-64c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm8 144H160c-13.2 0-24 10.8-24 24s10.8 24 24 24h176c13.2 0 24-10.8 24-24s-10.8-24-24-24z"></path></svg>';
    const FROWN = '<svg class="o-cf-icon frown" width="10" height="10" focusable="false" viewBox="0 0 496 512"><path fill="#DC6965" d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-80-216c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160-64c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-80 128c-40.2 0-78 17.7-103.8 48.6-8.5 10.2-7.1 25.3 3.1 33.8 10.2 8.4 25.3 7.1 33.8-3.1 16.6-19.9 41-31.4 66.9-31.4s50.3 11.4 66.9 31.4c8.1 9.7 23.1 11.9 33.8 3.1 10.2-8.5 11.5-23.6 3.1-33.8C326 321.7 288.2 304 248 304z"></path></svg>';
    const GREEN_DOT = '<svg class="o-cf-icon green-dot" width="10" height="10" focusable="false" viewBox="0 0 512 512"><path fill="#00A04A" d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8z"></path></svg>';
    const YELLOW_DOT = '<svg class="o-cf-icon yellow-dot" width="10" height="10" focusable="false" viewBox="0 0 512 512"><path fill="#F0AD4E" d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8z"></path></svg>';
    const RED_DOT = '<svg class="o-cf-icon red-dot" width="10" height="10" focusable="false" viewBox="0 0 512 512"><path fill="#DC6965" d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8z"></path></svg>';
    function loadIconImage(svg) {
        /** We have to add xmlns, as it's not added by owl in the canvas */
        svg = `<svg xmlns="http://www.w3.org/2000/svg" ${svg.slice(4)}`;
        const image = new Image();
        image.src = "data:image/svg+xml; charset=utf8, " + encodeURIComponent(svg);
        return image;
    }
    const ICONS = {
        arrowGood: {
            template: "ARROW_UP",
            img: loadIconImage(ARROW_UP),
        },
        arrowNeutral: {
            template: "ARROW_RIGHT",
            img: loadIconImage(ARROW_RIGHT),
        },
        arrowBad: {
            template: "ARROW_DOWN",
            img: loadIconImage(ARROW_DOWN),
        },
        smileyGood: {
            template: "SMILE",
            img: loadIconImage(SMILE),
        },
        smileyNeutral: {
            template: "MEH",
            img: loadIconImage(MEH),
        },
        smileyBad: {
            template: "FROWN",
            img: loadIconImage(FROWN),
        },
        dotGood: {
            template: "GREEN_DOT",
            img: loadIconImage(GREEN_DOT),
        },
        dotNeutral: {
            template: "YELLOW_DOT",
            img: loadIconImage(YELLOW_DOT),
        },
        dotBad: {
            template: "RED_DOT",
            img: loadIconImage(RED_DOT),
        },
    };
    const ICON_SETS = {
        arrows: {
            good: "arrowGood",
            neutral: "arrowNeutral",
            bad: "arrowBad",
        },
        smiley: {
            good: "smileyGood",
            neutral: "smileyNeutral",
            bad: "smileyBad",
        },
        dots: {
            good: "dotGood",
            neutral: "dotNeutral",
            bad: "dotBad",
        },
    };

    css /* scss */ `
  .o-icon-picker {
    position: absolute;
    z-index: ${ComponentsImportance.IconPicker};
    box-shadow: 1px 2px 5px 2px rgba(51, 51, 51, 0.15);
    background-color: white;
    padding: 2px 1px;
  }
  .o-cf-icon-line {
    display: flex;
    padding: 3px 6px;
  }
  .o-icon-picker-item {
    margin: 0px 2px;
    &:hover {
      background-color: rgba(0, 0, 0, 0.08);
      outline: 1px solid gray;
    }
  }
`;
    class IconPicker extends owl.Component {
        static template = "o-spreadsheet-IconPicker";
        icons = ICONS;
        iconSets = ICON_SETS;
        onIconClick(icon) {
            if (icon) {
                this.props.onIconPicked(icon);
            }
        }
    }
    IconPicker.props = {
        onIconPicked: Function,
    };

    function useDragAndDropListItems() {
        let dndHelper;
        const previousCursor = document.body.style.cursor;
        let cleanupFns = [];
        const cleanUp = () => {
            dndHelper = undefined;
            document.body.style.cursor = previousCursor;
            cleanupFns.forEach((fn) => fn());
            cleanupFns = [];
        };
        const start = (direction, args) => {
            const onCha