import { models } from "@web/../tests/web_test_helpers";

export class ProductProduct extends models.ServerModel {
    _name = "product.product";

    // NOTE - We don't take into account _eval_taxes_computation_prepare_product_fields
    _load_pos_data_fields() {
        return [
            "id",
            "lst_price",
            "display_name",
            "product_tmpl_id",
            "product_template_variant_value_ids",
            "product_template_attribute_value_ids",
            "barcode",
            "product_tag_ids",
            "default_code",
            "standard_price",
            "pos_categ_ids",
        ];
    }

    _records = [
        {
            id: 1,
            product_tmpl_id: 1,
            lst_price: 1,
            standard_price: 0,
            display_name: "TIP",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [1],
        },
        {
            id: 5,
            product_tmpl_id: 5,
            lst_price: 100,
            standard_price: 0,
            display_name: "TEST",
            product_tag_ids: [],
            barcode: "test_test",
            pos_categ_ids: [1],
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
        },
        {
            id: 6,
            product_tmpl_id: 6,
            lst_price: 100,
            standard_price: 0,
            display_name: "TEST 2",
            product_tag_ids: [],
            pos_categ_ids: [2],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
        },
        {
            id: 7,
            product_tmpl_id: 7,
            lst_price: 750,
            standard_price: 0,
            display_name: "Office combo",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [],
        },
        {
            id: 8,
            product_tmpl_id: 8,
            lst_price: 300,
            standard_price: 0,
            display_name: "Wood chair",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [],
        },
        {
            id: 9,
            product_tmpl_id: 9,
            lst_price: 450,
            standard_price: 0,
            display_name: "Steel chair",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [],
        },
        {
            id: 10,
            product_tmpl_id: 10,
            lst_price: 600,
            standard_price: 0,
            display_name: "Wood chair",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [],
        },
        {
            id: 11,
            product_tmpl_id: 11,
            lst_price: 700,
            standard_price: 0,
            display_name: "Steel desk",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [],
        },
        {
            id: 12,
            product_tmpl_id: 12,
            lst_price: 14,
            standard_price: 0,
            display_name: "Bacon burger",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [4],
        },
        {
            id: 13,
            product_tmpl_id: 13,
            lst_price: 12,
            standard_price: 0,
            display_name: "Pizza margarita",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [5],
        },
        {
            id: 14,
            product_tmpl_id: 14,
            lst_price: 3.4,
            standard_price: 0,
            display_name: "Club sandwich",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
            pos_categ_ids: [4],
        },
        {
            id: 15,
            product_tmpl_id: 15,
            lst_price: 1000,
            standard_price: 0,
            display_name: "Accounting Test Product 1",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
        },
        {
            id: 16,
            product_tmpl_id: 16,
            lst_price: 100,
            standard_price: 0,
            display_name: "Accounting Test Product 2",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
        },
        {
            id: 17,
            product_tmpl_id: 17,
            lst_price: 100,
            standard_price: 0,
            display_name: "Multi Category Product",
            product_tag_ids: [],
            barcode: false,
            default_code: false,
            product_template_attribute_value_ids: [],
            product_template_variant_value_ids: [],
        },
    ];
}
