import { startInteractions, setupInteractionWhiteList } from "@web/../tests/public/helpers";

import { describe, expect, getFixture, test } from "@odoo/hoot";
import { animationFrame, click, leave, press, queryOne } from "@odoo/hoot-dom";
import { advanceTime } from "@odoo/hoot-mock";

import { onceAllImagesLoaded } from "@website/utils/images";

setupInteractionWhiteList([
    "website.gallery_slider",
    "website.gallery_slider_001",
    "website.gallery",
    "website.base_lightbox",
]);

describe.current.tags("interaction_dev");

const SLIDE_DURATION = 1000;

// TODO Obtain rendering from `website.s_images_gallery` template ?
function getDefaultGallery(bsRide = false, bsInterval = 0, showPopup = false) {
    return `
        <div id="wrapwrap">
            <section class="s_image_gallery o_slideshow pt24 pb24 s_image_gallery_controllers_outside s_image_gallery_controllers_outside_arrows_right s_image_gallery_indicators_dots s_image_gallery_arrows_default ${
                showPopup ? " o_image_popup" : ""
            }" data-vcss="002" data-columns="3">
                <div class="o_container_small overflow-hidden">
                    <div id="slideshow_sample" class="carousel carousel-dark slide" data-bs-ride="${bsRide}" data-bs-interval="${bsInterval}">
                        <div class="carousel-inner">
                            <div class="carousel-item active">
                                <img class="img img-fluid d-block mh-100 mw-100 mx-auto rounded object-fit-cover" src="/web/image/website.library_image_08" data-name="Image" data-index="0" alt=""/>
                            </div>
                            <div class="carousel-item">
                                <img class="img img-fluid d-block mh-100 mw-100 mx-auto rounded object-fit-cover" src="/web/image/website.library_image_03" data-name="Image" data-index="1" alt=""/>
                            </div>
                            <div class="carousel-item">
                                <img class="img img-fluid d-block mh-100 mw-100 mx-auto rounded object-fit-cover" src="/web/image/website.library_image_02" data-name="Image" data-index="2" alt=""/>
                            </div>
                        </div>
                        <div class="o_carousel_controllers">
                            <button class="carousel-control-prev o_not_editable" contenteditable="false" data-bs-target="#slideshow_sample" data-bs-slide="prev" aria-label="Previous" title="Previous">
                                <span class="carousel-control-prev-icon" aria-hidden="true"/>
                                <span class="visually-hidden">Previous</span>
                            </button>
                            <div class="carousel-indicators">
                                <button type="button" data-bs-target="#slideshow_sample" data-bs-slide-to="0" style="background-image: url(/web/image/website.library_image_08)" class="active" aria-label="Carousel indicator"/>
                                <button type="button" style="background-image: url(/web/image/website.library_image_03)" data-bs-target="#slideshow_sample" data-bs-slide-to="1" aria-label="Carousel indicator"/>
                                <button type="button" style="background-image: url(/web/image/website.library_image_02)" data-bs-target="#slideshow_sample" data-bs-slide-to="2" aria-label="Carousel indicator"/>
                            </div>
                            <button class="carousel-control-next o_not_editable" contenteditable="false" data-bs-target="#slideshow_sample" data-bs-slide="next" aria-label="Next" title="Next">
                                <span class="carousel-control-next-icon" aria-hidden="true"/>
                                <span class="visually-hidden">Next</span>
                            </button>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    `;
}

// TODO Obtain rendering from `website.gallery.s_image_gallery_mirror.lightbox` template ?
const defaultLightbox = `
    <main class="modal-body o_slideshow bg-transparent">
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="position: absolute; right: 10px; top: 10px;">
        </button>
        <div style="margin: 0 12px;" id="slideshow_3" class="carousel slide undefined" data-bs-ride="false" data-bs-interval="0">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_03" alt="">
                </div>
                <div class="carousel-item undefined">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_10" alt="">
                </div>
                <div class="carousel-item undefined">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_13" alt="">
                </div>
                <div class="carousel-item undefined">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_05" alt="">
                </div>
                <div class="carousel-item undefined">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_14" alt="">
                </div>
                <div class="carousel-item undefined">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_16" alt="">
                </div>
            </div>
            <div class="o_carousel_controllers">
                <button class="carousel-control-prev o_we_no_overlay o_not_editable" contenteditable="false" data-bs-slide="prev" aria-label="Previous" title="Previous" data-bs-target="#slideshow_3">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <div class="carousel-indicators s_image_gallery_indicators_bars">
                    <button type="button" aria-label="Carousel indicator" data-bs-target="#slideshow_3" data-bs-slide-to="0" class="active" style="background-image: url(/web/image/website.library_image_03)"></button>
                    <button type="button" aria-label="Carousel indicator" data-bs-target="#slideshow_3" data-bs-slide-to="1" style="background-image: url(/web/image/website.library_image_10)"></button>
                    <button type="button" aria-label="Carousel indicator" data-bs-target="#slideshow_3" data-bs-slide-to="2" style="background-image: url(/web/image/website.library_image_13)"></button>
                    <button type="button" aria-label="Carousel indicator" data-bs-target="#slideshow_3" data-bs-slide-to="3" style="background-image: url(/web/image/website.library_image_05)"></button>
                    <button type="button" aria-label="Carousel indicator" data-bs-target="#slideshow_3" data-bs-slide-to="4" style="background-image: url(/web/image/website.library_image_14)"></button>
                    <button type="button" aria-label="Carousel indicator" data-bs-target="#slideshow_3" data-bs-slide-to="5" style="background-image: url(/web/image/website.library_image_16)"></button>
                </div>
                <button class="carousel-control-next o_we_no_overlay o_not_editable" contenteditable="false" data-bs-slide="next" aria-label="Next" title="Next" data-bs-target="#slideshow_3">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>
    </main>
`;

// TODO Obtain rendering from `website.gallery.slideshow` template.
const defaultOldLightbox = `
    <main class="modal-body o_slideshow bg-transparent">
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="position: absolute; right: 10px; top: 10px;">
        </button>
        <div class="carousel slide" style="margin: 0 12px;" id="slideshow_3" data-bs-ride="false" data-bs-interval="0">
            <div class="carousel-inner" style="padding: 0;">
                <div class="carousel-item active">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_03" alt="">
                </div>
                <div class="carousel-item">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_10" alt="">
                </div>
                <div class="carousel-item">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_13" alt="">
                </div>
                <div class="carousel-item">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_05" alt="">
                </div>
                <div class="carousel-item">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_14" alt="">
                </div>
                <div class="carousel-item undefined">
                    <img class="img img-fluid d-block" data-name="Image" src="/web/image/website.library_image_16" alt="">
                </div>
            </div>
            <ul class="carousel-indicators">
                <li class="o_indicators_left text-center d-none" aria-label="Previous" title="Previous">
                    <i class="oi oi-chevron-left"></i>
                </li>
                <li data-bs-target="#slideshow_3" data-bs-slide-to="0" class="" style="background-image: url(/web/image/website.library_image_03)"></li>
                <li data-bs-target="#slideshow_3" data-bs-slide-to="1" style="background-image: url(/web/image/website.library_image_10)" class=""></li>
                <li data-bs-target="#slideshow_3" data-bs-slide-to="2" style="background-image: url(/web/image/website.library_image_13)" class=""></li>
                <li data-bs-target="#slideshow_3" data-bs-slide-to="3" style="background-image: url(/web/image/website.library_image_05)" class="active" aria-current="true"></li><li data-bs-target="#slideshow_3" data-bs-slide-to="4" style="background-image: url(/web/image/website.library_image_14)"></li>
                <li data-bs-target="#slideshow_3" data-bs-slide-to="5" style="background-image: url(/web/image/website.library_image_16)" class=""></li>
                <li class="o_indicators_right text-center d-none" aria-label="Next" title="Next">
                    <i class="oi oi-chevron-right"></i>
                </li>
            </ul>
        </div>
    </main>
`;

test("gallery_slider does nothing if there is no o_slideshow s_image_gallery", async () => {
    const { core } = await startInteractions(`
        <div id="wrapwrap">
            <section class="s_image_gallery"/>
        </div>
    `);
    expect(core.interactions).toHaveLength(0);
});

test("gallery_slider interaction on image gallery", async () => {
    const { core } = await startInteractions(getDefaultGallery());
    expect(core.interactions).toHaveLength(1);
    await animationFrame();
    await onceAllImagesLoaded(getFixture());
    await advanceTime(SLIDE_DURATION);
    const imgEl = queryOne(".carousel-item.active img");
    await click("button[data-bs-slide-to]:eq(2)");
    await animationFrame();
    await onceAllImagesLoaded(getFixture());
    await advanceTime(SLIDE_DURATION);
    const img2El = queryOne(".carousel-item.active img");
    expect(imgEl).not.toBe(img2El);
});

test("gallery_slider interaction on lightbox", async () => {
    const { core } = await startInteractions(defaultLightbox);
    expect(core.interactions).toHaveLength(1);
    await onceAllImagesLoaded(getFixture());
    await advanceTime(SLIDE_DURATION);
    const imgEl = queryOne(".carousel-item.active img");
    await click(".carousel-control-next");
    await animationFrame();
    await onceAllImagesLoaded(getFixture());
    await advanceTime(SLIDE_DURATION);
    const img2El = queryOne(".carousel-item.active img");
    expect(imgEl).not.toBe(img2El);
    await click("button[data-bs-slide-to]:eq(2)");
    await animationFrame();
    await onceAllImagesLoaded(getFixture());
    await advanceTime(SLIDE_DURATION);
    const img3El = queryOne(".carousel-item.active img");
    expect(imgEl).not.toBe(img3El);
    expect(img2El).not.toBe(img3El);
});

test("gallery_slider interaction on old lightbox", async () => {
    const { core } = await startInteractions(defaultOldLightbox);
    expect(core.interactions).toHaveLength(1);
    const interaction = core.interactions[0].interaction;
    await onceAllImagesLoaded(getFixture());
    await advanceTime(SLIDE_DURATION);
    // Fix parameters that are based on sizes.
    interaction.page = 0;
    interaction.nbPages = 1;
    interaction.realNbPerPage = 20;
    const imgEl = queryOne(".carousel-item.active img");
    await click("li[data-bs-slide-to]:eq(1)");
    await animationFrame();
    await onceAllImagesLoaded(getFixture());
    await advanceTime(SLIDE_DURATION);
    const img2El = queryOne(".carousel-item.active img");
    expect(imgEl).not.toBe(img2El);
    await click("li[data-bs-slide-to]:eq(2)");
    await animationFrame();
    await onceAllImagesLoaded(getFixture());
    await advanceTime(SLIDE_DURATION);
    const img3El = queryOne(".carousel-item.active img");
    expect(imgEl).not.toBe(img3El);
    expect(img2El).not.toBe(img3El);
});

test("carousel autoplay pauses while lightbox is open and resumes after closing", async () => {
    const { core } = await startInteractions(getDefaultGallery("carousel", 500, true));
    expect(core.interactions).toHaveLength(2);
    expect(".carousel .carousel-item:nth-child(1)").toHaveClass("active");
    expect(".carousel .carousel-item:nth-child(2)").not.toHaveClass("active");
    expect(".carousel .carousel-item:nth-child(3)").not.toHaveClass("active");
    await click(".carousel .carousel-item.active img");
    await animationFrame();
    expect(".o_image_lightbox").not.toBe(null);
    // Trigger a mouseleave event to simulate the carousel's autoplay behavior
    await leave(".carousel .carousel-item.active img");
    await advanceTime(1000);
    expect(".carousel .carousel-item:nth-child(1)").toHaveClass("active");
    expect(".carousel .carousel-item:nth-child(2)").not.toHaveClass("active");
    expect(".carousel .carousel-item:nth-child(3)").not.toHaveClass("active");
    await press("Escape");
    await animationFrame();
    await advanceTime(1000);
    expect(".carousel .carousel-item:nth-child(1)").not.toHaveClass("active");
    expect(".carousel .carousel-item:nth-child(2)").toHaveClass("active");
    expect(".carousel .carousel-item:nth-child(3)").not.toHaveClass("active");
});
