import { _t } from "@web/core/l10n/translation";

export const backgroundShapesDefinition = {
    basic: {
        label: _t("Basic"),
        subgroups: {
            connections: {
                label: _t("Connections"),
                shapes: {
                    "html_builder/Connections/01": { selectLabel: _t("Connections 01") },
                    "html_builder/Connections/02": { selectLabel: _t("Connections 02") },
                    "html_builder/Connections/03": { selectLabel: _t("Connections 03") },
                    "html_builder/Connections/04": { selectLabel: _t("Connections 04") },
                    "html_builder/Connections/05": { selectLabel: _t("Connections 05") },
                    "html_builder/Connections/06": { selectLabel: _t("Connections 06") },
                    "html_builder/Connections/07": { selectLabel: _t("Connections 07") },
                    "html_builder/Connections/08": { selectLabel: _t("Connections 08") },
                    "html_builder/Connections/09": { selectLabel: _t("Connections 09") },
                    "html_builder/Connections/10": { selectLabel: _t("Connections 10") },
                    "html_builder/Connections/11": { selectLabel: _t("Connections 11") },
                    "html_builder/Connections/12": { selectLabel: _t("Connections 12") },
                    "html_builder/Connections/13": { selectLabel: _t("Connections 13") },
                    "html_builder/Connections/14": { selectLabel: _t("Connections 14") },
                    "html_builder/Connections/15": { selectLabel: _t("Connections 15") },
                    "html_builder/Connections/16": { selectLabel: _t("Connections 16") },
                    "html_builder/Connections/17": { selectLabel: _t("Connections 17") },
                    "html_builder/Connections/18": { selectLabel: _t("Connections 18") },
                    "html_builder/Connections/19": { selectLabel: _t("Connections 19") },
                    "html_builder/Connections/20": { selectLabel: _t("Connections 20") },
                },
            },
            containers: {
                label: _t("Containers"),
                shapes: {
                    "html_builder/Containers/01": { selectLabel: _t("Container 01") },
                    "html_builder/Containers/02": { selectLabel: _t("Container 02") },
                    "html_builder/Containers/03": { selectLabel: _t("Container 03") },
                    "html_builder/Containers/04": { selectLabel: _t("Container 04") },
                    "html_builder/Containers/05": {
                        selectLabel: _t("Container 05"),
                        animated: true,
                    },
                    "html_builder/Containers/06": {
                        selectLabel: _t("Container 06"),
                        animated: true,
                    },
                },
            },
            bold: {
                label: _t("Bold"),
                shapes: {
                    "html_builder/Bold/16": { selectLabel: _t("Bold 01") },
                    "html_builder/Bold/21": { selectLabel: _t("Bold 02") },
                    "html_builder/Bold/17": { selectLabel: _t("Bold 03") },
                    "html_builder/Bold/22": { selectLabel: _t("Bold 04") },
                    "html_builder/Bold/13": { selectLabel: _t("Bold 05") },
                    "html_builder/Bold/14": { selectLabel: _t("Bold 06") },
                    "html_builder/Bold/15": { selectLabel: _t("Bold 07") },
                    "html_builder/Bold/01_001": { selectLabel: _t("Bold 08") },
                    "html_builder/Bold/18": { selectLabel: _t("Bold 09") },
                    "html_builder/Bold/19": { selectLabel: _t("Bold 10") },
                    "html_builder/Bold/23": { selectLabel: _t("Bold 11") },
                    "html_builder/Bold/20": { selectLabel: _t("Bold 12") },
                },
            },
            angular: {
                label: _t("Angular"),
                shapes: {
                    "html_builder/Angular/01": { selectLabel: _t("Angular 01") },
                    "html_builder/Angular/02": { selectLabel: _t("Angular 02") },
                    "html_builder/Angular/03": { selectLabel: _t("Angular 03") },
                    "html_builder/Angular/04": { selectLabel: _t("Angular 04") },
                    "html_builder/Angular/05": { selectLabel: _t("Angular 05") },
                    "html_builder/Angular/06": { selectLabel: _t("Angular 06") },
                    "html_builder/Angular/07": { selectLabel: _t("Angular 07") },
                    "html_builder/Angular/08": { selectLabel: _t("Angular 08") },
                    "html_builder/Angular/09": { selectLabel: _t("Angular 09") },
                    "html_builder/Floats/07": { selectLabel: _t("Angular 10"), animated: true },
                },
            },
            blobs: {
                label: _t("Blobs"),
                shapes: {
                    "html_builder/Blobs/02": { selectLabel: _t("Blob 01") },
                    "html_builder/Blobs/05_001": { selectLabel: _t("Blob 02") },
                    "html_builder/Blobs/03": { selectLabel: _t("Blob 03") },
                    "html_builder/Blobs/06_001": { selectLabel: _t("Blob 04") },
                    "html_builder/Blobs/14": { selectLabel: _t("Blob 05") },
                    "html_builder/Blobs/17": { selectLabel: _t("Blob 06") },
                    "html_builder/Blobs/15": { selectLabel: _t("Blob 07") },
                    "html_builder/Blobs/18": { selectLabel: _t("Blob 08") },
                    "html_builder/Blobs/01_001": { selectLabel: _t("Blob 09"), animated: true },
                    "html_builder/Blobs/16": { selectLabel: _t("Blob 10") },
                    "html_builder/Blobs/04_001": { selectLabel: _t("Blob 11") },
                    "html_builder/Blobs/10_002": { selectLabel: _t("Blob 12") },
                    "html_builder/Blobs/13": { selectLabel: _t("Blob 13") },
                    "html_builder/Floats/03": { selectLabel: _t("Blob 14"), animated: true },
                    "html_builder/Floats/04": { selectLabel: _t("Blob 15"), animated: true },
                    "html_builder/Floats/06": { selectLabel: _t("Blob 16"), animated: true },
                },
            },
        },
    },
    linear: {
        label: _t("Linear"),
        subgroups: {
            airy: {
                label: _t("Airy"),
                shapes: {
                    "html_builder/Airy/01_001": { selectLabel: _t("Airy 01") },
                    "html_builder/Airy/06_001": { selectLabel: _t("Airy 02") },
                    "html_builder/Airy/02_001": { selectLabel: _t("Airy 03") },
                    "html_builder/Airy/07_001": { selectLabel: _t("Airy 04") },
                    "html_builder/Airy/08_001": { selectLabel: _t("Airy 05") },
                    "html_builder/Airy/10_001": { selectLabel: _t("Airy 06") },
                    "html_builder/Airy/09_001": { selectLabel: _t("Airy 07") },
                    "html_builder/Airy/11_001": { selectLabel: _t("Airy 08") },
                    "html_builder/Airy/16": { selectLabel: _t("Airy 09") },
                    "html_builder/Airy/17": { selectLabel: _t("Airy 10") },
                    "html_builder/Airy/12_002": { selectLabel: _t("Airy 11"), animated: true },
                    "html_builder/Airy/13_002": { selectLabel: _t("Airy 12"), animated: true },
                    "html_builder/Airy/14_001": { selectLabel: _t("Airy 13") },
                    "html_builder/Airy/15": { selectLabel: _t("Airy 14"), animated: true },
                },
            },
            grids: {
                label: _t("Grids"),
                shapes: {
                    "html_builder/Grids/01": { selectLabel: _t("Grid 01") },
                    "html_builder/Grids/02": { selectLabel: _t("Grid 02") },
                    "html_builder/Grids/03": { selectLabel: _t("Grid 03") },
                    "html_builder/Grids/04": { selectLabel: _t("Grid 04") },
                    "html_builder/Grids/05": { selectLabel: _t("Grid 05") },
                    "html_builder/Grids/06": { selectLabel: _t("Grid 06") },
                    "html_builder/Grids/07": { selectLabel: _t("Grid 07") },
                    "html_builder/Grids/08": { selectLabel: _t("Grid 08") },
                },
            },
        },
    },
    creative: {
        label: _t("Creative"),
        subgroups: {
            patterns: {
                label: _t("Patterns"),
                shapes: {
                    "html_builder/Patterns/01": { selectLabel: _t("Pattern 01") },
                    "html_builder/Patterns/02": { selectLabel: _t("Pattern 02") },
                    "html_builder/Patterns/03": { selectLabel: _t("Pattern 03") },
                    "html_builder/Patterns/04": { selectLabel: _t("Pattern 04") },
                    "html_builder/Patterns/05": { selectLabel: _t("Pattern 05") },
                    "html_builder/Floats/12": { selectLabel: _t("Pattern 06"), animated: true },
                },
            },
            blurry: {
                label: _t("Blurry"),
                shapes: {
                    "html_builder/Blurry/01": { selectLabel: _t("Blurry 01") },
                    "html_builder/Blurry/02": { selectLabel: _t("Blurry 02") },
                    "html_builder/Blurry/03": { selectLabel: _t("Blurry 03") },
                    "html_builder/Blurry/04": { selectLabel: _t("Blurry 04") },
                    "html_builder/Blurry/05": { selectLabel: _t("Blurry 05") },
                    "html_builder/Blurry/06": { selectLabel: _t("Blurry 06") },
                },
            },

            wavy: {
                label: _t("Wavy"),
                shapes: {
                    "html_builder/Wavy/03": { selectLabel: _t("Wavy 01") },
                    "html_builder/Wavy/10": { selectLabel: _t("Wavy 02") },
                    "html_builder/Wavy/24": { selectLabel: _t("Wavy 03"), animated: true },
                    "html_builder/Wavy/26": { selectLabel: _t("Wavy 04"), animated: true },
                    "html_builder/Wavy/27": { selectLabel: _t("Wavy 05"), animated: true },
                    "html_builder/Wavy/04": { selectLabel: _t("Wavy 06") },
                    "html_builder/Wavy/11_001": { selectLabel: _t("Wavy 07") },
                    "html_builder/Wavy/18": { selectLabel: _t("Wavy 08") },
                    "html_builder/Wavy/08_001": { selectLabel: _t("Wavy 09") },
                    "html_builder/Wavy/09_001": { selectLabel: _t("Wavy 10") },
                    "html_builder/Wavy/22_001": { selectLabel: _t("Wavy 11") },
                    "html_builder/Wavy/29": { selectLabel: _t("Wavy 12") },
                    "html_builder/Wavy/30": { selectLabel: _t("Wavy 13") },
                    "html_builder/Wavy/31": { selectLabel: _t("Wavy 14") },
                },
            },
            blockAndRainy: {
                label: _t("Block & Rainy"),
                shapes: {
                    "html_builder/Blocks/02_001": { selectLabel: _t("Blocks 01") },
                    "html_builder/Rainy/01_001": { selectLabel: _t("Rainy 01"), animated: true },
                    "html_builder/Blocks/01_001": { selectLabel: _t("Blocks 02") },
                    "html_builder/Rainy/02_001": { selectLabel: _t("Rainy 02"), animated: true },
                    "html_builder/Rainy/06": { selectLabel: _t("Rainy 03") },
                    "html_builder/Blocks/04": { selectLabel: _t("Blocks 03") },
                    "html_builder/Rainy/07": { selectLabel: _t("Rainy 04") },
                    "html_builder/Rainy/10": { selectLabel: _t("Rainy 05"), animated: true },
                    "html_builder/Floats/10": { selectLabel: _t("Rainy 06"), animated: true },
                    "html_builder/Floats/11": { selectLabel: _t("Rainy 07"), animated: true },
                    "html_builder/Rainy/08_001": { selectLabel: _t("Rainy 08"), animated: true },
                    "html_builder/Rainy/09_001": { selectLabel: _t("Rainy 09") },
                },
            },
            miscellaneous: {
                label: _t("Miscellaneous"),
                shapes: {
                    "html_builder/Floats/01": {
                        selectLabel: _t("Miscellaneous 01"),
                        animated: true,
                    },
                    "html_builder/Floats/02": {
                        selectLabel: _t("Miscellaneous 02"),
                        animated: true,
                    },
                    "html_builder/Floats/05": {
                        selectLabel: _t("Miscellaneous 03"),
                        animated: true,
                    },
                    "html_builder/Floats/08": {
                        selectLabel: _t("Miscellaneous 04"),
                        animated: true,
                    },
                    "html_builder/Floats/09": {
                        selectLabel: _t("Miscellaneous 05"),
                        animated: true,
                    },
                    "html_builder/Floats/13": {
                        selectLabel: _t("Miscellaneous 06"),
                        animated: true,
                    },
                    "html_builder/Floats/14": {
                        selectLabel: _t("Miscellaneous 07"),
                        animated: true,
                    },
                    "html_builder/Zigs/01_001": {
                        selectLabel: _t("Miscellaneous 08"),
                        animated: true,
                    },
                },
            },
        },
    },
};
