import { models } from "@web/../tests/web_test_helpers";

export class ProductTemplate extends models.ServerModel {
    _name = "product.template";

    _load_pos_data_fields() {
        return [
            "id",
            "display_name",
            "standard_price",
            "categ_id",
            "pos_categ_ids",
            "taxes_id",
            "barcode",
            "name",
            "list_price",
            "is_favorite",
            "default_code",
            "to_weight",
            "uom_id",
            "description_sale",
            "description",
            "tracking",
            "type",
            "service_tracking",
            "is_storable",
            "write_date",
            "color",
            "pos_sequence",
            "available_in_pos",
            "attribute_line_ids",
            "active",
            "image_128",
            "combo_ids",
            "product_variant_ids",
            "public_description",
            "pos_optional_product_ids",
            "sequence",
            "product_tag_ids",
        ];
    }

    _records = [
        {
            id: 1,
            display_name: "TIP",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [],
            taxes_id: [],
            barcode: false,
            name: "TIP",
            list_price: 100,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            combo_ids: [],
            product_variant_ids: [1],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 5,
            display_name: "TEST",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [1],
            taxes_id: [1],
            barcode: false,
            name: "TEST",
            list_price: 100,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            combo_ids: [],
            product_variant_ids: [5],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 6,
            display_name: "TEST 2",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "TEST 2",
            list_price: 100,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            combo_ids: [],
            product_variant_ids: [6],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 7,
            display_name: "Product combo",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "Product combo",
            list_price: 100,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "combo",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            combo_ids: [1, 2],
            product_variant_ids: [7],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 8,
            display_name: "Wood chair",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "Wood chair",
            list_price: 300,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [8],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 9,
            display_name: "Steel chair",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "Steel chair",
            list_price: 450,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [9],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 10,
            display_name: "Wood desk",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "Wood desk",
            list_price: 600,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [10],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 11,
            display_name: "Steel desk",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "Steel desk",
            list_price: 700,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [11],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 12,
            display_name: "Bacon burger",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [4],
            taxes_id: [2],
            barcode: false,
            name: "Bacon burger",
            list_price: 14,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [12],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 13,
            display_name: "Pizza margarita",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [5],
            taxes_id: [2],
            barcode: false,
            name: "Pizza margarita",
            list_price: 12,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [13],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 14,
            display_name: "Club sandwich",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [3],
            taxes_id: [2],
            barcode: false,
            name: "Club sandwich",
            list_price: 3.4,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [14],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 15,
            display_name: "Accounting Test Product 1",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [],
            taxes_id: [2],
            barcode: false,
            name: "Accounting Test Product 1",
            list_price: 1000,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [15],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 16,
            display_name: "Accounting Test Product 2",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [],
            taxes_id: [1, 2],
            barcode: false,
            name: "Accounting Test Product 2",
            list_price: 100,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [16],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 17,
            display_name: "Product combo (no upsell)",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "Product combo (no upsell)",
            list_price: 750,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "combo",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            combo_ids: [3, 4],
            product_variant_ids: [17],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 18,
            display_name: "Product combo (all upsell)",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "Product combo (all upsell)",
            list_price: 750,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "combo",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            combo_ids: [5, 6],
            product_variant_ids: [18],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 19,
            display_name: "Multi Category Product",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [1, 2],
            taxes_id: [2],
            barcode: false,
            name: "Multi Category Product",
            list_price: 100,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            combo_ids: [],
            product_variant_ids: [19],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
        {
            id: 20,
            display_name: "Free Product - Wood chair",
            standard_price: 0,
            categ_id: false,
            pos_categ_ids: [2],
            taxes_id: [2],
            barcode: false,
            name: "Free Product - Wood chair",
            list_price: 0,
            is_favorite: false,
            default_code: false,
            to_weight: false,
            uom_id: 1,
            description_sale: false,
            description: false,
            tracking: "none",
            type: "consu",
            service_tracking: "no",
            is_storable: false,
            write_date: "2025-07-03 13:04:14",
            color: 0,
            pos_sequence: 5,
            available_in_pos: true,
            attribute_line_ids: [],
            active: true,
            image_128: false,
            product_variant_ids: [18],
            public_description: false,
            pos_optional_product_ids: [],
            sequence: 1,
            product_tag_ids: [],
        },
    ];
    get_product_info_pos() {
        return {
            all_prices: { tax_details: [] },
            pricelists: [],
            warehouses: [],
            suppliers: [],
            variants: [],
            optional_products: [],
        };
    }
}
